/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rw_he_memories 
#(
  parameter   g_mac_txfifo_awidth  = 8,
  parameter   g_mac_rxfifo_awidth  = 8,
  parameter   g_keystorage_awidth  = 2,
  parameter   g_keystorage_dwidth  = 186,
  parameter   g_mpif_txfifo_awidth = 8,
  parameter   g_mpif_rxfifo_awidth = 8,
  parameter   g_sharedram_awidth   = 13,
`ifdef  RW_HSU_RSA_EN
  parameter   g_rsa_sram_awidth    = 7,
  parameter   g_rsa_sram_dwidth    = 128,
`endif//RW_HSU_RSA_EN
`ifdef  RW_EMBEDDED_LA
  parameter   g_embedded_la_dwidth = 128,
`endif//RW_EMBEDDED_LA
  parameter   g_fftmem_awidth      = 6
)
(
  
  //$port_g Clocks
  input  wire                                 mac_core_tx_clk,
  input  wire                                 mac_core_rx_clk,
  input  wire                                 mac_pi_tx_clk,
  input  wire                                 mac_pi_rx_clk,
  input  wire                                 mac_wt_clk, 
  input  wire                                 mpif_clk,
  input  wire                                 mac_crypt_clk,
  input  wire                                 mac_core_clk,
  input  wire                                 plf_clk,

  input  wire                                 phy_clk,
  input  wire                                 agcmem_clk,
  input  wire                                 agc_clk,
`ifdef RW_BFMEE_EN
  input  wire                                 svd_clk,
`endif // RW_BFMEE_EN
`ifdef RW_NX_LDPC_ENC
  input  wire                                 ldpc0tx0_clk,
`endif // RW_NX_LDPC_ENC
`ifdef RW_NX_LDPC_DEC
  input  wire                                 ldpcrx0_clk,
`endif // RW_NX_LDPC_DEC

`ifdef  RW_EMBEDDED_LA
  input  wire                                 lamemwr_clk,
  input  wire                                 lamemrd_clk,

  //$port_g Embedded LA
  input  wire                                 lamem_wen  ,
  input  wire [15:0]                          lamem_waddr,
  input  wire [g_embedded_la_dwidth-1:0]      lamem_wdata,
  input  wire [15:0]                          lamem_raddr,
  output wire [g_embedded_la_dwidth-1:0]      lamem_rdata,
`endif//RW_EMBEDDED_LA

  //$port_g TxFIFO 64*38 Two Ports SRAM       
  input  wire                                 mac_txfifo_wen,    // Transmit FIFO Write Enable.
  input  wire [g_mac_txfifo_awidth-1:0]       mac_txfifo_waddr,  // Transmit FIFO Write Address bus.
  input  wire [37:0]                          mac_txfifo_wdata,  // Transmit FIFO Write Data bus.
  input  wire                                 mac_txfifo_ren,    // Transmit FIFO Read Enable.
  input  wire [g_mac_txfifo_awidth-1:0]       mac_txfifo_raddr,  // Transmit FIFO Read Address bus.
  output wire [37:0]                          mac_txfifo_rdata,  // Transmit FIFO Read Data bus.
                                              
  //$port_g RxFIFO 64*36 Two Ports SRAM
  input  wire                                 mac_rxfifo_wen,    // Receive FIFO Write Enable.
  input  wire [g_mac_rxfifo_awidth-1:0]       mac_rxfifo_waddr,  // Receive FIFO Write Address bus.
  input  wire [35:0]                          mac_rxfifo_wdata,  // Receive FIFO Write Data bus.
  input  wire                                 mac_rxfifo_ren,    // Receive FIFO Read Enable.
  input  wire [g_mac_rxfifo_awidth-1:0]       mac_rxfifo_raddr,  // Receive FIFO Read Address bus.
  output wire [35:0]                          mac_rxfifo_rdata,  // Receive FIFO Read Data bus.

  //$port_g Key Storage RAM 64*187(315) Single Port SRAM
  input  wire                                 keystorage_en,     // Enable Key Storage RAM
  input  wire                                 keystorage_wen,    // Write Enable Key Storage RAM
  input  wire [g_keystorage_awidth-1:0]       keystorage_addr,   // Key Storage RAM write data bus
  input  wire [g_keystorage_dwidth-1:0]       keystorage_wdata,  // Key Storage RAM address bus.
  output wire [g_keystorage_dwidth-1:0]       keystorage_rdata,  // Key Storage RAM read data bus.

  //$port_g RC4 PRNG 128*16 Dual Ports SRAM
  output  wire  [15:0]                        sbox_mem_rdata,    // SBOX data bus from internal RAM
  input wire   [6:0]                          sbox_mem_waddr,    // SBOX address bus to internal RAM, port write
  input wire   [6:0]                          sbox_mem_raddr,    // SBOX address bus to internal RAM, port read
  input wire  [15:0]                          sbox_mem_wdata,    // SBOX data bus to internal RAM
  input wire   [1:0]                          sbox_mem_wen,      // SBOX write enable signal for internal RAM
  input wire                                  sbox_mem_ren,      // SBOX read enable signal for internal RAM


  //$port_g MAC-PHY IF TX FIFO RAM 256*8 Two Ports SRAM
  input  wire                                 mpif_txfifo_wen,   // MAC-PHY InterFace Transmit FIFO Write Enable.
  input  wire [g_mpif_txfifo_awidth-1:0]      mpif_txfifo_waddr, // MAC-PHY Interface Transmit FIFO Write Address bus.
  input  wire [ 7:0]                          mpif_txfifo_wdata, // MAC-PHY Interface Transmit FIFO Write Data bus.
  input  wire                                 mpif_txfifo_ren,   // MAC-PHY Interface Transmit FIFO Read Enable.
  input  wire [g_mpif_txfifo_awidth-1:0]      mpif_txfifo_raddr, // MAC-PHY Interface Transmit FIFO Read Address bus.
  output wire [ 7:0]                          mpif_txfifo_rdata, // MAC-PHY Interface Transmit FIFO Read Data bus.

  //$port_g MAC-PHY IF RX FIFO RAM 64*8 Two Ports SRAM
  input  wire                                 mpif_rxfifo_wen,   // MAC-PHY InterFace Receive FIFO Write Enable.
  input  wire [g_mpif_rxfifo_awidth-1:0]      mpif_rxfifo_waddr, // MAC-PHY Interface Receive FIFO Write Address bus.
  input  wire [ 7:0]                          mpif_rxfifo_wdata, // MAC-PHY Interface Receive FIFO Write Data bus.
  input  wire                                 mpif_rxfifo_ren,   // MAC-PHY Interface Receive FIFO Read Enable.
  input  wire [g_mpif_rxfifo_awidth-1:0]      mpif_rxfifo_raddr, // MAC-PHY Interface Receive FIFO Read Address bus.
  output wire [ 7:0]                          mpif_rxfifo_rdata, // MAC-PHY Interface Receive FIFO Read Data bus.

  //$port_g MIB Table RAM 256*32 Single Port SRAM
  input  wire                                 mibtable_en,       // MIB Table Enable.
  input  wire                                 mibtable_wen,      // MIB Table Write Enable.
  input  wire [ 7:0]                          mibtable_addr,     // MIB Table Address bus.
  input  wire [31:0]                          mibtable_wdata,    // MIB Table Write Data bus.
  output wire [31:0]                          mibtable_rdata,    // MIB Table Read Data bus.

  //$port_g Platform memory 32768/64 single sram port (one write enable per byte lane)
  input  wire                                 sharedram_en,      // Shared RAM Enable
  input  wire [g_sharedram_awidth-1:0]        sharedram_addr,    // Shared RAM Address
  input  wire [ 7:0]                          sharedram_wen,     // Shared RAM Write Byte Enable
  input  wire [63:0]                          sharedram_wdata,   // Shared RAM Write Data
  output wire [63:0]                          sharedram_rdata,   // Shared RAM Read Data

  //$port_g RSA Memory Single Port SRAM 
`ifdef  RW_HSU_RSA_EN
  input  wire                                 rsa_sram_en,       // RSA SRAM Enable
  input  wire         [g_rsa_sram_awidth-1:0] rsa_sram_addr,     // RSA SRAM Address
  input  wire                           [3:0] rsa_sram_wen,      // RSA SRAM Write Enable
  input  wire         [g_rsa_sram_dwidth-1:0] rsa_sram_wdata,    // RSA SRAM Write Data
  output wire         [g_rsa_sram_dwidth-1:0] rsa_sram_rdata,    // RSA SRAM Read  Data
`endif//RW_HSU_RSA_EN

  /*****************************************************************************
  //$port_g HDMCore memories interface
  *****************************************************************************/
  //$port_g FFT 0 buffer 0
  input  wire [ 15:0]                         fft0mem0_wen,      // FFT 0 Memory 0 Write Enable  
  input  wire [g_fftmem_awidth-1:0]           fft0mem0_waddr,    // FFT 0 Memory 0 Write Address 
  input  wire [239:0]                         fft0mem0_wdata,    // FFT 0 Memory 0 Write Data    
  input  wire                                 fft0mem0_ren,      // FFT 0 Memory 0 Read Enable   
  input  wire [g_fftmem_awidth-1:0]           fft0mem0_raddr,    // FFT 0 Memory 0 Read Address  
  output wire [239:0]                         fft0mem0_rdata,    // FFT 0 Memory 0 Read Data     

  //$port_g FFT 0 buffer 1
  input  wire [ 15:0]                         fft0mem1_wen,      // FFT 0 Memory 1 Write Enable  
  input  wire [g_fftmem_awidth-1:0]           fft0mem1_waddr,    // FFT 0 Memory 1 Write Address 
  input  wire [239:0]                         fft0mem1_wdata,    // FFT 0 Memory 1 Write Data    
  input  wire                                 fft0mem1_ren,      // FFT 0 Memory 1 Read Enable   
  input  wire [g_fftmem_awidth-1:0]           fft0mem1_raddr,    // FFT 0 Memory 1 Read Address  
  output wire [239:0]                         fft0mem1_rdata,    // FFT 0 Memory 1 Read Data     

  //$port_g FFT 0 buffer 2
  input  wire [ 15:0]                         fft0mem2_wen,      // FFT 0 Memory 2 Write Enable  
  input  wire [g_fftmem_awidth-1:0]           fft0mem2_waddr,    // FFT 0 Memory 2 Write Address 
  input  wire [239:0]                         fft0mem2_wdata,    // FFT 0 Memory 2 Write Data    
  input  wire                                 fft0mem2_ren,      // FFT 0 Memory 2 Read Enable   
  input  wire [g_fftmem_awidth-1:0]           fft0mem2_raddr,    // FFT 0 Memory 2 Read Address  
  output wire [239:0]                         fft0mem2_rdata,    // FFT 0 Memory 2 Read Data     

  //$port_g FFT 0 buffer 3
  input  wire [ 15:0]                         fft0mem3_wen,      // FFT 0 Memory 3 Write Enable  
  input  wire [g_fftmem_awidth-1:0]           fft0mem3_waddr,    // FFT 0 Memory 3 Write Address 
  input  wire [239:0]                         fft0mem3_wdata,    // FFT 0 Memory 3 Write Data    
  input  wire                                 fft0mem3_ren,      // FFT 0 Memory 3 Read Enable   
  input  wire [g_fftmem_awidth-1:0]           fft0mem3_raddr,    // FFT 0 Memory 3 Read Address  
  output wire [239:0]                         fft0mem3_rdata,    // FFT 0 Memory 3 Read Data     

  //$port_g FFT 0 buffer 4
  input  wire [ 15:0]                         fft0mem4_wen,      // FFT 0 Memory 4 Write Enable  
  input  wire [g_fftmem_awidth-1:0]           fft0mem4_waddr,    // FFT 0 Memory 4 Write Address 
  input  wire [303:0]                         fft0mem4_wdata,    // FFT 0 Memory 4 Write Data    
  input  wire                                 fft0mem4_ren,      // FFT 0 Memory 4 Read Enable   
  input  wire [g_fftmem_awidth-1:0]           fft0mem4_raddr,    // FFT 0 Memory 4 Read Address  
  output wire [303:0]                         fft0mem4_rdata,    // FFT 0 Memory 4 Read Data     

  //$port_g FFT 0 buffer 5
  input  wire [ 15:0]                         fft0mem5_wen,      // FFT 0 Memory 5 Write Enable  
  input  wire [g_fftmem_awidth-1:0]           fft0mem5_waddr,    // FFT 0 Memory 5 Write Address 
  input  wire [303:0]                         fft0mem5_wdata,    // FFT 0 Memory 5 Write Data    
  input  wire                                 fft0mem5_ren,      // FFT 0 Memory 5 Read Enable   
  input  wire [g_fftmem_awidth-1:0]           fft0mem5_raddr,    // FFT 0 Memory 5 Read Address  
  output wire [303:0]                         fft0mem5_rdata,    // FFT 0 Memory 5 Read Data     

`ifdef RW_NX_LDPC_ENC
  input  wire [  4:0]                         ldpc0tx0_addr,  
  input  wire                                 ldpc0tx0_en,   
  input  wire [  8:0]                         ldpc0tx0_wen,   
  input  wire [ 80:0]                         ldpc0tx0_wdata, 
  output wire [ 80:0]                         ldpc0tx0_rdata, 

  input  wire [  4:0]                         ldpc0tx1_addr,  
  input  wire                                 ldpc0tx1_en,   
  input  wire [  8:0]                         ldpc0tx1_wen,   
  input  wire [ 80:0]                         ldpc0tx1_wdata, 
  output wire [ 80:0]                         ldpc0tx1_rdata, 
`endif // RW_NX_LDPC_ENC

`ifdef RW_NX_LDPC_DEC
  /*  LDPC0 Memories */
  input  wire [`RW_LDPCCFGRAM_AWIDTH-1:0]     ldpcrx0_cfg_addr,
  input  wire                                 ldpcrx0_cfg_en,
  input  wire                                 ldpcrx0_cfg_wen,
  input  wire [28:0]                          ldpcrx0_cfg_wdata,
  output wire [28:0]                          ldpcrx0_cfg_rdata,
  
  input  wire [6:0]                           ldpcrx0_cr_waddr,   
  input  wire [6:0]                           ldpcrx0_cr_raddr,   
  input  wire [485:0]                         ldpcrx0_cr_wdata,   
  input  wire                                 ldpcrx0_cr_ren,     
  input  wire                                 ldpcrx0_cr_wen,     
  output wire  [485:0]                        ldpcrx0_cr_rdata,   

  input  wire [4:0]                           ldpcrx0_vr_waddr,   
  input  wire [4:0]                           ldpcrx0_vr_raddr,   
  input  wire [647:0]                         ldpcrx0_vr_wdata,   
  input  wire                                 ldpcrx0_vr_ren,     
  input  wire                                 ldpcrx0_vr_wen,     
  output wire [647:0]                         ldpcrx0_vr_rdata,   

  input  wire [4:0]                           ldpcrx0_vmx_waddr,  
  input  wire [4:0]                           ldpcrx0_vmx_raddr,  
  input  wire [647:0]                         ldpcrx0_vmx_wdata,  
  input  wire                                 ldpcrx0_vmx_ren,    
  input  wire [`RW_NX_DERIV_LDPC_VMWE_WIDTH-1:0] ldpcrx0_vmx_wen,    
  output wire [647:0]                         ldpcrx0_vmx_rdata,  

  input  wire [4:0]                           ldpcrx0_vmy_waddr,  
  input  wire [4:0]                           ldpcrx0_vmy_raddr,  
  input  wire [647:0]                         ldpcrx0_vmy_wdata,  
  input  wire                                 ldpcrx0_vmy_ren,    
  input  wire [`RW_NX_DERIV_LDPC_VMWE_WIDTH-1:0] ldpcrx0_vmy_wen,
  output wire [647:0]                         ldpcrx0_vmy_rdata,  

  input  wire [4:0]                           ldpcrx0_hd_waddr,   
  input  wire [80:0]                          ldpcrx0_hd_wdata,   

  input  wire [4:0]                           ldpcrx0_hdx_raddr,  
  output wire [80:0]                          ldpcrx0_hdx_rdata,  
  input  wire                                 ldpcrx0_hdx_ren,    
  input  wire                                 ldpcrx0_hdx_wen,    
  
  input  wire [4:0]                           ldpcrx0_hdy_raddr,  
  input  wire                                 ldpcrx0_hdy_wen,  
  input  wire                                 ldpcrx0_hdy_ren,    
  output wire [80:0]                          ldpcrx0_hdy_rdata,
`endif // RW_NX_LDPC_DEC

  //$port_g bdfd memory interface
  input  wire                                 bdfd_wen,    
  input  wire [ 6:0]                          bdfd_waddr,
  input  wire [59:0]                          bdfd_wdata,  
  input  wire                                 bdfd_ren,     
  input  wire [ 6:0]                          bdfd_raddr,   
  output wire [59:0]                          bdfd_rdata,  

`ifdef RW_BFMEE_EN
  //$port_g bfmee memory interface
  input  wire                                 bfmee_en,    
  input  wire                                 bfmee_wen,     
  input  wire [`RW_BFMEE_RAM_AWIDTH-1:0]      bfmee_addr,
  input  wire [31:0]                          bfmee_wdata,  
  output wire [31:0]                          bfmee_rdata,  
`endif

  /*****************************************************************************
  //$port_g RIU memories interface
  *****************************************************************************/

  //$port_g Radar detection
`ifdef RW_RADAR_EN
  input  wire [8:0]                           radarmem_addr,      // Radar Memory Address                   
  input  wire                                 radarmem_en,        // Radar Memory Enable              
  input  wire                                 radarmem_wren,      // Radar Memory Write Enable               
  input  wire [9:0]                           radarmem_wrdata,    // Radar Memory Write Data                
  output wire [9:0]                           radarmem_rddata,    // Radar Memory Read Data                 
`endif

  //$port_g AGC
  input  wire [7:0]                           agcmem_addr,        // AGC Memory Address                   
  input  wire                                 agcmem_en,          // AGC Memory Enable              
  input  wire [1:0]                           agcmem_wren,        // AGC Memory Write Enable               
  input  wire [63:0]                          agcmem_wrdata,      // AGC Memory Write Data                
  output wire [63:0]                          agcmem_rddata       // AGC Memory Read Data                 
);

  wire [239:0]                                fft0mem0_wen_bit; // FFT 0 Memory 0 Write Enable per bit  
  wire [239:0]                                fft0mem1_wen_bit; // FFT 0 Memory 1 Write Enable per bit    
  wire [239:0]                                fft0mem2_wen_bit; // FFT 0 Memory 2 Write Enable per bit  
  wire [239:0]                                fft0mem3_wen_bit; // FFT 0 Memory 3 Write Enable per bit  
  wire [303:0]                                fft0mem4_wen_bit; // FFT 0 Memory 4 Write Enable per bit  
  wire [303:0]                                fft0mem5_wen_bit; // FFT 0 Memory 5 Write Enable per bit  
  wire [ 63:0]                                sharedram_wen_bit;// Shared RAM Write Enable per bit
`ifdef  RW_HSU_RSA_EN
  wire [g_rsa_sram_dwidth-1:0]                rsa_sram_wen_bit; // RSA SRAM Write Enable per bit
`endif//RW_HSU_RSA_EN
  
`ifdef RW_NX_LDPC_ENC
  wire [ 80:0]                                ldpc0tx0_wen_bit;
  wire [ 80:0]                                ldpc0tx1_wen_bit;
`endif // RW_NX_LDPC_ENC

  /*****************************************************************************
  * MAC TXFIFO SRAM
  *****************************************************************************/
  sram_two_port_model
  #(
    .g_addr_width(     g_mac_txfifo_awidth),
    .g_data_width(     38)
  )
  u_mac_txfifo
  (
    .wclk(              mac_pi_tx_clk),
    .waddr(             mac_txfifo_waddr),
    .wen(               {38{mac_txfifo_wen}}),
    .wdata(             mac_txfifo_wdata),
   
    .rclk(              mac_core_tx_clk),
    .ren(               mac_txfifo_ren),
    .raddr(             mac_txfifo_raddr),
    .rdata(             mac_txfifo_rdata)
  );

  /*****************************************************************************
  * MAC RXFIFO SRAM
  *****************************************************************************/
  sram_two_port_model
  #(
    .g_addr_width(      g_mac_rxfifo_awidth),
    .g_data_width(      36)
  )
  u_mac_rxfifo
  (
    .wclk(              mac_core_rx_clk),
    .wen(               {36{mac_rxfifo_wen}}),
    .waddr(             mac_rxfifo_waddr),
    .wdata(             mac_rxfifo_wdata),
    
    .rclk(              mac_pi_rx_clk),
    .ren(               mac_rxfifo_ren),
    .raddr(             mac_rxfifo_raddr),
    .rdata(             mac_rxfifo_rdata)
  );

  /*****************************************************************************
  * MAC KEYSTORAGE SRAM
  *****************************************************************************/
  sram_single_port_model
  #(
    .g_addr_width(      g_keystorage_awidth),
    .g_data_width(      g_keystorage_dwidth)
  )
  u_keystorage
  (
    .clk(               mac_core_clk),
    .en(                keystorage_en),
    .addr(              keystorage_addr),
    .wen(               {g_keystorage_dwidth{keystorage_wen}}),
    .wdata(             keystorage_wdata),
    .rdata(             keystorage_rdata)
  );

  /*****************************************************************************
  * MAC SBOX SRAM
  *****************************************************************************/

  sram_two_port_model
  #(
    .g_addr_width(              7),
    .g_data_width(              16)
  )
  u_sbox
  (
    .wclk(    mac_wt_clk),
    .waddr(   sbox_mem_waddr),
    .wen(     {{8{sbox_mem_wen[1]}}, {8{sbox_mem_wen[0]}}}),
    .wdata(   sbox_mem_wdata),
    .rclk(    mac_wt_clk),
    .ren(     sbox_mem_ren),
    .raddr(   sbox_mem_raddr ),
    .rdata(   sbox_mem_rdata)
  );

  /*****************************************************************************
  * MPIF TXFIFO SRAM
  *****************************************************************************/
  sram_two_port_model
  #(
    .g_addr_width(      g_mpif_txfifo_awidth),
    .g_data_width(      8)
  )
  u_mpif_txfifo
  (
    .wclk(              mac_core_tx_clk),
    .wen(               {8{mpif_txfifo_wen}}),
    .waddr(             mpif_txfifo_waddr),
    .wdata(             mpif_txfifo_wdata),
    
    .rclk(              mpif_clk),
    .ren(               mpif_txfifo_ren),
    .raddr(             mpif_txfifo_raddr),
    .rdata(             mpif_txfifo_rdata)
  );
         
  /*****************************************************************************
  * MPIF RXFIFO SRAM
  *****************************************************************************/
  sram_two_port_model
  #(
    .g_addr_width(      g_mpif_rxfifo_awidth),
    .g_data_width(      8)
  )
  u_mpif_rxfifo
  (
    .wclk(              mpif_clk),
    .wen(               {8{mpif_rxfifo_wen}}),
    .waddr(             mpif_rxfifo_waddr),
    .wdata(             mpif_rxfifo_wdata),
    
    .rclk(              mac_core_rx_clk),
    .ren(               mpif_rxfifo_ren),
    .raddr(             mpif_rxfifo_raddr),
    .rdata(             mpif_rxfifo_rdata)
  );
  
  /*****************************************************************************
  * MAC MIB TABLE
  *****************************************************************************/
  sram_single_port_model
  #(
    .g_addr_width(      8),
    .g_data_width(      32)
  )
  u_mibtable
  (
    .clk (              mac_core_clk),
    .en(                mibtable_en),
    .addr(              mibtable_addr),
    .wen(               {32{mibtable_wen}}),
    .wdata(             mibtable_wdata),
    .rdata(             mibtable_rdata)
  );
 
  /*****************************************************************************
  * PLATFORM SHARED RAM
  *****************************************************************************/
`ifdef RW_MEM_FPGA

  `ifdef  RW_SHARED_RAM_384K
    sram_sp_48kx8 sram_sp_48kx8_i[7:0] (
  `else //RW_SHARED_RAM_384K
    sram_sp_32768x8 sram_sp_32768x8_i[7:0] (
  `endif//RW_SHARED_RAM_384K
      .clka       (plf_clk               ),
      .ena        (sharedram_en         ),
  `ifdef  RW_SHARED_RAM_384K
      .addra      (sharedram_addr[15:0] ),
  `else //RW_SHARED_RAM_384K
      .addra      (sharedram_addr[14:0] ),
  `endif//RW_SHARED_RAM_384K
      .wea        (sharedram_wen      ),
      .dina       (sharedram_wdata    ),
      .douta      (sharedram_rdata    )
    );

`else
  assign sharedram_wen_bit = {{8{sharedram_wen[7]}},{8{sharedram_wen[6]}},{8{sharedram_wen[5]}},{8{sharedram_wen[4]}},{8{sharedram_wen[3]}},{8{sharedram_wen[2]}},{8{sharedram_wen[1]}},{8{sharedram_wen[0]}}};

  sram_single_port_model
  #(
    .g_addr_width(      g_sharedram_awidth),
    .g_data_width(      64)
  )
  u_sharedram
  (
    .clk(               plf_clk),
    .en(                sharedram_en),
    .addr(              sharedram_addr),
    .wen(               sharedram_wen_bit),
    .wdata(             sharedram_wdata),
    .rdata(             sharedram_rdata)
  );
`endif // RW_MEM_FPGA

  /*****************************************************************************
  * RSA RAM
  *****************************************************************************/
`ifdef  RW_HSU_RSA_EN
  assign rsa_sram_wen_bit = {{g_rsa_sram_dwidth/4{rsa_sram_wen[3]}},
                             {g_rsa_sram_dwidth/4{rsa_sram_wen[2]}},
                             {g_rsa_sram_dwidth/4{rsa_sram_wen[1]}},
                             {g_rsa_sram_dwidth/4{rsa_sram_wen[0]}}};

  sram_single_port_model
  #(
    .g_addr_width(      g_rsa_sram_awidth),
    .g_data_width(      g_rsa_sram_dwidth)
  )
  u_rsa_sram
  (
    .clk(               plf_clk),
    .en(                rsa_sram_en),
    .addr(              rsa_sram_addr),
    .wen(               rsa_sram_wen_bit),
    .wdata(             rsa_sram_wdata),
    .rdata(             rsa_sram_rdata)
  );
`endif//RW_HSU_RSA_EN

  /*****************************************************************************
  * FFT RAM
  *****************************************************************************/
  assign fft0mem0_wen_bit = {{15{fft0mem0_wen[15]}},{15{fft0mem0_wen[14]}},{15{fft0mem0_wen[13]}},{15{fft0mem0_wen[12]}},
                             {15{fft0mem0_wen[11]}},{15{fft0mem0_wen[10]}},{15{fft0mem0_wen[ 9]}},{15{fft0mem0_wen[ 8]}},
                             {15{fft0mem0_wen[ 7]}},{15{fft0mem0_wen[ 6]}},{15{fft0mem0_wen[ 5]}},{15{fft0mem0_wen[ 4]}},
                             {15{fft0mem0_wen[ 3]}},{15{fft0mem0_wen[ 2]}},{15{fft0mem0_wen[ 1]}},{15{fft0mem0_wen[ 0]}}
                             };
  
  sram_two_port_model
  #(
    .g_addr_width(       g_fftmem_awidth),
    .g_data_width(       240)
  )
  u_fft0mem0
  ( 
    .wclk(              phy_clk),
    .wen(               fft0mem0_wen_bit),
    .waddr(             fft0mem0_waddr),
    .wdata(             fft0mem0_wdata),
    
    .rclk(              phy_clk),
    .ren(               fft0mem0_ren),
    .raddr(             fft0mem0_raddr),
    .rdata(             fft0mem0_rdata)
  );
 
  assign fft0mem1_wen_bit = {{15{fft0mem1_wen[15]}},{15{fft0mem1_wen[14]}},{15{fft0mem1_wen[13]}},{15{fft0mem1_wen[12]}},
                             {15{fft0mem1_wen[11]}},{15{fft0mem1_wen[10]}},{15{fft0mem1_wen[ 9]}},{15{fft0mem1_wen[ 8]}},
                             {15{fft0mem1_wen[ 7]}},{15{fft0mem1_wen[ 6]}},{15{fft0mem1_wen[ 5]}},{15{fft0mem1_wen[ 4]}},
                             {15{fft0mem1_wen[ 3]}},{15{fft0mem1_wen[ 2]}},{15{fft0mem1_wen[ 1]}},{15{fft0mem1_wen[ 0]}}
                            };

  sram_two_port_model
  #(
    .g_addr_width(      g_fftmem_awidth),
    .g_data_width(      240)
  )
  u_fft0mem1
  ( 
    .wclk(              phy_clk),
    .wen(               fft0mem1_wen_bit),
    .waddr(             fft0mem1_waddr),
    .wdata(             fft0mem1_wdata),
    
    .rclk(              phy_clk),
    .ren(               fft0mem1_ren),
    .raddr(             fft0mem1_raddr),
    .rdata(             fft0mem1_rdata)
  );
  
  assign fft0mem2_wen_bit = {{15{fft0mem2_wen[15]}},{15{fft0mem2_wen[14]}},{15{fft0mem2_wen[13]}},{15{fft0mem2_wen[12]}},
                             {15{fft0mem2_wen[11]}},{15{fft0mem2_wen[10]}},{15{fft0mem2_wen[ 9]}},{15{fft0mem2_wen[ 8]}},
                             {15{fft0mem2_wen[ 7]}},{15{fft0mem2_wen[ 6]}},{15{fft0mem2_wen[ 5]}},{15{fft0mem2_wen[ 4]}},
                             {15{fft0mem2_wen[ 3]}},{15{fft0mem2_wen[ 2]}},{15{fft0mem2_wen[ 1]}},{15{fft0mem2_wen[ 0]}}
                            };

  sram_two_port_model
  #(
    .g_addr_width(      g_fftmem_awidth),
    .g_data_width(      240)
  )
  u_fft0mem2
  ( 
    .wclk(              phy_clk),
    .wen(               fft0mem2_wen_bit),
    .waddr(             fft0mem2_waddr),
    .wdata(             fft0mem2_wdata),
    
    .rclk(              phy_clk),
    .ren(               fft0mem2_ren),
    .raddr(             fft0mem2_raddr),
    .rdata(             fft0mem2_rdata)
  );

  assign fft0mem3_wen_bit = {{15{fft0mem3_wen[15]}},{15{fft0mem3_wen[14]}},{15{fft0mem3_wen[13]}},{15{fft0mem3_wen[12]}},
                             {15{fft0mem3_wen[11]}},{15{fft0mem3_wen[10]}},{15{fft0mem3_wen[ 9]}},{15{fft0mem3_wen[ 8]}},
                             {15{fft0mem3_wen[ 7]}},{15{fft0mem3_wen[ 6]}},{15{fft0mem3_wen[ 5]}},{15{fft0mem3_wen[ 4]}},
                             {15{fft0mem3_wen[ 3]}},{15{fft0mem3_wen[ 2]}},{15{fft0mem3_wen[ 1]}},{15{fft0mem3_wen[ 0]}}
                            };

  sram_two_port_model
  #(
    .g_addr_width(      g_fftmem_awidth),
    .g_data_width(      240)
  )
  u_fft0mem3
  ( 
    .wclk(              phy_clk),
    .wen(               fft0mem3_wen_bit),
    .waddr(             fft0mem3_waddr),
    .wdata(             fft0mem3_wdata),
    
    .rclk(              phy_clk),
    .ren(               fft0mem3_ren),
    .raddr(             fft0mem3_raddr),
    .rdata(             fft0mem3_rdata)
  );

  assign fft0mem4_wen_bit = {{19{fft0mem4_wen[15]}},{19{fft0mem4_wen[14]}},{19{fft0mem4_wen[13]}},{19{fft0mem4_wen[12]}},
                             {19{fft0mem4_wen[11]}},{19{fft0mem4_wen[10]}},{19{fft0mem4_wen[ 9]}},{19{fft0mem4_wen[ 8]}},
                             {19{fft0mem4_wen[ 7]}},{19{fft0mem4_wen[ 6]}},{19{fft0mem4_wen[ 5]}},{19{fft0mem4_wen[ 4]}},
                             {19{fft0mem4_wen[ 3]}},{19{fft0mem4_wen[ 2]}},{19{fft0mem4_wen[ 1]}},{19{fft0mem4_wen[ 0]}}
                            };

  sram_two_port_model
  #(
    .g_addr_width(      g_fftmem_awidth),
    .g_data_width(      304)
  )
  u_fft0mem4
  ( 
    .wclk(              phy_clk),
    .wen(               fft0mem4_wen_bit),
    .waddr(             fft0mem4_waddr),
    .wdata(             fft0mem4_wdata),
    
    .rclk(              phy_clk),
    .ren(               fft0mem4_ren),
    .raddr(             fft0mem4_raddr),
    .rdata(             fft0mem4_rdata)
  );

  assign fft0mem5_wen_bit = {{19{fft0mem5_wen[15]}},{19{fft0mem5_wen[14]}},{19{fft0mem5_wen[13]}},{19{fft0mem5_wen[12]}},
                             {19{fft0mem5_wen[11]}},{19{fft0mem5_wen[10]}},{19{fft0mem5_wen[ 9]}},{19{fft0mem5_wen[ 8]}},
                             {19{fft0mem5_wen[ 7]}},{19{fft0mem5_wen[ 6]}},{19{fft0mem5_wen[ 5]}},{19{fft0mem5_wen[ 4]}},
                             {19{fft0mem5_wen[ 3]}},{19{fft0mem5_wen[ 2]}},{19{fft0mem5_wen[ 1]}},{19{fft0mem5_wen[ 0]}}
                            };

  sram_two_port_model
  #(
    .g_addr_width(      g_fftmem_awidth),
    .g_data_width(      304)
  )
  u_fft0mem5
  ( 
    .wclk(              phy_clk),
    .wen(               fft0mem5_wen_bit),
    .waddr(             fft0mem5_waddr),
    .wdata(             fft0mem5_wdata),
    
    .rclk(              phy_clk),
    .ren(               fft0mem5_ren),
    .raddr(             fft0mem5_raddr),
    .rdata(             fft0mem5_rdata)
  );

`ifdef RW_NX_LDPC_ENC
  assign ldpc0tx0_wen_bit = {{9{ldpc0tx0_wen[8]}},
                             {9{ldpc0tx0_wen[7]}},{9{ldpc0tx0_wen[6]}},{9{ldpc0tx0_wen[5]}},{9{ldpc0tx0_wen[4]}},
                             {9{ldpc0tx0_wen[3]}},{9{ldpc0tx0_wen[2]}},{9{ldpc0tx0_wen[1]}},{9{ldpc0tx0_wen[0]}}};

  sram_single_port_model
  #(
    .g_addr_width(              5),
    .g_data_width(              81)
  )
  u_ldpctx0_ram0
  (
    .clk(                        ldpc0tx0_clk),
    .addr(                       ldpc0tx0_addr),
    .wdata(                      ldpc0tx0_wdata),
    .wen(                        ldpc0tx0_wen_bit),
    .en(                         ldpc0tx0_en),
    .rdata(                      ldpc0tx0_rdata)

  );

  assign ldpc0tx1_wen_bit = {{9{ldpc0tx1_wen[8]}},
                             {9{ldpc0tx1_wen[7]}},{9{ldpc0tx1_wen[6]}},{9{ldpc0tx1_wen[5]}},{9{ldpc0tx1_wen[4]}},
                             {9{ldpc0tx1_wen[3]}},{9{ldpc0tx1_wen[2]}},{9{ldpc0tx1_wen[1]}},{9{ldpc0tx1_wen[0]}}};

  sram_single_port_model
  #(
    .g_addr_width(              5),
    .g_data_width(              81) 
  )
  u_ldpctx0_ram1
  (
    .clk(                        ldpc0tx0_clk),
    .addr(                       ldpc0tx1_addr),
    .wdata(                      ldpc0tx1_wdata),
    .wen(                        ldpc0tx1_wen_bit),
    .en(                         ldpc0tx1_en),
    .rdata(                      ldpc0tx1_rdata)

  );
`endif // RW_NX_LDPC_ENC

`ifdef RW_NX_LDPC_DEC

  sram_single_port_model
  #(
    .g_addr_width(              `RW_LDPCCFGRAM_AWIDTH),
    .g_data_width(              29),
//    .g_load_mem(                "ldpc_cfg_ram.bin"),
    .g_depth(                   `RW_NX_DERIV_LDPCCFGRAM_DEPTH)
  )
  u_ldpc_cfg_ram
  (
    .clk(                     plf_clk),
    .addr(                    ldpcrx0_cfg_addr),
    .wen(                     {29{ldpcrx0_cfg_wen}}),
    .en(                      ldpcrx0_cfg_en),
    .wdata(                   ldpcrx0_cfg_wdata),
    .rdata(                   ldpcrx0_cfg_rdata)
  );


  sram_two_port_model
  #(
    .g_addr_width(              7),
    .g_data_width(              486)
  )
  u_ldpc0_cr_ram
  (
    .wclk(                      ldpcrx0_clk),
    .waddr(                     ldpcrx0_cr_waddr),
    .wen(                       {486{ldpcrx0_cr_wen}}),
    .wdata(                     ldpcrx0_cr_wdata),
    .rclk(                      ldpcrx0_clk),
    .ren(                       ldpcrx0_cr_ren),
    .raddr(                     ldpcrx0_cr_raddr),
    .rdata(                     ldpcrx0_cr_rdata)
  );

  sram_two_port_model
  #(
    .g_addr_width(              5),
    .g_data_width(              648)
  )
  u_ldpc0_vr_ram
  (
    .wclk(                      ldpcrx0_clk),
    .waddr(                     ldpcrx0_vr_waddr),
    .wen(                       {648{ldpcrx0_vr_wen}}),
    .wdata(                     ldpcrx0_vr_wdata),
    .rclk(                      ldpcrx0_clk),
    .ren(                       ldpcrx0_vr_ren),
    .raddr(                     ldpcrx0_vr_raddr),
    .rdata(                     ldpcrx0_vr_rdata)
  );

  wire [647:0] ldpcrx0_vmx_wen_bit;
  assign ldpcrx0_vmx_wen_bit = {{216{ldpcrx0_vmx_wen[2]}},{216{ldpcrx0_vmx_wen[1]}},{216{ldpcrx0_vmx_wen[0]}}};

  sram_two_port_model
  #(
    .g_addr_width(              5),
    .g_data_width(              648)
  )
  u_ldpc0_vmx_ram
  (
    .wclk(                      ldpcrx0_clk),
    .waddr(                     ldpcrx0_vmx_waddr),
    .wen(                       ldpcrx0_vmx_wen_bit),
    .wdata(                     ldpcrx0_vmx_wdata),
    .rclk(                      ldpcrx0_clk),
    .ren(                       ldpcrx0_vmx_ren),
    .raddr(                     ldpcrx0_vmx_raddr),
    .rdata(                     ldpcrx0_vmx_rdata)
  );

  wire [647:0] ldpcrx0_vmy_wen_bit;
  assign ldpcrx0_vmy_wen_bit = {{216{ldpcrx0_vmy_wen[2]}},{216{ldpcrx0_vmy_wen[1]}},{216{ldpcrx0_vmy_wen[0]}}};

  sram_two_port_model
  #(
    .g_addr_width(              5),
    .g_data_width(              648)
  )
  u_ldpc0_vmy_ram
  (
    .wclk(                      ldpcrx0_clk),
    .waddr(                     ldpcrx0_vmy_waddr),
    .wen(                       ldpcrx0_vmy_wen_bit),
    .wdata(                     ldpcrx0_vmy_wdata),
    .rclk(                      ldpcrx0_clk),
    .ren(                       ldpcrx0_vmy_ren),
    .raddr(                     ldpcrx0_vmy_raddr),
    .rdata(                     ldpcrx0_vmy_rdata)
  );

  sram_two_port_model
  #(
    .g_addr_width(              5),
    .g_data_width(              81)
  )
  u_ldpc0_hdx_ram
  (
    .wclk(                      ldpcrx0_clk),
    .waddr(                     ldpcrx0_hd_waddr),
    .wen(                       {81{ldpcrx0_hdx_wen}}),
    .wdata(                     ldpcrx0_hd_wdata),
    .rclk(                      ldpcrx0_clk),
    .ren(                       ldpcrx0_hdx_ren),
    .raddr(                     ldpcrx0_hdx_raddr),
    .rdata(                     ldpcrx0_hdx_rdata)
  );

  sram_two_port_model
  #(
    .g_addr_width(              5),
    .g_data_width(              81)
  )
  u_ldpc0_hdy_ram
  (
    .wclk(                      ldpcrx0_clk),
    .waddr(                     ldpcrx0_hd_waddr),
    .wen(                       {81{ldpcrx0_hdy_wen}}),
    .wdata(                     ldpcrx0_hd_wdata),
    .rclk(                      ldpcrx0_clk),
    .ren(                       ldpcrx0_hdy_ren),
    .raddr(                     ldpcrx0_hdy_raddr),
    .rdata(                     ldpcrx0_hdy_rdata)
  );

`endif // RW_NX_LDPC_DEC
  
  /*****************************************************************************
  * bdfd memory
  *****************************************************************************/
  sram_two_port_model
  #(
    .g_addr_width(      7),
    .g_data_width(      60)
  )
  u_bdfd_ram
  (
    .wclk(              phy_clk),
    .waddr(             bdfd_waddr),
    .wen(               {60{bdfd_wen}}),
    .wdata(             bdfd_wdata),
    .rclk(              phy_clk),
    .ren(               bdfd_ren),
    .raddr(             bdfd_raddr),
    .rdata(             bdfd_rdata)
  );

`ifdef RW_BFMEE_EN
  /*****************************************************************************
  * BF RAM
  *****************************************************************************/
  sram_single_port_model 
  #(
    .g_data_width(      32),
    .g_addr_width(      `RW_BFMEE_RAM_AWIDTH),
    .g_depth(           `RW_BFMEE_RAM_DEPTH)
  ) 
  u_bfmee_ram
  (
    .clk(               svd_clk),
    .addr(              bfmee_addr),
    .en(                bfmee_en),
    .wen(               {32{bfmee_wen}}),
    .wdata(             bfmee_wdata),
    .rdata(             bfmee_rdata)
  );
`endif // RW_BFMEE_EN

`ifdef  RW_EMBEDDED_LA
  /*****************************************************************************
  * LA RAM
  *****************************************************************************/

`ifdef RW_MEM_FPGA

  reg [(g_embedded_la_dwidth*1 )-1:0] lamem_wen_ret   /* synthesis syn_preserve=1 */ = {g_embedded_la_dwidth{1'b0}};
  reg [(g_embedded_la_dwidth*16)-1:0] lamem_waddr_ret /* synthesis syn_preserve=1 */ = {g_embedded_la_dwidth{16'b0}};
  reg      [g_embedded_la_dwidth-1:0] lamem_wdata_ret /* synthesis syn_preserve=1 */ = {g_embedded_la_dwidth{1'b0}};
  always @(posedge lamemwr_clk)
  begin
     lamem_wen_ret   <= {g_embedded_la_dwidth{lamem_wen}};
     lamem_waddr_ret <= {g_embedded_la_dwidth{lamem_waddr}};
     lamem_wdata_ret <= lamem_wdata;
  end

  sram_dp_65536x1 sram_dp_65536x1[g_embedded_la_dwidth-1:0] (
    .clka       (lamemwr_clk     ),
    .wea        (lamem_wen_ret   ),
    .addra      (lamem_waddr_ret ),
    .dina       (lamem_wdata_ret ),
    .clkb       (lamemrd_clk     ),
    .addrb      (lamem_raddr     ),
    .doutb      (lamem_rdata     )
  );

`else // ASIC/simulation target

  sram_two_port_model
  #(
    .g_addr_width(      16),
    .g_data_width(      g_embedded_la_dwidth)
  )
  u_la
  ( 
    .wclk(              lamemwr_clk),
    .wen(               {g_embedded_la_dwidth{lamem_wen}}),
    .waddr(             lamem_waddr),
    .wdata(             lamem_wdata),
    
    .rclk(              lamemrd_clk),
    .ren(               1'b1),
    .raddr(             lamem_raddr),
    .rdata(             lamem_rdata)
  );
`endif // RW_MEM_FPGA

`endif//RW_EMBEDDED_LA

  sram_single_port_model #(
                           .g_addr_width(8),
                           .g_data_width(64),
                           .g_load_mem  ("ram.bin")  // Specific for RIU AGC ram
                           )
  u_agcmem (
                            .clk(     agcmem_clk),
                            .addr(    agcmem_addr),
                            .wen(     {{32{agcmem_wren[1]}},{32{agcmem_wren[0]}}}),
                            .en(      agcmem_en),
                            .wdata(   agcmem_wrdata),
                            .rdata(   agcmem_rddata)
                            );
  
`ifdef RW_RADAR_EN
  sram_single_port_model #(
                           .g_addr_width(9),
                           .g_data_width(10)
                           )
  u_radarmem (
                            .clk(   agc_clk),
                            .addr(  radarmem_addr),
                            .wen(   {10{radarmem_wren}}),
                            .en(    radarmem_en),
                            .wdata( radarmem_wrdata),
                            .rdata( radarmem_rddata)
                            );
`endif


endmodule
`default_nettype wire
