#!/bin/sh
#/////////////////////////////////////////////////////////////////////////////
#/  Copyright (C) by RivieraWaves.
#/  This module is a confidential and proprietary property of RivieraWaves
#/  and a possession or use of this module requires written permission 
#/  from RivieraWaves.
#/----------------------------------------------------------------------------
#/ $Author: jandre $
#/ Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/ $Revision: 16743 $
#/ $Date: 2014-11-12 10:46:53 +0100 (Wed, 12 Nov 2014) $
#/ ---------------------------------------------------------------------------
#/ Dependencies     : None
#/ Description      : Simulation script
#/ Application Note :
#/ Terms & concepts :
#/ Bugs             :
#/ Open issues and future enhancements :
#/ References       :
#/ Revision History :
#/ ---------------------------------------------------------------------------
#/
#/ $
#/
#/////////////////////////////////////////////////////////////////////////////


#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
#--- Display Help                                                 ---#
#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
DisplayHelp()
{
echo "
  This script runs compilation check.
  
  Options:

    -d | -define           : Add define for compilation

    -x | -xilinx           : Compile XILINX files

    -config <name>         : Select configuration of the DUT "
  CONFIGLIST=`find $SOURCESLIB/env/CONF/ -type f -name "*.v"| grep "$SOURCESLIB/env/CONF/config" | sed 's/.*\/env\/CONF\///'  | sed 's/\.v//' | sort -u`
  echo "                           Available configuration list :"
  for CONFIGNAME in ${CONFIGLIST}
  do
    echo "                            - $CONFIGNAME"
  done
  echo " 
                              
    -help                  : Display this message
"
}

#--------------------------------------------------------------------#
#--- PrintErrorWarning <message>                                  ---#
#--------------------------------------------------------------------#
PrintErrorWarning ()
{
  echo "ERROR: $*"
  echo ""
  exit 2
}

#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
#--- Main                                                         ---#
#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
STARTDATE=`date +%s`

INIT=0
COMPXILINX=0
DEFINES=""
ADD_XILINX=""
echo "" > defines.v
while test $# != 0
do
  arg="$1"
  OPTION=`echo $arg | sed 's/^-//'`
  shift
  case ${OPTION}
  in
    i | init)  
      INIT=1
    ;;
    d | define)
      DEFINES="$DEFINES -define $1"
      echo "\`define $1" >> defines.v
      shift
    ;;
    x | xilinx)  
      COMPXILINX=1
    ;;
    config)  
      if test $# = 0
      then
        echo "ERROR : Configuration name missing"
        echo "Please choose between available configuration : "
        #------------------------------------------------------------------------#
        #--- List the available configuration                                 ---#
        #------------------------------------------------------------------------#
        CONFIGLIST=`find $SOURCESLIB/env/CONF/ -type f -name "*.v"| grep "$SOURCESLIB/env/CONF/config" | sed 's/.*\/env\/CONF\///'  | sed 's/\.v//' `
        echo "Available configuration list :"
        echo "------------------------------"
        for CONFIGNAME in ${CONFIGLIST}
        do
          echo " - $CONFIGNAME"
        done
        echo
        exit 1
      else
        export IP_CONFIG_NAME="${1}"
        echo
        echo "Configured with ${SOURCESLIB}/env/CONF/$IP_CONFIG_NAME.v"
        echo
        IP_CONFIG_PATH="${SOURCESLIB}/env/CONF/$IP_CONFIG_NAME.v"
        shift
      fi
    ;;
    help)  
      #------------------------------------------------------------------------#
      #--- Display Help                                                     ---#
      #------------------------------------------------------------------------#
      DisplayHelp
      exit 1
    ;;
  esac
done


# Working Directory Initialization
if [ $INIT == 1 ]
then
  if [ -z "$RW_SIMDIR" ]
  then
    PrintErrorWarning "The RW_SIMDIR variable has not been set"
  else
    if [ -f "work.$RW_SIMDIR" ] || [ -d "work.$RW_SIMDIR" ]
    then
      PrintErrorWarning "Working directory 'work.$RW_SIMDIR' already exists!"
    fi
    echo "Create working directory : work.$RW_SIMDIR"
    cp -r _template work.$RW_SIMDIR
  fi
fi


# Move to the work directory
if [ -d work.$RW_SIMDIR ]
then
  cd work.$RW_SIMDIR
else
  PrintErrorWarning "Working directory work.$RW_SIMDIR does not exist"
fi

OS_OPTION=""
# Add 64 bit option if needed
if [ `uname -m` = "x86_64"  ]
then
 OS_OPTION="-64bit"
fi 

#\cp -rf $SOURCESLIB/SB/RIU_KARST/AGCKarstBinary/agcram_simu.bin ram.bin

# Create file list
create_comp_file.pl rw_he_top rtl rw_he_top_rtl_files.list 
create_comp_file.pl rw_he_top tb rw_he_top_tb_files.list 

if [ "${IP_CONFIG_PATH}" == "" ]
then
  echo "ERROR! -config <configuration name> missing"
  DisplayHelp
  exit
fi

if [ ! -e ${IP_CONFIG_PATH} ]
then
  echo "ERROR! Specified configuration files ${IP_CONFIG_NAME} does not exists (${IP_CONFIG_PATH})"
  DisplayHelp
  exit
fi

# Xilinx Compilation
if [ $COMPXILINX == 1 ]
then
  echo "Launch Xilinx Compilation"
  ncvlog ${OS_OPTION} ${XILINX}/verilog/src/glbl.v -work rw_he_top_lib -message
  ncvlog ${OS_OPTION} ${XILINX}/verilog/src/unisims/*.v -work rw_he_top_lib -message
  ADD_XILINX="-top glbl"
fi


# Run compilation
irun -nowarn CUDEFB -nowarn DLCPTH -nowarn RECOME ${OS_OPTION} \
  -access +rwc \
  -licqueue \
  -timescale "1ns / 10ps" \
  -define SIMU_ON \
  +incdir+${PHYSUBSYSDIR}/HDMCORE/OFDMACORE/OFDMTXCORE/ldpcEnc/verilog/rtl \
  +incdir+${PHYSUBSYSDIR}/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXBD/ldpcDec/verilog/rtl \
  -sv -q\
  -top rw_he_top_wrapper_tb ${ADD_XILINX} \
  ${IP_CONFIG_PATH} \
  ${DEFINES} \
  -f ${MODEM80211BCOREDIR}/modem802_11b_core/cfg/modem802_11b_core.list \
  -f rw_he_top_rtl_files.list \
  -f rw_he_top_tb_files.list \
  -work rw_he_top_lib \
  -s -input scripts/simu_run -log_ncvlog ncvlog.log

