//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of rw_he_top module
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`ifdef  RW_EMBEDDED_LA128
  `define RW_LA_RAM_DATAWIDTH 128
`else //RW_EMBEDDED_LA128
  `define RW_LA_RAM_DATAWIDTH 64
`endif//RW_EMBEDDED_LA128

`default_nettype none
module rw_he_top
(
  /*****************************************************************************
  //$port_g Resets inputs 
  *****************************************************************************/
  //$port_g rw_nx_platform resets
  input  wire             plf_rst_n,       // Active low hard reset signal synchronized to the plf_clk.
  input  wire             mac_core_rst_n,  // Active low hard reset signal synchronized to the mac_core_clk.
  input  wire             mac_wt_rst_n,    // Active low hard reset signal synchronized to the mac_wt_lk.
  input  wire             mac_mpif_rst_n,   // Active low hard reset signal synchronized to the PHY side mpif_clk.
  
  //$port_g HDMCore resets
  input  wire             phy_rst_n,       // Active low hard reset signal synchronized to the PhyMain
  input  wire             rxbd_rst_n,      // Active low hard reset signal synchronized to the vtb[01]_clk/ldpcrx0_clk
  input  wire             mdmb_rst_n,      // Active low hard reset signal synchronized to the mdmb
  //$port_g RIU resets
  input  wire             rc_rst_n,        // Active low hard reset signal synchronized to  Radio Controller
  input  wire             fe_rst_n,     // Active low hard reset signal synchronized to  FE 160 MHz
  input  wire             fe40_rst_n,      // Active low hard reset signal synchronized to  FE 40 MHz
`ifdef RW_NX_DERIV_FE_PATH40M
  input  wire             fe80_rst_n,      // Active low hard reset signal synchronized to  FE 80 MHz
`endif // RW_NX_DERIV_FE_PATH40M
  input  wire             fe44_rst_n,      // Active low hard reset signal synchronized to  Modem B Front End 
  input  wire             agc_rst_n,       // Active low hard reset signal synchronized to  AGC
`ifdef RW_RADAR_EN
  input  wire             radar_rst_n,     // Active low hard reset signal synchronized to  Radar
`endif
`ifdef  RW_EMBEDDED_LA
  //$port_g LA reset
  input  wire             la_rst_n,
`endif//RW_EMBEDDED_LA

  /*****************************************************************************
  //$port_g HDMCore reset request outputs
  *****************************************************************************/
  output wire             phywdog_hwrsten_n,   // Active low reset request for watchdog
  output wire             plf_swrsten_n,       // Active low sw reset request for platform

  /*****************************************************************************
  //$port_g Clocks inputs
  *****************************************************************************/
  //$port_g rw_nx_platform
  input  wire             mac_pi_clk,         // Primary MAC Platform Interface Clock
  input  wire             mac_pi_tx_clk,      // Secondary MAC Platform Interface Clock for TX
  input  wire             mac_pi_rx_clk,      // Secondary MAC Platform Interface Clock for RX
  input  wire             mac_core_clk,       // Primary MAC Core Clock
  input  wire             mac_core_tx_clk,    // Secondary MAC Core Clock for TX
  input  wire             mac_core_rx_clk,    // Secondary MAC Core Clock for RX
  input  wire             mac_crypt_clk,      // Secondary MAC Crypt Clock for CryptoEngine
  input  wire             mac_lp_clk,         // MAC Low Power clock.
  input  wire             mac_wt_clk,         // Clock input for WEP/TKIP blocks.
  input  wire             plf_clk,            // Platform Clock

  //$port_g hdm_core OFDM PHY
  input  wire             mpif_clk,           // MAC/PHY interface, common with MAC and PHY
  input  wire             macbypass_clk,      // MACBYPASS Gated clock
  input  wire             phy_clk,            // Main Gated Clock
  input  wire             phytx_clk,          // Tx path Gated Clock
  input  wire             tbe_clk,            // TBE Gated Clock
  input  wire             tdfoest_clk,        // TDFO Gated Clock
  input  wire             tdcomp_clk,         // TD compensation Gated Clock
  input  wire             channelest_clk,     // Channel Estimate Gated Clock
  input  wire             equ_clk,            // Equalizer Gated Clock
  input  wire             fdo_clk,            // FDO Gated Clock
  input  wire             fft0_clk,           // FFT 0 Gated Clock
`ifdef RW_BFMEE_EN
  input  wire             svd_clk,            // SVD free running clock
  input  wire             svd_gclk,           // SVD gated clock
`endif // RW_BFMEE_EN
  input  wire             vtb_clk,            // Rx All Viterbi gated clock
  input  wire             vtbcore0_clk,       // Rx Viterbi 0 Gated Clock
`ifdef RW_NX_LDPC_DEC
  input  wire             ldpcrx0_clk,
  input  wire             ldpcrx0_dec_clk,
`endif // RW_NX_LDPC_DEC
`ifdef RW_NX_LDPC_ENC
  input  wire             ldpc0tx0_clk,
`endif // RW_NX_LDPC_ENC

  //$port_g hdm_core DSSS PHY
  input  wire             mdmb_clk,           // DSSS Main Clock
  input  wire             mdmbrx_gclk,        // DSSS Rx path Gated Clock
  input  wire             mdmbtx_gclk,        // DSSS Tx path Gated Clock
 
  //$port_g RIU
  input  wire             rc_clk,             // Radio Controller Clock
  input  wire             fe_clk,             // Front End 160MHz Clock
  input  wire             fe40_clk,           // Front End 40MHz Clock
`ifdef RW_NX_DERIV_FE_PATH40M
  input  wire             fe80_clk,           // Front End 80MHz Clock
`endif // RW_NX_DERIV_FE_PATH40M
  input  wire             fe44_clk,           // Front End 44Mhz Clock
  input  wire             agc_clk,            // AGC Clock
  input  wire             agcmem_clk,         // AGC memory Clock
  input  wire             adcpow_clk,         // ADC power Clock
  input  wire             ferxpath_clk,       // Front End Rx 40MHz Clock
  input  wire             fetxpath_clk,       // Front End Tx 40MHz Clock

`ifdef RW_RADAR_EN
  input  wire             radar_clk,          // Radar Clock
`endif

  //$port_g LA
`ifdef  RW_EMBEDDED_LA
  input  wire             la_clk,
`endif//RW_EMBEDDED_LA

  /*****************************************************************************
  //$port_g Clock enable outputs
  *****************************************************************************/ 
  //$port_g rw_nx_platform
  output wire             platform_wake_up,   // Wake Up platform
  output wire             mac_lp_clkswitch,   // Switch MAC Lower Clock.
  output wire             mac_pi_clken,       // Clock Enable for macPriClk Clocks
  output wire             mac_pi_tx_clken,    // Clock Enable for macPITxClk Clock
  output wire             mac_pi_rx_clken,    // Clock Enable for macPIRxClk Clock
  output wire             mac_core_clken,     // Clock Enable for macCoreClk Clock
  output wire             mac_core_tx_clken,  // Clock Enable for macCoreTxClk Clock
  output wire             mac_core_rx_clken,  // Clock Enable for macCoreRxClk Clock
  output wire             mac_crypt_clken,    // Clock Enable for macCryptClk Clock
  output wire             mac_wt_clken,       // Clock Enable for macWTClk Clock
  output wire             mpif_clken,         // Clock Enable for mpIFClk Clock

  //$port_g RIU
  output wire             fe40_clken,         // Clock Enable for FE 40MHz Clock
`ifdef RW_NX_DERIV_FE_PATH40M
  output wire             fe80_clken,         // Clock Enable for FE 80MHz Clock
`endif // RW_NX_DERIV_FE_PATH40M
`ifdef RW_NX_DERIV_FE_PATH80M
  output wire             fe160_clken,        // Clock Enable for FE 160MHz Clock
`endif // RW_NX_DERIV_FE_PATH80M
  output wire             agc_clken,          // Clock Enable for AGC
  output wire             agcmem_clken,       // Clock Enable for AGC memory
  output wire             ferx_clken,         // Clock Enable for FE Rx Clock
  output wire             fetx_clken,         // Clock Enable for FE Tx Clock

  //$port_g PHY OFDM
  output wire             macbypass_clken,     // MACBYPASS Gated Clock Enable                
  output wire             phytx_clken,         // PHY Tx Path Clock Enable                   
  output wire             tbe_clken,           // TBE Gated Clock Enable
  output wire             tdfoest_clken,       // TDFO Gated Clock Enable
  output wire             tdcomp_clken,        // TD compensation Gated Clock Enable
  output wire             channelest_clken,    // Channel Estimate Gated Clock Enable                    
  output wire             equ_clken,           // Equalizer Gated Clock Enable                    
  output wire             fdo_clken,           // FDOl Gated Clock Enable                    
  output wire             fft0_clken,          // FFT 0 Gated Clock Enable                    
`ifdef RW_BFMEE_EN
  output wire             svd_clken,           // SVD Gated Clock Enable
`endif // RW_BFMEE_EN
  output wire             vtb_clken,           // Rx All Viterbi Gated Clock Enable
  output wire             vtbcore0_clken,      // Rx Viterbi 0 Gated Clock Enable
`ifdef RW_NX_LDPC_DEC
  output wire             ldpcrx0_clken,
  output wire             ldpcrx0_dec_clken,
`endif // RW_NX_LDPC_DEC
`ifdef RW_NX_LDPC_ENC
  output wire             ldpc0tx0_clken,
`endif // RW_NX_LDPC_ENC

  //$port_g PHY DSSS-CCK
  output wire             mdmb_clken,          // DSSS Main Clock Enable
  output wire             mdmbrx_clken,        // DSSS Rx path Gated Clock Enable
  output wire             mdmbtx_clken,        // DSSS Tx path Gated Clock Enable
  output wire             mdmb_clkskip,        // DSSS clock skip
 
  //$port_g HDMCore clock configuration
  output wire  [ 1:0]     mdmcfg_conf_bw,

  /*****************************************************************************
  //$port_g Processor (firmware)  AHB interface
  ************************************************************/
  output wire             proc_hready,         // Processor hready
  input  wire             proc_hready_in,      // Processor hready_in
  input  wire  [27:0]     proc_haddr,          // Processor haddr
  input  wire  [ 1:0]     proc_htrans,         // Processor htrans
  input  wire             proc_hwrite,         // Processor hwrite
  input  wire  [ 1:0]     proc_hsize,          // Processor hsize
  output wire  [31:0]     proc_hrdata,         // Processor hrdata
  input  wire  [31:0]     proc_hwdata,         // Processor hwdata
  output wire  [ 1:0]     proc_hresp,          // Processor hresp
  
  /*****************************************************************************
  //$port_g Interrupt sources
  *****************************************************************************/
`ifdef  RW_FPGA_AHB
  input  wire             fpga_irq,            // Interrupt from FPGA
`endif//RW_FPGA_AHB
  output wire             host_irq,            // Interrupt from host
  output wire  [95:20]    proc_irq,            // Interrupts to processor
  output wire             cpu_single_irq,      // Single Interrupt to processor (Active High)
  output wire             tick_timer_irq,      // Tick Timer Interrupt to processor (Active High)
  output wire             soft_irq,            // Soft Interrupt to processor (Active High)
  
  /*****************************************************************************
  //$port_g GPIO interface
  *****************************************************************************/
  output wire [31:0]      gpio_out,            // GPIO output
  input  wire [31:0]      gpio_in,             // GPIO input
  output wire [31:0]      gpio_oen,            // GPIO output enable
  
`ifdef RW_COEX_MODEL
  /*****************************************************************************
  //$port_g AHB to Coexistence interface
  *****************************************************************************/
  output wire             coexif_hready_in,    // Coexistence Interface hready_in
  output wire             coexif_hsel,         // Coexistence Interface hsel
  output wire  [8:0]      coexif_haddr,        // Coexistence Interface haddr
  output wire [ 1:0]      coexif_htrans,       // Coexistence Interface htrans
  output wire             coexif_hwrite,       // Coexistence Interface hwrite
  input  wire [31:0]      coexif_hrdata,       // Coexistence Interface hrdata
  output wire [31:0]      coexif_hwdata,       // Coexistence Interface hwdata
  input  wire [ 1:0]      coexif_hresp,        // Coexistence Interface hresp
  input  wire             coexif_hready,       // Coexistence Interface hready
`endif // RW_COEX_MODEL

`ifdef RW_WLAN_COEX_EN
  /*****************************************************************************
  //$port_g Bluetooth Coexistence Interface
  *****************************************************************************/
  input  wire             coex_bt_tx,          // BT Transmission On-going
  input  wire             coex_bt_rx,          // BT Reception    On-going
  input  wire             coex_bt_event,       // BT Event        On-going
  output wire             coex_bt_tx_abort,    // BT Transmission Abort Request
  output wire             coex_bt_rx_abort,    // BT Reception    Abort Request
  input  wire [3:0]       coex_bt_pti,         // BT Packet Traffic Information
  input  wire [6:0]       coex_bt_channel,     // BT Channel (0-78)
  input  wire             coex_bt_bw,          // BT Bandwidth (0:1MHz, 1:2MHz)
`endif // RW_WLAN_COEX_EN

  /*****************************************************************************
  //$port_g RC Coexistence interface
  *****************************************************************************/
  output wire             rc_tx_abort,         // Radio Controller Transmission Abort Request
  output wire             rc_rx_abort,         // Radio Controller Reception    Abort Request
  
  /*****************************************************************************
  //$port_g AXI Interface
  *****************************************************************************/
  //$port_g  upstream interface
  output wire [ 3:0]      dma0_awid,           // DMA Upstream awid
  output wire [31:0]      dma0_awaddr,         // DMA Upstream awaddr
  output wire [ 7:0]      dma0_awlen,          // DMA Upstream awlen 
  output wire [ 2:0]      dma0_awsize,         // DMA Upstream awsize
  output wire [ 1:0]      dma0_awburst,        // DMA Upstream awburst
  output wire [11:0]      dma0_awuser,         // DMA Upstream awuser
  output wire             dma0_awvalid,        // DMA Upstream awvalid
  input  wire             dma0_awready,        // DMA Upstream awready
                                                 
  output wire [ 3:0]      dma0_wid,            // DMA Upstream wid
  output wire [63:0]      dma0_wdata,          // DMA Upstream wdata 
  output wire [ 7:0]      dma0_wstrb,          // DMA Upstream wstrb
  output wire             dma0_wlast,          // DMA Upstream wlast
  output wire             dma0_wvalid,         // DMA Upstream wvalid
  input  wire             dma0_wready,         // DMA Upstream wready
                                                 
  input  wire  [3:0]      dma0_bid,            // DMA Upstream bid
  input  wire  [1:0]      dma0_bresp,          // DMA Upstream bresp
  input  wire             dma0_bvalid,         // DMA Upstream bvalid
  output wire             dma0_bready,         // DMA Upstream bready

  //$port_g  downstream interface
  output wire [ 3:0]      dma1_arid,           // DMA Downstream arid
  output wire [31:0]      dma1_araddr,         // DMA Downstream araddr
  output wire [ 7:0]      dma1_arlen,          // DMA Downstream arlen
  output wire [ 2:0]      dma1_arsize,         // DMA Downstream arsize
  output wire [ 1:0]      dma1_arburst,        // DMA Downstream arburst
  output wire             dma1_arvalid,        // DMA Downstream arvalid
  input  wire             dma1_arready,        // DMA Downstream arready
                                              
  input  wire [ 3:0]      dma1_rid,            // DMA Downstream rid
  input  wire [63:0]      dma1_rdata,          // DMA Downstream rdata
  input  wire [ 1:0]      dma1_rresp,          // DMA Downstream rresp
  input  wire             dma1_rlast,          // DMA Downstream rlast
  input  wire             dma1_rvalid,         // DMA Downstream rvalid
  output wire             dma1_rready,         // DMA Downstream rready
  
  /*****************************************************************************
  //$port_g rw_nx_platform memories interface
  *****************************************************************************/
  //$port_g TxFIFO 64*38 Two Ports SRAM
  output wire                        mac_txfifo_ren,      // Transmit FIFO Read Enable.
  output wire [`TXFIFOADDRWIDTH-1:0] mac_txfifo_raddr,    // Transmit FIFO Read Address bus.
  input  wire [37:0]                 mac_txfifo_rdata,    // Transmit FIFO Read Data bus.
  output wire                        mac_txfifo_wen,      // Transmit FIFO Write Enable.
  output wire [`TXFIFOADDRWIDTH-1:0] mac_txfifo_waddr,    // Transmit FIFO Write Address bus.
  output wire [37:0]                 mac_txfifo_wdata,    // Transmit FIFO Write Data bus.

  //$port_g RxFIFO 64*36 Two Ports SRAM
  output wire                        mac_rxfifo_ren,      // Receive FIFO Read Enable.
  output wire [`RXFIFOADDRWIDTH-1:0] mac_rxfifo_raddr,    // Receive FIFO Read Address bus.
  input  wire [35:0]                 mac_rxfifo_rdata,    // Receive FIFO Read Data bus.
  output wire                        mac_rxfifo_wen,      // Receive FIFO Write Enable.
  output wire [`RXFIFOADDRWIDTH-1:0] mac_rxfifo_waddr,    // Receive FIFO Write Address bus.
  output wire [35:0]                 mac_rxfifo_wdata,    // Receive FIFO Write Data bus.

  //$port_g Key Storage RAM 64*187(315) Single Port SRAM
  output wire                            keystorage_en,    // Enable Key Storage RAM
  output wire                            keystorage_wen,   // Write Enable Key Storage RAM
  output wire  [`RW_KEY_INDEX_WIDTH-1:0] keystorage_addr,  // Key Storage RAM write data bus
  input  wire   [`RW_KEY_DATA_WIDTH-1:0] keystorage_rdata, // Key Storage RAM read data bus.
  output wire   [`RW_KEY_DATA_WIDTH-1:0] keystorage_wdata, // Key Storage RAM address bus.

  //$port_g RC4 PRNG 128*16 Two Ports SRAM
  input  wire  [15:0]                    sbox_mem_rdata,   // SBOX data bus from internal RAM
  output wire   [6:0]                    sbox_mem_waddr,   // SBOX address bus to internal RAM, port write
  output wire   [6:0]                    sbox_mem_raddr,   // SBOX address bus to internal RAM, port read
  output wire  [15:0]                    sbox_mem_wdata,   // SBOX data bus to internal RAM
  output wire   [1:0]                    sbox_mem_wen,     // SBOX write enable signal for internal RAM
  output wire                            sbox_mem_ren,     // SBOX read enable signal for internal RAM


  //$port_g MAC-PHY IF TX FIFO RAM 256*8 Two Ports SRAM
  output wire                            mpif_txfifo_ren,   // MAC-PHY Interface Transmit FIFO Read Enable.
  output wire [`MPIFTXADDRWIDTH-1:0]     mpif_txfifo_raddr, // MAC-PHY Interface Transmit FIFO Read Address bus.
  input  wire [ 7:0]                     mpif_txfifo_rdata, // MAC-PHY Interface Transmit FIFO Read Data bus.
  output wire                            mpif_txfifo_wen,   // MAC-PHY InterFace Transmit FIFO Write Enable.
  output wire [`MPIFTXADDRWIDTH-1:0]     mpif_txfifo_waddr, // MAC-PHY Interface Transmit FIFO Write Address bus.
  output wire [ 7:0]                     mpif_txfifo_wdata, // MAC-PHY Interface Transmit FIFO Write Data bus.

  //$port_g MAC-PHY IF RX FIFO RAM 64*8 Two Ports SRAM
  output wire                            mpif_rxfifo_ren,     // MAC-PHY Interface Receive FIFO Read Enable.
  output wire [`MPIFRXADDRWIDTH-1:0]     mpif_rxfifo_raddr,   // MAC-PHY Interface Receive FIFO Read Address bus.
  input  wire [ 7:0]                     mpif_rxfifo_rdata,   // MAC-PHY Interface Receive FIFO Read Data bus.
  output wire                            mpif_rxfifo_wen,     // MAC-PHY InterFace Receive FIFO Write Enable.
  output wire [`MPIFRXADDRWIDTH-1:0]     mpif_rxfifo_waddr,   // MAC-PHY Interface Receive FIFO Write Address bus.
  output wire [ 7:0]                     mpif_rxfifo_wdata,   // MAC-PHY Interface Receive FIFO Write Data bus.

  //$port_g MIB Table RAM 256*32 Single Port SRAM
  output wire                            mibtable_en,              // MIB Table Enable.
  output wire                            mibtable_wen,             // MIB Table Write Enable.
  output wire [ 7:0]                     mibtable_addr,            // MIB Table Address bus.
  input  wire [31:0]                     mibtable_rdata,           // MIB Table Read Data bus.
  output wire [31:0]                     mibtable_wdata,           // MIB Table Write Data bus.

  //$port_g Platform memory 32768/64 single sram port (one write enable per byte lane)
  output wire                            sharedram_en,         // Shared RAM Enable
  output wire [`RW_SHARED_RAM_ADDR_WIDTH-4:0] sharedram_addr,       // Shared RAM Address
  output wire [ 7:0]                     sharedram_wen,      // Shared RAM Write Byte Enable
  output wire [63:0]                     sharedram_wdata,    // Shared RAM Write Data
  input  wire [63:0]                     sharedram_rdata,    // Shared RAM Read Data

  //$port_g RSA Memory Single Port SRAM 
`ifdef  RW_HSU_RSA_EN
  output wire                             rsa_sram_en,       // RSA SRAM Enable
  output wire  [`RW_RSA_RAM_ADDWIDTH-1:0] rsa_sram_addr,     // RSA SRAM Address
  output wire                       [3:0] rsa_sram_wen,      // RSA SRAM Write Enable
  output wire [`RW_RSA_RAM_DATAWIDTH-1:0] rsa_sram_wdata,    // RSA SRAM Write Data
  input  wire [`RW_RSA_RAM_DATAWIDTH-1:0] rsa_sram_rdata,    // RSA SRAM Read  Data
`endif//RW_HSU_RSA_EN

  /*****************************************************************************
  //$port_g HDMCore memories interface
  *****************************************************************************/
  //$port_g FFT 0 buffer 0
  output wire [ 15:0]                    fftmem0_wen,      // FFT 0 Memory 0 Write Enable  
  output wire [  5:0]                    fftmem0_waddr,    // FFT 0 Memory 0 Write Address 
  output wire [239:0]                    fftmem0_wdata,    // FFT 0 Memory 0 Write Data    
  output wire [  5:0]                    fftmem0_raddr,    // FFT 0 Memory 0 Read Address  
  output wire                            fftmem0_ren,      // FFT 0 Memory 0 Read Enable   
  input  wire [239:0]                    fftmem0_rdata,    // FFT 0 Memory 0 Read Data     

  //$port_g FFT 0 buffer 1
  output wire [ 15:0]                    fftmem1_wen,      // FFT 0 Memory 1 Write Enable  
  output wire [  5:0]                    fftmem1_waddr,    // FFT 0 Memory 1 Write Address 
  output wire [239:0]                    fftmem1_wdata,    // FFT 0 Memory 1 Write Data    
  output wire [  5:0]                    fftmem1_raddr,    // FFT 0 Memory 1 Read Address  
  output wire                            fftmem1_ren,      // FFT 0 Memory 1 Read Enable   
  input  wire [239:0]                    fftmem1_rdata,    // FFT 0 Memory 1 Read Data     

  //$port_g FFT 0 buffer 2
  output wire [ 15:0]                    fftmem2_wen,      // FFT 0 Memory 2 Write Enable  
  output wire [  5:0]                    fftmem2_waddr,    // FFT 0 Memory 2 Write Address 
  output wire [239:0]                    fftmem2_wdata,    // FFT 0 Memory 2 Write Data    
  output wire [  5:0]                    fftmem2_raddr,    // FFT 0 Memory 2 Read Address  
  output wire                            fftmem2_ren,      // FFT 0 Memory 2 Read Enable   
  input  wire [239:0]                    fftmem2_rdata,    // FFT 0 Memory 2 Read Data     

  //$port_g FFT 0 buffer 3
  output wire [ 15:0]                    fftmem3_wen,      // FFT 0 Memory 3 Write Enable  
  output wire [  5:0]                    fftmem3_waddr,    // FFT 0 Memory 3 Write Address 
  output wire [239:0]                    fftmem3_wdata,    // FFT 0 Memory 3 Write Data    
  output wire [  5:0]                    fftmem3_raddr,    // FFT 0 Memory 3 Read Address  
  output wire                            fftmem3_ren,      // FFT 0 Memory 3 Read Enable   
  input  wire [239:0]                    fftmem3_rdata,    // FFT 0 Memory 3 Read Data     

  //$port_g FFT 0 buffer 4
  output wire [ 15:0]                    fftmem4_wen,      // FFT 0 Memory 4 Write Enable  
  output wire [  5:0]                    fftmem4_waddr,    // FFT 0 Memory 4 Write Address 
  output wire [303:0]                    fftmem4_wdata,    // FFT 0 Memory 4 Write Data    
  output wire [  5:0]                    fftmem4_raddr,    // FFT 0 Memory 4 Read Address  
  output wire                            fftmem4_ren,      // FFT 0 Memory 4 Read Enable   
  input  wire [303:0]                    fftmem4_rdata,    // FFT 0 Memory 4 Read Data     

  //$port_g FFT 0 buffer 5
  output wire [ 15:0]                    fftmem5_wen,      // FFT 0 Memory 5 Write Enable  
  output wire [  5:0]                    fftmem5_waddr,    // FFT 0 Memory 5 Write Address 
  output wire [303:0]                    fftmem5_wdata,    // FFT 0 Memory 5 Write Data    
  output wire [  5:0]                    fftmem5_raddr,    // FFT 0 Memory 5 Read Address  
  output wire                            fftmem5_ren,      // FFT 0 Memory 5 Read Enable   
  input  wire [303:0]                    fftmem5_rdata,    // FFT 0 Memory 5 Read Data     

`ifdef RW_NX_LDPC_ENC
  output wire [  4:0]                    ldpc0tx0_addr, 
  output wire                            ldpc0tx0_en,  
  output wire [  8:0]                    ldpc0tx0_wen,  
  output wire [ 80:0]                    ldpc0tx0_wdata,
  input  wire [ 80:0]                    ldpc0tx0_rdata,

  output wire [  4:0]                    ldpc0tx1_addr, 
  output wire                            ldpc0tx1_en,  
  output wire [  8:0]                    ldpc0tx1_wen,  
  output wire [ 80:0]                    ldpc0tx1_wdata,
  input  wire [ 80:0]                    ldpc0tx1_rdata,
`endif // RW_NX_LDPC_ENC

`ifdef RW_NX_LDPC_DEC
  /*****************************************************************************
  * LDPC 
  *****************************************************************************/
  /* Config data interface */
  output wire [`RW_LDPCCFGRAM_AWIDTH-1:0] ldpcrx0_cfg_addr,
  output wire             ldpcrx0_cfg_en,
  output wire             ldpcrx0_cfg_wen,
  output wire [28:0]      ldpcrx0_cfg_wdata,
  input  wire [28:0]      ldpcrx0_cfg_rdata,
  
  /*  LDPC0 Memories */
  // Cr _s
  output wire [6:0]       ldpcrx0_cr_waddr,   
  output wire [6:0]       ldpcrx0_cr_raddr,   
  output wire [485:0]     ldpcrx0_cr_wdata,   
  output wire             ldpcrx0_cr_ren,     
  output wire             ldpcrx0_cr_wen,     
  input  wire  [485:0]    ldpcrx0_cr_rdata,   
  // Vr _s
  output wire [4:0]       ldpcrx0_vr_waddr,   
  output wire [4:0]       ldpcrx0_vr_raddr,   
  output wire [647:0]     ldpcrx0_vr_wdata,   
  output wire             ldpcrx0_vr_ren,     
  output wire             ldpcrx0_vr_wen,     
  input  wire [647:0]     ldpcrx0_vr_rdata,   
  // VM _s
  output wire [4:0]       ldpcrx0_vmx_waddr,  
  output wire [4:0]       ldpcrx0_vmx_raddr,  
  output wire [647:0]     ldpcrx0_vmx_wdata,  
  output wire             ldpcrx0_vmx_ren,    
  output wire [`RW_NX_DERIV_LDPC_VMWE_WIDTH-1:0] ldpcrx0_vmx_wen,    
  input  wire [647:0]     ldpcrx0_vmx_rdata,  

  output wire [4:0]       ldpcrx0_vmy_waddr,  
  output wire [4:0]       ldpcrx0_vmy_raddr,  
  output wire [647:0]     ldpcrx0_vmy_wdata,  
  output wire             ldpcrx0_vmy_ren,    
  output wire [`RW_NX_DERIV_LDPC_VMWE_WIDTH-1:0] ldpcrx0_vmy_wen,
  input  wire [647:0]     ldpcrx0_vmy_rdata,  
  // HD _s
  output wire [4:0]       ldpcrx0_hd_waddr,   
  output wire [80:0]      ldpcrx0_hd_wdata,   

  output wire [4:0]       ldpcrx0_hdx_raddr,  
  input  wire [80:0]      ldpcrx0_hdx_rdata,  
  output wire             ldpcrx0_hdx_ren,    
  output wire             ldpcrx0_hdx_wen,    
  
  output wire [4:0]       ldpcrx0_hdy_raddr,  
  output wire             ldpcrx0_hdy_wen,  
  output wire             ldpcrx0_hdy_ren,    
  input  wire [80:0]      ldpcrx0_hdy_rdata,
`endif // RW_NX_LDPC_DEC

  //$port_g bdfd memory
  output wire             bdfd_wen,
  output wire [ 6:0]      bdfd_waddr,
  output wire [59:0]      bdfd_wdata, 
  output wire             bdfd_ren,
  output wire [ 6:0]      bdfd_raddr,
  input  wire [59:0]      bdfd_rdata,
  
`ifdef RW_BFMEE_EN
  //$port_g bfmee memory interface
  output  wire                            bfmee_en,    
  output  wire                            bfmee_wen,     
  output  wire [`RW_BFMEE_RAM_AWIDTH-1:0] bfmee_addr,
  output  wire [31:0]                     bfmee_wdata,  
  input   wire [31:0]                     bfmee_rdata,  
`endif
 
  //$port_g AGC
  output wire [7:0]       agcmem_addr,        // AGC Memory Address                   
  output wire             agcmem_en,          // AGC Memory Enable              
  output wire [1:0]       agcmem_wren,        // AGC Memory Write Enable               
  output wire [63:0]      agcmem_wrdata,      // AGC Memory Write Data                
  input  wire [63:0]      agcmem_rddata,      // AGC Memory Read Data                 

  //$port_g Radar detection
`ifdef RW_RADAR_EN
  output wire [8:0]       radarmem_addr,      // Radar Memory Address                   
  output wire             radarmem_en,        // Radar Memory Enable              
  output wire             radarmem_wren,      // Radar Memory Write Enable               
  output wire [9:0]       radarmem_wrdata,    // Radar Memory Write Data                
  input  wire [9:0]       radarmem_rddata,    // Radar Memory Read Data                 
`endif

  /*****************************************************************************
  //$port_g DAC Interface
  *****************************************************************************/
  output wire                            dac0_on,       // DAC power/clock Enable 0
  output wire                            dac0_en,       // DAC Data valid 0
  output wire [11:0]                     dac0_i,        // DAC Data I0
  output wire [11:0]                     dac0_q,        // DAC Data Q0
  
  /*****************************************************************************
  //$port_g ADC Interface
  *****************************************************************************/
  output wire                            adc0_on,             // ADC0 Power/Clock enable     
  input  wire [11:0]                     adc0_i,              // ADC0 Data I
  input  wire [11:0]                     adc0_q,              // ADC0 Data Q

  /*******************************************************************
  //$port_g RF interface
  *******************************************************************/
  //$port_g Reset output
  output wire                             rf_resetn,        // Active Low Reset for Radio
  
  //$port_g RF AGC Control
  output wire                             rf_agcfreeze,     // AGC freeze 
 
  //$port_g RF Test mode
  output  wire                            rf_tmode,         // Radio Test Mode
  
  //$port_g Fast write bus
  output wire  [7:0]                      rf_gpio,          // GPIO Data
  
  //$port_g SPI Interface
  input  wire                             rf_spi_in,        // SPI Interface In
  output wire                             rf_spi_ss_n,      // SPI Interface Slave Select
  output wire                             rf_spi_clk,       // SPI Interface Clock
  output wire                             rf_spi_out,       // SPI Interface Out

  //$port_g Tx/Rx switch
  output wire                             rf_trsw0,         // Radio Tx On 0
                                                                                    
  //$port_g External PA
  output wire                             rf_extpaon_ch0_5G9,  // Radio External PA Channel 0 5Ghz
  output wire                             rf_extpaon_ch0_2G4,  // Radio External PA Channel 0 2.4Ghz
  
  
  /*******************************************************************
  //$port_g Embedded LA
  *******************************************************************/
`ifdef  RW_EMBEDDED_LA
  output wire                            lamemwr_clk, // ??
  output wire                            lamemrd_clk, // ??
  
  output wire                            lamem_wen  ,
  output wire [15:0]                     lamem_waddr,
  output wire [`RW_LA_RAM_DATAWIDTH-1:0] lamem_wdata,
  output wire [15:0]                     lamem_raddr,
  input  wire [`RW_LA_RAM_DATAWIDTH-1:0] lamem_rdata,
`endif//RW_EMBEDDED_LA

`ifdef RW_FPGA_AHB
  /*****************************************************************************
  //$port_g  AHB to FPGA
  *****************************************************************************/
  output wire                            fpga_hready_in,  // FPGA hready_in
  output wire                            fpga_hsel,       // FPGA hsel
  output wire [19:0]                     fpga_haddr,      // FPGA haddr
  output wire [ 1:0]                     fpga_htrans,     // FPGA htrans
  output wire                            fpga_hwrite,     // FPGA hwrite
  input  wire [31:0]                     fpga_hrdata,     // FPGA hrdata
  output wire [31:0]                     fpga_hwdata,     // FPGA hwdata
  input  wire [ 1:0]                     fpga_hresp,      // FPGA hresp
  input  wire                            fpga_hready,     // FPGA hready
`endif // RW_FPGA_AHB

  /*****************************************************************************
  //$port_g  AHB to CRM
  *****************************************************************************/
  output wire                            crm_hready_in,  // crm hready_in
  output wire                            crm_hsel,       // crm hsel
  output wire [ 9:0]                     crm_haddr,      // crm haddr
  output wire [ 1:0]                     crm_htrans,     // crm htrans
  output wire                            crm_hwrite,     // crm hwrite
  input  wire [31:0]                     crm_hrdata,     // crm hrdata
  output wire [31:0]                     crm_hwdata,     // crm hwdata
  input  wire [ 1:0]                     crm_hresp,      // crm hresp
  input  wire                            crm_hready,     // crm hready

  /*****************************************************************************
  //$port_g Diagnostic Ports
  *****************************************************************************/
`ifdef  RW_EMBEDDED_LA
  input  wire  [7:0]                     la_sampling_freq,    // LA sampling frequency
`endif//RW_EMBEDDED_LA
  input  wire  [31:0]                    ext_diagport,        // Diagnostic port
  output wire                            reg_bootrom_enable,  // CPU Boot enable
  
  output wire [ 4:0]                     rw_nx_ss_diag,       // Diagnostic port to be used with IQ for source synchrone capture
  output wire [15:0]                     rw_nx_diag0,         // Diagnostic port
  output wire [15:0]                     rw_nx_diag1,         // Diagnostic port
  output wire [15:0]                     rw_nx_diag2,         // Diagnostic port
  output wire [15:0]                     rw_nx_diag3,         // Diagnostic port
  output wire [15:0]                     rw_nx_diag4,         // Diagnostic port
  output wire [15:0]                     rw_nx_diag5,         // Diagnostic port
  output wire [15:0]                     rw_nx_diag6,         // Diagnostic port
  output wire                            mac_internal_error,  // MAC internal Error
  input  wire                            mac_debug_ksr,       // Debug Key Storage RAM.
  output wire  [1:0]                     macbypass_trigger,   // MAC Bypass Trigger Port
  output wire                            reg_diag_trigger     // SW Trigger Port
  );
  
  /*****************************************************************************
  * declarations
  *****************************************************************************/
  // Number of 16 bits diagnostic port
`ifdef  RW_EMBEDDED_LA128
  localparam DIAG_PORT_NBR = 7;
`else //RW_EMBEDDED_LA128
  localparam DIAG_PORT_NBR = 3;
`endif//RW_EMBEDDED_LA128

  /*****************************************************************************
  * declarations
  *****************************************************************************/
  wire                              riu_irq_n;     // RIU Interrupt
  wire                              phy_irq_n;
  wire                              reg_fpgaa_reset_req;

  // RIUKarstTop
  // OFDM PHY datapath
  /* TX */ 

  /* RX  */
  wire                              RxDataTD20Valid;
  wire [12:0]                       RxDataTD20PI0;
  wire [12:0]                       RxDataTD20PQ0;
  wire [12:0]                       RxDataTD20SI0;
  wire [12:0]                       RxDataTD20SQ0;
  wire                              RxDataTD40Valid;
  wire [12:0]                       RxDataTD40PI0;
  wire [12:0]                       RxDataTD40PQ0;
  wire                              RxDataTD80Valid;
  wire [12:0]                       RxDataTD80PI0;
  wire [12:0]                       RxDataTD80PQ0;
 
  // DSSS PHY datapath
  /* TX */
  wire                              DSSSTxDataEn;
  wire [ 6:0]                       DSSSTxDataI;
  wire [ 6:0]                       DSSSTxDataQ;       
  /* RX */
  wire                              DSSSRxDataEn;
  wire [ 6:0]                       DSSSRxDataI;
  wire [ 6:0]                       DSSSRxDataQ;
  
  // RIU / AGC interface
  wire                              AGCRifsDetected;
  wire                              AGCOFDMLock;
  wire                              AGCOFDMHTSTF;
  wire                              AGCDSSSLock;
  wire [7:0]                        AGCP1SNR;           // SNR value from AGC module
  wire [7:0]                        AGCP1NoiseVardB;    // Noise variance in dB from AGC module
  wire                              AGCP1Update;
  wire [1:0]                        AGCRegPSSelect;
  wire [7:0]                        AGCP2Rssi1;
  wire [7:0]                        AGCP2RxAntennaset;
  wire                              AGCP2Update;
  wire                              AGCCCAPrimary20;
  wire                              AGCCCASecondary20;
  wire                              AGCCCASecondary40;
                                    
  wire                              AGCOn;                
  wire                              AGCKeepRFOn;
                                    
  wire                              AGCSFDFound;
  wire                              AGCDemodRun;
  wire                              AGCStartP;            
  wire                              AGCPlatFallP;         
  wire                              AGCGainUpdateP;       
  wire                              AGCVHTFrame;          
  wire                              AGCNoACIMargin;          
  wire                              AGCBWSup20;           
  wire                              AGCBWEq20;            
  wire                              AGCBWEq40;            
  wire                              AGCBWEq80;
  wire                              CCALSigValid;         
  wire                              CCAHTSigVHTSigAValid; 
  wire                              AGCRxEndTiming;
  wire                              AGCFrameParamUpdate;
  wire [6:0]                        AGCFrameParamMCS;
  wire                              AGCLegFrame;
  wire [7:0]                        AGCFOAngle;
  wire [3:0]                        AGCFrameParamLegRate;
  
  wire                              RxFEEnDSSS;
  
  // RC 
  wire [2:0]                        RCNRx;
  
  // 
  // Bus interface with RIU / AGC / Radar
  wire [31:0]                       RegBusRData;
  wire [15:0]                       RegBusAddr;
  wire                              RegBusRdEn;
  wire                              RegBusWrEn;
  wire [31:0]                       RegBusWData;
  wire                              RegBusReady;

  // End of RIUKarstTop

  // AHB to PHY interface (master gasket)
  wire           plf_hready_in;
  wire [27:0]    plf_haddr;    
  wire           plf_hsel;     
  wire [ 1:0]    plf_htrans;   
  wire           plf_hwrite;   
  wire [ 1:0]    plf_hsize;    
  wire [31:0]    plf_hwdata;   
  reg  [31:0]    plf_hrdata;   
  reg  [ 1:0]    plf_hresp;    
  reg            plf_hready;   
  
  // PHY AHB control signals
  reg            plf_hsel_phy,           plf_hsel_macbyp;     
  wire [31:0]    plf_hrdata_phy,         plf_hrdata_macbyp; 
  wire [ 1:0]    plf_hresp_phy,          plf_hresp_macbyp;  
  wire           plf_hready_phy,         plf_hready_macbyp; 
  
  // TODO
  reg            plf_hsel_riu_karst;   
  wire [31:0]    plf_hrdata_riu_karst; 
  wire [ 1:0]    plf_hresp_riu_karst;  
  wire           plf_hready_riu_karst; 

  reg  [1:0]     ahb_slave;
  reg  [1:0]     ahb_slave_1t;
  
  // MAC to MACBYPASS interface
  wire           mac_mpif_txreq;             // Tx request
  wire [ 7:0]    mac_mpif_txdata;            // Tx data
  wire           mac_mpif_macdatavalid;      // Data valid
  wire           mac_mpif_mimocmdvalid;      // Mimo command
  wire           mac_mpif_phyrdy;            // Data valid signal
  wire           mac_mpif_txend_p;           // End of transaction
  wire           mac_mpif_rxreq;             // Rx request
  wire [ 7:0]    mac_mpif_rxdata;            // Rx data
  wire           mac_mpif_cca_pri20;         // CCA on Primary 20MHz channel
  wire           mac_mpif_cca_sec20;         // CCA on Secondary 20MHz channel
  wire           mac_mpif_cca_sec40;         // CCA on Secondary 40MHz channel
  wire           mac_mpif_rxendfortiming_p;  // End of transmission (antenna)
  wire           mac_mpif_rxerr_p;           // Rx error
  wire           mac_mpif_rxend_p;           // Rx end
  wire           mac_mpif_keeprfon;          // Keep RF on
  wire           mac_mpif_phyerr_p;          // Phy error
  wire           mac_mpif_rifsrxdetected;    // RIFS detected

  // MACBYPASS to PHY interface
  wire           phy_mpif_txreq;             // Tx request
  wire [ 7:0]    phy_mpif_txdata;            // Tx data
  wire           phy_mpif_macdatavalid;      // Data valid
  wire           phy_mpif_mimocmdvalid;      // Mimo command
  wire           phy_mpif_phyrdy;            // Data valid signal
  wire           phy_mpif_txend_p;           // End of transaction
  wire           phy_mpif_rxreq;             // Rx request
  wire [ 7:0]    phy_mpif_rxdata;            // Rx data
  wire           phy_mpif_cca_pri20;         // CCA on Primary 20MHz channel
  wire           phy_mpif_cca_sec20;         // CCA on Secondary 20MHz channel
  wire           phy_mpif_cca_sec40;         // CCA on Secondary 40MHz channel
  wire           phy_mpif_rxendfortiming_p;  // End of transmission (antenna)
  wire           phy_mpif_rxerr_p;           // Rx error
  wire           phy_mpif_rxend_p;           // Rx end
  wire           phy_mpif_keeprfon;          // Keep RF on
  wire           phy_mpif_phyerr_p;          // Phy error
  wire           phy_mpif_rifsrxdetected;    // RIFS detected

  // MPIF Interface masked signals
  wire [7:0]     mac_mpif_rxdata_masked;
  wire [7:0]     mac_mpif_txdata_masked;
  wire           mac_mpif_macdatavalid_masked;
  wire           mac_mpif_phyrdy_masked;

  // MPIF Interface muxed signals
  wire [7:0]     mac_mpif_rxdata_txdata;
  wire           mac_mpif_rxend_txend_p;
  wire           mac_mpif_rxerr_phyerr_p;
  wire           mac_mpif_cca_sec20_macdatavalid;

`ifdef RW_BFMEE_EN
  // MAC to BFR MPIF interface
  wire           mac_bfr_start;              // BFR computation started
  wire           mac_bfr_done;               // Beamforming Report computation is done

  wire [1:0]     mac_bfr_ch_bw;              // Beamforming report Channel Width
  wire [1:0]     mac_bfr_grouping;           // Bea?mforming report Grouping
  wire           mac_bfr_codebook;           // Beamforming report Codebook Information
  wire [1:0]     mac_bfr_feedback_type;      // Beamforming report Feedback Type
  wire [2:0]     mac_bfr_nr;                 // Beamforming report Nr Index
  wire [2:0]     mac_bfr_nc;                 // Beamforming report Nc Index
  wire           mac_bfr_he;                 // Beamforming report Format
                                             // (0:VHT or 1:HE)
  wire [6:0]     mac_bfr_he_rustartidx;      // Beamforming report RU Start index for HE
  wire [6:0]     mac_bfr_he_ruendidx;        // Beamforming report RU end index for HE
  
  wire [7:0]     mac_bfr_data;               // Beamforming report byte
  wire           mac_bfr_data_valid;         // Beamforming report byte valid          
  wire           mac_bfr_data_request;       // Beamforming report byte request
`endif // RW_BFMEE_EN

  
  /* MPIF */
  wire           macif_rfshutdown;  
  
  /* RC IF */
  wire           rc_tx_req;
  wire           rc_tx_ack;
  wire           rc_rx_req;
  wire           rc_rx_ack;
  wire           rc_tx1_update;
  wire           rc_tx1_ofdm_sel;
  wire [7:0]     rc_tx1_power;
  wire [7:0]     rc_tx1_ant;
  wire [2:0]     rc_tx1_ntx;
  wire           rc_tx1_sfo_bypass;
  wire [26:0]    rc_tx1_sfo;
  wire           rc_tx1_cfo_bypass;
  wire [24:0]    rc_tx1_cfo;
       
  /* RIU IF */
  wire           feif_tx_release;
  wire           feif_tx_underflow;
  wire           feif_tx_done;
  wire           feif_tx_ready;
  wire           feif_tx_enable;
  wire [12:0]    feif_tx_i,feif_tx_q;
  wire           feif_tx_last;
  wire           feif_tx_valid;
  
  /* HDM_CORE */
  wire [ 2:0]    mdmcfg_conf_primary;
  
`ifdef  RW_EMBEDDED_LA
  // LA interface
  wire                              la_hready_in;
  wire                              la_hsel;
  wire [20:0]                       la_haddr;
  wire [ 1:0]                       la_htrans;
  wire                              la_hwrite;
  wire [ 1:0]                       la_hsize;
  wire [31:0]                       la_hrdata;
  wire [31:0]                       la_hwdata;
  wire [ 1:0]                       la_hresp;
  wire                              la_hready;
  wire                              la_interrupt;
`endif//RW_EMBEDDED_LA

  // MAC Debug ports
  wire                              reg_diag_sel_en;
  wire  [1:0]                       reg_diag_sel0;
  wire  [1:0]                       reg_diag_sel1;
  wire  [1:0]                       reg_diag_sel2;
  wire  [1:0]                       reg_diag_sel3;
  wire  [1:0]                       reg_diag_sel4;
  wire  [1:0]                       reg_diag_sel5;
  wire  [1:0]                       reg_diag_sel6;
  wire  [5:0]                       reg_diag_presel0;
  wire  [5:0]                       reg_diag_presel1;
  wire  [5:0]                       reg_diag_presel2;
  wire  [5:0]                       reg_diag_presel3;
  wire  [5:0]                       reg_diag_presel4;
  wire  [5:0]                       reg_diag_presel5;
  wire  [5:0]                       reg_diag_presel6;
  wire                              reg_diag_mpif_mask_en;
  wire  [5:0]                       reg_diag_mpif_hdr_nbr;

  wire [ 2*DIAG_PORT_NBR-1:0]       reg_diag_sel;
  wire [ 6*DIAG_PORT_NBR-1:0]       reg_diag_presel;
  wire [16*DIAG_PORT_NBR-1:0]       diag_top;
  wire [16*DIAG_PORT_NBR-1:0]       diag_mac_hw;
  wire [16*DIAG_PORT_NBR-1:0]       diag_phy;
  wire [16*DIAG_PORT_NBR-1:0]       diag_riu;
  wire [16*DIAG_PORT_NBR-1:0]       rw_nx_diag;
  
  reg  [31:0]                       nx_mictor_test;
  reg  [31:0]                       nx_mictor_1t;
  reg  [31:0]                       nx_mictor_2t;
  wire [15:0]                       top_diag0;
  wire [15:0]                       top_diag1;
  wire [15:0]                       top_diag2;
  wire [15:0]                       top_diag3;
  wire [15:0]                       top_diag4;
  wire [15:0]                       top_diag5;
  wire [15:0]                       top_diag6;
  wire [15:0]                       top_diag7;
  wire [15:0]                       top_diag8;
  wire [15:0]                       top_diag9;
  wire [15:0]                       top_diag10;
  wire [15:0]                       top_diag11;
  wire [15:0]                       top_diag12;
  wire [15:0]                       top_diag13;
  wire [15:0]                       top_diag14;
  wire [15:0]                       top_diag15;
  wire [15:0]                       top_diag16;
  wire [15:0]                       top_diag17;
  wire [15:0]                       top_diag18;
  wire [15:0]                       top_diag19;
  wire [15:0]                       top_diag20;
  wire [15:0]                       top_diag21;
  wire [15:0]                       top_diag22;
  wire [15:0]                       top_diag23;
  wire [15:0]                       top_diag24;
  wire [15:0]                       top_diag25;
  wire [15:0]                       top_diag26;
  wire [15:0]                       top_diag27;
  wire [15:0]                       top_diag28;
  wire [15:0]                       top_diag29;
  wire [15:0]                       top_diag30;
  wire [15:0]                       top_diag31;
  wire [15:0]                       top_diag32;
  wire [15:0]                       top_diag33;
  wire [15:0]                       top_diag34;
  wire [15:0]                       top_diag35;
  wire [15:0]                       top_diag36;
  wire [15:0]                       top_diag37;
  wire [15:0]                       top_diag38;
  wire [15:0]                       top_diag39;
  wire [15:0]                       top_diag40;
  wire [15:0]                       top_diag41;
  wire [15:0]                       top_diag42;
  wire [15:0]                       top_diag43;
  wire [15:0]                       top_diag44;
  wire [15:0]                       top_diag45;
  wire [15:0]                       top_diag46;
  wire [15:0]                       top_diag47;
  wire [15:0]                       top_diag48;
  wire [15:0]                       top_diag49;
  wire [15:0]                       top_diag50;
  wire [15:0]                       top_diag51;
  wire [15:0]                       top_diag52;
  wire [15:0]                       top_diag53;
  wire [15:0]                       top_diag54;
  wire [15:0]                       top_diag55;
  wire [15:0]                       top_diag56;
  wire [15:0]                       top_diag57;
  wire [15:0]                       top_diag58;
  wire [15:0]                       top_diag59;
  wire [15:0]                       top_diag60;
  wire [15:0]                       top_diag61;
  wire [15:0]                       top_diag62;
  wire [15:0]                       top_diag63;
  wire [15:0]                       diag_mpif_diag_ctrl;
  wire [15:0]                       diag_mpif_mux;
  wire [15:0]                       diag_mpif_ctrl;
  wire [15:0]                       diag_mpif_data;
  wire [31:0]                       diag_platform0;    // Reference Platform Diagnostic port 0
  wire [31:0]                       diag_platform1;    // Reference Platform Diagnostic port 1
  wire [31:0]                       diag_platform2;    // Reference Platform Diagnostic port 2
  wire [63:0]                       diag_mac_sw;       // MAC SW Diagnostic Port
  wire [31:0]                       diag_coex;         // Coexistence Diagnostic Port
  wire [31:0]                       diag_dma_top;      // Dini DMA Diagnostic Port
  wire [15:0]                       diag_dma_downstream_axi0;// HOST DMA Diagnostic Port
  wire [15:0]                       diag_dma_downstream_axi1;// HOST DMA Diagnostic Port
  wire [15:0]                       diag_dma_downstream_axi2;// HOST DMA Diagnostic Port
  wire [31:0]                       diag_hsu;          // HSU Diagnostic Port
  wire [31:0]                       diag_la_adcdac;    // ADC, resynchronized on la_clk

  // MAC Debug port
  wire [15:0]                       mac_diag0;         // MAC HW Diagnostic port 0
  wire [15:0]                       mac_diag1;         // MAC HW Diagnostic port 1
  wire [15:0]                       mac_diag2;         // MAC HW Diagnostic port 2
  wire [15:0]                       mac_diag3;         // MAC HW Diagnostic port 3
  wire [15:0]                       mac_diag4;         // MAC HW Diagnostic port 4
  wire [15:0]                       mac_diag5;         // MAC HW Diagnostic port 5
  wire [15:0]                       mac_diag6;         // MAC HW Diagnostic port 6
  wire [15:0]                       mac_diag7;         // MAC HW Diagnostic port 7
  wire [15:0]                       mac_diag8;         // MAC HW Diagnostic port 8
  wire [15:0]                       mac_diag9;         // MAC HW Diagnostic port 9
  wire [15:0]                       mac_diag10;        // MAC HW Diagnostic port 10
  wire [15:0]                       mac_diag11;        // MAC HW Diagnostic port 11
  wire [15:0]                       mac_diag12;        // MAC HW Diagnostic port 12
  wire [15:0]                       mac_diag13;        // MAC HW Diagnostic port 13
  wire [15:0]                       mac_diag14;        // MAC HW Diagnostic port 14
  wire [15:0]                       mac_diag15;        // MAC HW Diagnostic port 15
  wire [15:0]                       mac_diag16;        // MAC HW Diagnostic port 16
  wire [15:0]                       mac_diag17;        // MAC HW Diagnostic port 17
  wire [15:0]                       mac_diag18;        // MAC HW Diagnostic port 18
  wire [15:0]                       mac_diag19;        // MAC HW Diagnostic port 19
  wire [15:0]                       mac_diag20;        // MAC HW Diagnostic port 20
  wire [15:0]                       mac_diag21;        // MAC HW Diagnostic port 21
  wire [15:0]                       mac_diag22;        // MAC HW Diagnostic port 22
  wire [15:0]                       mac_diag23;        // MAC HW Diagnostic port 23
  wire [15:0]                       mac_diag24;        // MAC HW Diagnostic port 24
  wire [15:0]                       mac_diag25;        // MAC HW Diagnostic port 25
  wire [15:0]                       mac_diag26;        // MAC HW Diagnostic port 26
  wire [15:0]                       mac_diag27;        // MAC HW Diagnostic port 27
  wire [15:0]                       mac_diag28;        // MAC HW Diagnostic port 28
  wire [15:0]                       mac_diag29;        // MAC HW Diagnostic port 29
  wire [15:0]                       mac_diag30;        // MAC HW Diagnostic port 30
  wire [15:0]                       mac_diag31;        // MAC HW Diagnostic port 31
  wire [15:0]                       mac_diag32;        // MAC HW Diagnostic port 32
  wire [15:0]                       mac_diag33;        // MAC HW Diagnostic port 33
  wire [15:0]                       mac_diag34;        // MAC HW Diagnostic port 34
  wire [15:0]                       mac_diag35;        // MAC HW Diagnostic port 35
  wire [15:0]                       mac_diag36;        // MAC HW Diagnostic port 36
  wire [15:0]                       mac_diag37;        // MAC HW Diagnostic port 37
  wire [15:0]                       mac_diag38;        // MAC HW Diagnostic port 38
  wire [15:0]                       mac_diag39;        // MAC HW Diagnostic port 39
  wire [15:0]                       mac_diag40;        // MAC HW Diagnostic port 40
  wire [15:0]                       mac_diag41;        // MAC HW Diagnostic port 41
  wire [15:0]                       mac_diag42;        // MAC HW Diagnostic port 42
  wire [15:0]                       mac_diag43;        // MAC HW Diagnostic port 43
  wire [15:0]                       mac_diag44;        // MAC HW Diagnostic port 44
  wire [15:0]                       mac_diag45;        // MAC HW Diagnostic port 45
  wire [15:0]                       mac_diag46;        // MAC HW Diagnostic port 46
  wire [15:0]                       mac_diag47;        // MAC HW Diagnostic port 47
  wire [15:0]                       mac_diag48;        // MAC HW Diagnostic port 48
  wire [15:0]                       mac_diag49;        // MAC HW Diagnostic port 49
  wire [15:0]                       mac_diag50;        // MAC HW Diagnostic port 50
  wire [15:0]                       mac_diag51;        // MAC HW Diagnostic port 51
  wire [15:0]                       mac_diag52;        // MAC HW Diagnostic port 52
  wire [15:0]                       mac_diag53;        // MAC HW Diagnostic port 53
  wire [15:0]                       mac_diag54;        // MAC HW Diagnostic port 54
  wire [15:0]                       mac_diag55;        // MAC HW Diagnostic port 55
  wire [15:0]                       mac_diag56;        // MAC HW Diagnostic port 56
  wire [15:0]                       mac_diag57;        // MAC HW Diagnostic port 57
  wire [15:0]                       mac_diag58;        // MAC HW Diagnostic port 58
  wire [15:0]                       mac_diag59;        // MAC HW Diagnostic port 59
  wire [15:0]                       mac_diag60;        // MAC HW Diagnostic port 60
  wire [15:0]                       mac_diag61;        // MAC HW Diagnostic port 61
  // PHY debug ports
  wire [15:0]                       phy_diag0;
  wire [15:0]                       phy_diag1;
  wire [15:0]                       phy_diag2;
  wire [15:0]                       phy_diag3;
  wire [15:0]                       phy_diag4;
  wire [15:0]                       phy_diag5;
  wire [15:0]                       phy_diag6;
  wire [15:0]                       phy_diag7;
  wire [15:0]                       phy_diag8;
  wire [15:0]                       phy_diag9;
  wire [15:0]                       phy_diag10;
  wire [15:0]                       phy_diag13;
  wire [15:0]                       phy_diag14;
  wire [15:0]                       phy_diag15;
  wire [15:0]                       phy_diag16;
  wire [15:0]                       phy_diag17;
  wire [15:0]                       phy_diag18;
  wire [15:0]                       phy_diag19;
  wire [15:0]                       phy_diag20;
  wire [15:0]                       phy_diag21;
  wire [15:0]                       phy_diag22;
  wire [15:0]                       phy_diag23;
  wire [15:0]                       phy_diag24;
  wire [15:0]                       phy_diag25;
  wire [15:0]                       phy_diag28;
  wire [15:0]                       phy_diag29;
  wire [15:0]                       phy_diag30;
  wire [15:0]                       phy_diag31;
  wire [15:0]                       phy_diag32;
  wire [15:0]                       phy_diag33;
  wire [15:0]                       phy_diag34;
  wire [15:0]                       phy_diag35;
  wire [15:0]                       phy_diag36;
  wire [15:0]                       phy_diag37;
  wire [15:0]                       phy_diag38;
  wire [15:0]                       phy_diag39;
  wire [15:0]                       phy_diag40;
  wire [15:0]                       phy_diag41;
  wire [15:0]                       phy_diag42;
  wire [15:0]                       phy_diag51;
  wire [15:0]                       phy_diag52;
  wire [15:0]                       phy_diag53;
  wire [15:0]                       phy_diag56;
  wire [15:0]                       phy_diag57;
  wire [15:0]                       phy_diag58;
  wire [15:0]                       phy_diag59;
  wire [15:0]                       phy_diag60;
  wire [15:0]                       phy_diag61;
  wire [15:0]                       phy_diag62;

  // RIU debug ports
  wire [15:0]                       riu_diag0;
  wire [15:0]                       riu_diag1;
  wire [15:0]                       riu_diag2;
  wire [15:0]                       riu_diag3;
  wire [15:0]                       riu_diag4;
  wire [15:0]                       riu_diag5;
  wire [15:0]                       riu_diag6;
  wire [15:0]                       riu_diag7;
  wire [15:0]                       riu_diag8;
  wire [15:0]                       riu_diag9;
  wire [15:0]                       riu_diag10;
  wire [15:0]                       riu_diag11;
  wire [15:0]                       riu_diag12;
  wire [15:0]                       riu_diag13;
  wire [15:0]                       riu_diag14;

  // MPIF Diag control
  wire                              diag_mpif_mask;    // Indicates that the MPIF data
                                                       // should be masked.
   
  /*****************************************************************************
  * platform instance
  *****************************************************************************/

  assign plf_swrsten_n = ~reg_fpgaa_reset_req;

  /* RW NX Platform instance */
  rw_nx_platform u_rw_nx_platform 
  (
    .plf_rst_n(                         plf_rst_n),
    .mac_core_rst_n(                    mac_core_rst_n),
    .mac_wt_rst_n(                      mac_wt_rst_n),
    .mpif_rst_n(                        mac_mpif_rst_n),
    //
    .mac_pi_clk(                        mac_pi_clk),
    .mac_pi_tx_clk(                     mac_pi_tx_clk),
    .mac_pi_rx_clk(                     mac_pi_rx_clk),
    .mac_core_clk(                      mac_core_clk),
    .mac_core_tx_clk(                   mac_core_tx_clk),
    .mac_core_rx_clk(                   mac_core_rx_clk),
    .mac_crypt_clk(                     mac_crypt_clk),
    .mac_lp_clk(                        mac_lp_clk),
    .mac_wt_clk(                        mac_wt_clk),
    .mpif_clk(                          mpif_clk),
    .plf_clk(                           plf_clk),
`ifdef RW_MUMIMO_SEC_USER1_EN
    .sec_u1_mac_pi_tx_clk(              ),
    .sec_u1_mac_core_tx_clk(            ),
    .sec_u1_mac_crypt_clk(              ),
    .sec_u1_mpif_clk(                   ),
`endif // RW_MUMIMO_SEC_USER1_EN
    //
    .platform_wake_up(                  platform_wake_up),
    .mac_pi_clken(                      mac_pi_clken),
    .mac_pi_tx_clken(                   mac_pi_tx_clken),
    .mac_pi_rx_clken(                   mac_pi_rx_clken),
    .mac_core_clken(                    mac_core_clken),
    .mac_core_tx_clken(                 mac_core_tx_clken),
    .mac_core_rx_clken(                 mac_core_rx_clken),
    .mac_crypt_clken(                   mac_crypt_clken),
    .mac_wt_clken(                      mac_wt_clken),
    .mpif_clken(                        mpif_clken),
    .mac_lp_clkswitch(                  mac_lp_clkswitch),
`ifdef RW_MUMIMO_SEC_USER1_EN
    .sec_u1_mac_pi_tx_clken(            ),
    .sec_u1_mac_core_tx_clken(          ),
    .sec_u1_mac_crypt_clken(            ),
    .sec_u1_mpif_clken(                 ),
`endif // RW_MUMIMO_SEC_USER1_EN
`ifdef  RW_FPGA_AHB
    .fpga_irq(                          fpga_irq),
`endif//RW_FPGA_AHB
    .host_irq(                          host_irq),
    .proc_irq(                          proc_irq),
    .cpu_single_irq(                    cpu_single_irq),
    .tick_timer_irq(                    tick_timer_irq),
    .soft_irq(                          soft_irq),
    .phy_irq_n(                         phy_irq_n),
    .rc_irq_n(                          riu_irq_n),
    .reg_diag_sel_en(                   reg_diag_sel_en),
    .reg_diag_sel6(                     reg_diag_sel6),
    .reg_diag_sel5(                     reg_diag_sel5),
    .reg_diag_sel4(                     reg_diag_sel4),
    .reg_diag_sel3(                     reg_diag_sel3),
    .reg_diag_sel2(                     reg_diag_sel2),
    .reg_diag_sel1(                     reg_diag_sel1),
    .reg_diag_sel0(                     reg_diag_sel0),
    .reg_diag_presel6(                  reg_diag_presel6),
    .reg_diag_presel5(                  reg_diag_presel5),
    .reg_diag_presel4(                  reg_diag_presel4),
    .reg_diag_presel3(                  reg_diag_presel3),
    .reg_diag_presel2(                  reg_diag_presel2),
    .reg_diag_presel1(                  reg_diag_presel1),
    .reg_diag_presel0(                  reg_diag_presel0),
    .reg_diag_trigger(                  reg_diag_trigger),
    .reg_diag_mpif_mask_en(             reg_diag_mpif_mask_en),
    .reg_diag_mpif_hdr_nbr(             reg_diag_mpif_hdr_nbr),
`ifdef  RW_EMBEDDED_LA
    .diag_value(                        nx_mictor_2t),
`else //RW_EMBEDDED_LA
    .diag_value(                        32'h0),
`endif//RW_EMBEDDED_LA
    .reg_bootrom_enable(                reg_bootrom_enable),
    .reg_fpgaa_reset_req(               reg_fpgaa_reset_req),
    .reg_fpgab_reset_req(               ),
    .nmb_io_busy(                       1'b0),
    .proc_hready(                       proc_hready),
    .proc_hready_in(                    proc_hready_in),
    .proc_haddr(                        proc_haddr),
    .proc_htrans(                       proc_htrans),
    .proc_hwrite(                       proc_hwrite),
    .proc_hsize(                        proc_hsize),
    .proc_hrdata(                       proc_hrdata),
    .proc_hwdata(                       proc_hwdata),
    .proc_hresp(                        proc_hresp),
    .dma0_awid(                         dma0_awid),
    .dma0_awaddr(                       dma0_awaddr),
    .dma0_awlen(                        dma0_awlen),
    .dma0_awsize(                       dma0_awsize),
    .dma0_awburst(                      dma0_awburst),
    .dma0_awuser(                       dma0_awuser),
    .dma0_awvalid(                      dma0_awvalid),
    .dma0_awready(                      dma0_awready),
    .dma0_wid(                          dma0_wid),
    .dma0_wdata(                        dma0_wdata),
    .dma0_wstrb(                        dma0_wstrb),
    .dma0_wlast(                        dma0_wlast),
    .dma0_wvalid(                       dma0_wvalid),
    .dma0_wready(                       dma0_wready),
    .dma0_bid(                          dma0_bid),
    .dma0_bresp(                        dma0_bresp),
    .dma0_bvalid(                       dma0_bvalid),
    .dma0_bready(                       dma0_bready),
    .dma1_arid(                         dma1_arid),
    .dma1_araddr(                       dma1_araddr),
    .dma1_arlen(                        dma1_arlen),
    .dma1_arsize(                       dma1_arsize),
    .dma1_arburst(                      dma1_arburst),
    .dma1_arvalid(                      dma1_arvalid),
    .dma1_arready(                      dma1_arready),
    .dma1_rid(                          dma1_rid),
    .dma1_rdata(                        dma1_rdata),
    .dma1_rresp(                        dma1_rresp),
    .dma1_rlast(                        dma1_rlast),
    .dma1_rvalid(                       dma1_rvalid),
    .dma1_rready(                       dma1_rready),
    .phy_hready_in(                     plf_hready_in),
    .phy_hsel(                          plf_hsel),
    .phy_haddr(                         plf_haddr),
    .phy_htrans(                        plf_htrans),
    .phy_hwrite(                        plf_hwrite),
    .phy_hsize(                         plf_hsize),
    .phy_hrdata(                        plf_hrdata),
    .phy_hwdata(                        plf_hwdata),
    .phy_hresp(                         plf_hresp),
    .phy_hready(                        plf_hready),
`ifdef  RW_EMBEDDED_LA
    .la_hready_in(                      la_hready_in),
    .la_hsel(                           la_hsel),
    .la_haddr(                          la_haddr),
    .la_htrans(                         la_htrans),
    .la_hwrite(                         la_hwrite),
    .la_hsize(                          la_hsize),
    .la_hrdata(                         la_hrdata),
    .la_hwdata(                         la_hwdata),
    .la_hresp(                          la_hresp),
    .la_hready(                         la_hready),
    .la_interrupt(                      la_interrupt),
`endif//RW_EMBEDDED_LA
`ifdef RW_FPGA_AHB
    .fpga_hready_in(                    fpga_hready_in),
    .fpga_hsel(                         fpga_hsel),
    .fpga_haddr(                        fpga_haddr),
    .fpga_htrans(                       fpga_htrans),
    .fpga_hwrite(                       fpga_hwrite),
    .fpga_hrdata(                       fpga_hrdata),
    .fpga_hwdata(                       fpga_hwdata),
    .fpga_hresp(                        fpga_hresp),
    .fpga_hready(                       fpga_hready),
`endif // RW_FPGA_AHB
    .crm_hready_in(                     crm_hready_in),
    .crm_hsel(                          crm_hsel),
    .crm_haddr(                         crm_haddr),
    .crm_htrans(                        crm_htrans),
    .crm_hwrite(                        crm_hwrite),
    .crm_hrdata(                        crm_hrdata),
    .crm_hwdata(                        crm_hwdata),
    .crm_hresp(                         crm_hresp),
    .crm_hready(                        crm_hready),
`ifdef RW_COEX_MODEL
    .coexif_hready_in(                  coexif_hready_in),
    .coexif_hsel(                       coexif_hsel),
    .coexif_haddr(                      coexif_haddr),
    .coexif_htrans(                     coexif_htrans),
    .coexif_hwrite(                     coexif_hwrite),
    .coexif_hrdata(                     coexif_hrdata),
    .coexif_hwdata(                     coexif_hwdata),
    .coexif_hresp(                      coexif_hresp),
    .coexif_hready(                     coexif_hready),
`endif
`ifdef RW_WLAN_COEX_EN
    .coex_bt_tx(                        coex_bt_tx),
    .coex_bt_rx(                        coex_bt_rx),
    .coex_bt_event(                     coex_bt_event),
    .coex_bt_tx_abort(                  coex_bt_tx_abort),
    .coex_bt_rx_abort(                  coex_bt_rx_abort),
    .coex_bt_pti(                       coex_bt_pti),
    .coex_bt_channel(                   coex_bt_channel),
    .coex_bt_bw(                        coex_bt_bw),
`endif
    .rc_tx_abort(                       rc_tx_abort),
    .rc_rx_abort(                       rc_rx_abort),
`ifdef RW_BFMEE_EN
    .bfr_start(                         mac_bfr_start),
    .bfr_done(                          mac_bfr_done),
    .bfr_ch_bw(                         mac_bfr_ch_bw),
    .bfr_grouping(                      mac_bfr_grouping),
    .bfr_codebook(                      mac_bfr_codebook),
    .bfr_feedback_type(                 mac_bfr_feedback_type),
    .bfr_nr(                            mac_bfr_nr),
    .bfr_nc(                            mac_bfr_nc),
    .bfr_he(                            mac_bfr_he),
    .bfr_he_rustartidx(                 mac_bfr_he_rustartidx),
    .bfr_he_ruendidx(                   mac_bfr_he_ruendidx),
    .bfr_data(                          mac_bfr_data),
    .bfr_data_valid(                    mac_bfr_data_valid),
    .bfr_data_ready(                    mac_bfr_data_request),
`endif //RW_BFMEE_EN
    .mac_debug_ksr(                     mac_debug_ksr),
    .mpif_txreq(                        mac_mpif_txreq),
    .mpif_txdata(                       mac_mpif_txdata),
    .mpif_macdatavalid(                 mac_mpif_macdatavalid),
    .mpif_mimocmdvalid(                 mac_mpif_mimocmdvalid),
    .mpif_phyrdy(                       mac_mpif_phyrdy),
    .mpif_txend_p(                      mac_mpif_txend_p),
    .mpif_rxreq(                        mac_mpif_rxreq),
    .mpif_rxdata(                       mac_mpif_rxdata),
    .mpif_cca_pri20(                    mac_mpif_cca_pri20),
    .mpif_cca_sec20(                    mac_mpif_cca_sec20),
    .mpif_cca_sec40(                    mac_mpif_cca_sec40),
    .mpif_rxendfortiming_p(             mac_mpif_rxendfortiming_p),
    .mpif_rxerr_p(                      mac_mpif_rxerr_p),
    .mpif_rxend_p(                      mac_mpif_rxend_p),
    .mpif_keeprfon(                     mac_mpif_keeprfon),
    .mpif_phyerr_p(                     mac_mpif_phyerr_p),
    .mpif_rifsrxdetected(               mac_mpif_rifsrxdetected),
    .mpif_rfshutdown(                   macif_rfshutdown),
`ifdef RW_MUMIMO_SEC_USER1_EN
    .mpif_txdata_u1(                    mac_mpif_txdata_u1),
    .mpif_macdatavalid_u1(              mac_mpif_macdatavalid_u1),
    .mpif_phyrdy_u1(                    mac_mpif_phyrdy_u1),
`endif // RW_MUMIMO_SEC_USER1_EN
    .tx_fifo_rd_en(                     mac_txfifo_ren),
    .tx_fifo_rd_addr(                   mac_txfifo_raddr),
    .tx_fifo_rd_data(                   mac_txfifo_rdata),
    .tx_fifo_wr_en(                     mac_txfifo_wen),
    .tx_fifo_wr_addr(                   mac_txfifo_waddr),
    .tx_fifo_wr_data(                   mac_txfifo_wdata),
`ifdef RW_MUMIMO_SEC_USER1_EN
    .sec_u1_tx_fifo_rd_en(              ),
    .sec_u1_tx_fifo_rd_addr(            ),
    .sec_u1_tx_fifo_rd_data(            ),
    .sec_u1_tx_fifo_wr_en(              ),
    .sec_u1_tx_fifo_wr_addr(            ),
    .sec_u1_tx_fifo_wr_data(            ),
`endif // RW_MUMIMO_SEC_USER1_EN
    .rx_fifo_rd_en(                     mac_rxfifo_ren),
    .rx_fifo_rd_addr(                   mac_rxfifo_raddr),
    .rx_fifo_rd_data(                   mac_rxfifo_rdata),
    .rx_fifo_wr_en(                     mac_rxfifo_wen),
    .rx_fifo_wr_addr(                   mac_rxfifo_waddr),
    .rx_fifo_wr_data(                   mac_rxfifo_wdata),
    .keystorage_en(                     keystorage_en),
    .keystorage_wr_en(                  keystorage_wen),
    .keystorage_addr(                   keystorage_addr),
    .keystorage_rd_data(                keystorage_rdata),
    .keystorage_wr_data(                keystorage_wdata),
    .sbox_mem_raddr(                    sbox_mem_raddr),          
    .sbox_mem_rdata(                    sbox_mem_rdata),          
    .sbox_mem_waddr(                    sbox_mem_waddr),          
    .sbox_mem_ren(                      sbox_mem_ren),            
    .sbox_mem_wen(                      sbox_mem_wen),            
    .sbox_mem_wdata(                    sbox_mem_wdata),      
    .mpif_tx_fifo_rd_en(                mpif_txfifo_ren),
    .mpif_tx_fifo_rd_addr(              mpif_txfifo_raddr),
    .mpif_tx_fifo_rd_data(              mpif_txfifo_rdata),
    .mpif_tx_fifo_wr_en(                mpif_txfifo_wen),
    .mpif_tx_fifo_wr_addr(              mpif_txfifo_waddr),
    .mpif_tx_fifo_wr_data(              mpif_txfifo_wdata),
`ifdef RW_MUMIMO_SEC_USER1_EN
    .sec_u1_mpif_tx_fifo_rd_en(         ),
    .sec_u1_mpif_tx_fifo_rd_addr(       ),
    .sec_u1_mpif_tx_fifo_rd_data(       ),
    .sec_u1_mpif_tx_fifo_wr_en(         ),
    .sec_u1_mpif_tx_fifo_wr_addr(       ),
    .sec_u1_mpif_tx_fifo_wr_data(       ),
`endif // RW_MUMIMO_SEC_USER2_EN
    .mpif_rx_fifo_rd_en(                mpif_rxfifo_ren),
    .mpif_rx_fifo_rd_addr(              mpif_rxfifo_raddr),
    .mpif_rx_fifo_rd_data(              mpif_rxfifo_rdata),
    .mpif_rx_fifo_wr_en(                mpif_rxfifo_wen),
    .mpif_rx_fifo_wr_addr(              mpif_rxfifo_waddr),
    .mpif_rx_fifo_wr_data(              mpif_rxfifo_wdata),
    .mib_table_en(                      mibtable_en),
    .mib_table_wr_en(                   mibtable_wen),
    .mib_table_addr(                    mibtable_addr),
    .mib_table_rd_data(                 mibtable_rdata),
    .mib_table_wr_data(                 mibtable_wdata),
    .shared_ram_en(                     sharedram_en),
    .shared_ram_addr(                   sharedram_addr),
    .shared_ram_wr_en(                  sharedram_wen),
    .shared_ram_wr_data(                sharedram_wdata),
    .shared_ram_rd_data(                sharedram_rdata),
`ifdef  RW_HSU_RSA_EN
    .rsa_sram_en(                       rsa_sram_en),
    .rsa_sram_addr(                     rsa_sram_addr),
    .rsa_sram_wr_en(                    rsa_sram_wen),
    .rsa_sram_din(                      rsa_sram_wdata),
    .rsa_sram_dout(                     rsa_sram_rdata),
`endif//RW_HSU_RSA_EN
    .diag_platform0(                    diag_platform0),
    .diag_platform1(                    diag_platform1),
    .diag_platform2(                    diag_platform2),
    .mac_diag0(                         mac_diag0),
    .mac_diag1(                         mac_diag1),
    .mac_diag2(                         mac_diag2),
    .mac_diag3(                         mac_diag3),
    .mac_diag4(                         mac_diag4),
    .mac_diag5(                         mac_diag5),
    .mac_diag6(                         mac_diag6),
    .mac_diag7(                         mac_diag7),
    .mac_diag8(                         mac_diag8),
    .mac_diag9(                         mac_diag9),
    .mac_diag10(                        mac_diag10),
    .mac_diag11(                        mac_diag11),
    .mac_diag12(                        mac_diag12),
    .mac_diag13(                        mac_diag13),
    .mac_diag14(                        mac_diag14),
    .mac_diag15(                        mac_diag15),
    .mac_diag16(                        mac_diag16),
    .mac_diag17(                        mac_diag17),
    .mac_diag18(                        mac_diag18),
    .mac_diag19(                        mac_diag19),
    .mac_diag20(                        mac_diag20),
    .mac_diag21(                        mac_diag21),
    .mac_diag22(                        mac_diag22),
    .mac_diag23(                        mac_diag23),
    .mac_diag24(                        mac_diag24),
    .mac_diag25(                        mac_diag25),
    .mac_diag26(                        mac_diag26),
    .mac_diag27(                        mac_diag27),
    .mac_diag28(                        mac_diag28),
    .mac_diag29(                        mac_diag29),
    .mac_diag30(                        mac_diag30),
    .mac_diag31(                        mac_diag31),
    .mac_diag32(                        mac_diag32),
    .mac_diag33(                        mac_diag33),
    .mac_diag34(                        mac_diag34),
    .mac_diag35(                        mac_diag35),
    .mac_diag36(                        mac_diag36),
    .mac_diag37(                        mac_diag37),
    .mac_diag38(                        mac_diag38),
    .mac_diag39(                        mac_diag39),
    .mac_diag40(                        mac_diag40),
    .mac_diag41(                        mac_diag41),
    .mac_diag42(                        mac_diag42),
    .mac_diag43(                        mac_diag43),
    .mac_diag44(                        mac_diag44),
    .mac_diag45(                        mac_diag45),
    .mac_diag46(                        mac_diag46),
    .mac_diag47(                        mac_diag47),
    .mac_diag48(                        mac_diag48),
    .mac_diag49(                        mac_diag49),
    .mac_diag50(                        mac_diag50),
    .mac_diag51(                        mac_diag51),
    .mac_diag52(                        mac_diag52),
    .mac_diag53(                        mac_diag53),
    .mac_diag54(                        mac_diag54),
    .mac_diag55(                        mac_diag55),
    .mac_diag56(                        mac_diag56),
    .mac_diag57(                        mac_diag57),
    .mac_diag58(                        mac_diag58),
    .mac_diag59(                        mac_diag59),
    .mac_diag60(                        mac_diag60),
    .mac_diag61(                        mac_diag61),
    .diag_mac_sw(                       diag_mac_sw),
    .diag_coex(                         diag_coex),
    .diag_dma_top(                      diag_dma_top),
    .diag_dma_downstream_axi0(          diag_dma_downstream_axi0),
    .diag_dma_downstream_axi1(          diag_dma_downstream_axi1),
    .diag_dma_downstream_axi2(          diag_dma_downstream_axi2),
    .diag_hsu(                          diag_hsu),
    .mac_internal_error(                mac_internal_error),
    .gpio_out(                          gpio_out),
    .gpio_in(                           gpio_in),
    .gpio_oen(                          gpio_oen)
  );
  

  /*****************************************************************************
  * MACBYPASS INSTANCE
  *****************************************************************************/
  wire macbypass_interrupt;
  assign phy_irq_n = ~macbypass_interrupt;
 
  rw_nx_macbypass u_macphy_bypass
  ( 
    /*************************************************************************
    * System
    *************************************************************************/
    .mpif_rst_n(               mac_mpif_rst_n),
    .ahb_rst_n(                plf_rst_n),
  
    .mpif_clk(                 macbypass_clk),
    .ahb_clk(                  plf_clk),
   
    /*************************************************************************
    * Clock Enable
    *************************************************************************/
    .mpif_clken(               macbypass_clken),
 
    /*************************************************************************
    * AHB
    *************************************************************************/
    .hready_in(                plf_hready_in),  
    .hsel(                     plf_hsel_macbyp),  
    .haddr(                    plf_haddr[9:0]),  
    .htrans(                   plf_htrans),  
    .hwrite(                   plf_hwrite),  
    .hwdata(                   plf_hwdata),
    .hrdata(                   plf_hrdata_macbyp), 
    .hresp(                    plf_hresp_macbyp),
    .hready(                   plf_hready_macbyp),
                                     
    /*************************************************************************
    * MAC/PHY 
    *************************************************************************/
    .mpifi_txreq(              mac_mpif_txreq),                                    
    .mpifi_txdata(             mac_mpif_txdata),                          
    .mpifi_macdatavalid(       mac_mpif_macdatavalid),                    
    .mpifi_mimocmdvalid(       mac_mpif_mimocmdvalid),                    
    .mpifi_phyrdy(             mac_mpif_phyrdy),                          
    .mpifi_txend(              mac_mpif_txend_p),                         
    .mpifi_rxreq(              mac_mpif_rxreq),                           
    .mpifi_rxdata(             mac_mpif_rxdata),                          
    .mpifi_cca_pri20(          mac_mpif_cca_pri20),                       
    .mpifi_cca_sec20(          mac_mpif_cca_sec20),                       
    .mpifi_cca_sec40(          mac_mpif_cca_sec40),                       
    .mpifi_rxendfortiming(     mac_mpif_rxendfortiming_p),                
    .mpifi_rxerr(              mac_mpif_rxerr_p),                         
    .mpifi_rxend(              mac_mpif_rxend_p),                         
    .mpifi_keeprfon(           mac_mpif_keeprfon),                        
    .mpifi_phyerr(             mac_mpif_phyerr_p),                        
    .mpifi_rifsrxdetected(     mac_mpif_rifsrxdetected),                  
   
    /*************************************************************************
    * MAC/PHY 
    *************************************************************************/
    .mpifo_txreq(              phy_mpif_txreq),                                    
    .mpifo_txdata(             phy_mpif_txdata),                        
    .mpifo_macdatavalid(       phy_mpif_macdatavalid),                  
    .mpifo_mimocmdvalid(       phy_mpif_mimocmdvalid),                    
    .mpifo_phyrdy(             phy_mpif_phyrdy),                          
    .mpifo_txend(              phy_mpif_txend_p),                         
    .mpifo_rxreq(              phy_mpif_rxreq),                           
    .mpifo_rxdata(             phy_mpif_rxdata),                          
    .mpifo_cca_pri20(          phy_mpif_cca_pri20),                       
    .mpifo_cca_sec20(          phy_mpif_cca_sec20),                       
    .mpifo_cca_sec40(          phy_mpif_cca_sec40),                       
    .mpifo_rxendfortiming(     phy_mpif_rxendfortiming_p),                
    .mpifo_rxerr(              phy_mpif_rxerr_p),                         
    .mpifo_rxend(              phy_mpif_rxend_p),                         
    .mpifo_keeprfon(           phy_mpif_keeprfon),                        
    .mpifo_phyerr(             phy_mpif_phyerr_p),                        
    .mpifo_rifsrxdetected(     phy_mpif_rifsrxdetected),                  
    /***************************************************************************
    * trigger
    ***************************************************************************/
    .trigger(                  macbypass_trigger),
    .interrupt(                macbypass_interrupt)
  );


  /*****************************************************************************
  * HDMCORE INSTANCE
  *****************************************************************************/
  assign plf_hresp_phy = 2'b00;

  hdm_core u_hdm_core
  (
    /***************************************************************************
    * CRM
    ***************************************************************************/
    .mpif_rst_n(                        phy_rst_n),           
    .phy_rst_n(                         phy_rst_n),            
    .ahb_rst_n(                         plf_rst_n),            
    .mdmb_rst_n(                        mdmb_rst_n),            
    .rxbd_rst_n(                        rxbd_rst_n),            
    .mpif_clk(                          mpif_clk),             
    .phy_clk(                           phy_clk),              
    .phytx_clk(                         phytx_clk),
    .tbe_clk(                           tbe_clk),
    .tdfoest_clk(                       tdfoest_clk),
    .tdcomp_clk(                        tdcomp_clk),
    .channelest_clk(                    channelest_clk),              
    .equ_clk(                           equ_clk),              
    .fdo_clk(                           fdo_clk),              
    .fft_clk(                           fft0_clk),              
    .ahb_clk(                           plf_clk),              
`ifdef RW_BFMEE_EN
    .svd_clk(                           svd_clk),
    .svd_gclk(                          svd_gclk),
`endif // RW_BFMEE_EN
    .vtb_clk(                           vtb_clk),
    .vtbcore0_clk(                      vtbcore0_clk),
    .mdmb_clk(                          mdmb_clk),
    .mdmbrx_gclk(                       mdmbrx_gclk),
    .mdmbtx_gclk(                       mdmbtx_gclk),
`ifdef RW_NX_LDPC_DEC
    .ldpcrx0_clk(                       ldpcrx0_clk),
    .ldpcrx0_dec_clk(                   ldpcrx0_dec_clk),
`endif // RW_NX_LDPC_DEC
`ifdef RW_NX_LDPC_ENC
    .ldpc0tx0_clk(                      ldpc0tx0_clk),
`endif // RW_NX_LDPC_ENC
   
    .phytx_clken(                       phytx_clken),
    .tbe_clken(                         tbe_clken),
    .tdfoest_clken(                     tdfoest_clken),
    .tdcomp_clken(                      tdcomp_clken),
    .channelest_clken(                  channelest_clken),              
    .equ_clken(                         equ_clken),              
    .fdo_clken(                         fdo_clken),              
    .fft_clken(                         fft0_clken),            
`ifdef RW_BFMEE_EN
    .svd_clken(                         svd_clken),
`endif // RW_BFMEE_EN
    .vtb_clken(                         vtb_clken),
    .vtbcore0_clken(                    vtbcore0_clken),
    .mdmb_clken(                        mdmb_clken),
    .mdmbrx_clken(                      mdmbrx_clken),
    .mdmbtx_clken(                      mdmbtx_clken),
    .mdmb_clkskip(                      mdmb_clkskip),
`ifdef RW_NX_LDPC_DEC
    .ldpcrx0_clken(                     ldpcrx0_clken),
    .ldpcrx0_dec_clken(                 ldpcrx0_dec_clken),
`endif // RW_NX_LDPC_DEC
`ifdef RW_NX_LDPC_ENC
    .ldpc0tx0_clken(                    ldpc0tx0_clken),
`endif // RW_NX_LDPC_ENC
    
    .watchdog_hwrsten_n(                phywdog_hwrsten_n),   

    .mdmcfg_conf_bw(                    mdmcfg_conf_bw),   
    .mdmcfg_conf_primary(               mdmcfg_conf_primary),   

    /***************************************************************************
    * AHB interface
    ***************************************************************************/
    .hsel(                              plf_hsel_phy),
    .hready_in(                         plf_hready_in),
    .haddr(                             plf_haddr[15:0]),
    .htrans(                            plf_htrans),
    .hwrite(                            plf_hwrite),
    .hrdata(                            plf_hrdata_phy),
    .hwdata(                            plf_hwdata),
    .hready(                            plf_hready_phy),
     
    /***************************************************************************
    * MAC/PHY data interface
    ***************************************************************************/
    .mac_txreq(                         phy_mpif_txreq),                      
    .mac_rxreq(                         phy_mpif_rxreq), 
    .mac_keeprfon(                      phy_mpif_keeprfon),          
    .mac_phyrdy(                        phy_mpif_phyrdy),           
    .mac_mimocmdvalid(                  phy_mpif_mimocmdvalid),    
    .mac_txdata(                        phy_mpif_txdata),          
    .mac_macdatavalid(                  phy_mpif_macdatavalid),      
    .mac_txend(                         phy_mpif_txend_p), 
    .mac_phyerr(                        phy_mpif_phyerr_p),
    .mac_rxdata(                        phy_mpif_rxdata),           
    .mac_rxerr(                         phy_mpif_rxerr_p),            
    .mac_rxend(                         phy_mpif_rxend_p),             
    .mac_rxendfortiming(                phy_mpif_rxendfortiming_p),    
    .mac_rxrifsdetected(                phy_mpif_rifsrxdetected),    
    .mac_cca_primary20(                 phy_mpif_cca_pri20),     
    .mac_cca_secondary20(               phy_mpif_cca_sec20),   
    .mac_cca_secondary40(               phy_mpif_cca_sec40),

`ifdef RW_BFMEE_EN
    /***************************************************************************
    * MAC/PHY SVD interface
    ***************************************************************************/
    .mac_bfr_start(                     mac_bfr_start),          
    .mac_bfr_done(                      mac_bfr_done),           
    .mac_bfr_ch_bw(                     mac_bfr_ch_bw),          
    .mac_bfr_grouping(                  mac_bfr_grouping),       
    .mac_bfr_codebook(                  mac_bfr_codebook),       
    .mac_bfr_feedback_type(             mac_bfr_feedback_type[0]),  
    .mac_bfr_nr(                        mac_bfr_nr[1:0]),
    .mac_bfr_nc(                        mac_bfr_nc[1:0]),
    .mac_bfr_he(                        mac_bfr_he),
    .mac_bfr_he_rustartidx(             mac_bfr_he_rustartidx[5:0]),  
    .mac_bfr_he_ruendidx(               mac_bfr_he_ruendidx[5:0]),    
    .mac_bfr_data(                      mac_bfr_data),           
    .mac_bfr_data_valid(                mac_bfr_data_valid),     
    .mac_bfr_data_request(              mac_bfr_data_request),   
`endif // RW_BFMEE_EN
    /***************************************************************************
    * RC interface
    ***************************************************************************/
    .rc_tx_req(                         rc_tx_req),
    .rc_tx_ack(                         rc_tx_ack),
    .rc_rx_req(                         rc_rx_req),
    .rc_rx_ack(                         rc_rx_ack),
    .rc_tx1_update(                     rc_tx1_update),
    .rc_tx1_ofdm_sel(                   rc_tx1_ofdm_sel),
    .rc_tx1_power(                      rc_tx1_power),
    .rc_tx1_ant(                        rc_tx1_ant),
    .rc_tx1_ntx(                        rc_tx1_ntx),
    .rc_tx1_sfo_bypass(                 rc_tx1_sfo_bypass), 
    .rc_tx1_sfo(                        rc_tx1_sfo),
    .rc_tx1_cfo_bypass(                 rc_tx1_cfo_bypass), 
    .rc_tx1_cfo(                        rc_tx1_cfo),
   
    /***************************************************************************
    * AGC interface
    ***************************************************************************/
    .agc_ofdm_lock(                     AGCOFDMLock),
    .agc_ofdm_htstf(                    AGCOFDMHTSTF),
    .agc_rxrifs_detected(               AGCRifsDetected),
    .agc_dsss_lock(                     AGCDSSSLock),
    .agc_p1_snr(                        AGCP1SNR),
    .agc_p1_noise_var_db(               AGCP1NoiseVardB),
    .agc_p1_update(                     AGCP1Update),
    .agc_p2_rx_antennaset(              AGCP2RxAntennaset),
    .agc_p2_rssi1(                      AGCP2Rssi1),
    .agc_p2_update(                     AGCP2Update),
    .agc_cca_primary20(                 AGCCCAPrimary20),
    .agc_cca_secondary20(               AGCCCASecondary20),
    .agc_sfd_found(                     AGCSFDFound),
    .agc_on(                            AGCOn),
    .agc_demod_run(                     AGCDemodRun),
    .agc_rxendtiming(                   AGCRxEndTiming),
    .agc_keep_rf_on(                    AGCKeepRFOn),
    .agc_lsig_valid(                    CCALSigValid),
    .agc_start_p(                       AGCStartP),
    .agc_gain_update_p(                 AGCGainUpdateP),
    .agc_tbe_count_valid(               ),
    .agc_plat_fall_p(                   AGCPlatFallP),
    .agc_vht_frame(                     AGCVHTFrame),
    .agc_no_aci_margin(                 AGCNoACIMargin),
    .agc_bw_sup20(                      AGCBWSup20),
    .agc_bw_eq20(                       AGCBWEq20),
    .agc_bw_eq40(                       AGCBWEq40),
    .agc_bw_eq80(                       AGCBWEq80),
    .agc_leg_frame(                     AGCLegFrame),
    .agc_fo_angle(                      AGCFOAngle),
    //
    .agc_htvhthesig_valid(              CCAHTSigVHTSigAValid),
    .agc_frameparam_update(             AGCFrameParamUpdate),
    .agc_frameparam_mcs(                AGCFrameParamMCS),
    .agc_frameparam_legrate(            AGCFrameParamLegRate),
    
    /***************************************************************************
    * FE interface
    ***************************************************************************/
    .feif_rx_20p_i0(                    RxDataTD20PI0),
    .feif_rx_20p_q0(                    RxDataTD20PQ0),
    .feif_rx_20s_i0(                    RxDataTD20SI0),
    .feif_rx_20s_q0(                    RxDataTD20SQ0),
    .feif_rx_valid_20(                  RxDataTD20Valid),
    .feif_rx_40p_i0(                    RxDataTD40PI0),
    .feif_rx_40p_q0(                    RxDataTD40PQ0),
    .feif_rx_valid_40(                  RxDataTD40Valid),
    .feif_rx_80p_i0(                    RxDataTD80PI0),
    .feif_rx_80p_q0(                    RxDataTD80PQ0),
    .feif_rx_valid_80(                  RxDataTD80Valid),
    
    .feif_tx_release(                   feif_tx_release),
    .feif_tx_done(                      feif_tx_done),
    .feif_tx_underflow(                 feif_tx_underflow),
    .feif_tx_ready(                     feif_tx_ready),
    .feif_tx_enable(                    feif_tx_enable),
    .feif_tx_i(                         feif_tx_i),
    .feif_tx_q(                         feif_tx_q),
    .feif_tx_last(                      feif_tx_last),
    .feif_tx_valid(                     feif_tx_valid),
    
    .feif_dsss_rx_i(                    DSSSRxDataI),
    .feif_dsss_rx_q(                    DSSSRxDataQ),
    .feif_dsss_tx_i(                    DSSSTxDataI),
    .feif_dsss_tx_q(                    DSSSTxDataQ),
    .feif_dsss_tx_valid(                DSSSTxDataEn),
    //
    .rx_dsss_fe_en(                     RxFEEnDSSS),
  
`ifdef RW_NX_LDPC_ENC
    /***************************************************************************
    * LDPC TX memory interface
    ***************************************************************************/
    .ldpc0tx0_en(                       ldpc0tx0_en),
    .ldpc0tx0_addr(                     ldpc0tx0_addr),
    .ldpc0tx0_wdata(                    ldpc0tx0_wdata),
    .ldpc0tx0_wen(                      ldpc0tx0_wen),
    .ldpc0tx0_rdata(                    ldpc0tx0_rdata),
    
    .ldpc0tx1_en(                       ldpc0tx1_en),
    .ldpc0tx1_addr(                     ldpc0tx1_addr),
    .ldpc0tx1_wdata(                    ldpc0tx1_wdata),
    .ldpc0tx1_wen(                      ldpc0tx1_wen),
    .ldpc0tx1_rdata(                    ldpc0tx1_rdata),
`endif // RW_NX_LDPC_ENC

`ifdef RW_NX_LDPC_DEC
    /***************************************************************************
    * LDPC RX memory interface
    ***************************************************************************/
    .ldpcrx0_cfg_addr(                  ldpcrx0_cfg_addr),
    .ldpcrx0_cfg_en(                    ldpcrx0_cfg_en),
    .ldpcrx0_cfg_wen(                   ldpcrx0_cfg_wen),
    .ldpcrx0_cfg_wdata(                 ldpcrx0_cfg_wdata),
    .ldpcrx0_cfg_rdata(                 ldpcrx0_cfg_rdata),
  
    .ldpcrx0_cr_waddr(                  ldpcrx0_cr_waddr),  
    .ldpcrx0_cr_raddr(                  ldpcrx0_cr_raddr),  
    .ldpcrx0_cr_wdata(                  ldpcrx0_cr_wdata),  
    .ldpcrx0_cr_ren(                    ldpcrx0_cr_ren),    
    .ldpcrx0_cr_wen(                    ldpcrx0_cr_wen),    
    .ldpcrx0_cr_rdata(                  ldpcrx0_cr_rdata),  
  
    .ldpcrx0_vr_waddr(                  ldpcrx0_vr_waddr),  
    .ldpcrx0_vr_raddr(                  ldpcrx0_vr_raddr),  
    .ldpcrx0_vr_wdata(                  ldpcrx0_vr_wdata),  
    .ldpcrx0_vr_ren(                    ldpcrx0_vr_ren),    
    .ldpcrx0_vr_wen(                    ldpcrx0_vr_wen),    
    .ldpcrx0_vr_rdata(                  ldpcrx0_vr_rdata),  
  
    .ldpcrx0_vmx_waddr(                 ldpcrx0_vmx_waddr), 
    .ldpcrx0_vmx_raddr(                 ldpcrx0_vmx_raddr), 
    .ldpcrx0_vmx_wdata(                 ldpcrx0_vmx_wdata), 
    .ldpcrx0_vmx_ren(                   ldpcrx0_vmx_ren),   
    .ldpcrx0_vmx_wen(                   ldpcrx0_vmx_wen),   
    .ldpcrx0_vmx_rdata(                 ldpcrx0_vmx_rdata), 

    .ldpcrx0_vmy_waddr(                 ldpcrx0_vmy_waddr), 
    .ldpcrx0_vmy_raddr(                 ldpcrx0_vmy_raddr), 
    .ldpcrx0_vmy_wdata(                 ldpcrx0_vmy_wdata), 
    .ldpcrx0_vmy_ren(                   ldpcrx0_vmy_ren),   
    .ldpcrx0_vmy_wen(                   ldpcrx0_vmy_wen),
    .ldpcrx0_vmy_rdata(                 ldpcrx0_vmy_rdata), 
  
    .ldpcrx0_hd_waddr(                  ldpcrx0_hd_waddr),  
    .ldpcrx0_hd_wdata(                  ldpcrx0_hd_wdata),  

    .ldpcrx0_hdx_raddr(                 ldpcrx0_hdx_raddr), 
    .ldpcrx0_hdx_rdata(                 ldpcrx0_hdx_rdata), 
    .ldpcrx0_hdx_ren(                   ldpcrx0_hdx_ren),   
    .ldpcrx0_hdx_wen(                   ldpcrx0_hdx_wen),   
  
    .ldpcrx0_hdy_raddr(                 ldpcrx0_hdy_raddr), 
    .ldpcrx0_hdy_wen(                   ldpcrx0_hdy_wen),  
    .ldpcrx0_hdy_ren(                   ldpcrx0_hdy_ren),   
    .ldpcrx0_hdy_rdata(                 ldpcrx0_hdy_rdata),
`endif // RW_NX_LDPC_DEC
    /***************************************************************************
    * FFT interface
    ***************************************************************************/
    .fftmem0_wen(                       fftmem0_wen),
    .fftmem0_waddr(                     fftmem0_waddr),
    .fftmem0_wdata(                     fftmem0_wdata),
    .fftmem0_ren(                       fftmem0_ren),
    .fftmem0_raddr(                     fftmem0_raddr),
    .fftmem0_rdata(                     fftmem0_rdata),

    .fftmem1_wen(                       fftmem1_wen),
    .fftmem1_waddr(                     fftmem1_waddr),
    .fftmem1_wdata(                     fftmem1_wdata),
    .fftmem1_ren(                       fftmem1_ren),
    .fftmem1_raddr(                     fftmem1_raddr),
    .fftmem1_rdata(                     fftmem1_rdata),

    .fftmem2_wen(                       fftmem2_wen),
    .fftmem2_waddr(                     fftmem2_waddr),
    .fftmem2_wdata(                     fftmem2_wdata),
    .fftmem2_ren(                       fftmem2_ren),
    .fftmem2_raddr(                     fftmem2_raddr),
    .fftmem2_rdata(                     fftmem2_rdata),

    .fftmem3_wen(                       fftmem3_wen),
    .fftmem3_waddr(                     fftmem3_waddr),
    .fftmem3_wdata(                     fftmem3_wdata),
    .fftmem3_ren(                       fftmem3_ren),
    .fftmem3_raddr(                     fftmem3_raddr),
    .fftmem3_rdata(                     fftmem3_rdata),

    .fftmem4_wen(                       fftmem4_wen),
    .fftmem4_waddr(                     fftmem4_waddr),
    .fftmem4_wdata(                     fftmem4_wdata),
    .fftmem4_ren(                       fftmem4_ren),
    .fftmem4_raddr(                     fftmem4_raddr),
    .fftmem4_rdata(                     fftmem4_rdata),

    .fftmem5_wen(                       fftmem5_wen),
    .fftmem5_waddr(                     fftmem5_waddr),
    .fftmem5_wdata(                     fftmem5_wdata),
    .fftmem5_ren(                       fftmem5_ren),
    .fftmem5_raddr(                     fftmem5_raddr),
    .fftmem5_rdata(                     fftmem5_rdata),
  
    /*****************************************************************************
    * bdfd mem
    *****************************************************************************/
    .bdfd_wen(                          bdfd_wen),
    .bdfd_waddr(                        bdfd_waddr),
    .bdfd_wdata(                        bdfd_wdata),
    .bdfd_ren(                          bdfd_ren),
    .bdfd_raddr(                        bdfd_raddr),
    .bdfd_rdata(                        bdfd_rdata),
    
`ifdef RW_BFMEE_EN
    /*****************************************************************************
    * bfmee mem
    *****************************************************************************/
    .bfmee_en(                          bfmee_en),    
    .bfmee_wen(                         bfmee_wen),      
    .bfmee_addr(                        bfmee_addr), 
    .bfmee_wdata(                       bfmee_wdata),   
    .bfmee_rdata(                       bfmee_rdata),   
`endif

    /***************************************************************************
    * Debug ports
    ***************************************************************************/
    .dbg_bank0(                         phy_diag0),
    .dbg_bank1(                         phy_diag1),
    .dbg_bank2(                         phy_diag2),
    .dbg_bank3(                         phy_diag3),
    .dbg_bank4(                         phy_diag4),
    .dbg_bank5(                         phy_diag5),
    .dbg_bank6(                         phy_diag6),
    .dbg_bank7(                         phy_diag7),
    .dbg_bank8(                         phy_diag8),
    .dbg_bank9(                         phy_diag9),
    .dbg_bank10(                        phy_diag10),
    .dbg_bank13(                        phy_diag13),
    .dbg_bank14(                        phy_diag14),
    .dbg_bank15(                        phy_diag15),
    .dbg_bank16(                        phy_diag16),
    .dbg_bank17(                        phy_diag17),
    .dbg_bank18(                        phy_diag18),
    .dbg_bank19(                        phy_diag19),
    .dbg_bank20(                        phy_diag20),
    .dbg_bank21(                        phy_diag21),
    .dbg_bank22(                        phy_diag22),
    .dbg_bank23(                        phy_diag23),
`ifdef RW_NX_LDPC_ENC
    .dbg_bank24(                        phy_diag24),
    .dbg_bank25(                        phy_diag25),
`endif // RW_NX_LDPC_ENC
`ifdef RW_NX_LDPC_DEC
    .dbg_bank28(                        phy_diag28),
    .dbg_bank29(                        phy_diag29),
    .dbg_bank30(                        phy_diag30),
    .dbg_bank31(                        phy_diag31),
    .dbg_bank32(                        phy_diag32),
    .dbg_bank33(                        phy_diag33),
    .dbg_bank34(                        phy_diag34),
    .dbg_bank35(                        phy_diag35),
    .dbg_bank36(                        phy_diag36),
    .dbg_bank37(                        phy_diag37),
    .dbg_bank38(                        phy_diag38),
`endif // RW_NX_LDPC_DEC
    .dbg_bank39(                        phy_diag39),
    .dbg_bank40(                        phy_diag40),
    .dbg_bank41(                        phy_diag41),
    .dbg_bank42(                        phy_diag42), 
`ifdef RW_BFMEE_EN
    .dbg_bank51(                        phy_diag51),
    .dbg_bank52(                        phy_diag52),
    .dbg_bank53(                        phy_diag53),
`endif // RW_BFMEE_EN
    .dbg_bank56(                        phy_diag56), 
    .dbg_bank57(                        phy_diag57), 
    .dbg_bank58(                        phy_diag58),
    .dbg_bank59(                        phy_diag59),
    .dbg_bank60(                        phy_diag60),
    .dbg_bank61(                        phy_diag61),
    .dbg_bank62(                        phy_diag62)
  );

`ifndef RW_NX_LDPC_ENC
  assign phy_diag24 = 16'd0;
  assign phy_diag25 = 16'd0;
`endif // RW_NX_LDPC_ENC
`ifndef RW_NX_LDPC_DEC
  assign phy_diag28 = 16'd0;
  assign phy_diag29 = 16'd0;
  assign phy_diag30 = 16'd0;
  assign phy_diag31 = 16'd0;
  assign phy_diag32 = 16'd0;
  assign phy_diag33 = 16'd0;
  assign phy_diag34 = 16'd0;
  assign phy_diag35 = 16'd0;
  assign phy_diag36 = 16'd0;
  assign phy_diag37 = 16'd0;
  assign phy_diag38 = 16'd0;
`endif // RW_NX_LDPC_DEC
`ifndef RW_BFMEE_EN
  assign phy_diag51 = 16'd0;
  assign phy_diag52 = 16'd0;
  assign phy_diag53 = 16'd0;
`endif // RW_BFMEE_EN
`ifndef RW_NX_DERIV_FE_PATH40M
  assign RxDataTD40Valid = 1'b0;
  assign RxDataTD40PI0   = 13'b0;
  assign RxDataTD40PQ0   = 13'b0;
`endif // RW_NX_DERIV_FE_PATH40M
`ifndef RW_NX_DERIV_FE_PATH80M
  assign RxDataTD80Valid = 1'b0;
  assign RxDataTD80PI0   = 13'b0;
  assign RxDataTD80PQ0   = 13'b0;
`endif // RW_NX_DERIV_FE_PATH80M

  // TODO RIUKarstTop: AHB slave to access RegBus registers
  assign plf_hresp_riu_karst = 2'd0; // TODO
  
  ahbslaveif u_ahbslaveif
  (
    /***************************************************************************
    * system
    ***************************************************************************/
    .clk(                                 plf_clk),
    .rst_n(                               plf_rst_n),
 
    /***************************************************************************
    * AHB slave
    ***************************************************************************/
    .hready_in(                           plf_hready_in),
    .hsel(                                plf_hsel_riu_karst), // todo
    .haddr(                               plf_haddr[15:0]),
    .htrans(                              plf_htrans),
    .hwrite(                              plf_hwrite),
    .hwdata(                              plf_hwdata),
    .hrdata(                              plf_hrdata_riu_karst), // todo
    .hready(                              plf_hready_riu_karst), // todo
 
    /***************************************************************************
    * register bus
    ***************************************************************************/
    .regbus_ready(                        RegBusReady),
    .regbus_addr(                         RegBusAddr),
    .regbus_rden(                         RegBusRdEn),
    .regbus_wren(                         RegBusWrEn),
    .regbus_wdata(                        RegBusWData),
    .regbus_rdata(                        RegBusRData)
  );
 
  // Forced unused RIU signals
  assign RCNRx = 3'd0; // only 1 Rx now

  /* RIU Instance */
  RIUKarstTop u_RIUKarstTop 
  (
    /*****************************************************************************
    * Resets
    *****************************************************************************/
    .nRegBusRst             (plf_rst_n),
    .nPhyRst                (phy_rst_n),
`ifdef RW_NX_DERIV_80211B
    .nFE44Rst               (fe44_rst_n),
`endif
    .nFERst                 (fe_rst_n),
    .nFE40Rst               (fe40_rst_n),
`ifdef RW_NX_DERIV_FE_PATH40M
    .nFE80Rst               (fe80_rst_n),
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    .nFE160Rst              (fe_rst_n),
`endif
    .nAGCRst                (agc_rst_n),
    .nRCRst                 (rc_rst_n),
`ifdef RW_RADAR_EN
    .nRadarTimRst           (radar_rst_n),
`endif   
    /*****************************************************************************
    * Clocks
    *****************************************************************************/
    /* regbus */
    .RegBusClk              (plf_clk),
    /* Front-end 44MHz */
`ifdef RW_NX_DERIV_80211B
    .FE44GClk               (fe44_clk),
`endif
    /* Front-end */
    .FERxPath0GClk          (ferxpath_clk),
    .FETxPath0GClk          (fetxpath_clk),
    .FE40Path0GClk          (fe40_clk),
`ifdef RW_NX_DERIV_FE_PATH40M
    .FE80Path0GClk          (fe80_clk),
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    .FE160Path0GClk         (fe_clk),
`endif
    /* PHY OFDM */
    .PhyClk                 (phy_clk),

    /* AGC and radar detection */
    .AGCGClk                (agc_clk),
    .AGCMemGClk             (agcmem_clk),
    .ADCPowGClk             (adcpow_clk),
`ifdef RW_RADAR_EN
    .RadarTimGClk           (radar_clk),
`endif   
    /* RC */
    .RCGClk                 (rc_clk),
    
    /*****************************************************************************
    * Clock enables
    *****************************************************************************/
    /* AGC */
    .AGCClkEn               (agc_clken),
    .AGCMemClkEn            (agcmem_clken),
    /* Frontend */
    .FERxClkEn              (ferx_clken),   
    .FETxClkEn              (fetx_clken),
    .FE40ClkEn              (fe40_clken),
`ifdef RW_NX_DERIV_FE_PATH40M
    .FE80ClkEn              (fe80_clken),
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    .FE160ClkEn             (fe160_clken),
`endif
    .FEPath0ClkEn           (),
    
    /*****************************************************************************
    * channel bandwidth (0=20M,1=40M,2=80M)
    *****************************************************************************/
    .CfgRegMdmConfBW        (mdmcfg_conf_bw),
    .CfgRegMdmConfPrimary   (mdmcfg_conf_primary),

    /*****************************************************************************
    * interrupt
    *****************************************************************************/
    .nInterrupt             (riu_irq_n),
   
    /*****************************************************************************
    * registers bank bus
    *****************************************************************************/
    .RegBusRdEn             (RegBusRdEn),
    .RegBusWrEn             (RegBusWrEn),
    .RegBusAddr             (RegBusAddr),
    .RegBusWrData           (RegBusWData),
    .RegBusReady            (RegBusReady),
    .RegBusRdData           (RegBusRData),

    /*****************************************************************************
    * HDMCore
    *****************************************************************************/
    .AGCRifsDetected        (AGCRifsDetected),
    .AGCOFDMLock            (AGCOFDMLock),
    .AGCOFDMHTSTF           (AGCOFDMHTSTF),
    .AGCDSSSLock            (AGCDSSSLock),
    .AGCP1SNR               (AGCP1SNR),           
    .AGCP1NoiseVardB        (AGCP1NoiseVardB),
    .AGCP1Update            (AGCP1Update),  
    .AGCP2Rssi1             (AGCP2Rssi1),
    .AGCP2RxAntennaset      (AGCP2RxAntennaset),  
    .AGCP2Update            (AGCP2Update),  
    .AGCCCAPrimary20        (AGCCCAPrimary20),
    .AGCCCASecondary20      (AGCCCASecondary20),
    .AGCCCASecondary40      (AGCCCASecondary40),
    .AGCOn                  (AGCOn),
    .AGCKeepRFOn            (AGCKeepRFOn),
    .AGCSFDFound            (AGCSFDFound),
    .AGCDemodRun            (AGCDemodRun),
    .AGCStartP              (AGCStartP),
    .AGCPlatFallP           (AGCPlatFallP),
    .AGCGainUpdateP         (AGCGainUpdateP),
    .AGCVHTFrame            (AGCVHTFrame),
    .AGCNoACIMargin         (AGCNoACIMargin),
    .AGCBWSup20             (AGCBWSup20),
    .AGCBWEq20              (AGCBWEq20),
    .AGCBWEq40              (AGCBWEq40),
    .AGCBWEq80              (AGCBWEq80),
    .AGCRxEndTiming         (AGCRxEndTiming),
    .AGCFrameParamUpdate    (AGCFrameParamUpdate),
    .AGCFrameParamMCS       (AGCFrameParamMCS),
`ifdef RW_NX_IQ_COMP_EN
    .AGCLegFrame            (AGCLegFrame),
    .AGCFOAngle             (AGCFOAngle),
    .AGCFrameParamLegRate   (AGCFrameParamLegRate),
`endif
    //
    .CCALSIGValid           (CCALSigValid),
    .CCAHTSigVHTSigAValid   (CCAHTSigVHTSigAValid),
    //
    .RxFEEnDSSS             (RxFEEnDSSS),
    
    /*****************************************************************************
    * RC
    *****************************************************************************/
    /* RX */
    .RCNRx                  (RCNRx),
    .RCRxOn                 (rc_rx_req),
    .RCRxAck                (rc_rx_ack),
    
    /* TX */
    .RCTxOn                 (rc_tx_req),
    .RCTxAck                (rc_tx_ack),
    .RCTx1Update            (rc_tx1_update),
    .RCTx1OFDMSel           (rc_tx1_ofdm_sel),
    .RCTx1Power             (rc_tx1_power),
    .RCTx1NTx               (rc_tx1_ntx),
    .RCTx1Ant               (rc_tx1_ant),
    .RCTx1SFOBypass         (rc_tx1_sfo_bypass),
    .RCTx1SFO               (rc_tx1_sfo),
    .RCTx1CFOBypass         (rc_tx1_cfo_bypass),
    .RCTx1CFO               (rc_tx1_cfo),
   
    /*****************************************************************************
    * OFDM PHY datapath
    *****************************************************************************/
    /* TX path 0*/ 
    .OFDMTxRelease          (feif_tx_release),
    .OFDMTxUnderflow        (feif_tx_underflow),
    .OFDMTxDone             (feif_tx_done),
    .OFDMTxReady            (feif_tx_ready),
    .OFDMTxI0               (feif_tx_i),
    .OFDMTxQ0               (feif_tx_q),
    .OFDMTxLast             (feif_tx_last),
    .OFDMTxValid            (feif_tx_valid),

    /* RX path 0 */
    .OFDMRx20Valid          (RxDataTD20Valid),
    .OFDMRx20PriI0          (RxDataTD20PI0),
    .OFDMRx20PriQ0          (RxDataTD20PQ0),
`ifdef RW_NX_DERIV_FE_PATH40M
    .OFDMRx20SecI           (RxDataTD20SI0),
    .OFDMRx20SecQ           (RxDataTD20SQ0),
    .OFDMRx40Valid          (RxDataTD40Valid),
    .OFDMRx40I0             (RxDataTD40PI0),
    .OFDMRx40Q0             (RxDataTD40PQ0),
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    .OFDMRx80Valid          (RxDataTD80Valid),
    .OFDMRx80I0             (RxDataTD80PI0),
    .OFDMRx80Q0             (RxDataTD80PQ0),
`endif

`ifdef RW_NX_DERIV_80211B
    /*****************************************************************************
    * DSSS PHY datapath
    *****************************************************************************/
    /* TX */
    .DSSSTxValid            (DSSSTxDataEn),
    .DSSSTxI                (DSSSTxDataI),
    .DSSSTxQ                (DSSSTxDataQ),
    /* RX */
    .DSSSRxValid            (DSSSRxDataEn),
    .DSSSRxI                (DSSSRxDataI),
    .DSSSRxQ                (DSSSRxDataQ),
`endif   
    /*****************************************************************************
    * memories
    *****************************************************************************/
    /* AGC */
    .AGCMemAddr             (agcmem_addr),
    .AGCMemEn               (agcmem_en),
    .AGCMemWrEn             (agcmem_wren),
    .AGCMemWrData           (agcmem_wrdata),
    .AGCMemRdData           (agcmem_rddata),
    
`ifdef RW_RADAR_EN
    //Radar detection
    .RadarMemAddr           (radarmem_addr),
    .RadarMemEn             (radarmem_en),
    .RadarMemWrEn           (radarmem_wren),
    .RadarMemWrData         (radarmem_wrdata),
    .RadarMemRdData         (radarmem_rddata),
`endif   

    /*****************************************************************************
    * Converters 
    *****************************************************************************/
    /* ADC */
    .ADCOn0                 (adc0_on),
    .ADCI0                  (adc0_i),
    .ADCQ0                  (adc0_q),
   
    /* DAC */
    .DACOn0                 (dac0_on),
    .DACEn0                 (dac0_en),
    .DACI0                  (dac0_i),
    .DACQ0                  (dac0_q),
    /*******************************************************************
    * RF interface
    *******************************************************************/
    .rf_resetn              (rf_resetn),
    .rf_interrupt           (1'b0),
    .rf_gpio                (rf_gpio),
    .rf_agcfreeze           (rf_agcfreeze),
    .rf_tmode               (rf_tmode),
   
    .rf_spi_in              (rf_spi_in),
    .rf_spi_ss_n            (rf_spi_ss_n),
    .rf_spi_clk             (rf_spi_clk),
    .rf_spi_out             (rf_spi_out),
    
    /*******************************************************************
    * RF daughter board control
    *******************************************************************/
    /* Tx/Rx switch */
    .rf_trsw0               (rf_trsw0),
    /* External PA */                                
    .rf_extpaon_ch0_5G9     (rf_extpaon_ch0_5G9),
    .rf_extpaon_ch0_2G4     (rf_extpaon_ch0_2G4),

    /*****************************************************************************
    * Coex
    *****************************************************************************/
`ifdef RW_WLAN_COEX_EN
    .rc_tx_abort            (rc_tx_abort),
    .rc_rx_abort            (rc_rx_abort),
`endif // RW_WLAN_COEX_EN

    /*****************************************************************************
    * debug/diag
    *****************************************************************************/
    .DbgBank0               (riu_diag0),
    .DbgBank1               (riu_diag1),
    .DbgBank2               (riu_diag2),
    .DbgBank3               (riu_diag3),
    .DbgBank4               (riu_diag4),
    .DbgBank5               (riu_diag5),
    .DbgBank6               (riu_diag6),
    .DbgBank7               (riu_diag7),
    .DbgBank8               (riu_diag8),
    .DbgBank9               (riu_diag9),
    .DbgBank10              (riu_diag10),
    .DbgBank11              (riu_diag11),
    .DbgBank12              (riu_diag12),
    .DbgBank13              (riu_diag13),
    .DbgBank14              (riu_diag14)
  );

`ifdef  RW_EMBEDDED_LA
 
  /* pipeline converterd to fifo */
  reg [11:0] debug_fe_adc_q_1t,    debug_fe_adc_i_1t;
  reg [11:0] debug_fe_adc_q_2t,    debug_fe_adc_i_2t;
  reg [11:0] debug_fe_adc_q_3t,    debug_fe_adc_i_3t;
  reg [11:0] debug_fe_dac_q_1t,    debug_fe_dac_i_1t;
  reg [11:0] debug_fe_dac_q_2t,    debug_fe_dac_i_2t;
  reg [11:0] debug_fe_dac_q_3t,    debug_fe_dac_i_3t;
  reg        debug_fe_dac_on_1t;
  reg        debug_fe_dac_on_2t;
  reg        debug_fe_dac_on_3t;
  reg [11:0] debug_fe_adcdac_q_4t, debug_fe_adcdac_i_4t;
 
  always @(posedge fe_clk, negedge fe_rst_n)
  begin
    if(!fe_rst_n)
    begin
      {debug_fe_adc_q_1t, debug_fe_adc_i_1t} <= 24'b0;
      {debug_fe_adc_q_2t, debug_fe_adc_i_2t} <= 24'b0;
      {debug_fe_adc_q_3t, debug_fe_adc_i_3t} <= 24'b0;
      {debug_fe_dac_on_1t, debug_fe_dac_q_1t, debug_fe_dac_i_1t} <= 25'b0;
      {debug_fe_dac_on_2t, debug_fe_dac_q_2t, debug_fe_dac_i_2t} <= 25'b0;
      {debug_fe_dac_on_3t, debug_fe_dac_q_3t, debug_fe_dac_i_3t} <= 25'b0;
      {debug_fe_adcdac_q_4t, debug_fe_adcdac_i_4t} <= 24'b0;
    end
    else
    begin
      {debug_fe_adc_q_1t, debug_fe_adc_i_1t} <= {adc0_q, adc0_i };
      {debug_fe_adc_q_2t, debug_fe_adc_i_2t} <= {debug_fe_adc_q_1t, debug_fe_adc_i_1t};
      {debug_fe_adc_q_3t, debug_fe_adc_i_3t} <= {debug_fe_adc_q_2t, debug_fe_adc_i_2t};
      {debug_fe_dac_on_1t, debug_fe_dac_q_1t, debug_fe_dac_i_1t} <= {dac0_on, dac0_q, dac0_i };
      {debug_fe_dac_on_2t, debug_fe_dac_q_2t, debug_fe_dac_i_2t} <= {debug_fe_dac_on_1t, debug_fe_dac_q_1t, debug_fe_dac_i_1t};
      {debug_fe_dac_on_3t, debug_fe_dac_q_3t, debug_fe_dac_i_3t} <= {debug_fe_dac_on_2t, debug_fe_dac_q_2t, debug_fe_dac_i_2t};
      if(debug_fe_dac_on_3t)
        {debug_fe_adcdac_q_4t,debug_fe_adcdac_i_4t} <= {debug_fe_dac_q_3t, debug_fe_dac_i_3t};
      else
        {debug_fe_adcdac_q_4t,debug_fe_adcdac_i_4t} <= {debug_fe_adc_q_3t, debug_fe_adc_i_3t};
    end
  end
  
  wire        debug_la_adcdac_valid;
  wire [11:0] debug_la_adcdac_q,debug_la_adcdac_i;
  
  wire        debug_la_adcdac_fifo_enable;
  assign      debug_la_adcdac_fifo_enable = rc_tx_req | rc_rx_req;
  
  async_fifo
  #(
    .g_width(                   24),
    .g_log_depth(               3)
  )
  u_async_fifo_adc2la
  (
    .enable(                    debug_la_adcdac_fifo_enable),
    /* */
    .w_rst_n(                   fe_rst_n),
    .w_clk(                     fe_clk),
    .w_ready(                   ),
    .w_data(                    {debug_fe_adcdac_q_4t, debug_fe_adcdac_i_4t}),
    .w_valid(                   1'b1),
    /* */
    .r_rst_n(                   la_rst_n),
    .r_clk(                     la_clk),
    .r_ready(                   1'b1),
    .r_data(                    {debug_la_adcdac_q,debug_la_adcdac_i}),
    .r_valid(                   debug_la_adcdac_valid)
  );
  
  /* pipeline adc to la */
  reg        debug_la_adcdac_valid_1t;
  reg        debug_la_adcdac_valid_2t;
  reg        debug_la_adcdac_valid_3t;
  reg [11:0] debug_la_adcdac_q_1t, debug_la_adcdac_i_1t;
  reg [11:0] debug_la_adcdac_q_2t, debug_la_adcdac_i_2t;
  reg [11:0] debug_la_adcdac_q_3t, debug_la_adcdac_i_3t;
  
  always @(posedge la_clk, negedge la_rst_n)
  begin
    if(!la_rst_n)
    begin
      {debug_la_adcdac_valid_1t, debug_la_adcdac_q_1t, debug_la_adcdac_i_1t} <= 25'b0;
      {debug_la_adcdac_valid_2t, debug_la_adcdac_q_2t, debug_la_adcdac_i_2t} <= 25'b0;
      {debug_la_adcdac_valid_3t, debug_la_adcdac_q_3t, debug_la_adcdac_i_3t} <= 25'b0;
    end
    else
    begin
      {debug_la_adcdac_valid_1t, debug_la_adcdac_q_1t, debug_la_adcdac_i_1t} <= {debug_la_adcdac_valid,    debug_la_adcdac_q,    debug_la_adcdac_i   };
      {debug_la_adcdac_valid_2t, debug_la_adcdac_q_2t, debug_la_adcdac_i_2t} <= {debug_la_adcdac_valid_1t, debug_la_adcdac_q_1t, debug_la_adcdac_i_1t};
      {debug_la_adcdac_valid_3t, debug_la_adcdac_q_3t, debug_la_adcdac_i_3t} <= {debug_la_adcdac_valid_2t, debug_la_adcdac_q_2t, debug_la_adcdac_i_2t};
    end
  end
  
  assign diag_la_adcdac = {7'b0,debug_la_adcdac_valid_3t, debug_la_adcdac_q_3t, debug_la_adcdac_i_3t};

`else
  assign diag_la_adcdac = {32'hadc0dead}; /* not implemented */
`endif


  /*****************************************************************************
  * platform AHB mux
  *****************************************************************************/
  always @(*)
  begin
    case(plf_haddr[19:16])
      4'b0110:
      begin
        plf_hsel_phy       = 1'b0;
        plf_hsel_macbyp    = plf_hsel;
        plf_hsel_riu_karst = 1'b0;
        ahb_slave          = 2'd0;
      end
        
      default:
      begin
        // TODO RC & RIU part of PHY space
        /***********************************************************
        * regbus address decoder (address given in bytes)
        *
        * 0X0000-0X0FFC  HDMCOREREG         0000_0XXX_XXXX_XXXX (Status, conf, 11b)
        * 0X1000-0X3FFC  **RESERVED**
        * 0X4000-0X4FFC  RADAR              0100_XXXX_XXXX_XXXX 
        * 0x5000-0x8FFC  BFREPORTMEM        0101_XXXX_XXXX_XXXX  to 1000_XXXX_XXXX_XXXX
        * 0x9000-0x97FC  LDPCCONFIGMEM      1001_0XXX_XXXX_XXXX
        * 0XA000-0XAFFC  AGCMEM             1010_XXXX_XXXX_XXXX
        * 0XB000-0xBFFC  RIUREG             1011_XXXX_XXXX_XXXX
        * 0XC000-0xCFFC  RCREG              1100_XXXX_XXXX_XXXX
        * 0XD000-0xDFFC  LBMEM              1101_XXXX_XXXX_XXXX
        ***********************************************************/ 
        
        case(plf_haddr[15:12])
          4'b0100,4'b1010,4'b1011,4'b1100: begin // Radar, AGCMem, RIURegs, RCRegs
            plf_hsel_phy       = 1'b0;
            plf_hsel_macbyp    = 1'b0;
            plf_hsel_riu_karst = plf_hsel;
            ahb_slave          = 2'd2;
          end
          default: begin
            plf_hsel_phy       = plf_hsel;
            plf_hsel_macbyp    = 1'b0;
            plf_hsel_riu_karst = 1'b0;
            ahb_slave          = 2'd1;
          end
        endcase

      end
    endcase
  end

  always @(negedge plf_rst_n, posedge plf_clk)
  begin
    if (!plf_rst_n)
      ahb_slave_1t <= 0;
    else if(plf_hready_in == 1'b1)
      ahb_slave_1t <= ahb_slave;
  end

  // AHB slave multiplexer
  always @(*)
  begin
    case (ahb_slave_1t)
      2'd0:
      begin                              
        plf_hrdata = plf_hrdata_macbyp;  
        plf_hresp  = plf_hresp_macbyp;   
        plf_hready = plf_hready_macbyp;  
      end                                
            
      2'd1:
      begin                           
        plf_hrdata = plf_hrdata_phy;
        plf_hresp  = plf_hresp_phy;   
        plf_hready = plf_hready_phy;
      end                             

      2'd2: // TODO
      begin                           
        plf_hrdata = plf_hrdata_riu_karst;
        plf_hresp  = plf_hresp_riu_karst;   
        plf_hready = plf_hready_riu_karst;
      end                             

      default:
      begin                  
        plf_hrdata = 32'h0;  
        plf_hresp  = 2'b0;   
        plf_hready = 1'b0;   
      end                    
    endcase
  end
  
  
  //////////////////////////////////////////////////////////////////////////////
  // Debug Port multiplexing infrastructure
  //////////////////////////////////////////////////////////////////////////////  
  
  assign rw_nx_ss_diag = {riu_diag5[6],phy_diag39[7:4]};
  
  assign reg_diag_sel[0*2+:2]    = reg_diag_sel0;
  assign reg_diag_sel[1*2+:2]    = reg_diag_sel1;
  assign reg_diag_sel[2*2+:2]    = reg_diag_sel2;

  assign reg_diag_presel[0*6+:6] = reg_diag_presel0;                             
  assign reg_diag_presel[1*6+:6] = reg_diag_presel1;                             
  assign reg_diag_presel[2*6+:6] = reg_diag_presel2;                             

  assign rw_nx_diag0             = rw_nx_diag[0*16+:16];                        
  assign rw_nx_diag1             = rw_nx_diag[1*16+:16];                        
  assign rw_nx_diag2             = rw_nx_diag[2*16+:16];                        

generate if (DIAG_PORT_NBR>3)
begin:DIAG_PORT_3456
  assign reg_diag_sel[3*2+:2]    = reg_diag_sel3;
  assign reg_diag_sel[4*2+:2]    = reg_diag_sel4;
  assign reg_diag_sel[5*2+:2]    = reg_diag_sel5;
  assign reg_diag_sel[6*2+:2]    = reg_diag_sel6;
                                                                                 
  assign reg_diag_presel[3*6+:6] = reg_diag_presel3;
  assign reg_diag_presel[4*6+:6] = reg_diag_presel4;
  assign reg_diag_presel[5*6+:6] = reg_diag_presel5;
  assign reg_diag_presel[6*6+:6] = reg_diag_presel6;
                                                                                 
  assign rw_nx_diag3             = rw_nx_diag[3*16+:16];
  assign rw_nx_diag4             = rw_nx_diag[4*16+:16];
  assign rw_nx_diag5             = rw_nx_diag[5*16+:16];
  assign rw_nx_diag6             = rw_nx_diag[6*16+:16];
end
else
begin:DIAG_PORT_3456
  assign rw_nx_diag3             = 16'h0;
  assign rw_nx_diag4             = 16'h0;
  assign rw_nx_diag5             = 16'h0;
  assign rw_nx_diag6             = 16'h0;
end
endgenerate

  // NX Diag Port interface
  rw_nx_diag_4x16 u_rw_nx_diag[DIAG_PORT_NBR-1:0] (
    .diag_sel   (reg_diag_sel ),
    .diag_in0   (diag_top     ),
    .diag_in1   (diag_mac_hw  ),
    .diag_in2   (diag_phy     ),
    .diag_in3   (diag_riu     ),
    .diag_out   (rw_nx_diag   )
  );
  

  rw_nx_diag_64x16 u_rw_nx_diag_top[DIAG_PORT_NBR-1:0] (
    .diag_sel   (reg_diag_presel  ),
    .diag_in0   (top_diag0        ),
    .diag_in1   (top_diag1        ),
    .diag_in2   (top_diag2        ),
    .diag_in3   (top_diag3        ),
    .diag_in4   (top_diag4        ),
    .diag_in5   (top_diag5        ),
    .diag_in6   (top_diag6        ),
    .diag_in7   (top_diag7        ),
    .diag_in8   (top_diag8        ),
    .diag_in9   (top_diag9        ),
    .diag_in10  (top_diag10       ),
    .diag_in11  (top_diag11       ),
    .diag_in12  (top_diag12       ),
    .diag_in13  (top_diag13       ),
    .diag_in14  (top_diag14       ),
    .diag_in15  (top_diag15       ),
    .diag_in16  (top_diag16       ),
    .diag_in17  (top_diag17       ),
    .diag_in18  (top_diag18       ),
    .diag_in19  (top_diag19       ),
    .diag_in20  (top_diag20       ),
    .diag_in21  (top_diag21       ),
    .diag_in22  (top_diag22       ),
    .diag_in23  (top_diag23       ),
    .diag_in24  (top_diag24       ),
    .diag_in25  (top_diag25       ),
    .diag_in26  (top_diag26       ),
    .diag_in27  (top_diag27       ),
    .diag_in28  (top_diag28       ),
    .diag_in29  (top_diag29       ),
    .diag_in30  (top_diag30       ),
    .diag_in31  (top_diag31       ),
    .diag_in32  (top_diag32       ),
    .diag_in33  (top_diag33       ),
    .diag_in34  (top_diag34       ),
    .diag_in35  (top_diag35       ),
    .diag_in36  (top_diag36       ),
    .diag_in37  (top_diag37       ),
    .diag_in38  (top_diag38       ),
    .diag_in39  (top_diag39       ),
    .diag_in40  (top_diag40       ),
    .diag_in41  (top_diag41       ),
    .diag_in42  (top_diag42       ),
    .diag_in43  (top_diag43       ),
    .diag_in44  (top_diag44       ),
    .diag_in45  (top_diag45       ),
    .diag_in46  (top_diag46       ),
    .diag_in47  (top_diag47       ),
    .diag_in48  (top_diag48       ),
    .diag_in49  (top_diag49       ),
    .diag_in50  (top_diag50       ),
    .diag_in51  (top_diag51       ),
    .diag_in52  (top_diag52       ),
    .diag_in53  (top_diag53       ),
    .diag_in54  (top_diag54       ),
    .diag_in55  (top_diag55       ),
    .diag_in56  (top_diag56       ),
    .diag_in57  (top_diag57       ),
    .diag_in58  (top_diag58       ),
    .diag_in59  (top_diag59       ),
    .diag_in60  (top_diag60       ),
    .diag_in61  (top_diag61       ),
    .diag_in62  (top_diag62       ),
    .diag_in63  (top_diag63       ),
    .diag_out   (diag_top         )
  );


  rw_nx_diag_64x16 u_rw_nx_diag_mac[DIAG_PORT_NBR-1:0] (
    .diag_sel   (reg_diag_presel  ),
    .diag_in0   (mac_diag0        ),
    .diag_in1   (mac_diag1        ),
    .diag_in2   (mac_diag2        ),
    .diag_in3   (mac_diag3        ),
    .diag_in4   (mac_diag4        ),
    .diag_in5   (mac_diag5        ),
    .diag_in6   (mac_diag6        ),
    .diag_in7   (mac_diag7        ),
    .diag_in8   (mac_diag8        ),
    .diag_in9   (mac_diag9        ),
    .diag_in10  (mac_diag10       ),
    .diag_in11  (mac_diag11       ),
    .diag_in12  (mac_diag12       ),
    .diag_in13  (mac_diag13       ),
    .diag_in14  (mac_diag14       ),
    .diag_in15  (mac_diag15       ),
    .diag_in16  (mac_diag16       ),
    .diag_in17  (mac_diag17       ),
    .diag_in18  (mac_diag18       ),
    .diag_in19  (mac_diag19       ),
    .diag_in20  (mac_diag20       ),
    .diag_in21  (mac_diag21       ),
    .diag_in22  (mac_diag22       ),
    .diag_in23  (mac_diag23       ),
    .diag_in24  (mac_diag24       ),
    .diag_in25  (mac_diag25       ),
    .diag_in26  (mac_diag26       ),
    .diag_in27  (mac_diag27       ),
    .diag_in28  (mac_diag28       ),
    .diag_in29  (mac_diag29       ),
    .diag_in30  (mac_diag30       ),
    .diag_in31  (mac_diag31       ),
    .diag_in32  (mac_diag32       ),
    .diag_in33  (mac_diag33       ),
    .diag_in34  (mac_diag34       ),
    .diag_in35  (mac_diag35       ),
    .diag_in36  (mac_diag36       ),
    .diag_in37  (mac_diag37       ),
    .diag_in38  (mac_diag38       ),
    .diag_in39  (mac_diag39       ),
    .diag_in40  (mac_diag40       ),
    .diag_in41  (mac_diag41       ),
    .diag_in42  (mac_diag42       ),
    .diag_in43  (mac_diag43       ),
    .diag_in44  (mac_diag44       ),
    .diag_in45  (mac_diag45       ),
    .diag_in46  (mac_diag46       ),
    .diag_in47  (mac_diag47       ),
    .diag_in48  (mac_diag48       ),
    .diag_in49  (mac_diag49       ),
    .diag_in50  (mac_diag50       ),
    .diag_in51  (mac_diag51       ),
    .diag_in52  (mac_diag52       ),
    .diag_in53  (mac_diag53       ),
    .diag_in54  (mac_diag54       ),
    .diag_in55  (mac_diag55       ),
    .diag_in56  (mac_diag56       ),
    .diag_in57  (mac_diag57       ),
    .diag_in58  (mac_diag58       ),
    .diag_in59  (mac_diag59       ),
    .diag_in60  (mac_diag60       ),
    .diag_in61  (mac_diag61       ),
    .diag_in62  (16'h0            ),
    .diag_in63  (16'h0            ),
    .diag_out   (diag_mac_hw      )
  );


  rw_nx_diag_64x16 u_rw_nx_diag_phy[DIAG_PORT_NBR-1:0] (
    .diag_sel   (reg_diag_presel  ),
    .diag_in0   (phy_diag0        ),
    .diag_in1   (phy_diag1        ),
    .diag_in2   (phy_diag2        ),
    .diag_in3   (phy_diag3        ),
    .diag_in4   (phy_diag4        ),
    .diag_in5   (phy_diag5        ),
    .diag_in6   (phy_diag6        ),
    .diag_in7   (phy_diag7        ),
    .diag_in8   (phy_diag8        ),
    .diag_in9   (phy_diag9        ),
    .diag_in10  (phy_diag10       ),
    .diag_in11  (16'h0            ),
    .diag_in12  (16'h0            ),
    .diag_in13  (phy_diag13       ),
    .diag_in14  (phy_diag14       ),
    .diag_in15  (phy_diag15       ),
    .diag_in16  (phy_diag16       ),
    .diag_in17  (phy_diag17       ),
    .diag_in18  (phy_diag18       ),
    .diag_in19  (phy_diag19       ),
    .diag_in20  (phy_diag20       ),
    .diag_in21  (phy_diag21       ),
    .diag_in22  (phy_diag22       ),
    .diag_in23  (phy_diag23       ),
    .diag_in24  (phy_diag24       ),
    .diag_in25  (phy_diag25       ),
    .diag_in26  (16'h0            ),
    .diag_in27  (16'h0            ),
    .diag_in28  (phy_diag28       ),
    .diag_in29  (phy_diag29       ),
    .diag_in30  (phy_diag30       ),
    .diag_in31  (phy_diag31       ),
    .diag_in32  (phy_diag32       ),
    .diag_in33  (phy_diag33       ),
    .diag_in34  (phy_diag34       ),
    .diag_in35  (phy_diag35       ),
    .diag_in36  (phy_diag36       ),
    .diag_in37  (phy_diag37       ),
    .diag_in38  (phy_diag38       ),
    .diag_in39  (phy_diag39       ),
    .diag_in40  (phy_diag40       ),
    .diag_in41  (phy_diag41       ),
    .diag_in42  (phy_diag42       ),
    .diag_in43  (16'h0            ),
    .diag_in44  (16'h0            ),
    .diag_in45  (16'h0            ),
    .diag_in46  (16'h0            ),
    .diag_in47  (16'h0            ),
    .diag_in48  (16'h0            ),
    .diag_in49  (16'h0            ),
    .diag_in50  (16'h0            ),
    .diag_in51  (phy_diag51       ),
    .diag_in52  (phy_diag52       ),
    .diag_in53  (phy_diag53       ),
    .diag_in54  (16'h0            ),
    .diag_in55  (16'h0            ),
    .diag_in56  (phy_diag56       ),
    .diag_in57  (phy_diag57       ),
    .diag_in58  (phy_diag58       ),
    .diag_in59  (phy_diag59       ),
    .diag_in60  (phy_diag60       ),
    .diag_in61  (phy_diag61       ),
    .diag_in62  (phy_diag62       ),
    .diag_in63  (16'h0            ),
    .diag_out   (diag_phy         )
  );


  rw_nx_diag_64x16 u_rw_nx_diag_riu[DIAG_PORT_NBR-1:0] (
    .diag_sel   (reg_diag_presel  ),
    .diag_in0   (riu_diag0        ),
    .diag_in1   (riu_diag1        ),
    .diag_in2   (riu_diag2        ),
    .diag_in3   (riu_diag3        ),
    .diag_in4   (riu_diag4        ),
    .diag_in5   (riu_diag5        ),
    .diag_in6   (riu_diag6        ),
    .diag_in7   (riu_diag7        ),
    .diag_in8   (riu_diag8        ),
    .diag_in9   (riu_diag9        ),
    .diag_in10  (riu_diag10       ),
    .diag_in11  (riu_diag11       ),
    .diag_in12  (riu_diag12       ),
    .diag_in13  (riu_diag13       ),
    .diag_in14  (riu_diag14       ),
    .diag_in15  (16'h0            ),
    .diag_in16  (16'h0            ),
    .diag_in17  (16'h0            ),
    .diag_in18  (16'h0            ),
    .diag_in19  (16'h0            ),
    .diag_in20  (16'h0            ),
    .diag_in21  (16'h0            ),
    .diag_in22  (16'h0            ),
    .diag_in23  (16'h0            ),
    .diag_in24  (16'h0            ),
    .diag_in25  (16'h0            ),
    .diag_in26  (16'h0            ),
    .diag_in27  (16'h0            ),
    .diag_in28  (16'h0            ),
    .diag_in29  (16'h0            ),
    .diag_in30  (16'h0            ),
    .diag_in31  (16'h0            ),
    .diag_in32  (16'h0            ),
    .diag_in33  (16'h0            ),
    .diag_in34  (16'h0            ),
    .diag_in35  (16'h0            ),
    .diag_in36  (16'h0            ),
    .diag_in37  (16'h0            ),
    .diag_in38  (16'h0            ),
    .diag_in39  (16'h0            ),
    .diag_in40  (16'h0            ),
    .diag_in41  (16'h0            ),
    .diag_in42  (16'h0            ),
    .diag_in43  (16'h0            ),
    .diag_in44  (16'h0            ),
    .diag_in45  (16'h0            ),
    .diag_in46  (16'h0            ),
    .diag_in47  (16'h0            ),
    .diag_in48  (16'h0            ),
    .diag_in49  (16'h0            ),
    .diag_in50  (16'h0            ),
    .diag_in51  (16'h0            ),
    .diag_in52  (16'h0            ),
    .diag_in53  (16'h0            ),
    .diag_in54  (16'h0            ),
    .diag_in55  (16'h0            ),
    .diag_in56  (16'h0            ),
    .diag_in57  (16'h0            ),
    .diag_in58  (16'h0            ),
    .diag_in59  (16'h0            ),
    .diag_in60  (16'h0            ),
    .diag_in61  (16'h0            ),
    .diag_in62  (16'h0            ),
    .diag_in63  (16'h0            ),
    .diag_out   (diag_riu         )
  );

  // 16bits Diag Ports
  assign top_diag0  = nx_mictor_test[15:0];
  assign top_diag1  = nx_mictor_test[31:16];
  assign top_diag2  = {
                      1'b0,//por_rst_n,
                      1'b0,//nmb_rst_n,
                      1'b0,//jtag_clk,
                      1'b0,//jtag_tms,
                      1'b0,//jtag_tdi,
                      1'b0,//jtag_tdo,
                      1'b0,
                      phywdog_hwrsten_n,
                      1'b0,
                      1'b0,
                      1'b0,
                      fe40_rst_n,
                      plf_rst_n,
                      1'b0,//g1_clk,
                      1'b0,//jtag_tck,
                      1'b0};
  assign top_diag3  = {
                      1'b0,
                      1'b0,//uart_clk,
                      1'b0,//nmb_clk,
                      1'b0,//nmb_io_busy,
                      1'b0,//nmb_idel_reset,
                      11'b0};
  assign top_diag4  = ext_diagport[15:0];
  assign top_diag5  = ext_diagport[31:16];
  assign top_diag6  = {
                      1'b0,
                      cpu_single_irq,
                      proc_hready,
                      proc_haddr[7:0],
                      proc_htrans[1:0],
                      proc_hwrite,
                      proc_hsize[1:0]};
  assign top_diag7  = {
                      8'b0,
                      proc_hrdata[31:28],
                      proc_hwdata[31:28]};
  assign top_diag8  = proc_haddr[15:0];
  assign top_diag9  = {
                      1'b0,
                      proc_hwdata[7:0],
                      proc_hwrite,
                      proc_hready,
                      proc_htrans[1:0],
                      proc_haddr[18:16]};
  assign top_diag10 = proc_hwdata[15:0];
  assign top_diag11 = proc_hwdata[31:16];
  assign top_diag12 = 16'd12; 
  assign top_diag13 = 16'd13; 
  assign top_diag14 = 16'd14;  
  assign top_diag15 = 16'd15;  
  assign top_diag16 = 16'd16;  
  assign top_diag17 = 16'd17;  
  assign top_diag18 = diag_platform0[15:0];
  assign top_diag19 = diag_platform0[31:16];
  assign top_diag20 = diag_platform1[15:0];
  assign top_diag21 = diag_platform1[31:16];
  assign top_diag22 = diag_platform2[15:0];
  assign top_diag23 = diag_platform2[31:16];
  assign top_diag24 = 16'd24;
  assign top_diag25 = 16'd25;
  assign top_diag26 = proc_irq[35:20];
  assign top_diag27 = proc_irq[51:36];
  assign top_diag28 = proc_irq[67:52];
  assign top_diag29 = proc_irq[83:68];
  assign top_diag30 = diag_mpif_diag_ctrl;
  assign top_diag31 = diag_mpif_mux;
  assign top_diag32 = diag_mpif_ctrl;
  assign top_diag33 = diag_mpif_data;
  assign top_diag34 = diag_coex[15:0];
  assign top_diag35 = diag_coex[31:16];
  assign top_diag36 = 16'd36;
  assign top_diag37 = 16'd37;
  assign top_diag38 = diag_dma_top[15:0];
  assign top_diag39 = diag_dma_top[31:16];
  assign top_diag40 = diag_dma_downstream_axi0[15:0];
  assign top_diag41 = diag_dma_downstream_axi1[15:0];
  assign top_diag42 = diag_dma_downstream_axi2[15:0];
  assign top_diag43 = 16'd43;
  assign top_diag44 = 16'd44;
  assign top_diag45 = 16'd45;
  assign top_diag46 = 16'd46;
  assign top_diag47 = 16'd47;
  assign top_diag48 = diag_hsu[15:0];
  assign top_diag49 = diag_hsu[31:16];
  assign top_diag50 = diag_la_adcdac[15:0];
  assign top_diag51 = diag_la_adcdac[31:16];
  assign top_diag52 = 16'd52;
  assign top_diag53 = 16'd53;
  assign top_diag54 = 16'd54;
  assign top_diag55 = 16'd55;
  assign top_diag56 = 16'd56;
  assign top_diag57 = 16'd57;
  assign top_diag58 = 16'd58;
  assign top_diag59 = 16'd59;
  assign top_diag60 = 16'd60;
  assign top_diag61 = 16'd61;
  assign top_diag62 = 16'd62;
  assign top_diag63 = 16'd63;

  // MAC/PHY Interface diagnostic port control
  rw_nx_mpif_diag_ctrl u_rw_nx_mpif_diag_ctrl( 
     //Clock and reset
     .clk               (mpif_clk              ),
     .hard_rst_n        (mac_mpif_rst_n        ),
     .soft_rst_n        (1'b1                  ),
     //MAC/PHY interface
     .mpif_txreq        (mac_mpif_txreq        ),
     .mpif_txdata       (mac_mpif_txdata       ),
     .mpif_macdatavalid (mac_mpif_macdatavalid ),
     .mpif_txend_p      (mac_mpif_txend_p      ),
     .mpif_rxreq        (mac_mpif_rxreq        ),
     .mpif_rxdata       (mac_mpif_rxdata       ),
     .mpif_phyrdy       (mac_mpif_phyrdy       ),
     .mpif_rxend_p      (mac_mpif_rxend_p      ),
     //Control interface
     .diag_mpif_mask_en (reg_diag_mpif_mask_en ),
     .diag_mpif_hdr_nbr (reg_diag_mpif_hdr_nbr ),
     .diag_mpif_mask    (diag_mpif_mask        ),
     //Debug Port
     .debug             (diag_mpif_diag_ctrl   )
  );

  // MAC/PHY Interface Masked signals
  assign mac_mpif_rxdata_masked       = diag_mpif_mask ? 8'd0 : mac_mpif_rxdata;
  assign mac_mpif_txdata_masked       = diag_mpif_mask ? 8'd0 : mac_mpif_txdata;
  assign mac_mpif_macdatavalid_masked = diag_mpif_mask ? 1'b0 : mac_mpif_macdatavalid;
  assign mac_mpif_phyrdy_masked       = diag_mpif_mask ? 1'b0 : mac_mpif_phyrdy;

  // MAC/PHY Interface Muxed signals
  assign mac_mpif_rxdata_txdata          = mac_mpif_rxreq ? mac_mpif_rxdata_masked :
                                                            mac_mpif_txdata_masked;
  assign mac_mpif_rxend_txend_p          = mac_mpif_rxreq ? mac_mpif_rxend_p :
                                                            mac_mpif_txend_p;
  assign mac_mpif_rxerr_phyerr_p         = mac_mpif_rxreq ? mac_mpif_rxerr_p : 
                                                            mac_mpif_phyerr_p;
  assign mac_mpif_cca_sec20_macdatavalid = mac_mpif_rxreq ? mac_mpif_cca_sec20 :
                                                            mac_mpif_macdatavalid_masked;

  // MAC/PHY Interface Diag Ports
  assign diag_mpif_mux = {
     mac_mpif_cca_pri20,
     mac_mpif_rxendfortiming_p,
     mac_mpif_txreq,
     mac_mpif_rxreq,
     mac_mpif_phyrdy_masked,
     mac_mpif_cca_sec20_macdatavalid, 
     mac_mpif_rxerr_phyerr_p,        
     mac_mpif_rxend_txend_p,         
     mac_mpif_rxdata_txdata
  };

  assign diag_mpif_ctrl = {
     mac_mpif_txreq,
     mac_mpif_rxreq,
     mac_mpif_macdatavalid_masked,
     mac_mpif_phyrdy_masked,
     mac_mpif_txend_p,
     mac_mpif_rxendfortiming_p,
     mac_mpif_rxend_p,
     mac_mpif_rxerr_p,
     mac_mpif_phyerr_p,
     mac_mpif_keeprfon,
     mac_mpif_rifsrxdetected,
     mac_mpif_cca_pri20,
     mac_mpif_cca_sec20,
     3'b000
  };

  assign diag_mpif_data = {
     mac_mpif_txdata_masked,
     mac_mpif_rxdata_masked
  };

`ifdef  RW_MUMIMO_SEC_USER1_EN
  assign mac_mpif_rxdata_txdata_u1 = (mac_mpif_txreq) ? mac_mpif_txdata_u1 :  mac_mpif_rxdata;
`endif//RW_MUMIMO_SEC_USER1_EN

  always @(posedge plf_clk or negedge plf_rst_n)
  begin
    if(plf_rst_n==0)
    begin
      nx_mictor_test <= {31'b0,1'b1};
      nx_mictor_1t   <= 32'b0;
      nx_mictor_2t   <= 32'b0;
    end
    else
    begin
      nx_mictor_test <= {nx_mictor_test[30:0],nx_mictor_test[31]};
      nx_mictor_1t   <= {rw_nx_diag3,rw_nx_diag2};
      nx_mictor_2t   <= nx_mictor_1t;
    end
  end


`ifdef  RW_EMBEDDED_LA
  //////////////////////////////////////////////////////////////////////////////
  // EMBEDDED LOGIC ANALYZER
  //////////////////////////////////////////////////////////////////////////////
  rw_nx_la #(
    .LA_MEMORY_SIZE  (16                  ),
    .LA_MEMORY_WIDTH (`RW_LA_RAM_DATAWIDTH)
  ) u_rw_nx_la (
    //--------------------------------------------------------------------------
    // System
    //--------------------------------------------------------------------------
    .ahb_rst_n    (plf_rst_n                                   ),
    .ahb_clk      (plf_clk                                     ),
    .la_rst_n     (la_rst_n                                    ),
    .la_clk       (la_clk                                      ),
    //--------------------------------------------------------------------------
    // AHB slave interface
    //--------------------------------------------------------------------------
    .hready_in    (la_hready_in                                ),
    .hsel         (la_hsel                                     ),
    .haddr        (la_haddr[20:0]                              ),
    .htrans       (la_htrans                                   ),
    .hwrite       (la_hwrite                                   ),
    .hwdata       (la_hwdata                                   ),
    .hrdata       (la_hrdata                                   ),
    .hresp        (la_hresp                                    ),
    .hready       (la_hready                                   ),
    //--------------------------------------------------------------------------
    // AHB slave interface
    //--------------------------------------------------------------------------
    .la_interrupt (la_interrupt                                ),
    //--------------------------------------------------------------------------
    // RAM interface
    //--------------------------------------------------------------------------
    .clka         (lamemwr_clk                                 ),
    .ena          (/*Open*/                                    ),
    .wea          (lamem_wen                                   ),
    .addra        (lamem_waddr                                 ),
    .dina         (lamem_wdata                                 ),
    .clkb         (lamemrd_clk                                 ),
    .enb          (/*Open*/                                    ),
    .addrb        (lamem_raddr                                 ),
    .doutb        (lamem_rdata                                 ),

    .samplingfreq (la_sampling_freq                            ),
    .input_data   (rw_nx_diag                                  ),
    .ext_trigger  ({reg_diag_trigger,macbypass_trigger,1'b0}   ),
    .triggered    (/*Open*/                                    )
  );
`endif//RW_EMBEDDED_LA

endmodule
`default_nettype wire
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
