//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of rw_he_top module
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none
module rw_he_top_wrapper
(
  /*****************************************************************************
  * $port_g Clocks & Resets Inputs
  *****************************************************************************/
  /* $port_g system resets */
  input wire                              sys_rst_n,
  
  /* $port_g rw_nx_platform clock */ 
  input wire                              ref0_root_clk,       // Reference clock for PHY (240/480 Mhz)
  input wire                              ref1_root_clk,       // Reference clock for MAC (80 Mhz)
  
  output wire                             fe_clk,  
  output wire                             fe_rst_n, 
  output wire                             plf_clk,
  output wire                             plf_rst_n,
  output wire                             plf_por_n,
`ifndef RW_CRM_FPGA
  input wire                              plf_root_clk,        // Platform clock
  input wire                              mac_lp_root_clk,     // Low-Power clock
`else
  input  wire                             global_rst_n,

  output wire                             ref80_clk, 
  output wire                             ref80_rst_n, 
  input  wire                             axi_aclk,
  output wire                             axi_por_n,
`endif

  /* $port_g rw_nx_platform clock enables */
  output wire                             platform_wake_up,    // Wake Up platform  
  
  /*****************************************************************************
  //$port_g Processor (firmware)  AHB interface
  *****************************************************************************/
  output wire                             proc_hready,         // Processor hready
  input  wire                             proc_hready_in,      // Processor hready_in
  input  wire  [27:0]                     proc_haddr,          // Processor haddr
  input  wire  [ 1:0]                     proc_htrans,         // Processor htrans
  input  wire                             proc_hwrite,         // Processor hwrite
  input  wire  [ 1:0]                     proc_hsize,          // Processor hsize
  output wire  [31:0]                     proc_hrdata,         // Processor hrdata
  input  wire  [31:0]                     proc_hwdata,         // Processor hwdata
  output wire  [ 1:0]                     proc_hresp,          // Processor hresp
  
  /*****************************************************************************
  //$port_g Interrupt sources
  *****************************************************************************/
`ifdef  RW_FPGA_AHB
  input  wire                             fpga_irq,            // Interrupt from FPGA
`endif//RW_FPGA_AHB
  output wire                             host_irq,            // Interrupt from host
  output wire  [95:20]                    proc_irq,            // Interrupts to processor
  output wire                             cpu_single_irq,      // Single Interrupt to processor (Active High)
  output wire                             tick_timer_irq,      // Tick Timer Interrupt to processor (Active High)
  output wire                             soft_irq,            // Soft Interrupt to processor (Active High)
  
  /*****************************************************************************
  //$port_g GPIO interface
  *****************************************************************************/
  output wire [31:0]                      gpio_out,            // GPIO output
  input  wire [31:0]                      gpio_in,             // GPIO input
  output wire [31:0]                      gpio_oen,            // GPIO output enable
  
`ifdef RW_COEX_MODEL
  /*****************************************************************************
  //$port_g AHB to Coexistence interface
  *****************************************************************************/
  output wire                             coexif_hready_in,    // Coexistence Interface hready_in
  output wire                             coexif_hsel,         // Coexistence Interface hsel
  output wire  [8:0]                      coexif_haddr,        // Coexistence Interface haddr
  output wire [ 1:0]                      coexif_htrans,       // Coexistence Interface htrans
  output wire                             coexif_hwrite,       // Coexistence Interface hwrite
  input  wire [31:0]                      coexif_hrdata,       // Coexistence Interface hrdata
  output wire [31:0]                      coexif_hwdata,       // Coexistence Interface hwdata
  input  wire [ 1:0]                      coexif_hresp,        // Coexistence Interface hresp
  input  wire                             coexif_hready,       // Coexistence Interface hready
`endif // RW_COEX_MODEL

`ifdef RW_WLAN_COEX_EN
  /*****************************************************************************
  //$port_g Bluetooth Coexistence Interface
  *****************************************************************************/
  input  wire                             coex_bt_tx,          // BT Transmission On-going
  input  wire                             coex_bt_rx,          // BT Reception    On-going
  input  wire                             coex_bt_event,       // BT Event        On-going
  output wire                             coex_bt_tx_abort,    // BT Transmission Abort Request
  output wire                             coex_bt_rx_abort,    // BT Reception    Abort Request
  input  wire [3:0]                       coex_bt_pti,         // BT Packet Traffic Information
  input  wire [6:0]                       coex_bt_channel,     // BT Channel (0-78)
  input  wire                             coex_bt_bw,          // BT Bandwidth (0:1MHz, 1:2MHz)
`endif // RW_WLAN_COEX_EN

  /*****************************************************************************
  //$port_g RC Coexistence interface
  *****************************************************************************/
  output wire                             rc_tx_abort,         // Radio Controller Transmission Abort Request
  output wire                             rc_rx_abort,         // Radio Controller Reception    Abort Request
  
  /*****************************************************************************
  //$port_g AXI Interface
  *****************************************************************************/
  //$port_g  upstream interface
  output wire [ 3:0]                      dma0_awid,           // DMA Upstream awid
  output wire [31:0]                      dma0_awaddr,         // DMA Upstream awaddr
  output wire [ 7:0]                      dma0_awlen,          // DMA Upstream awlen 
  output wire [ 2:0]                      dma0_awsize,         // DMA Upstream awsize
  output wire [ 1:0]                      dma0_awburst,        // DMA Upstream awburst
  output wire [11:0]                      dma0_awuser,         // DMA Upstream awuser
  output wire                             dma0_awvalid,        // DMA Upstream awvalid
  input  wire                             dma0_awready,        // DMA Upstream awready
                                                                 
  output wire [ 3:0]                      dma0_wid,            // DMA Upstream wid
  output wire [63:0]                      dma0_wdata,          // DMA Upstream wdata 
  output wire [ 7:0]                      dma0_wstrb,          // DMA Upstream wstrb
  output wire                             dma0_wlast,          // DMA Upstream wlast
  output wire                             dma0_wvalid,         // DMA Upstream wvalid
  input  wire                             dma0_wready,         // DMA Upstream wready
                                                                 
  input  wire  [3:0]                      dma0_bid,            // DMA Upstream bid
  input  wire  [1:0]                      dma0_bresp,          // DMA Upstream bresp
  input  wire                             dma0_bvalid,         // DMA Upstream bvalid
  output wire                             dma0_bready,         // DMA Upstream bready

  //$port_g  downstream interface
  output wire [ 3:0]                      dma1_arid,           // DMA Downstream arid
  output wire [31:0]                      dma1_araddr,         // DMA Downstream araddr
  output wire [ 7:0]                      dma1_arlen,          // DMA Downstream arlen
  output wire [ 2:0]                      dma1_arsize,         // DMA Downstream arsize
  output wire [ 1:0]                      dma1_arburst,        // DMA Downstream arburst
  output wire                             dma1_arvalid,        // DMA Downstream arvalid
  input  wire                             dma1_arready,        // DMA Downstream arready
                                                              
  input  wire [ 3:0]                      dma1_rid,            // DMA Downstream rid
  input  wire [63:0]                      dma1_rdata,          // DMA Downstream rdata
  input  wire [ 1:0]                      dma1_rresp,          // DMA Downstream rresp
  input  wire                             dma1_rlast,          // DMA Downstream rlast
  input  wire                             dma1_rvalid,         // DMA Downstream rvalid
  output wire                             dma1_rready,         // DMA Downstream rready
  
  /*****************************************************************************
  //$port_g ADC Interface
  *****************************************************************************/
  output wire                             adc0_on,             // ADC0 Power/Clock enable     
  input  wire [11:0]                      adc0_i,              // ADC0 Data I
  input  wire [11:0]                      adc0_q,              // ADC0 Data Q
`ifdef RW_NX_DERIV_FE_PATH1
  output wire                             adc1_on,             // ADC1 Power/Clock enable   
  input  wire [11:0]                      adc1_i,              // ADC1 Data I
  input  wire [11:0]                      adc1_q,              // ADC1 Data Q
`endif                                                       

  /*****************************************************************************
  //$port_g DAC Interface
  *****************************************************************************/
  output wire                             dac0_on,             // DAC0 Power/Clock enable     
  output wire                             dac0_en,             // DAC0 Data valid   
  output wire [11:0]                      dac0_i,              // DAC0 Data I
  output wire [11:0]                      dac0_q,              // DAC0 Data Q
`ifdef RW_NX_DERIV_FE_PATH1
  output wire                             dac1_on,             // DAC1 Power/Clock enable     
  output wire                             dac1_en,             // DAC1 Data valid               
  output wire [11:0]                      dac1_i,              // DAC1 Data I         
  output wire [11:0]                      dac1_q,              // DAC1 Data Q        
`endif
  
  /*******************************************************************
  //$port_g RF interface
  *******************************************************************/
  //$port_g Reset output
  output wire                             rf_resetn,        // Active Low Reset for Radio
  
  //$port_g RF AGC Control
  output wire                             rf_agcfreeze,     // AGC freeze 
 
  //$port_g RF Test mode
  output  wire                            rf_tmode,         // Radio Test Mode
  
  //$port_g Fast write bus
  output wire  [7:0]                      rf_gpio,          // GPIO Data
  
  //$port_g SPI Interface
  input  wire                             rf_spi_in,        // SPI Interface In
  output wire                             rf_spi_ss_n,      // SPI Interface Slave Select
  output wire                             rf_spi_clk,       // SPI Interface Clock
  output wire                             rf_spi_out,       // SPI Interface Out

  //$port_g Tx/Rx switch
  output wire                             rf_trsw0,         // Radio Tx On 0
`ifdef RW_NX_DERIV_FE_PATH1
  output wire                             rf_trsw1,         // Radio Tx On 1
`endif
                                                                                    
  //$port_g External PA
  output wire                             rf_extpaon_ch0_5G9,  // Radio External PA Channel 0 5Ghz
  output wire                             rf_extpaon_ch0_2G4,  // Radio External PA Channel 0 2.4Ghz
`ifdef RW_NX_DERIV_FE_PATH1
  output wire                             rf_extpaon_ch1_5G9,  // Radio External PA Channel 1 5Ghz                
  output wire                             rf_extpaon_ch1_2G4,  // Radio External PA Channel 1 2.4Ghz              
`endif
 
`ifdef RW_FPGA_AHB
  /*****************************************************************************
  //$port_g  AHB to FPGA
  *****************************************************************************/
  output wire                             fpga_hready_in,  // FPGA hready_in
  output wire                             fpga_hsel,       // FPGA hsel
  output wire [19:0]                      fpga_haddr,      // FPGA haddr
  output wire [ 1:0]                      fpga_htrans,     // FPGA htrans
  output wire                             fpga_hwrite,     // FPGA hwrite
  input  wire [31:0]                      fpga_hrdata,     // FPGA hrdata
  output wire [31:0]                      fpga_hwdata,     // FPGA hwdata
  input  wire [ 1:0]                      fpga_hresp,      // FPGA hresp
  input  wire                             fpga_hready,     // FPGA hready
`endif // RW_FPGA_AHB

  /*****************************************************************************
  //$port_g Diagnostic Ports
  *****************************************************************************/
  input  wire  [31:0]                     ext_diagport,        // Diagnostic port
  output wire                             reg_bootrom_enable,  // CPU Boot enable
  
  output wire [ 4:0]                      rw_nx_ss_diag,       // Diagnostic port to be used with IQ for source synchrone capture
  output wire [15:0]                      rw_nx_diag0,         // Diagnostic port
  output wire [15:0]                      rw_nx_diag1,         // Diagnostic port
  output wire [15:0]                      rw_nx_diag2,         // Diagnostic port
  output wire [15:0]                      rw_nx_diag3,         // Diagnostic port
  output wire [15:0]                      rw_nx_diag4,         // Diagnostic port
  output wire [15:0]                      rw_nx_diag5,         // Diagnostic port
  output wire [15:0]                      rw_nx_diag6,         // Diagnostic port
  output wire                             mac_internal_error,  // MAC internal Error
  input  wire                             mac_debug_ksr,       // Debug Key Storage RAM.
  output wire  [1:0]                      macbypass_trigger,   // MAC Bypass Trigger Port
  output wire                             reg_diag_trigger     // SW Trigger Port
);

  /*****************************************************************************
  * PARAMETERS
  *****************************************************************************/
  localparam g_mac_txfifo_awidth     = `TXFIFOADDRWIDTH;
  localparam g_mac_rxfifo_awidth     = `RXFIFOADDRWIDTH;
  localparam g_keystorage_awidth     = `RW_KEY_INDEX_WIDTH;
  localparam g_keystorage_dwidth     = `RW_KEY_DATA_WIDTH;
  localparam g_mpif_txfifo_awidth    = `MPIFTXADDRWIDTH;
  localparam g_mpif_rxfifo_awidth    = `MPIFRXADDRWIDTH;
  localparam g_sharedram_awidth      = `RW_SHARED_RAM_ADDR_WIDTH-3;
`ifdef  RW_HSU_RSA_EN
  localparam g_rsa_sram_awidth       = `RW_RSA_RAM_ADDWIDTH;
  localparam g_rsa_sram_dwidth       = `RW_RSA_RAM_DATAWIDTH;
`endif//RW_HSU_RSA_EN
  localparam g_fftmem_awidth         = 32'd6;
`ifdef  RW_EMBEDDED_LA
  localparam g_embedded_la_dwidth    = `RW_LA_RAM_DATAWIDTH;
`endif//RW_EMBEDDED_LA

  /*****************************************************************************
  * DECLARATIONS
  *****************************************************************************/
  /* RESET */
  wire        mac_core_rst_n;                       
  wire        mac_wt_rst_n;                         
  wire        mac_mpif_rst_n;                           
  wire        phy_rst_n;                          
  wire        rxbd_rst_n;                          
  wire        mdmb_rst_n;                          
  wire        rc_rst_n;                          
  wire        fe44_rst_n;                          
  wire        fe40_rst_n;                          
`ifdef RW_NX_DERIV_FE_PATH40M
  wire        fe80_rst_n;
`endif // RW_NX_DERIV_FE_PATH40M
`ifdef RW_NX_DERIV_FE_PATH80M
  wire        fe160_rst_n;
`endif // RW_NX_DERIV_FE_PATH80M
  wire        agc_rst_n;                          
  wire        radar_rst_n;                          
 
  /* RESET REQUESTS */
  wire        phywdog_hwrsten_n;  
  wire        plf_swrsten_n;       
  
  /* CLOCKS */
  wire        mac_pi_clk;                           
  wire        mac_pi_tx_clk;                        
  wire        mac_pi_rx_clk;                        
  wire        mac_core_clk;                         
  wire        mac_core_tx_clk;                      
  wire        mac_core_rx_clk;                      
  wire        mac_crypt_clk;                        
  wire        mac_lp_clk;                           
  wire        mac_wt_clk;                           
  wire        mpif_clk;                             
  wire        macbypass_clk;                             
  wire        phy_clk;                               
  wire        phytx_clk;                            
  wire        tbe_clk;
  wire        tdfoest_clk;
  wire        tdcomp_clk;
  wire        channelest_clk;
  wire        equ_clk;
  wire        fdo_clk;
  wire        fft0_clk; 
  wire        rc_clk;
  wire        fe44_clk;
  wire        fe40_clk;
`ifdef RW_NX_DERIV_FE_PATH40M
  wire        fe80_clk;
`endif // RW_NX_DERIV_FE_PATH40M
`ifdef RW_NX_DERIV_FE_PATH80M
  wire        fe160_clk;
`endif // RW_NX_DERIV_FE_PATH80M
  wire        agc_clk;
  wire        agcmem_clk;
  wire        adcpow_clk;
  wire        ferxpath_clk;
  wire        fetxpath_clk;
  wire        radar_clk;
  wire        mdmb_clk;
  wire        mdmbrx_clk;
  wire        mdmbtx_clk;
`ifdef RW_BFMEE_EN
  wire        svd_clk;
  wire        svd_gclk;
`endif // RW_BFMEE_EN
  wire        vtb_clk;
  wire        vtbcore0_clk;
`ifdef RW_NX_LDPC_ENC
  wire        ldpc0tx0_clk;
  wire        ldpc0tx0_clken;
`endif // RW_NX_LDPC_ENC
`ifdef RW_NX_LDPC_DEC
  wire        ldpcrx0_clk;
  wire        ldpcrx0_clken;
  wire        ldpcrx0_dec_clk;
  wire        ldpcrx0_dec_clken;
`endif // RW_NX_LDPC_DEC
`ifdef  RW_EMBEDDED_LA
  wire        la_rst_n;
  wire        la_clk;
`endif//  RW_EMBEDDED_LA
  wire  [7:0] la_sampling_freq;    // LA sampling frequency

  /* CLOCK ENABLES/SWITCHES */
  wire        mac_pi_clken;             
  wire        mac_pi_tx_clken;          
  wire        mac_pi_rx_clken;          
  wire        mac_core_clken;           
  wire        mac_core_tx_clken;        
  wire        mac_core_rx_clken;        
  wire        mac_crypt_clken;          
  wire        mac_wt_clken;             
  wire        phytx_clken;
  wire        mpif_clken;               
  wire        macbypass_clken;               
  wire        fft0_clken;
  wire        tbe_clken;
  wire        tdfoest_clken;
  wire        tdcomp_clken;
  wire        channelest_clken;
  wire        equ_clken;
  wire        fdo_clken;
  wire        mac_lp_clkswitch;
`ifdef RW_BFMEE_EN
  wire        svd_clken;
`endif // RW_BFMEE_EN
  wire        vtb_clken;
  wire        vtbcore0_clken;
  wire        fe40_clken;
`ifdef RW_NX_DERIV_FE_PATH40M
  wire        fe80_clken;
`endif // RW_NX_DERIV_FE_PATH40M
`ifdef RW_NX_DERIV_FE_PATH80M
  wire        fe160_clken;
`endif // RW_NX_DERIV_FE_PATH80M
  wire        agc_clken;
  wire        agcmem_clken;
  wire        ferx_clken;
  wire        fetx_clken;
  wire        mdmb_clken;
  wire        mdmbrx_clken;
  wire        mdmbtx_clken;
  wire        mdmb_clkskip;

  /* MEMORIES */
`ifdef  RW_EMBEDDED_LA
  wire                            lamemwr_clk;
  wire                            lamemrd_clk;
  wire                            lamem_wen  ;
  wire [15:0]                     lamem_waddr;
  wire [g_embedded_la_dwidth-1:0] lamem_wdata;
  wire [15:0]                     lamem_raddr;
  wire [g_embedded_la_dwidth-1:0] lamem_rdata;
`endif//RW_EMBEDDED_LA

  wire                            mac_txfifo_wen;  
  wire [g_mac_txfifo_awidth-1:0]  mac_txfifo_waddr;
  wire [37:0]                     mac_txfifo_wdata;
  wire                            mac_txfifo_ren;  
  wire [g_mac_txfifo_awidth-1:0]  mac_txfifo_raddr;
  wire [37:0]                     mac_txfifo_rdata;
                                               
  wire                            mac_rxfifo_wen;   
  wire [g_mac_rxfifo_awidth-1:0]  mac_rxfifo_waddr; 
  wire [35:0]                     mac_rxfifo_wdata; 
  wire                            mac_rxfifo_ren;   
  wire [g_mac_rxfifo_awidth-1:0]  mac_rxfifo_raddr; 
  wire [35:0]                     mac_rxfifo_rdata; 

  wire                            keystorage_en;     
  wire                            keystorage_wen;    
  wire [g_keystorage_awidth-1:0]  keystorage_addr;   
  wire [g_keystorage_dwidth-1:0]  keystorage_wdata;  
  wire [g_keystorage_dwidth-1:0]  keystorage_rdata;  

  wire  [15:0]                    sbox_mem_rdata;
  wire   [6:0]                    sbox_mem_waddr;
  wire   [6:0]                    sbox_mem_raddr;
  wire  [15:0]                    sbox_mem_wdata;
  wire   [1:0]                    sbox_mem_wen;
  wire                            sbox_mem_ren;

  wire                            mpif_txfifo_wen;  
  wire [g_mpif_txfifo_awidth-1:0] mpif_txfifo_waddr;
  wire [ 7:0]                     mpif_txfifo_wdata;
  wire                            mpif_txfifo_ren;  
  wire [g_mpif_txfifo_awidth-1:0] mpif_txfifo_raddr;
  wire [ 7:0]                     mpif_txfifo_rdata;

  wire                            mpif_rxfifo_wen;   
  wire [g_mpif_rxfifo_awidth-1:0] mpif_rxfifo_waddr; 
  wire [ 7:0]                     mpif_rxfifo_wdata; 
  wire                            mpif_rxfifo_ren;   
  wire [g_mpif_rxfifo_awidth-1:0] mpif_rxfifo_raddr; 
  wire [ 7:0]                     mpif_rxfifo_rdata; 

  wire                            mibtable_en;    
  wire                            mibtable_wen;   
  wire [ 7:0]                     mibtable_addr;  
  wire [31:0]                     mibtable_wdata; 
  wire [31:0]                     mibtable_rdata; 

  wire                            sharedram_en;   
  wire [g_sharedram_awidth-1:0]   sharedram_addr; 
  wire [ 7:0]                     sharedram_wen;  
  wire [63:0]                     sharedram_wdata;
  wire [63:0]                     sharedram_rdata;

`ifdef  RW_HSU_RSA_EN
  wire                            rsa_sram_en;
  wire    [g_rsa_sram_awidth-1:0] rsa_sram_addr;
  wire                      [3:0] rsa_sram_wen;
  wire    [g_rsa_sram_dwidth-1:0] rsa_sram_wdata;
  wire    [g_rsa_sram_dwidth-1:0] rsa_sram_rdata;
`endif//RW_HSU_RSA_EN

  wire [ 15:0]                    fft0mem0_wen,   fft0mem1_wen,   fft0mem2_wen,   fft0mem3_wen;   
  wire [g_fftmem_awidth-1:0]      fft0mem0_waddr, fft0mem1_waddr, fft0mem2_waddr, fft0mem3_waddr; 
  wire [239:0]                    fft0mem0_wdata, fft0mem1_wdata, fft0mem2_wdata, fft0mem3_wdata; 
  wire                            fft0mem0_ren,   fft0mem1_ren,   fft0mem2_ren,   fft0mem3_ren;   
  wire [g_fftmem_awidth-1:0]      fft0mem0_raddr, fft0mem1_raddr, fft0mem2_raddr, fft0mem3_raddr; 
  wire [239:0]                    fft0mem0_rdata, fft0mem1_rdata, fft0mem2_rdata, fft0mem3_rdata;


  wire [ 15:0]                    fft0mem4_wen,   fft0mem5_wen;    
  wire [g_fftmem_awidth-1:0]      fft0mem4_waddr, fft0mem5_waddr; 
  wire [303:0]                    fft0mem4_wdata, fft0mem5_wdata; 
  wire                            fft0mem4_ren,   fft0mem5_ren;   
  wire [g_fftmem_awidth-1:0]      fft0mem4_raddr, fft0mem5_raddr; 
  wire [303:0]                    fft0mem4_rdata, fft0mem5_rdata; 

`ifdef RW_NX_LDPC_ENC
  wire [  4:0]                    ldpc0tx0_addr; 
  wire                            ldpc0tx0_en;  
  wire [  8:0]                    ldpc0tx0_wen;  
  wire [ 80:0]                    ldpc0tx0_wdata;
  wire [ 80:0]                    ldpc0tx0_rdata;

  wire [  4:0]                    ldpc0tx1_addr; 
  wire                            ldpc0tx1_en;  
  wire [  8:0]                    ldpc0tx1_wen;  
  wire [ 80:0]                    ldpc0tx1_wdata;
  wire [ 80:0]                    ldpc0tx1_rdata;
`endif // RW_NX_LDPC_ENC

`ifdef RW_NX_LDPC_DEC
  /*****************************************************************************
  * LDPC 
  *****************************************************************************/
  /* Config data interface */
  wire [`RW_LDPCCFGRAM_AWIDTH-1:0] ldpcrx0_cfg_addr;
  wire                            ldpcrx0_cfg_en;
  wire                            ldpcrx0_cfg_wen;
  wire [28:0]                     ldpcrx0_cfg_wdata;
  wire [28:0]                     ldpcrx0_cfg_rdata;
  
  /*  LDPC0 Memories */
  // Cr _s
  wire [6:0]                      ldpcrx0_cr_waddr;   
  wire [6:0]                      ldpcrx0_cr_raddr;   
  wire [485:0]                    ldpcrx0_cr_wdata;   
  wire                            ldpcrx0_cr_ren;     
  wire                            ldpcrx0_cr_wen;     
  wire  [485:0]                   ldpcrx0_cr_rdata;   
  // Vr _s
  wire [4:0]                      ldpcrx0_vr_waddr;   
  wire [4:0]                      ldpcrx0_vr_raddr;   
  wire [647:0]                    ldpcrx0_vr_wdata;   
  wire                            ldpcrx0_vr_ren;     
  wire                            ldpcrx0_vr_wen;     
  wire [647:0]                    ldpcrx0_vr_rdata;   
  // VM _s
  wire [4:0]                      ldpcrx0_vmx_waddr;  
  wire [4:0]                      ldpcrx0_vmx_raddr;  
  wire [647:0]                    ldpcrx0_vmx_wdata;  
  wire                            ldpcrx0_vmx_ren;    
  wire [`RW_NX_DERIV_LDPC_VMWE_WIDTH-1:0] ldpcrx0_vmx_wen;    
  wire [647:0]                    ldpcrx0_vmx_rdata;  

  wire [4:0]                      ldpcrx0_vmy_waddr;  
  wire [4:0]                      ldpcrx0_vmy_raddr;  
  wire [647:0]                    ldpcrx0_vmy_wdata;  
  wire                            ldpcrx0_vmy_ren;    
  wire [`RW_NX_DERIV_LDPC_VMWE_WIDTH-1:0] ldpcrx0_vmy_wen;
  wire [647:0]                    ldpcrx0_vmy_rdata;  
  // HD _s
  wire [4:0]                      ldpcrx0_hd_waddr;   
  wire [80:0]                     ldpcrx0_hd_wdata;   

  wire [4:0]                      ldpcrx0_hdx_raddr;  
  wire [80:0]                     ldpcrx0_hdx_rdata;  
  wire                            ldpcrx0_hdx_ren;    
  wire                            ldpcrx0_hdx_wen;    
  
  wire [4:0]                      ldpcrx0_hdy_raddr;  
  wire                            ldpcrx0_hdy_wen;  
  wire                            ldpcrx0_hdy_ren;    
  wire [80:0]                     ldpcrx0_hdy_rdata;
`endif // RW_NX_LDPC_DEC

  wire                            bdfd_wen;     
  wire [ 6:0]                     bdfd_waddr;   
  wire [59:0]                     bdfd_wdata;   
  wire                            bdfd_ren;     
  wire [ 6:0]                     bdfd_raddr;   
  wire [59:0]                     bdfd_rdata;  
  
`ifdef RW_BFMEE_EN
  wire                            bfmee_en;   
  wire                            bfmee_wen;    
  wire [`RW_BFMEE_RAM_AWIDTH-1:0] bfmee_addr;
  wire [31:0]                     bfmee_wdata;  
  wire [31:0]                     bfmee_rdata;  
`endif

  wire [7:0]                      agcmem_addr;
  wire                            agcmem_en;
  wire [1:0]                      agcmem_wren;
  wire [63:0]                     agcmem_wrdata;
  wire [63:0]                     agcmem_rddata;

`ifdef RW_RADAR_EN
  wire [8:0]                      radarmem_addr;
  wire                            radarmem_en;
  wire                            radarmem_wren;
  wire [9:0]                      radarmem_wrdata;
  wire [9:0]                      radarmem_rddata;
`endif

  // CRM registers
  wire                             crm_hready_in; 
  wire                             crm_hsel;      
  wire [ 9:0]                      crm_haddr;     
  wire [ 1:0]                      crm_htrans;    
  wire                             crm_hwrite;    
  wire [31:0]                      crm_hrdata;    
  wire [31:0]                      crm_hwdata;    
  wire [ 1:0]                      crm_hresp;     
  wire                             crm_hready;    
  

  /*****************************************************************************
  * rw_he_top instance
  *****************************************************************************/
  rw_he_top u_rw_he_top 
  (
    /*****************************************************************************
    * Resets
    *****************************************************************************/
    .plf_rst_n(                    plf_rst_n),       
    .mac_core_rst_n(               mac_core_rst_n),  
    .mac_wt_rst_n(                 mac_wt_rst_n),    
    .mac_mpif_rst_n(               mac_mpif_rst_n),      
    .phy_rst_n(                    phy_rst_n),
    .mdmb_rst_n(                   mdmb_rst_n),
    .rxbd_rst_n(                   rxbd_rst_n),
    .rc_rst_n(                     rc_rst_n),
    .fe44_rst_n(                   fe44_rst_n),
    .fe40_rst_n(                   fe40_rst_n),
`ifdef RW_NX_DERIV_FE_PATH40M
    .fe80_rst_n(                   fe80_rst_n),
`endif // RW_NX_DERIV_FE_PATH40M
    .fe_rst_n(                     fe_rst_n),  
    .agc_rst_n(                    agc_rst_n),
`ifdef RW_RADAR_EN
    .radar_rst_n(                  radar_rst_n),
`endif
`ifdef  RW_EMBEDDED_LA
    .la_rst_n(                     la_rst_n),
`endif//RW_EMBEDDED_LA

    /*****************************************************************************
    * Reset requests
    *****************************************************************************/
    .phywdog_hwrsten_n(            phywdog_hwrsten_n),      
    .plf_swrsten_n(                plf_swrsten_n),           
   
    /*****************************************************************************
    * Clocks 
    *****************************************************************************/
    /* rw_nx_platform */
    .mac_pi_clk(                   mac_pi_clk),                  
    .mac_pi_tx_clk(                mac_pi_tx_clk),               
    .mac_pi_rx_clk(                mac_pi_rx_clk),               
    .mac_core_clk(                 mac_core_clk),                
    .mac_core_tx_clk(              mac_core_tx_clk),             
    .mac_core_rx_clk(              mac_core_rx_clk),             
    .mac_crypt_clk(                mac_crypt_clk),               
    .mac_lp_clk(                   mac_lp_clk),                  
    .mac_wt_clk(                   mac_wt_clk),                  
    .plf_clk(                      plf_clk),                     

    /* hdmcore */
    .mpif_clk(                     mpif_clk),                    
    .macbypass_clk(                macbypass_clk),
    .phy_clk(                      phy_clk),
    .phytx_clk(                    phytx_clk),
    .tbe_clk(                      tbe_clk),
    .tdfoest_clk(                  tdfoest_clk),
    .tdcomp_clk(                   tdcomp_clk),
    .channelest_clk(               channelest_clk),
    .equ_clk(                      equ_clk),
    .fdo_clk(                      fdo_clk),
    .fft0_clk(                     fft0_clk),
`ifdef RW_BFMEE_EN
    .svd_clk(                      svd_clk),
    .svd_gclk(                     svd_gclk),
`endif //  RW_BFMEE_EN
    .vtb_clk(                      vtb_clk),
    .vtbcore0_clk(                 vtbcore0_clk),
`ifdef RW_NX_LDPC_DEC
    .ldpcrx0_clk(                  ldpcrx0_clk),
    .ldpcrx0_dec_clk(              ldpcrx0_dec_clk),
`endif // RW_NX_LDPC_DEC
`ifdef RW_NX_LDPC_ENC
    .ldpc0tx0_clk(                 ldpc0tx0_clk),
`endif // RW_NX_LDPC_ENC
    /* embedded logic analyzer */
`ifdef  RW_EMBEDDED_LA
    .la_clk(                       la_clk),
`endif//RW_EMBEDDED_LA
    // hdm_core DSSS PHY
    .mdmb_clk(                     mdmb_clk),
    .mdmbrx_gclk(                  mdmbrx_clk),
    .mdmbtx_gclk(                  mdmbtx_clk),
    // RIU
    .rc_clk(                       rc_clk),
    .fe44_clk(                     fe44_clk),
    .fe40_clk(                     fe40_clk),
`ifdef RW_NX_DERIV_FE_PATH40M
    .fe80_clk(                     fe80_clk),
`endif // RW_NX_DERIV_FE_PATH40M
    .fe_clk(                       fe_clk),  
    .agc_clk(                      agc_clk),
    .agcmem_clk(                   agcmem_clk),
    .adcpow_clk(                   adcpow_clk),
    .ferxpath_clk(                 ferxpath_clk),
    .fetxpath_clk(                 fetxpath_clk),
`ifdef RW_RADAR_EN
    .radar_clk(                    radar_clk),
`endif

    /*****************************************************************************
    * Clock enable outputs
    *****************************************************************************/ 
    /* rw_nx_platform  */
    .platform_wake_up (            platform_wake_up),             
    .mac_lp_clkswitch (            mac_lp_clkswitch),             
    .mac_pi_clken(                 mac_pi_clken),                
    .mac_pi_tx_clken(              mac_pi_tx_clken),              
    .mac_pi_rx_clken(              mac_pi_rx_clken),              
    .mac_core_clken(               mac_core_clken),
    .mac_core_tx_clken(            mac_core_tx_clken),            
    .mac_core_rx_clken(            mac_core_rx_clken),            
    .mac_crypt_clken(              mac_crypt_clken),              
    .mac_wt_clken(                 mac_wt_clken),                 
    .mpif_clken(                   mpif_clken),        
     /* hdmcore ofdm */
    .macbypass_clken(              macbypass_clken),
    .phytx_clken(                  phytx_clken),
    .tbe_clken(                    tbe_clken),
    .tdfoest_clken(                tdfoest_clken),
    .tdcomp_clken(                 tdcomp_clken),
    .channelest_clken(             channelest_clken),
    .equ_clken(                    equ_clken),
    .fdo_clken(                    fdo_clken),
    .fft0_clken(                   fft0_clken),
`ifdef RW_BFMEE_EN
    .svd_clken(                    svd_clken),
`endif //  RW_BFMEE_EN
    .vtb_clken(                    vtb_clken),
    .vtbcore0_clken(               vtbcore0_clken),
`ifdef RW_NX_LDPC_DEC
    .ldpcrx0_clken(                ldpcrx0_clken),
    .ldpcrx0_dec_clken(            ldpcrx0_dec_clken),
`endif // RW_NX_LDPC_DEC
`ifdef RW_NX_LDPC_ENC
    .ldpc0tx0_clken(               ldpc0tx0_clken),
`endif // RW_NX_LDPC_ENC
     /* riu */
    .fe40_clken(                   fe40_clken),
`ifdef RW_NX_DERIV_FE_PATH40M
    .fe80_clken(                   fe80_clken),  
`endif // RW_NX_DERIV_FE_PATH40M
`ifdef RW_NX_DERIV_FE_PATH80M
    .fe160_clken(                  fe160_clken),
`endif // RW_NX_DERIV_FE_PATH80M
    .agc_clken(                    agc_clken),
    .agcmem_clken(                 agcmem_clken),
    .ferx_clken(                   ferx_clken),
    .fetx_clken(                   fetx_clken),
     /* hdmcore dsss-cck */
    .mdmb_clken(                   mdmb_clken),
    .mdmb_clkskip(                 mdmb_clkskip),
    .mdmbrx_clken(                 mdmbrx_clken),
    .mdmbtx_clken(                 mdmbtx_clken),
     /* hdmcore clock configuration */
    .mdmcfg_conf_bw(               ),
    
    /*****************************************************************************
    * Processor (firmware)  AHB interface
    *****************************************************************************/
    .proc_hready_in(               proc_hready_in),       
    .proc_hready(                  proc_hready),       
    .proc_haddr(                   proc_haddr),        
    .proc_htrans(                  proc_htrans),       
    .proc_hwrite(                  proc_hwrite),       
    .proc_hsize(                   proc_hsize),        
    .proc_hrdata(                  proc_hrdata),       
    .proc_hwdata(                  proc_hwdata),       
    .proc_hresp(                   proc_hresp),        
  
    /*****************************************************************************
    * Interrupt sources
    *****************************************************************************/
`ifdef  RW_FPGA_AHB
    .fpga_irq(                     fpga_irq),
`endif//RW_FPGA_AHB
    .host_irq(                     host_irq),          
    .proc_irq(                     proc_irq),          
    .cpu_single_irq(               cpu_single_irq),    
    .tick_timer_irq(               tick_timer_irq),    
    .soft_irq(                     soft_irq),    
     // GPIO interface
    .gpio_out(                     gpio_out),          
    .gpio_in(                      gpio_in),           
    .gpio_oen(                     gpio_oen),          
     // External interface
    .reg_bootrom_enable(           reg_bootrom_enable),            //CPU Boot enable
`ifdef RW_COEX_MODEL
    /*****************************************************************************
    * AHB to Coexistence interface
    *****************************************************************************/
    .coexif_hready_in(             coexif_hready_in),  
    .coexif_hsel(                  coexif_hsel),       
    .coexif_haddr(                 coexif_haddr),      
    .coexif_htrans(                coexif_htrans),     
    .coexif_hwrite(                coexif_hwrite),     
    .coexif_hrdata(                coexif_hrdata),     
    .coexif_hwdata(                coexif_hwdata),     
    .coexif_hresp(                 coexif_hresp),      
    .coexif_hready(                coexif_hready),     
`endif 
`ifdef RW_WLAN_COEX_EN
    /*****************************************************************************
    * Bluetooth Coexistence Interface
    *****************************************************************************/
    .coex_bt_tx(                   coex_bt_tx),  
    .coex_bt_rx(                   coex_bt_rx),  
    .coex_bt_event(                coex_bt_event),     
    .coex_bt_tx_abort(             coex_bt_tx_abort),  
    .coex_bt_rx_abort(             coex_bt_rx_abort),  
    .coex_bt_pti(                  coex_bt_pti),       
    .coex_bt_channel(              coex_bt_channel),   
    .coex_bt_bw(                   coex_bt_bw),        
`endif 
    // RC Coexistence interface
    .rc_tx_abort(                  rc_tx_abort),       
    .rc_rx_abort(                  rc_rx_abort),       
    /*****************************************************************************
    * AXI Interface
    *****************************************************************************/
    //  upstream interface
    .dma0_awid(                    dma0_awid),
    .dma0_awaddr(                  dma0_awaddr),
    .dma0_awlen(                   dma0_awlen),
    .dma0_awsize(                  dma0_awsize),
    .dma0_awburst(                 dma0_awburst),
    .dma0_awuser(                  dma0_awuser),
    .dma0_awvalid(                 dma0_awvalid),
    .dma0_awready(                 dma0_awready),
    .dma0_wid(                     dma0_wid),
    .dma0_wdata(                   dma0_wdata),
    .dma0_wstrb(                   dma0_wstrb),
    .dma0_wlast(                   dma0_wlast),
    .dma0_wvalid(                  dma0_wvalid),
    .dma0_wready(                  dma0_wready),
    .dma0_bid(                     dma0_bid),
    .dma0_bresp(                   dma0_bresp),
    .dma0_bvalid(                  dma0_bvalid),
    .dma0_bready(                  dma0_bready),
    //  downstream interface
    .dma1_arid(                    dma1_arid),
    .dma1_araddr(                  dma1_araddr),
    .dma1_arlen(                   dma1_arlen),
    .dma1_arsize(                  dma1_arsize),
    .dma1_arburst(                 dma1_arburst),
    .dma1_arvalid(                 dma1_arvalid),
    .dma1_arready(                 dma1_arready),
    .dma1_rid(                     dma1_rid),
    .dma1_rdata(                   dma1_rdata),
    .dma1_rresp(                   dma1_rresp),
    .dma1_rlast(                   dma1_rlast),
    .dma1_rvalid(                  dma1_rvalid),
    .dma1_rready(                  dma1_rready),
   
    /*****************************************************************************
    * rw_nx_platform memories interface
    *****************************************************************************/
    /* MAC TXFIFO */
    .mac_txfifo_ren(               mac_txfifo_ren),                 
    .mac_txfifo_raddr(             mac_txfifo_raddr),               
    .mac_txfifo_rdata(             mac_txfifo_rdata),               
    .mac_txfifo_wen(               mac_txfifo_wen),                 
    .mac_txfifo_waddr(             mac_txfifo_waddr),               
    .mac_txfifo_wdata(             mac_txfifo_wdata),               
    /* MAC RXFIFO */
    .mac_rxfifo_ren(               mac_rxfifo_ren),              
    .mac_rxfifo_raddr(             mac_rxfifo_raddr),            
    .mac_rxfifo_rdata(             mac_rxfifo_rdata),            
    .mac_rxfifo_wen(               mac_rxfifo_wen),              
    .mac_rxfifo_waddr(             mac_rxfifo_waddr),            
    .mac_rxfifo_wdata(             mac_rxfifo_wdata),            
    /* KEY STORAGE */
    .keystorage_en(                keystorage_en),              
    .keystorage_wen(               keystorage_wen),           
    .keystorage_addr(              keystorage_addr),            
    .keystorage_rdata(             keystorage_rdata),         
    .keystorage_wdata(             keystorage_wdata),         
    /* SBOX */
    .sbox_mem_raddr(               sbox_mem_raddr),        
    .sbox_mem_rdata(               sbox_mem_rdata),        
    .sbox_mem_waddr(               sbox_mem_waddr),        
    .sbox_mem_ren(                 sbox_mem_ren),          
    .sbox_mem_wen(                 sbox_mem_wen),          
    .sbox_mem_wdata(               sbox_mem_wdata),    
    /*  MAC-PHY IF TX FIFO*/
    .mpif_txfifo_ren(              mpif_txfifo_ren),         
    .mpif_txfifo_raddr(            mpif_txfifo_raddr),       
    .mpif_txfifo_rdata(            mpif_txfifo_rdata),       
    .mpif_txfifo_wen(              mpif_txfifo_wen),         
    .mpif_txfifo_waddr(            mpif_txfifo_waddr),       
    .mpif_txfifo_wdata(            mpif_txfifo_wdata),       

    // MAC-PHY IF RX FIFO RAM 64*8 Two Ports SRAM
    .mpif_rxfifo_ren(              mpif_rxfifo_ren),     
    .mpif_rxfifo_raddr(            mpif_rxfifo_raddr),   
    .mpif_rxfifo_rdata(            mpif_rxfifo_rdata),   
    .mpif_rxfifo_wen(              mpif_rxfifo_wen),     
    .mpif_rxfifo_waddr(            mpif_rxfifo_waddr),   
    .mpif_rxfifo_wdata(            mpif_rxfifo_wdata),   
    // MIB Table RAM 256*32 Single Port SRAM
    .mibtable_en(                  mibtable_en),              
    .mibtable_wen(                 mibtable_wen),           
    .mibtable_addr(                mibtable_addr),            
    .mibtable_rdata(               mibtable_rdata),         
    .mibtable_wdata(               mibtable_wdata),         
    // Platform memory 32768/64 single sram port (one wri
    .sharedram_en(                 sharedram_en),             
    .sharedram_addr(               sharedram_addr),           
    .sharedram_wen(                sharedram_wen),          
    .sharedram_wdata(              sharedram_wdata),        
    .sharedram_rdata(              sharedram_rdata),        
    // RSA Memory Single Port SRAM 
`ifdef  RW_HSU_RSA_EN
    .rsa_sram_en(                  rsa_sram_en),
    .rsa_sram_addr(                rsa_sram_addr),
    .rsa_sram_wen(                 rsa_sram_wen),
    .rsa_sram_wdata(               rsa_sram_wdata),
    .rsa_sram_rdata(               rsa_sram_rdata),
`endif//RW_HSU_RSA_EN

    /*****************************************************************************
    * hdmcore memories interface
    *****************************************************************************/
    /* FFT 0 buffer 0 */
    .fftmem0_wen(                  fft0mem0_wen),  
    .fftmem0_waddr(                fft0mem0_waddr),
    .fftmem0_wdata(                fft0mem0_wdata),
    .fftmem0_raddr(                fft0mem0_raddr),
    .fftmem0_ren(                  fft0mem0_ren),  
    .fftmem0_rdata(                fft0mem0_rdata),
    /* FFT 0 buffer 1 */
    .fftmem1_wen(                  fft0mem1_wen),  
    .fftmem1_waddr(                fft0mem1_waddr),
    .fftmem1_wdata(                fft0mem1_wdata),
    .fftmem1_raddr(                fft0mem1_raddr),
    .fftmem1_ren(                  fft0mem1_ren),  
    .fftmem1_rdata(                fft0mem1_rdata),
    /* FFT 0 buffer 2 */
    .fftmem2_wen(                  fft0mem2_wen),  
    .fftmem2_waddr(                fft0mem2_waddr),
    .fftmem2_wdata(                fft0mem2_wdata),
    .fftmem2_raddr(                fft0mem2_raddr),
    .fftmem2_ren(                  fft0mem2_ren),  
    .fftmem2_rdata(                fft0mem2_rdata),
    /* FFT 0 buffer 3 */
    .fftmem3_wen(                  fft0mem3_wen),  
    .fftmem3_waddr(                fft0mem3_waddr),
    .fftmem3_wdata(                fft0mem3_wdata),
    .fftmem3_raddr(                fft0mem3_raddr),
    .fftmem3_ren(                  fft0mem3_ren),  
    .fftmem3_rdata(                fft0mem3_rdata),
    /* FFT 0 buffer 4 */
    .fftmem4_wen(                  fft0mem4_wen),  
    .fftmem4_waddr(                fft0mem4_waddr),
    .fftmem4_wdata(                fft0mem4_wdata),
    .fftmem4_raddr(                fft0mem4_raddr),
    .fftmem4_ren(                  fft0mem4_ren),  
    .fftmem4_rdata(                fft0mem4_rdata),
    /* FFT 0 buffer 5 */
    .fftmem5_wen(                  fft0mem5_wen),  
    .fftmem5_waddr(                fft0mem5_waddr),
    .fftmem5_wdata(                fft0mem5_wdata),
    .fftmem5_raddr(                fft0mem5_raddr),
    .fftmem5_ren(                  fft0mem5_ren),  
    .fftmem5_rdata(                fft0mem5_rdata),
    /* BDFD */
    .bdfd_wen(                     bdfd_wen),  
    .bdfd_waddr(                   bdfd_waddr),
    .bdfd_wdata(                   bdfd_wdata),
    .bdfd_ren(                     bdfd_ren),  
    .bdfd_raddr(                   bdfd_raddr),
    .bdfd_rdata(                   bdfd_rdata),

`ifdef RW_BFMEE_EN
    /* BFMEE */
    .bfmee_en(                     bfmee_en),  
    .bfmee_wen(                    bfmee_wen),  
    .bfmee_addr(                   bfmee_addr),
    .bfmee_rdata(                  bfmee_rdata),
    .bfmee_wdata(                  bfmee_wdata),
`endif

`ifdef RW_NX_LDPC_ENC
    /* LDPC */
    .ldpc0tx0_en(                  ldpc0tx0_en),
    .ldpc0tx0_addr(                ldpc0tx0_addr),
    .ldpc0tx0_wdata(               ldpc0tx0_wdata),
    .ldpc0tx0_wen(                 ldpc0tx0_wen),
    .ldpc0tx0_rdata(               ldpc0tx0_rdata),
    
    .ldpc0tx1_en(                  ldpc0tx1_en),
    .ldpc0tx1_addr(                ldpc0tx1_addr),
    .ldpc0tx1_wdata(               ldpc0tx1_wdata),
    .ldpc0tx1_wen(                 ldpc0tx1_wen),
    .ldpc0tx1_rdata(               ldpc0tx1_rdata),
`endif // RW_NX_LDPC_ENC
`ifdef RW_NX_LDPC_DEC
    .ldpcrx0_cfg_addr(             ldpcrx0_cfg_addr),
    .ldpcrx0_cfg_en(               ldpcrx0_cfg_en),
    .ldpcrx0_cfg_wen(              ldpcrx0_cfg_wen),
    .ldpcrx0_cfg_wdata(            ldpcrx0_cfg_wdata),
    .ldpcrx0_cfg_rdata(            ldpcrx0_cfg_rdata),
  
    .ldpcrx0_cr_waddr(             ldpcrx0_cr_waddr),  
    .ldpcrx0_cr_raddr(             ldpcrx0_cr_raddr),  
    .ldpcrx0_cr_wdata(             ldpcrx0_cr_wdata),  
    .ldpcrx0_cr_ren(               ldpcrx0_cr_ren),    
    .ldpcrx0_cr_wen(               ldpcrx0_cr_wen),    
    .ldpcrx0_cr_rdata(             ldpcrx0_cr_rdata),  
  
    .ldpcrx0_vr_waddr(             ldpcrx0_vr_waddr),  
    .ldpcrx0_vr_raddr(             ldpcrx0_vr_raddr),  
    .ldpcrx0_vr_wdata(             ldpcrx0_vr_wdata),  
    .ldpcrx0_vr_ren(               ldpcrx0_vr_ren),    
    .ldpcrx0_vr_wen(               ldpcrx0_vr_wen),    
    .ldpcrx0_vr_rdata(             ldpcrx0_vr_rdata),  
  
    .ldpcrx0_vmx_waddr(            ldpcrx0_vmx_waddr), 
    .ldpcrx0_vmx_raddr(            ldpcrx0_vmx_raddr), 
    .ldpcrx0_vmx_wdata(            ldpcrx0_vmx_wdata), 
    .ldpcrx0_vmx_ren(              ldpcrx0_vmx_ren),   
    .ldpcrx0_vmx_wen(              ldpcrx0_vmx_wen),   
    .ldpcrx0_vmx_rdata(            ldpcrx0_vmx_rdata), 

    .ldpcrx0_vmy_waddr(            ldpcrx0_vmy_waddr), 
    .ldpcrx0_vmy_raddr(            ldpcrx0_vmy_raddr), 
    .ldpcrx0_vmy_wdata(            ldpcrx0_vmy_wdata), 
    .ldpcrx0_vmy_ren(              ldpcrx0_vmy_ren),   
    .ldpcrx0_vmy_wen(              ldpcrx0_vmy_wen),
    .ldpcrx0_vmy_rdata(            ldpcrx0_vmy_rdata), 
  
    .ldpcrx0_hd_waddr(             ldpcrx0_hd_waddr),  
    .ldpcrx0_hd_wdata(             ldpcrx0_hd_wdata),  

    .ldpcrx0_hdx_raddr(            ldpcrx0_hdx_raddr), 
    .ldpcrx0_hdx_rdata(            ldpcrx0_hdx_rdata), 
    .ldpcrx0_hdx_ren(              ldpcrx0_hdx_ren),   
    .ldpcrx0_hdx_wen(              ldpcrx0_hdx_wen),   
  
    .ldpcrx0_hdy_raddr(            ldpcrx0_hdy_raddr), 
    .ldpcrx0_hdy_wen(              ldpcrx0_hdy_wen),  
    .ldpcrx0_hdy_ren(              ldpcrx0_hdy_ren),   
    .ldpcrx0_hdy_rdata(            ldpcrx0_hdy_rdata),
`endif // RW_NX_LDPC_DEC
    .agcmem_addr(                  agcmem_addr),   
    .agcmem_en(                    agcmem_en),   
    .agcmem_wren(                  agcmem_wren),   
    .agcmem_wrdata(                agcmem_wrdata), 
    .agcmem_rddata(                agcmem_rddata), 

`ifdef RW_RADAR_EN
    .radarmem_addr(                radarmem_addr), 
    .radarmem_en(                  radarmem_en), 
    .radarmem_wren(                radarmem_wren), 
    .radarmem_wrdata(              radarmem_wrdata),
    .radarmem_rddata(              radarmem_rddata),
`endif

`ifdef  RW_EMBEDDED_LA
    /***************************************************************************
    * $port_g Embedded LA memory interface
    ***************************************************************************/
    .lamemwr_clk(                  lamemwr_clk), // ????
    .lamemrd_clk(                  lamemrd_clk), // ????
    .lamem_wen  (                  lamem_wen  ),
    .lamem_waddr(                  lamem_waddr),
    .lamem_wdata(                  lamem_wdata),
    .lamem_raddr(                  lamem_raddr),
    .lamem_rdata(                  lamem_rdata),
`endif//RW_EMBEDDED_LA
`ifdef RW_FPGA_AHB
    /***************************************************************************
    * $port_g FPGA AHB interface
    ***************************************************************************/
    .fpga_hready_in               (fpga_hready_in),
    .fpga_hsel                    (fpga_hsel     ),
    .fpga_haddr                   (fpga_haddr    ),
    .fpga_htrans                  (fpga_htrans   ),
    .fpga_hwrite                  (fpga_hwrite   ),
    .fpga_hrdata                  (fpga_hrdata   ),
    .fpga_hwdata                  (fpga_hwdata   ),
    .fpga_hresp                   (fpga_hresp    ),
    .fpga_hready                  (fpga_hready   ),
`endif // RW_FPGA_AHB
    /*****************************************************************************
    * AHB to CRM interface
    *****************************************************************************/
    .crm_hready_in(               crm_hready_in), 
    .crm_hsel(                    crm_hsel),      
    .crm_haddr(                   crm_haddr),     
    .crm_htrans(                  crm_htrans),    
    .crm_hwrite(                  crm_hwrite),    
    .crm_hrdata(                  crm_hrdata),    
    .crm_hwdata(                  crm_hwdata),    
    .crm_hresp(                   crm_hresp),     
    .crm_hready(                  crm_hready),    
    /*****************************************************************************
    * ADC Interface
    *****************************************************************************/
    .adc0_on(                      adc0_on),
    .adc0_i(                       adc0_i),
    .adc0_q(                       adc0_q),
    
    /*****************************************************************************
    * DAC Interface
    *****************************************************************************/
    .dac0_on(                      dac0_on),
    .dac0_en(                      dac0_en),
    .dac0_i(                       dac0_i),
    .dac0_q(                       dac0_q),
    
    /*******************************************************************
    * RF interface
    *******************************************************************/
    .rf_resetn              (rf_resetn),
    .rf_gpio                (rf_gpio),
    .rf_agcfreeze           (rf_agcfreeze),
    .rf_tmode               (rf_tmode),
   
    .rf_spi_in              (rf_spi_in),
    .rf_spi_ss_n            (rf_spi_ss_n),
    .rf_spi_clk             (rf_spi_clk),
    .rf_spi_out             (rf_spi_out),
    
    /*******************************************************************
    * RF daughter board control
    *******************************************************************/
    /* Tx/Rx switch */
    .rf_trsw0               (rf_trsw0),
    /* External PA */                                
    .rf_extpaon_ch0_5G9     (rf_extpaon_ch0_5G9),
    .rf_extpaon_ch0_2G4     (rf_extpaon_ch0_2G4),

    /*****************************************************************************
    * $port_g Diagnostic Ports
    *****************************************************************************/
`ifdef  RW_EMBEDDED_LA
    .la_sampling_freq(             la_sampling_freq),
`endif//RW_EMBEDDED_LA
    .ext_diagport(                 ext_diagport),                  //Diagnostic port read back value
    .rw_nx_ss_diag(                rw_nx_ss_diag),
    .rw_nx_diag0(                  rw_nx_diag0),
    .rw_nx_diag1(                  rw_nx_diag1),
    .rw_nx_diag2(                  rw_nx_diag2),
    .rw_nx_diag3(                  rw_nx_diag3),
    .rw_nx_diag4(                  rw_nx_diag4),
    .rw_nx_diag5(                  rw_nx_diag5),
    .rw_nx_diag6(                  rw_nx_diag6),
    .mac_internal_error(           mac_internal_error),            //MAC internal Error
    .mac_debug_ksr(                mac_debug_ksr),                 //Debug Key Storage RAM.
    .macbypass_trigger(            macbypass_trigger),             //MAC Bypass Trigger Port
    .reg_diag_trigger(             reg_diag_trigger)               //SW Trigger Port
  );

  /*****************************************************************************
  * rw_he_memories instance
  *****************************************************************************/
  rw_he_memories 
  #(
    .g_mac_txfifo_awidth(          g_mac_txfifo_awidth),
    .g_mac_rxfifo_awidth(          g_mac_rxfifo_awidth), 
    .g_keystorage_awidth(          g_keystorage_awidth), 
    .g_keystorage_dwidth(          g_keystorage_dwidth), 
    .g_mpif_txfifo_awidth(         g_mpif_txfifo_awidth), 
    .g_mpif_rxfifo_awidth(         g_mpif_rxfifo_awidth), 
    .g_sharedram_awidth(           g_sharedram_awidth), 
`ifdef  RW_HSU_RSA_EN
    .g_rsa_sram_awidth(            g_rsa_sram_awidth), 
    .g_rsa_sram_dwidth(            g_rsa_sram_dwidth),
`endif//RW_HSU_RSA_EN
`ifdef  RW_EMBEDDED_LA
    .g_embedded_la_dwidth(         g_embedded_la_dwidth),
`endif//RW_EMBEDDED_LA
    .g_fftmem_awidth(              g_fftmem_awidth) 
  )
  u_rw_he_memories
  (
    /* clocks */
    .mac_core_tx_clk(              mac_core_tx_clk),
    .mac_core_rx_clk(              mac_core_rx_clk),
    .mac_pi_tx_clk(                mac_pi_tx_clk),
    .mac_pi_rx_clk(                mac_pi_rx_clk),
    .mac_wt_clk(                   mac_wt_clk), 
    .mpif_clk(                     mpif_clk),
    .mac_crypt_clk(                mac_crypt_clk),
    .mac_core_clk(                 mac_core_clk),
    .plf_clk(                      plf_clk),
    .phy_clk(                      phy_clk),
    .agcmem_clk(                   agcmem_clk),
    .agc_clk(                      agc_clk),
`ifdef RW_BFMEE_EN
    .svd_clk(                      svd_clk),
`endif // RW_BFMEE_EN
`ifdef RW_NX_LDPC_ENC
    .ldpc0tx0_clk(                 ldpc0tx0_clk),
`endif // RW_NX_LDPC_ENC
`ifdef RW_NX_LDPC_DEC
    .ldpcrx0_clk(                  ldpcrx0_clk),
`endif // RW_NX_LDPC_DEC
   
`ifdef  RW_EMBEDDED_LA
    /* Embedded LA memory interface */
    .lamemwr_clk(                  lamemwr_clk),
    .lamemrd_clk(                  lamemrd_clk),
    .lamem_wen  (                  lamem_wen  ),
    .lamem_waddr(                  lamem_waddr),
    .lamem_wdata(                  lamem_wdata),
    .lamem_raddr(                  lamem_raddr),
    .lamem_rdata(                  lamem_rdata),
`endif//RW_EMBEDDED_LA

    /* MAC TX FIFO */
    .mac_txfifo_ren(               mac_txfifo_ren),     
    .mac_txfifo_raddr(             mac_txfifo_raddr),   
    .mac_txfifo_rdata(             mac_txfifo_rdata),   
    .mac_txfifo_wen(               mac_txfifo_wen),     
    .mac_txfifo_waddr(             mac_txfifo_waddr),   
    .mac_txfifo_wdata(             mac_txfifo_wdata),   
    /* MAC RX FIFO */
    .mac_rxfifo_ren(               mac_rxfifo_ren),   
    .mac_rxfifo_raddr(             mac_rxfifo_raddr), 
    .mac_rxfifo_rdata(             mac_rxfifo_rdata), 
    .mac_rxfifo_wen(               mac_rxfifo_wen),   
    .mac_rxfifo_waddr(             mac_rxfifo_waddr), 
    .mac_rxfifo_wdata(             mac_rxfifo_wdata), 

    .keystorage_en(                keystorage_en),   
    .keystorage_wen(               keystorage_wen),  
    .keystorage_addr(              keystorage_addr), 
    .keystorage_rdata(             keystorage_rdata),
    .keystorage_wdata(             keystorage_wdata),

    .sbox_mem_raddr(               sbox_mem_raddr),          
    .sbox_mem_rdata(               sbox_mem_rdata),          
    .sbox_mem_waddr(               sbox_mem_waddr),          
    .sbox_mem_ren(                 sbox_mem_ren),            
    .sbox_mem_wen(                 sbox_mem_wen),            
    .sbox_mem_wdata(               sbox_mem_wdata),      

    .mpif_txfifo_ren(              mpif_txfifo_ren),  
    .mpif_txfifo_raddr(            mpif_txfifo_raddr),
    .mpif_txfifo_rdata(            mpif_txfifo_rdata),
    .mpif_txfifo_wen(              mpif_txfifo_wen),  
    .mpif_txfifo_waddr(            mpif_txfifo_waddr),
    .mpif_txfifo_wdata(            mpif_txfifo_wdata),

    .mpif_rxfifo_ren(              mpif_rxfifo_ren),   
    .mpif_rxfifo_raddr(            mpif_rxfifo_raddr), 
    .mpif_rxfifo_rdata(            mpif_rxfifo_rdata), 
    .mpif_rxfifo_wen(              mpif_rxfifo_wen),   
    .mpif_rxfifo_waddr(            mpif_rxfifo_waddr), 
    .mpif_rxfifo_wdata(            mpif_rxfifo_wdata), 

    .mibtable_en(                  mibtable_en),    
    .mibtable_wen(                 mibtable_wen),   
    .mibtable_addr(                mibtable_addr),  
    .mibtable_rdata(               mibtable_rdata), 
    .mibtable_wdata(               mibtable_wdata), 

    .sharedram_en(                 sharedram_en),   
    .sharedram_addr(               sharedram_addr), 
    .sharedram_wen(                sharedram_wen),  
    .sharedram_wdata(              sharedram_wdata),
    .sharedram_rdata(              sharedram_rdata),

`ifdef  RW_HSU_RSA_EN
    .rsa_sram_en(                  rsa_sram_en),
    .rsa_sram_addr(                rsa_sram_addr),
    .rsa_sram_wen(                 rsa_sram_wen),
    .rsa_sram_wdata(               rsa_sram_wdata),
    .rsa_sram_rdata(               rsa_sram_rdata),
`endif//RW_HSU_RSA_EN

    .fft0mem0_wen(                 fft0mem0_wen),  
    .fft0mem0_waddr(               fft0mem0_waddr),
    .fft0mem0_wdata(               fft0mem0_wdata),
    .fft0mem0_ren(                 fft0mem0_ren),  
    .fft0mem0_raddr(               fft0mem0_raddr),
    .fft0mem0_rdata(               fft0mem0_rdata),

    .fft0mem1_wen(                 fft0mem1_wen),  
    .fft0mem1_waddr(               fft0mem1_waddr),
    .fft0mem1_wdata(               fft0mem1_wdata),
    .fft0mem1_ren(                 fft0mem1_ren),  
    .fft0mem1_raddr(               fft0mem1_raddr),
    .fft0mem1_rdata(               fft0mem1_rdata),

    .fft0mem2_wen(                 fft0mem2_wen),  
    .fft0mem2_waddr(               fft0mem2_waddr),
    .fft0mem2_wdata(               fft0mem2_wdata),
    .fft0mem2_ren(                 fft0mem2_ren),  
    .fft0mem2_raddr(               fft0mem2_raddr),
    .fft0mem2_rdata(               fft0mem2_rdata),

    .fft0mem3_wen(                 fft0mem3_wen),  
    .fft0mem3_waddr(               fft0mem3_waddr),
    .fft0mem3_wdata(               fft0mem3_wdata),
    .fft0mem3_ren(                 fft0mem3_ren),  
    .fft0mem3_raddr(               fft0mem3_raddr),
    .fft0mem3_rdata(               fft0mem3_rdata),

    .fft0mem4_wen(                 fft0mem4_wen),  
    .fft0mem4_waddr(               fft0mem4_waddr),
    .fft0mem4_wdata(               fft0mem4_wdata),
    .fft0mem4_ren(                 fft0mem4_ren),  
    .fft0mem4_raddr(               fft0mem4_raddr),
    .fft0mem4_rdata(               fft0mem4_rdata),

    .fft0mem5_wen(                 fft0mem5_wen),  
    .fft0mem5_waddr(               fft0mem5_waddr),
    .fft0mem5_wdata(               fft0mem5_wdata),
    .fft0mem5_ren(                 fft0mem5_ren),  
    .fft0mem5_raddr(               fft0mem5_raddr),
    .fft0mem5_rdata(               fft0mem5_rdata),

    .bdfd_wen(                     bdfd_wen),   
    .bdfd_waddr(                   bdfd_waddr), 
    .bdfd_wdata(                   bdfd_wdata), 
    .bdfd_ren(                     bdfd_ren),   
    .bdfd_raddr(                   bdfd_raddr), 
    .bdfd_rdata(                   bdfd_rdata),

`ifdef RW_BFMEE_EN
    .bfmee_en(                     bfmee_en),      
    .bfmee_wen(                    bfmee_wen),    
    .bfmee_addr(                   bfmee_addr),
    .bfmee_wdata(                  bfmee_wdata),  
    .bfmee_rdata(                  bfmee_rdata),  
`endif
    
`ifdef RW_NX_LDPC_ENC
    /* LDPC */
    .ldpc0tx0_en(                  ldpc0tx0_en),
    .ldpc0tx0_addr(                ldpc0tx0_addr),
    .ldpc0tx0_wdata(               ldpc0tx0_wdata),
    .ldpc0tx0_wen(                 ldpc0tx0_wen),
    .ldpc0tx0_rdata(               ldpc0tx0_rdata),
    
    .ldpc0tx1_en(                  ldpc0tx1_en),
    .ldpc0tx1_addr(                ldpc0tx1_addr),
    .ldpc0tx1_wdata(               ldpc0tx1_wdata),
    .ldpc0tx1_wen(                 ldpc0tx1_wen),
    .ldpc0tx1_rdata(               ldpc0tx1_rdata),
`endif // RW_NX_LDPC_ENC

`ifdef RW_NX_LDPC_DEC
    .ldpcrx0_cfg_addr(             ldpcrx0_cfg_addr),
    .ldpcrx0_cfg_en(               ldpcrx0_cfg_en),
    .ldpcrx0_cfg_wen(              ldpcrx0_cfg_wen),
    .ldpcrx0_cfg_wdata(            ldpcrx0_cfg_wdata),
    .ldpcrx0_cfg_rdata(            ldpcrx0_cfg_rdata),
  
    .ldpcrx0_cr_waddr(             ldpcrx0_cr_waddr),  
    .ldpcrx0_cr_raddr(             ldpcrx0_cr_raddr),  
    .ldpcrx0_cr_wdata(             ldpcrx0_cr_wdata),  
    .ldpcrx0_cr_ren(               ldpcrx0_cr_ren),    
    .ldpcrx0_cr_wen(               ldpcrx0_cr_wen),    
    .ldpcrx0_cr_rdata(             ldpcrx0_cr_rdata),  
  
    .ldpcrx0_vr_waddr(             ldpcrx0_vr_waddr),  
    .ldpcrx0_vr_raddr(             ldpcrx0_vr_raddr),  
    .ldpcrx0_vr_wdata(             ldpcrx0_vr_wdata),  
    .ldpcrx0_vr_ren(               ldpcrx0_vr_ren),    
    .ldpcrx0_vr_wen(               ldpcrx0_vr_wen),    
    .ldpcrx0_vr_rdata(             ldpcrx0_vr_rdata),  
  
    .ldpcrx0_vmx_waddr(            ldpcrx0_vmx_waddr), 
    .ldpcrx0_vmx_raddr(            ldpcrx0_vmx_raddr), 
    .ldpcrx0_vmx_wdata(            ldpcrx0_vmx_wdata), 
    .ldpcrx0_vmx_ren(              ldpcrx0_vmx_ren),   
    .ldpcrx0_vmx_wen(              ldpcrx0_vmx_wen),   
    .ldpcrx0_vmx_rdata(            ldpcrx0_vmx_rdata), 

    .ldpcrx0_vmy_waddr(            ldpcrx0_vmy_waddr), 
    .ldpcrx0_vmy_raddr(            ldpcrx0_vmy_raddr), 
    .ldpcrx0_vmy_wdata(            ldpcrx0_vmy_wdata), 
    .ldpcrx0_vmy_ren(              ldpcrx0_vmy_ren),   
    .ldpcrx0_vmy_wen(              ldpcrx0_vmy_wen),
    .ldpcrx0_vmy_rdata(            ldpcrx0_vmy_rdata), 
  
    .ldpcrx0_hd_waddr(             ldpcrx0_hd_waddr),  
    .ldpcrx0_hd_wdata(             ldpcrx0_hd_wdata),  

    .ldpcrx0_hdx_raddr(            ldpcrx0_hdx_raddr), 
    .ldpcrx0_hdx_rdata(            ldpcrx0_hdx_rdata), 
    .ldpcrx0_hdx_ren(              ldpcrx0_hdx_ren),   
    .ldpcrx0_hdx_wen(              ldpcrx0_hdx_wen),   
  
    .ldpcrx0_hdy_raddr(            ldpcrx0_hdy_raddr), 
    .ldpcrx0_hdy_wen(              ldpcrx0_hdy_wen),  
    .ldpcrx0_hdy_ren(              ldpcrx0_hdy_ren),   
    .ldpcrx0_hdy_rdata(            ldpcrx0_hdy_rdata),
`endif // RW_NX_LDPC_DEC

`ifdef RW_RADAR_EN
    .radarmem_addr(                radarmem_addr), 
    .radarmem_en(                  radarmem_en), 
    .radarmem_wren(                radarmem_wren), 
    .radarmem_wrdata(              radarmem_wrdata),
    .radarmem_rddata(              radarmem_rddata),
`endif
    
    .agcmem_addr(                  agcmem_addr),   
    .agcmem_en(                    agcmem_en),   
    .agcmem_wren(                  agcmem_wren),   
    .agcmem_wrdata(                agcmem_wrdata), 
    .agcmem_rddata(                agcmem_rddata)
    );

  /*****************************************************************************
  * CRM
  *****************************************************************************/
  rw_he_crm u_rw_he_crm
  (
    /* system */
    .sys_rst_n(                    sys_rst_n),         //System reset input
    .ref0_root_clk(                ref0_root_clk),     //reference modem clock 240/480
    .ref1_root_clk(                ref1_root_clk),     //reference mac clock 80
    // for ADC/DAC
    .fe_clk(                       fe_clk),  
    .fe_rst_n(                     fe_rst_n),  
`ifndef RW_CRM_FPGA
    .plf_root_clk(                 plf_root_clk),      //ASIC: Platform root clock is an input
    .mac_lp_root_clk(              mac_lp_root_clk),   //ASIC: Low-Power root clock is an input
`else
    .global_rst_n(                 global_rst_n),
    // for ADC/DAC controllers
    .ref80_clk(                    ref80_clk), 
    .ref80_rst_n(                  ref80_rst_n), 
    // CPU subsys
    .axi_aclk(                     axi_aclk),
    .axi_por_n(                    axi_por_n),
`endif

    /* reset requests */
    .plf_swrsten_n(                plf_swrsten_n),
    .phywdog_hwrsten_n(            phywdog_hwrsten_n),
  
    /* clock enables  */
    .mac_pi_clken(                 mac_pi_clken),      // Clock Enable for macPriClk Clocks
    .mac_pi_tx_clken(              mac_pi_tx_clken),   // Clock Enable for macPITxClk Clock
    .mac_pi_rx_clken(              mac_pi_rx_clken),   // Clock Enable for macPIRxClk Clock
    .mac_core_clken(               mac_core_clken),    // Clock Enable for macPIRxClk Clock
    .mac_core_tx_clken(            mac_core_tx_clken), // Clock Enable for macCoreTxClk Clock
    .mac_core_rx_clken(            mac_core_rx_clken), // Clock Enable for macCoreRxClk Clock
    .mac_crypt_clken(              mac_crypt_clken),   // Clock Enable for macCryptClk Clock
    .mac_wt_clken(                 mac_wt_clken),      // Clock Enable for macWTClk Clock
    .mac_lp_clkswitch(             mac_lp_clkswitch),  // Lowpower clock switch           
    .macbypass_clken(              macbypass_clken),
    .mpif_clken(                   mpif_clken),
    .phy_clken(                    mpif_clken),        // same control as mpif_clken
    .phytx_clken(                  phytx_clken),
    .tbe_clken(                    tbe_clken),              
    .tdfoest_clken(                tdfoest_clken),              
    .channelest_clken(             channelest_clken),              
    .tdcomp_clken(                 tdcomp_clken),              
    .equ_clken(                    equ_clken),              
    .fdo_clken(                    fdo_clken),              
    .fft0_clken(                   fft0_clken),
`ifdef RW_BFMEE_EN
    .svd_free_clken(               mpif_clken),        // same control as mpif_clken
    .svd_clken(                    svd_clken),
`endif //  RW_BFMEE_EN
    .vtb_clken(                    vtb_clken),
    .vtbcore0_clken(               vtbcore0_clken),
`ifdef RW_NX_LDPC_DEC
    .ldpcrx0_clken(                ldpcrx0_clken),
    .ldpcrx0_dec_clken(            ldpcrx0_dec_clken),
`endif // RW_NX_LDPC_DEC
`ifdef RW_NX_LDPC_ENC
    .ldpc0tx0_clken(               ldpc0tx0_clken),
`endif // RW_NX_LDPC_ENC
    .fe40_clken(                   fe40_clken),
    .fe44_clken(                   fe40_clken),        // same control as fe40_clken
`ifdef RW_NX_DERIV_FE_PATH40M
    .fe80_clken(                   fe80_clken),  
`endif // RW_NX_DERIV_FE_PATH40M
`ifdef RW_NX_DERIV_FE_PATH80M
//     .fe160_clken(                  fe160_clken),    // TBD: add 160MHz generation into CRM
`endif // RW_NX_DERIV_FE_PATH80M
    .agc_clken(                    agc_clken),
    .agcmem_clken(                 agcmem_clken),
    .ferx_clken(                   ferx_clken),
    .fetx_clken(                   fetx_clken),
    
    .mdmb_clken(                   mdmb_clken),
    .mdmb_clkskip(                 mdmb_clkskip),
    .mdmbrx_clken(                 mdmbrx_clken),
    .mdmbtx_clken(                 mdmbtx_clken),
    
    /* resets */
    .plf_por_n(                    plf_por_n),
    .plf_rst_n(                    plf_rst_n),         //Active low hard reset signal synchronized to the plf_clk.
    .mac_core_rst_n(               mac_core_rst_n),    //Active low hard reset signal synchronized to the mac_core_clk.
    .mac_wt_rst_n(                 mac_wt_rst_n),      //Active low hard reset signal synchronized to the mac_wt_lk.
    .mac_mpif_rst_n(               mac_mpif_rst_n),
`ifdef  RW_EMBEDDED_LA
    .la_rst_n(                     la_rst_n),
`endif//RW_EMBEDDED_LA
    .phy_rst_n(                    phy_rst_n),
    .rxbd_rst_n(                   rxbd_rst_n),
    .mdmb_rst_n(                   mdmb_rst_n),
    .fe44_rst_n(                   fe44_rst_n),
    .fe40_rst_n(                   fe40_rst_n),
`ifdef RW_NX_DERIV_FE_PATH40M
    .fe80_rst_n(                   fe80_rst_n),  
`endif // RW_NX_DERIV_FE_PATH40M
    .rc_rst_n(                     rc_rst_n),
    .agc_rst_n(                    agc_rst_n),
    .radar_rst_n(                  radar_rst_n),

    /* clocks */
    .plf_clk(                      plf_clk),           //Platform Clock
    .mac_pi_clk(                   mac_pi_clk),        //Primary MAC Platform Interface Clock
    .mac_pi_tx_clk(                mac_pi_tx_clk),     //Secondary MAC Platform Interface Clock for TX
    .mac_pi_rx_clk(                mac_pi_rx_clk),     //Secondary MAC Platform Interface Clock for RX
    .mac_core_clk(                 mac_core_clk),      //Primary MAC Core Clock
    .mac_core_tx_clk(              mac_core_tx_clk),   //Secondary MAC Core Clock for TX
    .mac_core_rx_clk(              mac_core_rx_clk),   //Secondary MAC Core Clock for RX
    .mac_crypt_clk(                mac_crypt_clk),     //Secondary MAC Crypt Clock for CryptoEngine
    .mac_lp_clk(                   mac_lp_clk),        //MAC Low Power clock.
    .mac_wt_clk(                   mac_wt_clk),        //Clock for WEP/TKIP blocks.
    .macbypass_clk(                macbypass_clk),    
    .mpif_clk(                     mpif_clk),          //Clock for Mpif.
`ifdef  RW_EMBEDDED_LA
    .la_clk(                       la_clk),
`endif//RW_EMBEDDED_LA
    /* riu */
    .rc_clk(                       rc_clk),
    .fe40_clk(                     fe40_clk),
    .fe44_clk(                     fe44_clk),
`ifdef RW_NX_DERIV_FE_PATH40M
    .fe80_clk(                     fe80_clk),  
`endif // RW_NX_DERIV_FE_PATH40M
    .agc_clk(                      agc_clk),
    .agcmem_clk(                   agcmem_clk),
    .adcpow_clk(                   adcpow_clk),
    .ferxpath_clk(                 ferxpath_clk),
    .fetxpath_clk(                 fetxpath_clk),
    .radar_clk(                    radar_clk),
    /* phy */
    .phy_clk(                      phy_clk),
    .phytx_clk(                    phytx_clk),
    .tbe_clk(                      tbe_clk),              
    .tdfoest_clk(                  tdfoest_clk),              
    .tdcomp_clk(                   tdcomp_clk),              
    .channelest_clk(               channelest_clk),              
    .equ_clk(                      equ_clk),              
    .fdo_clk(                      fdo_clk),              
    .fft0_clk(                     fft0_clk),
`ifdef RW_BFMEE_EN
    .svd_clk(                      svd_clk),
    .svd_gclk(                     svd_gclk),
`endif //  RW_BFMEE_EN
    .vtb_clk(                      vtb_clk),
    .vtbcore0_clk(                 vtbcore0_clk),
`ifdef RW_NX_LDPC_DEC
    .ldpcrx0_clk(                  ldpcrx0_clk),
    .ldpcrx0_dec_clk(              ldpcrx0_dec_clk),
`endif // RW_NX_LDPC_DEC
`ifdef RW_NX_LDPC_ENC
    .ldpc0tx0_clk(                 ldpc0tx0_clk),
`endif // RW_NX_LDPC_ENC
    /* mdmb */
    .mdmb_clk(                     mdmb_clk),
    .mdmbrx_clk(                   mdmbrx_clk),
    .mdmbtx_clk(                   mdmbtx_clk),
    
    /* Registers */
    .la_sampling_freq(             la_sampling_freq),

    /* AHB interface */
    .hready_in(                    crm_hready_in),
    .hsel     (                    crm_hsel     ),
    .haddr    (                    crm_haddr    ),
    .htrans   (                    crm_htrans   ),
    .hwrite   (                    crm_hwrite   ),
    .hwdata   (                    crm_hwdata   ),
    .hrdata   (                    crm_hrdata   ),
    .hresp    (                    crm_hresp    ),
    .hready   (                    crm_hready   )
   
  );

endmodule
`default_nettype wire
/*******************************************************************************
* End of file
*******************************************************************************/
