`default_nettype none
module rw_he_top_wrapper_tb;
  
  /*****************************************************************************
  * declarations
  *****************************************************************************/
`ifndef RW_CRM_FPGA
  reg  ref_root_clk;
  reg  mac_core_root_clk;
`else
  reg  ref0_fpga_root_clk;
  reg  ref1_fpga_root_clk;
`endif

  reg  mac_lp_root_clk;
  reg  plf_root_clk;
  reg  sys_rst_n;

  /*****************************************************************************
  * clock generation
  *****************************************************************************/
`ifndef RW_CRM_FPGA
  always
  begin
    #2.083 ref_root_clk = 1'b1;
    #2.083 ref_root_clk = 1'b0;
    #2.083 ref_root_clk = 1'b1;
    #2.083 ref_root_clk = 1'b0;
    #2.083 ref_root_clk = 1'b1;
    #2.084 ref_root_clk = 1'b0;
    #2.083 ref_root_clk = 1'b1;
    #2.084 ref_root_clk = 1'b0;
    #2.083 ref_root_clk = 1'b1;
    #2.084 ref_root_clk = 1'b0;
    #2.083 ref_root_clk = 1'b1;
    #2.084 ref_root_clk = 1'b0;
  end
  
  always
  begin
    #6.25  mac_core_root_clk  = 1'b1;
    #6.25  mac_core_root_clk  = 1'b0;
  end
`else
  always
  begin
    #12.5  ref0_fpga_root_clk = 1'b1;
    #12.5  ref0_fpga_root_clk = 1'b0;
  end
  
  always
  begin
    #20.0  ref1_fpga_root_clk  = 1'b1;
    #20.0  ref1_fpga_root_clk  = 1'b0;
  end
`endif
  
  always
  begin
    #15625 mac_lp_root_clk = 1'b1;
    #15625 mac_lp_root_clk = 1'b0;
  end
  
  always
  begin
    #5.0  plf_root_clk  = 1'b1;
    #5.0  plf_root_clk  = 1'b0;
  end
  
  
  
  initial
  begin
    sys_rst_n  = 1'b0;
    repeat(2) @(posedge mac_lp_root_clk);
    sys_rst_n <= 1'b1;
    
    repeat(50) @(posedge mac_lp_root_clk);
    
    $stop();
  end



  /*********************************************************************************
  *
  ********************************************************************************/
  rw_he_top_wrapper u_rw_he_top_wrapper
  (
    /*****************************************************************************
    * $port_g Clocks & Resets Inputs
    *****************************************************************************/
    /* $port_g system resets */
    .sys_rst_n(            sys_rst_n),
     
    /* $port_g rw_nx_platform clock */ 
`ifndef RW_CRM_FPGA
    .ref0_root_clk(        ref_root_clk),          //240
    .ref1_root_clk(        mac_core_root_clk),     //80
`else
    .ref0_root_clk(        ref0_fpga_root_clk),    //40
    .ref1_root_clk(        ref1_fpga_root_clk),    //25
`endif
    
    .plf_clk(              ),
    .plf_rst_n(            ),
    .plf_por_n(            ),
    
`ifndef RW_CRM_FPGA
    .plf_root_clk(         plf_root_clk),      //100      
    .mac_lp_root_clk(      mac_lp_root_clk),   //32k    
`else
    .global_rst_n(         sys_rst_n),
    .ref80_clk(            ),  
    .ref80_rst_n(          ),
    .axi_aclk(             plf_root_clk),
    .axi_por_n(            ),
`endif

    /* $port_g rw_nx_platform clock enables */
    .platform_wake_up(     ),
    
    /*****************************************************************************
    //$port_g Processor (firmware)  AHB interface
    *****************************************************************************/
    .proc_hready(          ),    
    .proc_hready_in(       1'b1), 
    .proc_haddr(           28'b0), 
    .proc_htrans(          2'b0), 
    .proc_hwrite(          1'b0), 
    .proc_hsize(           2'b0), 
    .proc_hrdata(          ),    
    .proc_hwdata(          32'b0), 
    .proc_hresp(           ),    
    
    /*****************************************************************************
    //$port_g Interrupt sources
    *****************************************************************************/
    .host_irq(             ), 
    .proc_irq(             ), 
    .cpu_single_irq(       ), 
    .tick_timer_irq(       ), 
    .soft_irq(             ), 
    
    /*****************************************************************************
    //$port_g GPIO interface
    *****************************************************************************/
    .gpio_out(             ),        
    .gpio_in(              'b0),     
    .gpio_oen(             ),        
    
  `ifdef RW_COEX_MODEL
    /*****************************************************************************
    //$port_g AHB to Coexistence interface
    *****************************************************************************/
    .coexif_hready_in(     ),    
    .coexif_hsel(          ),    
    .coexif_haddr(         ),    
    .coexif_htrans(        ),    
    .coexif_hwrite(        ),    
    .coexif_hrdata(        'b0), 
    .coexif_hwdata(        ),    
    .coexif_hresp(         2'b0),
    .coexif_hready(        1'b1),
  `endif // RW_COEX_MODEL

  `ifdef RW_WLAN_COEX_EN
    /*****************************************************************************
    //$port_g Bluetooth Coexistence Interface
    *****************************************************************************/
    .coex_bt_tx(           1'b1),  
    .coex_bt_rx(           1'b1),  
    .coex_bt_event(        1'b1),  
    .coex_bt_tx_abort(     ),      
    .coex_bt_rx_abort(     ),      
    .coex_bt_pti(          1'b1),  
    .coex_bt_channel(      1'b1),  
    .coex_bt_bw(           1'b1),  
  `endif // RW_WLAN_COEX_EN

    /*****************************************************************************
    //$port_g RC Coexistence interface
    *****************************************************************************/
    .rc_tx_abort(          ), 
    .rc_rx_abort(          ), 
    
    /*****************************************************************************
    //$port_g AXI Interface
    *****************************************************************************/
    //$port_g  upstream interface
    .dma0_awid(            ),   
    .dma0_awaddr(          ),   
    .dma0_awlen(           ),   
    .dma0_awsize(          ),   
    .dma0_awburst(         ),   
    .dma0_awuser(          ),   
    .dma0_awvalid(         ),   
    .dma0_awready(         1'b1), 
                                                                   
    .dma0_wid(             ),
    .dma0_wdata(           ),
    .dma0_wstrb(           ),
    .dma0_wlast(           ),
    .dma0_wvalid(          ),
    .dma0_wready(          1'b1),       
                                                                   
    .dma0_bid(             4'b0),  
    .dma0_bresp(           2'b0),  
    .dma0_bvalid(          1'b0),   
    .dma0_bready(          ),     

    //$port_g  downstream interface
    .dma1_arid(            ),       
    .dma1_araddr(          ),       
    .dma1_arlen(           ),       
    .dma1_arsize(          ),       
    .dma1_arburst(         ),       
    .dma1_arvalid(         ),       
    .dma1_arready(         1'b1),   
                                                                
    .dma1_rid(             4'b0),   
    .dma1_rdata(           64'b0),   
    .dma1_rresp(           2'b0),   
    .dma1_rlast(           1'b0),   
    .dma1_rvalid(          ),      
    .dma1_rready(          ),         // DMA Downstream rready
    
    /*****************************************************************************
    //$port_g ADC Interface
    *****************************************************************************/
    .adc0_on(              ),
    .adc0_i(               ),
    .adc0_q(               ),

    /*****************************************************************************
    //$port_g DAC Interface
    *****************************************************************************/
    .dac0_on(              ),       
    .dac0_en(              ),       
    .dac0_i(               ),       
    .dac0_q(               ),       
    
    /*******************************************************************
    //$port_g RF interface
    *******************************************************************/
    .rf_resetn(            ),  
    .rf_agcfreeze(         ),  
    .rf_tmode(             ),  
    .rf_gpio(              ),  
    .rf_spi_in(            ),  
    .rf_spi_ss_n(          ),  
    .rf_spi_clk(           ),  
    .rf_spi_out(           ),  
    .rf_trsw0(             ),  
    .rf_extpaon_ch0_5G9(   ),  
    .rf_extpaon_ch0_2G4(   ),  
   
  `ifdef RW_FPGA_AHB
    /*****************************************************************************
    //$port_g  AHB to FPGA
    *****************************************************************************/
    .fpga_hready_in(       ),  
    .fpga_hsel(            ),       
    .fpga_haddr(           ),      
    .fpga_htrans(          ),     
    .fpga_hwrite(          ),     
    .fpga_hrdata(          32'b0), 
    .fpga_hwdata(          ),      
    .fpga_hresp(           2'b0,   
    .fpga_hready(          1'b1),  
  `endif // RW_FPGA_AHB
  
    .ext_diagport(         32'b0),        
    .reg_bootrom_enable(   ),  
    
    .rw_nx_ss_diag(        ),    
    .rw_nx_diag0(          ),      
    .rw_nx_diag1(          ),      
    .rw_nx_diag2(          ),     
    .rw_nx_diag3(          ),     
    .rw_nx_diag4(          ),     
    .rw_nx_diag5(          ),     
    .rw_nx_diag6(          ),     
    .mac_internal_error(   ),    
    .mac_debug_ksr(        1'b0),   
    .macbypass_trigger(    ),    
    .reg_diag_trigger(     )      
  );


endmodule
`default_nettype wire
