#!/bin/sh
#/////////////////////////////////////////////////////////////////////////////
#/  Copyright (C) by RivieraWaves.
#/  This module is a confidential and proprietary property of RivieraWaves
#/  and a possession or use of this module requires written permission 
#/  from RivieraWaves.
#/----------------------------------------------------------------------------
#/ $Author: $
#/ Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/ $Revision: $
#/ $Date: $
#/ ---------------------------------------------------------------------------
#/ Dependencies     : None
#/ Description      : Hal script for rw_he_top_cpu
#/ Application Note :
#/ Terms & concepts :
#/ Bugs             :
#/ Open issues and future enhancements :
#/ References       :
#/ Revision History :
#/ ---------------------------------------------------------------------------
#/
#/
#/////////////////////////////////////////////////////////////////////////////


#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
#--- Display Help                                                 ---#
#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
DisplayHelp()
{
echo "
  This script runs lint check with Cadence Hal.
  
  Options:
    -nogui                 : Run lint in no gui mode.      

    -d | -define           : Add define for compilation

    -help                  : Display this message
"
}

#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
#--- Main                                                         ---#
#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
STARTDATE=`date +%s`
GUI="-gui"
DEFINES=""

while test $# != 0
do
  arg="$1"
  OPTION=`echo $arg | sed 's/^-//'`
  shift
  case ${OPTION}
  in
    nogui)  
      #------------------------------------------------------------------------#
      #--- Run with no gui                                                  ---#
      #------------------------------------------------------------------------#
      GUI=""
    ;;
    d | define)
      DEFINES="$DEFINES -define $1"
      shift
    ;;
    help)  
      #------------------------------------------------------------------------#
      #--- Display Help                                                     ---#
      #------------------------------------------------------------------------#
      DisplayHelp
      exit 1
    ;;
  esac
done

# OS Version detection (64 bits)
if [ `uname -p` = "x86_64"  ]
then
  OS_OPTION="-64BIT"
fi


# Create file list
create_comp_file.pl rw_he_top_cpu rtl comp_file

# Run HAL tool
hal $GUI $OS_OPTION $DEFINES -licqueue -stats -logfile rw_he_top_cpu.log -sv -top rw_he_top_cpu -file comp_file -rulefile $SOURCESLIB/env/HAL_RULES/local_hal.def &

ENDDATE=`date +%s`
DURATION=$(($ENDDATE-$STARTDATE))
echo $DURATION > duration.txt

#-------------------------------------------------------------------------------
#- End of file
#-------------------------------------------------------------------------------
