#!/bin/sh
#/////////////////////////////////////////////////////////////////////////////
#/  Copyright (C) by RivieraWaves.
#/  This module is a confidential and proprietary property of RivieraWaves
#/  and a possession or use of this module requires written permission 
#/  from RivieraWaves.
#/----------------------------------------------------------------------------
#/ $Author: $
#/ Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/ $Revision:  $
#/ $Date:  $
#/ ---------------------------------------------------------------------------
#/ Dependencies     : None
#/ Description      : spyglass script for rw_he_top_cpu_cpu
#/ Application Note :
#/ Terms & concepts :
#/ Bugs             :
#/ Open issues and future enhancements :
#/ References       :
#/ Revision History :
#/ ---------------------------------------------------------------------------
#/
#/
#/////////////////////////////////////////////////////////////////////////////


#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
#--- Display Help                                                 ---#
#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
DisplayHelp()
{
echo "
  This script runs lint and cdc checks with Atrenta Spyglass.
  
  Options:
  --------
    -nogui                 : Run lint in no gui mode.      

    -d | -define           : Add define for compilation

    -sdc <sdc file>        : Specify the SDC file to be used for CDC

    -cdc                   : Enable CDC check

    -lint                  : Enable Lint check

    -config <name>         : Select configuration of the DUT "
  CONFIGLIST=`find $SOURCESLIB/env/CONF/ -type f -name "*.v"| grep "$SOURCESLIB/env/CONF/config" | sed 's/.*\/env\/CONF\///'  | sed 's/\.v//' | sort -u`
  echo "                           Available configuration list :"
  for CONFIGNAME in ${CONFIGLIST}
  do
    echo "                            - $CONFIGNAME"
  done
  echo " 
                              
    -help                  : Display this message
    
    
  Examples:
  ---------
    
      To launch spyglass in gui mode
      >spyglass_run.sh -config <config name>

      To run Lint check with spyglass in batch mode
      >spyglass_run.sh -lint -nogui -config <config name>

      To run CDC check with spyglass in batch mode
      >spyglass_run.sh -cdc -sdc <sdcfile> -nogui -config <config name>
"
}


#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
#--- Parse Config                                                 ---#
#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
ParseConfig()
{
  BFMEE=`grep -v // ${IP_CONFIG_PATH} | egrep -c RW_MUMIMO_RX_EN`
  MUMIMOTX=`grep -v // ${IP_CONFIG_PATH} | egrep -c RW_MUMIMO_TX`
  COEX=`grep -v // ${IP_CONFIG_PATH} | egrep -c RW_WLAN_COEX_EN`
  FIQ=`grep -v // ${IP_CONFIG_PATH} | egrep -c RW_NX_FIQ_COMP_EN`
  IQ=`grep -v // ${IP_CONFIG_PATH} | egrep -c RW_NX_IQ_COMP_EN`
  CHBW20=`grep -v // ${IP_CONFIG_PATH} | egrep -c CHBW20`
  CHBW4020=`grep -v // ${IP_CONFIG_PATH} | egrep -c CHBW4020`
  CHBW804020=`grep -v // ${IP_CONFIG_PATH} | egrep -c CHBW804020`
  TXRX2X2=`grep -v // ${IP_CONFIG_PATH} | egrep -c RW_TXRX_2X2`
  TXRX1X1=`grep -v // ${IP_CONFIG_PATH} | egrep -c RW_TXRX_1X1`

  echo TXRX1X1 $TXRX1X1
  echo TXRX2X2 $TXRX2X2
  echo CHBW20 $CHBW20
  echo CHBW4020 $CHBW4020
  echo CHBW804020 $CHBW804020
  echo MUMIMOTX $MUMIMOTX
  echo BFMEE $BFMEE
  echo COEX $COEX
  echo FIQ $FIQ
  echo IQ $IQ
  CONFIG=""
  if [ "$TXRX1X1" == 1 ]
  then
    CONFIG="TXRX1X1 $CONFIG"
  fi
  if [ "$TXRX2X2" == 1 ]
  then
    CONFIG="TXRX2X2 $CONFIG"
  fi
  if [ "$CHBW20" == 1 ]
  then
    CONFIG="CHBW20 $CONFIG"
  fi
  if [ "$CHBW4020" == 1 ]
  then
    CONFIG="CHBW4020 $CONFIG"
  fi
  if [ "$CHBW804020" == 1 ]
  then
    CONFIG="CHBW804020 $CONFIG"
  fi
  if [ "$BFMEE" == 1 ]
  then
    CONFIG="BFMEE $CONFIG"
  fi
  if [ "$MUMIMOTX" == 1 ]
  then
    CONFIG="MUMIMOTX $CONFIG"
  fi
  if [ "$COEX" == 1 ]
  then
    CONFIG="COEX $CONFIG"
  fi
  if [ "$FIQ" == 1 ]
  then
    CONFIG="FIQ $CONFIG"
  fi
  if [ "$IQ" == 1 ]
  then
    CONFIG="IQ $CONFIG"
  fi
  #echo "CONFIG:$CONFIG"
  export SG_OPERATING_MODE=$CONFIG
  echo SG_OPERATING_MODE : \"${SG_OPERATING_MODE}\"
}

#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
#--- Main                                                         ---#
#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
STARTDATE=`date +%s`

GUI="-gui"
LINT=0
CDC=0
DEFINES="VERILATOR"
SDCNAME=""
echo "\`define VERILATOR" > defines.v
while test $# != 0
do
  arg="$1"
  OPTION=`echo $arg | sed 's/^-//'`
  shift
  case ${OPTION}
  in
    nogui)  
      #------------------------------------------------------------------------#
      #--- Run with no gui                                                  ---#
      #------------------------------------------------------------------------#
      GUI=""
    ;;
    d | define)
      DEFINES="$DEFINES -define $1"
      echo "\`define $1" >> defines.v
      shift
    ;;
    sdc )
      SDCNAME="$1"
      shift
    ;;
    lint )
      LINT=1
    ;;
    cdc )
      CDC=1
    ;;
    config)  
      if test $# = 0
      then
        echo "ERROR : Configuration name missing"
        echo "Please choose between available configuration : "
        #------------------------------------------------------------------------#
        #--- List the available configuration                                 ---#
        #------------------------------------------------------------------------#
        CONFIGLIST=`find $SOURCESLIB/env/CONF/ -type f -name "*.v"| grep "$SOURCESLIB/env/CONF/config" | sed 's/.*\/env\/CONF\///'  | sed 's/\.v//' `
        echo "Available configuration list :"
        echo "------------------------------"
        for CONFIGNAME in ${CONFIGLIST}
        do
          echo " - $CONFIGNAME"
        done
        echo
        exit 1
      else
        export IP_CONFIG_NAME="${1}"
        echo
        echo "Configured with ${SOURCESLIB}/env/CONF/$IP_CONFIG_NAME.v"
        echo
        IP_CONFIG_PATH="${SOURCESLIB}/env/CONF/$IP_CONFIG_NAME.v"
        shift
      fi
    ;;
    help)  
      #------------------------------------------------------------------------#
      #--- Display Help                                                     ---#
      #------------------------------------------------------------------------#
      DisplayHelp
      exit 1
    ;;
  esac
done

# OS Version detection (64 bits)
if [ `uname -p` = "x86_64"  ]
then
  OS_OPTION="-full64"
fi



if [ "${IP_CONFIG_PATH}" == "" ]
then
  echo "ERROR! -config <configuration name> missing"
  DisplayHelp
  exit
fi

if [ ! -e ${IP_CONFIG_PATH} ]
then
  echo "ERROR! Specified configuration files ${IP_CONFIG_NAME} does not exists (${IP_CONFIG_PATH})"
  DisplayHelp
  exit
fi


if [ $CDC == 1 ]
then
  if [ -e ${SDCNAME} ]
  then
    if [ -e rw_he_top_cpu.sdc ]
    then 
      rm rw_he_top_cpu.sdc
    fi
    ln -s $SDCNAME rw_he_top_cpu.sdc
  fi  
fi

if [ ! -e rw_he_top_cpu.sdc ]
then 
  touch rw_he_top_cpu.sdc
fi

ParseConfig

# Create file list
create_comp_file.pl rw_he_top_cpu rtl rw_he_top_cpu_rtl_files.list 
create_comp_file.pl rw_he_top_cpu tb rw_he_top_cpu_tb_files.list 
\rm -f verilog_files.list
echo "defines.v" > verilog_files.list   
echo "${IP_CONFIG_NAME}"    
echo "${IP_CONFIG_PATH}" >> verilog_files.list    
cat rw_he_top_cpu_rtl_files.list | egrep -v memory_models >> verilog_files.list                        
cat rw_he_top_cpu_tb_files.list | egrep -v memory_models >> verilog_files.list

OPTION=""

# Run SpyGlass tool
if [ "$GUI" = "-gui"  ]
then
  spyglass -project rw_he_top_cpu_spyglass.prj -gui=se
else
  if [ $LINT == 1 ]
  then
    OPTION="$OPTION -goal lint/lint_rtl "
  fi

  if [ $CDC == 1 ]
  then
    #OPTION="$OPTION -goal cdc/cdc_verify@original  -goal cdc/cdc_verify@low_power  "
    OPTION="$OPTION -goal cdc/cdc_verify@original  "
  fi
  echo "spyglass -project rw_he_top_cpu_spyglass.prj -batch $OPTION"
  TEST=1
  while [ $TEST != 0 ]
  do
    spyglass -project rw_he_top_cpu_spyglass.prj -batch $OPTION
    TEST=`egrep -c "LICENSE FAILURE NOTIFICATION" spyglass_results_${IP_CONFIG_NAME}/rw_he_top_cpu_spyglass/spyglass.out`
    sleep 5
  done  
  echo
fi



ENDDATE=`date +%s`
DURATION=$(($ENDDATE-$STARTDATE))
echo $DURATION > duration.txt
echo "Duration: $DURATION sec"

#-------------------------------------------------------------------------------
#- End of file
#-------------------------------------------------------------------------------
