`default_nettype none
module sram_dual_port_model
#(
  parameter  g_addr_width = 10,
  parameter  g_data_width = 8,
  parameter  g_depth      = 0 // 0 defaults to depth = 2**g_addr_width
)
( 
  /* port 1 */
  input  wire                    clk1,
  input  wire                    en1,
  input  wire [g_addr_width-1:0] addr1,
  input  wire [g_data_width-1:0] wen1,
  input  wire [g_data_width-1:0] wdata1,
  output reg  [g_data_width-1:0] rdata1,
  
  /* port 2 */
  input  wire                    clk2,
  input  wire                    en2,
  input  wire [g_addr_width-1:0] addr2,
  input  wire [g_data_width-1:0] wen2,
  input  wire [g_data_width-1:0] wdata2,
  output reg  [g_data_width-1:0] rdata2
);

endmodule

module sram_single_port_model
#(
  parameter  g_addr_width       = 10,
  parameter  g_data_width       = 8,
  parameter  g_load_mem         = "none",
  parameter  g_depth            = 0 // 0 defaults to depth = 2**g_addr_width
)
( 
  input  wire                    clk,
  input  wire                    en,
  input  wire [g_data_width-1:0] wen,
  input  wire [g_addr_width-1:0] addr,
  input  wire [g_data_width-1:0] wdata,
  output reg  [g_data_width-1:0] rdata
);

endmodule


module sram_two_port_model
#(
  parameter g_addr_width =8,
  parameter g_data_width =32,
  parameter g_depth      =0 // 0 defaults to depth = 2**g_addr_width
)
( 
  /* write port */
  input  wire                    wclk,
  input  wire [g_data_width-1:0] wen,
  input  wire [g_addr_width-1:0] waddr,
  input  wire [g_data_width-1:0] wdata,
  
  /* read port */
  input  wire                    rclk,
  input  wire                    ren,
  input  wire [g_addr_width-1:0] raddr,                
  output reg  [g_data_width-1:0] rdata
);

endmodule

`default_nettype wire
