setenv SNPSLMD_QUEUE true
setenv SNPS_MAX_WAITTIME  14400
setenv SNPS_MAX_QUEUETIME 14400


set hdlin_enable_presto true
set hdl_naming_threshold 1
set template_naming_style "%s"
set power_preserve_rtl_hier_names true

define_design_lib WORK -path ./work
set TECHNO "40nmLP"

set REBUILD 1
set BLOCKNAME rw_he_top_cpu
source -echo $env(SOURCESLIB)/env/SYNTH/library_setup.tcl

if {$REBUILD==1} {
  # re-synthesize netlist
  analyze  -format verilog $BLOCKNAME\_syn.v

} else {
  # analysis from a previously built netlist 
  analyze -format verilog ./netlist_cdc.v
}

elaborate $BLOCKNAME

current_design $BLOCKNAME

set_wire_load_model -name $WIRELOADMODEL
set_wire_load_mode enclosed

#==============================================================================
#-- Link the design, Ungroup, Flatten hierarcy & Uniquify 
#==============================================================================
link
uniquify

#==============================================================================
#-- Setting the design constraints
#==============================================================================
current_design $BLOCKNAME

source -echo scripts/$BLOCKNAME\_constraints.tcl

#==============================================================================
#-- audit CDC
#==============================================================================
# report clock domain interactions
set timing_check_defaults {clock_crossing}
# ensure that stdout display is not shortened
set collection_result_display_limit -1
# fix feedthroughs, constantes
set_fix_multiple_port_nets -feedthroughs -constants -outputs

# ensure that sequential elements have only one input D (not E, SE,SI,etc...)
set_dont_use [list [format "%s%s"  $TARGETTECH /SDF*]]      
set_dont_use [list [format "%s%s"  $TARGETTECH /SEDF*]]      
set_dont_use [list [format "%s%s"  $TARGETTECH /CKLH*]]      
set_dont_use [list [format "%s%s"  $TARGETTECH /EDF*]]      
set_dont_use [list [format "%s%s"  $TARGETTECH /GDF*]]      
set_dont_use [list [format "%s%s"  $TARGETTECH /GSDF*]]      
set_dont_use [list [format "%s%s"  $TARGETTECH /LH*]]      
set_dont_use [list [format "%s%s"  $TARGETTECH /LN*]]      
             
# re-generate the netlist
if {$REBUILD==1} {
  compile -map_effort low
  write_file -format verilog -hierarchy -output netlist_cdc.v $BLOCKNAME
  set REBUILD 0
}


if {$REBUILD==0} {

  # Check mpIFClk clock
  # List of patterns used to exclude endpoints belonging to mpIFClk from the analysis
  set wildcardlist(mpIFClk) {".*resync_reg" ".*Resync_reg" ".*Resync_p_reg"}

  # Check macCoreClk clock
  # List of patterns used to exclude endpoints belonging to macCoreClk from the analysis
  set wildcardlist(macCoreClk) {".*resync_reg" ".*Resync_reg" ".*Resync_p_reg"}

  # Check macPIClk clock
  # List of patterns used to exclude endpoints belonging to macPIClk from the analysis
  set wildcardlist(macPIClk) {".*resync_reg" ".*Resync_reg" ".*Resync_p_reg"}

  # check_clockdomain function
  # This function checks all the paths ending on a FF clocked by clkname and coming from a FF which is not clocked by clkname
  # It does not perform the analysis on end point match one of the wildcard defined in wildcardlist.
  # It reports in reports/cdc_$clkname.txt all the paths which may have clock domain crossing issue
  # It reports in reports/cdc_$clkname.skip.txt all the paths which have been excluded by the wildcardlist
  proc check_clockdomain {clkname wildcardlist} {
  
    echo ""
    echo "Start analyse of $clkname clock domain"
    echo "wildcardlist is : $wildcardlist"
    echo ""
  
    set ep_list [ all_registers -clock $clkname]
    echo "" > reports/cdc_$clkname.txt
    echo "" > reports/cdc_$clkname.skip.txt
    foreach_in_collection ep $ep_list {
      set pin [ format "%s/D" [get_attribute $ep full_name] ]
      set skip 0
      
      foreach wildcard $wildcardlist {
        if { [regexp "$wildcard" "$pin" match]} { 
          set skip 1
        }  
      
      }

      if { $skip == 0 } {
        set sp_list [ all_fanin -to $pin -startpoints_only -flat]
        # remove ep from same domain
        set sp_list [ remove_from_collection $sp_list [all_registers -clock $clkname -clock_pin] ]
        set sp_list [ remove_from_collection $sp_list [all_inputs -clock $clkname ]]
        # remove ep from tie-off
        set sp_list [ remove_from_collection $sp_list [get_pins -of_object [all_tieoff_cells ] ] ]
      
        if { [ llength $sp_list] != 0 } {
          set ep_clk [get_net -of_object [ format "%s/CP" [get_attribute $ep full_name] ] -top_net_of_hierarchical_group -segments]
          set str [ format "EP: %-20s (%s)" [get_attribute $ep full_name] [get_attribute $ep_clk full_name] ]
          echo $str
          echo $str >> reports/cdc_$clkname.txt
          foreach_in_collection sp $sp_list {
            set sp_clk [get_net -of_object $sp -top_net_of_hierarchical_group -segments]
            set str [ format "  SP: %-20s (%s)" [get_attribute $sp full_name] [get_attribute $sp_clk full_name]  ]
            echo $str 
            echo $str >> reports/cdc_$clkname.txt
          }
        }  
      } else  {
        set ep_clk [get_net -of_object [ format "%s/CP" [get_attribute $ep full_name] ] -top_net_of_hierarchical_group -segments]
        set str [ format "SKIP EP: %-20s (%s)" [get_attribute $ep full_name] [get_attribute $ep_clk full_name] ] 
        echo $str 
        echo $str >> reports/cdc_$clkname.skip.txt
      }
    }
  
  
  
  }

  set clk_list [ all_clocks]
  foreach_in_collection nclk $clk_list {
    set clock_name [get_attribute $nclk full_name]
    echo "Clock $clock_name"
    check_clockdomain $clock_name $wildcardlist($clock_name)
  }

}
exit
