#/////////////////////////////////////////////////////////////////////////////
#/  Copyright (C) by RivieraWaves.
#/  This module is a confidential and proprietary property of RivieraWaves
#/  and a possession or use of this module requires written permission 
#/  from RivieraWaves.
#/----------------------------------------------------------------------------
#/ $Author: $
#/ Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/ $Revision: $
#/ $Date: $
#/ ---------------------------------------------------------------------------
#/ Dependencies     : None
#/ Description      : DC Compiler Contraints file
#/ Application Note :
#/ Terms & concepts :
#/ Bugs             :
#/ Open issues and future enhancements :
#/ References       :
#/ Revision History :
#/ ---------------------------------------------------------------------------
#/
#/ $HeadURL: $
#/
#/////////////////////////////////////////////////////////////////////////////
#==============================================================================
#--  Define Clocks Constants
#==============================================================================

# Set number of antenna : 1 / 2 if output ADCOn1 exist
if {[string length [ find_objects -object_type port -pattern adc1_on . ]]} {
  set RW_ANT 2
} else {
  set RW_ANT 1
}

# Set RW_MODE : 20 / 40 / 80
if {[string length [ find_objects -object_type port -pattern u_rw_he_top_wrapper/u_rw_he_top/fe160_rst_n . ]]} {
  set RW_MODE 80
} elseif {[string length [ find_objects -object_type port -pattern u_rw_he_top_wrapper/u_rw_he_top/fe80_rst_n . ]]} {
  set RW_MODE 40
} else {
  set RW_MODE 20
}

# Set RW_LDPC : 0 / 1 if LDPCRxTop is found in u_HDMCore/U_OFDMCore/u_OFDMRxCore/u_ofdm_rx_bd
if {[string length [ find_objects -object_type model -pattern ldpcDecCoreWrap* u_rw_he_top_wrapper/u_rw_he_top/u_hdm_core/u_ofdm_rx_core/u_ofdm_rx_bd ]]} {
  set RW_LDPC 1
} else {
  set RW_LDPC 0
}

# Set RW_SVD : 0 / 1 if svdtop is found in u_HDMCore/U_BFCore
if {[string length [ find_objects -object_type model -pattern svdtop* u_rw_he_top_wrapper/u_rw_he_top/u_hdm_core/u_ofdm_rx_core/u_RxFDTop ]]} {
  set RW_SVD 1
} else {
  set RW_SVD 0
}

# Set RW_BFMER : 0 / 1 if MUBFTxPreProc is found in u_HDMCore/U_BFCore
if {[string length [ find_objects -object_type model -pattern MUBFTxPreProc* u_rw_he_top_wrapper/u_rw_he_top/u_hdm_core/U_BFCore ]]} {
  set RW_BFMER 1
} else {
  set RW_BFMER 0
}

# Set RW_MUTX : 0 / 1 if macSecTxCore is found in u_rw_nx_platform/u_rwWlanNxMACHW
if {[string length [ find_objects -object_type model -pattern macSecTxCore u_rw_he_top_wrapper/u_rw_he_top/u_rw_nx_platform/u_rwWlanNxMACHW ]]} {
  set RW_MUTX 1
} else {
  set RW_MUTX 0
}


# Set RW_FIQ : 0 / 1 if fIQEstStartDoneHandler is found in u_RIUKarstTop
if {[string length [ find_objects -object_type model -pattern fIQStatHandler* u_rw_he_top_wrapper/u_rw_he_top/u_RIUKarstTop ]]} {
  set RW_FIQ 1
} else {
  set RW_FIQ 0
}

# Set RW_IQ : 0 / 1 if iq_est is found in u_RIUKarstTop/U_RIUCORE/u_IQImbalance
if {[string length [ find_objects -object_type model -pattern iq_est u_rw_he_top_wrapper/u_rw_he_top/u_RIUKarstTop/U_RIUCORE/u_IQImbalance ]]} {
  set RW_IQ 1
} else {
  set RW_IQ 0
}

# Set RW_COEX : 0 / 1 if rw_pta is found in u_rw_nx_platform
if {[string length [ find_objects -object_type model -pattern rw_pta u_rw_he_top_wrapper/u_rw_he_top/u_rw_nx_platform ]]} {
  set RW_COEX 1
} else {
  set RW_COEX 0
}

# Set RW_RADAR : 0 / 1 if RadarDetection is found in u_AGCCCATop
if {[string length [ find_objects -object_type model -pattern RadarDetection u_rw_he_top_wrapper/u_rw_he_top/u_RIUKarstTop/U_RIUCORE/u_AGCCCATop ]]} {
  set RW_RADAR 1
} else {
  set RW_RADAR 0
}


#extract MAC_FREQ from config file
set t [exec egrep "define MAC_FREQ" rw_he_top_cpu_syn.v | head -n 1]
set CLKFREQMACCORECLK [string map {"`define MAC_FREQ " ""} $t]
set CLKPERIODMACCORECLK [expr 1000.0 / $CLKFREQMACCORECLK]

#extract WEP_2_BB_CLK_RATIO from config file
set t [exec egrep "define WEP_2_BB_CLK_RATIO" rw_he_top_cpu_syn.v | head -n 1]
set WEP_2_BB_CLK_RATIO [string map {"`define WEP_2_BB_CLK_RATIO " ""} $t]
set CLKPERIODMACWTCLK [expr $CLKPERIODMACCORECLK / $WEP_2_BB_CLK_RATIO]

#extract MACPI_CLK_FREQ from config file
set t [exec egrep "define MACPI_CLK_FREQ" rw_he_top_cpu_syn.v | head -n 1]
set CLKFREQPLF [string map {"`define MACPI_CLK_FREQ " ""} $t]
set CLKPERIODPLF [expr 1000.0 / $CLKFREQPLF]



# *** MODEM *** 
set CLKPERIOD240M      4.16
set CLKPERIOD480M      2.08

#/* Clock periods fixed */
set CLKPERIOD40M       24.6
set CLKPERIOD80M       [expr $CLKPERIOD40M / 2]
set CLKPERIOD160M      [expr $CLKPERIOD80M / 2]
set CLKPERIOD44M       20.6

# BDTX=PHY=MPIF=120 MHz
set CLKPERIODPHY     [expr $CLKPERIOD40M / 3]
#set CLKPERIODBDTX    [expr $CLKPERIOD40M / 3]
#set CLKPERIODMPIF    [expr $CLKPERIOD40M / 3]

#/* Clock periods variable */

# 20 MHz mode: FE=40MHz
if {$RW_MODE == 20} {
set CLKPERIODFE      [expr $CLKPERIOD40M]
}
# 40 MHz mode: FE=80MHz
if {$RW_MODE == 40} {
set CLKPERIODFE      [expr $CLKPERIOD80M]
}

# BDRX=240 MHz if LDPC, else 120 MHz
if {$RW_LDPC == 1} {
  # BDRX=240 MHz
  set CLKPERIODBDRX    [expr $CLKPERIOD40M / 6]
} else {
  # BDRX=120 MHz
  set CLKPERIODBDRX    [expr $CLKPERIOD40M / 3]
}


# *** MAC *** 

#/* Clock frequency */
#/* macPIClk  */
set CLKPERIODMACPICLK $CLKPERIODPLF

#/* mpIFClk  */
#set CLKPERIODMPIFCLK $CLKPERIODMPIF  

set CLKHALFPERIODMACPICLK   [expr $CLKPERIODMACPICLK    / 2]
set CLKHALFPERIODMACCORECLK [expr $CLKPERIODMACCORECLK  / 2]
set CLKHALFPERIODMACWTCLK   [expr $CLKPERIODMACWTCLK    / 2]
set CLKHALFPERIODPLFCLK     [expr $CLKPERIODPLF         / 2]
set CLKHALFPERIOD240M       [expr $CLKPERIOD240M        / 2]
set CLKPERIODLPCLK          1000

#/* Clock uncertainty */
set CKUNCERT 0.2


# *** CPU *** 

set CLKPERIODJTAG 10.0
set CLKHALFPERIODJTAGCLK   [expr $CLKPERIODJTAG    / 2]


puts "Configuration"
puts "RW_ANT    = $RW_ANT"
puts "RW_MODE   = $RW_MODE"
puts "RW_LDPC   = $RW_LDPC"
puts "RW_SVD    = $RW_SVD"
puts "RW_BFMER  = $RW_BFMER"
puts "RW_MUTX   = $RW_MUTX"
puts "RW_FIQ    = $RW_FIQ"
puts "RW_IQ     = $RW_IQ"
puts "RW_COEX   = $RW_COEX"
puts "RW_RADAR  = $RW_RADAR"

echo "Platform     = " [expr 1000.0 / $CLKPERIODPLF ] " MHz"
echo "MACCORE      = " [expr 1000.0 / $CLKPERIODMACCORECLK  ] " MHz"
echo "MACWT        = " [expr 1000.0 / $CLKPERIODMACWTCLK  ] " MHz"
echo "LowPower     = " [expr 1000.0 / $CLKPERIODLPCLK  ] " MHz"
#echo "MPIF         = " [expr 1000.0 / $CLKPERIODMPIF ] " MHz"
#echo "DBDTX        = " [expr 1000.0 / $CLKPERIODBDTX ] " MHz"
echo "DBDRX        = " [expr 1000.0 / $CLKPERIODBDRX ] " MHz"
echo "FE           = " [expr 1000.0 / $CLKPERIODFE  ] " MHz"
echo "PHY          = " [expr 1000.0 / $CLKPERIODPHY ] " MHz"
echo "JTAG         = " [expr 1000.0 / $CLKPERIODJTAG ] " MHz"



#==============================================================================
# End of file
#==============================================================================
