#/////////////////////////////////////////////////////////////////////////////
#/  Copyright (C) by RivieraWaves.
#/  This module is a confidential and proprietary property of RivieraWaves
#/  and a possession or use of this module requires written permission 
#/  from RivieraWaves.
#/----------------------------------------------------------------------------
#/ $Author: $
#/ Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/ $Revision: $
#/ $Date: $
#/ ---------------------------------------------------------------------------
#/ Dependencies     : None
#/ Description      : DC Compiler Commands file
#/ Application Note :
#/ Terms & concepts :
#/ Bugs             :
#/ Open issues and future enhancements :
#/ References       :
#/ Revision History :
#/ ---------------------------------------------------------------------------
#/
#/
#/////////////////////////////////////////////////////////////////////////////

sh date
#==============================================================================
#-- Support for licence queuing
#==============================================================================
setenv SNPSLMD_QUEUE true
setenv SNPS_MAX_WAITTIME  14400
setenv SNPS_MAX_QUEUETIME 14400


set BLOCKNAME rw_he_top_cpu
#==============================================================================
#-- Setting the variables and attributes
#==============================================================================
set hdlin_enable_presto true
set hdl_naming_threshold 1
set template_naming_style "%s"
set power_preserve_rtl_hier_names true

define_design_lib WORK -path ./work

#==============================================================================
#-- Setting up the environment
#==============================================================================
# Write gate level netlist
set WRITE_NETLIST 0

# Write SDC
set WRITE_SDC 1
# Stop synthesis after SDC generation
set WRITE_SDC_ONLY $env(RW_SDC_ONLY)

set TECHNO $env(RW_SYN_TECHNO)

source -echo $env(SOURCESLIB)/env/SYNTH/library_setup.tcl

#==============================================================================
#-- Reading the RTL files
#==============================================================================
set SOURCESLIB $env(SOURCESLIB)
set MODEM80211BCOREDIR $env(MODEM80211BCOREDIR)

# analyze vhdl files
analyze  -format vhdl modem802_11b_core_syn.vhd
analyze  -format sverilog -vcs  +incdir+$env(ZERORISCY_ROOT)/include+$env(PHYSUBSYSDIR)/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXBD/ldpcDec/verilog/rtl+$env(PHYSUBSYSDIR)/HDMCORE/OFDMACORE/OFDMTXCORE/ldpcEnc/verilog/rtl $BLOCKNAME\_syn.v
analyze  -format sverilog mem_models_for_synthesis.v
elaborate $BLOCKNAME 

#Uncomment the following 5 lines to insert auto clock gating
#set_clock_gating_style -sequential_cell latch \
#	-positive_edge_logic integrated:TLATNTSCAX2 \
#	-control_point before \
#	-control_signal scan_enable
#insert_clock_gating -global

#==============================================================================
#-- Defining the design environment
#==============================================================================
current_design $BLOCKNAME

set_wire_load_model -name $WIRELOADMODEL
set_wire_load_mode enclosed

#==============================================================================
#-- Link the design, Ungroup, Flatten hierarcy & Uniquify 
#==============================================================================
link
#ungroup -flatten -all
#set_flatten true -effort high
uniquify

remove_license VHDL-Compiler

#==============================================================================
#-- Setting the design constraints
#==============================================================================
current_design $BLOCKNAME

source -echo scripts/$BLOCKNAME\_constraints.tcl

#==============================================================================
#-- Writing out the constraints for using in Prime Time
#==============================================================================
if {$WRITE_SDC == 1} {
  write_sdc -version 2.0 $BLOCKNAME.sdc
  # if WRITE_SDC_ONLY is set, the script stops here
  if {$WRITE_SDC_ONLY} {
    exit
  }
}

check_design > reports/check_design_pre_synthesis.rpt
check_timing > reports/check_timing_pre_synthesis.rpt

#==============================================================================
#-- Compiling the design and retiming registers
#==============================================================================
compile_ultra

#Uncomment the following 7 lines if register retiming is required
#optimize_registers -sync_transform decompose  \
#                   -async_transform decompose \
#                   -justification_effort high \
#                   -clock clk                 \
#                   -edge rise                 \
#                   -check_design              \
#                   -print_critical_loop

#==============================================================================
#-- Analysis and Reports
#==============================================================================

check_design                                  > reports/check_design_post_synthesis.rpt
check_timing                                  > reports/timing_post_synthesis.rpt

report_constraint -all_violators -verbose     > reports/constraints_violations_ver.rpt
report_constraint -all_violators -max_delay   > reports/constraints_violations_max.rpt
report_constraint -all_violators -min_delay   > reports/constraints_violations_min.rpt

report_timing -loops                          > reports/timing_loops.rpt
report_timing -max_paths 10 -nworst 10        > reports/timing.rpt

report_area -hierarchy -nosplit               > reports/area.rpt
report_design                                 > reports/design.rpt

report_clock                                  > reports/clock.rpt
report_timing_requirements                    > reports/timing_req.rpt
report_clock_gating -verbose                  > reports/clock_gating.rpt
report_clock_fanout -nosplit                  > reports/clock_fanout.rpt

report_wire_load -nosplit                     > reports/wlm.rpt
report_resources -hier                        > reports/report_resources_hier.rpt

echo $NAND2X2_NAME                            > reports/nand2x2_area.rpt
echo $NAND2X2_AREA                           >> reports/nand2x2_area.rpt

echo $NAND2X1_NAME                            > reports/nand2x1_area.rpt
echo $NAND2X1_AREA                           >> reports/nand2x1_area.rpt

#==============================================================================
#-- Saving the design database
#==============================================================================
write -format ddc -hier -o $BLOCKNAME.ddc

if {$WRITE_NETLIST == 1} {
  define_name_rules -equal_ports_nets -inout_ports_equal_nets verilog
  set verilogout_no_tri true
  change_names -rules verilog -hierarchy
  write -format verilog -hier -o $BLOCKNAME\_gate.v
  write_sdf -version 2.1 -significant_digits 3 $BLOCKNAME\_gate.sdf
}


#==============================================================================
#-- Register count
#==============================================================================
report_clock_fanout -nosplit > clock_fanout.rpt

sh date

exit

#-------------------------------------------------------------------------------
#- End of file
#-------------------------------------------------------------------------------
