#/////////////////////////////////////////////////////////////////////////////
#/  Copyright (C) by RivieraWaves.
#/  This module is a confidential and proprietary property of RivieraWaves
#/  and a possession or use of this module requires written permission 
#/  from RivieraWaves.
#/----------------------------------------------------------------------------
#/ $Author: $
#/ Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/ $Revision: $
#/ $Date: $
#/ ---------------------------------------------------------------------------
#/ Dependencies     : None
#/ Description      : DC Compiler Contraints file
#/ Application Note :
#/ Terms & concepts :
#/ Bugs             :
#/ Open issues and future enhancements :
#/ References       :
#/ Revision History :
#/ ---------------------------------------------------------------------------
#/
#/
#/////////////////////////////////////////////////////////////////////////////

#==============================================================================
#--  Define Clocks Constants
#==============================================================================

#/* Clocks frequency configuration */
source -echo scripts/$BLOCKNAME\_clockdef.tcl

#==============================================================================
#--  Define Clocks & Resets Names
#==============================================================================

# *** MAC ***
#/* Reset names port names */
set RESET_IN      {sys_rst_n }


#==============================================================================
#--  Define Required/Arrival Time Constants
#==============================================================================

#/* Data arrival time (ns) */
set INMARGIN 0.16
set DTARVALTIMEPLF            [expr $INMARGIN * $CLKPERIODPLF]
set DTARVALTIMEFE40M          [expr $INMARGIN * $CLKPERIOD40M]
set DTARVALTIMEFE80M          [expr $INMARGIN * $CLKPERIOD80M]
set DTARVALTIMEMACCORECLK     [expr $INMARGIN * $CLKPERIODMACCORECLK]
set DTARVALTIMEMACWTCLK       [expr $INMARGIN * $CLKPERIODMACWTCLK]
set DTARVALTIMEJTAG           [expr $INMARGIN * $CLKPERIODJTAG]
set DTARVALTIMEPHY            [expr $INMARGIN * $CLKPERIODPHY]


#/* Data required time (ns) */
set OUTMARGIN 0.2
set DTREQTIMEPLF              [expr $OUTMARGIN * $CLKPERIODPLF] 
set DTREQTIMEFE40M            [expr $OUTMARGIN * $CLKPERIOD40M] 
set DTREQTIMEFE80M            [expr $OUTMARGIN * $CLKPERIOD80M] 
set DTREQTIMEMACCORECLK       [expr $OUTMARGIN * $CLKPERIODMACCORECLK]
set DTREQTIMEMACWTCLK         [expr $OUTMARGIN * $CLKPERIODMACWTCLK]
set DTREQTIMEJTAG             [expr $OUTMARGIN * $CLKPERIODJTAG]
set DTREQTIMEPHY              [expr $OUTMARGIN * $CLKPERIODPHY]


#==============================================================================
#--  Define Port constraints
#==============================================================================

#/* Drive cell reference */
set DRIVECELLREF $INVX2_NAME

#/* Max fan out load */
set MAXFANOUT 4



#==============================================================================
#-- Create Clocks in design
#==============================================================================
# *** JTAG ***
create_clock -name jtag_tck   -period $CLKPERIODJTAG   -waveform [list 0 $CLKHALFPERIODJTAGCLK] [find port jtag_tck ] 
set_clock_groups -asynchronous -group {jtag_tck } 

# *** PHY ***
create_clock -name ref0_root_clk   -period $CLKPERIOD240M   -waveform [list 0 $CLKHALFPERIOD240M] [find port ref0_root_clk ] 
create_generated_clock -source ref0_root_clk -name phy_clk  -divide_by 2 [find port u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_clock_generation/phy_root_clk ] 
create_generated_clock -source ref0_root_clk -name ref80_clk -divide_by 3 [find port u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_clock_generation/ref80_root_clk ] 
create_generated_clock -source ref0_root_clk -name ref40_clk -divide_by 6 [find port u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_clock_generation/ref40_root_clk ] 
create_generated_clock -source ref0_root_clk -name ref44_clk -divide_by 5 [find port u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_clock_generation/ref44_root_clk ] 
create_generated_clock -source ref0_root_clk -name freqmeter_clk -divide_by 1 [find port u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_clock_generation/ref200_root_clk ] 
if {$RW_LDPC == 1} {
create_generated_clock -source ref0_root_clk -name rxbd_clk -divide_by 1 [find port u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_clock_generation/rxbd_root_clk ] 
} else {
create_generated_clock -source ref0_root_clk -name rxbd_clk -divide_by 2 [find port u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_clock_generation/rxbd_root_clk ] 
}

if {$RW_MODE == 20 } {
  create_generated_clock -source ref0_root_clk -name fe_root_clk -divide_by 6 [find port u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_clock_generation/fe_root_clk ]
}
if {$RW_MODE == 40 } {
  create_generated_clock -source ref0_root_clk -name fe_root_clk -divide_by 3 [find port u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_clock_generation/fe_root_clk ]
}


# 
set_clock_groups -asynchronous -group {ref0_root_clk phy_clk rxbd_clk ref80_clk ref40_clk ref44_clk freqmeter_clk} 

# *** Platform ***
create_clock -name platform_clk   -period $CLKPERIODPLF   -waveform [list 0 $CLKHALFPERIODPLFCLK] [find port plf_root_clk  ] 
set_clock_groups -asynchronous -group { platform_clk } 

# *** MAC ***
set MACCOREDIV [ expr 240/$CLKFREQMACCORECLK ]
create_generated_clock -source ref0_root_clk -name mac_core_clk  -divide_by $MACCOREDIV [find port u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_clock_generation/mac_core_root_clk ] 
create_generated_clock -source ref0_root_clk -name mac_wt_clk  -divide_by [expr $MACCOREDIV / $WEP_2_BB_CLK_RATIO] [find port u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_clock_generation/mac_wt_root_clk ] 
set_clock_groups -asynchronous -group {mac_core_clk mac_wt_clk } 


# Force Mac LP clock selection to fast clock.
set_case_analysis 0 [find port u_rw_he_top_wrapper/u_rw_he_top/u_rw_nx_platform/u_rwWlanNxMACHW/U_macCore/U_dozeController/macLPClkSwitch]

#==============================================================================
#--
#-- Input delay and Output delay for block timing optimisation
#--
#==============================================================================
# *** JTAG ***
set JTAGCLK_IN {jtag_tms jtag_tdi }
set JTAGCLK_OUT {jtag_tdo jtag_rtck }

set_input_delay  $DTARVALTIMEJTAG -clock jtag_tck $JTAGCLK_IN
set_output_delay $DTREQTIMEJTAG   -clock jtag_tck $JTAGCLK_OUT

# *** Platform ***
set PLF_RESET_OUT { plf_rst_n plf_por_n }

# * AXI Master Port *
set DMAPORTS_IN   {dma0_awready* dma0_wready* dma0_bid dma0_bresp* dma0_bvalid* dma1_arready* dma1_rid* \
                   dma1_rdata* dma1_rresp* dma1_rlast* dma1_rvalid* }
set DMAPORTS_OUT  {dma0_awid* dma0_awaddr* dma0_awlen* dma0_awsize* dma0_awburst* dma0_awuser* dma0_awvalid* \
                   dma0_wid* dma0_wdata* dma0_wstrb* dma0_wlast* dma0_wvalid* dma0_bready* dma1_arid* dma1_araddr* dma1_arlen*\
                   dma1_arsize* dma1_arburst* dma1_arvalid* dma1_rready* } 

# * AHB Slave Port *
set INT_OUT       {host_irq platform_wake_up reg_bootrom_enable } 
set AHBPORTS_IN   {target_hready_in target_haddr* target_htrans* target_hwrite target_hsize* target_hwdata* target_hmastlock target_hburst* target_hprot*}
set AHBPORTS_OUT  {target_hready target_hrdata* target_hresp*}      

# * Coex Port *
if {$RW_COEX == 1} {
set COEX_IN       {coex_bt_tx coex_bt_rx coex_bt_event coex_bt_pti* coex_bt_channel* coex_bt_bw}
set COEX_OUT      {coex_bt_rx_abort coex_bt_tx_abort rc_rx_abort rc_tx_abort}
} else {
set COEX_IN       {}
set COEX_OUT      {rc_rx_abort rc_tx_abort}

}

# * GPIO *
set PLFGPIO_IN    {gpio_in*}
set PLFGPIO_OUT   {gpio_out* gpio_oen*}

set MACPLFDBG_IN  {ext_diagport* }
set MACPLFDBG_OUT {reg_diag_trigger  }

set_output_delay $DTREQTIMEPLF   -clock platform_clk [concat $INT_OUT $AHBPORTS_OUT $DMAPORTS_OUT $COEX_OUT $PLFGPIO_OUT $MACPLFDBG_OUT $PLF_RESET_OUT]
set_input_delay  $DTARVALTIMEPLF -clock platform_clk [concat $AHBPORTS_IN $DMAPORTS_IN $COEX_IN $PLFGPIO_IN $MACPLFDBG_IN]


# *** MAC ***

set MACDBG_IN      {mac_debug_ksr }
set MACDBG_OUT     {mac_internal_error}
set NXDBG_OUT      {rw_nx_ss_diag* rw_nx_diag*}


set_input_delay  $DTARVALTIMEMACCORECLK -clock mac_core_clk [concat $MACDBG_IN]
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk [concat $MACDBG_OUT $NXDBG_OUT]

# *** PHY ***

set MACBYPASS_OUT { macbypass_trigger }
set_output_delay $DTREQTIMEPHY -clock phy_clk [concat $MACBYPASS_OUT]


set ADC_RESET_OUT { fe_rst_n }
if {$RW_MODE == 20} {
set_output_delay $DTREQTIMEFE40M -clock ref40_clk [concat $ADC_RESET_OUT]
}
if {$RW_MODE == 40} {
set_output_delay $DTREQTIMEFE80M -clock ref80_clk [concat $ADC_RESET_OUT]
}
if {$RW_MODE == 80} {
set_output_delay $DTREQTIMEFE1600M -clock ref160_clk [concat $ADC_RESET_OUT]
}


if {$RW_ANT == 2} {
  set ADC_OUT { adc0_on adc1_on }
  set ADC_IN  { adc0_i* adc0_q* adc1_i* adc1_q* }
}
if {$RW_ANT == 1} {
  set ADC_OUT { adc0_on }
  set ADC_IN  { adc0_i* adc0_q* }
}

if {$RW_MODE == 20} {
set_output_delay $DTREQTIMEFE40M    -clock ref40_clk [concat $ADC_OUT]
set_input_delay  $DTARVALTIMEFE40M  -clock ref40_clk [concat $ADC_IN]
}
if {$RW_MODE == 40} {
set_output_delay $DTREQTIMEFE80M    -clock ref80_clk [concat $ADC_OUT]
set_input_delay  $DTARVALTIMEFE80M  -clock ref80_clk [concat $ADC_IN]
}
if {$RW_MODE == 80} {
set_output_delay $DTREQTIMEFE160M   -clock ref160_clk [concat $ADC_OUT]
set_input_delay  $DTARVALTIMEFE160M -clock ref160_clk [concat $ADC_IN]
}

if {$RW_ANT == 2} {
  set DAC_OUT { dac0_on dac0_en dac0_i* dac0_q* \
                dac1_on dac1_en dac1_i* dac1_q* }
}
if {$RW_ANT == 1} {
  set DAC_OUT { dac0_on dac0_en dac0_i* dac0_q* }
}
 
      
if {$RW_MODE == 20} {
set_output_delay $DTREQTIMEFE40M -clock ref40_clk [concat $DAC_OUT]
}
if {$RW_MODE == 40} {
set_output_delay $DTREQTIMEFE80M -clock ref80_clk [concat $DAC_OUT]
}
if {$RW_MODE == 80} {
set_output_delay $DTREQTIMEFE160M -clock ref160_clk [concat $DAC_OUT]
}

set RF_OUT { rf_agcfreeze rf_gpio* rf_spi_ss_n rf_spi_clk rf_spi_out \
             rf_trsw* rf_extpaon_ch*_5G9 rf_extpaon_ch*_2G4 }
set RF_IN  { rf_spi_in }

set_output_delay $DTREQTIMEFE80M   -clock ref80_clk [concat $RF_OUT]
set_input_delay  $DTARVALTIMEFE80M -clock ref80_clk [concat $RF_IN]

set_output_delay $DTREQTIMEPLF   -clock platform_clk rf_tmode
set_output_delay $DTREQTIMEPLF   -clock platform_clk rf_resetn

#==============================================================================
#--
#-- Input delay and Output delay of Memories
#--
#==============================================================================
# * u_mac_txfifo *
set_output_delay $DTREQTIMEPLF          -clock platform_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mac_txfifo/wen*    ]
set_output_delay $DTREQTIMEPLF          -clock platform_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mac_txfifo/waddr*  ]
set_output_delay $DTREQTIMEPLF          -clock platform_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mac_txfifo/wdata*  ]

set_input_delay  $DTARVALTIMEMACCORECLK -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mac_txfifo/rdata*  ]
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mac_txfifo/ren*    ]
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mac_txfifo/raddr*  ]

# * u_mac_rxfifo *
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mac_rxfifo/wen*    ]
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mac_rxfifo/waddr*  ]
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mac_rxfifo/wdata*  ]

set_input_delay  $DTARVALTIMEPLF        -clock platform_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mac_rxfifo/rdata*  ]
set_output_delay $DTREQTIMEPLF          -clock platform_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mac_rxfifo/ren*    ]
set_output_delay $DTREQTIMEPLF          -clock platform_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mac_rxfifo/raddr*  ]

# * u_keystorage *
set_input_delay  $DTARVALTIMEMACCORECLK -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_keystorage/rdata*  ]
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_keystorage/en*     ]
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_keystorage/wen*    ]
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_keystorage/addr*   ]
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_keystorage/wdata*  ]

# * u_sbox *
set_output_delay $DTREQTIMEMACWTCLK     -clock mac_wt_clk    [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_sbox/wen*    ]
set_output_delay $DTREQTIMEMACWTCLK     -clock mac_wt_clk    [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_sbox/waddr*  ]
set_output_delay $DTREQTIMEMACWTCLK     -clock mac_wt_clk    [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_sbox/wdata*  ]

set_input_delay  $DTARVALTIMEMACWTCLK   -clock mac_wt_clk    [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_sbox/rdata*  ]
set_output_delay $DTREQTIMEMACWTCLK     -clock mac_wt_clk    [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_sbox/ren*    ]
set_output_delay $DTREQTIMEMACWTCLK     -clock mac_wt_clk    [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_sbox/raddr*  ]

# * u_mpif_txfifo *
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mpif_txfifo/wen*    ]
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mpif_txfifo/waddr*  ]
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mpif_txfifo/wdata*  ]

set_input_delay  $DTARVALTIMEPHY        -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mpif_txfifo/rdata*  ]
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mpif_txfifo/ren*    ]
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mpif_txfifo/raddr*  ]

# * u_mpif_rxfifo *
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mpif_rxfifo/wen*    ]
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mpif_rxfifo/waddr*  ]
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mpif_rxfifo/wdata*  ]

set_input_delay  $DTARVALTIMEMACCORECLK -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mpif_rxfifo/rdata*  ]
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mpif_rxfifo/ren*    ]
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mpif_rxfifo/raddr*  ]

# * u_mibtable *
set_input_delay  $DTARVALTIMEMACCORECLK -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mibtable/rdata*  ]
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mibtable/en*     ]
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mibtable/wen*    ]
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mibtable/addr*   ]
set_output_delay $DTREQTIMEMACCORECLK   -clock mac_core_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_mibtable/wdata*  ]

# * u_sharedram *
set_input_delay  $DTARVALTIMEPLF        -clock platform_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_sharedram/rdata*  ]
set_output_delay $DTREQTIMEPLF          -clock platform_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_sharedram/en*     ]
set_output_delay $DTREQTIMEPLF          -clock platform_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_sharedram/wen*    ]
set_output_delay $DTREQTIMEPLF          -clock platform_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_sharedram/addr*   ]
set_output_delay $DTREQTIMEPLF          -clock platform_clk  [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_sharedram/wdata*  ]

# * u_fft0mem* *
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_fft0mem*/wen*    ]
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_fft0mem*/waddr*  ]
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_fft0mem*/wdata*  ]
set_input_delay  $DTARVALTIMEPHY        -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_fft0mem*/rdata*  ]
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_fft0mem*/ren*    ]
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_fft0mem*/raddr*  ]

# * u_bdfd_ram *
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_bdfd_ram/wen*    ]
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_bdfd_ram/waddr*  ]
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_bdfd_ram/wdata*  ]
set_input_delay  $DTARVALTIMEPHY        -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_bdfd_ram/rdata*  ]
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_bdfd_ram/ren*    ]
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_bdfd_ram/raddr*  ]

# * u_bfmee_ram *
if {$RW_SVD == 1 } {
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_bfmee_ram/en*     ]
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_bfmee_ram/wen*    ]
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_bfmee_ram/addr*   ]
set_output_delay $DTREQTIMEPHY          -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_bfmee_ram/wdata*  ]
set_input_delay  $DTARVALTIMEPHY        -clock phy_clk       [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_bfmee_ram/rdata*  ]
}

# * u_agcmem *
set_input_delay  $DTARVALTIMEFE80M      -clock ref80_clk     [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_agcmem/rdata*  ]
set_output_delay $DTREQTIMEFE80M        -clock ref80_clk     [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_agcmem/en*     ]
set_output_delay $DTREQTIMEFE80M        -clock ref80_clk     [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_agcmem/wen*    ]
set_output_delay $DTREQTIMEFE80M        -clock ref80_clk     [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_agcmem/addr*   ]
set_output_delay $DTREQTIMEFE80M        -clock ref80_clk     [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_agcmem/wdata*  ]

# * u_radarmem *
if {$RW_RADAR == 1 } {
set_input_delay  $DTARVALTIMEFE80M      -clock ref80_clk     [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_radarmem/rdata*  ]
set_output_delay $DTREQTIMEFE80M        -clock ref80_clk     [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_radarmem/en*     ]
set_output_delay $DTREQTIMEFE80M        -clock ref80_clk     [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_radarmem/wen*    ]
set_output_delay $DTREQTIMEFE80M        -clock ref80_clk     [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_radarmem/addr*   ]
set_output_delay $DTREQTIMEFE80M        -clock ref80_clk     [get_pins u_rw_he_top_wrapper/u_rw_he_memories/u_radarmem/wdata*  ]
}

# * CPU memories *
set_input_delay  $DTARVALTIMEPLF        -clock platform_clk  [get_pins u_riscv_subsys/sram_tdp_*/rdata*  ]
#set_output_delay $DTREQTIMEPLF          -clock platform_clk  [get_pins u_riscv_subsys/sram_tdp_*/en      ]
set_output_delay $DTREQTIMEPLF          -clock platform_clk  [get_pins u_riscv_subsys/sram_tdp_*/wen*    ]
set_output_delay $DTREQTIMEPLF          -clock platform_clk  [get_pins u_riscv_subsys/sram_tdp_*/addr*   ]
set_output_delay $DTREQTIMEPLF          -clock platform_clk  [get_pins u_riscv_subsys/sram_tdp_*/wdata*  ]

#==============================================================================
#-- Area
#==============================================================================
set_max_area 0 -ignore_tns

#==============================================================================
#-- False path
#==============================================================================

# *** MAC ***
#false path
set_false_path -from [concat $RESET_IN $MACPLFDBG_IN $MACDBG_IN]
set_false_path -to [concat $MACPLFDBG_OUT $MACDBG_OUT $NXDBG_OUT]

# *** PLF ***
#false path
set_false_path -from [concat $PLFGPIO_IN]
set_false_path -to [concat $PLFGPIO_OUT]

set_false_path  -to [get_clocks [list platform_clk]] -through [get_pins u_rw_he_top_wrapper/u_rw_he_top/u_rw_nx_platform/u_rwWlanNxMACHW/U_debugPortCtrl/debugPortRead[*]]


#==============================================================================
# Maximum path in between asynchronous clock domains
#==============================================================================

#mac_core_clk -> platform_clk
#mac_core_clk -> phy_clk
set_max_delay $CLKPERIODMACCORECLK -rise_from mac_core_clk -rise_to [get_clocks [list platform_clk phy_clk ]]

#mac_wt_clk -> platform_clk 
#mac_wt_clk -> phy_clk
set_max_delay $CLKPERIODMACCORECLK -rise_from mac_wt_clk -rise_to [get_clocks [list platform_clk phy_clk ]]

#platform_clk -> mac_core_clk
#platform_clk -> mac_wt_clk
#platform_clk -> phy_clk
#platform_clk -> ref40_clk
#platform_clk -> ref80_clk
#platform_clk -> ref44_clk
#set_max_delay $CLKPERIODPLF -rise_from platform_clk -rise_to [get_clocks [list mac_core_clk mac_wt_clk phy_clk ref40_clk ref80_clk ref44_clk]]

# Phy clock versus AGC clock
set_max_delay $CLKPERIOD80M         -rise_from  phy_clk        -rise_to   ref80_clk
set_max_delay $CLKPERIODPHY         -rise_from  ref80_clk      -rise_to   phy_clk

# Phy clock versus AHB clock
set_max_delay $CLKPERIODPLF         -rise_from  phy_clk        -rise_to   platform_clk
set_max_delay $CLKPERIODPHY         -rise_from  platform_clk   -rise_to   phy_clk

# Phy clock versus Mac Core clock
set_max_delay $CLKPERIODMACCORECLK  -rise_from  phy_clk        -rise_to   mac_core_clk
set_max_delay $CLKPERIODPHY         -rise_from  mac_core_clk   -rise_to   phy_clk

# Phy clock versus RX BD clock
set_max_delay $CLKPERIODBDRX        -rise_from  phy_clk        -rise_to   rxbd_clk
set_max_delay $CLKPERIODPHY         -rise_from  rxbd_clk       -rise_to   phy_clk

# RX BD clock versus AHB clock
set_max_delay $CLKPERIODPLF         -rise_from  rxbd_clk       -rise_to   platform_clk
set_max_delay $CLKPERIODBDRX        -rise_from  platform_clk   -rise_to   rxbd_clk

# Modem DSSS clock versus AHB clock
set_max_delay $CLKPERIODPLF         -rise_from  ref44_clk      -rise_to   platform_clk
set_max_delay $CLKPERIOD44M         -rise_from  platform_clk   -rise_to   ref44_clk

# AGC clock versus AHB clock
set_max_delay $CLKPERIODPLF         -rise_from  ref80_clk      -rise_to   platform_clk
set_max_delay $CLKPERIODPLF         -rise_from  ref80_clk      -rise_to   platform_clk

# AGC clock versus Mac Core clock
set_max_delay $CLKPERIODMACCORECLK  -rise_from  ref80_clk      -rise_to   mac_core_clk
set_max_delay $CLKPERIOD80M         -rise_from  mac_core_clk   -rise_to   ref80_clk

# Modem DSSS clock versus Phy clock
set_max_delay $CLKPERIODPHY         -rise_from  ref44_clk      -rise_to   phy_clk
set_max_delay $CLKPERIOD44M         -rise_from  phy_clk        -rise_to   ref44_clk

# Modem DSSS clock versus AGC clock
set_max_delay $CLKPERIOD80M         -rise_from  ref44_clk      -rise_to   ref80_clk
set_max_delay $CLKPERIOD80M         -rise_from  ref44_clk      -rise_to   ref80_clk

# FE clocks versus Phy clock
if {$RW_MODE == "80"} {
  set_max_delay $CLKPERIODFE        -rise_from  phy_clk        -rise_to   ref160_clk
  set_max_delay $CLKPERIODFE        -rise_from  ref160_clk     -rise_to   phy_clk
}
set_max_delay $CLKPERIODFE          -rise_from  phy_clk        -rise_to   ref80_clk
set_max_delay $CLKPERIODFE          -rise_from  ref80_clk      -rise_to   phy_clk
set_max_delay $CLKPERIODFE          -rise_from  phy_clk        -rise_to   ref40_clk
#set_max_delay $CLKPERIODFE          -rise_from  ref40_clk      -rise_to   phy_clk

# Modem DSSS clock versus FE clock
set_max_delay $CLKPERIOD44M         -rise_from  ref44_clk      -rise_to   ref40_clk
#set_max_delay $CLKPERIOD44M         -rise_from  ref40_clk      -rise_to   ref44_clk

#set_max_delay $CLKPERIODPLF         -rise_from  ref40_clk      -rise_to   platform_clk
set_max_delay $CLKPERIOD40M         -rise_from  platform_clk   -rise_to   ref40_clk

if {$RW_MODE == "80"} {
  set_max_delay $CLKPERIODPLF       -rise_from  ref160_clk     -rise_to   platform_clk
  set_max_delay $CLKPERIOD160M      -rise_from  platform_clk   -rise_to   ref160_clk
}

set_max_delay $CLKPERIODPLF         -rise_from  ref80_clk      -rise_to   platform_clk
set_max_delay $CLKPERIOD80M         -rise_from  platform_clk   -rise_to   ref80_clk


#==============================================================================
#-- Some don't use in library
#==============================================================================

set_dont_use [list [format "%s%s"  $TARGETTECH /$SDFF_NAME]]

#==============================================================================
#-- End of file
#==============================================================================
