#!/bin/sh
#/////////////////////////////////////////////////////////////////////////////
#/  Copyright (C) by RivieraWaves.
#/  This module is a confidential and proprietary property of RivieraWaves
#/  and a possession or use of this module requires written permission 
#/  from RivieraWaves.
#/----------------------------------------------------------------------------
#/ $Author: $
#/ Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/ $Revision: $
#/ $Date: $
#/ ---------------------------------------------------------------------------
#/ Dependencies     : None
#/ Description      : ASIC Synthesis script
#/ Application Note :
#/ Terms & concepts :
#/ Bugs             :
#/ Open issues and future enhancements :
#/ References       :
#/ Revision History :
#/ ---------------------------------------------------------------------------
#/
#/
#/////////////////////////////////////////////////////////////////////////////


#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
#--- Display Help                                                 ---#
#--------------------------------------------------------------------#
#--------------------------------------------------------------------#
DisplayHelp()
{
   LISTTECHNO=`echo $LISTTECHNO | sed 's/ /\n\t\t\t\t/g'`
  echo "
    This script creates the working directors and launches ASIC 
    synthesis using Synopsys DC Compile.
    
    Options:
      -i | -init        : Create the working directory work.\$RW_SYNDIR

      -c | -comp_file   : Generate compilation files

      -s | -synthesis   : Launch synthesis 

      -sdc_only         : Generate sdc file only

      -t | -tool <name> : Select Synthesis tool
                            tool available
                              dc  : Synopsys Design Compiler

                          If not specified, DC is selected by default
                              
      -l | -lib <name>  : Select techno Library
                            library available:
                                $LISTTECHNO                            

                          If not specified, $DEFAULTECHNO is selected by default
                              
      -cdc              : Enable the clock domain crossing analysis

      -config <name>    : Select configuration 
                           !!! Must be specified for compilation file generation !!! "
  CONFIGLIST=`find $SOURCESLIB/env/CONF/ -type f -name "*.v"| grep "$SOURCESLIB/env/CONF/config" | sed 's/.*\/env\/CONF\///'  | sed 's/\.v//' `
  echo "                           Available configuration list :"
  for CONFIGNAME in ${CONFIGLIST}
  do
    echo "                            - $CONFIGNAME"
  done
  echo " 
                              
      -d | -define      : Added specific Verilog define

      -h | -help        : Display this message
  "
}

#--------------------------------------------------------------------#
#--- PrintErrorWarning <message>                                  ---#
#--------------------------------------------------------------------#
PrintErrorWarning ()
{
  echo "ERROR: $*"
  echo ""
  exit 2
}



#--------------------------------------------------------------------#
#--- PrintDuration                                                ---#
#--------------------------------------------------------------------#
PrintDuration ()
{
  ENDDATE=`date +%s`
  DURATION=$(($ENDDATE-$STARTDATEDUR))
  ENDDATE=`date`
  echo $DURATION > duration.txt
  echo "STARTED : $STARTDATE "
  echo "ENDED   : $ENDDATE "  
  echo "Duration : $DURATION sec"
}


#--------------------------------------------------------------------#
#--- Main                                                         ---#
#--------------------------------------------------------------------#
#--------------------------------------------------------------------#

DEFAULTECHNO=`egrep "set *TECHNO *" $SOURCESLIB/env/SYNTH/library_setup.tcl | sed 's/^.* \"//' | sed 's/".*//'`
LISTTECHNO=`egrep "TECHNO *==" $SOURCESLIB/env/SYNTH/library_setup.tcl | sed 's/^.* \"//' | sed 's/".*//'`

#--- Options verification                                         ---#
# echo "Params: $*"
# echo "NbParam: $#"

if test $# == 0
then
  DisplayHelp
  exit 1
fi

STARTDATE=`date`
STARTDATEDUR=`date +%s`

SYNTHESIS=0
INIT=0
COMPFILE=0
TOOL="dc"
TECHNO="$DEFAULTECHNO"
CONFIG=""
DEFINES=""
CDC=0
SDC_ONLY=0

while test $# != 0
do

  arg="$1"
  OPTION=`echo $arg | sed 's/^-//'`
  shift
  case ${OPTION}
  in
    s | synthesis)  
      SYNTHESIS=1
    ;;
    i | init)  
      INIT=1
    ;;
    sdc_only)  
      SDC_ONLY=1
    ;;
    cdc)  
      CDC=1
    ;;
    l | lib)  
      if test $# = 0
      then
        echo "ERROR : library name missing"
        LISTTECHNO=`echo $LISTTECHNO`
        echo "Should be $LISTTECHNO"
        exit 1
      fi 
      if [ `echo "$LISTTECHNO" | grep -c "^$1$"` == 1 ] 
      then
          TECHNO="$1"
      else  
          echo "ERROR : Library name $1 is not supported"
          LISTTECHNO=`echo $LISTTECHNO`
          echo "Should be $LISTTECHNO"
          exit 1
      fi
      shift
    ;;
    config)  
      if test $# = 0
      then
        echo "ERROR : Configuration name missing"
        echo "Please choose between available configuration : "
        #------------------------------------------------------------------------#
        #--- List the available configuration                                 ---#
        #------------------------------------------------------------------------#
        CONFIGLIST=`find ${SOURCESLIB}/env/CONF/ -type f -name "*.v"| grep "${SOURCESLIB}/env/CONF/config" | sed 's/.*\/env\/CONF\///'  | sed 's/\.v//' `
        echo "Available configuration list :"
        echo "------------------------------"
        for CONFIGNAME in ${CONFIGLIST}
        do
          echo " - $CONFIGNAME"
        done
        echo
        exit 1
      fi
      CONFIG=$1
      shift
    ;;
    t | tool)  
      if test $# = 0
      then
        echo "ERROR : Tool missing"
        exit 1
      fi  
      case $1
      in
        dc)
          TOOL="dc"
        ;;  
        *)
          echo "ERROR : Tool $1 is not supported"
          exit 1
        ;;
      esac
      shift
    ;;
    c | compilation_file)  
      COMPFILE=1
    ;;
    d | define)
      DEFINES="$DEFINES
      \`define $1"
      shift
    ;;
    h | help)  
      #------------------------------------------------------------------------#
      #--- Display Help                                                     ---#
      #------------------------------------------------------------------------#
      DisplayHelp
      exit 1
    ;;
    *)  
      #------------------------------------------------------------------------#
      #--- Unknown Option                                                   ---#
      #------------------------------------------------------------------------#
      echo "Unknown Option"
      DisplayHelp
      exit 1
    ;;
  esac
done

export RW_SYN_TECHNO=$TECHNO
export RW_SYN_CONFIG=$CONFIG
export RW_SDC_ONLY=$SDC_ONLY


# Working Directory Initialization
if [ $INIT == 1 ]
then
  if [ -z "$RW_SYNDIR" ]
  then
    PrintErrorWarning "The RW_SYNDIR variable has not been set"
  else
    if [ -f ${TOOL}_work.$RW_SYNDIR ] || [ -d ${TOOL}_work.$RW_SYNDIR ]
    then
      PrintErrorWarning "Working directory '${TOOL}_work.$RW_SYNDIR' already exists!"
    fi
    echo "Create working directory : dc_work.$RW_SYNDIR"
    cp -r _${TOOL}_template ${TOOL}_work.$RW_SYNDIR
  fi
fi

if [ ! -d ${TOOL}_work.$RW_SYNDIR ]
then
  PrintErrorWarning "Working directory '${TOOL}_work.$RW_SYNDIR' does not exists!"
  exit 1
fi
cd ${TOOL}_work.$RW_SYNDIR

# Compilation files generation
if [ $COMPFILE == 1 ]
then
  if [ -z "$CONFIG" ]
  then
    echo "ERROR : !!! The configuration has not been set !!!"
    DisplayHelp
    exit 1
  else
    rm -f ./rw_he_top_cpu_syn.v modem802_11b_core_syn.vhd
    echo "Create compilation files"
    create_comp_file.pl rw_he_top_cpu rtl rw_he_top_cpu_rtl_files.list || exit 1
    echo '`define VERILATOR' > rw_he_top_cpu_syn.v
    cat $SOURCESLIB/env/CONF/${CONFIG}.v >> rw_he_top_cpu_syn.v
    echo ""  >> rw_he_top_cpu_syn.v
    cat rw_he_top_cpu_rtl_files.list | grep -v memory_models | xargs cat >> rw_he_top_cpu_syn.v
    cat $MODEM80211BCOREDIR/modem802_11b_core/cfg/modem802_11b_core.list | \
    egrep -v "//" | \
    sed 's@\$MODEM80211BCOREDIR@'$MODEM80211BCOREDIR'@g'| \
    xargs cat >> modem802_11b_core_syn.vhd
    RW_LDPC=`egrep -v // $SOURCESLIB/env/CONF/${CONFIG}.v | grep -c "define *RW_NX_LDPC_ENC"`
    if [ $RW_LDPC == 1 ]
    then
      echo "Create LDPC include links"
      ln -fs $HDMCOREDIR/OFDMACORE/OFDMRXCORE/OFDMRXBD/ldpcDec/verilog/rtl/*.vh .
      ln -fs $HDMCOREDIR/OFDMACORE/OFDMTXCORE/ldpcEnc/verilog/rtl/*.vh .
    fi
  fi
fi

# Launch Synthesis
if [ $SYNTHESIS == 1 ] && [ $TOOL == "dc" ]
then
  echo "Launch synthesis with Synopsys Design Compiler"
  echo "Targeted library is $TECHNO"
  dc_shell -64bit -f scripts/rw_he_top_cpu_commands.tcl | tee run_dc.log
  NERROR=`egrep -c "Error:" run_dc.log`
  if [ $NERROR == 0 ]
  then
    echo "DC SYNTHESIS SUCCESSFUL !!!"
  else
    egrep "Error:" run_dc.log
    echo "$NERROR ERROR FOUND DURING DC SYNTHESIS !!!"
    echo "see ${TOOL}_work.$RW_SYNDIR/run_dc.log"
    PrintDuration
    exit 1
  fi    
fi

# Launch Clock domain crossing analysis 
if [ $CDC == 1 ] && [ $TOOL == "dc" ]
then
  echo "Launch clock domain crossing analysis with Synopsys Design Compiler"
  dc_shell -tcl_mode -f scripts/report_cdc.tcl | tee run_dc_cdc.log
  NERROR=`egrep -c "Error:" run_dc_cdc.log`
  if [ $NERROR == 0 ]
  then
    echo "DC CLOCK DOMAIN CROSSING ANALYSIS DONE !!!"
  else
    egrep "Error:" run_dc_cdc.log
    echo "$NERROR ERROR FOUND DURING DC CLOCK DOMAIN CROSSING ANALYSIS !!!"
    echo "see ${TOOL}_work.$RW_SYNDIR/run_dc_cdc.log"
    PrintDuration
    exit 1
  fi
  cdc_report_list=`ls reports/ep_*.txt | grep -v skip`
  CDCERROR=0
  for i in $cdc_report_list
  do
    NERROR=`egrep -c "EP: " $i`
    if [ $NERROR != 0 ]
    then
      echo "$NERROR ERROR FOUND DURING CLOCK DOMAIN CROSSING ANALYSIS IN $i"
      echo "see ${TOOL}_work.$RW_SYNDIR/$i"
      CDCERROR=1
    fi
  done
  if [ $CDCERROR == 0 ]
  then
    echo "DC CLOCK DOMAIN CROSSING ANALYSIS SUCCESSFUL !!!"
  fi
fi


PrintDuration

cd ..
