//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of rw_he_top_cpu module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module rw_he_top_cpu
(
  /*****************************************************************************
  //$port_g Clocks / Resets Inputs
  *****************************************************************************/
  //$port_g system resets
  input wire                              sys_rst_n,           // System Reset active Low
  
  //$port_g Clocks
  input wire                              ref0_root_clk,       // Reference clock for PHY (240/480 Mhz)
  input wire                              ref1_root_clk,       // Reference clock for MAC (80 Mhz)

`ifndef RW_CRM_FPGA
  input wire                              plf_root_clk,        // Platform Root clock
  input wire                              mac_lp_root_clk,     // Low-Power clock
`else
  input  wire                             global_rst_n,

  output wire                             ref80_clk, 
  output wire                             ref80_rst_n, 
  input  wire                             axi_aclk,
  output wire                             axi_por_n,
`endif
  
  output wire                             fe_clk,             // ADC/DAC sampling clock
  output wire                             fe_rst_n,           // ADC/DAC Reset active Low
  output wire                             plf_clk,            // Platform Clock
  output wire                             plf_rst_n,          // Platform Reset active Low
  output wire                             plf_por_n,          // Platform Power On Reset active Low

  //$port_g Clock enables
  output wire                             platform_wake_up,    // Wake Up platform  
  
  /*****************************************************************************
  //$port_g AHB Slave interface
  *****************************************************************************/
  output wire                             target_hready,         // Processor hready
  input  wire                             target_hready_in,      // Processor hready_in
  input  wire  [31:0]                     target_haddr,          // Processor haddr
  input  wire  [ 1:0]                     target_htrans,         // Processor htrans
  input  wire                             target_hwrite,         // Processor hwrite
  input  wire                             target_hmastlock,      // Processor hmastlock
  input  wire  [ 2:0]                     target_hburst,         // Processor hburst
  input  wire  [ 3:0]                     target_hprot,          // Processor hprot
  input  wire  [ 2:0]                     target_hsize,          // Processor hsize
  output wire  [31:0]                     target_hrdata,         // Processor hrdata
  input  wire  [31:0]                     target_hwdata,         // Processor hwdata
  output wire  [ 1:0]                     target_hresp,          // Processor hresp
  
  output wire                             host_irq,            // Interrupt from host
`ifdef  RW_FPGA_AHB
  input  wire                             fpga_irq,            // Interrupt from FPGA
`endif//RW_FPGA_AHB
  
  /*****************************************************************************
  //$port_g GPIO interface
  *****************************************************************************/
  output wire [31:0]                      gpio_out,            // GPIO output
  input  wire [31:0]                      gpio_in,             // GPIO input
  output wire [31:0]                      gpio_oen,            // GPIO output enable
  
`ifdef RW_COEX_MODEL
  /*****************************************************************************
  //$port_g AHB to Coexistence interface
  *****************************************************************************/
  output wire                             coexif_hready_in,    // Coexistence Interface hready_in
  output wire                             coexif_hsel,         // Coexistence Interface hsel
  output wire  [8:0]                      coexif_haddr,        // Coexistence Interface haddr
  output wire [ 1:0]                      coexif_htrans,       // Coexistence Interface htrans
  output wire                             coexif_hwrite,       // Coexistence Interface hwrite
  input  wire [31:0]                      coexif_hrdata,       // Coexistence Interface hrdata
  output wire [31:0]                      coexif_hwdata,       // Coexistence Interface hwdata
  input  wire [ 1:0]                      coexif_hresp,        // Coexistence Interface hresp
  input  wire                             coexif_hready,       // Coexistence Interface hready
`endif // RW_COEX_MODEL

`ifdef RW_WLAN_COEX_EN
  /*****************************************************************************
  //$port_g Bluetooth Coexistence Interface
  *****************************************************************************/
  input  wire                             coex_bt_tx,          // BT Transmission On-going
  input  wire                             coex_bt_rx,          // BT Reception    On-going
  input  wire                             coex_bt_event,       // BT Event        On-going
  output wire                             coex_bt_tx_abort,    // BT Transmission Abort Request
  output wire                             coex_bt_rx_abort,    // BT Reception    Abort Request
  input  wire [3:0]                       coex_bt_pti,         // BT Packet Traffic Information
  input  wire [6:0]                       coex_bt_channel,     // BT Channel (0-78)
  input  wire                             coex_bt_bw,          // BT Bandwidth (0:1MHz, 1:2MHz)
`endif // RW_WLAN_COEX_EN

  /*****************************************************************************
  //$port_g RC Coexistence interface
  *****************************************************************************/
  output wire                             rc_tx_abort,         // Radio Controller Transmission Abort Request
  output wire                             rc_rx_abort,         // Radio Controller Reception    Abort Request
  
  /*****************************************************************************
  //$port_g AXI Interface
  *****************************************************************************/
  //$port_g  upstream interface
  output wire [ 3:0]                      dma0_awid,           // DMA Upstream awid
  output wire [31:0]                      dma0_awaddr,         // DMA Upstream awaddr
  output wire [ 7:0]                      dma0_awlen,          // DMA Upstream awlen 
  output wire [ 2:0]                      dma0_awsize,         // DMA Upstream awsize
  output wire [ 1:0]                      dma0_awburst,        // DMA Upstream awburst
  output wire [11:0]                      dma0_awuser,         // DMA Upstream awuser
  output wire                             dma0_awvalid,        // DMA Upstream awvalid
  input  wire                             dma0_awready,        // DMA Upstream awready
                                                                 
  output wire [ 3:0]                      dma0_wid,            // DMA Upstream wid
  output wire [63:0]                      dma0_wdata,          // DMA Upstream wdata 
  output wire [ 7:0]                      dma0_wstrb,          // DMA Upstream wstrb
  output wire                             dma0_wlast,          // DMA Upstream wlast
  output wire                             dma0_wvalid,         // DMA Upstream wvalid
  input  wire                             dma0_wready,         // DMA Upstream wready
                                                                 
  input  wire  [3:0]                      dma0_bid,            // DMA Upstream bid
  input  wire  [1:0]                      dma0_bresp,          // DMA Upstream bresp
  input  wire                             dma0_bvalid,         // DMA Upstream bvalid
  output wire                             dma0_bready,         // DMA Upstream bready

  //$port_g  downstream interface
  output wire [ 3:0]                      dma1_arid,           // DMA Downstream arid
  output wire [31:0]                      dma1_araddr,         // DMA Downstream araddr
  output wire [ 7:0]                      dma1_arlen,          // DMA Downstream arlen
  output wire [ 2:0]                      dma1_arsize,         // DMA Downstream arsize
  output wire [ 1:0]                      dma1_arburst,        // DMA Downstream arburst
  output wire                             dma1_arvalid,        // DMA Downstream arvalid
  input  wire                             dma1_arready,        // DMA Downstream arready
                                                              
  input  wire [ 3:0]                      dma1_rid,            // DMA Downstream rid
  input  wire [63:0]                      dma1_rdata,          // DMA Downstream rdata
  input  wire [ 1:0]                      dma1_rresp,          // DMA Downstream rresp
  input  wire                             dma1_rlast,          // DMA Downstream rlast
  input  wire                             dma1_rvalid,         // DMA Downstream rvalid
  output wire                             dma1_rready,         // DMA Downstream rready
  
  /*****************************************************************************
  //$port_g ADC Interface
  *****************************************************************************/
  output wire                             adc0_on,             // ADC0 Power/Clock enable     
  input  wire [11:0]                      adc0_i,              // ADC0 Data I
  input  wire [11:0]                      adc0_q,              // ADC0 Data Q
`ifdef RW_NX_DERIV_FE_PATH1
  output wire                             adc1_on,             // ADC1 Power/Clock enable   
  input  wire [11:0]                      adc1_i,              // ADC1 Data I
  input  wire [11:0]                      adc1_q,              // ADC1 Data Q
`endif                                                       

  /*****************************************************************************
  //$port_g DAC Interface
  *****************************************************************************/
  output wire                             dac0_on,             // DAC0 Power/Clock enable     
  output wire                             dac0_en,             // DAC0 Data valid   
  output wire [11:0]                      dac0_i,              // DAC0 Data I
  output wire [11:0]                      dac0_q,              // DAC0 Data Q
`ifdef RW_NX_DERIV_FE_PATH1
  output wire                             dac1_on,             // DAC1 Power/Clock enable     
  output wire                             dac1_en,             // DAC1 Data valid               
  output wire [11:0]                      dac1_i,              // DAC1 Data I         
  output wire [11:0]                      dac1_q,              // DAC1 Data Q        
`endif
  
  /*******************************************************************
  //$port_g RF interface
  *******************************************************************/
  //$port_g Reset output
  output wire                             rf_resetn,        // Active Low Reset for Radio
  
  //$port_g RF AGC Control
  output wire                             rf_agcfreeze,     // AGC freeze 
 
  //$port_g RF Test mode
  output  wire                            rf_tmode,         // Radio Test Mode
  
  //$port_g Fast write bus
  output wire  [7:0]                      rf_gpio,          // GPIO Data
  
  //$port_g SPI Interface
  input  wire                             rf_spi_in,        // SPI Interface In
  output wire                             rf_spi_ss_n,      // SPI Interface Slave Select
  output wire                             rf_spi_clk,       // SPI Interface Clock
  output wire                             rf_spi_out,       // SPI Interface Out

  //$port_g Tx/Rx switch
  output wire                             rf_trsw0,         // Radio Tx On 0
`ifdef RW_NX_DERIV_FE_PATH1
  output wire                             rf_trsw1,         // Radio Tx On 1
`endif
                                                                                    
  //$port_g External PA
  output wire                             rf_extpaon_ch0_5G9,  // Radio External PA Channel 0 5Ghz
  output wire                             rf_extpaon_ch0_2G4,  // Radio External PA Channel 0 2.4Ghz
`ifdef RW_NX_DERIV_FE_PATH1
  output wire                             rf_extpaon_ch1_5G9,  // Radio External PA Channel 1 5Ghz                
  output wire                             rf_extpaon_ch1_2G4,  // Radio External PA Channel 1 2.4Ghz              
`endif
 
`ifdef RW_FPGA_AHB
  /*****************************************************************************
  //$port_g  AHB to FPGA
  *****************************************************************************/
  output wire                             fpga_hready_in,  // FPGA hready_in
  output wire                             fpga_hsel,       // FPGA hsel
  output wire [19:0]                      fpga_haddr,      // FPGA haddr
  output wire [ 1:0]                      fpga_htrans,     // FPGA htrans
  output wire                             fpga_hwrite,     // FPGA hwrite
  input  wire [31:0]                      fpga_hrdata,     // FPGA hrdata
  output wire [31:0]                      fpga_hwdata,     // FPGA hwdata
  input  wire [ 1:0]                      fpga_hresp,      // FPGA hresp
  input  wire                             fpga_hready,     // FPGA hready
`endif // RW_FPGA_AHB

  /*****************************************************************************
  //$port_g Diagnostic Ports
  *****************************************************************************/
  input  wire  [31:0]                     ext_diagport,        // Diagnostic port
  output wire                             reg_bootrom_enable,  // CPU Boot enable
  
  output wire [ 4:0]                      rw_nx_ss_diag,       // Diagnostic port to be used with IQ for source synchrone capture
  output wire [15:0]                      rw_nx_diag0,         // Diagnostic port
  output wire [15:0]                      rw_nx_diag1,         // Diagnostic port
  output wire [15:0]                      rw_nx_diag2,         // Diagnostic port
  output wire [15:0]                      rw_nx_diag3,         // Diagnostic port
  output wire [15:0]                      rw_nx_diag4,         // Diagnostic port
  output wire [15:0]                      rw_nx_diag5,         // Diagnostic port
  output wire [15:0]                      rw_nx_diag6,         // Diagnostic port
  output wire                             mac_internal_error,  // MAC internal Error
  input  wire                             mac_debug_ksr,       // Debug Key Storage RAM.
  output wire  [1:0]                      macbypass_trigger,   // MAC Bypass Trigger Port
  output wire                             reg_diag_trigger,    // SW Trigger Port

  //****************************************************************************
  //port_g JTAG
  //****************************************************************************
  output wire                             jtag_rtck,           // JTAG RTCK
  output wire                             jtag_tdo,            // JTAG TDO
  input  wire                             jtag_tdi,            // JTAG TDI
  input  wire                             jtag_tms,            // JTAG TMS
  input  wire                             jtag_tck             // JTAG TCK
);

//////////////////////////////////////////////////////////////////////////////
// Parameter Definitions
//////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////

//------------------------------------------------------------------------------
// Processor (firmware)  AHB interface
//------------------------------------------------------------------------------
wire                         proc_hready_in;     // Processor hready_in
wire                         proc_hready;        // Processor hready
wire                  [27:0] proc_haddr;         // Processor haddr
wire                   [1:0] proc_htrans;        // Processor htrans
wire                         proc_hwrite;        // Processor hwrite
wire                   [1:0] proc_hsize;         // Processor hsize
wire                  [31:0] proc_hrdata;        // Processor hrdata
wire                  [31:0] proc_hwdata;        // Processor hwdata
wire                   [1:0] proc_hresp;         // Processor hresp
//------------------------------------------------------------------------------
// Interrupt sources
//------------------------------------------------------------------------------
wire                 [95:20] proc_irq;           // Interrupts to processor
wire                         cpu_single_irq;     // Single Interrupt to processor
wire                         tick_timer_irq;     // Tick Timer Interrupt to processor
wire                         soft_irq;           // Soft Interrupt to processor

//------------------------------------------------------------------------------
// RISC-V
//------------------------------------------------------------------------------
wire                         riscv_boot;
wire                         riscv_external_wait;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////



// Instanciation of rw_he_top_wrapper
// Name of the instance : u_rw_he_top_wrapper
// Name of the file containing this module : rw_he_top_wrapper.v
rw_he_top_wrapper u_rw_he_top_wrapper (
		.sys_rst_n              (sys_rst_n),
		.ref0_root_clk          (ref0_root_clk),
		.ref1_root_clk          (ref1_root_clk),
		.fe_clk                 (fe_clk),
		.fe_rst_n               (fe_rst_n),
		.plf_clk                (plf_clk),
		.plf_rst_n              (plf_rst_n),
		.plf_por_n              (plf_por_n),
`ifndef RW_CRM_FPGA
		.plf_root_clk           (plf_root_clk),
		.mac_lp_root_clk        (mac_lp_root_clk),
`else
		.global_rst_n           (global_rst_n),
		.ref80_clk              (ref80_clk),
		.ref80_rst_n            (ref80_rst_n),
		.axi_aclk               (axi_aclk),
		.axi_por_n              (axi_por_n),
`endif
		.platform_wake_up       (platform_wake_up),
		.proc_hready            (proc_hready),
		.proc_hready_in         (proc_hready),
		.proc_haddr             (proc_haddr),
		.proc_htrans            (proc_htrans),
		.proc_hwrite            (proc_hwrite),
		.proc_hsize             (proc_hsize),
		.proc_hrdata            (proc_hrdata),
		.proc_hwdata            (proc_hwdata),
		.proc_hresp             (proc_hresp),
`ifdef  RW_FPGA_AHB
      .fpga_irq               (fpga_irq),
`endif//RW_FPGA_AHB
		.host_irq               (host_irq),
		.proc_irq               (proc_irq),
		.cpu_single_irq         (cpu_single_irq),
		.tick_timer_irq         (tick_timer_irq),
		.soft_irq               (soft_irq),
		.gpio_out               (gpio_out),
		.gpio_in                (gpio_in),
		.gpio_oen               (gpio_oen),
`ifdef RW_COEX_MODEL
		.coexif_hready_in       (coexif_hready_in),
		.coexif_hsel            (coexif_hsel),
		.coexif_haddr           (coexif_haddr),
		.coexif_htrans          (coexif_htrans),
		.coexif_hwrite          (coexif_hwrite),
		.coexif_hrdata          (coexif_hrdata),
		.coexif_hwdata          (coexif_hwdata),
		.coexif_hresp           (coexif_hresp),
		.coexif_hready          (coexif_hready),
`endif // RW_COEX_MODEL
`ifdef RW_WLAN_COEX_EN
		.coex_bt_tx             (coex_bt_tx),
		.coex_bt_rx             (coex_bt_rx),
		.coex_bt_event          (coex_bt_event),
		.coex_bt_tx_abort       (coex_bt_tx_abort),
		.coex_bt_rx_abort       (coex_bt_rx_abort),
		.coex_bt_pti            (coex_bt_pti),
		.coex_bt_channel        (coex_bt_channel),
		.coex_bt_bw             (coex_bt_bw),
`endif // RW_WLAN_COEX_EN
		.rc_tx_abort            (rc_tx_abort),
		.rc_rx_abort            (rc_rx_abort),
		.dma0_awid              (dma0_awid),
		.dma0_awaddr            (dma0_awaddr),
		.dma0_awlen             (dma0_awlen),
		.dma0_awsize            (dma0_awsize),
		.dma0_awburst           (dma0_awburst),
		.dma0_awuser            (dma0_awuser),
		.dma0_awvalid           (dma0_awvalid),
		.dma0_awready           (dma0_awready),
		.dma0_wid               (dma0_wid),
		.dma0_wdata             (dma0_wdata),
		.dma0_wstrb             (dma0_wstrb),
		.dma0_wlast             (dma0_wlast),
		.dma0_wvalid            (dma0_wvalid),
		.dma0_wready            (dma0_wready),
		.dma0_bid               (dma0_bid),
		.dma0_bresp             (dma0_bresp),
		.dma0_bvalid            (dma0_bvalid),
		.dma0_bready            (dma0_bready),
		.dma1_arid              (dma1_arid),
		.dma1_araddr            (dma1_araddr),
		.dma1_arlen             (dma1_arlen),
		.dma1_arsize            (dma1_arsize),
		.dma1_arburst           (dma1_arburst),
		.dma1_arvalid           (dma1_arvalid),
		.dma1_arready           (dma1_arready),
		.dma1_rid               (dma1_rid),
		.dma1_rdata             (dma1_rdata),
		.dma1_rresp             (dma1_rresp),
		.dma1_rlast             (dma1_rlast),
		.dma1_rvalid            (dma1_rvalid),
		.dma1_rready            (dma1_rready),
		.adc0_on                (adc0_on),
		.adc0_i                 (adc0_i),
		.adc0_q                 (adc0_q),
`ifdef RW_NX_DERIV_FE_PATH1
		.adc1_on                (adc1_on),
		.adc1_i                 (adc1_i),
		.adc1_q                 (adc1_q),
`endif                                                       
		.dac0_on                (dac0_on),
		.dac0_en                (dac0_en),
		.dac0_i                 (dac0_i),
		.dac0_q                 (dac0_q),
`ifdef RW_NX_DERIV_FE_PATH1
		.dac1_on                (dac1_on),
		.dac1_en                (dac1_en),
		.dac1_i                 (dac1_i),
		.dac1_q                 (dac1_q),
`endif
		.rf_resetn              (rf_resetn),
		.rf_agcfreeze           (rf_agcfreeze),
		.rf_tmode               (rf_tmode),
		.rf_gpio                (rf_gpio),
		.rf_spi_in              (rf_spi_in),
		.rf_spi_ss_n            (rf_spi_ss_n),
		.rf_spi_clk             (rf_spi_clk),
		.rf_spi_out             (rf_spi_out),
		.rf_trsw0               (rf_trsw0),
`ifdef RW_NX_DERIV_FE_PATH1
		.rf_trsw1               (rf_trsw1),
`endif
		.rf_extpaon_ch0_5G9     (rf_extpaon_ch0_5G9),
		.rf_extpaon_ch0_2G4     (rf_extpaon_ch0_2G4),
`ifdef RW_NX_DERIV_FE_PATH1
		.rf_extpaon_ch1_5G9     (rf_extpaon_ch1_5G9),
		.rf_extpaon_ch1_2G4     (rf_extpaon_ch1_2G4),
`endif
`ifdef RW_FPGA_AHB
		.fpga_hready_in         (fpga_hready_in),
		.fpga_hsel              (fpga_hsel),
		.fpga_haddr             (fpga_haddr),
		.fpga_htrans            (fpga_htrans),
		.fpga_hwrite            (fpga_hwrite),
		.fpga_hrdata            (fpga_hrdata),
		.fpga_hwdata            (fpga_hwdata),
		.fpga_hresp             (fpga_hresp),
		.fpga_hready            (fpga_hready),
`endif // RW_FPGA_AHB
		.ext_diagport           (ext_diagport),
		.reg_bootrom_enable     (reg_bootrom_enable),
		.rw_nx_ss_diag          (rw_nx_ss_diag),
		.rw_nx_diag0            (rw_nx_diag0),
		.rw_nx_diag1            (rw_nx_diag1),
		.rw_nx_diag2            (rw_nx_diag2),
		.rw_nx_diag3            (rw_nx_diag3),
		.rw_nx_diag4            (rw_nx_diag4),
		.rw_nx_diag5            (rw_nx_diag5),
		.rw_nx_diag6            (rw_nx_diag6),
		.mac_internal_error     (mac_internal_error),
		.mac_debug_ksr          (mac_debug_ksr),
		.macbypass_trigger      (macbypass_trigger),
		.reg_diag_trigger       (reg_diag_trigger)
		);

//******************************************************************************
//
// RISC-V SUBSYSTEM SECTION
//
//******************************************************************************
assign riscv_boot          = 1'b0;
assign riscv_external_wait = !reg_bootrom_enable; //TODO

riscv_subsys u_riscv_subsys (
  //----------------------------------------------------------------------------
  // System
  //----------------------------------------------------------------------------
  .por_rst_n        (plf_por_n           ),
  .rst_n            (plf_rst_n           ),
  .clk              (plf_clk             ),
  //----------------------------------------------------------------------------
  // Processor control
  //----------------------------------------------------------------------------
  .boot             (riscv_boot          ),
  .external_wait    (riscv_external_wait ),
  //----------------------------------------------------------------------------
  // Interrupts
  //----------------------------------------------------------------------------
  .int0             (cpu_single_irq      ),
  .int1             (tick_timer_irq      ),
  .int2             (soft_irq            ),
  //----------------------------------------------------------------------------
  // ahb target interface
  //----------------------------------------------------------------------------
  .target_haddr     (target_haddr        ),
  .target_hburst    (target_hburst       ),
  .target_hmastlock (target_hmastlock    ),
  .target_hprot     (target_hprot        ),
  .target_hrdata    (target_hrdata       ),
  .target_hready    (target_hready       ),
  .target_hresp     (target_hresp        ),
  .target_hsize     (target_hsize        ),
  .target_htrans    (target_htrans       ),
  .target_hwdata    (target_hwdata       ),
  .target_hwrite    (target_hwrite       ),
  //----------------------------------------------------------------------------
  // AHB output
  //----------------------------------------------------------------------------
  .plf_hready       (proc_hready         ),
  .plf_haddr        (proc_haddr          ),
  .plf_htrans       (proc_htrans         ),
  .plf_hwrite       (proc_hwrite         ),
  .plf_hsize        (proc_hsize          ),
  .plf_hrdata       (proc_hrdata         ),
  .plf_hwdata       (proc_hwdata         ),
  .plf_hresp        (proc_hresp          ),
  //----------------------------------------------------------------------------
  // JTAG
  //----------------------------------------------------------------------------
  .tck              (jtag_tck            ),
  .tms              (jtag_tms            ),
  .tdi              (jtag_tdi            ),
  .tdo              (jtag_tdo            ),
  .tdo_oen          (/*Open*/            ),
  //----------------------------------------------------------------------------
  // DIAG
  //----------------------------------------------------------------------------
  .diag0            (                    ),
  .diag1            (                    )
);





assign jtag_rtck = 1'b0;

endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
