//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 35768 $
// $Date: 2018-10-18 14:20:16 +0200 (Thu, 18 Oct 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : RIUKarst_reg register
//                    
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module RIUKarst_reg (
    ////////////////////////////////////////////
    //$port_g clock and reset
    ////////////////////////////////////////////
    input wire rst_n     , // Hard Reset.
    input wire clk         , // clock clock.

    ////////////////////////////////////////////
    // Registers
    ////////////////////////////////////////////
    //$port_g RWNXVERSION register.
    input wire [7 : 0] RESERVED                   ,// in
    input wire [1 : 0] AGCRAMMODE                 ,// in
    input wire  IQCOMP                     ,// in
    input wire  DSSSCORR                   ,// in
    input wire  FIQCOMP                    ,// in
    input wire  AGCSNR                     ,// in
    input wire  RADAR                      ,// in
    input wire  DSSSCCK                    ,// in
    input wire [1 : 0] CHBW                       ,// in
    input wire [3 : 0] NSS                        ,// in
    input wire [3 : 0] NTX                        ,// in
    input wire [3 : 0] NRX                        ,// in
    //$port_g RWNXDYNAMICCONFIG register.
    input wire  AGCINBDPOWSTARTCAPTUREIn,// in
    input wire  AGCINBDPOWSTARTCAPTUREInValid,// in
`ifdef RW_NX_IQ_COMP_EN               
    //$port_g RWNXFERXIQESTCLR register.
    input wire  statusIQESTITERCLR               ,// in
`endif // RW_NX_IQ_COMP_EN               
`ifdef RW_NX_FIQ_COMP_EN              
    //$port_g RWNXFEFIQCOEFFUPDATE register.
    input wire  FIQCOEFFUPDATEIn,// in
    input wire  FIQCOEFFUPDATEInValid,// in
    //$port_g RWNXFEFIQCOEFFREQ register.
    input wire  FIQCOEFFREQIn,// in
    input wire  FIQCOEFFREQInValid,// in
    //$port_g RWNXFEFIQSTART register.
    input wire  statusFIQESTSTART                ,// in
    input wire  statusFIQCOLLSTART               ,// in
`endif // RW_NX_FIQ_COMP_EN              
    //$port_g AGCGAINSTAT register.
    input wire [7 : 0] AGCGAIN1                   ,// in
    input wire [7 : 0] AGCGAIN0                   ,// in
    //$port_g AGCADCPOWSTAT register.
    input wire [6 : 0] ADCPOWDBV1                 ,// in
    input wire [6 : 0] ADCPOWDBV0                 ,// in
    //$port_g AGCINBDPOW20PSTAT register.
    input wire [7 : 0] INBDPOW20PDBM1             ,// in
    input wire [7 : 0] INBDPOW20PDBM0             ,// in
    //$port_g AGCDIGGAIN0STAT register.
    input wire [6 : 0] DIGGAIN80ANT0              ,// in
    input wire [6 : 0] DIGGAIN40ANT0              ,// in
    input wire [6 : 0] DIGGAIN20ANT0              ,// in
    //$port_g AGCDIGGAIN1STAT register.
    input wire [6 : 0] DIGGAIN80ANT1              ,// in
    input wire [6 : 0] DIGGAIN40ANT1              ,// in
    input wire [6 : 0] DIGGAIN20ANT1              ,// in
`ifdef RW_RADAR_EN                    
    //$port_g RADARFIFOSTAT register.
    input wire  RADFIFOEMPTY               ,// in
`endif // RW_RADAR_EN                    
    //$port_g AGCINBDPOW20PNOISESTAT register.
    input wire [7 : 0] INBDPOW20PNOISEDBM1        ,// in
    input wire [7 : 0] INBDPOW20PNOISEDBM0        ,// in
    //$port_g AGCINBDPOWSECSTAT register.
    input wire [7 : 0] INBDPOW40SDBM              ,// in
    input wire [7 : 0] INBDPOW20SDBM              ,// in
    //$port_g AGCINBDPOWSECNOISESTAT register.
    input wire [7 : 0] INBDPOW40SNOISEDBM         ,// in
    input wire [7 : 0] INBDPOW20SNOISEDBM         ,// in
`ifdef RW_NX_IQ_COMP_EN               
    //$port_g RWNXFERXIQSTATVARI0 register.
    input wire [21 : 0] RXIQVARI0                  ,// in
    //$port_g RWNXFERXIQSTATVARQ0 register.
    input wire [21 : 0] RXIQVARQ0                  ,// in
    //$port_g RWNXFERXIQSTATMIQ0 register.
    input wire [22 : 0] RXIQSTATMIQ0               ,// in
    //$port_g RWNXFERXIQSTAT0 register.
    input wire [8 : 0] RXIQSTATPHASE0             ,// in
    input wire [10 : 0] RXIQSTATGAIN0              ,// in
    //$port_g RWNXFERXIQSTATVARI1 register.
    input wire [21 : 0] RXIQVARI1                  ,// in
    //$port_g RWNXFERXIQSTATVARQ1 register.
    input wire [21 : 0] RXIQVARQ1                  ,// in
    //$port_g RWNXFERXIQSTATMIQ1 register.
    input wire [22 : 0] RXIQSTATMIQ1               ,// in
    //$port_g RWNXFERXIQSTAT1 register.
    input wire [8 : 0] RXIQSTATPHASE1             ,// in
    input wire [10 : 0] RXIQSTATGAIN1              ,// in
`endif // RW_NX_IQ_COMP_EN               
`ifdef RW_NX_FIQ_COMP_EN              
    //$port_g RWNXFEFIQDONE register.
    input wire  FIQESTDONE                 ,// in
    input wire  FIQCOLLDONE                ,// in
    //$port_g RWNXFEFIQSTAT0 register.
    input wire [12 : 0] FIQTXESTERROR0             ,// in
    input wire [12 : 0] FIQRXESTERROR0             ,// in
    //$port_g RWNXFEFIQSTAT1 register.
    input wire [12 : 0] FIQTXESTERROR1             ,// in
    input wire [12 : 0] FIQRXESTERROR1             ,// in
    //$port_g RWNXFEFIQSTATCOEFF0 register.
    input wire [15 : 0] FIQSTATCOEFF0              ,// in
    //$port_g RWNXFEFIQSTATCOEFF1 register.
    input wire [15 : 0] FIQSTATCOEFF1              ,// in
    //$port_g RWNXFEFIQSTATCOEFF2 register.
    input wire [15 : 0] FIQSTATCOEFF2              ,// in
    //$port_g RWNXFEFIQSTATCOEFF3 register.
    input wire [15 : 0] FIQSTATCOEFF3              ,// in
    //$port_g RWNXFEFIQSTATCOEFF4 register.
    input wire [15 : 0] FIQSTATCOEFF4              ,// in
    //$port_g RWNXFEFIQSTATCOEFF5 register.
    input wire [15 : 0] FIQSTATCOEFF5              ,// in
    //$port_g RWNXFEFIQSTATCOEFF6 register.
    input wire [15 : 0] FIQSTATCOEFF6              ,// in
    //$port_g RWNXFEFIQSTATCOEFF7 register.
    input wire [15 : 0] FIQSTATCOEFF7              ,// in
    //$port_g RWNXFEFIQSTATCOEFF8 register.
    input wire [15 : 0] FIQSTATCOEFF8              ,// in
    //$port_g RWNXFEFIQSTATCOEFF9 register.
    input wire [15 : 0] FIQSTATCOEFF9              ,// in
    //$port_g RWNXFEFIQSTATCOEFF10 register.
    input wire [15 : 0] FIQSTATCOEFF10             ,// in
    //$port_g RWNXFEFIQSTATCOEFF11 register.
    input wire [15 : 0] FIQSTATCOEFF11             ,// in
    //$port_g RWNXFEFIQSTATCOEFF12 register.
    input wire [15 : 0] FIQSTATCOEFF12             ,// in
    //$port_g RWNXFEFIQSTATCOEFF13 register.
    input wire [15 : 0] FIQSTATCOEFF13             ,// in
    //$port_g RWNXFEFIQSTATCOEFF14 register.
    input wire [15 : 0] FIQSTATCOEFF14             ,// in
    //$port_g RWNXFEFIQSTATCOEFF15 register.
    input wire [15 : 0] FIQSTATCOEFF15             ,// in
    //$port_g RWNXFEFIQSTATCOEFF16 register.
    input wire [15 : 0] FIQSTATCOEFF16             ,// in
    //$port_g RWNXFEFIQSTATCOEFF17 register.
    input wire [15 : 0] FIQSTATCOEFF17             ,// in
    //$port_g RWNXFEFIQSTATCOEFF18 register.
    input wire [15 : 0] FIQSTATCOEFF18             ,// in
    //$port_g RWNXFEFIQSTATCOEFF19 register.
    input wire [15 : 0] FIQSTATCOEFF19             ,// in
`endif // RW_NX_FIQ_COMP_EN              
`ifdef RW_NX_AGC_SNR_EN               
`endif // RW_NX_AGC_SNR_EN               
`ifdef RW_RADAR_EN                    
`endif // RW_RADAR_EN                    
    //$port_g RWNXMACINTSTATRAW register.
    input wire  IRQMACRADARDETRAW          ,// in
    input wire  IRQMACCCATIMEOUTRAW        ,// in
    //$port_g RWNXMACINTSTATMASKED register.
    input wire  IRQMACRADARDETMASKED       ,// in
    input wire  IRQMACCCATIMEOUTMASKED     ,// in
    //$port_g RWNXMACINTGEN register.
    input wire  statusIRQMACRADARDETGEN          ,// in
    input wire  statusIRQMACCCATIMEOUTGEN        ,// in
`ifdef RW_NX_DERIV_80211B             
`endif // RW_NX_DERIV_80211B             
    //
    //$port_g RWNXSTATICCONFIG register.
    output reg [1 : 0] ACTIVEANT              ,// out
    //$port_g RWNXDYNAMICCONFIG register.
    output reg  AGCINBDPOWSTARTCAPTURE ,// out
    //$port_g RWNXIQCTRL register.
    output reg  TXIQSWAPPATH1          ,// out
    output reg  TXIQSWAPPATH0          ,// out
    output reg  RXIQSWAPPATH1          ,// out
    output reg  RXIQSWAPPATH0          ,// out
    output reg  TXIQDELPATHQ1          ,// out
    output reg  TXIQDELPATHI1          ,// out
    output reg  TXIQDELPATHQ0          ,// out
    output reg  TXIQDELPATHI0          ,// out
    output reg  RXIQDELPATHQ1          ,// out
    output reg  RXIQDELPATHI1          ,// out
    output reg  RXIQDELPATHQ0          ,// out
    output reg  RXIQDELPATHI0          ,// out
    output reg  TXC2SDISBCFG           ,// out
    output reg  RXC2SDISBCFG           ,// out
    //$port_g RWNXMACSTATICCONFIG register.
    output reg [1 : 0] PSSELECT               ,// out
    //$port_g RWNXFECTRL0 register.
    output reg [6 : 0] TX80DIGGAINLIN0        ,// out
    output reg [6 : 0] TX40DIGGAINLIN0        ,// out
    output reg [6 : 0] TX20DIGGAINLIN0        ,// out
    //$port_g RWNXFECTRL1 register.
    output reg [6 : 0] TX80DIGGAINLIN1        ,// out
    output reg [6 : 0] TX40DIGGAINLIN1        ,// out
    output reg [6 : 0] TX20DIGGAINLIN1        ,// out
`ifdef RW_NX_IQ_COMP_EN               
    //$port_g RWNXFETXIQCOMP0 register.
    output reg  TXIQPHASECOMPEN0       ,// out
    output reg  TXIQGAINCOMPEN0        ,// out
    output reg [8 : 0] TXIQPHASE0             ,// out
    output reg [10 : 0] TXIQGAIN0              ,// out
    //$port_g RWNXFETXIQCOMP1 register.
    output reg  TXIQPHASECOMPEN1       ,// out
    output reg  TXIQGAINCOMPEN1        ,// out
    output reg [8 : 0] TXIQPHASE1             ,// out
    output reg [10 : 0] TXIQGAIN1              ,// out
    //$port_g RWNXFERXIQESTCTRL register.
    output reg [7 : 0] IQESTFOMIN             ,// out
    output reg [2 : 0] IQESTBWLIST            ,// out
    output reg [3 : 0] IQESTMCSMIN            ,// out
    output reg [7 : 0] IQESTSNRMIN            ,// out
    output reg  RXIQPHASEESTEN         ,// out
    output reg  RXIQGAINESTEN          ,// out
    output reg  RXIQPHASECOMPEN        ,// out
    output reg  RXIQGAINCOMPEN         ,// out
    //$port_g RWNXFERXIQESTLOOP register.
    output reg [2 : 0] RXIQESTSTEP4           ,// out
    output reg [2 : 0] RXIQESTSTEP3           ,// out
    output reg [2 : 0] RXIQESTSTEP2           ,// out
    output reg [2 : 0] RXIQESTSTEP1           ,// out
    output reg [2 : 0] RXIQESTSTEP0           ,// out
    output reg [2 : 0] RXIQESTPHASESTEPSTOP   ,// out
    output reg [2 : 0] RXIQESTPHASESTEPINIT   ,// out
    output reg [2 : 0] RXIQESTGAINSTEPSTOP    ,// out
    output reg [2 : 0] RXIQESTGAINSTEPINIT    ,// out
    output reg [2 : 0] RXIQESTDEL             ,// out
    //$port_g RWNXFERXIQESTCLR register.
    output reg  IQESTITERCLR           ,// out
    //$port_g RWNXFERXIQCOMP0 register.
    output reg [8 : 0] RXIQPHASE0             ,// out
    output reg [10 : 0] RXIQGAIN0              ,// out
    //$port_g RWNXFERXIQCOMP1 register.
    output reg [8 : 0] RXIQPHASE1             ,// out
    output reg [10 : 0] RXIQGAIN1              ,// out
`endif // RW_NX_IQ_COMP_EN               
`ifdef RW_NX_FIQ_COMP_EN              
    //$port_g RWNXFEFIQCTRL register.
    output reg  FIQPATHSEL             ,// out
    output reg  FIQTXRX                ,// out
    output reg  FIQRXBYPASS            ,// out
    output reg  FIQTXBYPASS            ,// out
    output reg  FIQCALEN               ,// out
    //$port_g RWNXFEFIQCOLL register.
    output reg [7 : 0] FIQCOLLWROFFSET        ,// out
    output reg [7 : 0] FIQCOLLRDOFFSET        ,// out
    output reg [7 : 0] FIQCOLLSIZE            ,// out
    output reg  FIQCOLLPATH            ,// out
    //$port_g RWNXFEFIQEST0 register.
    output reg [7 : 0] FIQESTQOFFSET          ,// out
    output reg [7 : 0] FIQESTIOFFSET          ,// out
    output reg [7 : 0] FIQESTSIZE             ,// out
    //$port_g RWNXFEFIQEST1 register.
    output reg [3 : 0] FIQESTSTEP             ,// out
    output reg [15 : 0] FIQESTNITE             ,// out
    //$port_g RWNXFEFIQDEL register.
    output reg [4 : 0] FIQRXDEL               ,// out
    output reg [4 : 0] FIQTXDEL               ,// out
    output reg [7 : 0] FIQCOLLDEL             ,// out
    //$port_g RWNXFEFIQCOEFF0 register.
    output reg [15 : 0] FIQCOEFF0              ,// out
    //$port_g RWNXFEFIQCOEFF1 register.
    output reg [15 : 0] FIQCOEFF1              ,// out
    //$port_g RWNXFEFIQCOEFF2 register.
    output reg [15 : 0] FIQCOEFF2              ,// out
    //$port_g RWNXFEFIQCOEFF3 register.
    output reg [15 : 0] FIQCOEFF3              ,// out
    //$port_g RWNXFEFIQCOEFF4 register.
    output reg [15 : 0] FIQCOEFF4              ,// out
    //$port_g RWNXFEFIQCOEFF5 register.
    output reg [15 : 0] FIQCOEFF5              ,// out
    //$port_g RWNXFEFIQCOEFF6 register.
    output reg [15 : 0] FIQCOEFF6              ,// out
    //$port_g RWNXFEFIQCOEFF7 register.
    output reg [15 : 0] FIQCOEFF7              ,// out
    //$port_g RWNXFEFIQCOEFF8 register.
    output reg [15 : 0] FIQCOEFF8              ,// out
    //$port_g RWNXFEFIQCOEFF9 register.
    output reg [15 : 0] FIQCOEFF9              ,// out
    //$port_g RWNXFEFIQCOEFF10 register.
    output reg [15 : 0] FIQCOEFF10             ,// out
    //$port_g RWNXFEFIQCOEFF11 register.
    output reg [15 : 0] FIQCOEFF11             ,// out
    //$port_g RWNXFEFIQCOEFF12 register.
    output reg [15 : 0] FIQCOEFF12             ,// out
    //$port_g RWNXFEFIQCOEFF13 register.
    output reg [15 : 0] FIQCOEFF13             ,// out
    //$port_g RWNXFEFIQCOEFF14 register.
    output reg [15 : 0] FIQCOEFF14             ,// out
    //$port_g RWNXFEFIQCOEFF15 register.
    output reg [15 : 0] FIQCOEFF15             ,// out
    //$port_g RWNXFEFIQCOEFF16 register.
    output reg [15 : 0] FIQCOEFF16             ,// out
    //$port_g RWNXFEFIQCOEFF17 register.
    output reg [15 : 0] FIQCOEFF17             ,// out
    //$port_g RWNXFEFIQCOEFF18 register.
    output reg [15 : 0] FIQCOEFF18             ,// out
    //$port_g RWNXFEFIQCOEFF19 register.
    output reg [15 : 0] FIQCOEFF19             ,// out
    //$port_g RWNXFEFIQCOEFFUPDATE register.
    output reg  FIQCOEFFUPDATE         ,// out
    //$port_g RWNXFEFIQCOEFFREQ register.
    output reg  FIQCOEFFREQ            ,// out
    //$port_g RWNXFEFIQSTART register.
    output reg  FIQESTSTART            ,// out
    output reg  FIQCOLLSTART           ,// out
`endif // RW_NX_FIQ_COMP_EN              
`ifdef RW_RADAR_EN                    
`endif // RW_RADAR_EN                    
`ifdef RW_NX_IQ_COMP_EN               
`endif // RW_NX_IQ_COMP_EN               
`ifdef RW_NX_FIQ_COMP_EN              
`endif // RW_NX_FIQ_COMP_EN              
    //$port_g RWNXAGCANTLOSS register.
    output reg [3 : 0] RFLOSSANT1DB           ,// out
    output reg [3 : 0] RFLOSSANT0DB           ,// out
    //$port_g RWNXAGCGAINRANGE register.
    output reg [6 : 0] RFGAINMAX4DETDB        ,// out
    output reg [6 : 0] RFGAINMIN4DETDB        ,// out
    output reg [6 : 0] RFGAINMAXDB            ,// out
    output reg [6 : 0] RFGAINMINDB            ,// out
    //$port_g RWNXAGCDIGGAINCONF register.
    output reg [3 : 0] DIGGAIN80VS20          ,// out
    output reg [3 : 0] DIGGAIN40VS20          ,// out
`ifdef RW_NX_AGC_SNR_EN               
    //$port_g RWNXAGCNOISECONF register.
    output reg  SNRMEASSEL             ,// out
`endif // RW_NX_AGC_SNR_EN               
    //$port_g RWNXAGCACI20MARG0 register.
    output reg [5 : 0] ACI20MARGMCS3          ,// out
    output reg [5 : 0] ACI20MARGMCS2          ,// out
    output reg [5 : 0] ACI20MARGMCS1          ,// out
    output reg [5 : 0] ACI20MARGMCS0          ,// out
    //$port_g RWNXAGCACI20MARG1 register.
    output reg [5 : 0] ACI20MARGMCS7          ,// out
    output reg [5 : 0] ACI20MARGMCS6          ,// out
    output reg [5 : 0] ACI20MARGMCS5          ,// out
    output reg [5 : 0] ACI20MARGMCS4          ,// out
    //$port_g RWNXAGCACI20MARG2 register.
    output reg [5 : 0] ACI20MARGMCS9          ,// out
    output reg [5 : 0] ACI20MARGMCS8          ,// out
    //$port_g RWNXAGCACI40MARG0 register.
    output reg [5 : 0] ACI40MARGMCS3          ,// out
    output reg [5 : 0] ACI40MARGMCS2          ,// out
    output reg [5 : 0] ACI40MARGMCS1          ,// out
    output reg [5 : 0] ACI40MARGMCS0          ,// out
    //$port_g RWNXAGCACI40MARG1 register.
    output reg [5 : 0] ACI40MARGMCS7          ,// out
    output reg [5 : 0] ACI40MARGMCS6          ,// out
    output reg [5 : 0] ACI40MARGMCS5          ,// out
    output reg [5 : 0] ACI40MARGMCS4          ,// out
    //$port_g RWNXAGCACI40MARG2 register.
    output reg [5 : 0] ACI40MARGMCS9          ,// out
    output reg [5 : 0] ACI40MARGMCS8          ,// out
    //$port_g RWNXAGCACI80MARG0 register.
    output reg [5 : 0] ACI80MARGMCS3          ,// out
    output reg [5 : 0] ACI80MARGMCS2          ,// out
    output reg [5 : 0] ACI80MARGMCS1          ,// out
    output reg [5 : 0] ACI80MARGMCS0          ,// out
    //$port_g RWNXAGCACI80MARG1 register.
    output reg [5 : 0] ACI80MARGMCS7          ,// out
    output reg [5 : 0] ACI80MARGMCS6          ,// out
    output reg [5 : 0] ACI80MARGMCS5          ,// out
    output reg [5 : 0] ACI80MARGMCS4          ,// out
    //$port_g RWNXAGCACI80MARG2 register.
    output reg [5 : 0] ACI80MARGMCS9          ,// out
    output reg [5 : 0] ACI80MARGMCS8          ,// out
    //$port_g RWNXAGCSAT register.
    output reg [4 : 0] SATDELAY50NS           ,// out
    output reg [5 : 0] SATHIGHTHRDBV          ,// out
    output reg [5 : 0] SATLOWTHRDBV           ,// out
    output reg [5 : 0] SATTHRDBV              ,// out
    //$port_g RWNXAGCCROSS register.
    output reg [9 : 0] CROSSDNTHRQDBM         ,// out
    output reg [9 : 0] CROSSUPTHRQDBM         ,// out
    //$port_g RWNXAGCRAMP register.
    output reg [2 : 0] RAMPDNNDLINDEX         ,// out
    output reg [7 : 0] RAMPDNGAPQDB           ,// out
    output reg [2 : 0] RAMPUPNDLINDEX         ,// out
    output reg [7 : 0] RAMPUPGAPQDB           ,// out
    //$port_g RWNXAGCSTABDIS register.
    output reg [3 : 0] ADCPOWDISNDL           ,// out
    output reg [6 : 0] ADCPOWDISTHRDBV        ,// out
    output reg [2 : 0] PLATNDLINDEX           ,// out
    output reg [4 : 0] PLATDPQDB              ,// out
    //$port_g RWNXAGCDCCOMP0 register.
    output reg [1 : 0] DCDSSSTYPE             ,// out
    output reg [1 : 0] DCCENTEREDTYPE         ,// out
    output reg [1 : 0] DCAGC20TYPE            ,// out
    output reg [1 : 0] DCADCTYPE              ,// out
    output reg [6 : 0] DCADCHOLDTIME50NS      ,// out
    output reg [6 : 0] DCADCZEROTIME50NS      ,// out
    //$port_g RWNXAGCDCCOMP1 register.
    output reg [6 : 0] DCCENTEREDHOLDTIME50NS ,// out
    output reg [6 : 0] DCCENTEREDZEROTIME50NS ,// out
    output reg [6 : 0] DCAGC20HOLDTIME50NS    ,// out
    output reg [6 : 0] DCAGC20ZEROTIME50NS    ,// out
    //$port_g RWNXAGCDCCOMP2 register.
    output reg [6 : 0] DCDSSSHOLDTIME50NS     ,// out
    output reg [6 : 0] DCDSSSZEROTIME50NS     ,// out
    output reg [6 : 0] DELDCSTABLECC          ,// out
    //$port_g RWNXAGCEVT0 register.
    output reg [5 : 0] EVT0OP1                ,// out
    output reg [5 : 0] EVT0OP2                ,// out
    output reg [5 : 0] EVT0OP3                ,// out
    output reg  EVT0PATHCOMB           ,// out
    output reg [2 : 0] EVT0OPCOMB             ,// out
    output reg [8 : 0] EVT0TGTADD             ,// out
    //$port_g RWNXAGCEVT1 register.
    output reg [5 : 0] EVT1OP1                ,// out
    output reg [5 : 0] EVT1OP2                ,// out
    output reg [5 : 0] EVT1OP3                ,// out
    output reg  EVT1PATHCOMB           ,// out
    output reg [2 : 0] EVT1OPCOMB             ,// out
    output reg [8 : 0] EVT1TGTADD             ,// out
    //$port_g RWNXAGCEVT2 register.
    output reg [5 : 0] EVT2OP1                ,// out
    output reg [5 : 0] EVT2OP2                ,// out
    output reg [5 : 0] EVT2OP3                ,// out
    output reg  EVT2PATHCOMB           ,// out
    output reg [2 : 0] EVT2OPCOMB             ,// out
    output reg [8 : 0] EVT2TGTADD             ,// out
    //$port_g RWNXAGCEVT3 register.
    output reg [5 : 0] EVT3OP1                ,// out
    output reg [5 : 0] EVT3OP2                ,// out
    output reg [5 : 0] EVT3OP3                ,// out
    output reg  EVT3PATHCOMB           ,// out
    output reg [2 : 0] EVT3OPCOMB             ,// out
    output reg [8 : 0] EVT3TGTADD             ,// out
    //$port_g RWNXAGCCNTL register.
    output reg  HTSTFGAINEN            ,// out
    output reg  AGCFSMRESET            ,// out
    output reg  RADARDETEN             ,// out
    output reg  RIFSDETEN              ,// out
    output reg  DSSSONLY               ,// out
    output reg  OFDMONLY               ,// out
    output reg [3 : 0] GPSTATUS               ,// out
    output reg [1 : 0] COMBPATHSEL            ,// out
    //$port_g RWNXAGCDSP0 register.
    output reg [3 : 0] NBITADC                ,// out
    output reg [7 : 0] VPEAKADCQDBV           ,// out
    output reg [7 : 0] ADCPOWMINDBV           ,// out
    output reg [7 : 0] ADCPOWBIASQDBV         ,// out
    //$port_g RWNXAGCDSP1 register.
    output reg [7 : 0] ADCPOWMINDBM           ,// out
    output reg [7 : 0] ADCPOWBIASQDBM         ,// out
    //$port_g RWNXAGCDSP2 register.
    output reg [7 : 0] INBDPOW40SBIASQDB      ,// out
    output reg [7 : 0] INBDPOW20SBIASQDB      ,// out
    output reg [7 : 0] INBDPOW20PBIASQDB      ,// out
    //$port_g RWNXAGCDSP3 register.
    output reg [7 : 0] INBDPOWMINDBV          ,// out
    output reg [1 : 0] INBDRND                ,// out
    output reg [7 : 0] INBDPOWMINDBM          ,// out
    //$port_g RWNXAGCDSP4 register.
    output reg [7 : 0] FE40GAIN               ,// out
    output reg [7 : 0] FE20GAIN               ,// out
    //$port_g RWNXAGCCCA0 register.
    output reg [2 : 0] DELCCARAMPDNTAP        ,// out
    output reg [2 : 0] DELCCARAMPUPTAP        ,// out
    output reg [5 : 0] CCADETRAMPDN           ,// out
    output reg [5 : 0] CCADETRAMPUP           ,// out
    //$port_g RWNXAGCCCA1 register.
    output reg [8 : 0] INBDCCA20PPOWMINDBM    ,// out
    output reg [7 : 0] CCA20PFALLTHRDBM       ,// out
    output reg  DISCCAEN               ,// out
    output reg  SATCCAEN               ,// out
    output reg [7 : 0] CCA20PRISETHRDBM       ,// out
    //$port_g RWNXAGCCCACTRL register.
    output reg [3 : 0] CCAFLAG3CTRL           ,// out
    output reg [3 : 0] CCAFLAG2CTRL           ,// out
    output reg [3 : 0] CCAFLAG1CTRL           ,// out
    output reg [3 : 0] CCAFLAG0CTRL           ,// out
    output reg [1 : 0] ANTSELCCA40S           ,// out
    output reg [1 : 0] ANTSELCCA20S           ,// out
    output reg  CCADEMOD               ,// out
    output reg  CCACSEN                ,// out
    output reg [2 : 0] CCARAMPUDEN            ,// out
    output reg [2 : 0] CCAENERGYEN            ,// out
    //$port_g RWNXAGCCCASTATE0 register.
    output reg [10 : 0] RXSTATECCA20SSEL       ,// out
    output reg [10 : 0] RXSTATECCA20PSEL       ,// out
    //$port_g RWNXAGCCCASTATE1 register.
    output reg [10 : 0] RXSTATECCA40SSEL       ,// out
    //$port_g RWNXAGCCCATIMEOUT register.
    output reg [31 : 0] CCATIMEOUT             ,// out
    //$port_g RWNXAGCCOMP0 register.
    output reg [7 : 0] IDINBDPOWGAPDNQDBM     ,// out
    output reg [7 : 0] IDINBDPOWGAPUPQDBM     ,// out
    output reg [7 : 0] INBDPOWINFTHRDBM       ,// out
    output reg [7 : 0] INBDPOWSUPTHRDBM       ,// out
    //$port_g RWNXAGCCOMP1 register.
    output reg [7 : 0] ADCPOWINFTHRDBV        ,// out
    output reg [7 : 0] ADCPOWSUPTHRDBV        ,// out
    output reg [7 : 0] ADCPOWINFTHRDBM        ,// out
    output reg [7 : 0] ADCPOWSUPTHRDBM        ,// out
`ifdef RW_RADAR_EN                    
    //$port_g RWNXAGCRADAR register.
    output reg [1 : 0] ANTSELRADAR            ,// out
    output reg [3 : 0] FREQSINGGAP            ,// out
    output reg [7 : 0] FREQSING               ,// out
    output reg [3 : 0] FOMSINGGAP             ,// out
    output reg [7 : 0] FOMSING                ,// out
    //$port_g RWNXAGCRADARTIM register.
    output reg  PULSETIMERCLEAR        ,// out
    output reg [2 : 0] PULSEIRQFIFOTHR        ,// out
    output reg [7 : 0] PULSEIRQTIMEOUT        ,// out
    //$port_g RWNXAGCDCCOMPRADAR register.
    output reg [1 : 0] DCRADARTYPE            ,// out
    output reg [6 : 0] DCRADARHOLDTIME50NS    ,// out
    output reg [6 : 0] DCRADARZEROTIME50NS    ,// out
`endif // RW_RADAR_EN                    
    //$port_g RWNXAGCCCA2 register.
    output reg [8 : 0] INBDCCA20SPOWMINDBM    ,// out
    output reg [7 : 0] CCA20SFALLTHRDBM       ,// out
    output reg [7 : 0] CCA20SRISETHRDBM       ,// out
    //$port_g RWNXAGCCCA3 register.
    output reg [8 : 0] INBDCCA40SPOWMINDBM    ,// out
    output reg [7 : 0] CCA40SFALLTHRDBM       ,// out
    output reg [7 : 0] CCA40SRISETHRDBM       ,// out
    //$port_g RWNXMACINTEN register.
    output reg  IRQMACRADARDETEN       ,// out
    output reg  IRQMACCCATIMEOUTEN     ,// out
    //$port_g RWNXMACINTACK register.
    output reg  IRQMACRADARDETACK      ,// out
    output reg  IRQMACCCATIMEOUTACK    ,// out
    //$port_g RWNXMACINTGEN register.
    output reg  IRQMACRADARDETGEN      ,// out
    output reg  IRQMACCCATIMEOUTGEN    ,// out
`ifdef RW_NX_DERIV_80211B             
    //$port_g RWNXFEDSSSCCKCNTL register.
    output reg [2 : 0] RXSHIFT4044            ,// out
    output reg [1 : 0] TXSHIFT4044            ,// out
    output reg [1 : 0] BRXPATHSELREG          ,// out
    output reg  RXPATHSELFROMREG       ,// out
`endif // RW_NX_DERIV_80211B             

    ////////////////////////////////////////////
    //$port_g  slave
    ////////////////////////////////////////////
    input wire regbus_sel         , // Device select.
    input wire regbus_rden      , // Defines the enable cycle.
    input wire regbus_wren       , // Write signal.
    input wire [10:0] regbus_addr , // Address.
    input wire [31:0] regbus_wdata, // Write data.
    // 
    output reg [31:0] regbus_rdata  // Read data.

  );

////////////////////////////////////////////////////////////////////////////////
// Port Declaration 
////////////////////////////////////////////////////////////////////////////////
 
 
//////////////////////////////////////////////////////////////////////////////
// Constants for registers addresses
//////////////////////////////////////////////////////////////////////////////



  // Constants for register addresses.
localparam RWNXVERSION_ADDR_CT             = 9'b00000000;
localparam RWNXSTATICCONFIG_ADDR_CT        = 9'b00000001;
localparam RWNXDYNAMICCONFIG_ADDR_CT       = 9'b00000010;
localparam RWNXIQCTRL_ADDR_CT              = 9'b00000111;
localparam RWNXMACSTATICCONFIG_ADDR_CT     = 9'b00100000;
localparam RWNXFECTRL0_ADDR_CT             = 9'b01000000;
localparam RWNXFECTRL1_ADDR_CT             = 9'b01000001;
`ifdef RW_NX_IQ_COMP_EN               
localparam RWNXFETXIQCOMP0_ADDR_CT         = 9'b01000010;
localparam RWNXFETXIQCOMP1_ADDR_CT         = 9'b01000011;
localparam RWNXFERXIQESTCTRL_ADDR_CT       = 9'b01000100;
localparam RWNXFERXIQESTLOOP_ADDR_CT       = 9'b01000101;
localparam RWNXFERXIQESTCLR_ADDR_CT        = 9'b01000110;
localparam RWNXFERXIQCOMP0_ADDR_CT         = 9'b01000111;
localparam RWNXFERXIQCOMP1_ADDR_CT         = 9'b01001000;
`endif // RW_NX_IQ_COMP_EN               
`ifdef RW_NX_FIQ_COMP_EN              
localparam RWNXFEFIQCTRL_ADDR_CT           = 9'b01001001;
localparam RWNXFEFIQCOLL_ADDR_CT           = 9'b01001010;
localparam RWNXFEFIQEST0_ADDR_CT           = 9'b01001011;
localparam RWNXFEFIQEST1_ADDR_CT           = 9'b01001100;
localparam RWNXFEFIQDEL_ADDR_CT            = 9'b01001101;
localparam RWNXFEFIQCOEFF0_ADDR_CT         = 9'b01001110;
localparam RWNXFEFIQCOEFF1_ADDR_CT         = 9'b01001111;
localparam RWNXFEFIQCOEFF2_ADDR_CT         = 9'b01010000;
localparam RWNXFEFIQCOEFF3_ADDR_CT         = 9'b01010001;
localparam RWNXFEFIQCOEFF4_ADDR_CT         = 9'b01010010;
localparam RWNXFEFIQCOEFF5_ADDR_CT         = 9'b01010011;
localparam RWNXFEFIQCOEFF6_ADDR_CT         = 9'b01010100;
localparam RWNXFEFIQCOEFF7_ADDR_CT         = 9'b01010101;
localparam RWNXFEFIQCOEFF8_ADDR_CT         = 9'b01010110;
localparam RWNXFEFIQCOEFF9_ADDR_CT         = 9'b01010111;
localparam RWNXFEFIQCOEFF10_ADDR_CT        = 9'b01011000;
localparam RWNXFEFIQCOEFF11_ADDR_CT        = 9'b01011001;
localparam RWNXFEFIQCOEFF12_ADDR_CT        = 9'b01011010;
localparam RWNXFEFIQCOEFF13_ADDR_CT        = 9'b01011011;
localparam RWNXFEFIQCOEFF14_ADDR_CT        = 9'b01011100;
localparam RWNXFEFIQCOEFF15_ADDR_CT        = 9'b01011101;
localparam RWNXFEFIQCOEFF16_ADDR_CT        = 9'b01011110;
localparam RWNXFEFIQCOEFF17_ADDR_CT        = 9'b01011111;
localparam RWNXFEFIQCOEFF18_ADDR_CT        = 9'b01100000;
localparam RWNXFEFIQCOEFF19_ADDR_CT        = 9'b01100001;
localparam RWNXFEFIQCOEFFUPDATE_ADDR_CT    = 9'b01100010;
localparam RWNXFEFIQCOEFFREQ_ADDR_CT       = 9'b01100011;
localparam RWNXFEFIQSTART_ADDR_CT          = 9'b01100100;
`endif // RW_NX_FIQ_COMP_EN              
localparam AGCGAINSTAT_ADDR_CT             = 9'b10000000;
localparam AGCADCPOWSTAT_ADDR_CT           = 9'b10000010;
localparam AGCINBDPOW20PSTAT_ADDR_CT       = 9'b10000011;
localparam AGCDIGGAIN0STAT_ADDR_CT         = 9'b10000100;
localparam AGCDIGGAIN1STAT_ADDR_CT         = 9'b10000101;
`ifdef RW_RADAR_EN                    
localparam RADARFIFOSTAT_ADDR_CT           = 9'b10001000;
`endif // RW_RADAR_EN                    
localparam AGCINBDPOW20PNOISESTAT_ADDR_CT  = 9'b10001010;
localparam AGCINBDPOWSECSTAT_ADDR_CT       = 9'b10001011;
localparam AGCINBDPOWSECNOISESTAT_ADDR_CT  = 9'b10001100;
`ifdef RW_NX_IQ_COMP_EN               
localparam RWNXFERXIQSTATVARI0_ADDR_CT     = 9'b10010000;
localparam RWNXFERXIQSTATVARQ0_ADDR_CT     = 9'b10010001;
localparam RWNXFERXIQSTATMIQ0_ADDR_CT      = 9'b10010010;
localparam RWNXFERXIQSTAT0_ADDR_CT         = 9'b10010011;
localparam RWNXFERXIQSTATVARI1_ADDR_CT     = 9'b10010100;
localparam RWNXFERXIQSTATVARQ1_ADDR_CT     = 9'b10010101;
localparam RWNXFERXIQSTATMIQ1_ADDR_CT      = 9'b10010110;
localparam RWNXFERXIQSTAT1_ADDR_CT         = 9'b10010111;
`endif // RW_NX_IQ_COMP_EN               
`ifdef RW_NX_FIQ_COMP_EN              
localparam RWNXFEFIQDONE_ADDR_CT           = 9'b10011000;
localparam RWNXFEFIQSTAT0_ADDR_CT          = 9'b10011001;
localparam RWNXFEFIQSTAT1_ADDR_CT          = 9'b10011010;
localparam RWNXFEFIQSTATCOEFF0_ADDR_CT     = 9'b10011011;
localparam RWNXFEFIQSTATCOEFF1_ADDR_CT     = 9'b10011100;
localparam RWNXFEFIQSTATCOEFF2_ADDR_CT     = 9'b10011101;
localparam RWNXFEFIQSTATCOEFF3_ADDR_CT     = 9'b10011110;
localparam RWNXFEFIQSTATCOEFF4_ADDR_CT     = 9'b10011111;
localparam RWNXFEFIQSTATCOEFF5_ADDR_CT     = 9'b10100000;
localparam RWNXFEFIQSTATCOEFF6_ADDR_CT     = 9'b10100001;
localparam RWNXFEFIQSTATCOEFF7_ADDR_CT     = 9'b10100010;
localparam RWNXFEFIQSTATCOEFF8_ADDR_CT     = 9'b10100011;
localparam RWNXFEFIQSTATCOEFF9_ADDR_CT     = 9'b10100100;
localparam RWNXFEFIQSTATCOEFF10_ADDR_CT    = 9'b10100101;
localparam RWNXFEFIQSTATCOEFF11_ADDR_CT    = 9'b10100110;
localparam RWNXFEFIQSTATCOEFF12_ADDR_CT    = 9'b10100111;
localparam RWNXFEFIQSTATCOEFF13_ADDR_CT    = 9'b10101000;
localparam RWNXFEFIQSTATCOEFF14_ADDR_CT    = 9'b10101001;
localparam RWNXFEFIQSTATCOEFF15_ADDR_CT    = 9'b10101010;
localparam RWNXFEFIQSTATCOEFF16_ADDR_CT    = 9'b10101011;
localparam RWNXFEFIQSTATCOEFF17_ADDR_CT    = 9'b10101100;
localparam RWNXFEFIQSTATCOEFF18_ADDR_CT    = 9'b10101101;
localparam RWNXFEFIQSTATCOEFF19_ADDR_CT    = 9'b10101110;
`endif // RW_NX_FIQ_COMP_EN              
localparam RWNXAGCANTLOSS_ADDR_CT          = 9'b11000000;
localparam RWNXAGCGAINRANGE_ADDR_CT        = 9'b11000001;
localparam RWNXAGCDIGGAINCONF_ADDR_CT      = 9'b11000010;
`ifdef RW_NX_AGC_SNR_EN               
localparam RWNXAGCNOISECONF_ADDR_CT        = 9'b11000011;
`endif // RW_NX_AGC_SNR_EN               
localparam RWNXAGCACI20MARG0_ADDR_CT       = 9'b11010000;
localparam RWNXAGCACI20MARG1_ADDR_CT       = 9'b11010001;
localparam RWNXAGCACI20MARG2_ADDR_CT       = 9'b11010010;
localparam RWNXAGCACI40MARG0_ADDR_CT       = 9'b11010011;
localparam RWNXAGCACI40MARG1_ADDR_CT       = 9'b11010100;
localparam RWNXAGCACI40MARG2_ADDR_CT       = 9'b11010101;
localparam RWNXAGCACI80MARG0_ADDR_CT       = 9'b11010110;
localparam RWNXAGCACI80MARG1_ADDR_CT       = 9'b11010111;
localparam RWNXAGCACI80MARG2_ADDR_CT       = 9'b11011000;
localparam RWNXAGCSAT_ADDR_CT              = 9'b11011001;
localparam RWNXAGCCROSS_ADDR_CT            = 9'b11011010;
localparam RWNXAGCRAMP_ADDR_CT             = 9'b11011011;
localparam RWNXAGCSTABDIS_ADDR_CT          = 9'b11011100;
localparam RWNXAGCDCCOMP0_ADDR_CT          = 9'b11011101;
localparam RWNXAGCDCCOMP1_ADDR_CT          = 9'b11011110;
localparam RWNXAGCDCCOMP2_ADDR_CT          = 9'b11011111;
localparam RWNXAGCEVT0_ADDR_CT             = 9'b11100000;
localparam RWNXAGCEVT1_ADDR_CT             = 9'b11100001;
localparam RWNXAGCEVT2_ADDR_CT             = 9'b11100010;
localparam RWNXAGCEVT3_ADDR_CT             = 9'b11100011;
localparam RWNXAGCCNTL_ADDR_CT             = 9'b11100100;
localparam RWNXAGCDSP0_ADDR_CT             = 9'b11100101;
localparam RWNXAGCDSP1_ADDR_CT             = 9'b11100110;
localparam RWNXAGCDSP2_ADDR_CT             = 9'b11100111;
localparam RWNXAGCDSP3_ADDR_CT             = 9'b11101000;
localparam RWNXAGCDSP4_ADDR_CT             = 9'b11101001;
localparam RWNXAGCCCA0_ADDR_CT             = 9'b11101010;
localparam RWNXAGCCCA1_ADDR_CT             = 9'b11101011;
localparam RWNXAGCCCACTRL_ADDR_CT          = 9'b11101100;
localparam RWNXAGCCCASTATE0_ADDR_CT        = 9'b11101101;
localparam RWNXAGCCCASTATE1_ADDR_CT        = 9'b11101110;
localparam RWNXAGCCCATIMEOUT_ADDR_CT       = 9'b11101111;
localparam RWNXAGCCOMP0_ADDR_CT            = 9'b11110000;
localparam RWNXAGCCOMP1_ADDR_CT            = 9'b11110001;
`ifdef RW_RADAR_EN                    
localparam RWNXAGCRADAR_ADDR_CT            = 9'b11110010;
localparam RWNXAGCRADARTIM_ADDR_CT         = 9'b11110011;
localparam RWNXAGCDCCOMPRADAR_ADDR_CT      = 9'b11110100;
`endif // RW_RADAR_EN                    
localparam RWNXAGCCCA2_ADDR_CT             = 9'b11110101;
localparam RWNXAGCCCA3_ADDR_CT             = 9'b11110110;
localparam RWNXMACINTEN_ADDR_CT            = 9'b100000101;
localparam RWNXMACINTSTATRAW_ADDR_CT       = 9'b100000110;
localparam RWNXMACINTSTATMASKED_ADDR_CT    = 9'b100000111;
localparam RWNXMACINTACK_ADDR_CT           = 9'b100001000;
localparam RWNXMACINTGEN_ADDR_CT           = 9'b100001001;
`ifdef RW_NX_DERIV_80211B             
localparam RWNXFEDSSSCCKCNTL_ADDR_CT       = 9'b101000000;
`endif // RW_NX_DERIV_80211B             


  //////////////////////////////////////////////////////////////////////////////
  // Register write
  //////////////////////////////////////////////////////////////////////////////

  always @(posedge clk or negedge rst_n)
  begin
    if (!rst_n) 
    begin

      // RWNXSTATICCONFIG register.
      ACTIVEANT               <= 2'b0;
      // RWNXDYNAMICCONFIG register.
      AGCINBDPOWSTARTCAPTURE  <= 1'b0;
      // RWNXIQCTRL register.
      TXIQSWAPPATH1           <= 1'b0;
      TXIQSWAPPATH0           <= 1'b0;
      RXIQSWAPPATH1           <= 1'b0;
      RXIQSWAPPATH0           <= 1'b0;
      TXIQDELPATHQ1           <= 1'b0;
      TXIQDELPATHI1           <= 1'b0;
      TXIQDELPATHQ0           <= 1'b0;
      TXIQDELPATHI0           <= 1'b0;
      RXIQDELPATHQ1           <= 1'b0;
      RXIQDELPATHI1           <= 1'b0;
      RXIQDELPATHQ0           <= 1'b0;
      RXIQDELPATHI0           <= 1'b0;
      TXC2SDISBCFG            <= 1'b0;
      RXC2SDISBCFG            <= 1'b0;
      // RWNXMACSTATICCONFIG register.
      PSSELECT                <= 2'b0;
      // RWNXFECTRL0 register.
      TX80DIGGAINLIN0         <= 7'b100000;
      TX40DIGGAINLIN0         <= 7'b1000000;
      TX20DIGGAINLIN0         <= 7'b1000000;
      // RWNXFECTRL1 register.
      TX80DIGGAINLIN1         <= 7'b100000;
      TX40DIGGAINLIN1         <= 7'b1000000;
      TX20DIGGAINLIN1         <= 7'b1000000;
`ifdef RW_NX_IQ_COMP_EN               
      // RWNXFETXIQCOMP0 register.
      TXIQPHASECOMPEN0        <= 1'b0;
      TXIQGAINCOMPEN0         <= 1'b0;
      TXIQPHASE0              <= 9'b00000000;
      TXIQGAIN0               <= 11'b10000000000;
      // RWNXFETXIQCOMP1 register.
      TXIQPHASECOMPEN1        <= 1'b0;
      TXIQGAINCOMPEN1         <= 1'b0;
      TXIQPHASE1              <= 9'b00000000;
      TXIQGAIN1               <= 11'b10000000000;
      // RWNXFERXIQESTCTRL register.
      IQESTFOMIN              <= 8'b0000000;
      IQESTBWLIST             <= 3'b111;
      IQESTMCSMIN             <= 4'b000;
      IQESTSNRMIN             <= 8'b0000000;
      RXIQPHASEESTEN          <= 1'b0;
      RXIQGAINESTEN           <= 1'b0;
      RXIQPHASECOMPEN         <= 1'b0;
      RXIQGAINCOMPEN          <= 1'b0;
      // RWNXFERXIQESTLOOP register.
      RXIQESTSTEP4            <= 3'b10;
      RXIQESTSTEP3            <= 3'b10;
      RXIQESTSTEP2            <= 3'b10;
      RXIQESTSTEP1            <= 3'b10;
      RXIQESTSTEP0            <= 3'b10;
      RXIQESTPHASESTEPSTOP    <= 3'b01;
      RXIQESTPHASESTEPINIT    <= 3'b101;
      RXIQESTGAINSTEPSTOP     <= 3'b01;
      RXIQESTGAINSTEPINIT     <= 3'b110;
      RXIQESTDEL              <= 3'b10;
      // RWNXFERXIQESTCLR register.
      IQESTITERCLR            <= 1'b0;
      // RWNXFERXIQCOMP0 register.
      RXIQPHASE0              <= 9'b00000000;
      RXIQGAIN0               <= 11'b10000000000;
      // RWNXFERXIQCOMP1 register.
      RXIQPHASE1              <= 9'b00000000;
      RXIQGAIN1               <= 11'b10000000000;
`endif // RW_NX_IQ_COMP_EN               
`ifdef RW_NX_FIQ_COMP_EN              
      // RWNXFEFIQCTRL register.
      FIQPATHSEL              <= 1'b0;
      FIQTXRX                 <= 1'b0;
      FIQRXBYPASS             <= 1'b1;
      FIQTXBYPASS             <= 1'b1;
      FIQCALEN                <= 1'b0;
      // RWNXFEFIQCOLL register.
      FIQCOLLWROFFSET         <= 8'b10000000;
      FIQCOLLRDOFFSET         <= 8'b0000000;
      FIQCOLLSIZE             <= 8'b10000000;
      FIQCOLLPATH             <= 1'b0;
      // RWNXFEFIQEST0 register.
      FIQESTQOFFSET           <= 8'b10000000;
      FIQESTIOFFSET           <= 8'b0000000;
      FIQESTSIZE              <= 8'b10000000;
      // RWNXFEFIQEST1 register.
      FIQESTSTEP              <= 4'b110;
      FIQESTNITE              <= 16'b010011100010000;
      // RWNXFEFIQDEL register.
      FIQRXDEL                <= 5'b1001;
      FIQTXDEL                <= 5'b1001;
      FIQCOLLDEL              <= 8'b0000000;
      // RWNXFEFIQCOEFF0 register.
      FIQCOEFF0               <= 16'b000000000000000;
      // RWNXFEFIQCOEFF1 register.
      FIQCOEFF1               <= 16'b000000000000000;
      // RWNXFEFIQCOEFF2 register.
      FIQCOEFF2               <= 16'b000000000000000;
      // RWNXFEFIQCOEFF3 register.
      FIQCOEFF3               <= 16'b000000000000000;
      // RWNXFEFIQCOEFF4 register.
      FIQCOEFF4               <= 16'b000000000000000;
      // RWNXFEFIQCOEFF5 register.
      FIQCOEFF5               <= 16'b000000000000000;
      // RWNXFEFIQCOEFF6 register.
      FIQCOEFF6               <= 16'b000000000000000;
      // RWNXFEFIQCOEFF7 register.
      FIQCOEFF7               <= 16'b000000000000000;
      // RWNXFEFIQCOEFF8 register.
      FIQCOEFF8               <= 16'b000000000000000;
      // RWNXFEFIQCOEFF9 register.
      FIQCOEFF9               <= 16'b000000000000000;
      // RWNXFEFIQCOEFF10 register.
      FIQCOEFF10              <= 16'b000000000000000;
      // RWNXFEFIQCOEFF11 register.
      FIQCOEFF11              <= 16'b000000000000000;
      // RWNXFEFIQCOEFF12 register.
      FIQCOEFF12              <= 16'b000000000000000;
      // RWNXFEFIQCOEFF13 register.
      FIQCOEFF13              <= 16'b000000000000000;
      // RWNXFEFIQCOEFF14 register.
      FIQCOEFF14              <= 16'b000000000000000;
      // RWNXFEFIQCOEFF15 register.
      FIQCOEFF15              <= 16'b000000000000000;
      // RWNXFEFIQCOEFF16 register.
      FIQCOEFF16              <= 16'b000000000000000;
      // RWNXFEFIQCOEFF17 register.
      FIQCOEFF17              <= 16'b000000000000000;
      // RWNXFEFIQCOEFF18 register.
      FIQCOEFF18              <= 16'b000000000000000;
      // RWNXFEFIQCOEFF19 register.
      FIQCOEFF19              <= 16'b000000000000000;
      // RWNXFEFIQCOEFFUPDATE register.
      FIQCOEFFUPDATE          <= 1'b0;
      // RWNXFEFIQCOEFFREQ register.
      FIQCOEFFREQ             <= 1'b0;
      // RWNXFEFIQSTART register.
      FIQESTSTART             <= 1'b0;
      FIQCOLLSTART            <= 1'b0;
`endif // RW_NX_FIQ_COMP_EN              
`ifdef RW_RADAR_EN                    
`endif // RW_RADAR_EN                    
`ifdef RW_NX_IQ_COMP_EN               
`endif // RW_NX_IQ_COMP_EN               
`ifdef RW_NX_FIQ_COMP_EN              
`endif // RW_NX_FIQ_COMP_EN              
      // RWNXAGCANTLOSS register.
      RFLOSSANT1DB            <= 4'b000;
      RFLOSSANT0DB            <= 4'b000;
      // RWNXAGCGAINRANGE register.
      RFGAINMAX4DETDB         <= 7'b1000010;
      RFGAINMIN4DETDB         <= 7'b000000;
      RFGAINMAXDB             <= 7'b1000010;
      RFGAINMINDB             <= 7'b000000;
      // RWNXAGCDIGGAINCONF register.
      DIGGAIN80VS20           <= 4'b000;
      DIGGAIN40VS20           <= 4'b000;
`ifdef RW_NX_AGC_SNR_EN               
      // RWNXAGCNOISECONF register.
      SNRMEASSEL              <= 1'b0;
`endif // RW_NX_AGC_SNR_EN               
      // RWNXAGCACI20MARG0 register.
      ACI20MARGMCS3           <= 6'b00010;
      ACI20MARGMCS2           <= 6'b00100;
      ACI20MARGMCS1           <= 6'b00101;
      ACI20MARGMCS0           <= 6'b00111;
      // RWNXAGCACI20MARG1 register.
      ACI20MARGMCS7           <= 6'b00000;
      ACI20MARGMCS6           <= 6'b00000;
      ACI20MARGMCS5           <= 6'b00000;
      ACI20MARGMCS4           <= 6'b00001;
      // RWNXAGCACI20MARG2 register.
      ACI20MARGMCS9           <= 6'b00000;
      ACI20MARGMCS8           <= 6'b00000;
      // RWNXAGCACI40MARG0 register.
      ACI40MARGMCS3           <= 6'b01001;
      ACI40MARGMCS2           <= 6'b01011;
      ACI40MARGMCS1           <= 6'b01101;
      ACI40MARGMCS0           <= 6'b10000;
      // RWNXAGCACI40MARG1 register.
      ACI40MARGMCS7           <= 6'b00010;
      ACI40MARGMCS6           <= 6'b00011;
      ACI40MARGMCS5           <= 6'b00011;
      ACI40MARGMCS4           <= 6'b00101;
      // RWNXAGCACI40MARG2 register.
      ACI40MARGMCS9           <= 6'b00001;
      ACI40MARGMCS8           <= 6'b00001;
      // RWNXAGCACI80MARG0 register.
      ACI80MARGMCS3           <= 6'b11000;
      ACI80MARGMCS2           <= 6'b11011;
      ACI80MARGMCS1           <= 6'b11101;
      ACI80MARGMCS0           <= 6'b100000;
      // RWNXAGCACI80MARG1 register.
      ACI80MARGMCS7           <= 6'b01110;
      ACI80MARGMCS6           <= 6'b01111;
      ACI80MARGMCS5           <= 6'b10000;
      ACI80MARGMCS4           <= 6'b10100;
      // RWNXAGCACI80MARG2 register.
      ACI80MARGMCS9           <= 6'b01000;
      ACI80MARGMCS8           <= 6'b01010;
      // RWNXAGCSAT register.
      SATDELAY50NS            <= 5'b1000;
      SATHIGHTHRDBV           <= 6'b111001;
      SATLOWTHRDBV            <= 6'b110101;
      SATTHRDBV               <= 6'b110110;
      // RWNXAGCCROSS register.
      CROSSDNTHRQDBM          <= 10'b1010001000;
      CROSSUPTHRQDBM          <= 10'b1010001000;
      // RWNXAGCRAMP register.
      RAMPDNNDLINDEX          <= 3'b101;
      RAMPDNGAPQDB            <= 8'b0100000;
      RAMPUPNDLINDEX          <= 3'b111;
      RAMPUPGAPQDB            <= 8'b0010000;
      // RWNXAGCSTABDIS register.
      ADCPOWDISNDL            <= 4'b1000;
      ADCPOWDISTHRDBV         <= 7'b1010100;
      PLATNDLINDEX            <= 3'b11;
      PLATDPQDB               <= 5'b1000;
      // RWNXAGCDCCOMP0 register.
      DCDSSSTYPE              <= 2'b1;
      DCCENTEREDTYPE          <= 2'b11;
      DCAGC20TYPE             <= 2'b1;
      DCADCTYPE               <= 2'b1;
      DCADCHOLDTIME50NS       <= 7'b010100;
      DCADCZEROTIME50NS       <= 7'b000000;
      // RWNXAGCDCCOMP1 register.
      DCCENTEREDHOLDTIME50NS  <= 7'b001000;
      DCCENTEREDZEROTIME50NS  <= 7'b000010;
      DCAGC20HOLDTIME50NS     <= 7'b000000;
      DCAGC20ZEROTIME50NS     <= 7'b000010;
      // RWNXAGCDCCOMP2 register.
      DCDSSSHOLDTIME50NS      <= 7'b000000;
      DCDSSSZEROTIME50NS      <= 7'b000010;
      DELDCSTABLECC           <= 7'b000000;
      // RWNXAGCEVT0 register.
      EVT0OP1                 <= 6'b10100;
      EVT0OP2                 <= 6'b10000;
      EVT0OP3                 <= 6'b00001;
      EVT0PATHCOMB            <= 1'b0;
      EVT0OPCOMB              <= 3'b01;
      EVT0TGTADD              <= 9'b00000010;
      // RWNXAGCEVT1 register.
      EVT1OP1                 <= 6'b10101;
      EVT1OP2                 <= 6'b10111;
      EVT1OP3                 <= 6'b01111;
      EVT1PATHCOMB            <= 1'b0;
      EVT1OPCOMB              <= 3'b10;
      EVT1TGTADD              <= 9'b00000101;
      // RWNXAGCEVT2 register.
      EVT2OP1                 <= 6'b11001;
      EVT2OP2                 <= 6'b00000;
      EVT2OP3                 <= 6'b01110;
      EVT2PATHCOMB            <= 1'b1;
      EVT2OPCOMB              <= 3'b10;
      EVT2TGTADD              <= 9'b00001000;
      // RWNXAGCEVT3 register.
      EVT3OP1                 <= 6'b00001;
      EVT3OP2                 <= 6'b01111;
      EVT3OP3                 <= 6'b111111;
      EVT3PATHCOMB            <= 1'b0;
      EVT3OPCOMB              <= 3'b01;
      EVT3TGTADD              <= 9'b00001011;
      // RWNXAGCCNTL register.
      HTSTFGAINEN             <= 1'b1;
      AGCFSMRESET             <= 1'b0;
      RADARDETEN              <= 1'b0;
      RIFSDETEN               <= 1'b1;
      DSSSONLY                <= 1'b0;
      OFDMONLY                <= 1'b0;
      GPSTATUS                <= 4'b000;
      COMBPATHSEL             <= 2'b11;
      // RWNXAGCDSP0 register.
      NBITADC                 <= 4'b1100;
      VPEAKADCQDBV            <= 8'b11101000;
      ADCPOWMINDBV            <= 8'b10110101;
      ADCPOWBIASQDBV          <= 8'b0000000;
      // RWNXAGCDSP1 register.
      ADCPOWMINDBM            <= 8'b10011100;
      ADCPOWBIASQDBM          <= 8'b0000000;
      // RWNXAGCDSP2 register.
      INBDPOW40SBIASQDB       <= 8'b0000000;
      INBDPOW20SBIASQDB       <= 8'b0000000;
      INBDPOW20PBIASQDB       <= 8'b0000000;
      // RWNXAGCDSP3 register.
      INBDPOWMINDBV           <= 8'b10111111;
      INBDRND                 <= 2'b11;
      INBDPOWMINDBM           <= 8'b10011100;
      // RWNXAGCDSP4 register.
      FE40GAIN                <= 8'b0000010;
      FE20GAIN                <= 8'b0000010;
      // RWNXAGCCCA0 register.
      DELCCARAMPDNTAP         <= 3'b101;
      DELCCARAMPUPTAP         <= 3'b101;
      CCADETRAMPDN            <= 6'b01001;
      CCADETRAMPUP            <= 6'b01001;
      // RWNXAGCCCA1 register.
      INBDCCA20PPOWMINDBM     <= 9'b110110101;
      CCA20PFALLTHRDBM        <= 8'b10111111;
      DISCCAEN                <= 1'b1;
      SATCCAEN                <= 1'b1;
      CCA20PRISETHRDBM        <= 8'b11000010;
      // RWNXAGCCCACTRL register.
      CCAFLAG3CTRL            <= 4'b1010;
      CCAFLAG2CTRL            <= 4'b1010;
      CCAFLAG1CTRL            <= 4'b1010;
      CCAFLAG0CTRL            <= 4'b1010;
      ANTSELCCA40S            <= 2'b0;
      ANTSELCCA20S            <= 2'b0;
      CCADEMOD                <= 1'b1;
      CCACSEN                 <= 1'b1;
      CCARAMPUDEN             <= 3'b111;
      CCAENERGYEN             <= 3'b111;
      // RWNXAGCCCASTATE0 register.
      RXSTATECCA20SSEL        <= 11'b0011010100;
      RXSTATECCA20PSEL        <= 11'b11011111110;
      // RWNXAGCCCASTATE1 register.
      RXSTATECCA40SSEL        <= 11'b0010000000;
      // RWNXAGCCCATIMEOUT register.
      CCATIMEOUT              <= 32'b0000000000010001000101110000000;
      // RWNXAGCCOMP0 register.
      IDINBDPOWGAPDNQDBM      <= 8'b0101000;
      IDINBDPOWGAPUPQDBM      <= 8'b0101000;
      INBDPOWINFTHRDBM        <= 8'b10110000;
      INBDPOWSUPTHRDBM        <= 8'b11000100;
      // RWNXAGCCOMP1 register.
      ADCPOWINFTHRDBV         <= 8'b11011101;
      ADCPOWSUPTHRDBV         <= 8'b11011011;
      ADCPOWINFTHRDBM         <= 8'b10111111;
      ADCPOWSUPTHRDBM         <= 8'b10111110;
`ifdef RW_RADAR_EN                    
      // RWNXAGCRADAR register.
      ANTSELRADAR             <= 2'b0;
      FREQSINGGAP             <= 4'b000;
      FREQSING                <= 8'b0000000;
      FOMSINGGAP              <= 4'b000;
      FOMSING                 <= 8'b0000000;
      // RWNXAGCRADARTIM register.
      PULSETIMERCLEAR         <= 1'b0;
      PULSEIRQFIFOTHR         <= 3'b11;
      PULSEIRQTIMEOUT         <= 8'b0001000;
      // RWNXAGCDCCOMPRADAR register.
      DCRADARTYPE             <= 2'b0;
      DCRADARHOLDTIME50NS     <= 7'b001000;
      DCRADARZEROTIME50NS     <= 7'b000000;
`endif // RW_RADAR_EN                    
      // RWNXAGCCCA2 register.
      INBDCCA20SPOWMINDBM     <= 9'b110110000;
      CCA20SFALLTHRDBM        <= 8'b10110101;
      CCA20SRISETHRDBM        <= 8'b10111000;
      // RWNXAGCCCA3 register.
      INBDCCA40SPOWMINDBM     <= 9'b110110000;
      CCA40SFALLTHRDBM        <= 8'b10110101;
      CCA40SRISETHRDBM        <= 8'b10111000;
      // RWNXMACINTEN register.
      IRQMACRADARDETEN        <= 1'b0;
      IRQMACCCATIMEOUTEN      <= 1'b0;
      // RWNXMACINTACK register.
      IRQMACRADARDETACK       <= 1'b0;
      IRQMACCCATIMEOUTACK     <= 1'b0;
      // RWNXMACINTGEN register.
      IRQMACRADARDETGEN       <= 1'b0;
      IRQMACCCATIMEOUTGEN     <= 1'b0;
`ifdef RW_NX_DERIV_80211B             
      // RWNXFEDSSSCCKCNTL register.
      RXSHIFT4044             <= 3'b100;
      TXSHIFT4044             <= 2'b1;
      BRXPATHSELREG           <= 2'b0;
      RXPATHSELFROMREG        <= 1'b1;
`endif // RW_NX_DERIV_80211B             
    end

    else
    begin
      if (AGCINBDPOWSTARTCAPTUREInValid)
        AGCINBDPOWSTARTCAPTURE  <= AGCINBDPOWSTARTCAPTUREIn;
`ifdef RW_NX_IQ_COMP_EN               
`endif // RW_NX_IQ_COMP_EN               
`ifdef RW_NX_FIQ_COMP_EN              
      if (FIQCOEFFUPDATEInValid)
        FIQCOEFFUPDATE          <= FIQCOEFFUPDATEIn;
      if (FIQCOEFFREQInValid)
        FIQCOEFFREQ             <= FIQCOEFFREQIn;
`endif // RW_NX_FIQ_COMP_EN              
`ifdef RW_RADAR_EN                    
`endif // RW_RADAR_EN                    
`ifdef RW_NX_IQ_COMP_EN               
`endif // RW_NX_IQ_COMP_EN               
`ifdef RW_NX_FIQ_COMP_EN              
`endif // RW_NX_FIQ_COMP_EN              
`ifdef RW_NX_AGC_SNR_EN               
`endif // RW_NX_AGC_SNR_EN               
`ifdef RW_RADAR_EN                    
`endif // RW_RADAR_EN                    
`ifdef RW_NX_DERIV_80211B             
`endif // RW_NX_DERIV_80211B             
      if(regbus_sel && regbus_wren)
      begin

        case(regbus_addr [10:2])

          //Write RWNXSTATICCONFIG register.
          RWNXSTATICCONFIG_ADDR_CT : begin
            ACTIVEANT               <= regbus_wdata[1 : 0];
          end

          //Write RWNXDYNAMICCONFIG register.
          RWNXDYNAMICCONFIG_ADDR_CT : begin
            AGCINBDPOWSTARTCAPTURE  <= regbus_wdata[16];
          end

          //Write RWNXIQCTRL register.
          RWNXIQCTRL_ADDR_CT : begin
            TXIQSWAPPATH1           <= regbus_wdata[28];
            TXIQSWAPPATH0           <= regbus_wdata[27];
            RXIQSWAPPATH1           <= regbus_wdata[23];
            RXIQSWAPPATH0           <= regbus_wdata[22];
            TXIQDELPATHQ1           <= regbus_wdata[15];
            TXIQDELPATHI1           <= regbus_wdata[14];
            TXIQDELPATHQ0           <= regbus_wdata[13];
            TXIQDELPATHI0           <= regbus_wdata[12];
            RXIQDELPATHQ1           <= regbus_wdata[5];
            RXIQDELPATHI1           <= regbus_wdata[4];
            RXIQDELPATHQ0           <= regbus_wdata[3];
            RXIQDELPATHI0           <= regbus_wdata[2];
            TXC2SDISBCFG            <= regbus_wdata[1];
            RXC2SDISBCFG            <= regbus_wdata[0];
          end

          //Write RWNXMACSTATICCONFIG register.
          RWNXMACSTATICCONFIG_ADDR_CT : begin
            PSSELECT                <= regbus_wdata[1 : 0];
          end

          //Write RWNXFECTRL0 register.
          RWNXFECTRL0_ADDR_CT : begin
            TX80DIGGAINLIN0         <= regbus_wdata[22 : 16];
            TX40DIGGAINLIN0         <= regbus_wdata[14 : 8];
            TX20DIGGAINLIN0         <= regbus_wdata[6 : 0];
          end

          //Write RWNXFECTRL1 register.
          RWNXFECTRL1_ADDR_CT : begin
            TX80DIGGAINLIN1         <= regbus_wdata[22 : 16];
            TX40DIGGAINLIN1         <= regbus_wdata[14 : 8];
            TX20DIGGAINLIN1         <= regbus_wdata[6 : 0];
          end
`ifdef RW_NX_IQ_COMP_EN               

          //Write RWNXFETXIQCOMP0 register.
          RWNXFETXIQCOMP0_ADDR_CT : begin
            TXIQPHASECOMPEN0        <= regbus_wdata[29];
            TXIQGAINCOMPEN0         <= regbus_wdata[28];
            TXIQPHASE0              <= regbus_wdata[24 : 16];
            TXIQGAIN0               <= regbus_wdata[10 : 0];
          end

          //Write RWNXFETXIQCOMP1 register.
          RWNXFETXIQCOMP1_ADDR_CT : begin
            TXIQPHASECOMPEN1        <= regbus_wdata[29];
            TXIQGAINCOMPEN1         <= regbus_wdata[28];
            TXIQPHASE1              <= regbus_wdata[24 : 16];
            TXIQGAIN1               <= regbus_wdata[10 : 0];
          end

          //Write RWNXFERXIQESTCTRL register.
          RWNXFERXIQESTCTRL_ADDR_CT : begin
            IQESTFOMIN              <= regbus_wdata[31 : 24];
            IQESTBWLIST             <= regbus_wdata[22 : 20];
            IQESTMCSMIN             <= regbus_wdata[15 : 12];
            IQESTSNRMIN             <= regbus_wdata[11 : 4];
            RXIQPHASEESTEN          <= regbus_wdata[3];
            RXIQGAINESTEN           <= regbus_wdata[2];
            RXIQPHASECOMPEN         <= regbus_wdata[1];
            RXIQGAINCOMPEN          <= regbus_wdata[0];
          end

          //Write RWNXFERXIQESTLOOP register.
          RWNXFERXIQESTLOOP_ADDR_CT : begin
            RXIQESTSTEP4            <= regbus_wdata[30 : 28];
            RXIQESTSTEP3            <= regbus_wdata[27 : 25];
            RXIQESTSTEP2            <= regbus_wdata[24 : 22];
            RXIQESTSTEP1            <= regbus_wdata[21 : 19];
            RXIQESTSTEP0            <= regbus_wdata[18 : 16];
            RXIQESTPHASESTEPSTOP    <= regbus_wdata[15 : 13];
            RXIQESTPHASESTEPINIT    <= regbus_wdata[12 : 10];
            RXIQESTGAINSTEPSTOP     <= regbus_wdata[9 : 7];
            RXIQESTGAINSTEPINIT     <= regbus_wdata[6 : 4];
            RXIQESTDEL              <= regbus_wdata[2 : 0];
          end

          //Write RWNXFERXIQESTCLR register.
          RWNXFERXIQESTCLR_ADDR_CT : begin
            IQESTITERCLR            <= regbus_wdata[0];
          end

          //Write RWNXFERXIQCOMP0 register.
          RWNXFERXIQCOMP0_ADDR_CT : begin
            RXIQPHASE0              <= regbus_wdata[24 : 16];
            RXIQGAIN0               <= regbus_wdata[10 : 0];
          end

          //Write RWNXFERXIQCOMP1 register.
          RWNXFERXIQCOMP1_ADDR_CT : begin
            RXIQPHASE1              <= regbus_wdata[24 : 16];
            RXIQGAIN1               <= regbus_wdata[10 : 0];
          end
`endif // RW_NX_IQ_COMP_EN               
`ifdef RW_NX_FIQ_COMP_EN              

          //Write RWNXFEFIQCTRL register.
          RWNXFEFIQCTRL_ADDR_CT : begin
            FIQPATHSEL              <= regbus_wdata[12];
            FIQTXRX                 <= regbus_wdata[8];
            FIQRXBYPASS             <= regbus_wdata[2];
            FIQTXBYPASS             <= regbus_wdata[1];
            FIQCALEN                <= regbus_wdata[0];
          end

          //Write RWNXFEFIQCOLL register.
          RWNXFEFIQCOLL_ADDR_CT : begin
            FIQCOLLWROFFSET         <= regbus_wdata[31 : 24];
            FIQCOLLRDOFFSET         <= regbus_wdata[23 : 16];
            FIQCOLLSIZE             <= regbus_wdata[15 : 8];
            FIQCOLLPATH             <= regbus_wdata[0];
          end

          //Write RWNXFEFIQEST0 register.
          RWNXFEFIQEST0_ADDR_CT : begin
            FIQESTQOFFSET           <= regbus_wdata[31 : 24];
            FIQESTIOFFSET           <= regbus_wdata[23 : 16];
            FIQESTSIZE              <= regbus_wdata[7 : 0];
          end

          //Write RWNXFEFIQEST1 register.
          RWNXFEFIQEST1_ADDR_CT : begin
            FIQESTSTEP              <= regbus_wdata[19 : 16];
            FIQESTNITE              <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQDEL register.
          RWNXFEFIQDEL_ADDR_CT : begin
            FIQRXDEL                <= regbus_wdata[28 : 24];
            FIQTXDEL                <= regbus_wdata[20 : 16];
            FIQCOLLDEL              <= regbus_wdata[7 : 0];
          end

          //Write RWNXFEFIQCOEFF0 register.
          RWNXFEFIQCOEFF0_ADDR_CT : begin
            FIQCOEFF0               <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF1 register.
          RWNXFEFIQCOEFF1_ADDR_CT : begin
            FIQCOEFF1               <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF2 register.
          RWNXFEFIQCOEFF2_ADDR_CT : begin
            FIQCOEFF2               <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF3 register.
          RWNXFEFIQCOEFF3_ADDR_CT : begin
            FIQCOEFF3               <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF4 register.
          RWNXFEFIQCOEFF4_ADDR_CT : begin
            FIQCOEFF4               <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF5 register.
          RWNXFEFIQCOEFF5_ADDR_CT : begin
            FIQCOEFF5               <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF6 register.
          RWNXFEFIQCOEFF6_ADDR_CT : begin
            FIQCOEFF6               <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF7 register.
          RWNXFEFIQCOEFF7_ADDR_CT : begin
            FIQCOEFF7               <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF8 register.
          RWNXFEFIQCOEFF8_ADDR_CT : begin
            FIQCOEFF8               <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF9 register.
          RWNXFEFIQCOEFF9_ADDR_CT : begin
            FIQCOEFF9               <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF10 register.
          RWNXFEFIQCOEFF10_ADDR_CT : begin
            FIQCOEFF10              <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF11 register.
          RWNXFEFIQCOEFF11_ADDR_CT : begin
            FIQCOEFF11              <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF12 register.
          RWNXFEFIQCOEFF12_ADDR_CT : begin
            FIQCOEFF12              <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF13 register.
          RWNXFEFIQCOEFF13_ADDR_CT : begin
            FIQCOEFF13              <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF14 register.
          RWNXFEFIQCOEFF14_ADDR_CT : begin
            FIQCOEFF14              <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF15 register.
          RWNXFEFIQCOEFF15_ADDR_CT : begin
            FIQCOEFF15              <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF16 register.
          RWNXFEFIQCOEFF16_ADDR_CT : begin
            FIQCOEFF16              <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF17 register.
          RWNXFEFIQCOEFF17_ADDR_CT : begin
            FIQCOEFF17              <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF18 register.
          RWNXFEFIQCOEFF18_ADDR_CT : begin
            FIQCOEFF18              <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFF19 register.
          RWNXFEFIQCOEFF19_ADDR_CT : begin
            FIQCOEFF19              <= regbus_wdata[15 : 0];
          end

          //Write RWNXFEFIQCOEFFUPDATE register.
          RWNXFEFIQCOEFFUPDATE_ADDR_CT : begin
            FIQCOEFFUPDATE          <= regbus_wdata[0];
          end

          //Write RWNXFEFIQCOEFFREQ register.
          RWNXFEFIQCOEFFREQ_ADDR_CT : begin
            FIQCOEFFREQ             <= regbus_wdata[0];
          end

          //Write RWNXFEFIQSTART register.
          RWNXFEFIQSTART_ADDR_CT : begin
            FIQESTSTART             <= regbus_wdata[16];
            FIQCOLLSTART            <= regbus_wdata[0];
          end
`endif // RW_NX_FIQ_COMP_EN              
`ifdef RW_RADAR_EN                    
`endif // RW_RADAR_EN                    
`ifdef RW_NX_IQ_COMP_EN               
`endif // RW_NX_IQ_COMP_EN               
`ifdef RW_NX_FIQ_COMP_EN              
`endif // RW_NX_FIQ_COMP_EN              

          //Write RWNXAGCANTLOSS register.
          RWNXAGCANTLOSS_ADDR_CT : begin
            RFLOSSANT1DB            <= regbus_wdata[11 : 8];
            RFLOSSANT0DB            <= regbus_wdata[3 : 0];
          end

          //Write RWNXAGCGAINRANGE register.
          RWNXAGCGAINRANGE_ADDR_CT : begin
            RFGAINMAX4DETDB         <= regbus_wdata[30 : 24];
            RFGAINMIN4DETDB         <= regbus_wdata[22 : 16];
            RFGAINMAXDB             <= regbus_wdata[14 : 8];
            RFGAINMINDB             <= regbus_wdata[6 : 0];
          end

          //Write RWNXAGCDIGGAINCONF register.
          RWNXAGCDIGGAINCONF_ADDR_CT : begin
            DIGGAIN80VS20           <= regbus_wdata[19 : 16];
            DIGGAIN40VS20           <= regbus_wdata[3 : 0];
          end
`ifdef RW_NX_AGC_SNR_EN               

          //Write RWNXAGCNOISECONF register.
          RWNXAGCNOISECONF_ADDR_CT : begin
            SNRMEASSEL              <= regbus_wdata[16];
          end
`endif // RW_NX_AGC_SNR_EN               

          //Write RWNXAGCACI20MARG0 register.
          RWNXAGCACI20MARG0_ADDR_CT : begin
            ACI20MARGMCS3           <= regbus_wdata[29 : 24];
            ACI20MARGMCS2           <= regbus_wdata[21 : 16];
            ACI20MARGMCS1           <= regbus_wdata[13 : 8];
            ACI20MARGMCS0           <= regbus_wdata[5 : 0];
          end

          //Write RWNXAGCACI20MARG1 register.
          RWNXAGCACI20MARG1_ADDR_CT : begin
            ACI20MARGMCS7           <= regbus_wdata[29 : 24];
            ACI20MARGMCS6           <= regbus_wdata[21 : 16];
            ACI20MARGMCS5           <= regbus_wdata[13 : 8];
            ACI20MARGMCS4           <= regbus_wdata[5 : 0];
          end

          //Write RWNXAGCACI20MARG2 register.
          RWNXAGCACI20MARG2_ADDR_CT : begin
            ACI20MARGMCS9           <= regbus_wdata[13 : 8];
            ACI20MARGMCS8           <= regbus_wdata[5 : 0];
          end

          //Write RWNXAGCACI40MARG0 register.
          RWNXAGCACI40MARG0_ADDR_CT : begin
            ACI40MARGMCS3           <= regbus_wdata[29 : 24];
            ACI40MARGMCS2           <= regbus_wdata[21 : 16];
            ACI40MARGMCS1           <= regbus_wdata[13 : 8];
            ACI40MARGMCS0           <= regbus_wdata[5 : 0];
          end

          //Write RWNXAGCACI40MARG1 register.
          RWNXAGCACI40MARG1_ADDR_CT : begin
            ACI40MARGMCS7           <= regbus_wdata[29 : 24];
            ACI40MARGMCS6           <= regbus_wdata[21 : 16];
            ACI40MARGMCS5           <= regbus_wdata[13 : 8];
            ACI40MARGMCS4           <= regbus_wdata[5 : 0];
          end

          //Write RWNXAGCACI40MARG2 register.
          RWNXAGCACI40MARG2_ADDR_CT : begin
            ACI40MARGMCS9           <= regbus_wdata[13 : 8];
            ACI40MARGMCS8           <= regbus_wdata[5 : 0];
          end

          //Write RWNXAGCACI80MARG0 register.
          RWNXAGCACI80MARG0_ADDR_CT : begin
            ACI80MARGMCS3           <= regbus_wdata[29 : 24];
            ACI80MARGMCS2           <= regbus_wdata[21 : 16];
            ACI80MARGMCS1           <= regbus_wdata[13 : 8];
            ACI80MARGMCS0           <= regbus_wdata[5 : 0];
          end

          //Write RWNXAGCACI80MARG1 register.
          RWNXAGCACI80MARG1_ADDR_CT : begin
            ACI80MARGMCS7           <= regbus_wdata[29 : 24];
            ACI80MARGMCS6           <= regbus_wdata[21 : 16];
            ACI80MARGMCS5           <= regbus_wdata[13 : 8];
            ACI80MARGMCS4           <= regbus_wdata[5 : 0];
          end

          //Write RWNXAGCACI80MARG2 register.
          RWNXAGCACI80MARG2_ADDR_CT : begin
            ACI80MARGMCS9           <= regbus_wdata[13 : 8];
            ACI80MARGMCS8           <= regbus_wdata[5 : 0];
          end

          //Write RWNXAGCSAT register.
          RWNXAGCSAT_ADDR_CT : begin
            SATDELAY50NS            <= regbus_wdata[28 : 24];
            SATHIGHTHRDBV           <= regbus_wdata[21 : 16];
            SATLOWTHRDBV            <= regbus_wdata[13 : 8];
            SATTHRDBV               <= regbus_wdata[5 : 0];
          end

          //Write RWNXAGCCROSS register.
          RWNXAGCCROSS_ADDR_CT : begin
            CROSSDNTHRQDBM          <= regbus_wdata[21 : 12];
            CROSSUPTHRQDBM          <= regbus_wdata[9 : 0];
          end

          //Write RWNXAGCRAMP register.
          RWNXAGCRAMP_ADDR_CT : begin
            RAMPDNNDLINDEX          <= regbus_wdata[26 : 24];
            RAMPDNGAPQDB            <= regbus_wdata[23 : 16];
            RAMPUPNDLINDEX          <= regbus_wdata[10 : 8];
            RAMPUPGAPQDB            <= regbus_wdata[7 : 0];
          end

          //Write RWNXAGCSTABDIS register.
          RWNXAGCSTABDIS_ADDR_CT : begin
            ADCPOWDISNDL            <= regbus_wdata[27 : 24];
            ADCPOWDISTHRDBV         <= regbus_wdata[22 : 16];
            PLATNDLINDEX            <= regbus_wdata[10 : 8];
            PLATDPQDB               <= regbus_wdata[4 : 0];
          end

          //Write RWNXAGCDCCOMP0 register.
          RWNXAGCDCCOMP0_ADDR_CT : begin
            DCDSSSTYPE              <= regbus_wdata[29 : 28];
            DCCENTEREDTYPE          <= regbus_wdata[25 : 24];
            DCAGC20TYPE             <= regbus_wdata[21 : 20];
            DCADCTYPE               <= regbus_wdata[17 : 16];
            DCADCHOLDTIME50NS       <= regbus_wdata[14 : 8];
            DCADCZEROTIME50NS       <= regbus_wdata[6 : 0];
          end

          //Write RWNXAGCDCCOMP1 register.
          RWNXAGCDCCOMP1_ADDR_CT : begin
            DCCENTEREDHOLDTIME50NS  <= regbus_wdata[30 : 24];
            DCCENTEREDZEROTIME50NS  <= regbus_wdata[22 : 16];
            DCAGC20HOLDTIME50NS     <= regbus_wdata[14 : 8];
            DCAGC20ZEROTIME50NS     <= regbus_wdata[6 : 0];
          end

          //Write RWNXAGCDCCOMP2 register.
          RWNXAGCDCCOMP2_ADDR_CT : begin
            DCDSSSHOLDTIME50NS      <= regbus_wdata[30 : 24];
            DCDSSSZEROTIME50NS      <= regbus_wdata[22 : 16];
            DELDCSTABLECC           <= regbus_wdata[6 : 0];
          end

          //Write RWNXAGCEVT0 register.
          RWNXAGCEVT0_ADDR_CT : begin
            EVT0OP1                 <= regbus_wdata[31 : 26];
            EVT0OP2                 <= regbus_wdata[25 : 20];
            EVT0OP3                 <= regbus_wdata[19 : 14];
            EVT0PATHCOMB            <= regbus_wdata[13];
            EVT0OPCOMB              <= regbus_wdata[12 : 10];
            EVT0TGTADD              <= regbus_wdata[8 : 0];
          end

          //Write RWNXAGCEVT1 register.
          RWNXAGCEVT1_ADDR_CT : begin
            EVT1OP1                 <= regbus_wdata[31 : 26];
            EVT1OP2                 <= regbus_wdata[25 : 20];
            EVT1OP3                 <= regbus_wdata[19 : 14];
            EVT1PATHCOMB            <= regbus_wdata[13];
            EVT1OPCOMB              <= regbus_wdata[12 : 10];
            EVT1TGTADD              <= regbus_wdata[8 : 0];
          end

          //Write RWNXAGCEVT2 register.
          RWNXAGCEVT2_ADDR_CT : begin
            EVT2OP1                 <= regbus_wdata[31 : 26];
            EVT2OP2                 <= regbus_wdata[25 : 20];
            EVT2OP3                 <= regbus_wdata[19 : 14];
            EVT2PATHCOMB            <= regbus_wdata[13];
            EVT2OPCOMB              <= regbus_wdata[12 : 10];
            EVT2TGTADD              <= regbus_wdata[8 : 0];
          end

          //Write RWNXAGCEVT3 register.
          RWNXAGCEVT3_ADDR_CT : begin
            EVT3OP1                 <= regbus_wdata[31 : 26];
            EVT3OP2                 <= regbus_wdata[25 : 20];
            EVT3OP3                 <= regbus_wdata[19 : 14];
            EVT3PATHCOMB            <= regbus_wdata[13];
            EVT3OPCOMB              <= regbus_wdata[12 : 10];
            EVT3TGTADD              <= regbus_wdata[8 : 0];
          end

          //Write RWNXAGCCNTL register.
          RWNXAGCCNTL_ADDR_CT : begin
            HTSTFGAINEN             <= regbus_wdata[16];
            AGCFSMRESET             <= regbus_wdata[12];
            RADARDETEN              <= regbus_wdata[11];
            RIFSDETEN               <= regbus_wdata[10];
            DSSSONLY                <= regbus_wdata[9];
            OFDMONLY                <= regbus_wdata[8];
            GPSTATUS                <= regbus_wdata[7 : 4];
            COMBPATHSEL             <= regbus_wdata[1 : 0];
          end

          //Write RWNXAGCDSP0 register.
          RWNXAGCDSP0_ADDR_CT : begin
            NBITADC                 <= regbus_wdata[27 : 24];
            VPEAKADCQDBV            <= regbus_wdata[23 : 16];
            ADCPOWMINDBV            <= regbus_wdata[15 : 8];
            ADCPOWBIASQDBV          <= regbus_wdata[7 : 0];
          end

          //Write RWNXAGCDSP1 register.
          RWNXAGCDSP1_ADDR_CT : begin
            ADCPOWMINDBM            <= regbus_wdata[15 : 8];
            ADCPOWBIASQDBM          <= regbus_wdata[7 : 0];
          end

          //Write RWNXAGCDSP2 register.
          RWNXAGCDSP2_ADDR_CT : begin
            INBDPOW40SBIASQDB       <= regbus_wdata[23 : 16];
            INBDPOW20SBIASQDB       <= regbus_wdata[15 : 8];
            INBDPOW20PBIASQDB       <= regbus_wdata[7 : 0];
          end

          //Write RWNXAGCDSP3 register.
          RWNXAGCDSP3_ADDR_CT : begin
            INBDPOWMINDBV           <= regbus_wdata[27 : 20];
            INBDRND                 <= regbus_wdata[17 : 16];
            INBDPOWMINDBM           <= regbus_wdata[7 : 0];
          end

          //Write RWNXAGCDSP4 register.
          RWNXAGCDSP4_ADDR_CT : begin
            FE40GAIN                <= regbus_wdata[15 : 8];
            FE20GAIN                <= regbus_wdata[7 : 0];
          end

          //Write RWNXAGCCCA0 register.
          RWNXAGCCCA0_ADDR_CT : begin
            DELCCARAMPDNTAP         <= regbus_wdata[22 : 20];
            DELCCARAMPUPTAP         <= regbus_wdata[18 : 16];
            CCADETRAMPDN            <= regbus_wdata[13 : 8];
            CCADETRAMPUP            <= regbus_wdata[5 : 0];
          end

          //Write RWNXAGCCCA1 register.
          RWNXAGCCCA1_ADDR_CT : begin
            INBDCCA20PPOWMINDBM     <= regbus_wdata[28 : 20];
            CCA20PFALLTHRDBM        <= regbus_wdata[19 : 12];
            DISCCAEN                <= regbus_wdata[9];
            SATCCAEN                <= regbus_wdata[8];
            CCA20PRISETHRDBM        <= regbus_wdata[7 : 0];
          end

          //Write RWNXAGCCCACTRL register.
          RWNXAGCCCACTRL_ADDR_CT : begin
            CCAFLAG3CTRL            <= regbus_wdata[31 : 28];
            CCAFLAG2CTRL            <= regbus_wdata[27 : 24];
            CCAFLAG1CTRL            <= regbus_wdata[23 : 20];
            CCAFLAG0CTRL            <= regbus_wdata[19 : 16];
            ANTSELCCA40S            <= regbus_wdata[15 : 14];
            ANTSELCCA20S            <= regbus_wdata[13 : 12];
            CCADEMOD                <= regbus_wdata[9];
            CCACSEN                 <= regbus_wdata[8];
            CCARAMPUDEN             <= regbus_wdata[6 : 4];
            CCAENERGYEN             <= regbus_wdata[2 : 0];
          end

          //Write RWNXAGCCCASTATE0 register.
          RWNXAGCCCASTATE0_ADDR_CT : begin
            RXSTATECCA20SSEL        <= regbus_wdata[26 : 16];
            RXSTATECCA20PSEL        <= regbus_wdata[10 : 0];
          end

          //Write RWNXAGCCCASTATE1 register.
          RWNXAGCCCASTATE1_ADDR_CT : begin
            RXSTATECCA40SSEL        <= regbus_wdata[10 : 0];
          end

          //Write RWNXAGCCCATIMEOUT register.
          RWNXAGCCCATIMEOUT_ADDR_CT : begin
            CCATIMEOUT              <= regbus_wdata[31 : 0];
          end

          //Write RWNXAGCCOMP0 register.
          RWNXAGCCOMP0_ADDR_CT : begin
            IDINBDPOWGAPDNQDBM      <= regbus_wdata[31 : 24];
            IDINBDPOWGAPUPQDBM      <= regbus_wdata[23 : 16];
            INBDPOWINFTHRDBM        <= regbus_wdata[15 : 8];
            INBDPOWSUPTHRDBM        <= regbus_wdata[7 : 0];
          end

          //Write RWNXAGCCOMP1 register.
          RWNXAGCCOMP1_ADDR_CT : begin
            ADCPOWINFTHRDBV         <= regbus_wdata[31 : 24];
            ADCPOWSUPTHRDBV         <= regbus_wdata[23 : 16];
            ADCPOWINFTHRDBM         <= regbus_wdata[15 : 8];
            ADCPOWSUPTHRDBM         <= regbus_wdata[7 : 0];
          end
`ifdef RW_RADAR_EN                    

          //Write RWNXAGCRADAR register.
          RWNXAGCRADAR_ADDR_CT : begin
            ANTSELRADAR             <= regbus_wdata[29 : 28];
            FREQSINGGAP             <= regbus_wdata[27 : 24];
            FREQSING                <= regbus_wdata[23 : 16];
            FOMSINGGAP              <= regbus_wdata[11 : 8];
            FOMSING                 <= regbus_wdata[7 : 0];
          end

          //Write RWNXAGCRADARTIM register.
          RWNXAGCRADARTIM_ADDR_CT : begin
            PULSETIMERCLEAR         <= regbus_wdata[31];
            PULSEIRQFIFOTHR         <= regbus_wdata[18 : 16];
            PULSEIRQTIMEOUT         <= regbus_wdata[7 : 0];
          end

          //Write RWNXAGCDCCOMPRADAR register.
          RWNXAGCDCCOMPRADAR_ADDR_CT : begin
            DCRADARTYPE             <= regbus_wdata[29 : 28];
            DCRADARHOLDTIME50NS     <= regbus_wdata[22 : 16];
            DCRADARZEROTIME50NS     <= regbus_wdata[14 : 8];
          end
`endif // RW_RADAR_EN                    

          //Write RWNXAGCCCA2 register.
          RWNXAGCCCA2_ADDR_CT : begin
            INBDCCA20SPOWMINDBM     <= regbus_wdata[28 : 20];
            CCA20SFALLTHRDBM        <= regbus_wdata[19 : 12];
            CCA20SRISETHRDBM        <= regbus_wdata[7 : 0];
          end

          //Write RWNXAGCCCA3 register.
          RWNXAGCCCA3_ADDR_CT : begin
            INBDCCA40SPOWMINDBM     <= regbus_wdata[28 : 20];
            CCA40SFALLTHRDBM        <= regbus_wdata[19 : 12];
            CCA40SRISETHRDBM        <= regbus_wdata[7 : 0];
          end

          //Write RWNXMACINTEN register.
          RWNXMACINTEN_ADDR_CT : begin
            IRQMACRADARDETEN        <= regbus_wdata[12];
            IRQMACCCATIMEOUTEN      <= regbus_wdata[8];
          end

          //Write RWNXMACINTACK register.
          RWNXMACINTACK_ADDR_CT : begin
            IRQMACRADARDETACK       <= regbus_wdata[12];
            IRQMACCCATIMEOUTACK     <= regbus_wdata[8];
          end

          //Write RWNXMACINTGEN register.
          RWNXMACINTGEN_ADDR_CT : begin
            IRQMACRADARDETGEN       <= regbus_wdata[12];
            IRQMACCCATIMEOUTGEN     <= regbus_wdata[8];
          end
`ifdef RW_NX_DERIV_80211B             

          //Write RWNXFEDSSSCCKCNTL register.
          RWNXFEDSSSCCKCNTL_ADDR_CT : begin
            RXSHIFT4044             <= regbus_wdata[18 : 16];
            TXSHIFT4044             <= regbus_wdata[13 : 12];
            BRXPATHSELREG           <= regbus_wdata[6 : 5];
            RXPATHSELFROMREG        <= regbus_wdata[4];
          end
`endif // RW_NX_DERIV_80211B             

          
          // Disable coverage on the default state because it cannot be reached.
          // pragma coverage block = off 
          default : begin

          end
          // pragma coverage block = on 
        endcase
      end
      else begin

`ifdef RW_NX_IQ_COMP_EN               
        IQESTITERCLR            <= 1'b0;
`endif // RW_NX_IQ_COMP_EN               
`ifdef RW_NX_FIQ_COMP_EN              
        FIQESTSTART             <= 1'b0;
        FIQCOLLSTART            <= 1'b0;
`endif // RW_NX_FIQ_COMP_EN              
`ifdef RW_RADAR_EN                    
`endif // RW_RADAR_EN                    
`ifdef RW_NX_IQ_COMP_EN               
`endif // RW_NX_IQ_COMP_EN               
`ifdef RW_NX_FIQ_COMP_EN              
`endif // RW_NX_FIQ_COMP_EN              
`ifdef RW_NX_AGC_SNR_EN               
`endif // RW_NX_AGC_SNR_EN               
`ifdef RW_RADAR_EN                    
        PULSETIMERCLEAR         <= 1'b0;
`endif // RW_RADAR_EN                    
        IRQMACRADARDETACK       <= 1'b0;
        IRQMACCCATIMEOUTACK     <= 1'b0;
        IRQMACRADARDETGEN       <= 1'b0;
        IRQMACCCATIMEOUTGEN     <= 1'b0;
`ifdef RW_NX_DERIV_80211B             
`endif // RW_NX_DERIV_80211B             
      end
    end
  end
        
  //////////////////////////////////////////////////////////////////////////////
  // Registers read
  //////////////////////////////////////////////////////////////////////////////
  
  
  
  //Read_p: 
  
  always @*
  begin

    regbus_rdata      = 32'b0;
    if (regbus_sel && regbus_rden)
    begin

        case(regbus_addr [10:2])

        //Read RWNXVERSION register.
        RWNXVERSION_ADDR_CT : begin
          regbus_rdata[31 : 24]       = RESERVED;
          regbus_rdata[23 : 22]       = AGCRAMMODE;
          regbus_rdata[21]            = IQCOMP;
          regbus_rdata[20]            = DSSSCORR;
          regbus_rdata[19]            = FIQCOMP;
          regbus_rdata[18]            = AGCSNR;
          regbus_rdata[16]            = RADAR;
          regbus_rdata[14]            = DSSSCCK;
          regbus_rdata[13 : 12]       = CHBW;
          regbus_rdata[11 : 8]        = NSS;
          regbus_rdata[7 : 4]         = NTX;
          regbus_rdata[3 : 0]         = NRX;
        end

        //Read RWNXSTATICCONFIG register.
        RWNXSTATICCONFIG_ADDR_CT : begin
          regbus_rdata[1 : 0]         = ACTIVEANT;
        end

        //Read RWNXDYNAMICCONFIG register.
        RWNXDYNAMICCONFIG_ADDR_CT : begin
          regbus_rdata[16]            = AGCINBDPOWSTARTCAPTURE;
        end

        //Read RWNXIQCTRL register.
        RWNXIQCTRL_ADDR_CT : begin
          regbus_rdata[28]            = TXIQSWAPPATH1;
          regbus_rdata[27]            = TXIQSWAPPATH0;
          regbus_rdata[23]            = RXIQSWAPPATH1;
          regbus_rdata[22]            = RXIQSWAPPATH0;
          regbus_rdata[15]            = TXIQDELPATHQ1;
          regbus_rdata[14]            = TXIQDELPATHI1;
          regbus_rdata[13]            = TXIQDELPATHQ0;
          regbus_rdata[12]            = TXIQDELPATHI0;
          regbus_rdata[5]             = RXIQDELPATHQ1;
          regbus_rdata[4]             = RXIQDELPATHI1;
          regbus_rdata[3]             = RXIQDELPATHQ0;
          regbus_rdata[2]             = RXIQDELPATHI0;
          regbus_rdata[1]             = TXC2SDISBCFG;
          regbus_rdata[0]             = RXC2SDISBCFG;
        end

        //Read RWNXMACSTATICCONFIG register.
        RWNXMACSTATICCONFIG_ADDR_CT : begin
          regbus_rdata[1 : 0]         = PSSELECT;
        end

        //Read RWNXFECTRL0 register.
        RWNXFECTRL0_ADDR_CT : begin
          regbus_rdata[22 : 16]       = TX80DIGGAINLIN0;
          regbus_rdata[14 : 8]        = TX40DIGGAINLIN0;
          regbus_rdata[6 : 0]         = TX20DIGGAINLIN0;
        end

        //Read RWNXFECTRL1 register.
        RWNXFECTRL1_ADDR_CT : begin
          regbus_rdata[22 : 16]       = TX80DIGGAINLIN1;
          regbus_rdata[14 : 8]        = TX40DIGGAINLIN1;
          regbus_rdata[6 : 0]         = TX20DIGGAINLIN1;
        end
`ifdef RW_NX_IQ_COMP_EN               

        //Read RWNXFETXIQCOMP0 register.
        RWNXFETXIQCOMP0_ADDR_CT : begin
          regbus_rdata[29]            = TXIQPHASECOMPEN0;
          regbus_rdata[28]            = TXIQGAINCOMPEN0;
          regbus_rdata[24 : 16]       = TXIQPHASE0;
          regbus_rdata[10 : 0]        = TXIQGAIN0;
        end

        //Read RWNXFETXIQCOMP1 register.
        RWNXFETXIQCOMP1_ADDR_CT : begin
          regbus_rdata[29]            = TXIQPHASECOMPEN1;
          regbus_rdata[28]            = TXIQGAINCOMPEN1;
          regbus_rdata[24 : 16]       = TXIQPHASE1;
          regbus_rdata[10 : 0]        = TXIQGAIN1;
        end

        //Read RWNXFERXIQESTCTRL register.
        RWNXFERXIQESTCTRL_ADDR_CT : begin
          regbus_rdata[31 : 24]       = IQESTFOMIN;
          regbus_rdata[22 : 20]       = IQESTBWLIST;
          regbus_rdata[15 : 12]       = IQESTMCSMIN;
          regbus_rdata[11 : 4]        = IQESTSNRMIN;
          regbus_rdata[3]             = RXIQPHASEESTEN;
          regbus_rdata[2]             = RXIQGAINESTEN;
          regbus_rdata[1]             = RXIQPHASECOMPEN;
          regbus_rdata[0]             = RXIQGAINCOMPEN;
        end

        //Read RWNXFERXIQESTLOOP register.
        RWNXFERXIQESTLOOP_ADDR_CT : begin
          regbus_rdata[30 : 28]       = RXIQESTSTEP4;
          regbus_rdata[27 : 25]       = RXIQESTSTEP3;
          regbus_rdata[24 : 22]       = RXIQESTSTEP2;
          regbus_rdata[21 : 19]       = RXIQESTSTEP1;
          regbus_rdata[18 : 16]       = RXIQESTSTEP0;
          regbus_rdata[15 : 13]       = RXIQESTPHASESTEPSTOP;
          regbus_rdata[12 : 10]       = RXIQESTPHASESTEPINIT;
          regbus_rdata[9 : 7]         = RXIQESTGAINSTEPSTOP;
          regbus_rdata[6 : 4]         = RXIQESTGAINSTEPINIT;
          regbus_rdata[2 : 0]         = RXIQESTDEL;
        end

        //Read RWNXFERXIQESTCLR register.
        RWNXFERXIQESTCLR_ADDR_CT : begin
          regbus_rdata[0]             = statusIQESTITERCLR;
        end

        //Read RWNXFERXIQCOMP0 register.
        RWNXFERXIQCOMP0_ADDR_CT : begin
          regbus_rdata[24 : 16]       = RXIQPHASE0;
          regbus_rdata[10 : 0]        = RXIQGAIN0;
        end

        //Read RWNXFERXIQCOMP1 register.
        RWNXFERXIQCOMP1_ADDR_CT : begin
          regbus_rdata[24 : 16]       = RXIQPHASE1;
          regbus_rdata[10 : 0]        = RXIQGAIN1;
        end
`endif // RW_NX_IQ_COMP_EN               
`ifdef RW_NX_FIQ_COMP_EN              

        //Read RWNXFEFIQCTRL register.
        RWNXFEFIQCTRL_ADDR_CT : begin
          regbus_rdata[12]            = FIQPATHSEL;
          regbus_rdata[8]             = FIQTXRX;
          regbus_rdata[2]             = FIQRXBYPASS;
          regbus_rdata[1]             = FIQTXBYPASS;
          regbus_rdata[0]             = FIQCALEN;
        end

        //Read RWNXFEFIQCOLL register.
        RWNXFEFIQCOLL_ADDR_CT : begin
          regbus_rdata[31 : 24]       = FIQCOLLWROFFSET;
          regbus_rdata[23 : 16]       = FIQCOLLRDOFFSET;
          regbus_rdata[15 : 8]        = FIQCOLLSIZE;
          regbus_rdata[0]             = FIQCOLLPATH;
        end

        //Read RWNXFEFIQEST0 register.
        RWNXFEFIQEST0_ADDR_CT : begin
          regbus_rdata[31 : 24]       = FIQESTQOFFSET;
          regbus_rdata[23 : 16]       = FIQESTIOFFSET;
          regbus_rdata[7 : 0]         = FIQESTSIZE;
        end

        //Read RWNXFEFIQEST1 register.
        RWNXFEFIQEST1_ADDR_CT : begin
          regbus_rdata[19 : 16]       = FIQESTSTEP;
          regbus_rdata[15 : 0]        = FIQESTNITE;
        end

        //Read RWNXFEFIQDEL register.
        RWNXFEFIQDEL_ADDR_CT : begin
          regbus_rdata[28 : 24]       = FIQRXDEL;
          regbus_rdata[20 : 16]       = FIQTXDEL;
          regbus_rdata[7 : 0]         = FIQCOLLDEL;
        end

        //Read RWNXFEFIQCOEFF0 register.
        RWNXFEFIQCOEFF0_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF0;
        end

        //Read RWNXFEFIQCOEFF1 register.
        RWNXFEFIQCOEFF1_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF1;
        end

        //Read RWNXFEFIQCOEFF2 register.
        RWNXFEFIQCOEFF2_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF2;
        end

        //Read RWNXFEFIQCOEFF3 register.
        RWNXFEFIQCOEFF3_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF3;
        end

        //Read RWNXFEFIQCOEFF4 register.
        RWNXFEFIQCOEFF4_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF4;
        end

        //Read RWNXFEFIQCOEFF5 register.
        RWNXFEFIQCOEFF5_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF5;
        end

        //Read RWNXFEFIQCOEFF6 register.
        RWNXFEFIQCOEFF6_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF6;
        end

        //Read RWNXFEFIQCOEFF7 register.
        RWNXFEFIQCOEFF7_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF7;
        end

        //Read RWNXFEFIQCOEFF8 register.
        RWNXFEFIQCOEFF8_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF8;
        end

        //Read RWNXFEFIQCOEFF9 register.
        RWNXFEFIQCOEFF9_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF9;
        end

        //Read RWNXFEFIQCOEFF10 register.
        RWNXFEFIQCOEFF10_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF10;
        end

        //Read RWNXFEFIQCOEFF11 register.
        RWNXFEFIQCOEFF11_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF11;
        end

        //Read RWNXFEFIQCOEFF12 register.
        RWNXFEFIQCOEFF12_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF12;
        end

        //Read RWNXFEFIQCOEFF13 register.
        RWNXFEFIQCOEFF13_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF13;
        end

        //Read RWNXFEFIQCOEFF14 register.
        RWNXFEFIQCOEFF14_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF14;
        end

        //Read RWNXFEFIQCOEFF15 register.
        RWNXFEFIQCOEFF15_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF15;
        end

        //Read RWNXFEFIQCOEFF16 register.
        RWNXFEFIQCOEFF16_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF16;
        end

        //Read RWNXFEFIQCOEFF17 register.
        RWNXFEFIQCOEFF17_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF17;
        end

        //Read RWNXFEFIQCOEFF18 register.
        RWNXFEFIQCOEFF18_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF18;
        end

        //Read RWNXFEFIQCOEFF19 register.
        RWNXFEFIQCOEFF19_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQCOEFF19;
        end

        //Read RWNXFEFIQCOEFFUPDATE register.
        RWNXFEFIQCOEFFUPDATE_ADDR_CT : begin
          regbus_rdata[0]             = FIQCOEFFUPDATE;
        end

        //Read RWNXFEFIQCOEFFREQ register.
        RWNXFEFIQCOEFFREQ_ADDR_CT : begin
          regbus_rdata[0]             = FIQCOEFFREQ;
        end

        //Read RWNXFEFIQSTART register.
        RWNXFEFIQSTART_ADDR_CT : begin
          regbus_rdata[16]            = statusFIQESTSTART;
          regbus_rdata[0]             = statusFIQCOLLSTART;
        end
`endif // RW_NX_FIQ_COMP_EN              

        //Read AGCGAINSTAT register.
        AGCGAINSTAT_ADDR_CT : begin
          regbus_rdata[15 : 8]        = AGCGAIN1;
          regbus_rdata[7 : 0]         = AGCGAIN0;
        end

        //Read AGCADCPOWSTAT register.
        AGCADCPOWSTAT_ADDR_CT : begin
          regbus_rdata[14 : 8]        = ADCPOWDBV1;
          regbus_rdata[6 : 0]         = ADCPOWDBV0;
        end

        //Read AGCINBDPOW20PSTAT register.
        AGCINBDPOW20PSTAT_ADDR_CT : begin
          regbus_rdata[15 : 8]        = INBDPOW20PDBM1;
          regbus_rdata[7 : 0]         = INBDPOW20PDBM0;
        end

        //Read AGCDIGGAIN0STAT register.
        AGCDIGGAIN0STAT_ADDR_CT : begin
          regbus_rdata[22 : 16]       = DIGGAIN80ANT0;
          regbus_rdata[14 : 8]        = DIGGAIN40ANT0;
          regbus_rdata[6 : 0]         = DIGGAIN20ANT0;
        end

        //Read AGCDIGGAIN1STAT register.
        AGCDIGGAIN1STAT_ADDR_CT : begin
          regbus_rdata[22 : 16]       = DIGGAIN80ANT1;
          regbus_rdata[14 : 8]        = DIGGAIN40ANT1;
          regbus_rdata[6 : 0]         = DIGGAIN20ANT1;
        end
`ifdef RW_RADAR_EN                    

        //Read RADARFIFOSTAT register.
        RADARFIFOSTAT_ADDR_CT : begin
          regbus_rdata[0]             = RADFIFOEMPTY;
        end
`endif // RW_RADAR_EN                    

        //Read AGCINBDPOW20PNOISESTAT register.
        AGCINBDPOW20PNOISESTAT_ADDR_CT : begin
          regbus_rdata[15 : 8]        = INBDPOW20PNOISEDBM1;
          regbus_rdata[7 : 0]         = INBDPOW20PNOISEDBM0;
        end

        //Read AGCINBDPOWSECSTAT register.
        AGCINBDPOWSECSTAT_ADDR_CT : begin
          regbus_rdata[23 : 16]       = INBDPOW40SDBM;
          regbus_rdata[7 : 0]         = INBDPOW20SDBM;
        end

        //Read AGCINBDPOWSECNOISESTAT register.
        AGCINBDPOWSECNOISESTAT_ADDR_CT : begin
          regbus_rdata[23 : 16]       = INBDPOW40SNOISEDBM;
          regbus_rdata[7 : 0]         = INBDPOW20SNOISEDBM;
        end
`ifdef RW_NX_IQ_COMP_EN               

        //Read RWNXFERXIQSTATVARI0 register.
        RWNXFERXIQSTATVARI0_ADDR_CT : begin
          regbus_rdata[21 : 0]        = RXIQVARI0;
        end

        //Read RWNXFERXIQSTATVARQ0 register.
        RWNXFERXIQSTATVARQ0_ADDR_CT : begin
          regbus_rdata[21 : 0]        = RXIQVARQ0;
        end

        //Read RWNXFERXIQSTATMIQ0 register.
        RWNXFERXIQSTATMIQ0_ADDR_CT : begin
          regbus_rdata[22 : 0]        = RXIQSTATMIQ0;
        end

        //Read RWNXFERXIQSTAT0 register.
        RWNXFERXIQSTAT0_ADDR_CT : begin
          regbus_rdata[24 : 16]       = RXIQSTATPHASE0;
          regbus_rdata[10 : 0]        = RXIQSTATGAIN0;
        end

        //Read RWNXFERXIQSTATVARI1 register.
        RWNXFERXIQSTATVARI1_ADDR_CT : begin
          regbus_rdata[21 : 0]        = RXIQVARI1;
        end

        //Read RWNXFERXIQSTATVARQ1 register.
        RWNXFERXIQSTATVARQ1_ADDR_CT : begin
          regbus_rdata[21 : 0]        = RXIQVARQ1;
        end

        //Read RWNXFERXIQSTATMIQ1 register.
        RWNXFERXIQSTATMIQ1_ADDR_CT : begin
          regbus_rdata[22 : 0]        = RXIQSTATMIQ1;
        end

        //Read RWNXFERXIQSTAT1 register.
        RWNXFERXIQSTAT1_ADDR_CT : begin
          regbus_rdata[24 : 16]       = RXIQSTATPHASE1;
          regbus_rdata[10 : 0]        = RXIQSTATGAIN1;
        end
`endif // RW_NX_IQ_COMP_EN               
`ifdef RW_NX_FIQ_COMP_EN              

        //Read RWNXFEFIQDONE register.
        RWNXFEFIQDONE_ADDR_CT : begin
          regbus_rdata[16]            = FIQESTDONE;
          regbus_rdata[0]             = FIQCOLLDONE;
        end

        //Read RWNXFEFIQSTAT0 register.
        RWNXFEFIQSTAT0_ADDR_CT : begin
          regbus_rdata[28 : 16]       = FIQTXESTERROR0;
          regbus_rdata[12 : 0]        = FIQRXESTERROR0;
        end

        //Read RWNXFEFIQSTAT1 register.
        RWNXFEFIQSTAT1_ADDR_CT : begin
          regbus_rdata[28 : 16]       = FIQTXESTERROR1;
          regbus_rdata[12 : 0]        = FIQRXESTERROR1;
        end

        //Read RWNXFEFIQSTATCOEFF0 register.
        RWNXFEFIQSTATCOEFF0_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF0;
        end

        //Read RWNXFEFIQSTATCOEFF1 register.
        RWNXFEFIQSTATCOEFF1_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF1;
        end

        //Read RWNXFEFIQSTATCOEFF2 register.
        RWNXFEFIQSTATCOEFF2_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF2;
        end

        //Read RWNXFEFIQSTATCOEFF3 register.
        RWNXFEFIQSTATCOEFF3_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF3;
        end

        //Read RWNXFEFIQSTATCOEFF4 register.
        RWNXFEFIQSTATCOEFF4_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF4;
        end

        //Read RWNXFEFIQSTATCOEFF5 register.
        RWNXFEFIQSTATCOEFF5_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF5;
        end

        //Read RWNXFEFIQSTATCOEFF6 register.
        RWNXFEFIQSTATCOEFF6_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF6;
        end

        //Read RWNXFEFIQSTATCOEFF7 register.
        RWNXFEFIQSTATCOEFF7_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF7;
        end

        //Read RWNXFEFIQSTATCOEFF8 register.
        RWNXFEFIQSTATCOEFF8_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF8;
        end

        //Read RWNXFEFIQSTATCOEFF9 register.
        RWNXFEFIQSTATCOEFF9_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF9;
        end

        //Read RWNXFEFIQSTATCOEFF10 register.
        RWNXFEFIQSTATCOEFF10_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF10;
        end

        //Read RWNXFEFIQSTATCOEFF11 register.
        RWNXFEFIQSTATCOEFF11_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF11;
        end

        //Read RWNXFEFIQSTATCOEFF12 register.
        RWNXFEFIQSTATCOEFF12_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF12;
        end

        //Read RWNXFEFIQSTATCOEFF13 register.
        RWNXFEFIQSTATCOEFF13_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF13;
        end

        //Read RWNXFEFIQSTATCOEFF14 register.
        RWNXFEFIQSTATCOEFF14_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF14;
        end

        //Read RWNXFEFIQSTATCOEFF15 register.
        RWNXFEFIQSTATCOEFF15_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF15;
        end

        //Read RWNXFEFIQSTATCOEFF16 register.
        RWNXFEFIQSTATCOEFF16_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF16;
        end

        //Read RWNXFEFIQSTATCOEFF17 register.
        RWNXFEFIQSTATCOEFF17_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF17;
        end

        //Read RWNXFEFIQSTATCOEFF18 register.
        RWNXFEFIQSTATCOEFF18_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF18;
        end

        //Read RWNXFEFIQSTATCOEFF19 register.
        RWNXFEFIQSTATCOEFF19_ADDR_CT : begin
          regbus_rdata[15 : 0]        = FIQSTATCOEFF19;
        end
`endif // RW_NX_FIQ_COMP_EN              

        //Read RWNXAGCANTLOSS register.
        RWNXAGCANTLOSS_ADDR_CT : begin
          regbus_rdata[11 : 8]        = RFLOSSANT1DB;
          regbus_rdata[3 : 0]         = RFLOSSANT0DB;
        end

        //Read RWNXAGCGAINRANGE register.
        RWNXAGCGAINRANGE_ADDR_CT : begin
          regbus_rdata[30 : 24]       = RFGAINMAX4DETDB;
          regbus_rdata[22 : 16]       = RFGAINMIN4DETDB;
          regbus_rdata[14 : 8]        = RFGAINMAXDB;
          regbus_rdata[6 : 0]         = RFGAINMINDB;
        end

        //Read RWNXAGCDIGGAINCONF register.
        RWNXAGCDIGGAINCONF_ADDR_CT : begin
          regbus_rdata[19 : 16]       = DIGGAIN80VS20;
          regbus_rdata[3 : 0]         = DIGGAIN40VS20;
        end
`ifdef RW_NX_AGC_SNR_EN               

        //Read RWNXAGCNOISECONF register.
        RWNXAGCNOISECONF_ADDR_CT : begin
          regbus_rdata[16]            = SNRMEASSEL;
        end
`endif // RW_NX_AGC_SNR_EN               

        //Read RWNXAGCACI20MARG0 register.
        RWNXAGCACI20MARG0_ADDR_CT : begin
          regbus_rdata[29 : 24]       = ACI20MARGMCS3;
          regbus_rdata[21 : 16]       = ACI20MARGMCS2;
          regbus_rdata[13 : 8]        = ACI20MARGMCS1;
          regbus_rdata[5 : 0]         = ACI20MARGMCS0;
        end

        //Read RWNXAGCACI20MARG1 register.
        RWNXAGCACI20MARG1_ADDR_CT : begin
          regbus_rdata[29 : 24]       = ACI20MARGMCS7;
          regbus_rdata[21 : 16]       = ACI20MARGMCS6;
          regbus_rdata[13 : 8]        = ACI20MARGMCS5;
          regbus_rdata[5 : 0]         = ACI20MARGMCS4;
        end

        //Read RWNXAGCACI20MARG2 register.
        RWNXAGCACI20MARG2_ADDR_CT : begin
          regbus_rdata[13 : 8]        = ACI20MARGMCS9;
          regbus_rdata[5 : 0]         = ACI20MARGMCS8;
        end

        //Read RWNXAGCACI40MARG0 register.
        RWNXAGCACI40MARG0_ADDR_CT : begin
          regbus_rdata[29 : 24]       = ACI40MARGMCS3;
          regbus_rdata[21 : 16]       = ACI40MARGMCS2;
          regbus_rdata[13 : 8]        = ACI40MARGMCS1;
          regbus_rdata[5 : 0]         = ACI40MARGMCS0;
        end

        //Read RWNXAGCACI40MARG1 register.
        RWNXAGCACI40MARG1_ADDR_CT : begin
          regbus_rdata[29 : 24]       = ACI40MARGMCS7;
          regbus_rdata[21 : 16]       = ACI40MARGMCS6;
          regbus_rdata[13 : 8]        = ACI40MARGMCS5;
          regbus_rdata[5 : 0]         = ACI40MARGMCS4;
        end

        //Read RWNXAGCACI40MARG2 register.
        RWNXAGCACI40MARG2_ADDR_CT : begin
          regbus_rdata[13 : 8]        = ACI40MARGMCS9;
          regbus_rdata[5 : 0]         = ACI40MARGMCS8;
        end

        //Read RWNXAGCACI80MARG0 register.
        RWNXAGCACI80MARG0_ADDR_CT : begin
          regbus_rdata[29 : 24]       = ACI80MARGMCS3;
          regbus_rdata[21 : 16]       = ACI80MARGMCS2;
          regbus_rdata[13 : 8]        = ACI80MARGMCS1;
          regbus_rdata[5 : 0]         = ACI80MARGMCS0;
        end

        //Read RWNXAGCACI80MARG1 register.
        RWNXAGCACI80MARG1_ADDR_CT : begin
          regbus_rdata[29 : 24]       = ACI80MARGMCS7;
          regbus_rdata[21 : 16]       = ACI80MARGMCS6;
          regbus_rdata[13 : 8]        = ACI80MARGMCS5;
          regbus_rdata[5 : 0]         = ACI80MARGMCS4;
        end

        //Read RWNXAGCACI80MARG2 register.
        RWNXAGCACI80MARG2_ADDR_CT : begin
          regbus_rdata[13 : 8]        = ACI80MARGMCS9;
          regbus_rdata[5 : 0]         = ACI80MARGMCS8;
        end

        //Read RWNXAGCSAT register.
        RWNXAGCSAT_ADDR_CT : begin
          regbus_rdata[28 : 24]       = SATDELAY50NS;
          regbus_rdata[21 : 16]       = SATHIGHTHRDBV;
          regbus_rdata[13 : 8]        = SATLOWTHRDBV;
          regbus_rdata[5 : 0]         = SATTHRDBV;
        end

        //Read RWNXAGCCROSS register.
        RWNXAGCCROSS_ADDR_CT : begin
          regbus_rdata[21 : 12]       = CROSSDNTHRQDBM;
          regbus_rdata[9 : 0]         = CROSSUPTHRQDBM;
        end

        //Read RWNXAGCRAMP register.
        RWNXAGCRAMP_ADDR_CT : begin
          regbus_rdata[26 : 24]       = RAMPDNNDLINDEX;
          regbus_rdata[23 : 16]       = RAMPDNGAPQDB;
          regbus_rdata[10 : 8]        = RAMPUPNDLINDEX;
          regbus_rdata[7 : 0]         = RAMPUPGAPQDB;
        end

        //Read RWNXAGCSTABDIS register.
        RWNXAGCSTABDIS_ADDR_CT : begin
          regbus_rdata[27 : 24]       = ADCPOWDISNDL;
          regbus_rdata[22 : 16]       = ADCPOWDISTHRDBV;
          regbus_rdata[10 : 8]        = PLATNDLINDEX;
          regbus_rdata[4 : 0]         = PLATDPQDB;
        end

        //Read RWNXAGCDCCOMP0 register.
        RWNXAGCDCCOMP0_ADDR_CT : begin
          regbus_rdata[29 : 28]       = DCDSSSTYPE;
          regbus_rdata[25 : 24]       = DCCENTEREDTYPE;
          regbus_rdata[21 : 20]       = DCAGC20TYPE;
          regbus_rdata[17 : 16]       = DCADCTYPE;
          regbus_rdata[14 : 8]        = DCADCHOLDTIME50NS;
          regbus_rdata[6 : 0]         = DCADCZEROTIME50NS;
        end

        //Read RWNXAGCDCCOMP1 register.
        RWNXAGCDCCOMP1_ADDR_CT : begin
          regbus_rdata[30 : 24]       = DCCENTEREDHOLDTIME50NS;
          regbus_rdata[22 : 16]       = DCCENTEREDZEROTIME50NS;
          regbus_rdata[14 : 8]        = DCAGC20HOLDTIME50NS;
          regbus_rdata[6 : 0]         = DCAGC20ZEROTIME50NS;
        end

        //Read RWNXAGCDCCOMP2 register.
        RWNXAGCDCCOMP2_ADDR_CT : begin
          regbus_rdata[30 : 24]       = DCDSSSHOLDTIME50NS;
          regbus_rdata[22 : 16]       = DCDSSSZEROTIME50NS;
          regbus_rdata[6 : 0]         = DELDCSTABLECC;
        end

        //Read RWNXAGCEVT0 register.
        RWNXAGCEVT0_ADDR_CT : begin
          regbus_rdata[31 : 26]       = EVT0OP1;
          regbus_rdata[25 : 20]       = EVT0OP2;
          regbus_rdata[19 : 14]       = EVT0OP3;
          regbus_rdata[13]            = EVT0PATHCOMB;
          regbus_rdata[12 : 10]       = EVT0OPCOMB;
          regbus_rdata[8 : 0]         = EVT0TGTADD;
        end

        //Read RWNXAGCEVT1 register.
        RWNXAGCEVT1_ADDR_CT : begin
          regbus_rdata[31 : 26]       = EVT1OP1;
          regbus_rdata[25 : 20]       = EVT1OP2;
          regbus_rdata[19 : 14]       = EVT1OP3;
          regbus_rdata[13]            = EVT1PATHCOMB;
          regbus_rdata[12 : 10]       = EVT1OPCOMB;
          regbus_rdata[8 : 0]         = EVT1TGTADD;
        end

        //Read RWNXAGCEVT2 register.
        RWNXAGCEVT2_ADDR_CT : begin
          regbus_rdata[31 : 26]       = EVT2OP1;
          regbus_rdata[25 : 20]       = EVT2OP2;
          regbus_rdata[19 : 14]       = EVT2OP3;
          regbus_rdata[13]            = EVT2PATHCOMB;
          regbus_rdata[12 : 10]       = EVT2OPCOMB;
          regbus_rdata[8 : 0]         = EVT2TGTADD;
        end

        //Read RWNXAGCEVT3 register.
        RWNXAGCEVT3_ADDR_CT : begin
          regbus_rdata[31 : 26]       = EVT3OP1;
          regbus_rdata[25 : 20]       = EVT3OP2;
          regbus_rdata[19 : 14]       = EVT3OP3;
          regbus_rdata[13]            = EVT3PATHCOMB;
          regbus_rdata[12 : 10]       = EVT3OPCOMB;
          regbus_rdata[8 : 0]         = EVT3TGTADD;
        end

        //Read RWNXAGCCNTL register.
        RWNXAGCCNTL_ADDR_CT : begin
          regbus_rdata[16]            = HTSTFGAINEN;
          regbus_rdata[12]            = AGCFSMRESET;
          regbus_rdata[11]            = RADARDETEN;
          regbus_rdata[10]            = RIFSDETEN;
          regbus_rdata[9]             = DSSSONLY;
          regbus_rdata[8]             = OFDMONLY;
          regbus_rdata[7 : 4]         = GPSTATUS;
          regbus_rdata[1 : 0]         = COMBPATHSEL;
        end

        //Read RWNXAGCDSP0 register.
        RWNXAGCDSP0_ADDR_CT : begin
          regbus_rdata[27 : 24]       = NBITADC;
          regbus_rdata[23 : 16]       = VPEAKADCQDBV;
          regbus_rdata[15 : 8]        = ADCPOWMINDBV;
          regbus_rdata[7 : 0]         = ADCPOWBIASQDBV;
        end

        //Read RWNXAGCDSP1 register.
        RWNXAGCDSP1_ADDR_CT : begin
          regbus_rdata[15 : 8]        = ADCPOWMINDBM;
          regbus_rdata[7 : 0]         = ADCPOWBIASQDBM;
        end

        //Read RWNXAGCDSP2 register.
        RWNXAGCDSP2_ADDR_CT : begin
          regbus_rdata[23 : 16]       = INBDPOW40SBIASQDB;
          regbus_rdata[15 : 8]        = INBDPOW20SBIASQDB;
          regbus_rdata[7 : 0]         = INBDPOW20PBIASQDB;
        end

        //Read RWNXAGCDSP3 register.
        RWNXAGCDSP3_ADDR_CT : begin
          regbus_rdata[27 : 20]       = INBDPOWMINDBV;
          regbus_rdata[17 : 16]       = INBDRND;
          regbus_rdata[7 : 0]         = INBDPOWMINDBM;
        end

        //Read RWNXAGCDSP4 register.
        RWNXAGCDSP4_ADDR_CT : begin
          regbus_rdata[15 : 8]        = FE40GAIN;
          regbus_rdata[7 : 0]         = FE20GAIN;
        end

        //Read RWNXAGCCCA0 register.
        RWNXAGCCCA0_ADDR_CT : begin
          regbus_rdata[22 : 20]       = DELCCARAMPDNTAP;
          regbus_rdata[18 : 16]       = DELCCARAMPUPTAP;
          regbus_rdata[13 : 8]        = CCADETRAMPDN;
          regbus_rdata[5 : 0]         = CCADETRAMPUP;
        end

        //Read RWNXAGCCCA1 register.
        RWNXAGCCCA1_ADDR_CT : begin
          regbus_rdata[28 : 20]       = INBDCCA20PPOWMINDBM;
          regbus_rdata[19 : 12]       = CCA20PFALLTHRDBM;
          regbus_rdata[9]             = DISCCAEN;
          regbus_rdata[8]             = SATCCAEN;
          regbus_rdata[7 : 0]         = CCA20PRISETHRDBM;
        end

        //Read RWNXAGCCCACTRL register.
        RWNXAGCCCACTRL_ADDR_CT : begin
          regbus_rdata[31 : 28]       = CCAFLAG3CTRL;
          regbus_rdata[27 : 24]       = CCAFLAG2CTRL;
          regbus_rdata[23 : 20]       = CCAFLAG1CTRL;
          regbus_rdata[19 : 16]       = CCAFLAG0CTRL;
          regbus_rdata[15 : 14]       = ANTSELCCA40S;
          regbus_rdata[13 : 12]       = ANTSELCCA20S;
          regbus_rdata[9]             = CCADEMOD;
          regbus_rdata[8]             = CCACSEN;
          regbus_rdata[6 : 4]         = CCARAMPUDEN;
          regbus_rdata[2 : 0]         = CCAENERGYEN;
        end

        //Read RWNXAGCCCASTATE0 register.
        RWNXAGCCCASTATE0_ADDR_CT : begin
          regbus_rdata[26 : 16]       = RXSTATECCA20SSEL;
          regbus_rdata[10 : 0]        = RXSTATECCA20PSEL;
        end

        //Read RWNXAGCCCASTATE1 register.
        RWNXAGCCCASTATE1_ADDR_CT : begin
          regbus_rdata[10 : 0]        = RXSTATECCA40SSEL;
        end

        //Read RWNXAGCCCATIMEOUT register.
        RWNXAGCCCATIMEOUT_ADDR_CT : begin
          regbus_rdata[31 : 0]        = CCATIMEOUT;
        end

        //Read RWNXAGCCOMP0 register.
        RWNXAGCCOMP0_ADDR_CT : begin
          regbus_rdata[31 : 24]       = IDINBDPOWGAPDNQDBM;
          regbus_rdata[23 : 16]       = IDINBDPOWGAPUPQDBM;
          regbus_rdata[15 : 8]        = INBDPOWINFTHRDBM;
          regbus_rdata[7 : 0]         = INBDPOWSUPTHRDBM;
        end

        //Read RWNXAGCCOMP1 register.
        RWNXAGCCOMP1_ADDR_CT : begin
          regbus_rdata[31 : 24]       = ADCPOWINFTHRDBV;
          regbus_rdata[23 : 16]       = ADCPOWSUPTHRDBV;
          regbus_rdata[15 : 8]        = ADCPOWINFTHRDBM;
          regbus_rdata[7 : 0]         = ADCPOWSUPTHRDBM;
        end
`ifdef RW_RADAR_EN                    

        //Read RWNXAGCRADAR register.
        RWNXAGCRADAR_ADDR_CT : begin
          regbus_rdata[29 : 28]       = ANTSELRADAR;
          regbus_rdata[27 : 24]       = FREQSINGGAP;
          regbus_rdata[23 : 16]       = FREQSING;
          regbus_rdata[11 : 8]        = FOMSINGGAP;
          regbus_rdata[7 : 0]         = FOMSING;
        end

        //Read RWNXAGCRADARTIM register.
        RWNXAGCRADARTIM_ADDR_CT : begin
          regbus_rdata[31]            = 1'b0;
          regbus_rdata[18 : 16]       = PULSEIRQFIFOTHR;
          regbus_rdata[7 : 0]         = PULSEIRQTIMEOUT;
        end

        //Read RWNXAGCDCCOMPRADAR register.
        RWNXAGCDCCOMPRADAR_ADDR_CT : begin
          regbus_rdata[29 : 28]       = DCRADARTYPE;
          regbus_rdata[22 : 16]       = DCRADARHOLDTIME50NS;
          regbus_rdata[14 : 8]        = DCRADARZEROTIME50NS;
        end
`endif // RW_RADAR_EN                    

        //Read RWNXAGCCCA2 register.
        RWNXAGCCCA2_ADDR_CT : begin
          regbus_rdata[28 : 20]       = INBDCCA20SPOWMINDBM;
          regbus_rdata[19 : 12]       = CCA20SFALLTHRDBM;
          regbus_rdata[7 : 0]         = CCA20SRISETHRDBM;
        end

        //Read RWNXAGCCCA3 register.
        RWNXAGCCCA3_ADDR_CT : begin
          regbus_rdata[28 : 20]       = INBDCCA40SPOWMINDBM;
          regbus_rdata[19 : 12]       = CCA40SFALLTHRDBM;
          regbus_rdata[7 : 0]         = CCA40SRISETHRDBM;
        end

        //Read RWNXMACINTEN register.
        RWNXMACINTEN_ADDR_CT : begin
          regbus_rdata[12]            = IRQMACRADARDETEN;
          regbus_rdata[8]             = IRQMACCCATIMEOUTEN;
        end

        //Read RWNXMACINTSTATRAW register.
        RWNXMACINTSTATRAW_ADDR_CT : begin
          regbus_rdata[12]            = IRQMACRADARDETRAW;
          regbus_rdata[8]             = IRQMACCCATIMEOUTRAW;
        end

        //Read RWNXMACINTSTATMASKED register.
        RWNXMACINTSTATMASKED_ADDR_CT : begin
          regbus_rdata[12]            = IRQMACRADARDETMASKED;
          regbus_rdata[8]             = IRQMACCCATIMEOUTMASKED;
        end

        //Read RWNXMACINTACK register.
        RWNXMACINTACK_ADDR_CT : begin
          regbus_rdata[12]            = IRQMACRADARDETACK;
          regbus_rdata[8]             = IRQMACCCATIMEOUTACK;
        end

        //Read RWNXMACINTGEN register.
        RWNXMACINTGEN_ADDR_CT : begin
          regbus_rdata[12]            = statusIRQMACRADARDETGEN;
          regbus_rdata[8]             = statusIRQMACCCATIMEOUTGEN;
        end
`ifdef RW_NX_DERIV_80211B             

        //Read RWNXFEDSSSCCKCNTL register.
        RWNXFEDSSSCCKCNTL_ADDR_CT : begin
          regbus_rdata[18 : 16]       = RXSHIFT4044;
          regbus_rdata[13 : 12]       = TXSHIFT4044;
          regbus_rdata[6 : 5]         = BRXPATHSELREG;
          regbus_rdata[4]             = RXPATHSELFROMREG;
        end
`endif // RW_NX_DERIV_80211B             

        // Disable coverage on the default state because it cannot be reached.
        // pragma coverage block = off 
        default :
        begin
          regbus_rdata      = 32'b0;
        end
        // pragma coverage block = on 

      endcase
    
    end
    else
      regbus_rdata = 32'b0;
   
  end 
  
  
endmodule

////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////

