//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 15449 $
// $Date: 2014-07-03 11:58:45 +0200 (Thu, 03 Jul 2014) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of RIU Karst module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none
module RIUKarstTop
(
  /*****************************************************************************
  * Resets
  *****************************************************************************/
  input  wire                             nRegBusRst,
  input  wire                             nPhyRst,
`ifdef RW_NX_DERIV_80211B
  input  wire                             nFE44Rst,
`endif
  input  wire                             nFERst,
`ifdef RW_NX_FIQ_COMP_EN
  input  wire                             nFENoWdRst,
`endif // RW_NX_FIQ_COMP_EN
`ifdef RW_NX_DERIV_FE_PATH80M
  input  wire                             nFE160Rst,
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
  input  wire                             nFE80Rst,
`endif
  input  wire                             nFE40Rst,
  input  wire                             nAGCRst,
  input  wire                             nRCRst,
`ifdef RW_RADAR_EN
  input  wire                             nRadarTimRst,
`endif
  /*****************************************************************************
  * Clocks
  *****************************************************************************/
  /* regbus */
  input  wire                             RegBusClk,

  /* Front-end 44MHz */
`ifdef RW_NX_DERIV_80211B
  input  wire                             FE44GClk, // SHALL BE COHERENT WITH FEClk
`endif

  /* Front-end */
  input  wire                             FETxPath0GClk,
  input  wire                             FERxPath0GClk,
`ifdef RW_NX_IQ_COMP_EN
  input  wire                             FETxRxPath0GClk,
`endif
  input  wire                             FE40Path0GClk,
`ifdef RW_NX_DERIV_FE_PATH40M
  input  wire                             FE80Path0GClk,
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  input  wire                             FE160Path0GClk,
`endif

`ifdef RW_NX_DERIV_FE_PATH1
  input  wire                             FETxPath1GClk,
  input  wire                             FERxPath1GClk,
`ifdef RW_NX_IQ_COMP_EN
  input  wire                             FETxRxPath1GClk,
`endif
  input  wire                             FE40Path1GClk,
`ifdef RW_NX_DERIV_FE_PATH40M
  input  wire                             FE80Path1GClk,
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  input  wire                             FE160Path1GClk,
`endif // RW_NX_DERIV_FE_PATH1
`endif // RW_NX_DERIV_FE_PATH1

  /* PHY OFDM */
  input  wire                             PhyClk,

  /* AGC and radar detection */
  input  wire                             AGCGClk,
  input  wire                             AGCMemGClk,
  input  wire                             ADCPowGClk,
`ifdef RW_RADAR_EN
  input  wire                             RadarTimGClk,
`endif
                
  /* RC */
  input  wire                             RCGClk,

  /*****************************************************************************
  * Clock enables
  *****************************************************************************/
  /* AGC */
  output wire                             AGCClkEn,
  output wire                             AGCMemClkEn,
  /* Frontend */
  output wire                             FERxClkEn,
  output wire                             FETxClkEn,
`ifdef RW_NX_IQ_COMP_EN
  output wire                             FETxRxClkEn,
`endif    
  output wire                             FE40ClkEn,
`ifdef RW_NX_DERIV_FE_PATH40M
  output wire                             FE80ClkEn,
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  output wire                             FE160ClkEn,
`endif
  output wire                             FEPath0ClkEn,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire                             FEPath1ClkEn,
`endif

  /*****************************************************************************
  * Modem configuration (channel bandwidth/clocking)
  * exported registers
  *****************************************************************************/
  input  wire [ 1:0]                      CfgRegMdmConfBW,
  input  wire [ 2:0]                      CfgRegMdmConfPrimary,
 
  /*****************************************************************************
  * interrupt
  *****************************************************************************/
  output wire                             nInterrupt, 
  
  /*****************************************************************************
  * registers bank bus
  *****************************************************************************/
  input  wire                             RegBusRdEn,
  input  wire                             RegBusWrEn,
  input  wire  [15:0]                     RegBusAddr,
  input  wire  [31:0]                     RegBusWrData,
  output wire  [31:0]                     RegBusRdData,
  output wire                             RegBusReady,

  /*****************************************************************************
  * HDMCore
  *****************************************************************************/
  output wire                             AGCRifsDetected,
  output wire                             AGCOFDMLock,
  output wire                             AGCOFDMHTSTF,
  output wire                             AGCDSSSLock,
  output wire [7:0]                       AGCP1SNR,
  output wire [7:0]                       AGCP1NoiseVardB,
  output wire                             AGCP1Update,
  //
  output wire [7:0]                       AGCP2RxAntennaset,
  output wire [7:0]                       AGCP2Rssi1,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire [7:0]                       AGCP2Rssi2,
`endif
  output wire                             AGCP2Update,
  //
  output wire                             AGCCCAPrimary20,
  output wire                             AGCCCASecondary20,
  output wire                             AGCCCASecondary40,
  //
  input wire                              AGCOn,               
  input wire                              AGCKeepRFOn,
  //
  input wire                              AGCSFDFound,
  input wire                              AGCDemodRun,
  input wire                              AGCStartP,
  input wire                              AGCGainUpdateP,
  input wire                              AGCVHTFrame,
  input wire                              AGCNoACIMargin,
  input wire                              AGCBWSup20,
  input wire                              AGCBWEq20,
  input wire                              AGCBWEq40,
  input wire                              AGCBWEq80,
  input wire                              AGCPlatFallP,     // qualify AGCBWxxx
  input wire                              AGCRxEndTiming,
  input wire                              AGCFrameParamUpdate,                 
  input wire [6:0]                        AGCFrameParamMCS,                 
`ifdef RW_NX_IQ_COMP_EN
  input wire                              AGCLegFrame,
  input wire [7:0]                        AGCFOAngle,
  input wire [3:0]                        AGCFrameParamLegRate,                 
`endif
  //
  input wire                              CCALSIGValid,  
  input wire                              CCAHTSigVHTSigAValid,    
  //
  input wire                              RxFEEnDSSS,

  /*****************************************************************************
  * RC
  *****************************************************************************/
  /* RX */
  input  wire                             RCRxOn,
  output wire                             RCRxAck,
  input  wire [2:0]                       RCNRx,
 
  /* TX */
  input  wire                             RCTxOn,
  output wire                             RCTxAck,
  
  
  input  wire                             RCTx1Update, 
  input  wire                             RCTx1OFDMSel,  
  input  wire [7:0]                       RCTx1Power,  
  input  wire [2:0]                       RCTx1NTx,       
  input  wire [7:0]                       RCTx1Ant,     
  input  wire                             RCTx1SFOBypass, 
  input  wire [26:0]                      RCTx1SFO,
  input  wire                             RCTx1CFOBypass, 
  input  wire [24:0]                      RCTx1CFO,
  
  /*****************************************************************************
  * OFDM PHY datapath
  *****************************************************************************/
  /* TX path 0*/ 
  input  wire                             OFDMTxRelease,
  output wire                             OFDMTxUnderflow,
  output wire                             OFDMTxDone,
  output wire                             OFDMTxReady,   
  input  wire [12:0]                      OFDMTxI0,
  input  wire [12:0]                      OFDMTxQ0,
  input  wire                             OFDMTxLast,
  input  wire                             OFDMTxValid,   

  /* RX path 0*/
  output wire                             OFDMRx20Valid,
  output wire [12:0]                      OFDMRx20PriI0,
  output wire [12:0]                      OFDMRx20PriQ0,
`ifdef RW_NX_DERIV_FE_PATH40M
  output wire [12:0]                      OFDMRx20SecI,
  output wire [12:0]                      OFDMRx20SecQ,
  output wire                             OFDMRx40Valid,
  output wire [12:0]                      OFDMRx40I0,
  output wire [12:0]                      OFDMRx40Q0,
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  output wire                             OFDMRx80Valid,
  output wire [12:0]                      OFDMRx80I0,
  output wire [12:0]                      OFDMRx80Q0,
`endif

`ifdef RW_NX_DERIV_FE_PATH1
  /* TX path 1*/ 
  input  wire [14:0]                      OFDMTxI1,
  input  wire [14:0]                      OFDMTxQ1,
 
  /* RX path 1*/ 
  output wire [12:0]                      OFDMRx20PriI1,
  output wire [12:0]                      OFDMRx20PriQ1,
`ifdef RW_NX_DERIV_FE_PATH40M
  output wire [12:0]                      OFDMRx40I1,
  output wire [12:0]                      OFDMRx40Q1,
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  output wire [12:0]                      OFDMRx80I1,
  output wire [12:0]                      OFDMRx80Q1,
`endif
`endif // RW_NX_DERIV_FE_PATH1

`ifdef RW_NX_DERIV_80211B
  /*****************************************************************************
  * DSSS PHY datapath
  *****************************************************************************/
  /* TX */
  input  wire                             DSSSTxValid,
  input  wire [ 6:0]                      DSSSTxI,
  input  wire [ 6:0]                      DSSSTxQ,       
  /* RX */
  output wire                             DSSSRxValid,
  output wire [ 6:0]                      DSSSRxI,
  output wire [ 6:0]                      DSSSRxQ,
`endif
  /*****************************************************************************
  * memories
  *****************************************************************************/
  /* AGC */
  output wire [7:0]                       AGCMemAddr,
  output wire                             AGCMemEn,
  output wire [ 1:0]                      AGCMemWrEn,
  output wire [63:0]                      AGCMemWrData,
  input  wire [63:0]                      AGCMemRdData,

`ifdef RW_RADAR_EN
  /* Radar detection */
  output wire [8:0]                       RadarMemAddr,
  output wire                             RadarMemEn,
  output wire                             RadarMemWrEn,
  output wire [9:0]                       RadarMemWrData,
  input  wire [9:0]                       RadarMemRdData,
`endif
 
  /*****************************************************************************
  * Converters 
  *****************************************************************************/
  /* ADC */
  output wire                             ADCOn0,
  input  wire [11:0]                      ADCI0,
  input  wire [11:0]                      ADCQ0,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire                             ADCOn1,
  input  wire [11:0]                      ADCI1,
  input  wire [11:0]                      ADCQ1,
`endif

  /* DAC */
  output wire                             DACOn0,
  output wire                             DACEn0,
  output wire [11:0]                      DACI0,
  output wire [11:0]                      DACQ0,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire                             DACOn1,
  output wire                             DACEn1,
  output wire [11:0]                      DACI1,
  output wire [11:0]                      DACQ1,
`endif
  
  /*******************************************************************
  * RF interface
  *******************************************************************/
  output wire                             rf_resetn,
  input  wire                             rf_interrupt,
  output wire  [7:0]                      rf_gpio,
  output wire                             rf_agcfreeze,
  output wire                             rf_tmode,
  
  input  wire                             rf_spi_in,
  output wire                             rf_spi_ss_n,
  output wire                             rf_spi_clk,
  output wire                             rf_spi_out,

  /*******************************************************************
  * RF daughter board control
  *******************************************************************/
  /* Tx/Rx switch */
  output wire                             rf_trsw0,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire                             rf_trsw1,
`endif
                                                                                    
  /* External PA */                                          
  output wire                             rf_extpaon_ch0_5G9,
  output wire                             rf_extpaon_ch0_2G4,
`ifdef RW_NX_DERIV_FE_PATH1
  output wire                             rf_extpaon_ch1_5G9,
  output wire                             rf_extpaon_ch1_2G4,
`endif

  /*****************************************************************************
  * Coex
  *****************************************************************************/
`ifdef RW_WLAN_COEX_EN
  input wire                              rc_tx_abort,
  input wire                              rc_rx_abort,
`endif // RW_WLAN_COEX_EN

  /*****************************************************************************
  * debug/diag
  *****************************************************************************/
  output wire [15:0]                      DbgBank0,
  output wire [15:0]                      DbgBank1,
  output wire [15:0]                      DbgBank2,
  output wire [15:0]                      DbgBank3,
  output wire [15:0]                      DbgBank4,
  output wire [15:0]                      DbgBank5,
  output wire [15:0]                      DbgBank6,
  output wire [15:0]                      DbgBank7,
  output wire [15:0]                      DbgBank8,
  output wire [15:0]                      DbgBank9,
  output wire [15:0]                      DbgBank10,
  output wire [15:0]                      DbgBank11,
  output wire [15:0]                      DbgBank12,
  output wire [15:0]                      DbgBank13,
  output wire [15:0]                      DbgBank14
  );

  //////////////////////////////////////////////////////////////////////////////
  // Local Parameters Declarations
  //////////////////////////////////////////////////////////////////////////////
  localparam   BW20=2'd0,BW40=2'd1,BW80=2'd2;

  //////////////////////////////////////////////////////////////////////////////
  // Internal Wires declarations
  //////////////////////////////////////////////////////////////////////////////

  // Status Registers
  // Version register
  wire [7 : 0] RESERVED;   
  wire [1 : 0] AGCRAMMODE;
  wire         IQCOMP     ;
  wire         FIQCOMP    ;
  wire         DSSSCORR   ;
  wire         AGCSNR     ;
  wire         RADAR      ;
  wire         DSSSCCK    ;
  wire [1 : 0] CHBW       ;
  wire [3 : 0] NSS        ;
  wire [3 : 0] NTX        ;
  wire [3 : 0] NRX        ;

  wire signed [9 : 0]  InbdPow40SdBm,InbdPow20SdBm;
  wire signed [9 : 0]  InbdPow40SNoisedBm,InbdPow20SNoisedBm;
  wire signed [9 : 0]  InbdPow40SdBmSync,InbdPow20SdBmSync;
  wire signed [9 : 0]  InbdPow40SNoisedBmSync,InbdPow20SNoisedBmSync;
  wire                 InbdPow20PNoiseUpdate;
  
  wire signed [9 : 0]  InBd20PowqdBmAnt0;
  wire signed [8 : 0]  ADCPowqdBVAnt0;
  wire signed [9 : 0]  InbdPow20PNoisedBm0;
  wire signed [9 : 0]  InBd20PowqdBmAnt0Sync;
  wire signed [8 : 0]  ADCPowqdBVAnt0Sync;
  wire signed [9 : 0]  InbdPow20PNoisedBm0Sync;
  wire signed [7 : 0]  RxGainAnt0;
  wire signed [6 : 0]  DigGaindB20Ant0;
  wire signed [6 : 0]  DigGaindB40Ant0;
  wire signed [6 : 0]  DigGaindB80Ant0;
  wire signed [7 : 0]  RxGainAnt0Sync;
  wire signed [6 : 0]  DigGaindB20Ant0Sync;
  wire signed [6 : 0]  DigGaindB40Ant0Sync;
  wire signed [6 : 0]  DigGaindB80Ant0Sync;
`ifdef RW_NX_DERIV_FE_PATH1
  wire signed [9 : 0]  InBd20PowqdBmAnt1;
  wire signed [8 : 0]  ADCPowqdBVAnt1;
  wire signed [9 : 0]  InbdPow20PNoisedBm1;
  wire signed [9 : 0]  InBd20PowqdBmAnt1Sync;
  wire signed [8 : 0]  ADCPowqdBVAnt1Sync;
  wire signed [9 : 0]  InbdPow20PNoisedBm1Sync;
  wire signed [7 : 0]  RxGainAnt1;
  wire signed [6 : 0]  DigGaindB20Ant1;
  wire signed [6 : 0]  DigGaindB40Ant1;
  wire signed [6 : 0]  DigGaindB80Ant1;
  wire signed [7 : 0]  RxGainAnt1Sync;
  wire signed [6 : 0]  DigGaindB20Ant1Sync;
  wire signed [6 : 0]  DigGaindB40Ant1Sync;
  wire signed [6 : 0]  DigGaindB80Ant1Sync;
`endif // RW_NX_DERIV_FE_PATH1
  reg                  AGCLockStat;
`ifdef RW_NX_IQ_COMP_EN
  wire       [21 : 0]  StRegRxIQEstVarI0;
  wire       [21 : 0]  StRegRxIQEstVarQ0;
  wire       [22 : 0]  StRegRxIQEstMIQ0;
  wire       [10 : 0]  StRegRxIQEstIQGainEst0;
  wire        [8 : 0]  StRegRxIQEstIQPhaseEst0;
  wire                 StRegRxIQEstValid;
  wire       [21 : 0]  StRegRxIQEstVarI0Sync;
  wire       [21 : 0]  StRegRxIQEstVarQ0Sync;
  wire       [22 : 0]  StRegRxIQEstMIQ0Sync;
  wire       [10 : 0]  StRegRxIQEstIQGainEst0Sync;
  wire        [8 : 0]  StRegRxIQEstIQPhaseEst0Sync;
`ifdef RW_NX_DERIV_FE_PATH1
  wire       [21 : 0]  StRegRxIQEstVarI1;
  wire       [21 : 0]  StRegRxIQEstVarQ1;
  wire       [22 : 0]  StRegRxIQEstMIQ1;
  wire       [10 : 0]  StRegRxIQEstIQGainEst1;
  wire        [8 : 0]  StRegRxIQEstIQPhaseEst1;
  wire       [21 : 0]  StRegRxIQEstVarI1Sync;
  wire       [21 : 0]  StRegRxIQEstVarQ1Sync;
  wire       [22 : 0]  StRegRxIQEstMIQ1Sync;
  wire       [10 : 0]  StRegRxIQEstIQGainEst1Sync;
  wire        [8 : 0]  StRegRxIQEstIQPhaseEst1Sync;
`endif // RW_NX_DERIV_FE_PATH1
`endif // RW_NX_IQ_COMP_EN
`ifdef RW_NX_FIQ_COMP_EN
  wire       [12 : 0]  StRegfIQRxEstError0;
  wire       [12 : 0]  StRegfIQTxEstError0;
`ifdef RW_NX_DERIV_FE_PATH1
  wire       [12 : 0]  StRegfIQRxEstError1;
  wire       [12 : 0]  StRegfIQTxEstError1;
`endif // RW_NX_DERIV_FE_PATH1
  wire                 StRegfIQCollDone;
  wire                 StRegfIQEstDone;
  wire       [15 : 0]  StRegfIQCoeff0;
  wire       [15 : 0]  StRegfIQCoeff1;
  wire       [15 : 0]  StRegfIQCoeff2;
  wire       [15 : 0]  StRegfIQCoeff3;
  wire       [15 : 0]  StRegfIQCoeff4;
  wire       [15 : 0]  StRegfIQCoeff5;
  wire       [15 : 0]  StRegfIQCoeff6;
  wire       [15 : 0]  StRegfIQCoeff7;
  wire       [15 : 0]  StRegfIQCoeff8;
  wire       [15 : 0]  StRegfIQCoeff9;
  wire       [15 : 0]  StRegfIQCoeff10;
  wire       [15 : 0]  StRegfIQCoeff11;
  wire       [15 : 0]  StRegfIQCoeff12;
  wire       [15 : 0]  StRegfIQCoeff13;
  wire       [15 : 0]  StRegfIQCoeff14;
  wire       [15 : 0]  StRegfIQCoeff15;
  wire       [15 : 0]  StRegfIQCoeff16;
  wire       [15 : 0]  StRegfIQCoeff17;
  wire       [15 : 0]  StRegfIQCoeff18;
  wire       [15 : 0]  StRegfIQCoeff19;
`endif // RW_NX_FIQ_COMP_EN
  
  // Config Registers
  wire                 CfgRegTxC2sDisb;
  wire                 CfgRegAGCInbdPowStartCapture;
  wire                 AGCInbdPowStartCaptureInValid;
  wire [1 : 0]         CfgRegActiveAnt;
  wire                 CfgRegRxC2sDisb;
  wire                 CfgRegRxPathSelFromReg;
  wire [1 : 0]         CfgRegBRxPathSel;
  wire [2 : 0]         CfgRegBRxShift;
  wire [1 : 0]         CfgRegBTxShift;
  wire                 CfgRegTxIQSwapPath0; 
  wire                 CfgRegRxIQSwapPath0; 
  wire                 CfgRegTxIQDelPathQ0,CfgRegTxIQDelPathI0;  
  wire                 CfgRegRxIQDelPathQ0,CfgRegRxIQDelPathI0;  
  wire [6 : 0]         CfgRegTx80DigGainLin0,CfgRegTx40DigGainLin0,CfgRegTx20DigGainLin0;
`ifdef RW_NX_IQ_COMP_EN
  wire                 CfgRegTxIQGainCompEn0;
  wire                 CfgRegTxIQPhaseCompEn0;
  wire [10 : 0]        CfgRegTxIQGain0;
  wire [8 : 0]         CfgRegTxIQPhase0;
  wire                 CfgRegRxIQEstIterClr;
  wire                 CfgRegRxIQEstIterClrSync;
  wire [7 : 0]         CfgRegRxIQEstSNRMin;
  wire [3 : 0]         CfgRegRxIQEstMCSMin;
  wire [2 : 0]         CfgRegRxIQEstBWList;
  wire [7 : 0]         CfgRegRxIQEstFOMin;
  wire                 CfgRegRxIQPhaseEstEn;
  wire                 CfgRegRxIQGainEstEn;
  wire                 CfgRegRxIQGainCompEn;
  wire                 CfgRegRxIQPhaseCompEn;
  wire [2 : 0]         CfgRegRxIQEstDel;
  wire [2 : 0]         CfgRegRxIQEstGainStepInit;
  wire [2 : 0]         CfgRegRxIQEstGainStepStop;
  wire [2 : 0]         CfgRegRxIQEstPhaseStepInit;
  wire [2 : 0]         CfgRegRxIQEstPhaseStepStop;
  wire [2 : 0]         CfgRegRxIQEstStepDel0;
  wire [2 : 0]         CfgRegRxIQEstStepDel1;
  wire [2 : 0]         CfgRegRxIQEstStepDel2;
  wire [2 : 0]         CfgRegRxIQEstStepDel3;
  wire [2 : 0]         CfgRegRxIQEstStepDel4;
  wire [10: 0]         CfgRegRxIQGain0;
  wire [8 : 0]         CfgRegRxIQPhase0;
`endif // RW_NX_IQ_COMP_EN
`ifdef RW_NX_FIQ_COMP_EN              
  wire                 CfgRegfIQCalEn;
  wire                 CfgRegfIQCollStartP;
  wire                 CfgRegfIQEstStartP;
`ifdef RW_NX_DERIV_FE_PATH1
  wire                 CfgRegfIQPathSel;
`endif // RW_NX_DERIV_FE_PATH1
  wire                 CfgRegfIQTxRx;
  wire                 CfgRegfIQTxBypass;
  wire                 CfgRegfIQRxBypass;
  wire                 CfgRegfIQCollPath;
  wire [ 7 : 0]        CfgRegfIQCollWrOffset;
  wire [ 7 : 0]        CfgRegfIQCollRdOffset;
  wire [ 7 : 0]        CfgRegfIQCollSize;
  wire [ 7 : 0]        CfgRegfIQEstIOffset;
  wire [ 7 : 0]        CfgRegfIQEstQOffset;
  wire [ 7 : 0]        CfgRegfIQEstSize;
  wire [ 4 : 0]        CfgRegfIQTxDel;
  wire [ 4 : 0]        CfgRegfIQRxDel;
  wire [ 7 : 0]        CfgRegfIQCollDel;
  wire [ 3 : 0]        CfgRegfIQEstStep;
  wire [15 : 0]        CfgRegfIQEstNite;
  wire [15 : 0]        CfgRegfIQCoeff0;
  wire [15 : 0]        CfgRegfIQCoeff1;
  wire [15 : 0]        CfgRegfIQCoeff2;
  wire [15 : 0]        CfgRegfIQCoeff3;
  wire [15 : 0]        CfgRegfIQCoeff4;
  wire [15 : 0]        CfgRegfIQCoeff5;
  wire [15 : 0]        CfgRegfIQCoeff6;
  wire [15 : 0]        CfgRegfIQCoeff7;
  wire [15 : 0]        CfgRegfIQCoeff8;
  wire [15 : 0]        CfgRegfIQCoeff9;
  wire [15 : 0]        CfgRegfIQCoeff10;
  wire [15 : 0]        CfgRegfIQCoeff11;
  wire [15 : 0]        CfgRegfIQCoeff12;
  wire [15 : 0]        CfgRegfIQCoeff13;
  wire [15 : 0]        CfgRegfIQCoeff14;
  wire [15 : 0]        CfgRegfIQCoeff15;
  wire [15 : 0]        CfgRegfIQCoeff16;
  wire [15 : 0]        CfgRegfIQCoeff17;
  wire [15 : 0]        CfgRegfIQCoeff18;
  wire [15 : 0]        CfgRegfIQCoeff19;
  wire                 CfgRegfIQCoeffUpdate;
  wire                 CfgRegfIQCoeffReq;
`endif // RW_NX_FIQ_COMP_EN

`ifdef RW_NX_DERIV_FE_PATH1
  wire                 CfgRegTxIQSwapPath1;  
  wire                 CfgRegRxIQSwapPath1; 
  wire                 CfgRegTxIQDelPathQ1,CfgRegTxIQDelPathI1;  
  wire                 CfgRegRxIQDelPathQ1,CfgRegRxIQDelPathI1;  
  wire [6 : 0]         CfgRegTx80DigGainLin1,CfgRegTx40DigGainLin1,CfgRegTx20DigGainLin1;
`ifdef RW_NX_IQ_COMP_EN
  wire                 CfgRegTxIQGainCompEn1;
  wire                 CfgRegTxIQPhaseCompEn1;
  wire [10 : 0]        CfgRegTxIQGain1;
  wire [8 : 0]         CfgRegTxIQPhase1;
  wire [10 : 0]        CfgRegRxIQGain1;
  wire [8 : 0]         CfgRegRxIQPhase1;
`endif // RW_NX_IQ_COMP_EN
`endif // RW_NX_DERIV_FE_PATH1

  // AGC Registers
  wire [3 : 0]         AgcRegAntLossDB0;
  wire [3 : 0]         AgcRegAntLossDB1;
  wire [6 : 0]         AgcRegRFGainMax4DetdB;
  wire [6 : 0]         AgcRegRFGainMin4DetdB;
  wire [6 : 0]         AgcRegRFGainMaxdB;
  wire [6 : 0]         AgcRegRFGainMindB;
  wire [3 : 0]         AgcRegDigGain80vs20;
  wire [3 : 0]         AgcRegDigGain40vs20;
  wire                 AgcRegSNRMeasSel;
  wire [4 : 0]         AgcRegSatDelayCount;
  wire [5 : 0]         AgcRegSatDynHighThr;
  wire [5 : 0]         AgcRegSatDynLowThr;
  wire [5 : 0]         AgcRegSatLowThr;
  wire [9 : 0]         AgcRegDetFallThrqdBm;
  wire [9 : 0]         AgcRegDetRiseThrqdBm;
  wire [2 : 0]         AgcRegDelRampDownTap;
  wire [7 : 0]         AgcRegDetRampDown;
  wire [2 : 0]         AgcRegDelRampUpTap;
  wire [7 : 0]         AgcRegDetRampUp;
  wire [3 : 0]         AgcRegADCPowDisNdl;
  wire [6 : 0]         AgcRegADCPowDisThrdBV;
  wire [2 : 0]         AgcRegDelPlatTap;
  wire [4 : 0]         AgcRegDetPlat;
  wire [1 : 0]         AgcRegDC4ADCCompType;
  wire [1 : 0]         AgcRegDC4PrimaryCompType;
  wire [1 : 0]         AgcRegDC4CenteredCompType;
  wire [1 : 0]         AgcRegDC4DSSSCompType;
  wire [6 : 0]         AgcRegDC4ADCHoldTime;
  wire [6 : 0]         AgcRegDC4ADCZeroTime;
  wire [6 : 0]         AgcRegDC4PrimaryHoldTime;
  wire [6 : 0]         AgcRegDC4PrimaryZeroTime;
  wire [6 : 0]         AgcRegDC4CenteredHoldTime;
  wire [6 : 0]         AgcRegDC4CenteredZeroTime;
  wire [6 : 0]         AgcRegDC4DSSSHoldTime;
  wire [6 : 0]         AgcRegDC4DSSSZeroTime;
  wire [6 : 0]         AgcRegDelStableDC;
  wire [31 : 0]        AgcRegFsmEvent0;
  wire [31 : 0]        AgcRegFsmEvent1;
  wire [31 : 0]        AgcRegFsmEvent2;
  wire [31 : 0]        AgcRegFsmEvent3;
  wire                 AgcRegHTSTFGainEn;
  wire                 AgcRegAgcFsmReset;
  wire                 AgcRegRadarDetEn;
  wire                 AgcRegRifsDetEn;
  wire                 AgcRegModeB;
  wire                 AgcRegModeA;
  wire [3 : 0]         AgcRegGPSetting;
  wire [1 : 0]         AgcRegChCombMode;
  wire [3 : 0]         AgcRegNBitAdc;
  wire [7 : 0]         AgcRegVPeakADCqdBV;
  wire [7 : 0]         AgcRegADCdBVThr;
  wire [7 : 0]         AgcRegADCPowBiasqdBV;
  wire [7 : 0]         AgcRegADCdBmThr;
  wire [7 : 0]         AgcRegADCPowBiasqdBm;
  wire [7 : 0]         AgcRegInBddBVThr;
  wire [1 : 0]         AgcRegInBdRnd;
  wire [7 : 0]         AgcRegInBddBmThr;
  wire [7 : 0]         AgcRegInBd40SPowBiasqdBm;
  wire [7 : 0]         AgcRegInBd20SPowBiasqdBm;
  wire [7 : 0]         AgcRegInBd20PPowBiasqdBm;
  wire [7 : 0]         AgcRegFE20Gain;
  wire [7 : 0]         AgcRegFE40Gain;
  wire [5 : 0]         AgcRegACI20MargMCS9;
  wire [5 : 0]         AgcRegACI20MargMCS8;
  wire [5 : 0]         AgcRegACI20MargMCS7;
  wire [5 : 0]         AgcRegACI20MargMCS6;
  wire [5 : 0]         AgcRegACI20MargMCS5;
  wire [5 : 0]         AgcRegACI20MargMCS4;
  wire [5 : 0]         AgcRegACI20MargMCS3;
  wire [5 : 0]         AgcRegACI20MargMCS2;
  wire [5 : 0]         AgcRegACI20MargMCS1;
  wire [5 : 0]         AgcRegACI20MargMCS0;
  wire [5 : 0]         AgcRegACI40MargMCS9;
  wire [5 : 0]         AgcRegACI40MargMCS8;
  wire [5 : 0]         AgcRegACI40MargMCS7;
  wire [5 : 0]         AgcRegACI40MargMCS6;
  wire [5 : 0]         AgcRegACI40MargMCS5;
  wire [5 : 0]         AgcRegACI40MargMCS4;
  wire [5 : 0]         AgcRegACI40MargMCS3;
  wire [5 : 0]         AgcRegACI40MargMCS2;
  wire [5 : 0]         AgcRegACI40MargMCS1;
  wire [5 : 0]         AgcRegACI40MargMCS0;
  wire [5 : 0]         AgcRegACI80MargMCS9;
  wire [5 : 0]         AgcRegACI80MargMCS8;
  wire [5 : 0]         AgcRegACI80MargMCS7;
  wire [5 : 0]         AgcRegACI80MargMCS6;
  wire [5 : 0]         AgcRegACI80MargMCS5;
  wire [5 : 0]         AgcRegACI80MargMCS4;
  wire [5 : 0]         AgcRegACI80MargMCS3;
  wire [5 : 0]         AgcRegACI80MargMCS2;
  wire [5 : 0]         AgcRegACI80MargMCS1;
  wire [5 : 0]         AgcRegACI80MargMCS0;
  wire [2 : 0]         AgcRegDelCCARampDownTap;
  wire [2 : 0]         AgcRegDelCCARampUpTap;
  wire [5 : 0]         AgcRegCCADetRampDown;
  wire [5 : 0]         AgcRegCCADetRampUp;
  wire                 AgcRegDisCCAEn;
  wire                 AgcRegSatCCAEn;
  wire [8 : 0]         AgcRegInbdCCA20PPowMindBm;
  wire [7 : 0]         AgcRegCCA20PFallThrdBm;
  wire [7 : 0]         AgcRegCCA20PRiseThrdBm;
  wire [3 : 0]         AgcRegCCAFlag3Ctrl;
  wire [3 : 0]         AgcRegCCAFlag2Ctrl;
  wire [3 : 0]         AgcRegCCAFlag1Ctrl;
  wire [3 : 0]         AgcRegCCAFlag0Ctrl;
  wire [10: 0]         AgcRegRxStateCca20PSel;
  wire [10: 0]         AgcRegRxStateCca20SSel;
  wire [10: 0]         AgcRegRxStateCca40SSel;
  wire [1 : 0]         AgcRegAntSelCCA20s;
  wire [1 : 0]         AgcRegAntSelCCA40s;
  wire                 AgcRegCCADemod;
  wire                 AgcRegCCACSEn;
  wire [2 : 0]         AgcRegCCARampUDen;
  wire [2 : 0]         AgcRegCCAEnergyEn;
  wire [31 : 0]        AgcRegCCATimeOut;
  wire [7 : 0]         AgcRegIdInbdPowGapDnqdBm;
  wire [7 : 0]         AgcRegIdInbdPowGapUpqdBm;
  wire [7 : 0]         AgcRegInbdPowInfThrdBm;
  wire [7 : 0]         AgcRegInbdPowSupThrdBm;
  wire [7 : 0]         AgcRegADCPowInfThrdBV;
  wire [7 : 0]         AgcRegADCPowSupThrdBV;
  wire [7 : 0]         AgcRegADCPowInfThrdBm;
  wire [7 : 0]         AgcRegADCPowSupThrdBm;
`ifdef RW_RADAR_EN                    
  wire [1 : 0]         AgcRegAntSelRadar;
  wire [7 : 0]         AgcRegFreqSing;
  wire [3 : 0]         AgcRegFreqSingGap;
  wire [7 : 0]         AgcRegFomSing;
  wire [3 : 0]         AgcRegFomSingGap;
  wire                 AgcRegPulseTimerClear;
  wire [2 : 0]         AgcRegPulseIrqFifoThr;
  wire [7 : 0]         AgcRegPulseIrqTimeOut;
  wire [1 : 0]         AgcRegDC4RadarCompType;
  wire [6 : 0]         AgcRegDC4RadarHoldTime;
  wire [6 : 0]         AgcRegDC4RadarZeroTime;
`endif // RW_RADAR_EN
  wire [8 : 0]         AgcRegInbdCCA20SPowMindBm;
  wire [7 : 0]         AgcRegCCA20SFallThrdBm;
  wire [7 : 0]         AgcRegCCA20SRiseThrdBm;
  wire [8 : 0]         AgcRegInbdCCA40SPowMindBm;
  wire [7 : 0]         AgcRegCCA40SFallThrdBm;
  wire [7 : 0]         AgcRegCCA40SRiseThrdBm;
  wire                 StatusTrigReq;
  reg                  AGCStatusRegMask;
  
  // Added for AGC
  wire [8:0]           AGCMemAddrInt;
  wire [31:0]          AGCMemRdDataInt;
`ifdef RW_RADAR_EN                    
  wire                 RadarFifoEmpty;
`endif // RW_RADAR_EN                    

  // Resync signals
  wire                 InbdPowStartCaptureSync;
  wire                 AgcOnSync;
  wire                 AGCCCALSIGValidSync;
  wire                 AGCCCAHTSIGVHTSIGAValidSync;
  wire                 AGCKeepRFOnSync;
`ifdef RW_RADAR_EN                    
  wire                 PulseTimerClearSync;
`endif // RW_RADAR_EN                    
  wire                 AGCRxEndTimingSync;
  wire                 AGCStartPSync;
  wire                 AGCGainUpdatePSync;
  wire                 AGCSFDFoundSync;
  wire                 AGCDemodRunSync;
  wire                 StatusTrigReqSync;
  wire                 StatusTrigConfSync;
  wire                 AGCPlatFallPSync;
  wire                 AGCBWSup20Sync;
  wire                 AGCBWEq20Sync;
  wire                 AGCBWEq40Sync;
  wire                 AGCBWEq80Sync;
  wire                 AGCVHTFrameSync;
  wire                 AGCNoACIMarginSync;
  wire                 RxFEEnDSSSSync;
  wire [6:0]           AGCFrameParamMCSSync;
`ifdef RW_NX_IQ_COMP_EN
  wire                 AGCLegFrameSync;
  wire [7:0]           AGCFOAngleSync;
  wire [3:0]           AGCFrameParamLegRateSync;
`endif
  /* interrupts */
  wire CCATimeOutErrIrq,       RadarIrq;
  wire CCATimeOutErrIrqSync,   RadarIrqSync;
  wire IrqRegMACRADARDETGEN,   IrqRegMACRADARDETACK;
  wire IrqRegMACCCATIMEOUTGEN, IrqRegMACCCATIMEOUTACK;
  wire IrqRegMACRADARDETEN,    IrqRegMACCCATIMEOUTEN;
  wire IrqMACRADARDETMASKED,   IrqMACCCATIMEOUTMASKED;
  reg  IrqMACRADARDETRAW,      IrqMACCCATIMEOUTRAW;
  
  // Radio controller
  wire                 RCRxEndP;
  wire                 RCTxEndP;
  wire                 RCProgRFDone;
  wire                 RCProgRF;
  wire                 RFADCOn;
  wire                 RFTRXSwitch;
  wire [15:0]          DbgKarstCtrl;
  wire                 AGCRFGainCompReq;
  wire                 AGCRFGainCompDone;
  wire [7:0]           AGCGainTgt0;
  wire [7:0]           RFGaindB0;
  wire [5:0]           RFGainNFdB0;
`ifdef RW_NX_DERIV_FE_PATH1
  wire [7:0]           AGCGainTgt1;
  wire [7:0]           RFGaindB1;
  wire [5:0]           RFGainNFdB1;
`endif  

`ifdef RW_NX_FIQ_COMP_EN              
  // fIQ <-> regbus resynchronization
  wire                 RegfIQCoeffReqInValid;
  wire                 RegfIQCoeffUpdateInValid;
  reg                  RegfIQCoeffUpdate;
  wire                 RegfIQCoeffUpdateDone;
  reg                  RegfIQCoeffUpdateDoneD;
  wire                 fIQCollStartP;
  wire                 fIQCollDone;
  wire                 fIQEstStartP;
  wire                 fIQEstDone;
  wire                 fIQCoeffReq;
  wire                 fIQCoeffUpdate;
  wire [15 : 0]        fIQStatCoeff0;
  wire [15 : 0]        fIQStatCoeff1;
  wire [15 : 0]        fIQStatCoeff2;
  wire [15 : 0]        fIQStatCoeff3;
  wire [15 : 0]        fIQStatCoeff4;
  wire [15 : 0]        fIQStatCoeff5;
  wire [15 : 0]        fIQStatCoeff6;
  wire [15 : 0]        fIQStatCoeff7;
  wire [15 : 0]        fIQStatCoeff8;
  wire [15 : 0]        fIQStatCoeff9;
  wire [15 : 0]        fIQStatCoeff10;
  wire [15 : 0]        fIQStatCoeff11;
  wire [15 : 0]        fIQStatCoeff12;
  wire [15 : 0]        fIQStatCoeff13;
  wire [15 : 0]        fIQStatCoeff14;
  wire [15 : 0]        fIQStatCoeff15;
  wire [15 : 0]        fIQStatCoeff16;
  wire [15 : 0]        fIQStatCoeff17;
  wire [15 : 0]        fIQStatCoeff18;
  wire [15 : 0]        fIQStatCoeff19;
  wire                 fIQStatToggle0;
  wire [12 : 0]        fIQRxEstError0;
  wire [12 : 0]        fIQTxEstError0;
`ifdef RW_NX_DERIV_FE_PATH1
  wire                 fIQStatToggle1;
  wire [12 : 0]        fIQRxEstError1;
  wire [12 : 0]        fIQTxEstError1;
`endif // RW_NX_DERIV_FE_PATH1
`endif // RW_NX_FIQ_COMP_EN              

  // Clock enable control
  wire rc_rctxon,rc_rctxack;
  wire rc_rcrxon,rc_rcrxack;
  reg fe_tx_ofdm_blocken;
  reg fe_tx_ofdm_blocken_realigned;
  reg agc_clken;
`ifdef RW_NX_DERIV_80211B
  reg fe_tx_dsss_blocken;
`endif
  reg fe40_clken;
`ifdef RW_NX_DERIV_FE_PATH40M
  reg fe80_clken;
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  reg fe160_clken;
`endif
  reg ferx_clken;
  reg fetx_clken;
  reg fe_path0_clken;
`ifdef RW_NX_DERIV_FE_PATH1
  reg fe_path1_clken;
`endif  

  wire coexrc_txon_req;
  wire coexrc_txon_req_mask;
  wire coexrc_txon_ack;
  wire coexrc_rxon_req;
  wire coexrc_rxon_ack;

  // FE
  wire           phy_tden;
  wire           fe_rx_valid;
  wire           phy_rx20_valid;
  wire [12:0]    fe_rx20pri_i0, fe_rx20pri_q0;

`ifdef RW_NX_DERIV_FE_PATH40M
  wire [12:0]    fe_rx20sec_i, fe_rx20sec_q;
  wire           phy_rx40_valid;
  wire [12:0]    fe_rx40_i0,    fe_rx40_q0;
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  wire           phy_rx80_valid;
  wire [12:0]    fe_rx80_i0,    fe_rx80_q0;
`endif
`ifdef RW_NX_DERIV_FE_PATH1
  wire [12:0]    fe_rx20pri_i1, fe_rx20pri_q1;
`ifdef RW_NX_DERIV_FE_PATH40M
  wire [12:0]    fe_rx40_i1,    fe_rx40_q1;
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  wire [12:0]    fe_rx80_i1,    fe_rx80_q1;
`endif
`endif
`ifdef RW_NX_FIQ_COMP_EN
  wire [7:0]     fIQMemAddr;
  wire           fIQMemWrEn;
  wire           fIQMemRdEn;
  wire [63:0]    fIQMemWrData;
`endif // RW_NX_FIQ_COMP_EN  

  wire [7:0]   RCAntennaSet;
  
  wire [ 6:0] ofdm_tx_diggain0;
`ifdef RW_NX_DERIV_FE_PATH1
  wire [ 6:0] ofdm_tx_diggain1;
`endif
  wire        ofdm_tx_ready;
  wire [12:0] ofdm_tx_q0_sync,ofdm_tx_i0_sync;
  wire        ofdm_tx_valid_sync;
  wire        ofdm_tx_last_sync;
  wire        ofdm_tx_loaded;
  wire        ofdm_tx_release_sync;
  
  
  
  /*****************************************************************************
  * versioning
  *****************************************************************************/
  assign RESERVED   = 8'd0;     // RESERVED !!!
  assign AGCRAMMODE = 2'd2;  // AGC RAM can be read/write through APB
`ifdef RW_NX_FIQ_COMP_EN
  assign FIQCOMP = 1'b1;
`else
  assign FIQCOMP = 1'b0;
`endif
`ifdef RW_NX_IQ_COMP_EN
  assign IQCOMP = 1'b1;
`else
  assign IQCOMP = 1'b0;
`endif
`ifdef RW_NX_DSSS_CORR_EN
  assign DSSSCORR = 1'b1;
`else
  assign DSSSCORR = 1'b0;
`endif
`ifdef RW_NX_AGC_SNR_EN
  assign AGCSNR = 1'b1;
`else
  assign AGCSNR = 1'b0;
`endif
`ifdef RW_RADAR_EN
  assign RADAR = 1'b1;
`else
  assign RADAR = 1'b0;
`endif
`ifdef RW_NX_DERIV_80211B
  assign DSSSCCK = 1'b1;
`else
  assign DSSSCCK = 1'b0;
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  assign CHBW = 2'd2;
`elsif RW_NX_DERIV_FE_PATH40M
  assign CHBW = 2'd1;
`else
  assign CHBW = 2'd0;
`endif
assign NSS = 4'd`RW_NX_DERIV_NSS;
assign NTX = 4'd`RW_NX_DERIV_NTX;
assign NRX = 4'd`RW_NX_DERIV_NRX;
  
  /*****************************************************************************
  * regbus address decoder (address given in bytes)
  *
  * 0X0000-0X07FC  STATUS             0000_0XXX_XXXX_XXXX
  * 0X0800-0X0FFC  CONFIG             0000_1XXX_XXXX_XXXX
  * 0X1000-0X2FFC  **RESERVED**
  * 0X3000-0X3FFC  11B                0011_XXXX_XXXX_XXXX
  * 0X4000-0X4FFC  RADAR              0100_XXXX_XXXX_XXXX speculation disabled
  * 0X5000-0X9FFC  **RESERVED**
  * 0XA000-0XAFFC  AGCMEM             1010_XXXX_XXXX_XXXX
  * 0XB000-0xBFFC  RIUREG             1011_XXXX_XXXX_XXXX
  * 0XC000-0xCFFC  RCRREG             1100_XXXX_XXXX_XXXX
  * 0XD000-0xDFFC  LBMEM              1101_XXXX_XXXX_XXXX
  *****************************************************************************/ 
  wire        RegBusSelRC,RegBusSelRB,RegBusSelAGCMEM,RegBusSelRadar;
  wire        RadarFifoRdEn;
  wire [31:0] RadarFifoRdData;
  
  assign RegBusSelRC     = RegBusAddr[15:12]==5'b1100;
  assign RegBusSelRB     = RegBusAddr[15:12]==4'b1011;
  assign RegBusSelAGCMEM = RegBusAddr[15:12]==4'b1010;
  assign RegBusSelRadar  = RegBusAddr[15:12]==4'b0100;
 
  assign RadarFifoRdEn   = RegBusSelRadar & RegBusRdEn;

  /* regbus read data multiplexer */
  wire [31:0] RegBusRdDataRC,RegBusRdDataRB,RegBusRdDataAGCMEM;
  reg  [31:0] RegBusRdDataRadar_1t,RegBusRdDataRC_1t,RegBusRdDataRB_1t,RegBusRdDataAGCMEM_1t;
  // !!! Only AGC memory can insert wait states !!! Else RIUAGCMemCtrl must be updated
  wire RegBusRdDataAGCMEM_Valid;
  always @(posedge RegBusClk, negedge nRegBusRst)
    if(!nRegBusRst)
    begin
      RegBusRdDataRadar_1t  <= 32'b0;
      RegBusRdDataRC_1t     <= 32'b0;
      RegBusRdDataRB_1t     <= 32'b0;
      RegBusRdDataAGCMEM_1t <= 32'b0;
    end
    else
    begin
      /* RTZ */
      RegBusRdDataRadar_1t  <= 32'b0;
      RegBusRdDataRC_1t     <= 32'b0;
      RegBusRdDataRB_1t     <= 32'b0;
      
      /* read cycle */
      if(RegBusRdEn)
      begin
        // These modules do not insert wait states
        if(RegBusSelRadar)
          RegBusRdDataRadar_1t  <= RadarFifoRdData;
        if(RegBusSelRB)
          RegBusRdDataRB_1t     <= RegBusRdDataRB;
        if(RegBusSelRC)
          RegBusRdDataRC_1t     <= RegBusRdDataRC;
      end
      // There is wait state when reading AGC memory
      if(RegBusRdDataAGCMEM_Valid)
        RegBusRdDataAGCMEM_1t <= RegBusRdDataAGCMEM;
      else if (RegBusReady==1'b1)
        RegBusRdDataAGCMEM_1t <= 32'd0; // so that OR can be used below

    end
    
  assign RegBusRdData = RegBusRdDataRadar_1t   | 
                        RegBusRdDataRB_1t      |
                        RegBusRdDataRC_1t      |
                        RegBusRdDataAGCMEM_1t;

  /*****************************************************************************
  * RIU AGC memory controller
  * !!! Designed as the only module inserting wait states on the RegBus !!!
  * If this changes, need to add "RegBusReady from bus" management
  *****************************************************************************/
  RIUAGCMemCtrl u_RIUAGCMemCtrl (
    //Resets
    .nRegBusRst       (nRegBusRst),
    .nAGCRst          (nAGCRst),
    //regbus
    .RegBusClk        (RegBusClk),
    .AGCMemGClk       (AGCMemGClk),
    //RIU registers
    .AgcRegAgcFsmReset(AgcRegAgcFsmReset),
`ifdef RW_NX_FIQ_COMP_EN
    .CfgRegfIQCalEn   (CfgRegfIQCalEn),
`endif // RW_NX_FIQ_COMP_EN
    //registers bank bus
    .RegBusSelAGCMEM  (RegBusSelAGCMEM),
    .RegBusAddr       (RegBusAddr[10:0]),
    .RegBusWrEn       (RegBusWrEn),
    .RegBusRdEn       (RegBusRdEn),
    .RegBusWrData     (RegBusWrData),
    .RegBusRdData     (RegBusRdDataAGCMEM),
    .RegBusReady      (RegBusReady),
    .RegBusRdDataValid(RegBusRdDataAGCMEM_Valid),
    //HDMCore
    .AGCOn            (AgcOnSync),
    //AGC memory control from RIUCore
    .RIUAGCMemAddr    (AGCMemAddrInt),
    // fIQ interface
`ifdef RW_NX_FIQ_COMP_EN
    .fIQMemAddr(      fIQMemAddr),
    .fIQMemRdEn(      fIQMemRdEn),
    .fIQMemWrEn(      fIQMemWrEn),
    .fIQMemWrData(    fIQMemWrData),
`endif // RW_NX_FIQ_COMP_EN
    //AGC memory
    .AGCMemRdData     (AGCMemRdData),
    .AGCMemAddr       (AGCMemAddr),
    .AGCMemEn         (AGCMemEn),
    .AGCMemWrEn       (AGCMemWrEn),
    .AGCMemWrData     (AGCMemWrData)
  );


  /*****************************************************************************
  * register bank
  *****************************************************************************/
  RIUKarst_reg U_RIUKarstReg (
    .rst_n(                               nRegBusRst),
    .clk(                                 RegBusClk),
    // RWNXVERSION register.
    .RESERVED     (RESERVED   ),
    .AGCRAMMODE   (AGCRAMMODE ),
    .FIQCOMP      (FIQCOMP    ),
    .IQCOMP       (IQCOMP     ),
    .DSSSCORR     (DSSSCORR   ),
    .AGCSNR       (AGCSNR     ),
    .RADAR        (RADAR      ),
    .DSSSCCK      (DSSSCCK    ),
    .CHBW         (CHBW       ),
    .NSS          (NSS        ),
    .NTX          (NTX        ),
    .NRX          (NRX        ),
    // RWNXDYNAMICCONFIG register.
    .AGCINBDPOWSTARTCAPTUREIn(            1'b0),
    .AGCINBDPOWSTARTCAPTUREInValid(       AGCInbdPowStartCaptureInValid),
`ifdef RW_NX_IQ_COMP_EN               
    // RWNXFERXIQESTCLR register.
    .statusIQESTITERCLR(                  1'b0),
`endif // RW_NX_IQ_COMP_EN               
`ifdef RW_NX_FIQ_COMP_EN              
    // RWNXFEFIQCOEFFUPDATE register.
    .FIQCOEFFUPDATEIn(                    1'b0), // Automatic reset by HW
    .FIQCOEFFUPDATEInValid(               RegfIQCoeffUpdateInValid),
    // RWNXFEFIQCOEFFREQ register.
    .FIQCOEFFREQIn(                       1'b0), // Automatic reset by HW
    .FIQCOEFFREQInValid(                  RegfIQCoeffReqInValid),
    // RWNXFEFIQSTART register.
    .statusFIQESTSTART(                   1'b0), // Always read as zero
    .statusFIQCOLLSTART(                  1'b0), // Always read as zero
`endif // RW_NX_FIQ_COMP_EN              
    // RWNXMACINTSTATRAW register.
    .IRQMACRADARDETRAW(                   IrqMACRADARDETRAW), 
    .IRQMACCCATIMEOUTRAW(                 IrqMACCCATIMEOUTRAW), 
    // RWNXMACINTSTATMASKED register.
    .IRQMACRADARDETMASKED(                IrqMACRADARDETMASKED), 
    .IRQMACCCATIMEOUTMASKED(              IrqMACCCATIMEOUTMASKED), 
    // RWNXMACINTGEN register.
    .statusIRQMACRADARDETGEN(             1'b0), 
    .statusIRQMACCCATIMEOUTGEN(           1'b0), 
    // AGCGAINSTAT register.
    .AGCGAIN0(                            RxGainAnt0Sync),
`ifdef RW_NX_DERIV_FE_PATH1
    .AGCGAIN1(                            RxGainAnt1Sync),
`else
    .AGCGAIN1(                            8'b0),
`endif
    // AGCADCPOWSTAT register.
    .ADCPOWDBV0(                          ADCPowqdBVAnt0Sync[8:2]),
`ifdef RW_NX_DERIV_FE_PATH1
    .ADCPOWDBV1(                          ADCPowqdBVAnt1Sync[8:2]),
`else
    .ADCPOWDBV1(                          7'b0),
`endif
    // AGCINBDPOW20PSTAT register.
    .INBDPOW20PDBM0(                      InBd20PowqdBmAnt0Sync[9:2]),
`ifdef RW_NX_DERIV_FE_PATH1
    .INBDPOW20PDBM1(                      InBd20PowqdBmAnt1Sync[9:2]),
`else
    .INBDPOW20PDBM1(                      8'b0),
`endif
    // AGCDIGGAIN0STAT register.
    .DIGGAIN80ANT0(                       DigGaindB80Ant0Sync),
    .DIGGAIN40ANT0(                       DigGaindB40Ant0Sync),
    .DIGGAIN20ANT0(                       DigGaindB20Ant0Sync),
    // AGCDIGGAIN1STAT register.
`ifdef RW_NX_DERIV_FE_PATH1
    .DIGGAIN80ANT1(                       DigGaindB80Ant1Sync),
    .DIGGAIN40ANT1(                       DigGaindB40Ant1Sync),
    .DIGGAIN20ANT1(                       DigGaindB20Ant1Sync),
`else
    .DIGGAIN80ANT1(                       7'b0),
    .DIGGAIN40ANT1(                       7'b0),
    .DIGGAIN20ANT1(                       7'b0),
`endif
`ifdef RW_RADAR_EN                    
    // RADARFIFOSTAT register.
    .RADFIFOEMPTY(                        RadarFifoEmpty), 
`endif // RW_RADAR_EN                    
    // AGCINBDPOW20PNOISESTAT register.
    .INBDPOW20PNOISEDBM0(                 InbdPow20PNoisedBm0Sync[9:2]),
`ifdef RW_NX_DERIV_FE_PATH1
    .INBDPOW20PNOISEDBM1(                 InbdPow20PNoisedBm1Sync[9:2]),
`else
    .INBDPOW20PNOISEDBM1(                 8'b0),
`endif
    // AGCINBDPOWSECSTAT register.
    .INBDPOW40SDBM(                       InbdPow40SdBmSync[9:2]),
    .INBDPOW20SDBM(                       InbdPow20SdBmSync[9:2]),
    // AGCINBDPOWSECNOISESTAT register.
    .INBDPOW40SNOISEDBM(                  InbdPow40SNoisedBmSync[9:2]),
    .INBDPOW20SNOISEDBM(                  InbdPow20SNoisedBmSync[9:2]),
`ifdef RW_NX_IQ_COMP_EN
    // RWNXFERXIQSTATVARI0 register.
    .RXIQVARI0(                           StRegRxIQEstVarI0Sync),
    // RWNXFERXIQSTATVARQ0 register.
    .RXIQVARQ0(                           StRegRxIQEstVarQ0Sync),
    // RWNXFERXIQSTATMIQ0 register.
    .RXIQSTATMIQ0(                        StRegRxIQEstMIQ0Sync),
    // RWNXFERXIQSTAT0 register.
    .RXIQSTATPHASE0(                      StRegRxIQEstIQPhaseEst0Sync),
    .RXIQSTATGAIN0(                       StRegRxIQEstIQGainEst0Sync),
`ifdef RW_NX_DERIV_FE_PATH1
    // RWNXFERXIQSTATVARI1 register.
    .RXIQVARI1(                           StRegRxIQEstVarI1Sync),
    // RWNXFERXIQSTATVARQ1 register.
    .RXIQVARQ1(                           StRegRxIQEstVarQ1Sync),
    // RWNXFERXIQSTATMIQ1 register.
    .RXIQSTATMIQ1(                        StRegRxIQEstMIQ1Sync),
    // RWNXFERXIQSTAT1 register.
    .RXIQSTATPHASE1(                      StRegRxIQEstIQPhaseEst1Sync),
    .RXIQSTATGAIN1(                       StRegRxIQEstIQGainEst1Sync),
`else
    // RWNXFERXIQSTATVARI1 register.
    .RXIQVARI1(                           22'b0),
    // RWNXFERXIQSTATVARQ1 register.
    .RXIQVARQ1(                           22'b0),
    // RWNXFERXIQSTATMIQ1 register.
    .RXIQSTATMIQ1(                        23'b0),
    // RWNXFERXIQSTAT1 register.
    .RXIQSTATPHASE1(                      9'b0),
    .RXIQSTATGAIN1(                       11'b0),
`endif
`endif // RW_NX_IQ_COMP_EN
`ifdef RW_NX_FIQ_COMP_EN              
    // RWNXFEFIQDONE register.
    .FIQESTDONE                 (StRegfIQEstDone),
    .FIQCOLLDONE                (StRegfIQCollDone),
    // RWNXFEFIQSTAT0 register.
    .FIQTXESTERROR0             (StRegfIQTxEstError0),
    .FIQRXESTERROR0             (StRegfIQRxEstError0),
`ifdef RW_NX_DERIV_FE_PATH1
    // RWNXFEFIQSTAT1 register.
    .FIQTXESTERROR1             (StRegfIQTxEstError1),
    .FIQRXESTERROR1             (StRegfIQRxEstError1),
`else
    .FIQTXESTERROR1             (13'd0),
    .FIQRXESTERROR1             (13'd0),
`endif
    // RWNXFEFIQSTATCOEFF0 register.
    .FIQSTATCOEFF0              (StRegfIQCoeff0),
    // RWNXFEFIQSTATCOEFF1 register.
    .FIQSTATCOEFF1              (StRegfIQCoeff1),
    // RWNXFEFIQSTATCOEFF2 register.
    .FIQSTATCOEFF2              (StRegfIQCoeff2),
    // RWNXFEFIQSTATCOEFF3 register.
    .FIQSTATCOEFF3              (StRegfIQCoeff3),
    // RWNXFEFIQSTATCOEFF4 register.
    .FIQSTATCOEFF4              (StRegfIQCoeff4),
    // RWNXFEFIQSTATCOEFF5 register.
    .FIQSTATCOEFF5              (StRegfIQCoeff5),
    // RWNXFEFIQSTATCOEFF6 register.
    .FIQSTATCOEFF6              (StRegfIQCoeff6),
    // RWNXFEFIQSTATCOEFF7 register.
    .FIQSTATCOEFF7              (StRegfIQCoeff7),
    // RWNXFEFIQSTATCOEFF8 register.
    .FIQSTATCOEFF8              (StRegfIQCoeff8),
    // RWNXFEFIQSTATCOEFF9 register.
    .FIQSTATCOEFF9              (StRegfIQCoeff9),
    // RWNXFEFIQSTATCOEFF10 register.
    .FIQSTATCOEFF10             (StRegfIQCoeff10),
    // RWNXFEFIQSTATCOEFF11 register.
    .FIQSTATCOEFF11             (StRegfIQCoeff11),
    // RWNXFEFIQSTATCOEFF12 register.
    .FIQSTATCOEFF12             (StRegfIQCoeff12),
    // RWNXFEFIQSTATCOEFF13 register.
    .FIQSTATCOEFF13             (StRegfIQCoeff13),
    // RWNXFEFIQSTATCOEFF14 register.
    .FIQSTATCOEFF14             (StRegfIQCoeff14),
    // RWNXFEFIQSTATCOEFF15 register.
    .FIQSTATCOEFF15             (StRegfIQCoeff15),
    // RWNXFEFIQSTATCOEFF16 register.
    .FIQSTATCOEFF16             (StRegfIQCoeff16),
    // RWNXFEFIQSTATCOEFF17 register.
    .FIQSTATCOEFF17             (StRegfIQCoeff17),
    // RWNXFEFIQSTATCOEFF18 register.
    .FIQSTATCOEFF18             (StRegfIQCoeff18),
    // RWNXFEFIQSTATCOEFF19 register.
    .FIQSTATCOEFF19             (StRegfIQCoeff19),
`endif // RW_NX_FIQ_COMP_EN    
    // RWNXSTATICCONFIG register.
    .ACTIVEANT(                           CfgRegActiveAnt),
    // RWNXDYNAMICCONFIG register.
    .AGCINBDPOWSTARTCAPTURE(              CfgRegAGCInbdPowStartCapture),
    // RWNXIQCTRL register.
    .TXIQSWAPPATH0(                       CfgRegTxIQSwapPath0),
    .RXIQSWAPPATH0(                       CfgRegRxIQSwapPath0),
    .TXIQDELPATHQ0(                       CfgRegTxIQDelPathQ0),
    .TXIQDELPATHI0(                       CfgRegTxIQDelPathI0),
    .RXIQDELPATHQ0(                       CfgRegRxIQDelPathQ0),
    .RXIQDELPATHI0(                       CfgRegRxIQDelPathI0),
`ifdef RW_NX_DERIV_FE_PATH1
    .TXIQSWAPPATH1(                       CfgRegTxIQSwapPath1),
    .RXIQSWAPPATH1(                       CfgRegRxIQSwapPath1),
    .TXIQDELPATHQ1(                       CfgRegTxIQDelPathQ1),
    .TXIQDELPATHI1(                       CfgRegTxIQDelPathI1),
    .RXIQDELPATHQ1(                       CfgRegRxIQDelPathQ1),
    .RXIQDELPATHI1(                       CfgRegRxIQDelPathI1),
`else
    .TXIQSWAPPATH1(                       ),
    .RXIQSWAPPATH1(                       ),
    .TXIQDELPATHQ1(                       ),
    .TXIQDELPATHI1(                       ),
    .RXIQDELPATHQ1(                       ),
    .RXIQDELPATHI1(                       ),
`endif
    .TXC2SDISBCFG(                        CfgRegTxC2sDisb),
    .RXC2SDISBCFG(                        CfgRegRxC2sDisb),
    // RWNXMACSTATICCONFIG register.
    .PSSELECT(                            ),
    // RWNXFECTRL0 register.
    .TX80DIGGAINLIN0(                     CfgRegTx80DigGainLin0),
    .TX40DIGGAINLIN0(                     CfgRegTx40DigGainLin0),
    .TX20DIGGAINLIN0(                     CfgRegTx20DigGainLin0),
    // RWNXFECTRL1 register.
`ifdef RW_NX_DERIV_FE_PATH1
    .TX80DIGGAINLIN1(                     CfgRegTx80DigGainLin1),
    .TX40DIGGAINLIN1(                     CfgRegTx40DigGainLin1),
    .TX20DIGGAINLIN1(                     CfgRegTx20DigGainLin1),
`else
    .TX80DIGGAINLIN1(                     ),
    .TX40DIGGAINLIN1(                     ),
    .TX20DIGGAINLIN1(                     ),
`endif
`ifdef RW_NX_IQ_COMP_EN               
    // RWNXFETXIQCOMP0 register.
    .TXIQPHASECOMPEN0(                    CfgRegTxIQPhaseCompEn0),
    .TXIQGAINCOMPEN0(                     CfgRegTxIQGainCompEn0),
    .TXIQPHASE0(                          CfgRegTxIQPhase0),
    .TXIQGAIN0(                           CfgRegTxIQGain0),
    // RWNXFETXIQCOMP1 register.
`ifdef RW_NX_DERIV_FE_PATH1
    .TXIQPHASECOMPEN1(                    CfgRegTxIQPhaseCompEn1),
    .TXIQGAINCOMPEN1(                     CfgRegTxIQGainCompEn1),
    .TXIQPHASE1(                          CfgRegTxIQPhase1),
    .TXIQGAIN1(                           CfgRegTxIQGain1),
`else
    .TXIQPHASECOMPEN1(                    ),
    .TXIQGAINCOMPEN1(                     ),
    .TXIQPHASE1(                          ),
    .TXIQGAIN1(                           ),
`endif // RW_NX_DERIV_FE_PATH1
    // RWNXFERXIQESTCTRL register.
    .IQESTFOMIN(                          CfgRegRxIQEstFOMin),
    .IQESTBWLIST(                         CfgRegRxIQEstBWList),
    .IQESTMCSMIN(                         CfgRegRxIQEstMCSMin),
    .IQESTSNRMIN(                         CfgRegRxIQEstSNRMin),
    .RXIQPHASEESTEN(                      CfgRegRxIQPhaseEstEn),
    .RXIQGAINESTEN(                       CfgRegRxIQGainEstEn),
    .RXIQPHASECOMPEN(                     CfgRegRxIQPhaseCompEn),
    .RXIQGAINCOMPEN(                      CfgRegRxIQGainCompEn),
    // RWNXFERXIQESTLOOP register.
    .RXIQESTSTEP4(                        CfgRegRxIQEstStepDel4),
    .RXIQESTSTEP3(                        CfgRegRxIQEstStepDel3),
    .RXIQESTSTEP2(                        CfgRegRxIQEstStepDel2),
    .RXIQESTSTEP1(                        CfgRegRxIQEstStepDel1),
    .RXIQESTSTEP0(                        CfgRegRxIQEstStepDel0),
    .RXIQESTPHASESTEPSTOP(                CfgRegRxIQEstPhaseStepStop),
    .RXIQESTPHASESTEPINIT(                CfgRegRxIQEstPhaseStepInit),
    .RXIQESTGAINSTEPSTOP(                 CfgRegRxIQEstGainStepStop),
    .RXIQESTGAINSTEPINIT(                 CfgRegRxIQEstGainStepInit),
    .RXIQESTDEL(                          CfgRegRxIQEstDel),
    // RWNXFERXIQESTCLR register.
    .IQESTITERCLR(                        CfgRegRxIQEstIterClr),
    // RWNXFERXIQCOMP0 register.
    .RXIQPHASE0(                          CfgRegRxIQPhase0),
    .RXIQGAIN0(                           CfgRegRxIQGain0),
    // RWNXFERXIQCOMP1 register.
`ifdef RW_NX_DERIV_FE_PATH1
    .RXIQPHASE1(                          CfgRegRxIQPhase1),
    .RXIQGAIN1(                           CfgRegRxIQGain1),
`else
    .RXIQPHASE1(                          ),
    .RXIQGAIN1(                           ),
`endif // RW_NX_DERIV_FE_PATH1
`endif // RW_NX_IQ_COMP_EN
`ifdef RW_NX_FIQ_COMP_EN              
    // RWNXFEFIQCTRL register.
`ifdef RW_NX_DERIV_FE_PATH1
    .FIQPATHSEL(                          CfgRegfIQPathSel),
`else
    .FIQPATHSEL(                          ),
`endif // RW_NX_DERIV_FE_PATH1
    .FIQTXRX(                             CfgRegfIQTxRx),
    .FIQRXBYPASS(                         CfgRegfIQRxBypass),
    .FIQTXBYPASS(                         CfgRegfIQTxBypass),
    .FIQCALEN(                            CfgRegfIQCalEn),
    // RWNXFEFIQCOLL register.
    .FIQCOLLWROFFSET(                     CfgRegfIQCollWrOffset),
    .FIQCOLLRDOFFSET(                     CfgRegfIQCollRdOffset),
    .FIQCOLLSIZE(                         CfgRegfIQCollSize),
    .FIQCOLLPATH(                         CfgRegfIQCollPath),
    // RWNXFEFIQEST0 register.
    .FIQESTQOFFSET(                       CfgRegfIQEstQOffset),
    .FIQESTIOFFSET(                       CfgRegfIQEstIOffset),
    .FIQESTSIZE(                          CfgRegfIQEstSize),
    // RWNXFEFIQEST1 register.
    .FIQESTSTEP(                          CfgRegfIQEstStep),
    .FIQESTNITE(                          CfgRegfIQEstNite),
    // RWNXFEFIQDEL register.
    .FIQRXDEL(                            CfgRegfIQRxDel),
    .FIQTXDEL(                            CfgRegfIQTxDel),
    .FIQCOLLDEL(                          CfgRegfIQCollDel),
    // RWNXFEFIQCOEFF0 register.
    .FIQCOEFF0(                           CfgRegfIQCoeff0),
    // RWNXFEFIQCOEFF1 register.
    .FIQCOEFF1(                           CfgRegfIQCoeff1),
    // RWNXFEFIQCOEFF2 register.
    .FIQCOEFF2(                           CfgRegfIQCoeff2),
    // RWNXFEFIQCOEFF3 register.
    .FIQCOEFF3(                           CfgRegfIQCoeff3),
    // RWNXFEFIQCOEFF4 register.
    .FIQCOEFF4(                           CfgRegfIQCoeff4),
    // RWNXFEFIQCOEFF5 register.
    .FIQCOEFF5(                           CfgRegfIQCoeff5),
    // RWNXFEFIQCOEFF6 register.
    .FIQCOEFF6(                           CfgRegfIQCoeff6),
    // RWNXFEFIQCOEFF7 register.
    .FIQCOEFF7(                           CfgRegfIQCoeff7),
    // RWNXFEFIQCOEFF8 register.
    .FIQCOEFF8(                           CfgRegfIQCoeff8),
    // RWNXFEFIQCOEFF9 register.
    .FIQCOEFF9(                           CfgRegfIQCoeff9),
    // RWNXFEFIQCOEFF10 register.
    .FIQCOEFF10(                          CfgRegfIQCoeff10),
    // RWNXFEFIQCOEFF11 register.
    .FIQCOEFF11(                          CfgRegfIQCoeff11),
    // RWNXFEFIQCOEFF12 register.
    .FIQCOEFF12(                          CfgRegfIQCoeff12),
    // RWNXFEFIQCOEFF13 register.
    .FIQCOEFF13(                          CfgRegfIQCoeff13),
    // RWNXFEFIQCOEFF14 register.
    .FIQCOEFF14(                          CfgRegfIQCoeff14),
    // RWNXFEFIQCOEFF15 register.
    .FIQCOEFF15(                          CfgRegfIQCoeff15),
    // RWNXFEFIQCOEFF16 register.
    .FIQCOEFF16(                          CfgRegfIQCoeff16),
    // RWNXFEFIQCOEFF17 register.
    .FIQCOEFF17(                          CfgRegfIQCoeff17),
    // RWNXFEFIQCOEFF18 register.
    .FIQCOEFF18(                          CfgRegfIQCoeff18),
    // RWNXFEFIQCOEFF19 register.
    .FIQCOEFF19(                          CfgRegfIQCoeff19),
    // RWNXFEFIQCOEFFUPDATE register.
    .FIQCOEFFUPDATE(                      CfgRegfIQCoeffUpdate),
    // RWNXFEFIQCOEFFREQ register.
    .FIQCOEFFREQ(                         CfgRegfIQCoeffReq),
    // RWNXFEFIQSTART register.
    .FIQESTSTART(                         CfgRegfIQEstStartP),
    .FIQCOLLSTART(                        CfgRegfIQCollStartP),
`endif // RW_NX_FIQ_COMP_EN              
    // RWNXAGCANTLOSS register.
    .RFLOSSANT1DB(                        AgcRegAntLossDB1),
    .RFLOSSANT0DB(                        AgcRegAntLossDB0),
    // RWNXAGCGAINRANGE register.
    .RFGAINMAX4DETDB(                     AgcRegRFGainMax4DetdB),
    .RFGAINMIN4DETDB(                     AgcRegRFGainMin4DetdB),
    .RFGAINMAXDB(                         AgcRegRFGainMaxdB),
    .RFGAINMINDB(                         AgcRegRFGainMindB),
    // RWNXAGCDIGGAINCONF register.
    .DIGGAIN80VS20(                       AgcRegDigGain80vs20),
    .DIGGAIN40VS20(                       AgcRegDigGain40vs20),
    // RWNXAGCNOISECONF register.
    .SNRMEASSEL(                          AgcRegSNRMeasSel),
    // RWNXAGCACI20MARG0 register.
    .ACI20MARGMCS3(                       AgcRegACI20MargMCS3),
    .ACI20MARGMCS2(                       AgcRegACI20MargMCS2),
    .ACI20MARGMCS1(                       AgcRegACI20MargMCS1),
    .ACI20MARGMCS0(                       AgcRegACI20MargMCS0),
    // RWNXAGCACI20MARG1)register.        
    .ACI20MARGMCS7(                       AgcRegACI20MargMCS7),
    .ACI20MARGMCS6(                       AgcRegACI20MargMCS6),
    .ACI20MARGMCS5(                       AgcRegACI20MargMCS5),
    .ACI20MARGMCS4(                       AgcRegACI20MargMCS4),
    // RWNXAGCACI20MARG2)register.        
    .ACI20MARGMCS9(                       AgcRegACI20MargMCS9),
    .ACI20MARGMCS8(                       AgcRegACI20MargMCS8),
    // RWNXAGCACI40MARG0)register.        
    .ACI40MARGMCS3(                       AgcRegACI40MargMCS3),
    .ACI40MARGMCS2(                       AgcRegACI40MargMCS2),
    .ACI40MARGMCS1(                       AgcRegACI40MargMCS1),
    .ACI40MARGMCS0(                       AgcRegACI40MargMCS0),
    // RWNXAGCACI40MARG1)register.        
    .ACI40MARGMCS7(                       AgcRegACI40MargMCS7),
    .ACI40MARGMCS6(                       AgcRegACI40MargMCS6),
    .ACI40MARGMCS5(                       AgcRegACI40MargMCS5),
    .ACI40MARGMCS4(                       AgcRegACI40MargMCS4),
    // RWNXAGCACI40MARG2)register.        
    .ACI40MARGMCS9(                       AgcRegACI40MargMCS9),
    .ACI40MARGMCS8(                       AgcRegACI40MargMCS8),
    // RWNXAGCACI80MARG0)register.        
    .ACI80MARGMCS3(                       AgcRegACI80MargMCS3),
    .ACI80MARGMCS2(                       AgcRegACI80MargMCS2),
    .ACI80MARGMCS1(                       AgcRegACI80MargMCS1),
    .ACI80MARGMCS0(                       AgcRegACI80MargMCS0),
    // RWNXAGCACI80MARG1)register.        
    .ACI80MARGMCS7(                       AgcRegACI80MargMCS7),
    .ACI80MARGMCS6(                       AgcRegACI80MargMCS6),
    .ACI80MARGMCS5(                       AgcRegACI80MargMCS5),
    .ACI80MARGMCS4(                       AgcRegACI80MargMCS4),
    // RWNXAGCACI80MARG2)register.        
    .ACI80MARGMCS9(                       AgcRegACI80MargMCS9),
    .ACI80MARGMCS8(                       AgcRegACI80MargMCS8),
    // RWNXAGCSAT register.
    .SATDELAY50NS(                        AgcRegSatDelayCount),
    .SATHIGHTHRDBV(                       AgcRegSatDynHighThr),
    .SATLOWTHRDBV(                        AgcRegSatLowThr),
    .SATTHRDBV(                           AgcRegSatDynLowThr),
    // RWNXAGCCROSS register.
    .CROSSDNTHRQDBM(                      AgcRegDetFallThrqdBm),
    .CROSSUPTHRQDBM(                      AgcRegDetRiseThrqdBm),
    // RWNXAGCRAMP register.
    .RAMPDNNDLINDEX(                      AgcRegDelRampDownTap),
    .RAMPDNGAPQDB(                        AgcRegDetRampDown),
    .RAMPUPNDLINDEX(                      AgcRegDelRampUpTap),
    .RAMPUPGAPQDB(                        AgcRegDetRampUp),
    // RWNXAGCSTABDIS register.
    .ADCPOWDISNDL(                        AgcRegADCPowDisNdl),
    .ADCPOWDISTHRDBV(                     AgcRegADCPowDisThrdBV),
    .PLATNDLINDEX(                        AgcRegDelPlatTap),
    .PLATDPQDB(                           AgcRegDetPlat),
    // RWNXAGCDCCOMP0 register.
    .DCDSSSTYPE(                          AgcRegDC4DSSSCompType),
    .DCCENTEREDTYPE(                      AgcRegDC4CenteredCompType),
    .DCAGC20TYPE(                         AgcRegDC4PrimaryCompType),
    .DCADCTYPE(                           AgcRegDC4ADCCompType),
    .DCADCHOLDTIME50NS(                   AgcRegDC4ADCHoldTime),
    .DCADCZEROTIME50NS(                   AgcRegDC4ADCZeroTime),
    // RWNXAGCDCCOMP1 register.
    .DCCENTEREDHOLDTIME50NS(              AgcRegDC4CenteredHoldTime),
    .DCCENTEREDZEROTIME50NS(              AgcRegDC4CenteredZeroTime),
    .DCAGC20HOLDTIME50NS(                 AgcRegDC4PrimaryHoldTime),
    .DCAGC20ZEROTIME50NS(                 AgcRegDC4PrimaryZeroTime),
    // RWNXAGCDCCOMP2 register.
    .DCDSSSHOLDTIME50NS(                  AgcRegDC4DSSSHoldTime),
    .DCDSSSZEROTIME50NS(                  AgcRegDC4DSSSZeroTime),
    .DELDCSTABLECC(                       AgcRegDelStableDC),
    // RWNXAGCEVT0 register.
    .EVT0OP3(                             AgcRegFsmEvent0[31:26]),
    .EVT0OP2(                             AgcRegFsmEvent0[25:20]),
    .EVT0OP1(                             AgcRegFsmEvent0[19:14]),
    .EVT0PATHCOMB(                        AgcRegFsmEvent0[13]),
    .EVT0OPCOMB(                          AgcRegFsmEvent0[12:10]),
    .EVT0TGTADD(                          AgcRegFsmEvent0[8:0]),
    // RWNXAGCEVT1 register.
    .EVT1OP1(                             AgcRegFsmEvent1[31:26]),
    .EVT1OP2(                             AgcRegFsmEvent1[25:20]),
    .EVT1OP3(                             AgcRegFsmEvent1[19:14]),
    .EVT1PATHCOMB(                        AgcRegFsmEvent1[13]),
    .EVT1OPCOMB(                          AgcRegFsmEvent1[12:10]),
    .EVT1TGTADD(                          AgcRegFsmEvent1[8:0]),
    // RWNXAGCEVT2 register.
    .EVT2OP1(                             AgcRegFsmEvent2[31:26]),
    .EVT2OP2(                             AgcRegFsmEvent2[25:20]),
    .EVT2OP3(                             AgcRegFsmEvent2[19:14]),
    .EVT2PATHCOMB(                        AgcRegFsmEvent2[13]),
    .EVT2OPCOMB(                          AgcRegFsmEvent2[12:10]),
    .EVT2TGTADD(                          AgcRegFsmEvent2[8:0]),
    // RWNXAGCEVT3 register.
    .EVT3OP1(                             AgcRegFsmEvent3[31:26]),
    .EVT3OP2(                             AgcRegFsmEvent3[25:20]),
    .EVT3OP3(                             AgcRegFsmEvent3[19:14]),
    .EVT3PATHCOMB(                        AgcRegFsmEvent3[13]),
    .EVT3OPCOMB(                          AgcRegFsmEvent3[12:10]),
    .EVT3TGTADD(                          AgcRegFsmEvent3[8:0]),
    // RWNXAGCCNTL0 register.
    .HTSTFGAINEN(                         AgcRegHTSTFGainEn),
    .AGCFSMRESET(                         AgcRegAgcFsmReset),
    .RADARDETEN(                          AgcRegRadarDetEn),
    .RIFSDETEN(                           AgcRegRifsDetEn),
    .DSSSONLY(                            AgcRegModeB),
    .OFDMONLY(                            AgcRegModeA),
    .GPSTATUS(                            AgcRegGPSetting),
    .COMBPATHSEL(                         AgcRegChCombMode),
    // RWNXAGCDSP0 register.
    .NBITADC(                             AgcRegNBitAdc),
    .VPEAKADCQDBV(                        AgcRegVPeakADCqdBV),
    .ADCPOWMINDBV(                        AgcRegADCdBVThr),
    .ADCPOWBIASQDBV(                      AgcRegADCPowBiasqdBV),
    // RWNXAGCDSP1 register.
    .ADCPOWMINDBM(                        AgcRegADCdBmThr),
    .ADCPOWBIASQDBM(                      AgcRegADCPowBiasqdBm),
    // RWNXAGCDSP2 register.
    .INBDPOW40SBIASQDB(                   AgcRegInBd40SPowBiasqdBm),
    .INBDPOW20SBIASQDB(                   AgcRegInBd20SPowBiasqdBm),
    .INBDPOW20PBIASQDB(                   AgcRegInBd20PPowBiasqdBm),
    // RWNXAGCDSP3 register.
    .INBDPOWMINDBV(                       AgcRegInBddBVThr),
    .INBDRND(                             AgcRegInBdRnd),
    .INBDPOWMINDBM(                       AgcRegInBddBmThr),
    // RWNXAGCDSP4 register.
    .FE40GAIN(                            AgcRegFE40Gain),
    .FE20GAIN(                            AgcRegFE20Gain),
    // RWNXAGCCCA0 register.
    .DELCCARAMPDNTAP(                     AgcRegDelCCARampDownTap),
    .DELCCARAMPUPTAP(                     AgcRegDelCCARampUpTap),
    .CCADETRAMPDN(                        AgcRegCCADetRampDown),
    .CCADETRAMPUP(                        AgcRegCCADetRampUp),
    // RWNXAGCCCA1 register.
    .INBDCCA20PPOWMINDBM(                 AgcRegInbdCCA20PPowMindBm),
    .CCA20PFALLTHRDBM(                    AgcRegCCA20PFallThrdBm),
    .DISCCAEN(                            AgcRegDisCCAEn),
    .SATCCAEN(                            AgcRegSatCCAEn),
    .CCA20PRISETHRDBM(                    AgcRegCCA20PRiseThrdBm),
    // RWNXAGCCCACTRL register.
    .CCAFLAG3CTRL(                        AgcRegCCAFlag3Ctrl),
    .CCAFLAG2CTRL(                        AgcRegCCAFlag2Ctrl),
    .CCAFLAG1CTRL(                        AgcRegCCAFlag1Ctrl),
    .CCAFLAG0CTRL(                        AgcRegCCAFlag0Ctrl),
    .ANTSELCCA40S(                        AgcRegAntSelCCA40s),
    .ANTSELCCA20S(                        AgcRegAntSelCCA20s),
    .CCADEMOD(                            AgcRegCCADemod),
    .CCACSEN(                             AgcRegCCACSEn),
    .CCARAMPUDEN(                         AgcRegCCARampUDen),
    .CCAENERGYEN(                         AgcRegCCAEnergyEn),
    // RWNXAGCCCASTATE0 register.
    .RXSTATECCA20SSEL(                    AgcRegRxStateCca20SSel),
    .RXSTATECCA20PSEL(                    AgcRegRxStateCca20PSel),
    // RWNXAGCCCASTATE1 register.
    .RXSTATECCA40SSEL(                    AgcRegRxStateCca40SSel),
    // RWNXAGCCCATIMEOUT register.
    .CCATIMEOUT(                          AgcRegCCATimeOut),
    // RWNXAGCCOMP0 register.
    .IDINBDPOWGAPDNQDBM(                  AgcRegIdInbdPowGapDnqdBm),
    .IDINBDPOWGAPUPQDBM(                  AgcRegIdInbdPowGapUpqdBm),
    .INBDPOWINFTHRDBM(                    AgcRegInbdPowInfThrdBm),
    .INBDPOWSUPTHRDBM(                    AgcRegInbdPowSupThrdBm),
    // RWNXAGCCOMP1 register.
    .ADCPOWINFTHRDBV(                     AgcRegADCPowInfThrdBV),
    .ADCPOWSUPTHRDBV(                     AgcRegADCPowSupThrdBV),
    .ADCPOWINFTHRDBM(                     AgcRegADCPowInfThrdBm),
    .ADCPOWSUPTHRDBM(                     AgcRegADCPowSupThrdBm),
`ifdef RW_RADAR_EN                    
    // RWNXAGCRADAR register.
    .ANTSELRADAR(                         AgcRegAntSelRadar),
    .FREQSINGGAP(                         AgcRegFreqSingGap),
    .FREQSING(                            AgcRegFreqSing),
    .FOMSINGGAP(                          AgcRegFomSingGap),
    .FOMSING(                             AgcRegFomSing),
    // RWNXAGCRADARTIM register.
    .PULSETIMERCLEAR(                     AgcRegPulseTimerClear),
    .PULSEIRQFIFOTHR(                     AgcRegPulseIrqFifoThr),
    .PULSEIRQTIMEOUT(                     AgcRegPulseIrqTimeOut),
    // RWNXAGCDCCOMPRADAR register.
    .DCRADARTYPE(                         AgcRegDC4RadarCompType),
    .DCRADARHOLDTIME50NS(                 AgcRegDC4RadarHoldTime),
    .DCRADARZEROTIME50NS(                 AgcRegDC4RadarZeroTime),
`endif // RW_RADAR_EN
    // RWNXAGCCCA2 register.
    .INBDCCA20SPOWMINDBM(                 AgcRegInbdCCA20SPowMindBm),
    .CCA20SFALLTHRDBM(                    AgcRegCCA20SFallThrdBm),
    .CCA20SRISETHRDBM(                    AgcRegCCA20SRiseThrdBm),
    // RWNXAGCCCA3 register.
    .INBDCCA40SPOWMINDBM(                 AgcRegInbdCCA40SPowMindBm),
    .CCA40SFALLTHRDBM(                    AgcRegCCA40SFallThrdBm),
    .CCA40SRISETHRDBM(                    AgcRegCCA40SRiseThrdBm),
    // RWNXMACINTEN register.
    .IRQMACRADARDETEN(                    IrqRegMACRADARDETEN),
    .IRQMACCCATIMEOUTEN(                  IrqRegMACCCATIMEOUTEN),
    // RWNXMACINTACK register.
    .IRQMACRADARDETACK(                   IrqRegMACRADARDETACK),
    .IRQMACCCATIMEOUTACK(                 IrqRegMACCCATIMEOUTACK),
    // RWNXMACINTGEN register.
    .IRQMACRADARDETGEN(                   IrqRegMACRADARDETGEN),
    .IRQMACCCATIMEOUTGEN(                 IrqRegMACCCATIMEOUTGEN),
`ifdef RW_NX_DERIV_80211B             
    // RWNXFEDSSSCCKCNTL register.
    .RXPATHSELFROMREG(                    CfgRegRxPathSelFromReg),
    .BRXPATHSELREG(                       CfgRegBRxPathSel),
    .RXSHIFT4044(                         CfgRegBRxShift),
    .TXSHIFT4044(                         CfgRegBTxShift),
`endif // RW_NX_DERIV_80211B             
    // regbus interface
    .regbus_sel(                          RegBusSelRB),
    .regbus_rden(                         RegBusRdEn),
    .regbus_wren(                         RegBusWrEn),
    .regbus_addr(                         RegBusAddr[10:0]),
    .regbus_wdata(                        RegBusWrData),
    .regbus_rdata(                        RegBusRdDataRB) 
  );

`ifndef RW_RADAR_EN
  assign DbgBank8        = 16'b0;
  assign RadarIrq        = 1'b0;
  assign RadarIrqSync    = 1'b0;
  assign RadarFifoRdData = 32'b0;
`endif // RW_RADAR_EN

`ifndef RW_NX_DERIV_80211B
  assign CfgRegRxPathSelFromReg = 1'b0;
  assign CfgRegBRxPathSel       = 2'b0;
  assign CfgRegBRxShift         = 3'b0;
  assign CfgRegBTxShift         = 2'b0;
`endif // RW_NX_DERIV_80211B             
 
  /*****************************************************************************
  * interrupt resynchro
  *****************************************************************************/
  /* resync from agc clk to regbus clk */
  ClkSyncPulse2Pulse U_CCATimeOutErrSync 
  ( 
    .srcclk(         AGCGClk),
    .srcresetn(      nAGCRst),
    .dstclk(         RegBusClk),
    .dstresetn(      nRegBusRst),
    .srcdata(        CCATimeOutErrIrq),
    .dstdata(        CCATimeOutErrIrqSync)
  );

`ifdef RW_RADAR_EN
  /* resync radar clk to regbus clk*/
  ClkSyncPulse2Pulse U_RadarIrqSync 
  ( 
    .srcclk(         RadarTimGClk),
    .srcresetn(      nRadarTimRst),
    .dstclk(         RegBusClk),
    .dstresetn(      nRegBusRst),
    .srcdata(        RadarIrq),
    .dstdata(        RadarIrqSync)
  );
`endif // RW_RADAR_EN
  
  always @(posedge RegBusClk, negedge nRegBusRst)
  begin
    if(!nRegBusRst)
    begin
      IrqMACRADARDETRAW   <= 1'b0;
      IrqMACCCATIMEOUTRAW <= 1'b0;
    end
    else
    begin
      // Radar detection FLAG 
      if(IrqRegMACRADARDETACK)
        IrqMACRADARDETRAW <= 1'b0;
      else if(RadarIrqSync || IrqRegMACRADARDETGEN)
        IrqMACRADARDETRAW <= 1'b1;

      // CCA time-out FLAG 
      if(IrqRegMACCCATIMEOUTACK)
        IrqMACCCATIMEOUTRAW <= 1'b0;
      else if(CCATimeOutErrIrqSync || IrqRegMACCCATIMEOUTGEN)
        IrqMACCCATIMEOUTRAW <= 1'b1;
    end
  end

  assign IrqMACRADARDETMASKED   = IrqMACRADARDETRAW   & IrqRegMACRADARDETEN;
  assign IrqMACCCATIMEOUTMASKED = IrqMACCCATIMEOUTRAW & IrqRegMACCCATIMEOUTEN;
  assign nInterrupt             = ~(IrqMACRADARDETMASKED | IrqMACCCATIMEOUTMASKED);

  /*****************************************************************************
  * RIUCore
  *****************************************************************************/
`ifdef RW_NX_FIQ_COMP_EN

  // regbus <-> FE fIQ start/done resync
  StartDoneHandler U_fIQCollStartDoneHandler (
    .SrcClk     (RegBusClk),
    .nSrcRst    (nRegBusRst),
    .DstClk     (FETxRxPath0GClk),
    .nDstRst    (nFERst),
    .SrcStartP  (CfgRegfIQCollStartP),
    .DstStartP  (fIQCollStartP),
    .DstDone    (fIQCollDone),
    .SrcDone    (StRegfIQCollDone)
  );

  StartDoneHandler U_fIQEstStartDoneHandler (
    .SrcClk     (RegBusClk),
    .nSrcRst    (nRegBusRst),
    .DstClk     (FETxRxPath0GClk),
    .nDstRst    (nFERst),
    .SrcStartP  (CfgRegfIQEstStartP),
    .DstStartP  (fIQEstStartP),
    .DstDone    (fIQEstDone),
    .SrcDone    (StRegfIQEstDone)
  );
  
  // regbus -> FE fIQ coefficients resync

  // Resync of update request to FE
  // CfgRegfIQCoeffUpdate is written last by SW and ensures that all coefficient values,
  // as well as fIQTxRx and fIQPathSel are static when sampled
  always @(posedge RegBusClk, negedge nRegBusRst)
    if(!nRegBusRst) begin
      RegfIQCoeffUpdate      <= 1'b0;
      RegfIQCoeffUpdateDoneD <= 1'b0;
    end else begin
      RegfIQCoeffUpdateDoneD <= RegfIQCoeffUpdateDone;
      if (RegfIQCoeffUpdateDoneD==1'b1)
        RegfIQCoeffUpdate    <= 1'b0;
      else if (CfgRegfIQCoeffUpdate==1'b1)
        RegfIQCoeffUpdate    <= 1'b1;
    end
  // CfgRegfIQCoeffUpdate is only reset when Update signals in both clock domains are back to zero.
  assign RegfIQCoeffUpdateInValid = RegfIQCoeffUpdateDoneD & ~RegfIQCoeffUpdateDone;
  
  ClkSyncSimple U_fIQCoeffUpdateSync ( 
    .dstclk     (FETxRxPath0GClk),
    .dstresetn  (nFERst),
    .srcdata    (RegfIQCoeffUpdate),
    .dstdata    (fIQCoeffUpdate)
  );
  
  // Resync of write done to regbus
  ClkSyncSimple U_fIQCoeffDoneSync ( 
    .dstclk     (RegBusClk),
    .dstresetn  (nRegBusRst),
    .srcdata    (fIQCoeffUpdate),
    .dstdata    (RegfIQCoeffUpdateDone)
  );

  // FE -> regbus fIQ stat errors resync
  fIQStatHandler U_fIQStatHandler0 (
    .SrcClk             (FETxRxPath0GClk),
    .nSrcRst            (nFERst),
    .DstClk             (RegBusClk),
    .nDstRst            (nRegBusRst),
    .fIQStatToggle      (fIQStatToggle0),
    .fIQRxEstError      (fIQRxEstError0),
    .fIQTxEstError      (fIQTxEstError0),
    .StRegfIQRxEstError (StRegfIQRxEstError0),
    .StRegfIQTxEstError (StRegfIQTxEstError0)
  );
  
`ifdef RW_NX_DERIV_FE_PATH1
  fIQStatHandler U_fIQStatHandler1 (
    .SrcClk             (FETxRxPath0GClk), // FETxRxPath0GClk is the clock used for calibration, FETxRxPath1GClk is used only for compensation 
    .nSrcRst            (nFERst),
    .DstClk             (RegBusClk),
    .nDstRst            (nRegBusRst),
    .fIQStatToggle      (fIQStatToggle1),
    .fIQRxEstError      (fIQRxEstError1),
    .fIQTxEstError      (fIQTxEstError1),
    .StRegfIQRxEstError (StRegfIQRxEstError1),
    .StRegfIQTxEstError (StRegfIQTxEstError1)
  );
`endif //  RW_NX_DERIV_FE_PATH1

  
  // FE -> regbus fIQ stat coefficients resync
  
  // Simple resync of read request to FE
  // CfgRegfIQCoeffReq is written last by SW and ensures that all coefficient values,
  // as well as fIQTxRx and fIQPathSel are stable when coefficients are sampled
  ClkSyncSimple U_fIQStatCoeffReqSync ( 
    .dstclk     (FETxRxPath0GClk),
    .dstresetn  (nFERst),
    .srcdata    (CfgRegfIQCoeffReq),
    .dstdata    (fIQCoeffReq)
  );

  
  ClkSyncParam  
  #(
    .PARAMSIZE(     320)
  ) 
  U_fIQ2CfgRegStatCoeffResync (
    .dstclk(       RegBusClk),
    .dstresetn(    nRegBusRst),
    .srcupdate(    fIQCoeffReq),
    .srcdata(      {fIQStatCoeff0,
                    fIQStatCoeff1,
                    fIQStatCoeff2,
                    fIQStatCoeff3,
                    fIQStatCoeff4,
                    fIQStatCoeff5,
                    fIQStatCoeff6,
                    fIQStatCoeff7,
                    fIQStatCoeff8,
                    fIQStatCoeff9,
                    fIQStatCoeff10,
                    fIQStatCoeff11,
                    fIQStatCoeff12,
                    fIQStatCoeff13,
                    fIQStatCoeff14,
                    fIQStatCoeff15,
                    fIQStatCoeff16,
                    fIQStatCoeff17,
                    fIQStatCoeff18,
                    fIQStatCoeff19
                   }),
    .dstupdate(    RegfIQCoeffReqInValid),
    .dstdata(      {StRegfIQCoeff0,
                    StRegfIQCoeff1,
                    StRegfIQCoeff2,
                    StRegfIQCoeff3,
                    StRegfIQCoeff4,
                    StRegfIQCoeff5,
                    StRegfIQCoeff6,
                    StRegfIQCoeff7,
                    StRegfIQCoeff8,
                    StRegfIQCoeff9,
                    StRegfIQCoeff10,
                    StRegfIQCoeff11,
                    StRegfIQCoeff12,
                    StRegfIQCoeff13,
                    StRegfIQCoeff14,
                    StRegfIQCoeff15,
                    StRegfIQCoeff16,
                    StRegfIQCoeff17,
                    StRegfIQCoeff18,
                    StRegfIQCoeff19
                    })
  );

`endif // RW_NX_FIQ_COMP_EN

  // Simple resync to regbus
  ClkSyncSimple U_StatusTrigReqSync ( 
    .dstclk     (RegBusClk),
    .dstresetn  (nRegBusRst),
    .srcdata    (StatusTrigReq),
    .dstdata    (StatusTrigReqSync)
  );

  ClkSyncParam  
  #(
`ifdef RW_NX_DERIV_FE_PATH1
    .PARAMSIZE(     58)
`else
    .PARAMSIZE(     39)
`endif
  ) 
  u_agc2ahbParamResync_1 (
    .dstclk(       RegBusClk),
    .dstresetn(    nRegBusRst),
    .srcupdate(    AGCP2Update),
    .srcdata(      {InbdPow40SdBm,
                    InbdPow20SdBm,
                    InBd20PowqdBmAnt0,
                    ADCPowqdBVAnt0
`ifdef RW_NX_DERIV_FE_PATH1
                    ,
                    ADCPowqdBVAnt1,
                    InBd20PowqdBmAnt1
`endif
                    }),
    .dstupdate(    ),
    .dstdata(      {InbdPow40SdBmSync,
                    InbdPow20SdBmSync,
                    InBd20PowqdBmAnt0Sync,
                    ADCPowqdBVAnt0Sync
`ifdef RW_NX_DERIV_FE_PATH1
                    ,
                    ADCPowqdBVAnt1Sync,
                    InBd20PowqdBmAnt1Sync
`endif
                    })
  );

  ClkSyncParam  
  #(
`ifdef RW_NX_DERIV_FE_PATH1
    .PARAMSIZE(     40)
`else
    .PARAMSIZE(     30)
`endif
  ) 
  u_agc2ahbParamResync_2 (
    .dstclk(       RegBusClk),
    .dstresetn(    nRegBusRst),
    .srcupdate(    InbdPow20PNoiseUpdate),
    .srcdata(      {InbdPow40SNoisedBm,
                    InbdPow20SNoisedBm,
                    InbdPow20PNoisedBm0
`ifdef RW_NX_DERIV_FE_PATH1
                    ,
                    InbdPow20PNoisedBm1
`endif
                    }),
    .dstupdate(    ),
    .dstdata(      {InbdPow40SNoisedBmSync,
                    InbdPow20SNoisedBmSync,
                    InbdPow20PNoisedBm0Sync
`ifdef RW_NX_DERIV_FE_PATH1
                    ,
                    InbdPow20PNoisedBm1Sync
`endif
                    })
  );

  ClkSyncParam  
  #(
`ifdef RW_NX_DERIV_FE_PATH1
    .PARAMSIZE(     58)
`else
    .PARAMSIZE(     29)
`endif
  ) 
  u_agc2ahbParamResync_3 (
    .dstclk(       RegBusClk),
    .dstresetn(    nRegBusRst),
    .srcupdate(    AGCLockStat),
    .srcdata(      {RxGainAnt0,
                    DigGaindB20Ant0,
                    DigGaindB40Ant0,
                    DigGaindB80Ant0
`ifdef RW_NX_DERIV_FE_PATH1
                    ,
                    RxGainAnt1,
                    DigGaindB20Ant1,
                    DigGaindB40Ant1,
                    DigGaindB80Ant1
`endif
                    }),
    .dstupdate(    ),
    .dstdata(      {RxGainAnt0Sync,
                    DigGaindB20Ant0Sync,
                    DigGaindB40Ant0Sync,
                    DigGaindB80Ant0Sync
`ifdef RW_NX_DERIV_FE_PATH1
                    ,
                    RxGainAnt1Sync,
                    DigGaindB20Ant1Sync,
                    DigGaindB40Ant1Sync,
                    DigGaindB80Ant1Sync
`endif
                    })
  );

`ifdef RW_NX_IQ_COMP_EN
  ClkSyncParam  
  #(
`ifdef RW_NX_DERIV_FE_PATH1
    .PARAMSIZE(     174)
`else
    .PARAMSIZE(     87)
`endif
  ) 
  u_agc2ahbParamResync_4 (
    .dstclk(       RegBusClk),
    .dstresetn(    nRegBusRst),
    .srcupdate(    StRegRxIQEstValid),
    .srcdata(      {StRegRxIQEstVarI0,
                    StRegRxIQEstVarQ0,
                    StRegRxIQEstMIQ0,
                    StRegRxIQEstIQGainEst0,
                    StRegRxIQEstIQPhaseEst0
`ifdef RW_NX_DERIV_FE_PATH1
                    ,
                    StRegRxIQEstVarI1,
                    StRegRxIQEstVarQ1,
                    StRegRxIQEstMIQ1,
                    StRegRxIQEstIQGainEst1,
                    StRegRxIQEstIQPhaseEst1
`endif // RW_NX_DERIV_FE_PATH1
                    }),
    .dstupdate(    ),
    .dstdata(      {StRegRxIQEstVarI0Sync,
                    StRegRxIQEstVarQ0Sync,
                    StRegRxIQEstMIQ0Sync,
                    StRegRxIQEstIQGainEst0Sync,
                    StRegRxIQEstIQPhaseEst0Sync
`ifdef RW_NX_DERIV_FE_PATH1
                    ,
                    StRegRxIQEstVarI1Sync,
                    StRegRxIQEstVarQ1Sync,
                    StRegRxIQEstMIQ1Sync,
                    StRegRxIQEstIQGainEst1Sync,
                    StRegRxIQEstIQPhaseEst1Sync
`endif // RW_NX_DERIV_FE_PATH1
                    })
  );

  // Pulse resync to regbus
  ClkSyncPulse2Pulse U_RxIQEstIterClrSync ( 
    .srcclk     (RegBusClk),
    .srcresetn  (nRegBusRst),
    .dstclk     (FERxPath0GClk),
    .dstresetn  (nFERst),
    .srcdata    (CfgRegRxIQEstIterClr),
    .dstdata    (CfgRegRxIQEstIterClrSync)
  );

`endif // RW_NX_IQ_COMP_EN

  // Pulse resync to AGC
  ClkSyncPulse2Pulse U_AGCPlatFallPSync ( 
    .srcclk     (PhyClk),
    .srcresetn  (nPhyRst),
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (AGCPlatFallP),
    .dstdata    (AGCPlatFallPSync)
  );

  ClkSyncPulse2Pulse U_AGCStartPSync ( 
    .srcclk     (PhyClk),
    .srcresetn  (nPhyRst),
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (AGCStartP),
    .dstdata    (AGCStartPSync)
  );

  ClkSyncPulse2Pulse U_AGCGainUpdatePSync ( 
    .srcclk     (PhyClk),
    .srcresetn  (nPhyRst),
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (AGCGainUpdateP),
    .dstdata    (AGCGainUpdatePSync)
  );

`ifdef RW_RADAR_EN                    
  ClkSyncPulse2Pulse U_PulseTimerClearSync ( 
    .srcclk     (RegBusClk),
    .srcresetn  (nRegBusRst),
    .dstclk     (RadarTimGClk),
    .dstresetn  (nRadarTimRst),
    .srcdata    (AgcRegPulseTimerClear),
    .dstdata    (PulseTimerClearSync)
  );
`endif // RW_RADAR_EN                    

  ClkSyncPulse2Pulse U_InbdPowStartCaptureSync ( 
    .srcclk     (RegBusClk),
    .srcresetn  (nRegBusRst),
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (CfgRegAGCInbdPowStartCapture),
    .dstdata    (InbdPowStartCaptureSync)
  );

  ClkSyncPulse2Pulse U_InbdPowStartCaptureInValidSync (
    .srcclk     (AGCGClk),
    .srcresetn  (nAGCRst),
    .dstclk     (RegBusClk),
    .dstresetn  (nRegBusRst),
    .srcdata    (InbdPowStartCaptureSync),
    .dstdata    (AGCInbdPowStartCaptureInValid)
  );

  // Simple resync to AGCGClk
  ClkSyncSimple U_LSIGValidSync ( 
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (CCALSIGValid),
    .dstdata    (AGCCCALSIGValidSync)
  );

  ClkSyncSimple U_HTSIGValidSync ( 
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (CCAHTSigVHTSigAValid),
    .dstdata    (AGCCCAHTSIGVHTSIGAValidSync)
    );
 
  ClkSyncSimple U_RxEndTimingSync ( 
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (AGCRxEndTiming),
    .dstdata    (AGCRxEndTimingSync)
  );
 
  ClkSyncSimple U_KeepRFOnSync ( 
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (AGCKeepRFOn),
    .dstdata    (AGCKeepRFOnSync)
  );
 
  ClkSyncSimple U_AgcOnSync ( 
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (AGCOn),
    .dstdata    (AgcOnSync)
    );
 
  ClkSyncSimple U_StatusTrigConfSync ( 
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (AGCStatusRegMask),
    .dstdata    (StatusTrigConfSync)
    );

  ClkSyncSimple U_SFDFoundSync ( 
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (AGCSFDFound),
    .dstdata    (AGCSFDFoundSync)
    );

  ClkSyncSimple U_AGCDemodRun ( 
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (AGCDemodRun),
    .dstdata    (AGCDemodRunSync)
    );
  
  ClkSyncSimple U_AGCBWSup20 ( 
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (AGCBWSup20),
    .dstdata    (AGCBWSup20Sync)
    );
 
  ClkSyncSimple U_AGCBWEq20 ( 
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (AGCBWEq20),
    .dstdata    (AGCBWEq20Sync)
    );

  ClkSyncSimple U_AGCBWEq40 ( 
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (AGCBWEq40),
    .dstdata    (AGCBWEq40Sync)
    );

  ClkSyncSimple U_AGCBWEq80 ( 
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (AGCBWEq80),
    .dstdata    (AGCBWEq80Sync)
    );

  ClkSyncSimple U_AGCVHTFrame ( 
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (AGCVHTFrame),
    .dstdata    (AGCVHTFrameSync)
    );
  
  ClkSyncSimple U_AGCNoACIMargin ( 
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (AGCNoACIMargin),
    .dstdata    (AGCNoACIMarginSync)
    );

  ClkSyncSimple U_AGCRxFEEnDSSS ( 
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (RxFEEnDSSS),
    .dstdata    (RxFEEnDSSSSync)
    );

  ClkSyncParam  
  #(
`ifdef RW_NX_IQ_COMP_EN
    .PARAMSIZE(     11)
`else
    .PARAMSIZE(     7)
`endif
  ) 
  U_AGCParam (
    .dstclk(       AGCGClk),
    .dstresetn(    nAGCRst),
    .srcupdate(    AGCFrameParamUpdate),
    .srcdata(      {AGCFrameParamMCS
`ifdef RW_NX_IQ_COMP_EN
                   ,
                   AGCFrameParamLegRate
`endif
                   }),
    .dstupdate(    ),
    .dstdata(      {AGCFrameParamMCSSync
`ifdef RW_NX_IQ_COMP_EN
                   ,
                   AGCFrameParamLegRateSync
`endif
                   })
  );

`ifdef RW_NX_IQ_COMP_EN
  ClkSyncSimple U_AGCLegFrame ( 
    .dstclk     (AGCGClk),
    .dstresetn  (nAGCRst),
    .srcdata    (AGCLegFrame),
    .dstdata    (AGCLegFrameSync)
    );
    
  ClkSyncParam  
  #(
    .PARAMSIZE(     8)
  ) 
  u_AGCFOAngle (
    .dstclk(       AGCGClk),
    .dstresetn(    nAGCRst),
    .srcupdate(    AGCRxEndTiming),
    .srcdata(      AGCFOAngle),
    .dstupdate(    ),
    .dstdata(      AGCFOAngleSync)
  );
`endif

  assign AgcRegFsmEvent0[9] = 1'b0;
  assign AgcRegFsmEvent1[9] = 1'b0;
  assign AgcRegFsmEvent2[9] = 1'b0;
  assign AgcRegFsmEvent3[9] = 1'b0;

  /*****************************************************************************
  * PHY TX TO RC RESYNCHRO
  *****************************************************************************/
  wire        ofdm_tx_p1_update;
  wire        ofdm_tx_p1_sfo_bypass;   
  wire [26:0] ofdm_tx_p1_sfo_ppm;
  wire        ofdm_tx_p1_cfo_bypass;   
  wire [24:0] ofdm_tx_p1_cfo_freq;
  wire [ 7:0] ofdm_tx_p1_antennaset;
  wire [ 2:0] ofdm_tx_p1_ntx;
  wire [ 7:0] ofdm_tx_p1_txpower;
  wire        ofdm_tx_p1_ofdm_sel;
  
  ClkSyncParam  
  #(
    .PARAMSIZE(     74)
  ) 
  u_phy2rcResync_1 (
    .dstclk(       RCGClk),
    .dstresetn(    nRCRst),
    .srcupdate(    RCTx1Update),
    .srcdata(      {RCTx1CFOBypass,
                    RCTx1CFO,
                    RCTx1SFOBypass,
                    RCTx1SFO,
                    RCTx1OFDMSel,
                    RCTx1Ant,
                    RCTx1NTx,
                    RCTx1Power}),
    .dstupdate(     ofdm_tx_p1_update),
    .dstdata(      {ofdm_tx_p1_cfo_bypass,
                    ofdm_tx_p1_cfo_freq,
                    ofdm_tx_p1_sfo_bypass,
                    ofdm_tx_p1_sfo_ppm,
                    ofdm_tx_p1_ofdm_sel,
                    ofdm_tx_p1_antennaset,
                    ofdm_tx_p1_ntx,
                    ofdm_tx_p1_txpower})
  );

  /*****************************************************************************
  * clock enable/ block enable managment
  *****************************************************************************/
  ClkSyncSimple u_rc_rctxon_resync 
  ( 
    .dstclk     (RCGClk),
    .dstresetn  (nRCRst),
    .srcdata    (RCTxOn),
    .dstdata    (rc_rctxon)
  );
  
  assign RCTxAck = rc_rctxack;

  ClkSyncSimple u_rc_rcrxon_resync 
  ( 
    .dstclk     (RCGClk),
    .dstresetn  (nRCRst),
    .srcdata    (RCRxOn),
    .dstdata    (rc_rcrxon)
  );
  
  assign RCRxAck = rc_rcrxack;
  
  reg [ 7:0] latency_sr;
  always @(posedge RCGClk, negedge nRCRst)
  begin
    if(!nRCRst)
    begin
      latency_sr         <= 8'b0;
      agc_clken          <= 1'b0;
      ferx_clken         <= 1'b0;
      fetx_clken         <= 1'b0;
      fe_path0_clken     <= 1'b0;
`ifdef RW_NX_DERIV_FE_PATH1
      fe_path1_clken     <= 1'b0;
`endif
      fe40_clken         <= 1'b0;
`ifdef RW_NX_DERIV_FE_PATH40M
      fe80_clken         <= 1'b0;
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
      fe160_clken        <= 1'b0;
`endif
      fe_tx_ofdm_blocken <= 1'b0;
`ifdef RW_NX_DERIV_80211B
      fe_tx_dsss_blocken <= 1'b0;
`endif
    end
    else
    begin
      /*************************************************************************
      * TX 
      *************************************************************************/
      if(rc_rctxon || rc_rctxack)
      begin
        latency_sr    <= {latency_sr[6:0],1'b1};

        /* turn-on rx related clocks */
        agc_clken      <= 1'b0;
        ferx_clken     <= 1'b0;
        fetx_clken     <= 1'b1;
        fe_path0_clken <= CfgRegActiveAnt[0];
`ifdef RW_NX_DERIV_FE_PATH1
        fe_path1_clken <= CfgRegActiveAnt[1];
`endif

        fe40_clken     <= 1'b1; 
`ifdef RW_NX_DERIV_FE_PATH40M
        fe80_clken     <= CfgRegMdmConfBW==2'd1 | CfgRegMdmConfBW==2'd2; 
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
        fe160_clken    <= CfgRegMdmConfBW==2'd2;
`endif
        
        if(latency_sr[7])
        begin
          fe_tx_ofdm_blocken <=  ofdm_tx_p1_ofdm_sel & ofdm_tx_p1_update;
`ifdef RW_NX_DERIV_80211B
          fe_tx_dsss_blocken <= ~ofdm_tx_p1_ofdm_sel & ofdm_tx_p1_update;
`endif
        end
        else
        begin
          fe_tx_ofdm_blocken <= 1'b0;
`ifdef RW_NX_DERIV_80211B
          fe_tx_dsss_blocken <= 1'b0;
`endif
        end
      end
      /*************************************************************************
      * RX 
      *************************************************************************/
      else if(rc_rcrxon || rc_rcrxack)
      begin
        /* turn-on rx related clocks */
        agc_clken      <= 1'b1;
        ferx_clken     <= 1'b1;
        fetx_clken     <= 1'b0;
        fe_path0_clken <= CfgRegActiveAnt[0];
`ifdef RW_NX_DERIV_FE_PATH1
        fe_path1_clken <= CfgRegActiveAnt[1];
`endif

        fe40_clken     <= 1'b1; 
`ifdef RW_NX_DERIV_FE_PATH40M
        fe80_clken     <= CfgRegMdmConfBW==2'd1 | CfgRegMdmConfBW==2'd2; 
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
        fe160_clken    <= CfgRegMdmConfBW==2'd2;
`endif
        fe_tx_ofdm_blocken <= 1'b0;
        fe_tx_dsss_blocken <= 1'b0;
      end
      else
      begin
        latency_sr <= {latency_sr[6:0],1'b0};
        fe_tx_ofdm_blocken <= 1'b0;
        fe_tx_dsss_blocken <= 1'b0;
        
        if(!latency_sr[7])
        begin
        /* turn-on rx related clocks */
        agc_clken      <= 1'b0;
        ferx_clken     <= 1'b0;
        fetx_clken     <= 1'b0;
        fe_path0_clken <= 1'b0;
`ifdef RW_NX_DERIV_FE_PATH1
        fe_path1_clken <= 1'b0;
`endif

        fe40_clken     <= 1'b0; 
`ifdef RW_NX_DERIV_FE_PATH40M
        fe80_clken     <= 1'b0; 
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
        fe160_clken    <= 1'b0; 
`endif
        end
      end
    end
  end  
  
  assign AGCClkEn     = agc_clken;
  assign AGCMemClkEn  = agc_clken  | RegBusSelAGCMEM
`ifdef RW_NX_FIQ_COMP_EN
   | CfgRegfIQCalEn  // Force AGC Mem clock running during fIQ calibration
`endif // RW_NX_FIQ_COMP_EN
   ;
`ifdef RW_NX_IQ_COMP_EN
  assign FETxRxClkEn  = ferx_clken | fetx_clken
`ifdef RW_NX_FIQ_COMP_EN
   | CfgRegfIQCalEn  | CfgRegfIQCoeffUpdate | CfgRegfIQCoeffReq // Force TxRx Fe clock running during fIQ calibration
`endif // RW_NX_FIQ_COMP_EN
   ;
`endif // RW_NX_IQ_COMP_EN
  assign FERxClkEn    = ferx_clken;
  assign FETxClkEn    = fetx_clken;
  assign FE40ClkEn    = fe40_clken;
`ifdef RW_NX_DERIV_FE_PATH40M
  assign FE80ClkEn    = fe80_clken;
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  assign FE160ClkEn   = fe160_clken;
`endif
  assign FEPath0ClkEn = fe_path0_clken
`ifdef RW_NX_FIQ_COMP_EN
   | CfgRegfIQCalEn  | CfgRegfIQCoeffUpdate | CfgRegfIQCoeffReq // Force TxRx Fe clock running during fIQ calibration, using RxClkEn
`endif // RW_NX_FIQ_COMP_EN
   ;
`ifdef RW_NX_DERIV_FE_PATH1
  assign FEPath1ClkEn = fe_path1_clken;
`endif

  /*****************************************************************************
  * TX DONE/UNDERFLOW
  *****************************************************************************/
  wire fe_dac_en;
  
`ifdef RW_NX_DERIV_FE_PATH1
  assign fe_dac_en = DACEn0 | DACEn1;
`else
  assign fe_dac_en = DACEn0;
`endif  
 
  reg  fe_tx_last_captured;
  reg  fe_tx_underflow;
  reg  fe_tx_done;
  reg  fe_dac_en_1t,fe_dac_en_2t;
  
  always @(posedge FETxPath0GClk, negedge nFERst)
  begin
    if(!nFERst)
    begin
      fe_tx_last_captured          <= 1'b0;
      fe_tx_underflow              <= 1'b0;
      fe_dac_en_1t                 <= 1'b0;
      fe_dac_en_2t                 <= 1'b0;
      fe_tx_done                   <= 1'b0;
      fe_tx_ofdm_blocken_realigned <= 1'b0;
    end
    else
    begin
     
      fe_tx_ofdm_blocken_realigned <= fe_tx_ofdm_blocken;
      
      if(!fe_tx_ofdm_blocken_realigned)
      begin
        fe_tx_last_captured <= 1'b0;
        fe_tx_underflow     <= 1'b0;
        fe_dac_en_1t        <= 1'b0;
        fe_dac_en_2t        <= 1'b0;
        fe_tx_done          <= 1'b0;
      end
      else
      begin
        if(ofdm_tx_ready && ofdm_tx_valid_sync && ofdm_tx_last_sync)
          fe_tx_last_captured <= 1'b1;
   
        if(ofdm_tx_release_sync && ofdm_tx_ready && !ofdm_tx_valid_sync && !fe_tx_last_captured)
          fe_tx_underflow <= 1'b1;
   
        fe_dac_en_1t <= fe_dac_en;
        fe_dac_en_2t <= fe_dac_en_1t;
        
        if(fe_dac_en_2t && !fe_dac_en_1t)
          fe_tx_done <= 1'b1;
      end
    end
  end

  ClkSyncSimple u_ofdm_tx_done 
  ( 
    .dstclk     (PhyClk),
    .dstresetn  (nPhyRst),
    .srcdata    (fe_tx_done),
    .dstdata    (OFDMTxDone)
  );
  
  ClkSyncSimple u_ofdm_tx_underflow 
  ( 
    .dstclk     (PhyClk),
    .dstresetn  (nPhyRst),
    .srcdata    (fe_tx_underflow),
    .dstdata    (OFDMTxUnderflow)
  );

  /*****************************************************************************
  * TX GAIN SELECTION
  *****************************************************************************/
  assign ofdm_tx_diggain0 = 
`ifdef RW_NX_DERIV_FE_PATH80M
    (CfgRegMdmConfBW==BW80) ? CfgRegTx80DigGainLin0 :
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
    (CfgRegMdmConfBW==BW40) ? CfgRegTx40DigGainLin0 :
`endif
                              CfgRegTx20DigGainLin0;

`ifdef RW_NX_DERIV_FE_PATH1
  assign ofdm_tx_diggain1 = 
`ifdef RW_NX_DERIV_FE_PATH80M
    (CfgRegMdmConfBW==BW80) ? CfgRegTx80DigGainLin1 :
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
    (CfgRegMdmConfBW==BW40) ? CfgRegTx40DigGainLin1 :
`endif
                              CfgRegTx20DigGainLin1;
`endif

  /*****************************************************************************
  * OFDMTX TO FE DATA RESYNCHRO
  *
  * IMPORTANT: FETxPath0GClk shall be present at LEAST 5 cycles BEFORE 
  *            the OFDMTxValid assertion
  *
  *****************************************************************************/
  
  /* ensure that w_clk of fifo is enable before receiving data from hdmcore */
  wire   phy_phy2fe_fifo_enable;
  assign phy_phy2fe_fifo_enable = RCTx1Update & RCTx1OFDMSel;
  
  async_fifo
  #(
`ifdef RW_NX_DERIV_FE_PATH1
    .g_width(                   53),
`else
    .g_width(                   27),
`endif
    .g_log_depth(               3)
  )
  u_tx_phy2fe_fifo
  (
    /*****************************************************************************
    * common
    *  1) if async: at least duration of 2 cycles of the longest clock period)
    *  2) if sync:  coming from the domain of the longest clock period
    *****************************************************************************/
    .enable(                    phy_phy2fe_fifo_enable),
  
    /*****************************************************************************
    * Domain W (w_clk)
    *****************************************************************************/
    .w_rst_n(                   nPhyRst),
    .w_clk(                     PhyClk),
  
    .w_ready(                   OFDMTxReady),
    .w_data(                    {
`ifdef RW_NX_DERIV_FE_PATH1
                                OFDMTxQ1,OFDMTxI1,
`endif
                                OFDMTxLast,OFDMTxQ0,OFDMTxI0}),
    .w_valid(                   OFDMTxValid),

    /*****************************************************************************
    * Domain R (r_clk)
    *****************************************************************************/
    .r_rst_n(                   nFERst),
    .r_clk(                     FETxPath0GClk),
  
    .r_ready(                   ofdm_tx_ready),
    .r_data(                    {
`ifdef RW_NX_DERIV_FE_PATH1
                                ofdm_tx_q1_sync,ofdm_tx_i1_sync,
`endif
                                ofdm_tx_last_sync,ofdm_tx_q0_sync,ofdm_tx_i0_sync}),
    .r_valid(                   ofdm_tx_valid_sync)
  );

  ClkSyncSimple u_ofdm_tx_release_resync 
  ( 
    .dstclk     (FETxPath0GClk),
    .dstresetn  (nFERst),
    .srcdata    (OFDMTxRelease),
    .dstdata    (ofdm_tx_release_sync)
  );

  /*****************************************************************************
  * FE TO OFDMRX DATA RESYNCHRO
  *
  *  BW   RX     PRI20    SEC20     40     80     
  *  20   1      2x13     0         0      0      
  *  40   1      2x13     2x13      4x13   0      
  *  80   1      2x13     2x13      2x13   2x13   
  *  20   2      4x13     0         0      0      
  *  40   2      4x13     2x13      4x13   0      
  *  80   2      4x13     2x13      4x13   4x13   
  *
  *****************************************************************************/
  fe2phy_fifo
  #(
`ifdef RW_NX_DERIV_FE_PATH1
`ifdef RW_NX_DERIV_FE_PATH80M
    .g_width80(                        52),
    .g_width40(                        52),
    .g_width20(                        78)
`elsif RW_NX_DERIV_FE_PATH40M
    .g_width40(                        52),
    .g_width20(                        78)
`else
    .g_width20(                        52)
`endif
`else // RW_NX_DERIV_FE_PATH1
`ifdef RW_NX_DERIV_FE_PATH80M
    .g_width80(                        26),
    .g_width40(                        26),
    .g_width20(                        52)
`elsif RW_NX_DERIV_FE_PATH40M
    .g_width40(                        26),
    .g_width20(                        52)
`else
    .g_width20(                        26)
`endif
`endif
  )
  u_fe2phy_fifo
  (
    /*****************************************************************************
    * FE domain
    *****************************************************************************/
    .fe_rst_n(                         nFERst), 
    .fe_clk(                           FERxPath0GClk), 
    
    .fe_cbw(                           CfgRegMdmConfBW),
    .fe_tden(                          AGCOFDMLock),
    .fe_valid(                         fe_rx_valid),
`ifdef RW_NX_DERIV_FE_PATH1
`ifdef RW_NX_DERIV_FE_PATH80M
    .fe_data80(                        {   fe_rx80_i1,    fe_rx80_q1,
                                           fe_rx80_i0,    fe_rx80_q0}),
    .fe_data40(                        {   fe_rx40_i1,    fe_rx40_q1,
                                           fe_rx40_i0,    fe_rx40_q0}),
    .fe_data20(                        {fe_rx20pri_i1, fe_rx20pri_q1,
                                        fe_rx20pri_i0, fe_rx20pri_q0,
                                         fe_rx20sec_i,  fe_rx20sec_q}),
`elsif RW_NX_DERIV_FE_PATH40M
    .fe_data40(                        {   fe_rx40_i1,    fe_rx40_q1,
                                           fe_rx40_i0,    fe_rx40_q0}),
    .fe_data20(                        {fe_rx20pri_i1, fe_rx20pri_q1,
                                        fe_rx20pri_i0, fe_rx20pri_q0,
                                        fe_rx20sec_i,  fe_rx20sec_q}),
`else
    .fe_data20(                        { fe_rx20pri_i1, fe_rx20pri_q1,
                                         fe_rx20pri_i0, fe_rx20pri_q0}),
`endif
`else  // RW_NX_DERIV_FE_PATH1
`ifdef RW_NX_DERIV_FE_PATH80M
    .fe_data80(                        {   fe_rx80_i0,    fe_rx80_q0}),
    .fe_data40(                        {   fe_rx40_i0,    fe_rx40_q0}),
    .fe_data20(                        {fe_rx20pri_i0, fe_rx20pri_q0,
                                         fe_rx20sec_i,  fe_rx20sec_q}),
`elsif RW_NX_DERIV_FE_PATH40M
    .fe_data40(                        {   fe_rx40_i0,    fe_rx40_q0}),
    .fe_data20(                        {fe_rx20pri_i0, fe_rx20pri_q0,
                                         fe_rx20sec_i,  fe_rx20sec_q}),
`else
    .fe_data20(                        {fe_rx20pri_i0, fe_rx20pri_q0}),
`endif
`endif
    /*****************************************************************************
    * PHY domain
    *****************************************************************************/
    .phy_rst_n(                          nPhyRst), 
    .phy_clk(                            PhyClk),   
  
    .phy_tden(                           phy_tden),
`ifdef RW_NX_DERIV_FE_PATH1
`ifdef RW_NX_DERIV_FE_PATH80M
    .phy_valid80(                        phy_rx80_valid),
    .phy_valid40(                        phy_rx40_valid),
    .phy_valid20(                        phy_rx20_valid),
    .phy_data80(                         {    OFDMRx80I1,       OFDMRx80Q1,
                                              OFDMRx80I0,       OFDMRx80Q0}),
    .phy_data40(                         {    OFDMRx40I1,       OFDMRx40Q1,
                                              OFDMRx40I0,       OFDMRx40Q0}),
    .phy_data20(                         { OFDMRx20PriI1,    OFDMRx20PriQ1,
                                           OFDMRx20PriI0,    OFDMRx20PriQ0,
                                            OFDMRx20SecI,     OFDMRx20SecQ}) 
`elsif RW_NX_DERIV_FE_PATH40M
    .phy_valid40(                        phy_rx40_valid),
    .phy_valid20(                        phy_rx20_valid),
    .phy_data40(                         {    OFDMRx40I1,       OFDMRx40Q1,
                                              OFDMRx40I0,       OFDMRx40Q0}),
    .phy_data20(                         { OFDMRx20PriI1,    OFDMRx20PriQ1,
                                           OFDMRx20PriI0,    OFDMRx20PriQ0,
                                            OFDMRx20SecI,     OFDMRx20SecQ})  
`else
    .phy_valid20(                         phy_rx20_valid),
    .phy_data20(                         { OFDMRx20PriI0,    OFDMRx20PriQ0,
                                           OFDMRx20PriI1,    OFDMRx20PriQ1})
`endif
`else // RW_NX_DERIV_FE_PATH1
`ifdef RW_NX_DERIV_FE_PATH80M
    .phy_valid80(                        phy_rx80_valid),
    .phy_valid40(                        phy_rx40_valid),
    .phy_valid20(                        phy_rx20_valid),
    .phy_data80(                         {    OFDMRx80I0,       OFDMRx80Q0}),
    .phy_data40(                         {    OFDMRx40I0,       OFDMRx40Q0}),
    .phy_data20(                         { OFDMRx20PriI0,    OFDMRx20PriQ0,
                                            OFDMRx20SecI,     OFDMRx20SecQ}) 
`elsif RW_NX_DERIV_FE_PATH40M
    .phy_valid40(                         phy_rx40_valid),
    .phy_valid20(                         phy_rx20_valid),
    .phy_data40(                         {    OFDMRx40I0,       OFDMRx40Q0}),
    .phy_data20(                         { OFDMRx20PriI0,    OFDMRx20PriQ0,
                                            OFDMRx20SecI,     OFDMRx20SecQ})  
`else
    .phy_valid20(                         phy_rx20_valid),
    .phy_data20(                         { OFDMRx20PriI0,    OFDMRx20PriQ0})
`endif
`endif 
  );
  
  /* do rx20-aligned valid gating */
`ifdef RW_NX_DERIV_FE_PATH80M
  assign OFDMRx80Valid = phy_rx80_valid & phy_tden;
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
  assign OFDMRx40Valid = phy_rx40_valid & phy_tden;
`endif
  assign OFDMRx20Valid = phy_rx20_valid & phy_tden;
  
  // AGC mem 64->32
  reg AGCMemRdDataSel;
  always @(posedge AGCMemGClk, negedge nAGCRst)
    if(!nAGCRst) begin
      AGCMemRdDataSel <= 1'b0;
    end else begin
      if (AgcOnSync==1'b1)
        AGCMemRdDataSel <= AGCMemAddrInt[0];
    end
  assign AGCMemRdDataInt = AGCMemRdDataSel ? AGCMemRdData[63:32] : AGCMemRdData[31:0];
  
  /*****************************************************************************
  * RIUCore instance
  *****************************************************************************/
  RIUCore U_RIUCORE 
  (
    /***************************************************************************
    * Resets
    ***************************************************************************/
    .nAGCRst(                          nAGCRst),
    .nFERst(                           nFERst),
`ifdef RW_NX_FIQ_COMP_EN
    .nFENoWdRst (                      nFENoWdRst),
`endif // RW_NX_FIQ_COMP_EN
`ifdef RW_NX_DERIV_FE_PATH80M
    .nFE160Rst(                        nFE160Rst),
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
    .nFE80Rst(                         nFE80Rst),
`endif
    .nFE40Rst(                         nFE40Rst),
`ifdef RW_NX_DERIV_80211B
    .nFE44Rst(                         nFE44Rst),
`endif
`ifdef RW_RADAR_EN
    .nRegBusRst(                       nRegBusRst),
    .nRadarTimRst(                     nRadarTimRst),
`endif // RW_RADAR_EN

    /***************************************************************************
    * Clocks
    ***************************************************************************/
    /* AGC */
    .AGCGClk(                          AGCGClk),
    .ADCPowGClk(                       ADCPowGClk),
    /* regbus */
    .RegBusClk(                        RegBusClk),
    
    /* Front-end 44MHz */
`ifdef RW_NX_DERIV_80211B
    .FE44GClk(                         FE44GClk),
`endif

    /* FE path 0 */
    .FERxPath0GClk(                    FERxPath0GClk),
    .FETxPath0GClk(                    FETxPath0GClk),
`ifdef RW_NX_IQ_COMP_EN
    .FETxRxPath0GClk(                  FETxRxPath0GClk),
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    .FE160Path0GClk(                   FE160Path0GClk),
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
    .FE80Path0GClk(                    FE80Path0GClk),
`endif
    .FE40Path0GClk(                    FE40Path0GClk),
`ifdef RW_NX_DERIV_FE_PATH1
    /* FE path 1 */
    .FERxPath1GClk(                    FERxPath1GClk),
    .FETxPath1GClk(                    FETxPath1GClk),
`ifdef RW_NX_IQ_COMP_EN
    .FETxRxPath1GClk(                  FETxRxPath1GClk),
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    .FE160Path1GClk(                   FE160Path1GClk),
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
    .FE80Path1GClk(                    FE80Path1GClk),
`endif
    .FE40Path1GClk(                    FE40Path1GClk),
`endif // RW_NX_DERIV_FE_PATH1
`ifdef RW_RADAR_EN
    .RadarTimGClk(                     RadarTimGClk),
`endif // RW_RADAR_EN

    /***************************************************************************
    * channel bandwidth (0=20M,1=40M,2=80M)
    ***************************************************************************/
    .CfgRegMdmConfBW(                  CfgRegMdmConfBW),
    .CfgRegMdmConfPrimary(             CfgRegMdmConfPrimary),

`ifdef RW_RADAR_EN
    /***************************************************************************
    * Radar FIFO read interface (@ RegBusClk)
    ***************************************************************************/
    .RadarFifoRdEn(                    RadarFifoRdEn),
    .RadarFifoRdData(                  RadarFifoRdData),
`endif // RW_RADAR_EN
    /***************************************************************************
    * AGC
    ***************************************************************************/
    .AGCRifsDetected(                  AGCRifsDetected),
    .AGCOFDMLock(                      AGCOFDMLock),
    .AGCOFDMHTSTF(                     AGCOFDMHTSTF),
    .AGCDSSSLock(                      AGCDSSSLock),
    .AGCP1SNR(                         AGCP1SNR),
    .AGCP1NoiseVardB(                  AGCP1NoiseVardB),
    .AGCP1Update(                      AGCP1Update),
    .AGCP2RxAntennaset(                AGCP2RxAntennaset),
    .AGCP2Rssi1(                       AGCP2Rssi1),
`ifdef RW_NX_DERIV_FE_PATH1
    .AGCP2Rssi2(                       AGCP2Rssi2),
`endif
    .AGCP2Update(                      AGCP2Update),
    .AGCCCAPrimary20(                  AGCCCAPrimary20),
    .AGCCCASecondary20(                AGCCCASecondary20),
    .AGCCCASecondary40(                AGCCCASecondary40),
    .AGCOn(                            AgcOnSync),
    .AGCKeepRFOn(                      AGCKeepRFOnSync),
    .AGCSFDFound(                      AGCSFDFoundSync),
    .AGCDemodRun(                      AGCDemodRunSync),
    .AGCStartEstimP (                  AGCStartPSync),
    .AGCGainUpdateP (                  AGCGainUpdatePSync),
    .AGCVHTFrame(                      AGCVHTFrameSync),
    .AGCNoACIMargin(                   AGCNoACIMarginSync),
    .AGCBWSup20(                       AGCBWSup20Sync),
    .AGCBWEq20(                        AGCBWEq20Sync),
    .AGCBWEq40(                        AGCBWEq40Sync),
    .AGCBWEq80(                        AGCBWEq80Sync),
    .AGCPlatFallP(                     AGCPlatFallPSync),
    .AGCCCALSIGValid(                  AGCCCALSIGValidSync),
    .AGCCCAHTSigVHTSigAValid(          AGCCCAHTSIGVHTSIGAValidSync),
    .AGCRxEndTiming(                   AGCRxEndTimingSync),
    .AGCFrameParamMCS(                 AGCFrameParamMCSSync),
    .RxFEEnDSSS(                       RxFEEnDSSSSync),
    .InbdPowStartCaptureP(             InbdPowStartCaptureSync),
`ifdef RW_NX_IQ_COMP_EN
    .AGCLegFrame(                      AGCLegFrameSync),
    .AGCFOAngle(                       AGCFOAngleSync),
    .AGCFrameParamLegRate(             AGCFrameParamLegRateSync),
`endif
    
    /***************************************************************************
    * FE BlockEn
    ***************************************************************************/
    .OFDMTxBlockEn(                    fe_tx_ofdm_blocken_realigned),
`ifdef RW_NX_DERIV_80211B
    .DSSSTxBlockEn(                    fe_tx_dsss_blocken),
`endif
    
    /***************************************************************************
    * OFDM PHY datapath
    ***************************************************************************/
    /* TX0 */ 
    .OFDMTxPipeRelease(                ofdm_tx_release_sync),
    .OFDMTxPipeLoaded(                 ofdm_tx_loaded),
    .OFDMTxSFOBypass(                  ofdm_tx_p1_sfo_bypass),   
    .OFDMTxSFOPPM(                     ofdm_tx_p1_sfo_ppm),
    .OFDMTxCFOBypass(                  ofdm_tx_p1_cfo_bypass),   
    .OFDMTxCFOFreq(                    ofdm_tx_p1_cfo_freq),
    .OFDMTxDigGain0(                   ofdm_tx_diggain0),
    .OFDMTxReady(                      ofdm_tx_ready),
    .OFDMTxI0(                         ofdm_tx_i0_sync),
    .OFDMTxQ0(                         ofdm_tx_q0_sync),
    .OFDMTxValid(                      ofdm_tx_valid_sync),

    /* RX 0 */
    .OFDMRxValid(                      fe_rx_valid),
    .OFDMRx20I0(                       fe_rx20pri_i0),
    .OFDMRx20Q0(                       fe_rx20pri_q0),
`ifdef RW_NX_DERIV_FE_PATH40M
    .OFDMRx20SecI(                     fe_rx20sec_i),    
    .OFDMRx20SecQ(                     fe_rx20sec_q),    
    .OFDMRx40I0(                       fe_rx40_i0),    
    .OFDMRx40Q0(                       fe_rx40_q0),    
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    .OFDMRx80I0(                       fe_rx80_i0), 
    .OFDMRx80Q0(                       fe_rx80_q0), 
`endif
`ifdef RW_NX_DERIV_FE_PATH1
    /* TX1 */ 
    .OFDMTxDigGain1(                   ofdm_tx_diggain1),
    .OFDMTxI1(                         ofdm_tx_i1_sync),
    .OFDMTxQ1(                         ofdm_tx_q1_sync),

    /* RX 1 */
    .OFDMRx20I1(                       fe_rx20pri_i1),
    .OFDMRx20Q1(                       fe_rx20pri_q1),
`ifdef RW_NX_DERIV_FE_PATH40M
    .OFDMRx40I1(                       fe_rx40_i1),    
    .OFDMRx40Q1(                       fe_rx40_q1),    
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
    .OFDMRx80I1(                       fe_rx80_i1), 
    .OFDMRx80Q1(                       fe_rx80_q1), 
`endif
`endif //RW_NX_DERIV_FE_PATH1
    
`ifdef RW_NX_DERIV_80211B
    /***************************************************************************
    * DSSS PHY datapath
    ***************************************************************************/
    /* TX */
    .DSSSTxValid(                      DSSSTxValid),
    .DSSSTxI(                          DSSSTxI),
    .DSSSTxQ(                          DSSSTxQ),     
 
    /* RX */
    .DSSSRxValid(                      DSSSRxValid),
    .DSSSRxI(                          DSSSRxI),
    .DSSSRxQ(                          DSSSRxQ),
`endif

    /***************************************************************************
    * memories
    ***************************************************************************/
    /* AGC */
    .AGCMemAddr(                       AGCMemAddrInt),
    .AGCMemRdData(                     AGCMemRdDataInt),
  // RAM interface
`ifdef RW_NX_FIQ_COMP_EN
    .fIQMemAddr(                       fIQMemAddr),
    .fIQMemRdEn(                       fIQMemRdEn),
    .fIQMemWrEn(                       fIQMemWrEn),
    .fIQMemWrData(                     fIQMemWrData),
    .fIQMemRdData(                     AGCMemRdData),
`endif // RW_NX_FIQ_COMP_EN
`ifdef RW_RADAR_EN
   /* Radar detection */
    .RadarMemAddr(                     RadarMemAddr),
    .RadarMemEn(                       RadarMemEn),
    .RadarMemWrEn(                     RadarMemWrEn),
    .RadarMemWrData(                   RadarMemWrData),
    .RadarMemRdData(                   RadarMemRdData),
`endif // RW_RADAR_EN
    /***************************************************************************
    * Converters 
    ***************************************************************************/
    /* ADC 0 */
    .ADCI0(                            ADCI0),
    .ADCQ0(                            ADCQ0),
    /* DAC 0 */                  
    .DACEn0(                           DACEn0),  
    .DACI0(                            DACI0), 
    .DACQ0(                            DACQ0), 
 
`ifdef RW_NX_DERIV_FE_PATH1
    /* ADC 1 */
    .ADCI1(                            ADCI1),
    .ADCQ1(                            ADCQ1),
    /* DAC 1 */                  
    .DACEn1(                           DACEn1),  
    .DACI1(                            DACI1), 
    .DACQ1(                            DACQ1), 
`endif
    /***************************************************************************
    * RC and Gain Table interface
    ***************************************************************************/
    .RCProgRFDone(                     RCProgRFDone),
    .RCRFGainCompDone(                 AGCRFGainCompDone),
    .RCExtDetect0(                     AgcRegGPSetting[0]), // Allow sending event to AGC from register
    .RFGaindB0(                        RFGaindB0),
`ifdef RW_NX_AGC_SNR_EN
    .RFGainNFdB0(                      RFGainNFdB0),
`endif
`ifdef RW_NX_DERIV_FE_PATH1
    .RCExtDetect1(                     AgcRegGPSetting[1]), // Allow sending event to AGC from register
    .RFGaindB1(                        RFGaindB1),
`ifdef RW_NX_AGC_SNR_EN
    .RFGainNFdB1(                      RFGainNFdB1),
`endif
`endif
    .RCProgRF(                         RCProgRF),
    .RCRFGainCompReq(                  AGCRFGainCompReq),
    .AGCGainTgt0(                      AGCGainTgt0),
  `ifdef RW_NX_DERIV_FE_PATH1
    .AGCGainTgt1(                      AGCGainTgt1),
  `endif
   
    /***************************************************************************
    * Register Interface
    ***************************************************************************/
    .StatusTrigConf(                   StatusTrigConfSync),
    .StatusTrigReq(                    StatusTrigReq),
    .StRegRxGainAnt0(                  RxGainAnt0),
`ifdef RW_NX_DERIV_FE_PATH1
    .StRegRxGainAnt1(                  RxGainAnt1),
`endif
    .StRegADCPowqdBVAnt0(              ADCPowqdBVAnt0),
`ifdef RW_NX_DERIV_FE_PATH1
    .StRegADCPowqdBVAnt1(              ADCPowqdBVAnt1),
`endif
    .StRegInBd20PowqdBmAnt0(           InBd20PowqdBmAnt0),
`ifdef RW_NX_DERIV_FE_PATH1
    .StRegInBd20PowqdBmAnt1(           InBd20PowqdBmAnt1),
`endif
    .StRegDigGaindB80Ant0(             DigGaindB80Ant0),
    .StRegDigGaindB40Ant0(             DigGaindB40Ant0),
    .StRegDigGaindB20Ant0(             DigGaindB20Ant0),
 `ifdef RW_NX_DERIV_FE_PATH1
    .StRegDigGaindB80Ant1(             DigGaindB80Ant1),
    .StRegDigGaindB40Ant1(             DigGaindB40Ant1),
    .StRegDigGaindB20Ant1(             DigGaindB20Ant1),
`endif
`ifdef RW_RADAR_EN
    .StRegRadarFifoEmpty(              RadarFifoEmpty),
`endif // RW_RADAR_EN
    .StRegInbdPow20PNoisedBm0(         InbdPow20PNoisedBm0),
`ifdef RW_NX_DERIV_FE_PATH1
    .StRegInbdPow20PNoisedBm1(         InbdPow20PNoisedBm1),
`endif
    .StRegInbdPow20PNoiseUpdate(       InbdPow20PNoiseUpdate),
    .StRegInbdPow40SdBm(               InbdPow40SdBm),
    .StRegInbdPow20SdBm(               InbdPow20SdBm),
    .StRegInbdPow40SNoisedBm(          InbdPow40SNoisedBm),
    .StRegInbdPow20SNoisedBm(          InbdPow20SNoisedBm),
    //
    .CfgRegActiveAnt(                  CfgRegActiveAnt),
    .CfgRegTxIQSwapPath0(              CfgRegTxIQSwapPath0),
    .CfgRegRxIQSwapPath0(              CfgRegRxIQSwapPath0),
    .CfgRegTxIQDelPathQ0(              CfgRegTxIQDelPathQ0),
    .CfgRegTxIQDelPathI0(              CfgRegTxIQDelPathI0),
    .CfgRegRxIQDelPathQ0(              CfgRegRxIQDelPathQ0),
    .CfgRegRxIQDelPathI0(              CfgRegRxIQDelPathI0),
`ifdef RW_NX_DERIV_FE_PATH1
    .CfgRegTxIQSwapPath1(              CfgRegTxIQSwapPath1),
    .CfgRegRxIQSwapPath1(              CfgRegRxIQSwapPath1),
    .CfgRegTxIQDelPathQ1(              CfgRegTxIQDelPathQ1),
    .CfgRegTxIQDelPathI1(              CfgRegTxIQDelPathI1),
    .CfgRegRxIQDelPathQ1(              CfgRegRxIQDelPathQ1),
    .CfgRegRxIQDelPathI1(              CfgRegRxIQDelPathI1),
`endif
    .CfgRegTxC2sDisb(                  CfgRegTxC2sDisb),
    .CfgRegRxC2sDisb(                  CfgRegRxC2sDisb),
`ifdef RW_NX_IQ_COMP_EN
    .CfgRegTxIQGainCompEn0(            CfgRegTxIQGainCompEn0),
    .CfgRegTxIQPhaseCompEn0(           CfgRegTxIQPhaseCompEn0),
    .CfgRegTxIQGain0(                  CfgRegTxIQGain0),
    .CfgRegTxIQPhase0(                 CfgRegTxIQPhase0),
`ifdef RW_NX_DERIV_FE_PATH1
    .CfgRegTxIQGainCompEn1(            CfgRegTxIQGainCompEn1),
    .CfgRegTxIQPhaseCompEn1(           CfgRegTxIQPhaseCompEn1),
    .CfgRegTxIQGain1(                  CfgRegTxIQGain1),
    .CfgRegTxIQPhase1(                 CfgRegTxIQPhase1),
`endif
    .CfgRegRxIQEstIterClr (            CfgRegRxIQEstIterClrSync),
    .CfgRegRxIQEstSNRMin (             CfgRegRxIQEstSNRMin),
    .CfgRegRxIQEstMCSMin (             CfgRegRxIQEstMCSMin),
    .CfgRegRxIQEstBWList (             CfgRegRxIQEstBWList),
    .CfgRegRxIQEstFOMin  (             CfgRegRxIQEstFOMin),
    .CfgRegRxIQPhaseEstEn(             CfgRegRxIQPhaseEstEn),
    .CfgRegRxIQGainEstEn (             CfgRegRxIQGainEstEn),
    .CfgRegRxIQGainCompEn (            CfgRegRxIQGainCompEn),
    .CfgRegRxIQPhaseCompEn (           CfgRegRxIQPhaseCompEn),
    .CfgRegRxIQEstDel (                CfgRegRxIQEstDel),
    .CfgRegRxIQEstGainStepInit (       CfgRegRxIQEstGainStepInit),
    .CfgRegRxIQEstGainStepStop (       CfgRegRxIQEstGainStepStop),
    .CfgRegRxIQEstPhaseStepInit (      CfgRegRxIQEstPhaseStepInit),
    .CfgRegRxIQEstPhaseStepStop (      CfgRegRxIQEstPhaseStepStop),
    .CfgRegRxIQEstStepDel0 (           CfgRegRxIQEstStepDel0),
    .CfgRegRxIQEstStepDel1 (           CfgRegRxIQEstStepDel1),
    .CfgRegRxIQEstStepDel2 (           CfgRegRxIQEstStepDel2),
    .CfgRegRxIQEstStepDel3 (           CfgRegRxIQEstStepDel3),
    .CfgRegRxIQEstStepDel4 (           CfgRegRxIQEstStepDel4),
    .CfgRegRxIQGain0 (                 CfgRegRxIQGain0),
    .CfgRegRxIQPhase0  (               CfgRegRxIQPhase0),
`ifdef RW_NX_DERIV_FE_PATH1
    .CfgRegRxIQGain1 (                 CfgRegRxIQGain1),
    .CfgRegRxIQPhase1 (                CfgRegRxIQPhase1),
`endif
    //
    //
    .StRegRxIQEstVarI0 (               StRegRxIQEstVarI0),
    .StRegRxIQEstVarQ0 (               StRegRxIQEstVarQ0),
    .StRegRxIQEstMIQ0 (                StRegRxIQEstMIQ0),
    .StRegRxIQEstIQGainEst0 (          StRegRxIQEstIQGainEst0),
    .StRegRxIQEstIQPhaseEst0 (         StRegRxIQEstIQPhaseEst0),
    .StRegRxIQEstValid (               StRegRxIQEstValid),
`ifdef RW_NX_DERIV_FE_PATH1
    .StRegRxIQEstVarI1 (               StRegRxIQEstVarI1),
    .StRegRxIQEstVarQ1 (               StRegRxIQEstVarQ1),
    .StRegRxIQEstMIQ1 (                StRegRxIQEstMIQ1),
    .StRegRxIQEstIQGainEst1 (          StRegRxIQEstIQGainEst1),
    .StRegRxIQEstIQPhaseEst1 (         StRegRxIQEstIQPhaseEst1),
`endif

`endif
    .AgcRegAntLossDB0(                 AgcRegAntLossDB0),
    .AgcRegAntLossDB1(                 AgcRegAntLossDB1),
    .AgcRegRFGainMax4DetdB(            AgcRegRFGainMax4DetdB),
    .AgcRegRFGainMin4DetdB(            AgcRegRFGainMin4DetdB),
    .AgcRegRFGainMaxdB(                AgcRegRFGainMaxdB),
    .AgcRegRFGainMindB(                AgcRegRFGainMindB),
    .AgcRegDigGain80vs20(              AgcRegDigGain80vs20),
    .AgcRegDigGain40vs20(              AgcRegDigGain40vs20),
    .AgcRegSNRMeasSel(                 AgcRegSNRMeasSel),
    .AgcRegACI20MargMCS3(              AgcRegACI20MargMCS3),
    .AgcRegACI20MargMCS2(              AgcRegACI20MargMCS2),
    .AgcRegACI20MargMCS1(              AgcRegACI20MargMCS1),
    .AgcRegACI20MargMCS0(              AgcRegACI20MargMCS0),
    .AgcRegACI20MargMCS7(              AgcRegACI20MargMCS7),
    .AgcRegACI20MargMCS6(              AgcRegACI20MargMCS6),
    .AgcRegACI20MargMCS5(              AgcRegACI20MargMCS5),
    .AgcRegACI20MargMCS4(              AgcRegACI20MargMCS4),
    .AgcRegACI20MargMCS9(              AgcRegACI20MargMCS9),
    .AgcRegACI20MargMCS8(              AgcRegACI20MargMCS8),
    .AgcRegACI40MargMCS3(              AgcRegACI40MargMCS3),
    .AgcRegACI40MargMCS2(              AgcRegACI40MargMCS2),
    .AgcRegACI40MargMCS1(              AgcRegACI40MargMCS1),
    .AgcRegACI40MargMCS0(              AgcRegACI40MargMCS0),
    .AgcRegACI40MargMCS7(              AgcRegACI40MargMCS7),
    .AgcRegACI40MargMCS6(              AgcRegACI40MargMCS6),
    .AgcRegACI40MargMCS5(              AgcRegACI40MargMCS5),
    .AgcRegACI40MargMCS4(              AgcRegACI40MargMCS4),
    .AgcRegACI40MargMCS9(              AgcRegACI40MargMCS9),
    .AgcRegACI40MargMCS8(              AgcRegACI40MargMCS8),
    .AgcRegACI80MargMCS3(              AgcRegACI80MargMCS3),
    .AgcRegACI80MargMCS2(              AgcRegACI80MargMCS2),
    .AgcRegACI80MargMCS1(              AgcRegACI80MargMCS1),
    .AgcRegACI80MargMCS0(              AgcRegACI80MargMCS0),
    .AgcRegACI80MargMCS7(              AgcRegACI80MargMCS7),
    .AgcRegACI80MargMCS6(              AgcRegACI80MargMCS6),
    .AgcRegACI80MargMCS5(              AgcRegACI80MargMCS5),
    .AgcRegACI80MargMCS4(              AgcRegACI80MargMCS4),
    .AgcRegACI80MargMCS9(              AgcRegACI80MargMCS9),
    .AgcRegACI80MargMCS8(              AgcRegACI80MargMCS8),
    .AgcRegSatDelayCount(              AgcRegSatDelayCount),
    .AgcRegSatDynHighThr(              AgcRegSatDynHighThr),
    .AgcRegSatLowThr(                  AgcRegSatLowThr),
    .AgcRegSatDynLowThr(               AgcRegSatDynLowThr),
    .AgcRegDetFallThrqdBm(             AgcRegDetFallThrqdBm),
    .AgcRegDetRiseThrqdBm(             AgcRegDetRiseThrqdBm),
    .AgcRegDelRampDownTap(             AgcRegDelRampDownTap),
    .AgcRegDetRampDown(                AgcRegDetRampDown),
    .AgcRegDelRampUpTap(               AgcRegDelRampUpTap),
    .AgcRegDetRampUp(                  AgcRegDetRampUp),
    .AgcRegADCPowDisNdl(               AgcRegADCPowDisNdl),
    .AgcRegADCPowDisThrdBV(            AgcRegADCPowDisThrdBV),
    .AgcRegDelPlatTap(                 AgcRegDelPlatTap),
    .AgcRegDetPlat(                    AgcRegDetPlat),
`ifdef RW_NX_DERIV_80211B
    .AgcRegDC4DSSSCompType(            AgcRegDC4DSSSCompType),
    .AgcRegDC4DSSSHoldTime(            AgcRegDC4DSSSHoldTime),
    .AgcRegDC4DSSSZeroTime(            AgcRegDC4DSSSZeroTime),
`endif
    .AgcRegDC4CenteredCompType(        AgcRegDC4CenteredCompType),
    .AgcRegDC4CenteredHoldTime(        AgcRegDC4CenteredHoldTime),
    .AgcRegDC4CenteredZeroTime(        AgcRegDC4CenteredZeroTime),
    .AgcRegDC4PrimaryCompType(         AgcRegDC4PrimaryCompType),
    .AgcRegDC4PrimaryHoldTime(         AgcRegDC4PrimaryHoldTime),
    .AgcRegDC4PrimaryZeroTime(         AgcRegDC4PrimaryZeroTime),
    .AgcRegDC4ADCCompType(             AgcRegDC4ADCCompType),
    .AgcRegDC4ADCHoldTime(             AgcRegDC4ADCHoldTime),
    .AgcRegDC4ADCZeroTime(             AgcRegDC4ADCZeroTime),
`ifdef RW_RADAR_EN
    .AgcRegDC4RadarCompType(           AgcRegDC4RadarCompType),
    .AgcRegDC4RadarHoldTime(           AgcRegDC4RadarHoldTime),
    .AgcRegDC4RadarZeroTime(           AgcRegDC4RadarZeroTime),
`endif // RW_RADAR_EN
    .AgcRegDelStableDC(                AgcRegDelStableDC),
    .AgcRegFsmEvent0(                  AgcRegFsmEvent0),
    .AgcRegFsmEvent1(                  AgcRegFsmEvent1),
    .AgcRegFsmEvent2(                  AgcRegFsmEvent2),
    .AgcRegFsmEvent3(                  AgcRegFsmEvent3),
    .AgcRegHTSTFGainEn(                AgcRegHTSTFGainEn),
    .AgcRegAgcFsmReset(                AgcRegAgcFsmReset),
`ifdef RW_RADAR_EN
    .AgcRegRadarDetEn(                 AgcRegRadarDetEn),
`endif // RW_RADAR_EN
    .AgcRegRifsDetEn(                  AgcRegRifsDetEn),
    .AgcRegModeB(                      AgcRegModeB),
    .AgcRegModeA(                      AgcRegModeA),
    .AgcRegGPSetting(                  AgcRegGPSetting),
    .AgcRegChCombMode(                 AgcRegChCombMode),
    .AgcRegNBitAdc(                    AgcRegNBitAdc),
    .AgcRegVPeakADCqdBV(               AgcRegVPeakADCqdBV),
    .AgcRegADCdBVThr(                  AgcRegADCdBVThr),
    .AgcRegADCPowBiasqdBV(             AgcRegADCPowBiasqdBV),
    .AgcRegADCdBmThr(                  AgcRegADCdBmThr),
    .AgcRegADCPowBiasqdBm(             AgcRegADCPowBiasqdBm),
    .AgcRegInBd40SPowBiasqdBm(         AgcRegInBd40SPowBiasqdBm),
    .AgcRegInBd20SPowBiasqdBm(         AgcRegInBd20SPowBiasqdBm),
    .AgcRegInBd20PPowBiasqdBm(         AgcRegInBd20PPowBiasqdBm),
    .AgcRegInBddBVThr(                 AgcRegInBddBVThr),
    .AgcRegInBdRnd(                    AgcRegInBdRnd),
    .AgcRegInBddBmThr(                 AgcRegInBddBmThr),
    .AgcRegFE40Gain(                   AgcRegFE40Gain),
    .AgcRegFE20Gain(                   AgcRegFE20Gain),
    .AgcRegDelCCARampDownTap (         AgcRegDelCCARampDownTap),
    .AgcRegDelCCARampUpTap(            AgcRegDelCCARampUpTap),
    .AgcRegCCADetRampDown (            AgcRegCCADetRampDown),
    .AgcRegCCADetRampUp(               AgcRegCCADetRampUp),
    .AgcRegInbdCCA20PPowMindBm(        AgcRegInbdCCA20PPowMindBm),
    .AgcRegCCA20PFallThrdBm(           AgcRegCCA20PFallThrdBm),
    .AgcRegDisCCAEn(                   AgcRegDisCCAEn),
    .AgcRegSatCCAEn(                   AgcRegSatCCAEn),
    .AgcRegCCA20PRiseThrdBm(           AgcRegCCA20PRiseThrdBm),
    .AgcRegInbdCCA20SPowMindBm(        AgcRegInbdCCA20SPowMindBm),
    .AgcRegCCA20SFallThrdBm(           AgcRegCCA20SFallThrdBm),
    .AgcRegCCA20SRiseThrdBm(           AgcRegCCA20SRiseThrdBm),
    .AgcRegInbdCCA40SPowMindBm(        AgcRegInbdCCA40SPowMindBm),
    .AgcRegCCA40SFallThrdBm(           AgcRegCCA40SFallThrdBm),
    .AgcRegCCA40SRiseThrdBm(           AgcRegCCA40SRiseThrdBm),
    .AgcRegCCAFlag3Ctrl(               AgcRegCCAFlag3Ctrl),
    .AgcRegCCAFlag2Ctrl(               AgcRegCCAFlag2Ctrl),
    .AgcRegCCAFlag1Ctrl(               AgcRegCCAFlag1Ctrl),
    .AgcRegCCAFlag0Ctrl(               AgcRegCCAFlag0Ctrl),
    .AgcRegAntSelCCA40s(               AgcRegAntSelCCA40s),
    .AgcRegAntSelCCA20s(               AgcRegAntSelCCA20s),
    .AgcRegCCADemod(                   AgcRegCCADemod),
    .AgcRegCCACSEn(                    AgcRegCCACSEn),
    .AgcRegCCARampUDen(                AgcRegCCARampUDen),
    .AgcRegCCAEnergyEn(                AgcRegCCAEnergyEn),
    .AgcRegRxStateCca20SSel(           AgcRegRxStateCca20SSel),
    .AgcRegRxStateCca20PSel(           AgcRegRxStateCca20PSel),
    .AgcRegRxStateCca40SSel(           AgcRegRxStateCca40SSel),
    .AgcRegCCATimeOut(                 AgcRegCCATimeOut),
    .AgcRegIdInbdPowGapDnqdBm(         AgcRegIdInbdPowGapDnqdBm),
    .AgcRegIdInbdPowGapUpqdBm(         AgcRegIdInbdPowGapUpqdBm),
    .AgcRegInbdPowInfThrdBm(           AgcRegInbdPowInfThrdBm),
    .AgcRegInbdPowSupThrdBm(           AgcRegInbdPowSupThrdBm),
    .AgcRegADCPowInfThrdBV(            AgcRegADCPowInfThrdBV),
    .AgcRegADCPowSupThrdBV(            AgcRegADCPowSupThrdBV),
    .AgcRegADCPowInfThrdBm(            AgcRegADCPowInfThrdBm),
    .AgcRegADCPowSupThrdBm(            AgcRegADCPowSupThrdBm),
`ifdef RW_RADAR_EN
    .AgcRegAntSelRadar(                AgcRegAntSelRadar),
    .AgcRegFreqSingGap(                AgcRegFreqSingGap),
    .AgcRegFreqSing(                   AgcRegFreqSing),
    .AgcRegFomSingGap(                 AgcRegFomSingGap),
    .AgcRegFomSing(                    AgcRegFomSing),
    .PulseTimerClear(                  PulseTimerClearSync),
    .AgcRegPulseIrqFifoThr(            AgcRegPulseIrqFifoThr),
    .AgcRegPulseIrqTimeOut(            AgcRegPulseIrqTimeOut),
`endif // RW_RADAR_EN
    .CfgRegBRxShift(                   CfgRegBRxShift),
    .CfgRegBTxShift(                   CfgRegBTxShift),
    .CfgRegBRxPathSel(                 CfgRegBRxPathSel),
    .CfgRegRxPathSelFromReg(           CfgRegRxPathSelFromReg),
    //
    .CCATimeOutErrIrq(                 CCATimeOutErrIrq),
`ifdef RW_RADAR_EN
    .RadarIrq(                         RadarIrq),
`endif // RW_RADAR_EN
`ifdef RW_NX_FIQ_COMP_EN
     // fIQ Imbalance
    .fIQCollStartP(                    fIQCollStartP),
    .fIQCollDone(                      fIQCollDone),
    .fIQEstStartP(                     fIQEstStartP),
    .fIQEstDone(                       fIQEstDone),
    .CfgRegfIQCalEn(                   CfgRegfIQCalEn),
`ifdef RW_NX_DERIV_FE_PATH1
    .CfgRegfIQPathSel(                 CfgRegfIQPathSel),
`endif
    .CfgRegfIQTxRx(                    CfgRegfIQTxRx),
    .CfgRegfIQTxBypass(                CfgRegfIQTxBypass),
    .CfgRegfIQRxBypass(                CfgRegfIQRxBypass),
    .CfgRegfIQCollPath(                CfgRegfIQCollPath),
    .CfgRegfIQCollWrOffset(            CfgRegfIQCollWrOffset),
    .CfgRegfIQCollRdOffset(            CfgRegfIQCollRdOffset),
    .CfgRegfIQCollSize(                CfgRegfIQCollSize),
    .CfgRegfIQEstIOffset(              CfgRegfIQEstIOffset),
    .CfgRegfIQEstQOffset(              CfgRegfIQEstQOffset),
    .CfgRegfIQEstSize(                 CfgRegfIQEstSize),
    .CfgRegfIQTxDel(                   CfgRegfIQTxDel),
    .CfgRegfIQRxDel(                   CfgRegfIQRxDel),
    .CfgRegfIQCollDel(                 CfgRegfIQCollDel),
    .CfgRegfIQEstStep(                 CfgRegfIQEstStep),
    .CfgRegfIQEstNite(                 CfgRegfIQEstNite),
    .CfgRegfIQCoeff0(                  CfgRegfIQCoeff0),
    .CfgRegfIQCoeff1(                  CfgRegfIQCoeff1),
    .CfgRegfIQCoeff2(                  CfgRegfIQCoeff2),
    .CfgRegfIQCoeff3(                  CfgRegfIQCoeff3),
    .CfgRegfIQCoeff4(                  CfgRegfIQCoeff4),
    .CfgRegfIQCoeff5(                  CfgRegfIQCoeff5),
    .CfgRegfIQCoeff6(                  CfgRegfIQCoeff6),
    .CfgRegfIQCoeff7(                  CfgRegfIQCoeff7),
    .CfgRegfIQCoeff8(                  CfgRegfIQCoeff8),
    .CfgRegfIQCoeff9(                  CfgRegfIQCoeff9),
    .CfgRegfIQCoeff10(                 CfgRegfIQCoeff10),
    .CfgRegfIQCoeff11(                 CfgRegfIQCoeff11),
    .CfgRegfIQCoeff12(                 CfgRegfIQCoeff12),
    .CfgRegfIQCoeff13(                 CfgRegfIQCoeff13),
    .CfgRegfIQCoeff14(                 CfgRegfIQCoeff14),
    .CfgRegfIQCoeff15(                 CfgRegfIQCoeff15),
    .CfgRegfIQCoeff16(                 CfgRegfIQCoeff16),
    .CfgRegfIQCoeff17(                 CfgRegfIQCoeff17),
    .CfgRegfIQCoeff18(                 CfgRegfIQCoeff18),
    .CfgRegfIQCoeff19(                 CfgRegfIQCoeff19),
    .CfgRegfIQCoeffUpdate(             fIQCoeffUpdate),
    // Stats
    .StRegfIQToggle0(                  fIQStatToggle0),
    .StRegfIQRxEstError0(              fIQRxEstError0),
    .StRegfIQTxEstError0(              fIQTxEstError0),
    .StRegfIQCoeff0(                   fIQStatCoeff0),
    .StRegfIQCoeff1(                   fIQStatCoeff1),
    .StRegfIQCoeff2(                   fIQStatCoeff2),
    .StRegfIQCoeff3(                   fIQStatCoeff3),
    .StRegfIQCoeff4(                   fIQStatCoeff4),
    .StRegfIQCoeff5(                   fIQStatCoeff5),
    .StRegfIQCoeff6(                   fIQStatCoeff6),
    .StRegfIQCoeff7(                   fIQStatCoeff7),
    .StRegfIQCoeff8(                   fIQStatCoeff8),
    .StRegfIQCoeff9(                   fIQStatCoeff9),
    .StRegfIQCoeff10(                  fIQStatCoeff10),
    .StRegfIQCoeff11(                  fIQStatCoeff11),
    .StRegfIQCoeff12(                  fIQStatCoeff12),
    .StRegfIQCoeff13(                  fIQStatCoeff13),
    .StRegfIQCoeff14(                  fIQStatCoeff14),
    .StRegfIQCoeff15(                  fIQStatCoeff15),
    .StRegfIQCoeff16(                  fIQStatCoeff16),
    .StRegfIQCoeff17(                  fIQStatCoeff17),
    .StRegfIQCoeff18(                  fIQStatCoeff18),
    .StRegfIQCoeff19(                  fIQStatCoeff19),
`ifdef RW_NX_DERIV_FE_PATH1
    .StRegfIQToggle1(                  fIQStatToggle1),
    .StRegfIQRxEstError1(              fIQRxEstError1),
    .StRegfIQTxEstError1(              fIQTxEstError1),
`endif // RW_NX_DERIV_FE_PATH1
    .fIQDbgBank(                       DbgBank12),
`endif // RW_NX_FIQ_COMP_EN 
`ifdef RW_RADAR_EN
    .DbgBank8(                         DbgBank8),
`endif // RW_RADAR_EN
    .DbgBank0(                         DbgBank0),
    .DbgBank1(                         DbgBank1),
    .DbgBank2(                         DbgBank2),
    .DbgBank3(                         DbgBank3),
    .DbgBank4(                         DbgBank4),
    .DbgBank5(                         DbgBank5),
    .DbgBank6(                         DbgBank6),
    .DbgBank7(                         DbgBank7),
    .CcaDbgBank(                       DbgBank14)
  );
  
  // Control asynchronism for APB status register reading from AGC
  always @(negedge nRegBusRst, posedge RegBusClk)
  begin
    if(!nRegBusRst)
       AGCStatusRegMask <= 1'b0;
    else
       AGCStatusRegMask <= StatusTrigReqSync;
  end

  // Control asynchronism for APB status register reading from AGC
  always @(negedge nAGCRst, posedge AGCGClk)
  begin
    if(!nAGCRst)
       AGCLockStat <= 1'b0;
    else
       AGCLockStat <= (AGCOFDMLock ^ AGCOFDMHTSTF) | AGCDSSSLock;
  end

  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////
  // Coexistence Radio Interface
  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////
`ifdef RW_WLAN_COEX_EN
  // Coexistence TX Radio Interface 
  rw_coex_rc u_rw_coex_rc_tx( 
     // Clock And Reset
     .rc_rst_n      (nRCRst       ),
     .rc_clk        (RCGClk         ),
     // Modem Controls                   
     .mdm_on_req    (rc_rctxon      ),
     .mdm_on_ack    (rc_rctxack      ),
     // Radio Controls               
     .rc_on_req     (coexrc_txon_req   ),
     .rc_on_ack     (coexrc_txon_ack   ),
     // PTA Controls                 
     .rc_abort      (rc_tx_abort    ),
     // Diag Port
     .diag          (      )
  );

  // Coexistence RX Radio Interface 
  rw_coex_rc u_rw_coex_rc_rx( 
     // Clock And Reset
     .rc_rst_n      (nRCRst       ),
     .rc_clk        (RCGClk         ),
     // Modem Controls                   
     .mdm_on_req    (rc_rcrxon      ),
     .mdm_on_ack    (rc_rcrxack      ),
     // Radio Controls               
     .rc_on_req     (coexrc_rxon_req   ),
     .rc_on_ack     (coexrc_rxon_ack   ),
     // PTA Controls                 
     .rc_abort      (rc_rx_abort    ),
     // Diag Port
     .diag          (      )
  );
`else
  assign coexrc_txon_req = rc_rctxon;
  assign coexrc_rxon_req = rc_rcrxon;

  assign rc_rctxack = coexrc_txon_ack;
  assign rc_rcrxack = coexrc_rxon_ack;
`endif // RW_WLAN_COEX_EN
  
  // Add mask on coexrc_txon_req to wait ofdm_tx_p2_update assertion validating stable RCAntennaSet for Tx
  assign coexrc_txon_req_mask = coexrc_txon_req & ofdm_tx_p1_update;
  
  assign DACOn0 = coexrc_txon_req_mask;

`ifdef RW_NX_DERIV_FE_PATH1
  assign DACOn1 = coexrc_txon_req_mask & ((ofdm_tx_p1_ntx!=3'b0) | (ofdm_tx_p1_antennaset[1] & (ofdm_tx_p1_ntx==3'b0)));
`endif

  /*****************************************************************************
  * Karst RF Controller
  *****************************************************************************/
  assign RCAntennaSet = (coexrc_txon_req | coexrc_txon_ack) ? ofdm_tx_p1_antennaset: {6'b0,CfgRegActiveAnt};

  rc_karstTop U_rc_karstTop 
  ( 
    // Asynchronous Resets
    .nRCRst                    (nRCRst),  
    .nRegBusRst                (nRegBusRst),
    // Clocks
    .RCClk                     (RCGClk),
    .RegBusClk                 (RegBusClk),
    // Interrupts
    .RCRxEndP                  (RCRxEndP),
    .RCTxEndP                  (RCTxEndP),
    // RegBus interface
    .RegBusSel                 (RegBusSelRC),
    .RegBusRdEn                (RegBusRdEn),
    .RegBusWrEn                (RegBusWrEn),
    .RegBusAddr                (RegBusAddr[7:2]),
    .RegBusWrData              (RegBusWrData),
    .RegBusRdData              (RegBusRdDataRC),
    // RIUCore interface
    .RCTxOn                    (coexrc_txon_req_mask),
    .RCTxAck                   (coexrc_txon_ack),
`ifdef RW_NX_DERIV_FE_PATH1
    .RCTxGain1                 (ofdm_tx_p1_txpower[5:0]),
`endif
    .RCAntennaSet              (RCAntennaSet[1:0]),
    .RCRxOn                    (coexrc_rxon_req),
    .RCRxAck                   (coexrc_rxon_ack),
    .RCTxGain0                 (ofdm_tx_p1_txpower[5:0]),
    .RCProgRF                  (RCProgRF),
    .RCProgRFDone              (RCProgRFDone),
    .AGCRFGainCompReq          (AGCRFGainCompReq),
    .AGCRFGainCompDone         (AGCRFGainCompDone),
    .AGCGainTgt0               (AGCGainTgt0),
    .RFGain0dB                 (RFGaindB0), 
    .RFGainNF0dB               (RFGainNFdB0),
`ifdef RW_NX_DERIV_FE_PATH1
    .AGCGainTgt1               (AGCGainTgt1),
    .RFGain1dB                 (RFGaindB1), 
    .RFGainNF1dB               (RFGainNFdB1),
`endif
    // RF interface
    .RFSpiMiso                 (rf_spi_in),     
    .RFSpiCsn                  (rf_spi_ss_n),   
    .RFSpiSclk                 (rf_spi_clk),    
    .RFSpiMosi                 (rf_spi_out),    
    .RFGPIO                    (rf_gpio),
    .RFAGCFreeze               (rf_agcfreeze),
    .RFForceTxOn               (),  
    .RFTestMode                (rf_tmode),   // $todo: ask jandre 
    .RFResetn                  (rf_resetn),
    // External interface
    .RFDACOn                   (),                   
    .RFTRXSwitch               (RFTRXSwitch),            
    .RFADCOn                   (RFADCOn),                    
    .RFExtPA0On_5G9            (rf_extpaon_ch0_5G9),  
    .RFExtPA0On_2G4            (rf_extpaon_ch0_2G4),  
 `ifdef RW_NX_DERIV_FE_PATH1
    .RFExtPA1On_5G9            (rf_extpaon_ch1_5G9),  
    .RFExtPA1On_2G4            (rf_extpaon_ch1_2G4),  
`endif
    //Debug port                         
    .DbgKarstCtrl              (DbgKarstCtrl) 
  );
  
  
  assign ADCOn0  = RFADCOn & CfgRegActiveAnt[0];
  assign rf_trsw0 = RFTRXSwitch;
 
`ifdef RW_NX_DERIV_FE_PATH1
  assign ADCOn1  = RFADCOn & CfgRegActiveAnt[1];
  assign rf_trsw1 = RFTRXSwitch;
`endif

  /*****************************************************************************
  * Debug ports
  *****************************************************************************/
  assign DbgBank9  = {AgcRegAgcFsmReset,1'b0,1'b0,
                      1'b0,1'b0,1'b0,
                      RegBusSelAGCMEM,RegBusWrEn,AgcOnSync,AGCMemEn,
                      AGCMemWrEn,AGCMemAddr[3:0]};
  assign DbgBank10 = {rf_spi_clk,rf_spi_out,rf_agcfreeze,rf_gpio,RCProgRFDone,
                      RCTxEndP,RCRxEndP,AGCGainUpdatePSync,AGCStartPSync};
  assign DbgBank11 = DbgKarstCtrl;
  
`ifndef RW_NX_FIQ_COMP_EN
  assign DbgBank12 = 16'd0;
  assign DbgBank13 = 16'd0;
`else
  wire fIQStatCoeff9_IsNull;
  wire StRegfIQCoeff9_IsNull;
  wire CfgRegfIQCoeff9_IsNull;
  assign fIQStatCoeff9_IsNull = (fIQStatCoeff9[15:0]==16'd0);
  assign StRegfIQCoeff9_IsNull = (StRegfIQCoeff9[15:0]==16'd0);
  assign CfgRegfIQCoeff9_IsNull = (CfgRegfIQCoeff9[15:0]==16'd0);
  // debug port on coefficients update/read from Regbus
  assign DbgBank13 = {
    // Status read
    fIQStatCoeff9_IsNull,
    CfgRegfIQCoeffReq,
    fIQCoeffReq, 
    RegfIQCoeffReqInValid, 
    StRegfIQCoeff9_IsNull,
    // Coeff set
    CfgRegfIQCoeff9_IsNull,
    CfgRegfIQCoeffUpdate, 
    RegfIQCoeffUpdate,
    fIQCoeffUpdate, 
    RegfIQCoeffUpdateDone,
    RegfIQCoeffUpdateInValid,
    DbgBank12[4], // CfgRegCoeffValid,
    DbgBank12[3], // UpdatedCoeffValidEn[9],
    DbgBank12[2], // TxCoeff9Array0_IsNull,
    DbgBank12[1], // RxCoeff9Array0_IsNull,
    DbgBank12[0]  // SelCoeff9Array0_IsNull
  };
`endif // RW_NX_FIQ_COMP_EN

endmodule
`default_nettype wire
