//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : 
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

// The SrcStartP pulse in source domain is resynchronized to the DstStartP pulse
// in the destination domain.
// the SrcDone flag goes low when SrcStartP goes high. It goes high again after the
// DstDone flag is seen high in the destination domain and has been resynchronized
// to the source domain.
module StartDoneHandler (
  input  wire        SrcClk,
  input  wire        nSrcRst,

  input  wire        DstClk,
  input  wire        nDstRst,
  
  input  wire        SrcStartP,
  output reg         DstStartP,
  input  wire        DstDone,
  output reg         SrcDone
);

//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
  wire DstStartPcomb;
  wire SrcDoneInt;
  reg  SrcDoneIntD;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

  // Start pulse from Src to Dst clock domain
  ClkSyncPulse2Pulse UClkSyncPulse2PulseStart (
    .srcclk    (SrcClk),
    .srcresetn (nSrcRst),
    .dstclk    (DstClk),
    .dstresetn (nDstRst),
    .srcdata   (SrcStartP),
    .dstdata   (DstStartPcomb)
  );

  // Register DstStartPcomb
  always @(posedge DstClk or negedge nDstRst)
  begin
    if (nDstRst == 1'b0) begin
      DstStartP <= 1'd0;
    end else begin
      DstStartP <= DstStartPcomb;
    end
  end

  // Resync Done flag to SrcClk
  ClkSyncSimple UClkSyncSimpleDone (
    .dstclk    (SrcClk),
    .dstresetn (nSrcRst),
    .srcdata   (DstDone),
    .dstdata   (SrcDoneInt)
  );
  
  // SrcDone output must be low from SrcStartP to SrcDoneInt rising 
  always @(posedge SrcClk or negedge nSrcRst)
  begin
    if (nSrcRst == 1'b0)
    begin
      SrcDoneIntD  <= 1'b0;
      SrcDone      <= 1'b0;
    end else begin
      SrcDoneIntD  <= SrcDoneInt;
      if (SrcStartP==1'b1)
        SrcDone     <= 1'b0;
      else if (SrcDoneInt==1'b1 && SrcDoneIntD==1'd0)
        SrcDone     <= 1'b1;
    end
  end

endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
