//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : 
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

// fIQStatToggle may be faster than regbus DstClk. The aim is to capture as much values
// as possible so that the SW can have "real time" status of the estimation.
module fIQStatHandler (
  input  wire           SrcClk,
  input  wire           nSrcRst,

  input  wire           DstClk,
  input  wire           nDstRst,
  
  input  wire           fIQStatToggle,
  input  wire [12 : 0]  fIQRxEstError,
  input  wire [12 : 0]  fIQTxEstError,
  
  output wire [12 : 0]  StRegfIQRxEstError,
  output wire [12 : 0]  StRegfIQTxEstError

);

//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
  reg  SrcUpdate, GateSrcUpdate, SrcUpdateDoneD;
  wire DstUpdate, SrcUpdateDone;
  reg  fIQStatToggleD;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

  // Detect start of stat update processing
  always @(posedge SrcClk or negedge nSrcRst)
  begin
    if (nSrcRst == 1'b0) begin
      fIQStatToggleD <= 1'b0;
      SrcUpdate      <= 1'b0;
      SrcUpdateDoneD <= 1'b1;
      GateSrcUpdate  <= 1'b0;
    end else begin
      fIQStatToggleD <= fIQStatToggle;
      SrcUpdateDoneD <= SrcUpdateDone;

      // Reset GateSrcUpdate on SrcUpdateDone falling edge.
      // This indicates SrcUpdate has been low long enough to be seen in Destination domain,
      // a new update cycle can begin.
      if ((SrcUpdateDone==1'b0) && (SrcUpdateDoneD==1'b1))
        GateSrcUpdate <= 1'b0;
       
      // Reset update flag once resync done
      if (SrcUpdateDone==1'b1) begin
        SrcUpdate     <= 1'b0;
      // Start new update process on Toggle if previous update is over (GateSrcUpdate low)
      end else if ((fIQStatToggle!=fIQStatToggleD) && (GateSrcUpdate==1'b0)) begin
        SrcUpdate     <= 1'b1;
        GateSrcUpdate <= 1'b1;
      end
    end
  end

  // Resync stats to destination domain
  ClkSyncParam  
  #(
    .PARAMSIZE(     26)
  ) 
  U_fIQStatResync (
    .dstclk(       DstClk),
    .dstresetn(    nDstRst),
    .srcupdate(    SrcUpdate),
    .srcdata(      {fIQRxEstError,
                    fIQTxEstError}),
    .dstupdate(    DstUpdate),
    .dstdata(      {StRegfIQRxEstError,
                    StRegfIQTxEstError
                    })
  );

  // resync DstUpdate signal to source domain and use it to reset SrcUpdate
  ClkSyncSimple U_DstUpdateClkSyncSimple
  (
    .dstclk(     SrcClk),
    .dstresetn(  nSrcRst),
    .srcdata(    DstUpdate),
    .dstdata(    SrcUpdateDone)
   );

endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
