/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author:$
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :                                       
* Description      : fe2phy_fifo
* Simulation Notes :                                       
* Synthesis Notes  :                                        
* Application Note :                                        
* Simulator        :                                       
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*                                     
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module fe2phy_fifo
#(
`ifdef RW_NX_DERIV_FE_PATH80M
  parameter g_width80 = 10,
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
  parameter g_width40 = 10,
`endif
  parameter g_width20 = 10
)
(
  /*****************************************************************************
  * FE domain
  *****************************************************************************/
  input  wire                 fe_rst_n, 
  input  wire                 fe_clk,  
   
  input  wire [ 1:0]          fe_cbw,
  input  wire                 fe_tden,
  input  wire                 fe_valid,
`ifdef RW_NX_DERIV_FE_PATH80M
  input  wire [g_width80-1:0] fe_data80,
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
  input  wire [g_width40-1:0] fe_data40,
`endif
  input  wire [g_width20-1:0] fe_data20,
  
  /*****************************************************************************
  * PHY domain
  *****************************************************************************/
  input  wire                 phy_rst_n, 
  input  wire                 phy_clk,   
  
  
  output reg                  phy_tden,
`ifdef RW_NX_DERIV_FE_PATH80M
  output wire                 phy_valid80,
  output reg  [g_width80-1:0] phy_data80,
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
  output wire                 phy_valid40,
  output reg  [g_width40-1:0] phy_data40,
`endif
  output wire                 phy_valid20,
  output reg  [g_width20-1:0] phy_data20
);
  
  /*****************************************************************************
  * FE domain
  *****************************************************************************/
  /* input pipelining */
  reg       fe_valid_1t;
  reg       fe_tden_1t;
  reg [1:0] fe_cbw_1t;

`ifdef RW_NX_DERIV_FE_PATH80M
  reg [g_width80-1:0] fe_data80_1t;
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
  reg [g_width40-1:0] fe_data40_1t;
`endif
  reg [g_width20-1:0] fe_data20_1t;
  
  always @(posedge fe_clk,negedge fe_rst_n)
  begin
    if(!fe_rst_n)
    begin
      fe_cbw_1t    <= 2'b0;
      fe_tden_1t   <= 1'b0;
      fe_valid_1t  <= 1'b0;
`ifdef RW_NX_DERIV_FE_PATH80M
      fe_data80_1t <= {g_width80{1'b0}};
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
      fe_data40_1t <= {g_width40{1'b0}};
`endif
      fe_data20_1t <= {g_width20{1'b0}}; 
    end
    else
    begin
      fe_cbw_1t    <= fe_cbw;  
      fe_tden_1t   <= fe_tden;  
      fe_valid_1t  <= fe_valid; 
`ifdef RW_NX_DERIV_FE_PATH80M
      fe_data80_1t <= fe_data80;
`endif
`ifdef RW_NX_DERIV_FE_PATH40M
      fe_data40_1t <= fe_data40;
`endif
      fe_data20_1t <= fe_data20; 
    end
  end
  
  /* BW20 datapath */
  reg [g_width20-1:0] w_fifo20_d0;
  reg                 w_fifo20_tden0;
  reg [g_width20-1:0] w_fifo20_d1;
  reg                 w_fifo20_tden1;
  reg                 w_fifo20_ptr;
  reg                 w_start;
  reg [1:0]           w_cbw;
  reg [2:0]           w_cycle;
  
  wire                w_clr_cycle;
  wire                w_wen,w_wen20;
  
  assign w_wen       = fe_valid_1t | fe_tden_1t;
  assign w_wen20     = w_wen & w_cycle==3'd0;
  
  assign w_clr_cycle = fe_cbw_1t==2'd0 & w_cycle==3'd1 |
                       fe_cbw_1t==2'd1 & w_cycle==3'd3 |
                       fe_cbw_1t==2'd2 & w_cycle==3'd7;
  
  always @(posedge fe_clk,negedge fe_rst_n)
  begin
    if(!fe_rst_n)
    begin
      w_start        <= 1'b0;
      w_cbw          <= 2'd0;
      w_cycle        <= 3'd0;
      w_fifo20_d0    <= {g_width20{1'b0}};
      w_fifo20_tden0 <= 1'b0;
      w_fifo20_d1    <= {g_width20{1'b0}};
      w_fifo20_tden1 <= 1'b0;
      w_fifo20_ptr   <= 1'b0; 
    end
    else
    begin
      if(!w_wen)
      begin
        w_fifo20_ptr <= 1'b0;
        w_start      <= 1'b0;
        w_cycle      <= 3'd0;
      end
      else
      begin
        w_cbw   <= fe_cbw_1t;
        w_start <= 1'b1;
        
        /* cycle tracking */
        if(w_clr_cycle)
          w_cycle <= 3'd0;
        else
          w_cycle <= w_cycle + 3'd1;
      
        /* fifo write */
        if(w_wen20)
        begin
          if(!w_fifo20_ptr)
            {w_fifo20_ptr,w_fifo20_tden0,w_fifo20_d0} <= {1'b1,fe_tden_1t,fe_data20_1t};
          else
            {w_fifo20_ptr,w_fifo20_tden1,w_fifo20_d1} <= {1'b0,fe_tden_1t,fe_data20_1t};
        end
      end
    end
  end
 
`ifdef RW_NX_DERIV_FE_PATH40M
  /* BW40 datapath */
  reg [g_width40-1:0] w_fifo40_d0,w_fifo40_d1;
  reg                 w_fifo40_ptr;
  wire                w_wen40;
 
  assign w_wen40 = w_wen & (fe_cbw_1t==2'd1 & w_cycle[  0]==1'd0 |
                            fe_cbw_1t==2'd2 & w_cycle[1:0]==2'd0);
 
  always @(posedge fe_clk, negedge  fe_rst_n)
  begin
    if(!fe_rst_n)
    begin
      w_fifo40_d0  <= {g_width40{1'b0}};
      w_fifo40_d1  <= {g_width40{1'b0}};
      w_fifo40_ptr <= 1'b0; 
    end
    else
    begin
      if(!w_wen)
      begin
        w_fifo40_ptr <= 1'b0;
      end
      else if(w_wen40)
      begin
        if(!w_fifo40_ptr)
          {w_fifo40_ptr,w_fifo40_d0} <= {1'b1,fe_data40_1t};
        else
          {w_fifo40_ptr,w_fifo40_d1} <= {1'b0,fe_data40_1t};
      end
    end
  end
`endif
  
`ifdef RW_NX_DERIV_FE_PATH80M
  /* BW80 datapath */
  reg [g_width80-1:0] w_fifo80_d0,w_fifo80_d1,w_fifo80_d2;
  reg [ 1:0]          w_fifo80_ptr;
  wire                w_wen80;
  
  assign w_wen80 = w_wen & fe_cbw_1t==2'd2 & w_cycle[0]==1'd0;
  
  always @(posedge fe_clk, negedge  fe_rst_n)
  begin
    if(!fe_rst_n)
    begin
      w_fifo80_d0  <= {g_width80{1'b0}};
      w_fifo80_d1  <= {g_width80{1'b0}};
      w_fifo80_d2  <= {g_width80{1'b0}};
      w_fifo80_ptr <= 2'b0; 
    end
    else
    begin
      if(!w_wen)
      begin
        w_fifo80_ptr <=2'd0;
      end
      else if(w_wen80)
      begin
        case(w_fifo80_ptr)
          2'd0:   {w_fifo80_ptr,w_fifo80_d0} <= {2'd1,fe_data80_1t};
          2'd1:   {w_fifo80_ptr,w_fifo80_d1} <= {2'd2,fe_data80_1t};
          default:{w_fifo80_ptr,w_fifo80_d2} <= {2'd0,fe_data80_1t};
        endcase
      end
    end
  end
`endif
 
  /*****************************************************************************
  * PHY domain
  *****************************************************************************/
  /* BW20 datapath */
  wire        r_start;
  reg         r_start_1t;
  reg  [ 2:0] r_cycle;
  reg  [ 1:0] r_cbw;
  reg         r_fifo20_ptr;
  reg         r_valid20;
  wire        r_clr_cycle;
  wire        r_ren20;
  
  /* resync fe to phy */
  ClkSyncSimple u_phy2fe_start_resync
  ( 
    .dstclk(         phy_clk),
    .dstresetn(      phy_rst_n),
    .srcdata(        w_start),   
    .dstdata(        r_start)   
  );
  
  
//   assign r_clr_cycle = r_cbw==2'd0 & r_cycle==3'd2 | r_cycle==3'd5;
  assign r_clr_cycle = r_cycle==3'd5;
  assign r_ren20     = r_clr_cycle | ~r_start_1t;

  always @(posedge phy_clk, negedge phy_rst_n)
  begin
    if(!phy_rst_n)
    begin
      r_start_1t     <= 1'b0;
      r_cycle        <= 3'd0;
      r_cbw          <= 2'd0;
      r_fifo20_ptr   <= 1'b0;
      r_valid20      <= 1'b0;
      phy_tden       <= 1'b0;
      phy_data20     <= {g_width20{1'b0}};
    end
    else
    begin
      /* delay for edge detection */
      r_start_1t     <= r_start;
      
      if(r_start)
      begin
        /* fifo not empty */
        if(!r_start_1t)
        begin
          /* first fifo read */
          r_cycle      <= 3'd0;
          r_cbw        <= w_cbw;
        end
        else
        begin
          /* track cycle */
          if(r_clr_cycle)
            r_cycle <= 3'd0;
          else
            r_cycle <= r_cycle + 3'd1;
        end
          
        if(r_ren20)
        begin
          /* subsequent fifo read */
         if(!r_fifo20_ptr)
            {r_fifo20_ptr,phy_tden,phy_data20} <= {1'b1,w_fifo20_tden0,w_fifo20_d0};
          else
            {r_fifo20_ptr,phy_tden,phy_data20} <= {1'b0,w_fifo20_tden1,w_fifo20_d1};
        end
        r_valid20 <= r_ren20;
      end
      else
      begin
        /* fifo empty */
        phy_tden       <= 1'b0;
        phy_data20     <= {g_width20{1'b0}};
        r_cycle        <= 3'd0;
        r_cbw          <= 2'd0;
        r_fifo20_ptr   <= 1'b0;
        r_valid20    <= 1'b0;
      end
    end
  end
  
  assign phy_valid20 = r_valid20;
  
`ifdef RW_NX_DERIV_FE_PATH40M
  /* BW40 datapath */
  reg    r_fifo40_ptr;
  wire   r_ren40;
  reg    r_valid40;
     
  assign r_ren40 =  r_cycle==3'd2 | r_cycle==3'd5 | ~r_start_1t;
  
  always @(posedge phy_clk, negedge phy_rst_n)
  begin
    if(!phy_rst_n)
    begin
      r_valid40    <= 1'b0;
      r_fifo40_ptr <= 1'b0;
      phy_data40   <= {g_width40{1'b0}};
    end
    else if(r_start)
    begin
      if(r_ren40)                                             
      begin                                                   
        if(!r_fifo40_ptr)                                     
          {r_fifo40_ptr,phy_data40} <= {1'b1,w_fifo40_d0};    
        else                                                  
          {r_fifo40_ptr,phy_data40} <= {1'b0,w_fifo40_d1};    
      end                                                     
      r_valid40 <= r_ren40;                                 
    end
    else
    begin
      /* inactive */
      phy_data40   <= {g_width40{1'b0}};
      r_valid40    <= 1'b0;
      r_fifo40_ptr <= 1'b0;
    end
  end

  assign phy_valid40 = r_valid40 & r_cbw!=2'd0;
`endif
`ifdef RW_NX_DERIV_FE_PATH80M
  /* BW80datapath */
  reg  [ 1:0] r_fifo80_ptr;
  reg         r_valid80;
  wire        r_ren80;
  
  assign r_ren80 = r_cycle==3'd0 || r_cycle==3'd2|| r_cycle==3'd3 || r_cycle==3'd5 || ~r_start_1t;
  
  always @(posedge phy_clk, negedge phy_rst_n)
  begin
    if(!phy_rst_n)
    begin
      r_fifo80_ptr <= 2'b0;
      r_valid80    <= 1'b0;
      phy_data80   <= {g_width80{1'b0}};
    end
    else if(r_start)
    begin
      if(!r_start_1t)                                                                      
      begin                                                                               
        /* first fifo read */                                                             
        r_valid80 <= 1'b1;
        {r_fifo80_ptr,phy_data80} <= {2'd1,w_fifo80_d0};          
      end                                                                                 
      else                                                              
      begin                                                                               
        if(r_ren80)                                                                       
        begin                                                                             
          case(r_fifo80_ptr)                                                              
            2'd0:    {r_fifo80_ptr,phy_data80} <= {2'd1,w_fifo80_d0};    
            2'd1:    {r_fifo80_ptr,phy_data80} <= {2'd2,w_fifo80_d1};    
            default: {r_fifo80_ptr,phy_data80} <= {2'd0,w_fifo80_d2};    
          endcase                                                                         
        end                                                                               
        r_valid80 <= r_ren80;                                                            
      end                                                                                 
    end
    else                                 
    begin                                
      /* fifo empty */                   
      phy_data80   <= {g_width80{1'b0}};  
      r_valid80    <= 1'b0;               
      r_fifo80_ptr <= 2'b0;
    end                                  
  end

  assign phy_valid80 = r_valid80 & r_cbw==2'd2;
`endif
  
endmodule
`default_nettype wire
