#-------------------------------------------------------------------------------
set block   "RW_sub_system"
set project "project_${block}"
set workdir "work.${block}"
#-------------------------------------------------------------------------------
if {[version -short]>=2018.3} {
   set bdversion "2018.3"
} elseif {[version -short]>=2017.3} {
   set bdversion "2017.3"
} else {
   puts "Error: Vivado version not supported !!!"
   exit
}
#-------------------------------------------------------------------------------
create_project ${project} ${workdir} -force -part xc7v2000tflg1925-1
add_files -fileset [current_fileset] -norecurse _vivado/${bdversion}/${block}.bd
#-------------------------------------------------------------------------------
set_property SYNTH_CHECKPOINT_MODE Singular [get_files ${block}.bd]
generate_target {Synthesis Simulation} [get_files ${block}.bd]
create_ip_run -force [get_files ${block}.bd]
launch_run -jobs 4 [get_runs ${block}_synth_1]
wait_on_run [get_runs ${block}_synth_1]
open_run [get_runs ${block}_synth_1]
write_edif    -force                  _vivado/${block}.edf
write_verilog -force -mode design     _vivado/${block}_netlist.v
write_verilog -force -mode funcsim    _vivado/${block}_funcsim.v
write_verilog -force -mode synth_stub _vivado/${block}_blackbox.v
write_xdc     -force -constraints all _vivado/${block}.xdc
#-------------------------------------------------------------------------------
start_gui
open_bd_design [get_files ${block}.bd]
regenerate_bd_layout
write_bd_layout -force -format pdf -orientation landscape _vivado/${block}.pdf
stop_gui
#-------------------------------------------------------------------------------
current_project ${project}
close_project
#-------------------------------------------------------------------------------
