/*****************************************************************************
* sram_sp_4096x32
*****************************************************************************/
module sram_sp_4096x32
(
  input  wire           clka,
  input  wire           ena,
  input  wire  [ 3:0]   wea,
  input  wire  [11:0]   addra,
  input  wire  [31:0]   dina,
  output reg   [31:0]   douta
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/*****************************************************************************
* sram_sp_8192x32
*****************************************************************************/
module sram_sp_8192x32
(
  input  wire           clka,
  input  wire           ena,
  input  wire  [ 3:0]   wea,
  input  wire  [12:0]   addra,
  input  wire  [31:0]   dina,
  output reg   [31:0]   douta
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/*****************************************************************************
* sram_sp_8192x16
*****************************************************************************/
module sram_sp_8192x16
(
  input  wire           clka,
  input  wire           ena,
  input  wire  [ 1:0]   wea,
  input  wire  [12:0]   addra,
  input  wire  [15:0]   dina,
  output reg   [15:0]   douta
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/*****************************************************************************
* sram_sp_32768x16
*****************************************************************************/
module sram_sp_32768x16
(
  input  wire           clka,
  input  wire           ena,
  input  wire  [ 1:0]   wea,
  input  wire  [14:0]   addra,
  input  wire  [15:0]   dina,
  output reg   [15:0]   douta
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/*****************************************************************************
* sram_sp_32768x8
*****************************************************************************/
module sram_sp_32768x8
(
  input  wire           clka,
  input  wire           ena,
  input  wire  [ 0:0]   wea,
  input  wire  [14:0]   addra,
  input  wire  [ 7:0]   dina,
  output reg   [ 7:0]   douta
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/*****************************************************************************
* sram_sp_65536x8
*****************************************************************************/
module sram_sp_65536x8
(
  input  wire           clka,
  input  wire           ena,
  input  wire  [ 0:0]   wea,
  input  wire  [15:0]   addra,
  input  wire  [ 7:0]   dina,
  output reg   [ 7:0]   douta
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/*****************************************************************************
* sram_sp_256x32
*****************************************************************************/
module sram_sp_256x32
(
  input  wire           clka,
  input  wire           ena,
  input  wire   [0:0]   wea,
  input  wire  [ 7:0]   addra,
  input  wire  [31:0]   dina,
  output reg   [31:0]   douta
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/*****************************************************************************
* sram_sp_64x187
*****************************************************************************/
module sram_sp_64x187
(
  input  wire           clka,
  input  wire           ena,
  input  wire   [0:0]   wea,
  input  wire  [ 5:0]   addra,
  input  wire  [186:0]  dina,
  output reg   [186:0]  douta
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/*****************************************************************************
* sram_sp_64x315
*****************************************************************************/
module sram_sp_64x315
(
  input  wire           clka,
  input  wire           ena,
  input  wire   [0:0]   wea,
  input  wire  [ 5:0]   addra,
  input  wire  [314:0]  dina,
  output reg   [314:0]  douta
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/*****************************************************************************
* sram_dp_64x38
*****************************************************************************/
module sram_dp_64x38
(
  input  wire           clka,
  input  wire  [0:0]    wea,
  input  wire [ 5:0]    addra,
  input  wire [37:0]    dina,

  input  wire           clkb,
  input  wire           enb,
  input  wire [ 5:0]    addrb,
  output reg  [37:0]    doutb
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule


/*****************************************************************************
* sram_dp_64x36
*****************************************************************************/
module sram_dp_64x36
(
  input  wire           clka,
  input  wire  [0:0]    wea,
  input  wire [ 5:0]    addra,
  input  wire [35:0]    dina,

  input  wire           clkb,
  input  wire           enb,
  input  wire [ 5:0]    addrb,
  output reg  [35:0]    doutb
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/*****************************************************************************
* sram_dp_128x8
*****************************************************************************/
module sram_dp_128x8
(
  input  wire           clka,
  input  wire  [0:0]    wea,
  input  wire [ 6:0]    addra,
  input  wire [ 7:0]    dina,

  input  wire           clkb,
  input  wire           enb,
  input  wire [ 6:0]    addrb,
  output reg  [ 7:0]    doutb
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/*****************************************************************************
* sram_tdp_256x8
*****************************************************************************/
module sram_tdp_256x8
(
  input  wire           clka,
  input  wire           ena,
  input  wire  [0:0]    wea,
  input  wire [ 7:0]    addra,
  input  wire [ 7:0]    dina,
  output reg  [ 7:0]    douta,

  input  wire           clkb,
  input  wire           enb,
  input  wire  [0:0]    web,
  input  wire [ 7:0]    addrb,
  input  wire [ 7:0]    dinb,
  output reg  [ 7:0]    doutb
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/****************************************************************************
* sram_tdp_16kx32
*****************************************************************************/
module sram_tdp_16kx32
(
  input  wire          clka,
  input  wire          ena,
  input  wire          wea,
  input  wire  [13:0]  addra,
  input  wire  [31:0]  dina,
  output reg   [31:0]  douta,
  
  input  wire          clkb,
  input  wire          enb,
  input  wire  [ 0:0]  web,
  input  wire  [13:0]  addrb,
  input  wire  [31:0]  dinb,
  output reg   [31:0]  doutb
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/*****************************************************************************
* sram_dp_32x31
*****************************************************************************/
module sram_dp_32x31
(
  input  wire           clka,
  input  wire  [ 0:0]   wea,
  input  wire  [ 4:0]   addra,
  input  wire  [30:0]   dina,
  
  input  wire           clkb,
  input  wire           enb,
  input  wire  [ 4:0]   addrb,
  output reg   [30:0]   doutb
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/*****************************************************************************
* sram_dp_256x26
*****************************************************************************/
module sram_dp_256x26
(
  input  wire           clka,
  input  wire  [ 0:0]   wea,
  input  wire  [ 7:0]   addra,
  input  wire  [25:0]   dina,
  
  input  wire           clkb,
  input  wire           enb,
  input  wire  [ 7:0]   addrb,
  output reg   [25:0]   doutb
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/*****************************************************************************
* sram_dp_256x40
*****************************************************************************/
module sram_dp_256x40
(
  input  wire           clka,
  input  wire  [ 0:0]   wea,
  input  wire  [ 7:0]   addra,
  input  wire  [39:0]   dina,
  
  input  wire           clkb,
  input  wire           enb,
  input  wire  [ 7:0]   addrb,
  output reg   [39:0]   doutb
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule


/*****************************************************************************
* sram_dp_128x52
*****************************************************************************/
module sram_dp_128x52
(
  input  wire           clka,
  input  wire  [ 0:0]   wea,
  input  wire  [ 6:0]   addra,
  input  wire  [51:0]   dina,
  
  input  wire           clkb,
  input  wire           enb,
  input  wire  [ 6:0]   addrb,
  output reg   [51:0]   doutb
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/****************************************************************************
* sram_sp_256x76
*****************************************************************************/
module sram_sp_256x76
(
  input  wire           clka,
  input  wire           ena,
  input  wire  [ 0:0]   wea,
  input  wire  [ 7:0]   addra,
  input  wire  [75:0]   dina,
  output reg   [75:0]   douta
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/****************************************************************************
* sram_sp_512x32
*****************************************************************************/
module sram_sp_512x32
(
  input  wire           clka,
  input  wire           ena,
  input  wire  [ 0:0]   wea,
  input  wire  [ 8:0]   addra,
  input  wire  [31:0]   dina,
  output reg   [31:0]   douta
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

/****************************************************************************
* sram_sp_512x10
*****************************************************************************/
module sram_sp_512x10
(
  input  wire           clka,
  input  wire           ena,
  input  wire  [ 0:0]   wea,
  input  wire  [ 8:0]   addra,
  input  wire  [ 9:0]   dina,
  output reg   [ 9:0]   douta
);
/* synthesis syn_black_box */
/* synthesis syn_macro=0 */
endmodule

