#-------------------------------------------------------------------------------
set block   "rw_he_v7"
set workdir "par"
set part    "xc7v2000tflg1925-1"

set TIME_start [expr [clock clicks -milliseconds]/1000]
#-------------------------------------------------------------------------------
if {[version -short]>=2018.3} {
   set bdversion "2018.3"
} elseif {[version -short]>=2017.3} {
   set bdversion "2017.3"
} else {
   puts "Error: Vivado version not supported !!!"
   exit
}
#-------------------------------------------------------------------------------
if {[llength $argv] == 0} {
   puts "RW_INFO: Error, the placement directive name is missing."
   quit
} else {
   set place_directive [lindex $argv 0]
}
#-------------------------------------------------------------------------------
proc hh:mm:ss {secs} {
       set h [expr {${secs}/3600}]
       incr secs [expr {${h}*-3600}]
       set m [expr {${secs}/60}]
       set s [expr {${secs}%60}]
       format "%02.2d:%02.2d:%02.2d" ${h} ${m} ${s}
}
#-------------------------------------------------------------------------------
proc wait_license {} {}
if {[file exist ${block}_func.tcl]==1} {
   source ${block}_func.tcl
}
#-------------------------------------------------------------------------------
proc report_phase {phase text start} {
  set TIME_taken [hh:mm:ss [expr [clock clicks -milliseconds]/1000 - $start]]
  puts "RW_INFO: VIVADO Phase ${phase}/10 : ${text} (${TIME_taken})"
}
#-------------------------------------------------------------------------------
proc report_status {phase text} {
   set wns [get_property SLACK [get_timing_paths -setup -quiet]]
   set whs [get_property SLACK [get_timing_paths -hold  -quiet]]
   set tns 0
   set ths 0
   foreach tp [get_timing_paths -setup -quiet -max_paths 100000 -filter {SLACK < 0}] {
      set tns [expr $tns + [get_property SLACK $tp]]
   }
   foreach tp [get_timing_paths -hold  -quiet -max_paths 100000 -filter {SLACK < 0}] {
      set ths [expr $ths + [get_property SLACK $tp]]
   }
   set setup "WNS=[format {%2.3f} ${wns}] / TNS=[format {%2.3f} ${tns}]"
   set hold  "WHS=[format {%2.3f} ${whs}] / THS=[format {%2.3f} ${ths}]"
   puts "RW_INFO: VIVADO Phase ${phase}/10 : ${text}: ${setup} - ${hold}"
}
#-------------------------------------------------------------------------------
proc write_status {statusfile} {
   set fid [open ${statusfile} w]

   set wns [get_property SLACK [get_timing_paths -setup -quiet]]
   set whs [get_property SLACK [get_timing_paths -hold  -quiet]]
   set tns 0
   set ths 0
   foreach tp [get_timing_paths -setup -quiet -max_paths 100000 -filter {SLACK < 0}] {
      set tns [expr ${tns} + [get_property SLACK ${tp}]]
   }
   foreach tp [get_timing_paths -hold  -quiet -max_paths 100000 -filter {SLACK < 0}] {
      set ths [expr ${ths} + [get_property SLACK ${tp}]]
   }
   puts  ${fid} "set wns ${wns}"
   puts  ${fid} "set tns ${tns}"
   puts  ${fid} "set whs ${whs}"
   puts  ${fid} "set ths ${ths}"
   close ${fid}
}
#-------------------------------------------------------------------------------
# Remove old design checkpoint & status, if exist.
if {[file exist ${workdir}/${block}_${place_directive}_postroute_physopted.dcp]==1} {
   exec rm -f ${workdir}/${block}_${place_directive}_postroute_physopted.dcp
}
if {[file exist ${workdir}/${block}_${place_directive}_status.tcl]==1} {
   exec rm -f ${workdir}/${block}_${place_directive}_status.tcl
}
#-------------------------------------------------------------------------------
# Create in-memory project
set_part ${part}
#-------------------------------------------------------------------------------
# Read design & constraints
report_phase "01" "Read design & constraints" ${TIME_start}
read_bd   ../_vivado/${bdversion}/RW_sub_system.bd
read_edif ./synthesis/rev_1/${block}.edf
read_xdc -unmanaged ./${block}.xdc
read_xdc  ./${block}_common.xdc
#-------------------------------------------------------------------------------
#set_param general.maxThreads 1
#-------------------------------------------------------------------------------
report_phase  "--" "Wait License" ${TIME_start}
wait_license
report_phase  "02" "link_design" ${TIME_start}
link_design -top ${block}
report_status "02" "link_design"
#-------------------------------------------------------------------------------
report_phase  "03" "opt_design" ${TIME_start}
wait_license
opt_design
report_status "03" "opt_design"
#-------------------------------------------------------------------------------
if {[file exist ./${block}.dcp]==1} {
   report_phase "04" "read_checkpoint" ${TIME_start}
   read_checkpoint -incremental ./${block}.dcp
} else {
   report_phase "04" "read_checkpoint skipped" ${TIME_start}
}
#-------------------------------------------------------------------------------
#open_checkpoint ${workdir}/${block}_preplace.dcp
report_phase  "--" "Wait License" ${TIME_start}
wait_license
report_phase  "05" "place_design ($place_directive)" ${TIME_start}
place_design -directive $place_directive -timing_summary
report_status "05" "place_design ($place_directive)"
#write_checkpoint -force ${workdir}/${block}_${place_directive}_postplace
#-------------------------------------------------------------------------------
report_timing_summary -warn_on_violation -max_paths 10 \
   -file ${workdir}/${block}_${place_directive}_timing_summary_postplace.rpt \
   -rpx  ${workdir}/${block}_${place_directive}_timing_summary_postplace.rpx
#-------------------------------------------------------------------------------
# Abort if TNS > 10000ns (or WNS < -2ns ?)
set tns 0
foreach tp [get_timing_paths -quiet -max_paths 100000 -filter {SLACK < 0}] {
   set tns [expr $tns + [get_property SLACK $tp]]
}
if {$tns<=-10000} {
   report_phase "--" "Aborted" ${TIME_start}
   quit
}
#-------------------------------------------------------------------------------
# Force Critical Net replication (should help place&route)
# -> only for Vivado 2016.2 : this step increase the timing violation with newer
#                             version of Vivado
if {[version -short]=="2016.2"} {
   set nets [list]
   # High Fanout Reset
   lappend nets u_bdtx_cleaner/*
   lappend nets u_bdrx_cleaner/*
   lappend nets u_agc_cleaner/*
   lappend nets u_fe_cleaner/*
   lappend nets u_mdmb_cleaner/*
   lappend nets u_phy_cleaner/*
   lappend nets u_reset_cleaner_plf/*
   lappend nets u_reset_cleaner_mac/*
   lappend nets u_axi_por_reset_cleaner/*
   lappend nets u_plf_por_reset_cleaner/*
   # Embedded LA registers driving 256 block RAM.
   lappend nets u_rw_nx_la/la_ram_addra[*]
   lappend nets u_rw_nx_la/la_ram_addrb[*]
   lappend nets u_rw_nx_la/la_ram_wea

   
   phys_opt_design -force_replication_on_nets \
      [get_nets [get_pins -filter {DIRECTION==OUT} -hierarchical $nets]]
}

## High Fanout Registers
#phys_opt_design -force_replication_on_nets \
#   [get_nets  -filter {FLAT_PIN_COUNT>=4000} -of_objects \
#   [get_pins  -filter {DIRECTION==OUT}       -of_objects \
#   [get_cells -filter {PRIMITIVE_GROUP==FLOP_LATCH} -hierarchical *]]]
#-------------------------------------------------------------------------------
report_phase  "--" "Wait License" ${TIME_start}
wait_license
report_phase  "06" "phys_opt_design" ${TIME_start}
phys_opt_design \
   -fanout_opt        -placement_opt     \
   -rewire            -critical_cell_opt \
   -bram_register_opt -shift_register_opt\
   -critical_pin_opt  -retime            \
   -hold_fix
report_status "06" "phys_opt_design"
#write_iphys_opt_tcl ${workdir}/${block}_iphy_opt_design.tcl
#write_checkpoint -force ${workdir}/${block}_postplace_physopted
report_timing_summary -warn_on_violation -max_paths 10 \
   -file ${workdir}/${block}_${place_directive}_timing_summary_postplace_physopted.rpt \
   -rpx  ${workdir}/${block}_${place_directive}_timing_summary_postplace_physopted.rpx
#-------------------------------------------------------------------------------
report_phase  "--" "Wait License" ${TIME_start}
wait_license
report_phase  "07" "route_design (Explore)" ${TIME_start}
route_design -directive Explore -tns_cleanup -timing_summary
report_status "07" "route_design (Explore)"
#write_checkpoint -force ${workdir}/${block}_postroute
report_timing_summary -warn_on_violation -max_paths 10 \
   -file ${workdir}/${block}_${place_directive}_timing_summary_postroute.rpt \
   -rpx  ${workdir}/${block}_${place_directive}_timing_summary_postroute.rpx
#-------------------------------------------------------------------------------
report_phase  "--" "Wait License" ${TIME_start}
wait_license
report_phase  "08" "phys_opt_design" ${TIME_start}
phys_opt_design
report_status "08" "phys_opt_design"
write_checkpoint -force ${workdir}/${block}_${place_directive}_postroute_physopted
report_timing_summary -warn_on_violation -max_paths 10 \
   -file ${workdir}/${block}_${place_directive}_timing_summary_postroute_physopted.rpt \
   -rpx  ${workdir}/${block}_${place_directive}_timing_summary_postroute_physopted.rpx
#-------------------------------------------------------------------------------
# Write status of the PAR (tns & wns)
write_status ${workdir}/${block}_${place_directive}_status.tcl
#-------------------------------------------------------------------------------
