################################################################################
# Input/Output Delay
################################################################################
#set_input_delay -clock [get_clocks karst_adc0_dco_p] 0.0 [get_ports {karst_adc0_n[*] karst_adc0_p[*]}]
#set_input_delay -clock [get_clocks karst_adc1_dco_p] 0.0 [get_ports {karst_adc1_n[*] karst_adc1_p[*]}]

################################################################################
# I/O STANDARDS and Location Constraints
################################################################################
set_property PACKAGE_PIN AD1  [get_ports pcie_7x_mgt_txn]
set_property PACKAGE_PIN AD2  [get_ports pcie_7x_mgt_txp]
set_property PACKAGE_PIN AD5  [get_ports pcie_7x_mgt_rxn]
set_property PACKAGE_PIN AD6  [get_ports pcie_7x_mgt_rxp]

set_property PACKAGE_PIN AP23 [get_ports karst_adc0_sync]
set_property PACKAGE_PIN AT23 [get_ports karst_adc0_pdwn]
set_property PACKAGE_PIN BA28 [get_ports karst_adc0_oen]
set_property PACKAGE_PIN AU22 [get_ports karst_adc1_sync]
set_property PACKAGE_PIN AV27 [get_ports karst_adc1_pdwn]
set_property PACKAGE_PIN AU24 [get_ports karst_adc1_oen]

set_property PACKAGE_PIN AY27 [get_ports karst_adc_spi_clk]
set_property PACKAGE_PIN AY20 [get_ports karst_adc_spi_csn0]
set_property PACKAGE_PIN AY22 [get_ports karst_adc_spi_csn1]
set_property PACKAGE_PIN BC24 [get_ports karst_adc_spi_mosi]
set_property PACKAGE_PIN BC27 [get_ports karst_adc_spi_miso]

set_property PACKAGE_PIN BD19 [get_ports karst_dac0_reset]
set_property PACKAGE_PIN AY23 [get_ports karst_dac1_reset]

set_property PACKAGE_PIN BA19 [get_ports karst_dac_spi_clk]
set_property PACKAGE_PIN AY21 [get_ports karst_dac_spi_csn0]
set_property PACKAGE_PIN BB24 [get_ports karst_dac_spi_csn1]
set_property PACKAGE_PIN BA25 [get_ports karst_dac_spi_miso]
set_property PACKAGE_PIN BB19 [get_ports karst_dac_spi_mosi]

set_property PACKAGE_PIN AW34 [get_ports karst_rf_interrupt]
set_property PACKAGE_PIN AP24 [get_ports karst_trsw0]
set_property PACKAGE_PIN AM25 [get_ports karst_trsw1]
set_property PACKAGE_PIN AM24 [get_ports karst_5g_pa0]
set_property PACKAGE_PIN AT29 [get_ports karst_5g_pa1]
set_property PACKAGE_PIN AJ14 [get_ports karst_2g_pa0]
set_property PACKAGE_PIN AL25 [get_ports karst_2g_pa1]

set_property PACKAGE_PIN AY26 [get_ports karst_rf_agcfreeze]
set_property PACKAGE_PIN BD39 [get_ports karst_rf_resetn]
set_property PACKAGE_PIN AK22 [get_ports karst_rf_spi_clk]
set_property PACKAGE_PIN AJ13 [get_ports karst_rf_spi_csn]
set_property PACKAGE_PIN AP13 [get_ports karst_rf_spi_mosi]
set_property PACKAGE_PIN AP25 [get_ports karst_rf_spi_miso]

set_property PACKAGE_PIN AR38 [get_ports {karst_rf_gpio[7]}]
set_property PACKAGE_PIN AP35 [get_ports {karst_rf_gpio[6]}]
set_property PACKAGE_PIN AK38 [get_ports {karst_rf_gpio[5]}]
set_property PACKAGE_PIN AU36 [get_ports {karst_rf_gpio[4]}]
set_property PACKAGE_PIN BA33 [get_ports {karst_rf_gpio[3]}]
set_property PACKAGE_PIN BC28 [get_ports {karst_rf_gpio[2]}]
set_property PACKAGE_PIN BA27 [get_ports {karst_rf_gpio[1]}]
set_property PACKAGE_PIN AJ28 [get_ports {karst_rf_gpio[0]}]
set_property PACKAGE_PIN AY28 [get_ports karst_ctrl_en_n]

set_property PACKAGE_PIN BD28 [get_ports karst_pwr_en]

#NotForCactus#set_property PACKAGE_PIN AJ28 [get_ports karst_rf_tmode]
#NotForCactus#set_property PACKAGE_PIN BC28 [get_ports karst_clkbuf0_sync]
#NotForCactus#set_property PACKAGE_PIN BA33 [get_ports karst_clkbuf1_sync]

set_property PACKAGE_PIN D23  [get_ports clk_ext_25]
set_property PACKAGE_PIN AG8  [get_ports clk_pcie_p]
set_property PACKAGE_PIN AA29 [get_ports global_rst_n]

set_property PACKAGE_PIN M21  [get_ports jtag_tck]
set_property PACKAGE_PIN H22  [get_ports jtag_tms]
set_property PACKAGE_PIN G22  [get_ports jtag_tdi]
set_property PACKAGE_PIN P24  [get_ports jtag_tdo]
set_property PACKAGE_PIN N24  [get_ports jtag_rtck]

set_property PACKAGE_PIN AU10 [get_ports {led[1]}]
set_property PACKAGE_PIN AT10 [get_ports {led[2]}]
set_property PACKAGE_PIN AY11 [get_ports {led[3]}]
set_property PACKAGE_PIN AW11 [get_ports {led[4]}]
set_property PACKAGE_PIN AY10 [get_ports {led[5]}]
set_property PACKAGE_PIN AW10 [get_ports {led[6]}]
set_property PACKAGE_PIN AY13 [get_ports {led[7]}]

set_property PACKAGE_PIN L23  [get_ports coex_bt_tx_abort]
set_property PACKAGE_PIN K23  [get_ports coex_bt_rx_abort]
set_property PACKAGE_PIN B24  [get_ports coex_bt_tied0]
set_property PACKAGE_PIN BD11 [get_ports coex_bt_event]
set_property PACKAGE_PIN BB12 [get_ports coex_bt_tx]
set_property PACKAGE_PIN BC12 [get_ports coex_bt_rx]
set_property PACKAGE_PIN L24  [get_ports {coex_bt_pti[3]}]
set_property PACKAGE_PIN A24  [get_ports {coex_bt_pti[2]}]

#I/O standard
set_property IOSTANDARD LVCMOS18 [get_ports karst_adc0_sync]
set_property IOSTANDARD LVCMOS18 [get_ports karst_adc0_pdwn]
set_property IOSTANDARD LVCMOS18 [get_ports karst_adc0_oen]
set_property IOSTANDARD LVCMOS18 [get_ports karst_adc1_sync]
set_property IOSTANDARD LVCMOS18 [get_ports karst_adc1_pdwn]
set_property IOSTANDARD LVCMOS18 [get_ports karst_adc1_oen]

set_property IOSTANDARD LVCMOS18 [get_ports karst_adc_spi_clk]
set_property IOSTANDARD LVCMOS18 [get_ports karst_adc_spi_csn0]
set_property IOSTANDARD LVCMOS18 [get_ports karst_adc_spi_csn1]
set_property IOSTANDARD LVCMOS18 [get_ports karst_adc_spi_mosi]
set_property IOSTANDARD LVCMOS18 [get_ports karst_adc_spi_miso]

set_property IOSTANDARD LVCMOS18 [get_ports karst_dac0_reset]
set_property IOSTANDARD LVCMOS18 [get_ports karst_dac1_reset]

set_property IOSTANDARD LVCMOS18 [get_ports karst_dac_spi_clk]
set_property IOSTANDARD LVCMOS18 [get_ports karst_dac_spi_csn0]
set_property IOSTANDARD LVCMOS18 [get_ports karst_dac_spi_csn1]
set_property IOSTANDARD LVCMOS18 [get_ports karst_dac_spi_miso]
set_property IOSTANDARD LVCMOS18 [get_ports karst_dac_spi_mosi]

set_property IOSTANDARD LVCMOS18 [get_ports karst_rf_interrupt]
set_property IOSTANDARD LVCMOS18 [get_ports karst_trsw0]
set_property IOSTANDARD LVCMOS18 [get_ports karst_trsw1]
set_property IOSTANDARD LVCMOS18 [get_ports karst_5g_pa0]
set_property IOSTANDARD LVCMOS18 [get_ports karst_5g_pa1]
set_property IOSTANDARD LVCMOS18 [get_ports karst_2g_pa0]
set_property IOSTANDARD LVCMOS18 [get_ports karst_2g_pa1]

set_property IOSTANDARD LVCMOS18 [get_ports karst_rf_agcfreeze]
set_property IOSTANDARD LVCMOS18 [get_ports karst_rf_resetn]
set_property IOSTANDARD LVCMOS18 [get_ports karst_rf_spi_clk]
set_property IOSTANDARD LVCMOS18 [get_ports karst_rf_spi_csn]
set_property IOSTANDARD LVCMOS18 [get_ports karst_rf_spi_mosi]
set_property IOSTANDARD LVCMOS18 [get_ports karst_rf_spi_miso]

set_property IOSTANDARD LVCMOS18 [get_ports {karst_rf_gpio[0]}]
set_property IOSTANDARD LVCMOS18 [get_ports {karst_rf_gpio[1]}]
set_property IOSTANDARD LVCMOS18 [get_ports {karst_rf_gpio[2]}]
set_property IOSTANDARD LVCMOS18 [get_ports {karst_rf_gpio[3]}]
set_property IOSTANDARD LVCMOS18 [get_ports {karst_rf_gpio[4]}]
set_property IOSTANDARD LVCMOS18 [get_ports {karst_rf_gpio[5]}]
set_property IOSTANDARD LVCMOS18 [get_ports {karst_rf_gpio[6]}]
set_property IOSTANDARD LVCMOS18 [get_ports {karst_rf_gpio[7]}]
set_property IOSTANDARD LVCMOS18 [get_ports karst_ctrl_en_n]

set_property IOSTANDARD LVCMOS18 [get_ports karst_pwr_en]

#NotForCactus#set_property IOSTANDARD LVCMOS18 [get_ports karst_clkbuf0_sync]
#NotForCactus#set_property IOSTANDARD LVCMOS18 [get_ports karst_clkbuf1_sync]
#NotForCactus#set_property IOSTANDARD LVCMOS18 [get_ports karst_rf_tmode]

set_property IOSTANDARD LVCMOS18 [get_ports clk_ext_25]
set_property IOSTANDARD LVCMOS18 [get_ports global_rst_n]

set_property IOSTANDARD LVCMOS18 [get_ports jtag_tck]
set_property IOSTANDARD LVCMOS18 [get_ports jtag_tdo]
set_property IOSTANDARD LVCMOS18 [get_ports jtag_tms]
set_property IOSTANDARD LVCMOS18 [get_ports jtag_tdi]
set_property IOSTANDARD LVCMOS18 [get_ports jtag_rtck]

set_property IOSTANDARD LVCMOS18 [get_ports {led[1]}]
set_property IOSTANDARD LVCMOS18 [get_ports {led[2]}]
set_property IOSTANDARD LVCMOS18 [get_ports {led[3]}]
set_property IOSTANDARD LVCMOS18 [get_ports {led[4]}]
set_property IOSTANDARD LVCMOS18 [get_ports {led[5]}]
set_property IOSTANDARD LVCMOS18 [get_ports {led[6]}]
set_property IOSTANDARD LVCMOS18 [get_ports {led[7]}]

set_property IOSTANDARD LVCMOS18 [get_ports coex_bt_tx_abort]
set_property IOSTANDARD LVCMOS18 [get_ports coex_bt_rx_abort]
set_property IOSTANDARD LVCMOS18 [get_ports coex_bt_tied0]
set_property IOSTANDARD LVCMOS18 [get_ports coex_bt_event]
set_property IOSTANDARD LVCMOS18 [get_ports coex_bt_tx]
set_property IOSTANDARD LVCMOS18 [get_ports coex_bt_rx]
set_property IOSTANDARD LVCMOS18 [get_ports {coex_bt_pti[*]}]

# PullUp/ PullDown
set_property PULLDOWN true [get_ports coex_bt_tx_abort]
set_property PULLDOWN true [get_ports coex_bt_rx_abort]
set_property PULLDOWN true [get_ports coex_bt_event]
set_property PULLDOWN true [get_ports coex_bt_tx]
set_property PULLDOWN true [get_ports coex_bt_rx]
set_property PULLDOWN true [get_ports {coex_bt_pti[*]}]

#############################LVDS channels #####################################
set_property PACKAGE_PIN AL39 [get_ports karst_dac0_clk_p]
set_property PACKAGE_PIN AM39 [get_ports karst_dac0_clk_n]
set_property PACKAGE_PIN AV19 [get_ports karst_dac0_dci_p]
set_property PACKAGE_PIN AV18 [get_ports karst_dac0_dci_n]
set_property PACKAGE_PIN AJ11 [get_ports {karst_dac0_p[0]}]
set_property PACKAGE_PIN AJ10 [get_ports {karst_dac0_n[0]}]
set_property PACKAGE_PIN AK13 [get_ports {karst_dac0_p[1]}]
set_property PACKAGE_PIN AK12 [get_ports {karst_dac0_n[1]}]
set_property PACKAGE_PIN AN12 [get_ports {karst_dac0_p[2]}]
set_property PACKAGE_PIN AN11 [get_ports {karst_dac0_n[2]}]
set_property PACKAGE_PIN AL10 [get_ports {karst_dac0_p[3]}]
set_property PACKAGE_PIN AM10 [get_ports {karst_dac0_n[3]}]
set_property PACKAGE_PIN AR13 [get_ports {karst_dac0_p[4]}]
set_property PACKAGE_PIN AT13 [get_ports {karst_dac0_n[4]}]
set_property PACKAGE_PIN AK20 [get_ports {karst_dac0_p[5]}]
set_property PACKAGE_PIN AL20 [get_ports {karst_dac0_n[5]}]
set_property PACKAGE_PIN AJ20 [get_ports {karst_dac0_p[6]}]
set_property PACKAGE_PIN AJ19 [get_ports {karst_dac0_n[6]}]
set_property PACKAGE_PIN AK17 [get_ports {karst_dac0_p[7]}]
set_property PACKAGE_PIN AL17 [get_ports {karst_dac0_n[7]}]
set_property PACKAGE_PIN AR18 [get_ports {karst_dac0_p[8]}]
set_property PACKAGE_PIN AT18 [get_ports {karst_dac0_n[8]}]
set_property PACKAGE_PIN BC18 [get_ports {karst_dac0_p[9]}]
set_property PACKAGE_PIN BD18 [get_ports {karst_dac0_n[9]}]
set_property PACKAGE_PIN BA20 [get_ports {karst_dac0_p[10]}]
set_property PACKAGE_PIN BB20 [get_ports {karst_dac0_n[10]}]
set_property PACKAGE_PIN BD21 [get_ports {karst_dac0_p[11]}]
set_property PACKAGE_PIN BD20 [get_ports {karst_dac0_n[11]}]

set_property PACKAGE_PIN AK36 [get_ports karst_adc0_clk_p]
set_property PACKAGE_PIN AK37 [get_ports karst_adc0_clk_n]
set_property PACKAGE_PIN AR42 [get_ports karst_adc0_dco_p]
set_property PACKAGE_PIN AT42 [get_ports karst_adc0_dco_n]
set_property PACKAGE_PIN AJ33 [get_ports {karst_adc0_p[0]}]
set_property PACKAGE_PIN AJ34 [get_ports {karst_adc0_n[0]}]
set_property PACKAGE_PIN AJ39 [get_ports {karst_adc0_p[1]}]
set_property PACKAGE_PIN AJ40 [get_ports {karst_adc0_n[1]}]
set_property PACKAGE_PIN AH43 [get_ports {karst_adc0_p[2]}]
set_property PACKAGE_PIN AH44 [get_ports {karst_adc0_n[2]}]
set_property PACKAGE_PIN AL35 [get_ports {karst_adc0_p[3]}]
set_property PACKAGE_PIN AM35 [get_ports {karst_adc0_n[3]}]
set_property PACKAGE_PIN AK42 [get_ports {karst_adc0_p[4]}]
set_property PACKAGE_PIN AK43 [get_ports {karst_adc0_n[4]}]
set_property PACKAGE_PIN AK40 [get_ports {karst_adc0_p[5]}]
set_property PACKAGE_PIN AL40 [get_ports {karst_adc0_n[5]}]
set_property PACKAGE_PIN AM42 [get_ports {karst_adc0_p[6]}]
set_property PACKAGE_PIN AN42 [get_ports {karst_adc0_n[6]}]
set_property PACKAGE_PIN AW43 [get_ports {karst_adc0_p[7]}]
set_property PACKAGE_PIN AW44 [get_ports {karst_adc0_n[7]}]
set_property PACKAGE_PIN AN43 [get_ports {karst_adc0_p[8]}]
set_property PACKAGE_PIN AN44 [get_ports {karst_adc0_n[8]}]
set_property PACKAGE_PIN AK33 [get_ports {karst_adc0_p[9]}]
set_property PACKAGE_PIN AL33 [get_ports {karst_adc0_n[9]}]
set_property PACKAGE_PIN BA35 [get_ports {karst_adc0_p[10]}]
set_property PACKAGE_PIN BB35 [get_ports {karst_adc0_n[10]}]
set_property PACKAGE_PIN AY36 [get_ports {karst_adc0_p[11]}]
set_property PACKAGE_PIN AY37 [get_ports {karst_adc0_n[11]}]

set_property PACKAGE_PIN V4   [get_ports karst_dac1_clk_p]
set_property PACKAGE_PIN V3   [get_ports karst_dac1_clk_n]
set_property PACKAGE_PIN W4   [get_ports karst_dac1_dci_p]
set_property PACKAGE_PIN W3   [get_ports karst_dac1_dci_n]
set_property PACKAGE_PIN A5   [get_ports {karst_dac1_p[0]}]
set_property PACKAGE_PIN A4   [get_ports {karst_dac1_n[0]}]
set_property PACKAGE_PIN B4   [get_ports {karst_dac1_p[1]}]
set_property PACKAGE_PIN A3   [get_ports {karst_dac1_n[1]}]
set_property PACKAGE_PIN C2   [get_ports {karst_dac1_p[2]}]
set_property PACKAGE_PIN B2   [get_ports {karst_dac1_n[2]}]
set_property PACKAGE_PIN F3   [get_ports {karst_dac1_p[3]}]
set_property PACKAGE_PIN E3   [get_ports {karst_dac1_n[3]}]
set_property PACKAGE_PIN G4   [get_ports {karst_dac1_p[4]}]
set_property PACKAGE_PIN F4   [get_ports {karst_dac1_n[4]}]
set_property PACKAGE_PIN J5   [get_ports {karst_dac1_p[5]}]
set_property PACKAGE_PIN J4   [get_ports {karst_dac1_n[5]}]
set_property PACKAGE_PIN K7   [get_ports {karst_dac1_p[6]}]
set_property PACKAGE_PIN K6   [get_ports {karst_dac1_n[6]}]
set_property PACKAGE_PIN K1   [get_ports {karst_dac1_p[7]}]
set_property PACKAGE_PIN J1   [get_ports {karst_dac1_n[7]}]
set_property PACKAGE_PIN L8   [get_ports {karst_dac1_p[8]}]
set_property PACKAGE_PIN L7   [get_ports {karst_dac1_n[8]}]
set_property PACKAGE_PIN R5   [get_ports {karst_dac1_p[9]}]
set_property PACKAGE_PIN P5   [get_ports {karst_dac1_n[9]}]
set_property PACKAGE_PIN AA5  [get_ports {karst_dac1_p[10]}]
set_property PACKAGE_PIN AA4  [get_ports {karst_dac1_n[10]}]
set_property PACKAGE_PIN P10  [get_ports {karst_dac1_p[11]}]
set_property PACKAGE_PIN P9   [get_ports {karst_dac1_n[11]}]

set_property PACKAGE_PIN AC39 [get_ports karst_adc1_clk_p]
set_property PACKAGE_PIN AB39 [get_ports karst_adc1_clk_n]
set_property PACKAGE_PIN AC41 [get_ports karst_adc1_dco_p]
set_property PACKAGE_PIN AB41 [get_ports karst_adc1_dco_n]
set_property PACKAGE_PIN V33  [get_ports {karst_adc1_p[0]}]
set_property PACKAGE_PIN V34  [get_ports {karst_adc1_n[0]}]
set_property PACKAGE_PIN U34  [get_ports {karst_adc1_p[1]}]
set_property PACKAGE_PIN U35  [get_ports {karst_adc1_n[1]}]
set_property PACKAGE_PIN U39  [get_ports {karst_adc1_p[2]}]
set_property PACKAGE_PIN U40  [get_ports {karst_adc1_n[2]}]
set_property PACKAGE_PIN Y35  [get_ports {karst_adc1_p[3]}]
set_property PACKAGE_PIN Y36  [get_ports {karst_adc1_n[3]}]
set_property PACKAGE_PIN Y42  [get_ports {karst_adc1_p[4]}]
set_property PACKAGE_PIN Y43  [get_ports {karst_adc1_n[4]}]
set_property PACKAGE_PIN W43  [get_ports {karst_adc1_p[5]}]
set_property PACKAGE_PIN W44  [get_ports {karst_adc1_n[5]}]
set_property PACKAGE_PIN AC42 [get_ports {karst_adc1_p[6]}]
set_property PACKAGE_PIN AB42 [get_ports {karst_adc1_n[6]}]
set_property PACKAGE_PIN W30  [get_ports {karst_adc1_p[7]}]
set_property PACKAGE_PIN W31  [get_ports {karst_adc1_n[7]}]
set_property PACKAGE_PIN V31  [get_ports {karst_adc1_p[8]}]
set_property PACKAGE_PIN V32  [get_ports {karst_adc1_n[8]}]
set_property PACKAGE_PIN AL29 [get_ports {karst_adc1_p[9]}]
set_property PACKAGE_PIN AL30 [get_ports {karst_adc1_n[9]}]
set_property PACKAGE_PIN AK30 [get_ports {karst_adc1_p[10]}]
set_property PACKAGE_PIN AK31 [get_ports {karst_adc1_n[10]}]
set_property PACKAGE_PIN AL32 [get_ports {karst_adc1_p[11]}]
set_property PACKAGE_PIN AM32 [get_ports {karst_adc1_n[11]}]

set_property PACKAGE_PIN AR20 [get_ports karst_fsys_p]
set_property PACKAGE_PIN AT20 [get_ports karst_fsys_n]
set_property IOSTANDARD LVDS  [get_ports karst_fsys_p]

#I/O Mictors
set_property PACKAGE_PIN R41  [get_ports {mictor0[33]}]
set_property PACKAGE_PIN P38  [get_ports {mictor0[32]}]
set_property PACKAGE_PIN P30  [get_ports {mictor0[31]}]
set_property PACKAGE_PIN R31  [get_ports {mictor0[30]}]
set_property PACKAGE_PIN P34  [get_ports {mictor0[29]}]
set_property PACKAGE_PIN P36  [get_ports {mictor0[28]}]
set_property PACKAGE_PIN R37  [get_ports {mictor0[27]}]
set_property PACKAGE_PIN N38  [get_ports {mictor0[26]}]
set_property PACKAGE_PIN P39  [get_ports {mictor0[25]}]
set_property PACKAGE_PIN R38  [get_ports {mictor0[24]}]
set_property PACKAGE_PIN T35  [get_ports {mictor0[23]}]
set_property PACKAGE_PIN T38  [get_ports {mictor0[22]}]
set_property PACKAGE_PIN N36  [get_ports {mictor0[21]}]
set_property PACKAGE_PIN P43  [get_ports {mictor0[20]}]
set_property PACKAGE_PIN T44  [get_ports {mictor0[19]}]
set_property PACKAGE_PIN T29  [get_ports {mictor0[18]}]
set_property PACKAGE_PIN R40  [get_ports {mictor0[17]}]
set_property PACKAGE_PIN P35  [get_ports {mictor0[16]}]
set_property PACKAGE_PIN M41  [get_ports {mictor0[15]}]
set_property PACKAGE_PIN N44  [get_ports {mictor0[14]}]
set_property PACKAGE_PIN N41  [get_ports {mictor0[13]}]
set_property PACKAGE_PIN N43  [get_ports {mictor0[12]}]
set_property PACKAGE_PIN T30  [get_ports {mictor0[11]}]
set_property PACKAGE_PIN R32  [get_ports {mictor0[10]}]
set_property PACKAGE_PIN P33  [get_ports {mictor0[9]}]
set_property PACKAGE_PIN T33  [get_ports {mictor0[8]}]
set_property PACKAGE_PIN T34  [get_ports {mictor0[7]}]
set_property PACKAGE_PIN R36  [get_ports {mictor0[6]}]
set_property PACKAGE_PIN M39  [get_ports {mictor0[5]}]
set_property PACKAGE_PIN N39  [get_ports {mictor0[4]}]
set_property PACKAGE_PIN M40  [get_ports {mictor0[3]}]
set_property PACKAGE_PIN N42  [get_ports {mictor0[2]}]
set_property PACKAGE_PIN P44  [get_ports {mictor0[1]}]
set_property PACKAGE_PIN T40  [get_ports {mictor0[0]}]

set_property PACKAGE_PIN C41  [get_ports {mictor1[33]}]
set_property PACKAGE_PIN D41  [get_ports {mictor1[32]}]
set_property PACKAGE_PIN B42  [get_ports {mictor1[31]}]
set_property PACKAGE_PIN C44  [get_ports {mictor1[30]}]
set_property PACKAGE_PIN D44  [get_ports {mictor1[29]}]
set_property PACKAGE_PIN F40  [get_ports {mictor1[28]}]
set_property PACKAGE_PIN D34  [get_ports {mictor1[27]}]
set_property PACKAGE_PIN B34  [get_ports {mictor1[26]}]
set_property PACKAGE_PIN B35  [get_ports {mictor1[25]}]
set_property PACKAGE_PIN B36  [get_ports {mictor1[24]}]
set_property PACKAGE_PIN D39  [get_ports {mictor1[23]}]
set_property PACKAGE_PIN B39  [get_ports {mictor1[22]}]
set_property PACKAGE_PIN B40  [get_ports {mictor1[21]}]
set_property PACKAGE_PIN B41  [get_ports {mictor1[20]}]
set_property PACKAGE_PIN A42  [get_ports {mictor1[19]}]
set_property PACKAGE_PIN C43  [get_ports {mictor1[18]}]
set_property PACKAGE_PIN E41  [get_ports {mictor1[17]}]
set_property PACKAGE_PIN F44  [get_ports {mictor1[16]}]
set_property PACKAGE_PIN N34  [get_ports {mictor1[15]}]
set_property PACKAGE_PIN R35  [get_ports {mictor1[14]}]
set_property PACKAGE_PIN N37  [get_ports {mictor1[13]}]
set_property PACKAGE_PIN C37  [get_ports {mictor1[12]}]
set_property PACKAGE_PIN C38  [get_ports {mictor1[11]}]
set_property PACKAGE_PIN A39  [get_ports {mictor1[10]}]
set_property PACKAGE_PIN A40  [get_ports {mictor1[9]}]
set_property PACKAGE_PIN D43  [get_ports {mictor1[8]}]
set_property PACKAGE_PIN B37  [get_ports {mictor1[7]}]
set_property PACKAGE_PIN C39  [get_ports {mictor1[6]}]
set_property PACKAGE_PIN E40  [get_ports {mictor1[5]}]
set_property PACKAGE_PIN D40  [get_ports {mictor1[4]}]
set_property PACKAGE_PIN C42  [get_ports {mictor1[3]}]
set_property PACKAGE_PIN E42  [get_ports {mictor1[2]}]
set_property PACKAGE_PIN F43  [get_ports {mictor1[1]}]
set_property PACKAGE_PIN F42  [get_ports {mictor1[0]}]

set_property PACKAGE_PIN T9   [get_ports {mictor2[33]}]
set_property PACKAGE_PIN T10  [get_ports {mictor2[32]}]
set_property PACKAGE_PIN T8   [get_ports {mictor2[31]}]
set_property PACKAGE_PIN T4   [get_ports {mictor2[30]}]
set_property PACKAGE_PIN U7   [get_ports {mictor2[29]}]
set_property PACKAGE_PIN U10  [get_ports {mictor2[28]}]
set_property PACKAGE_PIN V8   [get_ports {mictor2[27]}]
set_property PACKAGE_PIN V10  [get_ports {mictor2[26]}]
set_property PACKAGE_PIN W9   [get_ports {mictor2[25]}]
set_property PACKAGE_PIN AA2  [get_ports {mictor2[24]}]
set_property PACKAGE_PIN T2   [get_ports {mictor2[23]}]
set_property PACKAGE_PIN U6   [get_ports {mictor2[22]}]
set_property PACKAGE_PIN W6   [get_ports {mictor2[21]}]
set_property PACKAGE_PIN Y8   [get_ports {mictor2[20]}]
set_property PACKAGE_PIN AA7  [get_ports {mictor2[19]}]
set_property PACKAGE_PIN AA9  [get_ports {mictor2[18]}]
set_property PACKAGE_PIN AA10 [get_ports {mictor2[17]}]
set_property PACKAGE_PIN U1   [get_ports {mictor2[16]}]
set_property PACKAGE_PIN R8   [get_ports {mictor2[15]}]
set_property PACKAGE_PIN T7   [get_ports {mictor2[14]}]
set_property PACKAGE_PIN T5   [get_ports {mictor2[13]}]
set_property PACKAGE_PIN U9   [get_ports {mictor2[12]}]
set_property PACKAGE_PIN V7   [get_ports {mictor2[11]}]
set_property PACKAGE_PIN V9   [get_ports {mictor2[10]}]
set_property PACKAGE_PIN W8   [get_ports {mictor2[9]}]
set_property PACKAGE_PIN W10  [get_ports {mictor2[8]}]
set_property PACKAGE_PIN U2   [get_ports {mictor2[7]}]
set_property PACKAGE_PIN V6   [get_ports {mictor2[6]}]
set_property PACKAGE_PIN Y7   [get_ports {mictor2[5]}]
set_property PACKAGE_PIN AA3  [get_ports {mictor2[4]}]
set_property PACKAGE_PIN AA8  [get_ports {mictor2[3]}]
set_property PACKAGE_PIN Y10  [get_ports {mictor2[2]}]
set_property PACKAGE_PIN T3   [get_ports {mictor2[1]}]
set_property PACKAGE_PIN V1   [get_ports {mictor2[0]}]

set_property SLEW FAST           [get_ports {mictor0[*]}]
set_property SLEW FAST           [get_ports {mictor1[*]}]
set_property SLEW FAST           [get_ports {mictor2[*]}]

set_property IOSTANDARD LVCMOS18 [get_ports {mictor0[*]}]
set_property IOSTANDARD LVCMOS18 [get_ports {mictor1[*]}]
set_property IOSTANDARD LVCMOS18 [get_ports {mictor2[*]}]

################################################################################
# Debug Only I/O
################################################################################
#set_property PACKAGE_PIN AK11    [get_ports {debug_dco_clk[0]}]
#set_property PACKAGE_PIN AL13    [get_ports {debug_dco_clk[1]}]
#set_property PACKAGE_PIN AL12    [get_ports debug_fe_clk]
#set_property IOSTANDARD LVCMOS18 [get_ports {debug_dco_clk[0]}]
#set_property IOSTANDARD LVCMOS18 [get_ports {debug_dco_clk[1]}]
#set_property IOSTANDARD LVCMOS18 [get_ports debug_fe_clk]
#InvalidPort#set_property PACKAGE_PIN AK10    [get_ports debug_xo]
#InvalidPort#set_property IOSTANDARD LVCMOS18 [get_ports debug_xo]

################################################################################
# False Path
################################################################################
set_false_path -from [get_ports global_rst_n]
set_false_path -to   [get_ports {mictor0[*]}]
set_false_path -to   [get_ports {mictor1[*]}]
set_false_path -to   [get_ports {mictor2[*]}]
set_false_path -to   [get_ports {led[*]}]
set_false_path -to   [get_cells {u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_top/nx_mictor_1t[*]}]
set_false_path -to   [get_ports coex_bt_tx_abort]
set_false_path -to   [get_ports coex_bt_rx_abort]
set_false_path -to   [get_ports coex_bt_tied0]
set_false_path -from [get_ports coex_bt_event]
set_false_path -from [get_ports coex_bt_tx]
set_false_path -from [get_ports coex_bt_rx]
set_false_path -from [get_ports {coex_bt_pti[*]}]

################################################################################
# Clock Placement
################################################################################
#set_property CLOCK_DEDICATED_ROUTE BACKBONE [get_nets u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_v7_crm/fsys_prebufg]

# MAC
set_property LOC MMCME2_ADV_X0Y8 [get_cells u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc4] 

# Platform
set_property LOC MMCME2_ADV_X0Y7 [get_cells u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc5] 
set_property LOC MMCME2_ADV_X0Y6 [get_cells u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc0] 

# Modem + MPIF
#set_property LOC MMCME2_ADV_X0Y3 [get_cells u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc2] 
set_property LOC MMCME2_ADV_X1Y3 [get_cells u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc1] 

# ModemB (44MHz)
#set_property LOC MMCME2_ADV_X1Y0 [get_cells u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc3] 

################################################################################
# Floorplan
################################################################################
# LA MEM ON TOP OF THE FPGA
#create_pblock       pblock_la_mem
#resize_pblock       pblock_la_mem -add CLOCKREGION_X0Y9:CLOCKREGION_X1Y11
#add_cells_to_pblock pblock_la_mem [get_cells [list u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/sram_dp_65536x1[*]]]

################################################################################
# ???
################################################################################
set_property CFGBVS GND [current_design]
set_property CONFIG_VOLTAGE 1.8 [current_design]
set_property PULLUP true [get_ports global_rst_n]
set_property BITSTREAM.GENERAL.COMPRESS True [current_design]
set_property BITSTREAM.CONFIG.UNUSEDPIN PULLNONE [current_design]

# Disable power optimization
set_power_opt -cell_types {none}

#-------------------------------------------------------------------------------
# End of file
#-------------------------------------------------------------------------------
