#-------------------------------------------------------------------------------
# sleep
#    Wait for N minutes
#-------------------------------------------------------------------------------
proc sleep {N} {
   after [ expr {int($N * 60 * 1000)} ] 
}
#-------------------------------------------------------------------------------
# check_license
#    Return 1 if Implementation license is available.
#    Return 0 if Implementation license is not available.
#-------------------------------------------------------------------------------
proc check_license {} {
   set lic_status [exec lmutil lmstat -c 2100@192.168.64.100 -f Implementation]
   # Extract license information
   regexp -all -line {^Users.*(\d+).*(\d+).*$} ${lic_status} lic_line lic_nbr lic_use
   puts "${lic_line} (${lic_nbr} ${lic_use})"
   # Check if a license is already checkout by the user
   set mylic [lsearch $lic_status [exec whoami]]
   #
   if {${lic_nbr}==${lic_use} && $mylic<0} {
      return 0
   } else {
      return 1
   }
}
#-------------------------------------------------------------------------------
# wait_license
#    Wait until a license is available
#-------------------------------------------------------------------------------
proc wait_license {} {
   while {[check_license]==0} {
      sleep 5
   }
}
#-------------------------------------------------------------------------------
