#-------------------------------------------------------------------------------
# Clock period
#-------------------------------------------------------------------------------
#ADC
set ADC0_PERIOD       12.500
set ADC1_PERIOD       12.500
#Reference Clock (200MHz)
set REF200_PERIOD     5.000
#Platform Clock
set PLF_PERIOD       14.000 
set PLF20_PERIOD     50.000 
#MAC Clock
set MAC_CORE_PERIOD  16.5
set MAC_WT_PERIOD    16.5 
#MPIF (120MHz)
set MPIF_PERIOD       8.333 
set LA_PERIOD         8.333 
#PHY Clock
set PHY_PERIOD       8.333 
#set SVD_PERIOD       16.666 
#FE Clock (40MHz)
set FE40_PERIOD      25.000 
set FE80_PERIOD      12.500 
set FE_PERIOD        12.500 
#Modem B Clock
set MDMB44_PERIOD    22.720 
#BD Clock
set BD_PERIOD        16.666 
#PCIe Clock
set PCIE_PERIOD      10.000 
#PCIe AXI Clock (62.5MHz)
set PCIE_AXI_PERIOD  16.000 

#-------------------------------------------------------------------------------
# Clock Constraints
#-------------------------------------------------------------------------------
create_clock -period ${ADC0_PERIOD}     -name adc0_clk       [get_ports karst_adc0_dco_p]
create_clock -period ${ADC1_PERIOD}     -name adc1_clk       [get_ports karst_adc1_dco_p]
create_clock -period ${REF200_PERIOD}   -name ref200_clk     [get_pins u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc0/CLKOUT0]
create_clock -period ${PLF20_PERIOD}    -name plf20_clk      [get_pins u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc0/CLKOUT1]

create_clock -period ${LA_PERIOD}       -name la_clk         [get_pins u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc1/CLKOUT0]
#create_clock -period ${SVD_PERIOD}      -name svd_clk        [get_pins u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc1/CLKOUT1]
create_clock -period ${FE40_PERIOD}     -name fe40_clk       [get_pins u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc1/CLKOUT2]
create_clock -period ${FE80_PERIOD}     -name fe80_clk       [get_pins u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc1/CLKOUT3]
create_clock -period ${FE_PERIOD}       -name fe_clk         [get_pins u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc1/CLKOUT4]
create_clock -period ${PHY_PERIOD}      -name phy_clk        [get_pins u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc1/CLKOUT5]
#create_clock -period ${MPIF_PERIOD}     -name mpif_clk       [get_pins u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc1/CLKOUT6] 

#create_clock -period ${BD_PERIOD}       -name bd_clk         [get_pins u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc2/CLKOUT6]

create_clock -period ${MAC_CORE_PERIOD} -name mac_core_clk   [get_pins u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc4/CLKOUT1]
create_clock -period ${MAC_WT_PERIOD}   -name mac_wt_clk     [get_pins u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc4/CLKOUT2]

create_clock -period ${PLF_PERIOD}      -name plf_clk        [get_pins u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc5/CLKOUT0]

create_clock -period ${MDMB44_PERIOD}   -name mdmb44_clk     [get_pins u_rw_he_top_cpu_u0/u_rw_he_top_wrapper/u_rw_he_crm/u_rw_he_crm_fpga/u_mmc6/CLKOUT1]

create_clock -period ${PCIE_PERIOD}     -name pcie_clk       [get_ports clk_pcie_p]

#-------------------------------------------------------------------------------
# Clock domain
#-------------------------------------------------------------------------------
set_clock_groups -physically_exclusive -name group_platform        -group [get_clocks plf_clk]      -group [get_clocks plf20_clk]
set_clock_groups -asynchronous         -name group_ref200_to_la    -group [get_clocks ref200_clk]   -group [get_clocks la_clk]
set_clock_groups -asynchronous         -name group_plf_to_la       -group [get_clocks plf_clk]      -group [get_clocks la_clk]
set_clock_groups -asynchronous         -name group_plf20_to_la     -group [get_clocks plf20_clk]    -group [get_clocks la_clk]
set_clock_groups -asynchronous         -name group_mac_core_to_la  -group [get_clocks mac_core_clk] -group [get_clocks la_clk]
set_clock_groups -asynchronous         -name group_mac_wt_to_la    -group [get_clocks mac_wt_clk]   -group [get_clocks la_clk]
#set_clock_groups -asynchronous         -name group_phy_to_la       -group [get_clocks phy_clk]      -group [get_clocks la_clk]
#set_clock_groups -asynchronous         -name group_svd_to_la       -group [get_clocks svd_clk]      -group [get_clocks la_clk]
set_clock_groups -asynchronous         -name group_fe40_to_la      -group [get_clocks fe40_clk]     -group [get_clocks la_clk]
set_clock_groups -asynchronous         -name group_fe80_to_la      -group [get_clocks fe80_clk]     -group [get_clocks la_clk]
#set_clock_groups -asynchronous         -name group_fe_to_la        -group [get_clocks fe_clk]       -group [get_clocks la_clk]
set_clock_groups -asynchronous         -name group_mdmb44_to_la    -group [get_clocks mdmb44_clk]   -group [get_clocks la_clk]
#set_clock_groups -asynchronous         -name group_bd_to_la        -group [get_clocks bd_clk]       -group [get_clocks la_clk]
set_clock_groups -asynchronous         -name group_pcie_to_la      -group [get_clocks userclk1]     -group [get_clocks la_clk]

#To 200MHz clock domain
set_max_delay -datapath_only -from [get_clocks plf_clk]          -to [get_clocks ref200_clk]   [expr 2 * ${REF200_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf20_clk]        -to [get_clocks ref200_clk]   [expr 2 * ${REF200_PERIOD}]
set_max_delay -datapath_only -from [get_clocks userclk1]         -to [get_clocks ref200_clk]   [expr 2 * ${REF200_PERIOD}]
#To Platform clock domain
set_max_delay -datapath_only -from [get_clocks ref200_clk]       -to [get_clocks plf_clk]      [expr 2 * ${PLF_PERIOD}]
set_max_delay -datapath_only -from [get_clocks mac_core_clk]     -to [get_clocks plf_clk]      [expr 2 * ${PLF_PERIOD}]
set_max_delay -datapath_only -from [get_clocks mac_wt_clk]       -to [get_clocks plf_clk]      [expr 2 * ${PLF_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks mpif_clk]         -to [get_clocks plf_clk]      [expr 2 * ${PLF_PERIOD}]
set_max_delay -datapath_only -from [get_clocks la_clk]           -to [get_clocks plf_clk]      [expr 2 * ${PLF_PERIOD}]
set_max_delay -datapath_only -from [get_clocks phy_clk]          -to [get_clocks plf_clk]      [expr 2 * ${PLF_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks svd_clk]          -to [get_clocks plf_clk]      [expr 2 * ${PLF_PERIOD}]
set_max_delay -datapath_only -from [get_clocks fe40_clk]         -to [get_clocks plf_clk]      [expr 2 * ${PLF_PERIOD}]
set_max_delay -datapath_only -from [get_clocks fe80_clk]         -to [get_clocks plf_clk]      [expr 2 * ${PLF_PERIOD}]
set_max_delay -datapath_only -from [get_clocks fe_clk]           -to [get_clocks plf_clk]      [expr 2 * ${PLF_PERIOD}]
set_max_delay -datapath_only -from [get_clocks mdmb44_clk]       -to [get_clocks plf_clk]      [expr 2 * ${PLF_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks bd_clk]           -to [get_clocks plf_clk]      [expr 2 * ${PLF_PERIOD}]
set_max_delay -datapath_only -from [get_clocks userclk1]         -to [get_clocks plf_clk]      [expr 2 * ${PLF_PERIOD}]

set_max_delay -datapath_only -from [get_clocks ref200_clk]       -to [get_clocks plf20_clk]    [expr 2 * ${PLF20_PERIOD}]
set_max_delay -datapath_only -from [get_clocks mac_core_clk]     -to [get_clocks plf20_clk]    [expr 2 * ${PLF20_PERIOD}]
set_max_delay -datapath_only -from [get_clocks mac_wt_clk]       -to [get_clocks plf20_clk]    [expr 2 * ${PLF20_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks mpif_clk]         -to [get_clocks plf20_clk]    [expr 2 * ${PLF20_PERIOD}]
set_max_delay -datapath_only -from [get_clocks la_clk]           -to [get_clocks plf20_clk]    [expr 2 * ${PLF20_PERIOD}]
set_max_delay -datapath_only -from [get_clocks phy_clk]          -to [get_clocks plf20_clk]    [expr 2 * ${PLF20_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks svd_clk]          -to [get_clocks plf20_clk]    [expr 2 * ${PLF20_PERIOD}]
set_max_delay -datapath_only -from [get_clocks fe40_clk]         -to [get_clocks plf20_clk]    [expr 2 * ${PLF20_PERIOD}]
set_max_delay -datapath_only -from [get_clocks fe80_clk]         -to [get_clocks plf20_clk]    [expr 2 * ${PLF20_PERIOD}]
set_max_delay -datapath_only -from [get_clocks fe_clk]           -to [get_clocks plf20_clk]    [expr 2 * ${PLF20_PERIOD}]
set_max_delay -datapath_only -from [get_clocks mdmb44_clk]       -to [get_clocks plf20_clk]    [expr 2 * ${PLF20_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks bd_clk]           -to [get_clocks plf20_clk]    [expr 2 * ${PLF20_PERIOD}]
set_max_delay -datapath_only -from [get_clocks userclk1]         -to [get_clocks plf20_clk]    [expr 2 * ${PLF20_PERIOD}]
#To MAC clock domain
set_max_delay -datapath_only -from [get_clocks ref200_clk]       -to [get_clocks mac_core_clk] [expr 2 * ${MAC_CORE_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf_clk]          -to [get_clocks mac_core_clk] [expr 2 * ${MAC_CORE_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf20_clk]        -to [get_clocks mac_core_clk] [expr 2 * ${MAC_CORE_PERIOD}]
set_max_delay -datapath_only -from [get_clocks phy_clk]         -to [get_clocks mac_core_clk] [expr 2 * ${MAC_CORE_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks svd_clk]          -to [get_clocks mac_core_clk] [expr 2 * ${MAC_CORE_PERIOD}]
set_max_delay -datapath_only -from [get_clocks fe40_clk]         -to [get_clocks mac_core_clk] [expr 2 * ${MAC_CORE_PERIOD}]
set_max_delay -datapath_only -from [get_clocks fe80_clk]         -to [get_clocks mac_core_clk] [expr 2 * ${MAC_CORE_PERIOD}]
set_max_delay -datapath_only -from [get_clocks fe_clk]           -to [get_clocks mac_core_clk] [expr 2 * ${MAC_CORE_PERIOD}]
set_max_delay -datapath_only -from [get_clocks userclk1]         -to [get_clocks mac_core_clk] [expr 2 * ${MAC_CORE_PERIOD}]

set_max_delay -datapath_only -from [get_clocks ref200_clk]       -to [get_clocks mac_wt_clk]   [expr 2 * ${MAC_WT_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf_clk]          -to [get_clocks mac_wt_clk]   [expr 2 * ${MAC_WT_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf20_clk]        -to [get_clocks mac_wt_clk]   [expr 2 * ${MAC_WT_PERIOD}]
#To FE clock domain
set_max_delay -datapath_only -from [get_clocks ref200_clk]       -to [get_clocks fe40_clk]     [expr 2 * ${FE40_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf_clk]          -to [get_clocks fe40_clk]     [expr 2 * ${FE40_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf20_clk]        -to [get_clocks fe40_clk]     [expr 2 * ${FE40_PERIOD}]
set_max_delay -datapath_only -from [get_clocks phy_clk]         -to [get_clocks fe40_clk]     [expr 2 * ${FE40_PERIOD}]
set_max_delay -datapath_only -from [get_clocks mdmb44_clk]       -to [get_clocks fe40_clk]     [expr 2 * ${FE40_PERIOD}]
set_max_delay -datapath_only -from [get_clocks userclk1]         -to [get_clocks fe40_clk]     [expr 2 * ${FE40_PERIOD}]
                                                           
set_max_delay -datapath_only -from [get_clocks ref200_clk]       -to [get_clocks fe80_clk]     [expr 2 * ${FE80_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf_clk]          -to [get_clocks fe80_clk]     [expr 2 * ${FE80_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf20_clk]        -to [get_clocks fe80_clk]     [expr 2 * ${FE80_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks mpif_clk]         -to [get_clocks fe80_clk]     [expr 2 * ${FE80_PERIOD}]
set_max_delay -datapath_only -from [get_clocks phy_clk]          -to [get_clocks fe80_clk]     [expr 2 * ${FE80_PERIOD}]
set_max_delay -datapath_only -from [get_clocks mdmb44_clk]       -to [get_clocks fe80_clk]     [expr 2 * ${FE80_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks bd_clk]           -to [get_clocks fe80_clk]     [expr 2 * ${FE80_PERIOD}]
set_max_delay -datapath_only -from [get_clocks userclk1]         -to [get_clocks fe80_clk]     [expr 2 * ${FE80_PERIOD}]
                                                           
set_max_delay -datapath_only -from [get_clocks ref200_clk]       -to [get_clocks fe_clk]       [expr 2 * ${FE_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf_clk]          -to [get_clocks fe_clk]       [expr 2 * ${FE_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf20_clk]        -to [get_clocks fe_clk]       [expr 2 * ${FE_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks mpif_clk]         -to [get_clocks fe_clk]       [expr 2 * ${FE_PERIOD}]
set_max_delay -datapath_only -from [get_clocks phy_clk]          -to [get_clocks fe_clk]       [expr 2 * ${FE_PERIOD}]
set_max_delay -datapath_only -from [get_clocks adc0_clk]         -to [get_clocks fe_clk]       [expr 2 * ${FE_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks adc1_clk]         -to [get_clocks fe_clk]       [expr 2 * ${FE_PERIOD}]
set_max_delay -datapath_only -from [get_clocks userclk1]         -to [get_clocks fe_clk]       [expr 2 * ${FE_PERIOD}]
#To PHY Clock domain
set_max_delay -datapath_only -from [get_clocks ref200_clk]       -to [get_clocks phy_clk]      [expr 2 * ${PHY_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf_clk]          -to [get_clocks phy_clk]      [expr 2 * ${PHY_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf20_clk]        -to [get_clocks phy_clk]      [expr 2 * ${PHY_PERIOD}]
set_max_delay -datapath_only -from [get_clocks mac_core_clk]     -to [get_clocks phy_clk]      [expr 2 * ${PHY_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks mpif_clk]         -to [get_clocks phy_clk]      [expr 2 * ${PHY_PERIOD}]
set_max_delay -datapath_only -from [get_clocks mdmb44_clk]         -to [get_clocks phy_clk]      [expr 2 * ${PHY_PERIOD}]
set_max_delay -datapath_only -from [get_clocks fe40_clk]         -to [get_clocks phy_clk]      [expr 2 * ${PHY_PERIOD}]
set_max_delay -datapath_only -from [get_clocks fe80_clk]         -to [get_clocks phy_clk]      [expr 2 * ${PHY_PERIOD}]
set_max_delay -datapath_only -from [get_clocks fe_clk]           -to [get_clocks phy_clk]      [expr 2 * ${PHY_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks bd_clk]           -to [get_clocks phy_clk]      [expr 2 * ${PHY_PERIOD}]
set_max_delay -datapath_only -from [get_clocks userclk1]         -to [get_clocks phy_clk]      [expr 2 * ${PHY_PERIOD}]

#set_max_delay -datapath_only -from [get_clocks ref200_clk]       -to [get_clocks svd_clk]      [expr 2 * ${SVD_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks plf_clk]          -to [get_clocks svd_clk]      [expr 2 * ${SVD_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks plf20_clk]        -to [get_clocks svd_clk]      [expr 2 * ${SVD_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks mac_core_clk]     -to [get_clocks svd_clk]      [expr 2 * ${SVD_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks userclk1]         -to [get_clocks svd_clk]      [expr 2 * ${SVD_PERIOD}]
#To MPIF clock domain
#set_max_delay -datapath_only -from [get_clocks ref200_clk]       -to [get_clocks mpif_clk]     [expr 2 * ${MPIF_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks plf_clk]          -to [get_clocks mpif_clk]     [expr 2 * ${MPIF_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks plf20_clk]        -to [get_clocks mpif_clk]     [expr 2 * ${MPIF_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks mac_core_clk]     -to [get_clocks mpif_clk]     [expr 2 * ${MPIF_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks phy_clk]          -to [get_clocks mpif_clk]     [expr 2 * ${MPIF_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks fe40_clk]         -to [get_clocks mpif_clk]     [expr 2 * ${MPIF_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks fe80_clk]         -to [get_clocks mpif_clk]     [expr 2 * ${MPIF_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks fe_clk]           -to [get_clocks mpif_clk]     [expr 2 * ${MPIF_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks mdmb44_clk]       -to [get_clocks mpif_clk]     [expr 2 * ${MPIF_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks bd_clk]           -to [get_clocks mpif_clk]     [expr 2 * ${MPIF_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks userclk1]         -to [get_clocks mpif_clk]     [expr 2 * ${MPIF_PERIOD}]
#To BD clock domain
#set_max_delay -datapath_only -from [get_clocks ref200_clk]       -to [get_clocks bd_clk]       [expr 2 * ${BD_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks plf_clk]          -to [get_clocks bd_clk]       [expr 2 * ${BD_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks plf20_clk]        -to [get_clocks bd_clk]       [expr 2 * ${BD_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks mpif_clk]         -to [get_clocks bd_clk]       [expr 2 * ${BD_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks phy_clk]          -to [get_clocks bd_clk]       [expr 2 * ${BD_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks userclk1]         -to [get_clocks bd_clk]       [expr 2 * ${BD_PERIOD}]
#To ModemB clock domain
set_max_delay -datapath_only -from [get_clocks ref200_clk]       -to [get_clocks mdmb44_clk]   [expr 2 * ${MDMB44_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf_clk]          -to [get_clocks mdmb44_clk]   [expr 2 * ${MDMB44_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf20_clk]        -to [get_clocks mdmb44_clk]   [expr 2 * ${MDMB44_PERIOD}]
#set_max_delay -datapath_only -from [get_clocks mpif_clk]         -to [get_clocks mdmb44_clk]   [expr 2 * ${MDMB44_PERIOD}]
set_max_delay -datapath_only -from [get_clocks phy_clk]          -to [get_clocks mdmb44_clk]   [expr 2 * ${MDMB44_PERIOD}]
set_max_delay -datapath_only -from [get_clocks fe40_clk]         -to [get_clocks mdmb44_clk]   [expr 2 * ${MDMB44_PERIOD}]
set_max_delay -datapath_only -from [get_clocks fe80_clk]         -to [get_clocks mdmb44_clk]   [expr 2 * ${MDMB44_PERIOD}]
set_max_delay -datapath_only -from [get_clocks fe_clk]           -to [get_clocks mdmb44_clk]   [expr 2 * ${MDMB44_PERIOD}]
set_max_delay -datapath_only -from [get_clocks userclk1]         -to [get_clocks mdmb44_clk]   [expr 2 * ${MDMB44_PERIOD}]
#To Karst clock domain
set_max_delay -datapath_only -from [get_clocks plf_clk]          -to [get_clocks adc0_clk]     [expr 2 * ${ADC0_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf20_clk]        -to [get_clocks adc0_clk]     [expr 2 * ${ADC0_PERIOD}]
set_max_delay -datapath_only -from [get_clocks fe_clk]           -to [get_clocks adc0_clk]     [expr 2 * ${ADC0_PERIOD}]
set_max_delay -datapath_only -from [get_clocks userclk1]         -to [get_clocks adc0_clk]     [expr 2 * ${ADC0_PERIOD}]

set_max_delay -datapath_only -from [get_clocks plf_clk]          -to [get_clocks adc1_clk]     [expr 2 * ${ADC1_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf20_clk]        -to [get_clocks adc1_clk]     [expr 2 * ${ADC1_PERIOD}]
set_max_delay -datapath_only -from [get_clocks fe_clk]           -to [get_clocks adc1_clk]     [expr 2 * ${ADC1_PERIOD}]
set_max_delay -datapath_only -from [get_clocks userclk1]         -to [get_clocks adc1_clk]     [expr 2 * ${ADC1_PERIOD}]
#To PCIe clock domain                                                                    
set_max_delay -datapath_only -from [get_clocks ref200_clk]       -to [get_clocks pcie_clk]     [expr 2 * ${PCIE_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf_clk]          -to [get_clocks pcie_clk]     [expr 2 * ${PCIE_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf20_clk]        -to [get_clocks pcie_clk]     [expr 2 * ${PCIE_PERIOD}]
set_max_delay -datapath_only -from [get_clocks userclk1]         -to [get_clocks pcie_clk]     [expr 2 * ${PCIE_PERIOD}]
#To PCIe AXI clock domain (created by PCIe subsytem bd file)                                      
set_max_delay -datapath_only -from [get_clocks ref200_clk]       -to [get_clocks userclk1]     [expr 2 * ${PCIE_AXI_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf_clk]          -to [get_clocks userclk1]     [expr 2 * ${PCIE_AXI_PERIOD}]
set_max_delay -datapath_only -from [get_clocks plf20_clk]        -to [get_clocks userclk1]     [expr 2 * ${PCIE_AXI_PERIOD}]

# FE to LA , asynchronous, all false paths except withing u_async_fifo_adc2la instance
set_false_path -from [get_clocks fe_clk] -to [get_clocks la_clk] -hold
set_max_delay  -datapath_only -from [get_clocks fe_clk] -to [get_clocks la_clk] [expr 10 * ${LA_PERIOD}]
set_false_path -from [get_clocks la_clk] -to [get_clocks fe_clk] -hold
set_max_delay  -datapath_only -from [get_clocks la_clk] -to [get_clocks fe_clk] [expr 10 * ${FE_PERIOD}]

if {[get_cell -hier -filter { name =~ *u_async_fifo_adc2la* }] != "" } {
  set_max_delay -from [filter [all_register -clock fe_clk] {name =~*adc2la*}] -to [filter [all_register -clock la_clk] {name =~*adc2la*}] -reset_path [expr 2 * ${LA_PERIOD}]
  set_max_delay -from [filter [all_register -clock la_clk] {name =~*adc2la*}] -to [filter [all_register -clock fe_clk] {name =~*adc2la*}] -reset_path [expr 2 * ${FE_PERIOD}]
}

#-------------------------------------------------------------------------------
# False Path
#-------------------------------------------------------------------------------
# False path for MPIF Diag from Modem
set_false_path -from [get_clocks phy_clk] -through [get_cells -hierarchical u_rw_nx_diag[*]] -to [get_clocks la_clk]

#-------------------------------------------------------------------------------
# End of file
#-------------------------------------------------------------------------------
