#-------------------------------------------------------------------------------
set block   "rw_he_v7"
set workdir "par"
set part    "xc7v2000tflg1925-1"

set TIME_start [expr [clock clicks -milliseconds]/1000]
#-------------------------------------------------------------------------------
if {[llength $argv] == 0} {
  set njobs 2
} else {
  set njobs [lindex $argv 0]
}
#-------------------------------------------------------------------------------
proc hh:mm:ss {secs} {
       set h [expr {${secs}/3600}]
       incr secs [expr {${h}*-3600}]
       set m [expr {${secs}/60}]
       set s [expr {${secs}%60}]
       format "%02.2d:%02.2d:%02.2d" ${h} ${m} ${s}
}
#-------------------------------------------------------------------------------
proc wait_license {} {}
if {[file exist ${block}_func.tcl]==1} {
   source ${block}_func.tcl
}
#-------------------------------------------------------------------------------
# Create workdir if doesn't exist.
if {[file exist ${workdir}]==0} {
   file mkdir ${workdir}
}
#-------------------------------------------------------------------------------
proc report_phase {phase text start} {
   set text  "[format {%-40s} ${text}]"
   set TIME_taken [hh:mm:ss [expr [clock clicks -milliseconds]/1000 - $start]]
   puts "RW_INFO: VIVADO Phase ${phase}/10 : ${text} (${TIME_taken})"
}
#-------------------------------------------------------------------------------
proc report_status {phase text} {
   set wns [get_property SLACK [get_timing_paths -setup -quiet]]
   set whs [get_property SLACK [get_timing_paths -hold  -quiet]]
   set tns 0
   set ths 0
   foreach tp [get_timing_paths -setup -quiet -max_paths 100000 -filter {SLACK < 0}] {
      set tns [expr $tns + [get_property SLACK $tp]]
   }
   foreach tp [get_timing_paths -hold  -quiet -max_paths 100000 -filter {SLACK < 0}] {
      set ths [expr $ths + [get_property SLACK $tp]]
   }
   set text  "[format {%-40s} ${text}]"
   set setup "WNS=[format {%2.3f} ${wns}] / TNS=[format {%2.3f} ${tns}]"
   set hold  "WHS=[format {%2.3f} ${whs}] / THS=[format {%2.3f} ${ths}]"
   puts "RW_INFO: VIVADO Phase ${phase}/10 : ${text}: ${setup} - ${hold}"
}
#-------------------------------------------------------------------------------
proc report_par_status {phase text wns tns whs ths} {
   set text  "[format {%-40s} ${text}]"
   set setup "WNS=[format {%2.3f} ${wns}] / TNS=[format {%2.3f} ${tns}]"
   set hold  "WHS=[format {%2.3f} ${whs}] / THS=[format {%2.3f} ${ths}]"
   puts "RW_INFO: VIVADO Phase ${phase}/10 : ${text}: ${setup} - ${hold}"
}
#-------------------------------------------------------------------------------
# Remove old bit file, if exist.
if {[file exist ${workdir}/${block}.bit]==1} {
   exec rm -f ${workdir}/${block}.bit
}
#-------------------------------------------------------------------------------
set place_directive [list]
lappend place_directive Default
lappend place_directive Explore
lappend place_directive WLDrivenBlockPlacement
lappend place_directive ExtraPostPlacementOpt
lappend place_directive ExtraTimingOpt
lappend place_directive ExtraNetDelay_high
lappend place_directive ExtraNetDelay_low
lappend place_directive SSI_SpreadLogic_high
lappend place_directive SSI_SpreadLogic_low
lappend place_directive AltSpreadLogic_high
lappend place_directive AltSpreadLogic_medium
lappend place_directive AltSpreadLogic_low
lappend place_directive SSI_SpreadSLLs
lappend place_directive SSI_BalanceSLLs
lappend place_directive SSI_BalanceSLRs
lappend place_directive SSI_HighUtilSLRs
set par_started [list]
# PAR loop
while { 1 } {
   # launch PAR
   while { [llength $place_directive] > 0 && [llength ${par_started}] < ${njobs} } {
      set pd [lindex $place_directive 0]
      set place_directive [lreplace $place_directive 0 0]

      report_phase  "--" "par started ($pd)" $TIME_start

      if {[file exist ${workdir}/${block}_${pd}_done]==1} {
         exec rm -f ${workdir}/${block}_${pd}_done
      }

      exec ./${block}_smart.sh $pd &
      lappend par_started $pd
   }

   # Check PAR status
   foreach par $par_started {
      if {[file exist ${workdir}/${block}_${par}_done]==1} {
         if {[file exist ${workdir}/${block}_${par}_postroute_physopted.dcp]==1 &&
             [file exist ${workdir}/${block}_${par}_status.tcl]==1} {

            # Read timing result (tns wns)
            source -notrace ${workdir}/${block}_${par}_status.tcl

            report_par_status "--" "par done    (${par})" ${wns} ${tns} ${whs} ${ths}

            if {[info exists best_slack] == 0} {
               # Save first placement result
               set best_slack ${wns}
               set best_hold  ${whs}
               set best_run   ${par}
            } elseif {${wns} > ${best_slack}} {
               # Save placement result if SLACK is better
               set best_slack ${wns}
               set best_hold  ${whs}
               set best_run   ${par}
            } elseif {${wns} == ${best_slack} && ${whs} > ${best_hold}} {
               # Save placement result if SETUP is same and HOLD is better
               set best_slack ${wns}
               set best_hold  ${whs}
               set best_run   ${par}
            }
         } else {
            report_phase  "--" "par aborted (${par})" $TIME_start
         }
         set index [lsearch $par_started ${par}]
         set par_started [lreplace $par_started $index $index]
      }
   }

   # Stop when timing is meet
   if {[info exists best_slack] == 1} {
      if {${best_slack} >= 0 && ${best_hold} >= 0} { break }
   }

   # Stop when all jobs done
   if { [llength ${par_started}]==0 && [llength $place_directive]==0 } {break}

   # Wait 5min when maximum run is reached
   if { [llength ${par_started}] == ${njobs} || [llength $place_directive] == 0 } {
      after [ expr {int(5 * 60 * 1000)} ]
   }
}
#-------------------------------------------------------------------------------
# Display the best run log file
set fd [open ${workdir}/${block}_${best_run}.log r]
while {[gets $fd line] >= 0} {
   puts $line
}
close $fd
#-------------------------------------------------------------------------------
exec cp -f ${workdir}/${block}_${best_run}_postroute_physopted.dcp \
           ${workdir}/${block}_postroute_physopted.dcp
open_checkpoint -quiet ${workdir}/${block}_postroute_physopted.dcp
report_timing_summary -warn_on_violation -max_paths 10 \
   -file ${workdir}/${block}_timing_summary_postroute_physopted.rpt \
   -rpx  ${workdir}/${block}_timing_summary_postroute_physopted.rpx
#-------------------------------------------------------------------------------
report_phase "09" "Generate reports" ${TIME_start}
report_clock_utilization         -file ${workdir}/${block}_clock_utilization.rpt
report_utilization               -file ${workdir}/${block}_utilization.rpt
report_utilization -hierarchical -file ${workdir}/${block}_utilization_hierarchical.rpt
report_drc                       -file ${workdir}/${block}_drc.rpt
report_io                        -file ${workdir}/${block}_io.rpt
report_datasheet                 -file ${workdir}/${block}_datasheet.rpt
#-------------------------------------------------------------------------------
report_phase "10" "write_bitstream" ${TIME_start}
write_bitstream -force ${workdir}/${block}.bit
#-------------------------------------------------------------------------------
report_phase  "--" "P&R Completed" ${TIME_start}
report_status "--" "P&R Completed (${best_run})"
#-------------------------------------------------------------------------------
# Kill remaining PAR process
exec kill 0
#-------------------------------------------------------------------------------
