//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: jvanthou $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: 2015-12-18 17:02:34 +0100 (Fri, 18 Dec 2015) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : clock and reset control module
// Simulation Notes : 
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//////////////////////////////////////////////////////////////////////////////
//`define MAC_FREQ_40MHZ
`default_nettype none
module clock_ctrl
(
  /*******************************************************************
  * Incoming resets
  *******************************************************************/
  input  wire        por_rst_n,

  /*******************************************************************
  * Reset requests
  *******************************************************************/
  input  wire        soft_reset_req_n,

  /*******************************************************************
  * Outgoing requests
  *******************************************************************/
  output wire        plf_rst_n,
  output wire        mac_core_rst_n,
  output wire        mac_wt_rst_n,
  output wire        mpif_rst_n,
  
  /*******************************************************************
  * NMB
  *******************************************************************/

  /*******************************************************************
  * Incoming clocks
  *******************************************************************/             
  input wire         ahb_clk,         
  input wire         clk_ref200,
  /*******************************************************************
  * Clock request and enables
  *******************************************************************/
  
  input  wire        mac_pi_clken,
  input  wire        mac_pi_tx_clken,
  input  wire        mac_pi_rx_clken,
  input  wire        mac_core_clken,
  input  wire        mac_core_tx_clken,
  input  wire        mac_core_rx_clken,
  input  wire        mac_crypt_clken,
`ifdef RW_MUMIMO_SEC_USER1_EN
  input  wire        sec_u1_mac_pi_tx_clken,
  input  wire        sec_u1_mac_core_tx_clken,
  input  wire        sec_u1_mac_crypt_clken,
  input  wire        sec_u1_mpif_clken,
`endif // RW_MUMIMO_SEC_USER1_EN
`ifdef RW_MUMIMO_SEC_USER2_EN
  input  wire        sec_u2_mac_pi_tx_clken,
  input  wire        sec_u2_mac_core_tx_clken,
  input  wire        sec_u2_mac_crypt_clken,
  input  wire        sec_u2_mpif_clken,
`endif // RW_MUMIMO_SEC_USER2_EN
`ifdef RW_MUMIMO_SEC_USER3_EN
  input  wire        sec_u3_mac_pi_tx_clken,
  input  wire        sec_u3_mac_core_tx_clken,
  input  wire        sec_u3_mac_crypt_clken,
  input  wire        sec_u3_mpif_clken,
`endif // RW_MUMIMO_SEC_USER3_EN
  input  wire        mac_wt_clken,
  input  wire        mpif_clken,
  input  wire        mac_lp_clkswitch,

  /*******************************************************************
  * Outgoing clocks
  *******************************************************************/
  output wire        plf_clk,
  output wire        uart_clk,
  output wire        mac_pi_free_clk,
  output wire        mac_pi_clk,
  output wire        mac_pi_tx_clk,
  output wire        mac_pi_rx_clk,
  output wire        mac_core_free_clk,
  output wire        mac_core_clk,
  output wire        mac_core_tx_clk,
  output wire        mac_core_rx_clk,
  output wire        mac_crypt_clk,
`ifdef RW_MUMIMO_SEC_USER1_EN
  output wire        sec_u1_mac_pi_tx_clk,
  output wire        sec_u1_mac_core_tx_clk,
  output wire        sec_u1_mac_crypt_clk,
  output wire        sec_u1_mpif_clk,
`endif // RW_MUMIMO_SEC_USER1_EN
`ifdef RW_MUMIMO_SEC_USER2_EN
  output wire        sec_u2_mac_pi_tx_clk,
  output wire        sec_u2_mac_core_tx_clk,
  output wire        sec_u2_mac_crypt_clk,
  output wire        sec_u2_mpif_clk,
`endif // RW_MUMIMO_SEC_USER2_EN
`ifdef RW_MUMIMO_SEC_USER3_EN
  output wire        sec_u3_mac_pi_tx_clk,
  output wire        sec_u3_mac_core_tx_clk,
  output wire        sec_u3_mac_crypt_clk,
  output wire        sec_u3_mpif_clk,
`endif // RW_MUMIMO_SEC_USER3_EN
  output wire        mac_lp_clk,
  output wire        mac_wt_free_clk,
  output wire        mac_wt_clk,
  output wire        mpif_free_clk,
  output wire        mpif_clk,
  output wire        la_clk,

  /*******************************************************************
  * MMCM Configuration
  *******************************************************************/
  output reg         dyncfgmmc_done,
  output reg  [15:0] dyncfgmmc_rdata,
  input  wire        dyncfgmmc_start,
  input  wire        dyncfgmmc_we,
  input  wire  [3:0] dyncfgmmc_sel,
  input  wire [15:0] dyncfgmmc_addr,
  input  wire [15:0] dyncfgmmc_wdata,
  input  wire        fmetre_start,
  output reg         fmetre_done,
  output wire [19:0] fmetre_maccore,
  output wire [19:0] fmetre_macwt,
  output wire [19:0] fmetre_mpif,
  output wire [19:0] fmetre_la,
  output wire [19:0] fmetre_macpi,

  /*******************************************************************
  * MMCM Status
  *******************************************************************/
  output wire        mmc0_lock
);

  localparam S_IDLE     =2'd0,
             S_DO_RESET =2'd1,
             S_WAIT_DRDY=2'd2,
             S_WAIT_DONE=2'd3;

  /*****************************************************************************
  * declarations
  *****************************************************************************/
  wire global_rst_n;
  wire global_rst;
  
  reg  reset_req_n_1t;
  reg  reset_req_n_2t;
  
  wire async_plf_rst_n;
  reg  cleaner_plf_rst_n_m5t;
  reg  cleaner_plf_rst_n_m4t;
  reg  cleaner_plf_rst_n_m3t;
  reg  cleaner_plf_rst_n_m2t;
  reg  cleaner_plf_rst_n_m1t;
  
  wire async_tap_rst_n;
  reg  cleaner_tap_rst_n_m5t;
  reg  cleaner_tap_rst_n_m4t;
  reg  cleaner_tap_rst_n_m3t;
  reg  cleaner_tap_rst_n_m2t;
  reg  cleaner_tap_rst_n_m1t;

  reg  cleaner_g2_rst_n_m5t;
  reg  cleaner_g2_rst_n_m4t;
  reg  cleaner_g2_rst_n_m3t;
  reg  cleaner_g2_rst_n_m2t;
  reg  cleaner_g2_rst_n_m1t;
  wire g2_rst_n;
  reg [5:0] nmb_idel_rst_counter;
  
  wire  async_nmb_rst_n;
  reg   nmb_rst_n_2t;
  reg   nmb_rst_n_1t;
  
  wire  g0_clk_prebufg;
  wire  g1_clk_prebufg;
  wire  g2_clk_prebufg;

  wire  mac_core_clk_prebufg;
  wire  mac_wt_clk_prebufg;
  wire  mpif_clk_prebufg;
  wire  la_clk_prebufg;
  wire  mac_lp_root_clk;
  
  wire  g0_root_clk       /* synthesis syn_keep = 1 */;
  wire  g1_root_clk       /* synthesis syn_keep = 1 */;
  wire  g2_root_clk       /* synthesis syn_keep = 1 */;
  wire  mac_core_root_clk /* synthesis syn_keep = 1 */;
  wire  mac_wt_root_clk   /* synthesis syn_keep = 1 */;
  wire  la_root_clk       /* synthesis syn_keep = 1 */;
  wire  mpif_root_clk     /* synthesis syn_keep = 1 */;
  wire  g2_clk;
  wire  async_mac_rst_n;
  reg   mac_rst_n;
  reg   mac_rst_n_1t;
  reg   mac_rst_n_2t;

  wire  async_macphy_rst_n;
  reg   macphy_rst_n;
  reg   macphy_rst_n_1t;
  reg   macphy_rst_n_2t;

  wire  mmc0_rst;
  wire  mmc0_clk_fb;
  
  wire  mmc1_rst;
  wire  mmc1_fb;
  wire  mmc1_fb_prebufg;
  
  reg mac_lp_clk_gen;
  reg [11:0] mac_lp_clk_cnt;

  reg         mmc0_drst;
  reg   [6:0] mmc0_daddr;
  reg         mmc0_den;
  reg  [15:0] mmc0_di;
  reg         mmc0_dwe;
  wire [15:0] mmc0_do;
  wire        mmc0_drdy;

  reg         mmc1_drst;
  reg   [6:0] mmc1_daddr;
  reg         mmc1_den;
  reg  [15:0] mmc1_di;
  reg         mmc1_dwe;
  wire [15:0] mmc1_do;
  wire        mmc1_drdy;
  reg [ 1:0]  dyncfgmmc_state; 
  reg         dyncfgmmc_start_1t;   
  reg         dyncfgmmc_start_2t;  

  /*****************************************************************************
  * platform related clocks (G0 source)
  *****************************************************************************/
  /* G0 source */

  assign g0_root_clk = ahb_clk;
  
  /*****************************************************************************
  * MAC/PHY interface related clock (G1 source 30 MHz)
  *****************************************************************************/
  BUFG mpif_clk_bufg
  (
    .I(             mpif_clk_prebufg),
    .O(             mpif_root_clk)
  ); 
   

  /*****************************************************************************
  * MAC related clocks (G2 source 200 MHz)
  *****************************************************************************/
 
  assign g2_root_clk = clk_ref200;
  
  MMCM_ADV
  #(
    .DIVCLK_DIVIDE(    1),
    .CLKFBOUT_MULT_F(  6),

`ifdef  MAC_FREQ_72MHZ
    .CLKOUT1_DIVIDE(   17),
    .CLKOUT2_DIVIDE(   17),
`endif//MAC_FREQ_72MHZ

`ifdef  MAC_FREQ_100MHZ
    .CLKOUT1_DIVIDE(   12),
    .CLKOUT2_DIVIDE(   12),
`endif//MAC_FREQ_100MHZ

`ifdef  MAC_FREQ_80MHZ
    .CLKOUT1_DIVIDE(   15),
    .CLKOUT2_DIVIDE(   15),
`endif//MAC_FREQ_80MHZ

`ifdef  MAC_FREQ_60MHZ
    .CLKOUT1_DIVIDE(   20),
    .CLKOUT2_DIVIDE(   20),
`endif//MAC_FREQ_60MHZ

`ifdef  MAC_FREQ_40MHZ
      .CLKOUT1_DIVIDE(   30),
      .CLKOUT2_DIVIDE(   15),
`endif//MAC_FREQ_40MHZ

`ifdef  MAC_FREQ_20MHZ
      .CLKOUT1_DIVIDE(   60),
      .CLKOUT2_DIVIDE(   20),
`endif//MAC_FREQ_20MHZ
    
    .CLKIN1_PERIOD(    5.0)
  ) 
  u_mmc0
  (
    // Control Ports
    .CLKINSEL(      1'b1),
    .PWRDWN(        1'b0),
    .RST(           mmc0_rst),
    // Clock Inputs
    .CLKIN1(        g2_root_clk),
    .CLKIN2(        1'b0),
    // Clock Outputs
    .CLKOUT0(       ),
    .CLKOUT0B(      ),
    .CLKOUT1(       mac_core_clk_prebufg),
    .CLKOUT1B(      ),
    .CLKOUT2(       mac_wt_clk_prebufg),
    .CLKOUT2B(      ),
    .CLKOUT3(       ),
    .CLKOUT3B(      ),
    .CLKOUT4(       ),
    .CLKOUT5(       ),
    .CLKOUT6(       ),
    // Feedback Clocks
    .CLKFBIN(       mmc0_clk_fb),
    .CLKFBOUT(      mmc0_clk_fb),
    .CLKFBOUTB(     ),
    // Status Ports
    .CLKFBSTOPPED(  ),
    .CLKINSTOPPED(  ),
    .LOCKED(        mmc0_lock),
    // Dynamic reconfigration ports
    .DADDR(         mmc0_daddr),
    .DCLK(          plf_clk),
    .DEN(           mmc0_den),
    .DI(            mmc0_di),
    .DWE(           mmc0_dwe),
    .DO(            mmc0_do),
    .DRDY(          mmc0_drdy),
    // Dynamic Phase Shift Ports
    .PSCLK(         1'b0),
    .PSEN(          1'b0),
    .PSINCDEC(      1'b0),
    .PSDONE(        ) 
  );
  
  BUFG mac_core_clk_bufg
  (
    .I(             mac_core_clk_prebufg),
    .O(             mac_core_root_clk)
  ); 

  BUFG mac_wt_clk_bufg
  (
    .I(             mac_wt_clk_prebufg),
    .O(             mac_wt_root_clk)
  ); 
  
  BUFGMUX 
  #(
      .CLK_SEL_TYPE("ASYNC")
  )  
    mac_lp_clk_bufgmux
  (
    .I0(mac_core_clk_prebufg),
    .I1(mac_lp_clk_gen),
    .S(mac_lp_clkswitch),
    .O(mac_lp_root_clk)
   );

  // generation of a 32kHz clock from the 200MHz G2 clock input
  always @(posedge g2_root_clk, negedge g2_rst_n)
  begin
  
    if(g2_rst_n==1'b0)
    begin
      mac_lp_clk_gen <= 1'b0; 
      mac_lp_clk_cnt <= 12'b0;
    end
    else
    begin 
      if (mac_lp_clk_cnt == 12'd3124)
      begin
        mac_lp_clk_gen <= ~mac_lp_clk_gen;
        mac_lp_clk_cnt <= 12'b0;
      end
      else
        mac_lp_clk_cnt <= mac_lp_clk_cnt + 12'd1;
    end
  end

  /*****************************************************************************
  * MAC clock
  *****************************************************************************/   
  assign g2_clk          = g2_root_clk;

  assign plf_clk         = g0_root_clk;

  assign mac_pi_free_clk = g0_root_clk;

  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_mac_pi_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_mac_pi_clk(
                .clk          (g0_root_clk),
                .resetn       (plf_rst_n),
                .enable       (mac_pi_clken),
                .test         (1'b0),
                .gclk         (mac_pi_clk)
                );
  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_mac_pi_tx_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_mac_pi_tx_clk(
                .clk          (g0_root_clk),
                .resetn       (plf_rst_n),
                .enable       (mac_pi_tx_clken),
                .test         (1'b0),
                .gclk         (mac_pi_tx_clk)
                );
  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_mac_pi_rx_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_mac_pi_rx_clk(
                .clk          (g0_root_clk),
                .resetn       (plf_rst_n),
                .enable       (mac_pi_rx_clken),
                .test         (1'b0),
                .gclk         (mac_pi_rx_clk)
                );

  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_mac_core_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_mac_core_clk(
                .clk          (mac_core_root_clk),
                .resetn       (mac_core_rst_n),
                .enable       (mac_core_clken),
                .test         (1'b0),
                .gclk         (mac_core_clk)
                );
  
  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_mac_core_rx_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_mac_core_tx_clk(
                .clk          (mac_core_root_clk),
                .resetn       (mac_core_rst_n),
                .enable       (mac_core_tx_clken),
                .test         (1'b0),
                .gclk         (mac_core_tx_clk)
                );
  
  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_mac_core_rx_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_mac_core_rx_clk(
                .clk          (mac_core_root_clk),
                .resetn       (mac_core_rst_n),
                .enable       (mac_core_rx_clken),
                .test         (1'b0),
                .gclk         (mac_core_rx_clk)
                );
  
  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_mac_crypt_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_mac_crypt_clk(
                .clk          (mac_core_root_clk),
                .resetn       (mac_core_rst_n),
                .enable       (mac_crypt_clken),
                .test         (1'b0),
                .gclk         (mac_crypt_clk)
                );
  
`ifdef RW_MUMIMO_SEC_USER1_EN
  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_sec_u1_mac_pi_tx_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_sec_u1_mac_pi_tx_clk(
                .clk          (g0_root_clk),
                .resetn       (plf_rst_n),
                .enable       (sec_u1_mac_pi_tx_clken),
                .test         (1'b0),
                .gclk         (sec_u1_mac_pi_tx_clk)
                );

  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_sec_u1_mac_core_rx_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_sec_u1_mac_core_tx_clk(
                .clk          (mac_core_root_clk),
                .resetn       (mac_core_rst_n),
                .enable       (sec_u1_mac_core_tx_clken),
                .test         (1'b0),
                .gclk         (sec_u1_mac_core_tx_clk)
                );

  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_sec_u1_mac_crypt_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_sec_u1_mac_crypt_clk(
                .clk          (mac_core_root_clk),
                .resetn       (mac_core_rst_n),
                .enable       (sec_u1_mac_crypt_clken),
                .test         (1'b0),
                .gclk         (sec_u1_mac_crypt_clk)
                );

  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_sec_u1_mpif_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_sec_u1_mpif_clk(
                .clk          (mpif_root_clk),
                .resetn       (mpif_rst_n),
                .enable       (sec_u1_mpif_clken),
                .test         (1'b0),
                .gclk         (sec_u1_mpif_clk)
                );
`endif // RW_MUMIMO_SEC_USER1_EN

`ifdef RW_MUMIMO_SEC_USER2_EN
  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_sec_u2_mac_pi_tx_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_sec_u2_mac_pi_tx_clk(
                .clk          (g0_root_clk),
                .resetn       (plf_rst_n),
                .enable       (sec_u2_mac_pi_tx_clken),
                .test         (1'b0),
                .gclk         (sec_u2_mac_pi_tx_clk)
                );

  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_sec_u2_mac_core_rx_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_sec_u2_mac_core_tx_clk(
                .clk          (mac_core_root_clk),
                .resetn       (mac_core_rst_n),
                .enable       (sec_u2_mac_core_tx_clken),
                .test         (1'b0),
                .gclk         (sec_u2_mac_core_tx_clk)
                );

  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_sec_u2_mac_crypt_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_sec_u2_mac_crypt_clk(
                .clk          (mac_core_root_clk),
                .resetn       (mac_core_rst_n),
                .enable       (sec_u2_mac_crypt_clken),
                .test         (1'b0),
                .gclk         (sec_u2_mac_crypt_clk)
                );

  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_sec_u2_mpif_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_sec_u2_mpif_clk(
                .clk          (mpif_root_clk),
                .resetn       (mpif_rst_n),
                .enable       (sec_u2_mpif_clken),
                .test         (1'b0),
                .gclk         (sec_u2_mpif_clk)
                );
`endif // RW_MUMIMO_SEC_USER2_EN

`ifdef RW_MUMIMO_SEC_USER3_EN
  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_sec_u3_mac_pi_tx_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_sec_u3_mac_pi_tx_clk(
                .clk          (g0_root_clk),
                .resetn       (plf_rst_n),
                .enable       (sec_u3_mac_pi_tx_clken),
                .test         (1'b0),
                .gclk         (sec_u3_mac_pi_tx_clk)
                );

  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_sec_u3_mac_core_rx_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_sec_u3_mac_core_tx_clk(
                .clk          (mac_core_root_clk),
                .resetn       (mac_core_rst_n),
                .enable       (sec_u3_mac_core_tx_clken),
                .test         (1'b0),
                .gclk         (sec_u3_mac_core_tx_clk)
                );

  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_sec_u3_mac_crypt_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_sec_u3_mac_crypt_clk(
                .clk          (mac_core_root_clk),
                .resetn       (mac_core_rst_n),
                .enable       (sec_u3_mac_crypt_clken),
                .test         (1'b0),
                .gclk         (sec_u3_mac_crypt_clk)
                );

  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_sec_u3_mpif_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_sec_u3_mpif_clk(
                .clk          (mpif_root_clk),
                .resetn       (mpif_rst_n),
                .enable       (sec_u3_mpif_clken),
                .test         (1'b0),
                .gclk         (sec_u3_mpif_clk)
                );
`endif // RW_MUMIMO_SEC_USER3_EN


  assign mac_lp_clk      = mac_lp_root_clk;
//  assign mac_lp_clk      = mac_core_root_clk; 


  assign mac_core_free_clk = mac_core_root_clk;

`ifdef NO_PRNG_FASTER_CLK
  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_mac_wt_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_mac_wt_clk(
                .clk          (mac_core_root_clk),
                .resetn       (mac_wt_rst_n),
                .enable       (mac_wt_clken),
                .test         (1'b0),
                .gclk         (mac_wt_clk)
                );

`else
  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_mac_wt_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_mac_wt_clk(
                .clk          (mac_wt_root_clk),
                .resetn       (mac_wt_rst_n),
                .enable       (mac_wt_clken),
                .test         (1'b0),
                .gclk         (mac_wt_clk)
                );
  `endif

  assign mac_wt_free_clk   = mac_wt_root_clk;

  // Instanciation of rw_clock_gater
  // Name of the instance : u_rw_clock_gater_mpif_clk
  // Name of the file containing this module : rw_clock_gater.v
  rw_clock_gater u_rw_clock_gater_mpif_clk(
                .clk          (mpif_root_clk),
                .resetn       (mpif_rst_n),
                .enable       (mpif_clken),
                .test         (1'b0),
                .gclk         (mpif_clk)
                );

  assign mpif_free_clk   = mpif_root_clk;
 
  assign la_clk          = la_root_clk;
  assign la_root_clk     = ahb_clk;

  /*****************************************************************************
  * uart clock g2/20 = 200/20 = 10 MHz
  *
  * we use G2 because it is a fixed 200 MHz reference clock
  *
  *****************************************************************************/   
  reg  [3:0]  uart_count;
  reg         uart_clk_prebufg;
  
  always @(posedge g2_root_clk, negedge g2_rst_n)
  begin
  
    if(g2_rst_n==1'b0)
    begin
    
      uart_count       <= 4'b0;
      uart_clk_prebufg <= 1'b0;
    
    end
    else
    begin
    
`ifdef RW_SIMU_ON
      if(uart_count==4'd1)
`else
      if(uart_count==4'd9)
`endif
      begin
      
        uart_clk_prebufg <= ~uart_clk_prebufg;
        uart_count       <= 4'b0;
      
      end
      else
      begin

        uart_count <= uart_count + 4'b1;
      
      end
    
    end
  
  end
  
  BUFG uart_bufg
  (
    .I(             uart_clk_prebufg),
    .O(             uart_clk)
  ); 

  /*****************************************************************************
  * reset
  *****************************************************************************/   
  assign global_rst_n = por_rst_n;
  assign global_rst   = ~global_rst_n;
  assign mmc0_rst     = global_rst | mmc0_drst;
  assign mmc1_rst     = global_rst | mmc1_drst;
  
  /* */
  
  /* platform reset */
  always @(posedge plf_clk)
  begin
  
    reset_req_n_1t <= soft_reset_req_n;
    reset_req_n_2t <= reset_req_n_1t;
  
  end
  
  assign async_plf_rst_n = global_rst_n &
                           reset_req_n_2t;
  
  always @(posedge plf_clk,negedge async_plf_rst_n)
  begin
  
    if(async_plf_rst_n==0)
    begin
    
      cleaner_plf_rst_n_m5t <= 0;
      cleaner_plf_rst_n_m4t <= 0;
      cleaner_plf_rst_n_m3t <= 0;

      cleaner_plf_rst_n_m2t <= 0;
      cleaner_plf_rst_n_m1t <= 0;
    end
    else
    begin
    
      cleaner_plf_rst_n_m5t <= 1;
      cleaner_plf_rst_n_m4t <= cleaner_plf_rst_n_m5t;
      cleaner_plf_rst_n_m3t <= cleaner_plf_rst_n_m4t;
      cleaner_plf_rst_n_m2t <= cleaner_plf_rst_n_m3t;
      cleaner_plf_rst_n_m1t <= cleaner_plf_rst_n_m2t;

  
    end
  
  end
 
  assign plf_rst_n = cleaner_plf_rst_n_m1t;

  /* NMB idelay reset */
  always @(posedge g2_root_clk,negedge global_rst_n)
  begin
  
    if(global_rst_n==0)
    begin
    
      cleaner_g2_rst_n_m5t <= 0;
      cleaner_g2_rst_n_m4t <= 0;
      cleaner_g2_rst_n_m3t <= 0;

    end
    else
    begin
    
      cleaner_g2_rst_n_m5t <= 1;
      cleaner_g2_rst_n_m4t <= cleaner_g2_rst_n_m5t;
      cleaner_g2_rst_n_m3t <= cleaner_g2_rst_n_m4t;
      cleaner_g2_rst_n_m2t <= cleaner_g2_rst_n_m3t;
      cleaner_g2_rst_n_m1t <= cleaner_g2_rst_n_m2t;
  
    end
  
  end
 
  assign g2_rst_n = cleaner_g2_rst_n_m1t;

  /* mac reset */
  assign async_mac_rst_n = global_rst_n & async_plf_rst_n & mmc0_lock;
  
  always @(posedge mac_core_root_clk,negedge async_mac_rst_n)
  begin
  
    if(async_mac_rst_n==0)
    begin
    
      mac_rst_n_2t <= 0;
      mac_rst_n_1t <= 0;
      mac_rst_n    <= 0;

    end
    else
    begin
    
      mac_rst_n_2t <= 1;
      mac_rst_n_1t <= mac_rst_n_2t;
      mac_rst_n    <= mac_rst_n_1t;
    
    end
    
  end

  /* macphy reset */
  assign async_macphy_rst_n = global_rst_n & async_plf_rst_n & mmc0_lock;
  
  always @(posedge mpif_root_clk,negedge async_macphy_rst_n)
  begin
  
    if(async_macphy_rst_n==0)
    begin
    
      macphy_rst_n_2t <= 0;
      macphy_rst_n_1t <= 0;
      macphy_rst_n    <= 0;

    end
    else
    begin
    
      macphy_rst_n_2t <= 1;
      macphy_rst_n_1t <= macphy_rst_n_2t;
      macphy_rst_n    <= macphy_rst_n_1t;
    
    end
    
  end

  assign mac_core_rst_n = mac_rst_n;
  assign mac_wt_rst_n   = mac_rst_n;
  assign mpif_rst_n     = macphy_rst_n;


  /*****************************************************************************
  * MMCM Configuration
  *****************************************************************************/   
  always @(posedge plf_clk or negedge plf_rst_n)
  begin
    if(plf_rst_n==1'b0)
    begin
      dyncfgmmc_start_1t <= 1'b0;
      dyncfgmmc_start_2t <= 1'b0;   
      dyncfgmmc_done     <= 1'b0;
      dyncfgmmc_rdata    <= 16'd0;
      mmc0_drst          <= 1'b0;   
      mmc0_den           <= 1'b0;   
      mmc0_dwe           <= 1'b0;   
      mmc0_daddr         <= 7'b0;   
      mmc0_di            <= 16'b0; 
      mmc1_drst          <= 1'b0;   
      mmc1_den           <= 1'b0;   
      mmc1_dwe           <= 1'b0;   
      mmc1_daddr         <= 7'b0;   
      mmc1_di            <= 16'b0; 
      dyncfgmmc_state    <= S_IDLE; 
    end
    else
    begin
      /* resynchro */
      dyncfgmmc_start_1t <= dyncfgmmc_start;
      dyncfgmmc_start_2t <= dyncfgmmc_start_1t;
      
      /* fsm */
      case(dyncfgmmc_state)
        S_IDLE:
        begin
          if(dyncfgmmc_start_2t)
          begin
            if(dyncfgmmc_sel==4'h0)
              mmc0_drst <= 1'b1;
            else
              mmc1_drst <= 1'b1;
            dyncfgmmc_state <= S_DO_RESET;
          end
        end
        S_DO_RESET:
        begin
          if(dyncfgmmc_sel==4'h0)
          begin
            mmc0_daddr <= dyncfgmmc_addr[6:0];
            mmc0_den   <= 1'b1;
            if(dyncfgmmc_we)
            begin
              mmc0_di  <= dyncfgmmc_wdata;
              mmc0_dwe <= 1'b1;
            end
          end
          else
          begin
            mmc1_daddr <= dyncfgmmc_addr[6:0];
            mmc1_den   <= 1'b1;
            if(dyncfgmmc_we)
            begin
              mmc1_di  <= dyncfgmmc_wdata;
              mmc1_dwe <= 1'b1;
            end
          end
          dyncfgmmc_state <= S_WAIT_DRDY;
        end
        S_WAIT_DRDY:
        begin
          if(dyncfgmmc_sel==4'h0)
          begin
            mmc0_daddr <= 7'b0;
            mmc0_den   <= 1'b0;
            mmc0_dwe   <= 1'b0;
            if(mmc0_drdy)
            begin
              if(!dyncfgmmc_we)
              begin
                dyncfgmmc_rdata<= mmc0_do;
              end
              mmc0_drst       <= 1'b0;
              dyncfgmmc_done  <= 1'b1;
              dyncfgmmc_state <= S_WAIT_DONE;
            end
          end
          else
          begin
            mmc1_daddr <= 7'b0;
            mmc1_den   <= 1'b0;
            mmc1_dwe   <= 1'b0;
            if(mmc1_drdy)
            begin
              if(!dyncfgmmc_we)
              begin
                dyncfgmmc_rdata<= mmc1_do;
              end
              mmc1_drst       <= 1'b0;
              dyncfgmmc_done  <= 1'b1;
              dyncfgmmc_state <= S_WAIT_DONE;
            end
          end
        end 
        default: /* S_WAIT_DONE */
        begin
          if(!dyncfgmmc_start_2t)
          begin
            dyncfgmmc_done  <= 1'b0;
            dyncfgmmc_state <= S_IDLE;
          end
        end
      endcase
    end
  end

`ifdef RW_SIMU_ON
  reg [32*8-1:0] dyncfgmmc_state_str;
  always @(*)
    case(dyncfgmmc_state)
      S_IDLE:      dyncfgmmc_state_str = "S_IDLE";
      S_DO_RESET:  dyncfgmmc_state_str = "S_DO_RESET";
      S_WAIT_DRDY: dyncfgmmc_state_str = "S_WAIT_DRDY";
      S_WAIT_DONE: dyncfgmmc_state_str = "S_WAIT_DONE";
      default:     dyncfgmmc_state_str = "XXXXXXXXXX";
    endcase
`endif

  /*****************************************************************************
  * fmetre
  *****************************************************************************/   
  reg         fmetre_start_1t;
  reg         fmetre_start_2t;
  reg         fmetre_enable;
  wire [19:0] fmetre_g2;
  always @(posedge g2_clk,negedge g2_rst_n)
  begin
    if(g2_rst_n==1'b0)
    begin
      fmetre_start_1t  <= 1'b0;
      fmetre_start_2t  <= 1'b0;
      fmetre_enable    <= 1'b0;
      fmetre_done      <= 1'b0;
    end
    else
    begin
      fmetre_start_1t  <= fmetre_start;
      fmetre_start_2t  <= fmetre_start_1t;
     
      if(fmetre_start_2t)
      begin
        if(!fmetre_done)
        begin
`ifdef RW_SIMU_ON
          if(fmetre_g2==20'd2000-3)
`else//RW_SIMU_ON
          if(fmetre_g2==20'd200000-3) // 3 cycles (fmetre start delay)
`endif//RW_SIMU_ON
          begin
            fmetre_enable <= 1'b0;
            fmetre_done   <= 1'b1;
          end
          else
          begin
            fmetre_enable <= 1'b1;
          end  
        end
      end
      else
      begin
        fmetre_enable    <= 1'b0;
        fmetre_done      <= 1'b0;
      end
    end
  end

  rw_clock_fmetre u_rw_clock_fmetre_g2 (
    .rst_n      (1'b1          ),
    .clk        (g2_clk        ),
    .enable     (fmetre_enable ),
    .count      (fmetre_g2     )
  );

  rw_clock_fmetre u_rw_clock_fmetre_mpif (
    .rst_n      (1'b1              ),
    .clk        (mpif_root_clk     ),
    .enable     (fmetre_enable     ),
    .count      (fmetre_mpif       )
  );

  rw_clock_fmetre u_rw_clock_fmetre_la (
    .rst_n      (1'b1              ),
    .clk        (la_root_clk       ),
    .enable     (fmetre_enable     ),
    .count      (fmetre_la         )
  );

  rw_clock_fmetre u_rw_clock_fmetre_maccore (
    .rst_n      (1'b1              ),
    .clk        (mac_core_root_clk ),
    .enable     (fmetre_enable     ),
    .count      (fmetre_maccore   )
  );

  rw_clock_fmetre u_rw_clock_fmetre_macwt (
    .rst_n      (1'b1              ),
    .clk        (mac_wt_root_clk   ),
    .enable     (fmetre_enable     ),
    .count      (fmetre_macwt     )
  );

  rw_clock_fmetre u_rw_clock_fmetre_macpi (
    .rst_n      (1'b1              ),
    .clk        (ahb_clk           ),
    .enable     (fmetre_enable     ),
    .count      (fmetre_macpi      )
  );


endmodule
