/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author:$
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :                                       
* Description      : iqcomp
* Simulation Notes :                                       
* Synthesis Notes  :                                        
* Application Note :                                        
* Simulator        :                                       
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*                                     
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module iqcomp
(
  input  wire        rst_n,
  input  wire        clk,
  
  input  wire [ 9:0] gcos,
  input  wire [ 9:0] gsin,
  
  input  wire [11:0] in_i,
  input  wire [11:0] in_q,
  
  output reg  [11:0] out_i,
  output reg  [11:0] out_q
);

  /*****************************************************************************
  * S0: re-register input
  *****************************************************************************/
  reg [11:0] s0_i,s0_q;
  reg [ 9:0] gcos_1t,gsin_1t;
  reg [ 9:0] gcos_2t,gsin_2t;
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      s0_i    <= 12'b0;
      s0_q    <= 12'b0;
      gcos_1t <= 10'b0;
      gsin_1t <= 10'b0;
      gcos_2t <= 10'b0;
      gsin_2t <= 10'b0;
    end
    else
    begin
      s0_i    <= in_i;
      s0_q    <= in_q;
      gcos_1t <= gcos;
      gsin_1t <= gsin;
      gcos_2t <= gcos_1t;
      gsin_2t <= gsin_1t;
    end
  end
    
  /*****************************************************************************
  * S1: compute compensation 
  *****************************************************************************/
 
  /* max:    -2048*-512+128 = 1048704
  *  min:     2047*-512+128 = -1047936
     range:  [-2**20 2**20-1] = [ -1048576   1048575 ] = [ ok bad ]
             [-2**21 2**21-1] = [ -2097152   2097151 ] = [ ok ok  ]
  
     after 8bit rounding [-1047936 1048704] / 256 =>  [-4093.5   4096.5] => 14 bit range
  
  */
  wire signed [21:0] n_s1_i_x_gcos,n_s1_i_x_gsin;
  wire        [21:0] n_s1_i_x_gcos_fix,n_s1_i_x_gsin_fix;
  
  assign  n_s1_i_x_gcos     = $signed(gcos_2t) * $signed(s0_i);
  assign  n_s1_i_x_gsin     = $signed(gsin_2t) * $signed(s0_i);  
  assign  n_s1_i_x_gcos_fix = $unsigned(n_s1_i_x_gcos) + 22'd128;
  assign  n_s1_i_x_gsin_fix = $unsigned(n_s1_i_x_gsin) + 22'd128;  
  
  reg  [11:0] s1_q;
  reg  [13:0] s1_i_x_gcos,s1_i_x_gsin; 
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      s1_i_x_gcos <= 14'b0;
      s1_i_x_gsin <= 14'b0;
      s1_q        <= 12'b0;
    end
    else
    begin
      s1_i_x_gcos <= n_s1_i_x_gcos_fix[21:8];
      s1_i_x_gsin <= n_s1_i_x_gsin_fix[21:8];
      s1_q        <= s0_q;
    end
  end
  /*****************************************************************************
  * S2: apply compensation and output
  *****************************************************************************/
  wire [13:0] n_s2_i_presat,n_s2_q_presat;
  reg  [11:0] n_s2_i,n_s2_q;
  
  assign  n_s2_i_presat = s1_i_x_gcos;
  assign  n_s2_q_presat = {s1_q[11],s1_q[11],s1_q} + s1_i_x_gsin;
  
  always @(*)
  begin
    
    if(n_s2_i_presat[13:11]==3'b000 || n_s2_i_presat[13:11]==3'b111)
    begin
      n_s2_i = n_s2_i_presat[11:0];
    end
    else
    begin
      n_s2_i = {n_s2_i_presat[13],{11{~n_s2_i_presat[13]}}};
    end
    
    if(n_s2_q_presat[13:11]==3'b000 || n_s2_q_presat[13:11]==3'b111)
    begin
      n_s2_q = n_s2_q_presat[11:0];
    end
    else
    begin
      n_s2_q = {n_s2_q_presat[13],{11{~n_s2_q_presat[13]}}};
    end
  
  end

  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      out_i   <= 12'b0;
      out_q   <= 12'b0;
    end
    else
    begin
      out_i   <= n_s2_i;
      out_q   <= n_s2_q;
    end
  end

endmodule
`default_nettype wire
