//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of karst_chan_if module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: https://oringot@svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_KARST_IP/HW/SB/rw_nx_fpga_b_karst/verilog/rtl/karst_chan_if.v $
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none
module karst_if 
( 
//    input wire  XO_CLKP,//for test
//    input wire  XO_CLKN,//fo
  ///////////////////////////////////////////////
  //$port_g resets
  ///////////////////////////////////////////////
  output wire [1:0]        debug_dco_clk,
//  output wire              debug_fe_clk,
  output wire              dco_adc1_locked,
  output wire              dco_adc0_locked,
  output wire              karst_dac1_clk,
  output wire              karst_dac0_clk,

  input  wire                   fe_rst_n,
  
  ///////////////////////////////////////////////
  //$port_g clocks
  ///////////////////////////////////////////////
  input  wire                   fe_clk, 

  ///////////////////////////////////////////////
  //$port_g register bank
  ///////////////////////////////////////////////
  /* force rf control interface */
  input  wire [15:0]            regb_rf_force_en,
  input  wire [15:0]            regb_rf_force,
  input  wire [ 7:0]            regb_gpio,
  
  /* alternate rf spi controller */
  input  wire                   regb_spi_start,
  output reg                    regb_spi_done,
  input  wire [ 3:0]            regb_spi_prescaler,
  input  wire                   regb_spi_we,
  input  wire [ 9:0]            regb_spi_addr,
  output reg  [15:0]            regb_spi_rdata,
  input  wire [15:0]            regb_spi_wdata,
 
  /* adc/dac io delays */
  input  wire                   regb_iodelay_start,
  output reg                    regb_iodelay_done,
  input  wire [ 4:0]            regb_iodelay_dac0,
  input  wire [ 4:0]            regb_iodelay_dac1,
  input  wire [ 4:0]            regb_iodelay_adc0,
  input  wire [ 4:0]            regb_iodelay_adc1,
  
  ///////////////////////////////////////////////
  //$port_g Karst interface
  ///////////////////////////////////////////////
  /* DAUGTER BOARD CONTROL */
  output wire                   karst_rf_resetn,  
  output wire  [7:0]            karst_rf_gpio,      
  output wire                   karst_rf_agcfreeze, 
  output wire                   karst_rf_tmode,     
 
  output wire                   karst_trsw0,  
  output wire                   karst_trsw1,  
  output wire                   karst_2g_pa0, 
  output wire                   karst_2g_pa1, 
  output wire                   karst_5g_pa0, 
  output wire                   karst_5g_pa1, 
 
  output wire                   karst_rf_spi_csn,
  output wire                   karst_rf_spi_clk,
  input  wire                   karst_rf_spi_miso,
  output wire                   karst_rf_spi_mosi,
 
  /* CH0 ADC */
  output wire                   karst_adc0_clk_p,
  output wire                   karst_adc0_clk_n,
  input  wire                   karst_adc0_dco_p,
  input  wire                   karst_adc0_dco_n,
  input  wire [11:0]            karst_adc0_p,
  input  wire [11:0]            karst_adc0_n,
  /* CH0 DAC */
  output wire                   karst_dac0_clk_p,    
  output wire                   karst_dac0_clk_n,    
  output wire                   karst_dac0_dci_p, 
  output wire                   karst_dac0_dci_n,
  output wire [11:0]            karst_dac0_p,
  output wire [11:0]            karst_dac0_n,
  /* CH1 ADC */
  output wire                   karst_adc1_clk_p,
  output wire                   karst_adc1_clk_n,
  input  wire                   karst_adc1_dco_p,
  input  wire                   karst_adc1_dco_n,
  input  wire [11:0]            karst_adc1_p,
  input  wire [11:0]            karst_adc1_n,
  /* CH1 DAC */
  output wire                   karst_dac1_clk_p,    
  output wire                   karst_dac1_clk_n,    
  output wire                   karst_dac1_dci_p, 
  output wire                   karst_dac1_dci_n,
  output wire [11:0]            karst_dac1_p,
  output wire [11:0]            karst_dac1_n,
  ///////////////////////////////////////////////
  //$port_g Phy Interface
  ///////////////////////////////////////////////
  /* DAUGTER BOARD CONTROL */
  input  wire                   rf_spi_csn,
  input  wire                   rf_spi_clk,
  input wire                    rf_spi_mosi,
  output  wire                  rf_spi_miso,
  
  input  wire                   rf_resetn,  
  input  wire [ 7:0]            rf_gpio,      
  input  wire                   rf_agcfreeze, 
  input  wire                   rf_tmode,     
  input  wire                   rf_trsw0,
  input  wire                   rf_trsw1,
  input  wire                   rf_2g_pa0,
  input  wire                   rf_2g_pa1,
  input  wire                   rf_5g_pa0,
  input  wire                   rf_5g_pa1,
  /* CH0 RX */
  input  wire                   dac0_on,
  input  wire [11:0]            dac0_i,
  input  wire [11:0]            dac0_q,
  /* CH0 RX */
  input  wire                   adc0_on,
  output reg  [11:0]            adc0_i,
  output reg  [11:0]            adc0_q,
  /* CH1 RX */
  input  wire                   dac1_on,
  input  wire [11:0]            dac1_i,
  input  wire [11:0]            dac1_q,
  /* CH1 TX */
  input  wire                   adc1_on,
  output reg  [11:0]            adc1_i,
  output reg  [11:0]            adc1_q
);
  /*****************************************************************************
  * declaration
  *****************************************************************************/
  reg [11:0] dac0_i_1t,dac0_q_1t,dac0_i_2t,dac0_q_2t;
  reg [11:0] dac1_i_1t,dac1_q_1t,dac1_i_2t,dac1_q_2t;
  reg [15:0] dac0_flush,dac1_flush;
  reg        dac0_clk_on,dac1_clk_on;
  reg        dac0_clk_d1,dac0_clk_d2,dac1_clk_d1,dac1_clk_d2;
  reg [8:0]  dac0_steady_counter,dac1_steady_counter;

  /*****************************************************************************
  * delay programmation
  *****************************************************************************/
  reg        regb_iodelay_start_1t,regb_iodelay_start_2t,regb_iodelay_start_3t;
  reg        iodelay_update,iodelay_update_1t;
  
  reg [ 4:0] iodelay_adc0,iodelay_adc0_1t;
  reg [ 4:0] iodelay_dac0,iodelay_dac0_1t;
  reg [ 4:0] iodelay_adc1,iodelay_adc1_1t;
  reg [ 4:0] iodelay_dac1,iodelay_dac1_1t;
  
    wire    karst_dac0_clk_predel,karst_dac1_clk_predel;

  
  always @(posedge fe_clk,negedge fe_rst_n)
    if(!fe_rst_n)
    begin
      regb_iodelay_start_1t <= 1'b0;         
      regb_iodelay_start_2t <= 1'b0;     
      regb_iodelay_start_3t <= 1'b0;     
      regb_iodelay_done     <= 1'b0;     
      iodelay_update        <= 1'b0;     
      iodelay_adc0          <= 5'b0; 
      iodelay_dac0          <= 5'b0;   
      iodelay_adc1          <= 5'b0;   
      iodelay_dac1          <= 5'b0;       
      iodelay_update_1t     <= 1'b0;     
      iodelay_adc0_1t       <= 5'b0; 
      iodelay_dac0_1t       <= 5'b0;   
      iodelay_adc1_1t       <= 5'b0;   
      iodelay_dac1_1t       <= 5'b0;       
    end
    else
    begin
      regb_iodelay_start_1t <= regb_iodelay_start;         
      regb_iodelay_start_2t <= regb_iodelay_start_1t;
      regb_iodelay_start_3t <= regb_iodelay_start_2t;
      regb_iodelay_done     <= regb_iodelay_start_3t;
      
      iodelay_update_1t     <= iodelay_update;     
      iodelay_adc0_1t       <= iodelay_adc0; 
      iodelay_dac0_1t       <= iodelay_dac0;   
      iodelay_adc1_1t       <= iodelay_adc1;   
      iodelay_dac1_1t       <= iodelay_dac1;       
     
      if(regb_iodelay_start_2t && !regb_iodelay_start_3t)
      begin
        iodelay_update <= 1'b1;
        iodelay_adc0   <= regb_iodelay_adc0;
        iodelay_dac0   <= regb_iodelay_dac0;
        iodelay_adc1   <= regb_iodelay_adc1;
        iodelay_dac1   <= regb_iodelay_dac1;
      end
      else
        iodelay_update <= 1'b0;
   
   end
  
  /*****************************************************************************
  * datapath
  *****************************************************************************/
  /* re-pipeline */                                                                                         
  always @(posedge fe_clk,negedge fe_rst_n)                                                                                
  begin   
    if(!fe_rst_n)
    begin
      dac0_i_2t           <= 12'b0;    
      dac0_q_2t           <= 12'b0;     
      dac0_i_1t           <= 12'b0;     
      dac0_q_1t           <= 12'b0;     
      dac0_flush          <= 16'b0; 
      dac0_clk_on         <= 1'b0; 
      dac0_clk_d1         <= 1'b0; 
      dac0_clk_d2         <= 1'b0; 
      dac0_steady_counter <= 9'd0;
      dac1_i_1t           <= 12'b0;  
      dac1_q_1t           <= 12'b0;  
      dac1_i_2t           <= 12'b0;  
      dac1_q_2t           <= 12'b0;  
      dac1_flush          <= 16'b0; 
      dac1_clk_on         <= 1'b0; 
      dac1_clk_d1         <= 1'b0; 
      dac1_clk_d2         <= 1'b0; 
      dac1_steady_counter <= 9'd0;
    end
    else
    begin                                                                                                  
      /* pipeline */
      dac0_i_2t <= dac0_i_1t;                                            
      dac0_q_2t <= dac0_q_1t;                                            
      dac1_i_2t <= dac1_i_1t;                                            
      dac1_q_2t <= dac1_q_1t;                                            
      /* keep  few cycles away from modem */
      if(dac0_on)                                                  
      begin                                                                                   
        dac0_i_1t <= dac0_i;                                            
        dac0_q_1t <= dac0_q;
      end                                                                  
      else                                                                                                  
      begin                                                                                   
        dac0_i_1t  <= 12'b0;                                                
        dac0_q_1t  <= 12'b0;                                                
      end                                                                  
    
      if(dac1_on)                                                  
      begin                                                                                   
        dac1_i_1t  <= dac1_i;                                            
        dac1_q_1t  <= dac1_q;
      end                                                                  
      else                                                                                                  
      begin                                                                                   
        dac1_i_1t  <= 12'b0;                                                
        dac1_q_1t  <= 12'b0;                                                
      end                                                                  
                                                                                                            
      /* flush tx data path up to converter, 16 cycles would be enough */ 
      dac0_flush  <= {dac0_on,dac0_flush[15:1]};
      if(|dac0_flush)
      begin
         /* running clock */
        dac0_clk_on         <= 1'b1;
        dac0_clk_d1         <= 1'b1;
        dac0_clk_d2         <= 1'b0;
        dac0_steady_counter <= 9'd0;
      end
      else
      begin
        /* slow toggling, prevents CACTUS DAC clock AC coupling problem */
        dac0_clk_on <= 1'b0;
        /* keep d1 and d2 to the same level, changing every fe/32 */
        dac0_steady_counter <= dac0_steady_counter + 9'd1;
        if(dac0_steady_counter==9'd0)
          {dac0_clk_d1,dac0_clk_d2} <= {2{~dac0_clk_d1}};
      end
      
      dac1_flush  <= {dac1_on,dac1_flush[15:1]};
      if(|dac1_flush)
      begin
        dac1_clk_on         <= 1'b1;
        dac1_clk_d1         <= 1'b1;
        dac1_clk_d2         <= 1'b0;
        dac1_steady_counter <= 9'd0;
      end
      else
      begin
        /* slow toggling, prevents CACTUS DAC clock AC coupling problem */
        dac1_clk_on <= 1'b0;
        /* keep d1 and d2 to the same level, changing every fe/32 */
        dac1_steady_counter <= dac1_steady_counter + 9'd1;
        if(dac1_steady_counter==9'd0)
          {dac1_clk_d1,dac1_clk_d2} <= {2{~dac1_clk_d1}};
      end
    end
  end                                                                                                       
  
  /*****************************************************************************
  * DAC clk
  *****************************************************************************/

  ODDR 
  #(
    .DDR_CLK_EDGE( "SAME_EDGE"),    
    .INIT(         1'b0),           
    .SRTYPE(       "SYNC")          
  ) 
  u_odddr_ch0_karst_tx_clk 
  (
    .Q(            karst_dac0_clk_predel),          
    .C(            fe_clk),               
    .CE(           1'b1), 
    .D1(           dac0_clk_d1),        
    .D2(           dac0_clk_d2),       
    .R(            1'b0),                   
    .S(            1'b0)                    
  );
 
  ODDR 
  #(
    .DDR_CLK_EDGE( "SAME_EDGE"),    
    .INIT(         1'b0),           
    .SRTYPE(       "SYNC")          
  ) 
  u_odddr_ch1_karst_tx_clk 
  (
    .Q(            karst_dac1_clk_predel),          
    .C(            fe_clk),               
    .CE(           1'b1), 
    .D1(           dac1_clk_d1),        
    .D2(           dac1_clk_d2),       
    .R(            1'b0),                   
    .S(            1'b0)                    
  );
  
  /* note: 32 tap, one tap has a delay of 1/(32*2*Fref) = 78.125 ps */
  /*       maximum possible delay is 2.5 ns                         */
/* 
(* IODELAY_GROUP = "IODELAY_KARST" *) IODELAYE1
  #(
    .IDELAY_TYPE(           "DEFAULT"),
    .ODELAY_TYPE(           "VAR_LOADABLE"),
    .DELAY_SRC(             "O"),
    .IDELAY_VALUE(          0.0),
    .ODELAY_VALUE(          0.0),
    .HIGH_PERFORMANCE_MODE( "FALSE"),
    .SIGNAL_PATTERN(        "DATA"),
    .REFCLK_FREQUENCY(      200.0),
    .CINVCTRL_SEL(          "FALSE")
  )
  u_iodelay_karst_dac0_clk 
  (
    .RST(                   iodelay_update_1t),
    .C(                     fe_clk),
    .CE(                    1'b0),
    .CINVCTRL(              1'b0),
    .INC(                   1'b0),
    .CNTVALUEIN(            iodelay_dac0_1t),
    .CNTVALUEOUT(           ),
    .T(                     1'b0),
    .CLKIN(                 1'b0),
    .IDATAIN(               1'b0),
    .ODATAIN(               karst_dac0_clk_predel),
    .DATAIN(                1'b0),
    .DATAOUT(               karst_dac0_clk)
  );

(* IODELAY_GROUP = "IODELAY_KARST" *) IODELAYE1
  #(
    .IDELAY_TYPE(           "DEFAULT"),
    .ODELAY_TYPE(           "VAR_LOADABLE"),
    .DELAY_SRC(             "O"),
    .IDELAY_VALUE(          0.0),
    .ODELAY_VALUE(          0.0),
    .HIGH_PERFORMANCE_MODE( "FALSE"),
    .SIGNAL_PATTERN(        "DATA"),
    .REFCLK_FREQUENCY(      200.0),
    .CINVCTRL_SEL(          "FALSE")
  )
  u_iodelay_karst_dac1_clk 
  (
    .RST(                   iodelay_update_1t),
    .C(                     fe_clk),
    .CE(                    1'b0),
    .CINVCTRL(              1'b0),
    .INC(                   1'b0),
    .CNTVALUEIN(            iodelay_dac1_1t),
    .CNTVALUEOUT(           ),
    .T(                     1'b0),
    .CLKIN(                 1'b0),
    .IDATAIN(               1'b0),
    .ODATAIN(               karst_dac1_clk_predel),
    .DATAIN(                1'b0),
    .DATAOUT(               karst_dac1_clk)
  );
*/

  assign karst_dac0_clk = 1'b0;
  assign karst_dac1_clk = 1'b0;
  
  OBUFDS
  #(
    .IOSTANDARD (  "LVDS")
  ) 
  u_obufds_karst_dac0_clk
  (
    .I(            karst_dac0_clk_predel/*karst_dac0_clk*/),
    .O(            karst_dac0_clk_p),
    .OB(           karst_dac0_clk_n)
  );    
 
  OBUFDS
  #(
    .IOSTANDARD (  "LVDS")
  ) 
  u_obufds_karst_dac1_clk
  (
    .I(            karst_dac1_clk_predel/*karst_dac1_clk*/),
    .O(            karst_dac1_clk_p),
    .OB(           karst_dac1_clk_n)
  );    
   
  /*****************************************************************************
  * DAC I/Q selection (dci)  
  *****************************************************************************/
  wire    karst_dac0_dci,karst_dac1_dci;
  ODDR 
  #(
    .DDR_CLK_EDGE( "SAME_EDGE"),    
    .INIT(         1'b0),           
    .SRTYPE(       "SYNC")          
  ) 
  u_odddr_karst_dac0_dci 
  (
    .Q(            karst_dac0_dci),          
    .C(            fe_clk),               
    .CE(           1'b1), 
    .D1(           dac0_clk_on),        
    .D2(           1'b0),       
    .R(            1'b0),                   
    .S(            1'b0)                    
  );

  ODDR 
  #(
    .DDR_CLK_EDGE( "SAME_EDGE"),    
    .INIT(         1'b0),           
    .SRTYPE(       "SYNC")          
  ) 
  u_odddr_karst_dac1_dci 
  (
    .Q(            karst_dac1_dci),          
    .C(            fe_clk),               
    .CE(           1'b1), 
    .D1(           dac1_clk_on),        
    .D2(           1'b0),       
    .R(            1'b0),                   
    .S(            1'b0)                    
  );
  
  OBUFDS
  #(
    .IOSTANDARD( "LVDS")
  ) 
  u_obufds_karst_dac0_dci
  (
    .I(            karst_dac0_dci),
    .O(            karst_dac0_dci_p),
    .OB(           karst_dac0_dci_n)
  );    

  OBUFDS
  #(
    .IOSTANDARD( "LVDS")
  ) 
  u_obufds_karst_dac1_dci
  (
    .I(            karst_dac1_dci),
    .O(            karst_dac1_dci_p),
    .OB(           karst_dac1_dci_n)
  );    

  /*****************************************************************************
  * DAC I/Q data 
  *****************************************************************************/
  wire  [11:0]  karst_dac0,karst_dac1;
  
  generate
  begin:g_dac_pads
    genvar i; 
    for(i=0;i<12;i=i+1)                                                       
    begin:u_obufds_oddr_karst_tx                                                          

      ODDR 
      #(                                                                 
        .DDR_CLK_EDGE(  "SAME_EDGE"),   
        .INIT(          1'b0),          
        .SRTYPE(        "SYNC")        
      ) 
      u_oddr_ch0_tx
      (                                                           
        .Q(             karst_dac0[i]),      
        .C(             fe_clk),           
        .CE(            1'b1), 
        .D1(            dac0_i_2t[i]),     
        .D2(            dac0_q_2t[i]),     
        .R(             1'b0),             
        .S(             1'b0)              
      );   
     
      ODDR 
      #(                                                                 
        .DDR_CLK_EDGE(  "SAME_EDGE"),   
        .INIT(          1'b0),          
        .SRTYPE(        "SYNC")        
      ) 
      u_oddr_ch1_tx 
      (                                                           
        .Q(             karst_dac1[i]),      
        .C(             fe_clk),           
        .CE(            1'b1), 
        .D1(            dac1_i_2t[i]),     
        .D2(            dac1_q_2t[i]),     
        .R(             1'b0),             
        .S(             1'b0) 
      );   
     
      OBUFDS                                                                  
      #(                                                                      
        .IOSTANDARD(   "LVDS")                                             
      ) 
      u_obufds_ch0_tx                                                           
      (                                                                       
        .I(            karst_dac0[i]),                                               
        .O(            karst_dac0_p[i]),                                             
        .OB(           karst_dac0_n[i])                                              
      );                                                                      

      OBUFDS                                                                  
      #(                                                                      
        .IOSTANDARD(   "LVDS")                                             
      ) 
      u_obufds_ch1_tx                                                           
      (                                                                       
        .I(            karst_dac1[i]),                                               
        .O(            karst_dac1_p[i]),                                             
        .OB(           karst_dac1_n[i])                                              
      ); 
                                                                           
    end 
  end                                                                      
  endgenerate

  /*****************************************************************************
  * ADC clock
  *****************************************************************************/
  wire    karst_adc0_clk,karst_adc1_clk;

  ODDR 
  #(
    .DDR_CLK_EDGE(    "SAME_EDGE"),    
    .INIT(            1'b0),           
    .SRTYPE(          "SYNC")          
  ) 
  u_odddr_karst_adc0_clk 
  (
    .Q(               karst_adc0_clk),       
    .C(               fe_clk),            
    .CE(              1'b1), 
    .D1(              1'b1),       
    .D2(              1'b0),       
    .R(               1'b0),                
    .S(               1'b0)                 
  );

  ODDR 
  #(
    .DDR_CLK_EDGE(    "SAME_EDGE"),    
    .INIT(            1'b0),           
    .SRTYPE(          "SYNC")          
  ) 
  u_odddr_karst_adc1_clk 
  (
    .Q(               karst_adc1_clk),       
    .C(               fe_clk),            
    .CE(              1'b1), 
    .D1(              1'b1),       
    .D2(              1'b0),       
    .R(               1'b0),                
    .S(               1'b0)                 
  );

  OBUFDS
  #(
    .IOSTANDARD(      "LVDS")
  ) 
  u_obufds_karst_adc0_clk
  (
    .I(               karst_adc0_clk),
    .O(               karst_adc0_clk_p),
    .OB(              karst_adc0_clk_n)
  );    

  OBUFDS
  #(
    .IOSTANDARD(      "LVDS")
  ) 
  u_obufds_karst_adc1_clk
  (
    .I(               karst_adc1_clk),
    .O(               karst_adc1_clk_p),
    .OB(              karst_adc1_clk_n)
  );    

  /*****************************************************************************
  * ADC returned cloc
  *****************************************************************************/
  wire    karst_adc0_dco_prebufg;
  wire    karst_adc1_dco_prebufg;
  /* for flops */
  wire    karst_adc0_dco_clk   /* synthesis syn_keep = 1 */;
  wire    karst_adc1_dco_clk   /* synthesis syn_keep = 1 */;
  /* for ddr pads */
  //wire    karst_adc0_dco_clkio /* synthesis syn_keep = 1 */;
  //wire    karst_adc1_dco_clkio /* synthesis syn_keep = 1 */;

  IBUFGDS
  #(
    .DIFF_TERM(       "TRUE"),
    .IOSTANDARD(      "LVDS")
  )
  u_ibufgds_karst_adc0_dco
  (
    .I(               karst_adc0_dco_p),
    .IB(              karst_adc0_dco_n),
    .O(               karst_adc0_dco_prebufg)
  );

  IBUFGDS
  #(
    .DIFF_TERM(       "TRUE"),
    .IOSTANDARD(      "LVDS")
  )
  u_ibufgds_karst_adc1_dco
  (
    .I(               karst_adc1_dco_p),
    .IB(              karst_adc1_dco_n),
    .O(               karst_adc1_dco_prebufg)
  );

  BUFG u_bufr_karst_adc0_dco  
  (
    .I(               karst_adc0_dco_prebufg),
    .O(               karst_adc0_dco_clk)
  );

  BUFG u_bufr_karst_adc1_dco
  (
    .I(               karst_adc1_dco_prebufg),
    .O(               karst_adc1_dco_clk)
  );

/*
 dco_mmcm dco_mmcm_adc0
 (
 // Clock in ports
  .clk_in1_p(karst_adc0_dco_p),
  .clk_in1_n(karst_adc0_dco_n),
  // Clock out ports
  .clk_out1(karst_adc0_dco_clk),
  // Status and control signals
  .locked(dco_adc0_locked)
 );
 
  dco_mmcm dco_mmcm_adc1
 (
 // Clock in ports
  .clk_in1_p(karst_adc1_dco_p),
  .clk_in1_n(karst_adc1_dco_n),
  // Clock out ports
  .clk_out1(karst_adc1_dco_clk),
  // Status and control signals
  .locked(dco_adc1_locked)
 );
*/
  
  assign dco_adc1_locked = 1'b0;
  assign dco_adc0_locked = 1'b0;
  
  /*****************************************************************************
  * ADC data 
  *****************************************************************************/
  wire [11:0]   karst_adc0_predel,karst_adc1_predel;
  (* keep = "true" *) wire [11:0]   karst_adc0,karst_adc1;
  (* keep = "true" *) wire [11:0]   karst_adc0_i,karst_adc1_i;
  (* keep = "true" *) wire [11:0]   karst_adc0_q,karst_adc1_q;

  generate
  begin
    genvar i; 
    for(i=0;i<12;i=i+1) 
    begin:u_ibufds_uodelay_iddr_karst_rx  
      IBUFDS                                   
      #(                                       
        .DIFF_TERM(             "TRUE"),                   
        .IOSTANDARD(            "LVDS")                 
      ) 
      u_ibufds_karst_adc0                                    
      (                                                
        .I(                     karst_adc0_p[i]),        
        .IB(                    karst_adc0_n[i]),        
        .O(                     karst_adc0_predel[i])               
      );

      IBUFDS                                   
      #(                                       
        .DIFF_TERM(             "TRUE"),                   
        .IOSTANDARD(            "LVDS")                 
      ) 
      u_ibufds_karst_adc1                                    
      (                                                
        .I(                     karst_adc1_p[i]),        
        .IB(                    karst_adc1_n[i]),        
        .O(                     karst_adc1_predel[i])               
      );


(* IODELAY_GROUP = "IODELAY_KARST" *) IODELAYE1
      #(
        .IDELAY_TYPE(           "VAR_LOADABLE"),
        .ODELAY_TYPE(           "FIXED"),
        .DELAY_SRC(             "I"),
        .IDELAY_VALUE(          0.0),
        .ODELAY_VALUE(          0.0),
        .HIGH_PERFORMANCE_MODE( "FALSE"),
        .SIGNAL_PATTERN(        "DATA"),
        .REFCLK_FREQUENCY(      200.0),
        .CINVCTRL_SEL(          "FALSE")
      )
      u_iodelay_karst_adc0 
      (
        .RST(                   iodelay_update_1t),
        .C(                     fe_clk),
        .CE(                    1'b0),
        .CINVCTRL(              1'b0),
        .INC(                   1'b0),
        .CNTVALUEIN(            iodelay_adc0_1t),
        .CNTVALUEOUT(           ),
        .T(                     1'b0),
        .CLKIN(                 1'b0),
        .IDATAIN(               karst_adc0_predel[i]),
        .ODATAIN(               1'b0),
        .DATAIN(                1'b0),
        .DATAOUT(               karst_adc0[i])
      );

//assign       karst_adc0[i] = karst_adc0_predel[i];


(* IODELAY_GROUP = "IODELAY_KARST" *) IODELAYE1
      #(
        .IDELAY_TYPE(           "VAR_LOADABLE"),
        .ODELAY_TYPE(           "FIXED"),
        .DELAY_SRC(             "I"),
        .IDELAY_VALUE(          0.0),
        .ODELAY_VALUE(          0.0),
        .HIGH_PERFORMANCE_MODE( "FALSE"),
        .SIGNAL_PATTERN(        "DATA"),
        .REFCLK_FREQUENCY(      200.0),
        .CINVCTRL_SEL(          "FALSE")
      )
      u_iodelay_karst_adc1 
      (
        .RST(                   iodelay_update_1t),
        .C(                     fe_clk),
        .CE(                    1'b0),
        .CINVCTRL(              1'b0),
        .INC(                   1'b0),
        .CNTVALUEIN(            iodelay_adc1_1t),
        .CNTVALUEOUT(           ),
        .T(                     1'b0),
        .CLKIN(                 1'b0),
        .IDATAIN(               karst_adc1_predel[i]),
        .ODATAIN(               1'b0),
        .DATAIN(                1'b0),
        .DATAOUT(               karst_adc1[i])
      );


//assign       karst_adc1[i] =  karst_adc1_predel[i];
      /*
      * VERY IMPORTANT: 
      *  
      *  1) the karst ADCs display I(k) on the DCO high level and 
      *     Q(k) on the DCO low level where k is the sample index.
      *
      *  2) because we delay the data (with IODELAY) for maximizing the 
      *     sampling window, the DCO rising edge samples Q(k-1) and
      *     and the DCO falling edge samples I(k).
      *
      *  3) the onle cycle delay on the k pair is compensated
      *      with the SAME_EDGE attribute (cf Xilinx UG361 SelectIO ressources),
      *      Q(k) being displayed on Q1 and I(k) being displayed on Q2
      */
      IDDR 
      #(
        .DDR_CLK_EDGE(          "SAME_EDGE"),
        .INIT_Q1(               0),
        .INIT_Q2(               0)
      ) 
      u_iddr_karst_adc0
      (
       .C(                      /*fe_clk*/karst_adc0_dco_clk),     
       .R(                      1'b0),        
       .S(                      1'b0),        
       .D(                      karst_adc0[i]),     
       .CE(                     1'b1),   
       .Q1(                     karst_adc0_q[i]),   
       .Q2(                     karst_adc0_i[i])    
      ); 
     
      IDDR 
      #(
        .DDR_CLK_EDGE(          "SAME_EDGE"),
        .INIT_Q1(               0),
        .INIT_Q2(               0)
      ) 
      u_iddr_karst_adc1
      (
       .C(                      /*fe_clk*/karst_adc1_dco_clk),     
       .R(                      1'b0),        
       .S(                      1'b0),        
       .D(                      karst_adc1[i]),     
       .CE(                     1'b1),   
       .Q1(                     karst_adc1_q[i]),   
       .Q2(                     karst_adc1_i[i])    
      ); 
    end
  end                                        
  endgenerate
  
  /*****************************************************************************
  * resynchronize ADC data from ADC clock domain to FE clock domain
  *****************************************************************************/
  /* synchronize ch0 and ch1 
  *
  *  
  *
  */
  reg [15:0] adc0_on_rs,adc1_on_rs;
  reg        adc0_run,adc1_run;
  
  always @(negedge karst_adc0_dco_clk,negedge fe_rst_n)
  begin
    if(!fe_rst_n)
    begin
      adc0_on_rs <= 16'b0;
      adc1_on_rs <= 16'b0;
      adc0_run   <= 1'b0;
      adc1_run   <= 1'b0; 
    end
    else
    begin
      /* we use adc0_on, adc1_on to align both paths
      *  so they shall be considered as a vector.
      *  since they may come from any clock domain, we
      *  resynchronize this vector.
      *  
      *  coalescing resynchronization method
      */ 
      adc0_on_rs <= {adc0_on,adc0_on_rs[15:1]}; // [15:14] is the resync cell
      adc1_on_rs <= {adc1_on,adc1_on_rs[15:1]};
      if( (adc0_on_rs[13:0]==14'h0 || adc0_on_rs[13:0]==14'h3fff) &&
          (adc1_on_rs[13:0]==14'h0 || adc1_on_rs[13:0]==14'h3fff))
      begin
        adc0_run <= adc0_on_rs[0];
        adc1_run <= adc1_on_rs[0];
      end
    end
  end
  
  reg        adc0_run_1t;
  reg [2:0]  ch0_wrptr;
  reg        ch0_e0_valid;
  reg [11:0] ch0_e0_i,ch0_e1_i,ch0_e2_i,ch0_e3_i,ch0_e4_i,ch0_e5_i;
  reg [11:0] ch0_e0_q,ch0_e1_q,ch0_e2_q,ch0_e3_q,ch0_e4_q,ch0_e5_q;
  
  always @(posedge karst_adc0_dco_clk,negedge fe_rst_n)
  begin
    if(!fe_rst_n)
    begin
      adc0_run_1t <= 1'b0;
      ch0_wrptr   <= 3'd0;
      {ch0_e0_valid,ch0_e0_i,ch0_e0_q} <= {1'b0,12'b0,12'b0};  
      {ch0_e1_i,ch0_e1_q}              <= {12'b0,12'b0};  
      {ch0_e2_i,ch0_e2_q}              <= {12'b0,12'b0};  
      {ch0_e3_i,ch0_e3_q}              <= {12'b0,12'b0};  
      {ch0_e4_i,ch0_e4_q}              <= {12'b0,12'b0};  
      {ch0_e5_i,ch0_e5_q}              <= {12'b0,12'b0};  
    end
    else
    begin
      adc0_run_1t <= adc0_run;
      if(!adc0_run_1t)
      begin
        ch0_wrptr <= 3'd0;
        {ch0_e0_valid,ch0_e0_i,ch0_e0_q} <= {1'b0,12'b0,12'b0};
        {ch0_e1_i,ch0_e1_q}              <= {12'b0,12'b0};
        {ch0_e2_i,ch0_e2_q}              <= {12'b0,12'b0};
        {ch0_e3_i,ch0_e3_q}              <= {12'b0,12'b0};
        {ch0_e4_i,ch0_e4_q}              <= {12'b0,12'b0};
        {ch0_e5_i,ch0_e5_q}              <= {12'b0,12'b0};
      end
      else
      begin
        case(ch0_wrptr)                              
          3'd0:    {ch0_wrptr,ch0_e0_valid,ch0_e0_i,ch0_e0_q} <= {3'd1,1'b1,karst_adc0_i,karst_adc0_q};    
          3'd1:    {ch0_wrptr,ch0_e1_i,ch0_e1_q}              <= {3'd2,     karst_adc0_i,karst_adc0_q}; 
          3'd2:    {ch0_wrptr,ch0_e2_i,ch0_e2_q}              <= {3'd3,     karst_adc0_i,karst_adc0_q}; 
          3'd3:    {ch0_wrptr,ch0_e3_i,ch0_e3_q}              <= {3'd4,     karst_adc0_i,karst_adc0_q}; 
          3'd4:    {ch0_wrptr,ch0_e4_i,ch0_e4_q}              <= {3'd5,     karst_adc0_i,karst_adc0_q}; 
          default: {ch0_wrptr,ch0_e5_i,ch0_e5_q}              <= {3'd0,     karst_adc0_i,karst_adc0_q}; 
        endcase
      end
    end
  end
  
  /* wr ch1 */
  reg        adc1_run_1t;
  reg [2:0]  ch1_wrptr;
  reg        ch1_e0_valid;
  reg [11:0] ch1_e0_i,ch1_e1_i,ch1_e2_i,ch1_e3_i,ch1_e4_i,ch1_e5_i;
  reg [11:0] ch1_e0_q,ch1_e1_q,ch1_e2_q,ch1_e3_q,ch1_e4_q,ch1_e5_q;
 
  always @(posedge karst_adc1_dco_clk,negedge fe_rst_n)
  begin
    if(!fe_rst_n)
    begin
      adc1_run_1t <= 1'b0;
      ch1_wrptr   <= 3'd0;
      {ch1_e0_valid,ch1_e0_i,ch1_e0_q} <= {1'b0,12'b0,12'b0};
      {ch1_e1_i,ch1_e1_q}              <= {     12'b0,12'b0};
      {ch1_e2_i,ch1_e2_q}              <= {     12'b0,12'b0};
      {ch1_e3_i,ch1_e3_q}              <= {     12'b0,12'b0};
      {ch1_e4_i,ch1_e4_q}              <= {     12'b0,12'b0};
      {ch1_e5_i,ch1_e5_q}              <= {     12'b0,12'b0};
    end
    else
    begin
      adc1_run_1t <= adc1_run;
      if(!adc1_run_1t)
      begin
        ch1_wrptr <= 3'd0;
        {ch1_e0_valid,ch1_e0_i,ch1_e0_q} <= {1'b0,12'b0,12'b0};
        {ch1_e1_i,ch1_e1_q}              <= {     12'b0,12'b0};
        {ch1_e2_i,ch1_e2_q}              <= {     12'b0,12'b0};
        {ch1_e3_i,ch1_e3_q}              <= {     12'b0,12'b0};
        {ch1_e4_i,ch1_e4_q}              <= {     12'b0,12'b0};
        {ch1_e5_i,ch1_e5_q}              <= {     12'b0,12'b0};
      end
      else
      begin
        case(ch1_wrptr)                              
          3'd0:    {ch1_wrptr,ch1_e0_valid,ch1_e0_i,ch1_e0_q} <= {3'd1,1'b1,karst_adc1_i,karst_adc1_q};    
          3'd1:    {ch1_wrptr,ch1_e1_i,ch1_e1_q}              <= {3'd2,     karst_adc1_i,karst_adc1_q};    
          3'd2:    {ch1_wrptr,ch1_e2_i,ch1_e2_q}              <= {3'd3,     karst_adc1_i,karst_adc1_q};    
          3'd3:    {ch1_wrptr,ch1_e3_i,ch1_e3_q}              <= {3'd4,     karst_adc1_i,karst_adc1_q};    
          3'd4:    {ch1_wrptr,ch1_e4_i,ch1_e4_q}              <= {3'd5,     karst_adc1_i,karst_adc1_q};    
          default: {ch1_wrptr,ch1_e5_i,ch1_e5_q}              <= {3'd0,     karst_adc1_i,karst_adc1_q};    
        endcase
      end
    end
  end
  
  reg        ch_valid_1t,ch_valid_2t;
  reg [ 2:0] ch_rdptr;
  
  always @(posedge fe_clk or negedge fe_rst_n)
  begin  
    if(!fe_rst_n)
    begin
      ch_valid_1t                            <= 1'b0;
      ch_valid_2t                            <= 1'b0;
      {ch_rdptr,adc1_i,adc1_q,adc0_i,adc0_q} <= {3'd0,12'b0,12'b0,12'b0,12'b0};
    end
    else
    begin
      ch_valid_1t <= ch0_e0_valid | ch1_e0_valid;
      ch_valid_2t <= ch_valid_1t;
      if(!ch_valid_2t)
        {ch_rdptr,adc1_i,adc1_q,adc0_i,adc0_q} <= {3'd0,12'b0,12'b0,12'b0,12'b0};
      else
        case(ch_rdptr)
          3'd0:    {ch_rdptr,adc1_i,adc1_q,adc0_i,adc0_q} <= {3'd1,ch1_e0_i,ch1_e0_q,ch0_e0_i,ch0_e0_q};
          3'd1:    {ch_rdptr,adc1_i,adc1_q,adc0_i,adc0_q} <= {3'd2,ch1_e1_i,ch1_e1_q,ch0_e1_i,ch0_e1_q};
          3'd2:    {ch_rdptr,adc1_i,adc1_q,adc0_i,adc0_q} <= {3'd3,ch1_e2_i,ch1_e2_q,ch0_e2_i,ch0_e2_q};
          3'd3:    {ch_rdptr,adc1_i,adc1_q,adc0_i,adc0_q} <= {3'd4,ch1_e3_i,ch1_e3_q,ch0_e3_i,ch0_e3_q};
          3'd4:    {ch_rdptr,adc1_i,adc1_q,adc0_i,adc0_q} <= {3'd5,ch1_e4_i,ch1_e4_q,ch0_e4_i,ch0_e4_q};
          default: {ch_rdptr,adc1_i,adc1_q,adc0_i,adc0_q} <= {3'd0,ch1_e5_i,ch1_e5_q,ch0_e5_i,ch0_e5_q};
        endcase
    end
  end

  /*****************************************************************************
  * bypass
  *****************************************************************************/
  localparam    IDLE=3'd0,C0=3'd1,C1=3'd2,P0=3'd3,P1=3'd4,P2=3'd5,DONE=3'd6;
  reg [ 2:0]    state;
  reg           spi_start_1t,spi_start_2t;
  reg [ 5:0]    prescaler;
  reg [ 4:0]    count; 
  reg [25:0]    wdata;
  reg [15:0]    rdata;
  reg           spi_csn;
  reg           spi_clk;
  reg           spi_mosi;
  wire          prescaler_long_done; 
  wire          prescaler_short_done; 
  wire [ 5:0]   n_prescaler;
  wire [ 4:0]   n_count; 
  
  /*****************************************************************************
  * gpio bypass
  *****************************************************************************/
  reg         gpio_update_1t;
  reg         gpio_update_2t;
  reg         gpio_update_3t;
  reg  [ 7:0] prev_regb_gpio;
  reg  [ 7:0] gpio;
  
  always @(posedge fe_clk, negedge fe_rst_n)
    if(!fe_rst_n)
    begin
      gpio_update_1t <= 1'b0;
      gpio_update_2t <= 1'b0;
      gpio_update_3t <= 1'b0;
      prev_regb_gpio <= 8'b0;
      gpio           <= 8'b0;
    end
    else
    begin
      /* detect new value */
      gpio_update_1t <= prev_regb_gpio != regb_gpio;
      gpio_update_2t <= gpio_update_1t;
      gpio_update_3t <= gpio_update_2t;
      if(gpio_update_2t && !gpio_update_3t)
      begin
        gpio           <= {regb_gpio[7],~gpio[6],regb_gpio[5:0]};
        prev_regb_gpio <= regb_gpio;
      end
    end
      
  
  /*****************************************************************************
  * spi bypass
  *****************************************************************************/
  assign n_count              = count     + 5'd1;
  assign n_prescaler          = prescaler + 6'd1;
  assign prescaler_short_done = prescaler[3:0]==regb_spi_prescaler;
  assign prescaler_long_done  = prescaler=={2'b11,regb_spi_prescaler};
  
  always @(posedge fe_clk, negedge fe_rst_n)
    if(!fe_rst_n)
    begin
      spi_clk           <= 1'b0;    
      spi_csn           <= 1'b1;    
      spi_mosi          <= 1'b0;    
      
      spi_start_1t      <= 1'b0;    
      spi_start_2t      <= 1'b0;    
      regb_spi_rdata    <= 16'b0;    
      regb_spi_done     <= 1'b0;    
      
      rdata             <= 16'd0;    
      wdata             <= 23'd0;   
      count             <= 5'd0;    
      prescaler         <= 6'd0;    
      state             <= IDLE;    
    end
    else
    begin
      /* resynchro */
      spi_start_1t <= regb_spi_start;
      spi_start_2t <= spi_start_1t;
            
      /* FSM */
      case(state)
        IDLE:
        begin
          if(spi_start_2t)
          begin
            spi_csn   <= 1'b0;
            spi_mosi  <= regb_spi_we;
            count     <= 5'd0;
            prescaler <= 6'd0;
            rdata     <= 16'd0;
            wdata     <= {regb_spi_addr,regb_spi_wdata};
            state     <= C0;
          end
        end
        
        C0:
        begin
          if(prescaler_short_done)
          begin
            /* RISING EDGE, CAPTURE */
            spi_clk   <= 1'b1;
            rdata         <= {rdata[14:0],karst_rf_spi_miso};
            prescaler     <= 6'd0;
            state         <= C1;
          end
          else
            prescaler <= n_prescaler;
        end
        
        C1:
        begin
          if(prescaler_short_done)
          begin
            /* FALLING EDGE, CAPTURE */
            prescaler   <= 6'd0;
            count       <= n_count;
            spi_clk     <= 1'b0;
            spi_mosi    <= wdata[25];
            wdata       <= {wdata[24:0],1'b0};
            
            if(count==5'd10 && !regb_spi_we)
            begin
              /* need a pause by de-asserting csn */
              state   <= P0;
            end
            else if(count==5'd26)
            begin
              /* DONE */
              if(!regb_spi_we)
                regb_spi_rdata <= rdata;
              spi_mosi         <= 1'b0;
              state            <= DONE;
            end
            else
              state <= C0;
          end
          else
            prescaler <= n_prescaler;
        end
        
        P0:
        begin
          if(prescaler_long_done)
          begin
            spi_csn   <= 1'b1;
            prescaler <= 6'd0;
            state     <= P1;
          end
          else
            prescaler <= n_prescaler;
        end
       
        P1:
        begin
          if(prescaler_long_done)
          begin
            spi_csn   <= 1'b0;
            prescaler <= 6'd0;
            state     <= P2;
          end
          else
            prescaler <= n_prescaler;
        end
      
        P2:
        begin
          if(prescaler_long_done)
          begin
            prescaler <= 6'd0;
            state     <= C0;
          end
          else
            prescaler <= n_prescaler;
        end
        
        default: /* DONE */
        begin
          if(prescaler_short_done)
          begin
            regb_spi_done <= 1'b1;
            spi_csn          <= 1'b1;
            if(!spi_start_2t)
            begin
              regb_spi_done <= 1'b0;
              state            <= IDLE;
            end
          end
          else
            prescaler <= n_prescaler;
        end
      endcase
    end
  
  /*****************************************************************************
  * bypass mux
  *
  * [15] karst_5g_pa1
  * [14] karst_5g_pa0
  * [13] karst_2g_pa1
  * [12] karst_2g_pa0
  *
  * [11] 
  * [10] 
  * [ 9] karst_trsw1
  * [ 8] karst_trsw0
  *
  * [ 7] 
  * [ 6] 
  * [ 5] karst_rf_gpi0
  * [ 4] karst_rf_spi
  *
  * [ 3] 
  * [ 2] karst_rf_tmode
  * [ 1] karst_rf_agcfreeze
  * [ 0] karst_rf_resetn
  *
  *****************************************************************************/
  /* bypass rf and daughter board signals */
  assign karst_rf_resetn    = regb_rf_force_en[ 0] ? regb_rf_force[ 0] : rf_resetn;
  assign karst_rf_agcfreeze = regb_rf_force_en[ 1] ? regb_rf_force[ 1] : rf_agcfreeze;
  assign karst_rf_tmode     = regb_rf_force_en[ 2] ? regb_rf_force[ 2] : rf_tmode;   
  
  assign karst_trsw0        = regb_rf_force_en[ 8] ? regb_rf_force[ 8] : rf_trsw0;       
  assign karst_trsw1        = regb_rf_force_en[ 9] ? regb_rf_force[ 9] : rf_trsw1; 
        
  assign karst_2g_pa0       = regb_rf_force_en[12] ? regb_rf_force[12] : rf_2g_pa0;      
  assign karst_2g_pa1       = regb_rf_force_en[13] ? regb_rf_force[13] : rf_2g_pa1;      
  assign karst_5g_pa0       = regb_rf_force_en[14] ? regb_rf_force[14] : rf_5g_pa0;      
  assign karst_5g_pa1       = regb_rf_force_en[15] ? regb_rf_force[15] : rf_5g_pa1;      
 
  /* bypass rf_gpio */
  assign karst_rf_gpio      = regb_rf_force_en[5]  ? gpio              : rf_gpio;
 
  /* bypass spi */
  assign karst_rf_spi_csn   = regb_rf_force_en[4]  ? spi_csn           : rf_spi_csn;
  assign karst_rf_spi_clk   = regb_rf_force_en[4]  ? spi_clk           : rf_spi_clk;
  assign karst_rf_spi_mosi  = regb_rf_force_en[4]  ? spi_mosi          : rf_spi_mosi;
  assign rf_spi_miso        = karst_rf_spi_miso;
  
//reg karst_adc0_dco_reg,karst_adc1_dco_reg;
//always @(negedge karst_adc0_dco_clk)  karst_adc0_dco_reg <= ~karst_adc0_dco_reg;
//always @(negedge karst_adc1_dco_clk)  karst_adc1_dco_reg <= ~karst_adc1_dco_reg;
//
//assign debug_dco_clk ={karst_adc1_dco_reg,karst_adc0_dco_reg};
assign debug_dco_clk ={karst_adc1_dco_clk,karst_adc0_dco_clk};


endmodule
`default_nettype wire
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
