////////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//------------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//------------------------------------------------------------------------------
// $Revision: $
// $Date: $
// -----------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of rw_nx_v7 module
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// -----------------------------------------------------------------------------
//
//
////////////////////////////////////////////////////////////////////////////////
`default_nettype none

`ifndef FPGA_SVNREV_MODEM
   `define FPGA_SVNREV_MODEM 32'h0
`endif
`ifndef RW_FPGA_SVNREV
   `define RW_FPGA_SVNREV 32'h0
`endif
`ifndef RW_FPGA_SIGNATURE
   `define RW_FPGA_SIGNATURE 32'h0
`endif
`ifndef RW_FPGA_DATE
   `define RW_FPGA_DATE      32'h0
`endif


//`define FRAMEBUFFER

module rw_he_v7(
  //****************************************************************************
  //$port_g PCIe
  //****************************************************************************
  input  wire                clk_pcie_p,
  input  wire                clk_pcie_n,
  input  wire                pcie_7x_mgt_rxn,
  input  wire                pcie_7x_mgt_rxp,
  output wire                pcie_7x_mgt_txn,
  output wire                pcie_7x_mgt_txp,
  //****************************************************************************
  //$port_g Resets inputs
  //****************************************************************************
  input  wire                global_rst_n,       // Asynchronous reset (Active low)
  //****************************************************************************
  //$port_g Clocks inputs
  //****************************************************************************
  input  wire                clk_ext_25,         // On board oscillator
  //****************************************************************************
  //$port_g KARST Interface
  //****************************************************************************
  //CLOCK SOURCE
  input  wire                karst_fsys_n,
  input  wire                karst_fsys_p,
  //SERIAL IF
  output wire                karst_rf_spi_csn,
  output wire                karst_rf_spi_clk,
  input  wire                karst_rf_spi_miso,
  output wire                karst_rf_spi_mosi,

  output wire                karst_adc_spi_csn0,
  output wire                karst_adc_spi_csn1,
  output wire                karst_adc_spi_clk,
  output wire                karst_adc_spi_mosi,
`ifdef RW_RF_CACTUS
  input  wire                karst_adc_spi_miso,
`endif

  output wire                karst_dac_spi_csn0,
  output wire                karst_dac_spi_csn1,
  output wire                karst_dac_spi_clk,
  output wire                karst_dac_spi_mosi,
  input  wire                karst_dac_spi_miso,

  //RF CONTROL
`ifndef RW_RF_CACTUS
  output wire                karst_rf_tmode,
`endif
  input  wire                karst_rf_interrupt,
  output wire                karst_rf_agcfreeze,
  output wire                karst_rf_resetn,
  output wire          [7:0] karst_rf_gpio,

  //RX/TX SWITCH
  output wire                karst_trsw0,
  output wire                karst_trsw1,

  //PA
  output wire                karst_2g_pa0,
  output wire                karst_5g_pa0,
  output wire                karst_2g_pa1,
  output wire                karst_5g_pa1,

  //ADC
`ifndef RW_RF_CACTUS
  output wire                karst_clkbuf0_sync,
  output wire                karst_clkbuf1_sync,
`endif
  output wire                karst_adc0_sync,
  output wire                karst_adc0_oen,
  output wire                karst_adc0_pdwn,
  output wire                karst_adc0_clk_p,
  output wire                karst_adc0_clk_n,
  input  wire                karst_adc0_dco_p,
  input  wire                karst_adc0_dco_n,
  input  wire         [11:0] karst_adc0_p,
  input  wire         [11:0] karst_adc0_n,

  output wire                karst_adc1_sync,
  output wire                karst_adc1_oen,
  output wire                karst_adc1_pdwn,
  output wire                karst_adc1_clk_p,
  output wire                karst_adc1_clk_n,
  input  wire                karst_adc1_dco_p,
  input  wire                karst_adc1_dco_n,
  input  wire         [11:0] karst_adc1_p,
  input  wire         [11:0] karst_adc1_n,

  //DAC
  output wire                karst_dac0_reset,
  output wire                karst_dac0_clk_p,
  output wire                karst_dac0_clk_n,
  output wire                karst_dac0_dci_p,
  output wire                karst_dac0_dci_n,
  output wire         [11:0] karst_dac0_p,
  output wire         [11:0] karst_dac0_n,

`ifdef RW_RF_CACTUS
  //cactus board control
  output wire                karst_ctrl_en_n,
`endif

  output wire                karst_dac1_reset,
  output wire                karst_dac1_clk_p,
  output wire                karst_dac1_clk_n,
  output wire                karst_dac1_dci_p,
  output wire                karst_dac1_dci_n,
  output wire         [11:0] karst_dac1_p,
  output wire         [11:0] karst_dac1_n,

  output wire                karst_pwr_en,

  //****************************************************************************
  //Bluetooth Coexistence Interface
  //****************************************************************************
  input  wire                coex_bt_tx,
  input  wire                coex_bt_rx,
  input  wire                coex_bt_event,
  output wire                coex_bt_tx_abort,
  output wire                coex_bt_rx_abort,
  input  wire          [3:2] coex_bt_pti,
  output wire                coex_bt_tied0,
  //****************************************************************************
  //Board LED
  //****************************************************************************
  output wire          [7:1] led,
  //****************************************************************************
  //mictors
  //****************************************************************************
  output wire         [33:0] mictor0,
  output wire         [33:0] mictor1,
  output wire         [33:0] mictor2,
  //****************************************************************************
  //JTAG
  //****************************************************************************
  output wire                jtag_rtck,
  output wire                jtag_tdo,
  input  wire                jtag_tdi,
  input  wire                jtag_tms,
  input  wire                jtag_tck
);


////////////////////////////////////////////////////////////////////////////////
//
// Internal Wires declarations
//
////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------------------------
// Interrupt sources
//------------------------------------------------------------------------------
wire                         host_irq;           // Interrupt from host
wire                         fpga_irq;           // Interrupt from rw_he_v7
//------------------------------------------------------------------------------
// GPIO interface
//------------------------------------------------------------------------------
wire                  [31:0] gpio_out;           // GPIO
wire                  [31:0] gpio_in;            // GPIO
wire                  [31:0] gpio_oen;           // GPIO enable
`ifdef  RW_COEX_MODEL
//------------------------------------------------------------------------------
// AHB to Coexistence interface
//------------------------------------------------------------------------------
wire                         coexif_hready_in;   // Coexistence Interface hready_in
wire                         coexif_hsel;        // Coexistence Interface hsel
wire                   [8:0] coexif_haddr;       // Coexistence Interface haddr
wire                   [1:0] coexif_htrans;      // Coexistence Interface htrans
wire                         coexif_hwrite;      // Coexistence Interface hwrite
wire                  [31:0] coexif_hrdata;      // Coexistence Interface hrdata
wire                  [31:0] coexif_hwdata;      // Coexistence Interface hwdata
wire                   [1:0] coexif_hresp;       // Coexistence Interface hresp
wire                         coexif_hready;      // Coexistence Interface hready
`endif//RW_COEX_MODEL
//------------------------------------------------------------------------------
// RC Coexistence interface
//------------------------------------------------------------------------------
wire                         rc_tx_abort;        // Radio Controller Transmission Abort Request
wire                         rc_rx_abort;        // Radio Controller Reception    Abort Request

//------------------------------------------------------------------------------
// Platform DMA Interface
//------------------------------------------------------------------------------
// upstream interface
wire                   [3:0] dma0_awid;          // DMA Upstream awid
wire                  [31:0] dma0_awaddr;        // DMA Upstream awaddr
wire                   [7:0] dma0_awlen;         // DMA Upstream awlen
wire                   [2:0] dma0_awsize;        // DMA Upstream awsize
wire                   [1:0] dma0_awburst;       // DMA Upstream awburst
wire                  [11:0] dma0_awuser;        // DMA Upstream awuser
wire                         dma0_awvalid;       // DMA Upstream awvalid
wire                         dma0_awready;       // DMA Upstream awready
wire                  [63:0] dma0_wdata;         // DMA Upstream wdata
wire                   [7:0] dma0_wstrb;         // DMA Upstream wstrb
wire                         dma0_wlast;         // DMA Upstream wlast
wire                         dma0_wvalid;        // DMA Upstream wvalid
wire                         dma0_wready;        // DMA Upstream wready
wire                   [3:0] dma0_bid;           // DMA Upstream bid
wire                   [1:0] dma0_bresp;         // DMA Upstream bresp
wire                         dma0_bvalid;        // DMA Upstream bvalid
wire                         dma0_bready;        // DMA Upstream bready
// downstream interface
wire                   [3:0] dma1_arid;          // DMA Downstream arid
wire                  [31:0] dma1_araddr;        // DMA Downstream araddr
wire                   [7:0] dma1_arlen;         // DMA Downstream arlen
wire                   [2:0] dma1_arsize;        // DMA Downstream arsize
wire                   [1:0] dma1_arburst;       // DMA Downstream arburst
wire                         dma1_arvalid;       // DMA Downstream arvalid
wire                         dma1_arready;       // DMA Downstream arready
wire                   [3:0] dma1_rid;           // DMA Downstream rid
wire                  [63:0] dma1_rdata;         // DMA Downstream rdata
wire                   [1:0] dma1_rresp;         // DMA Downstream rresp
wire                         dma1_rlast;         // DMA Downstream rlast
wire                         dma1_rvalid;        // DMA Downstream rvalid
wire                         dma1_rready;        // DMA Downstream rready
`ifdef  RW_FPGA_AHB
//------------------------------------------------------------------------------
// AHB to FPGA
//------------------------------------------------------------------------------
wire                         fpga_hready_in;     // FPGA hready_in
wire                         fpga_hsel;          // FPGA hsel
wire                  [19:0] fpga_haddr;         // FPGA haddr
wire                   [1:0] fpga_htrans;        // FPGA htrans
wire                         fpga_hwrite;        // FPGA hwrite
wire                  [31:0] fpga_hrdata;        // FPGA hrdata
wire                  [31:0] fpga_hwdata;        // FPGA hwdata
wire                   [1:0] fpga_hresp;         // FPGA hresp
wire                         fpga_hready;        // FPGA hready
`endif//RW_FPGA_AHB
//------------------------------------------------------------------------------
// MAC Platform Diagnostic Ports
//------------------------------------------------------------------------------
wire                   [4:0] rw_nx_ss_diag;      // Diagnostic port
wire                  [15:0] rw_nx_diag0  ;      // Diagnostic port
wire                  [15:0] rw_nx_diag1  ;      // Diagnostic port
wire                  [15:0] rw_nx_diag2  ;      // Diagnostic port
wire                  [15:0] rw_nx_diag3  ;      // Diagnostic port
wire                  [15:0] rw_nx_diag4  ;      // Diagnostic port
wire                  [15:0] rw_nx_diag5  ;      // Diagnostic port
wire                  [15:0] rw_nx_diag6  ;      // Diagnostic port
wire                         mac_internal_error; // MAC internal Error
wire                         mac_debug_ksr ;     // Debug Key Storage RAM.
wire                   [1:0] macbypass_trigger;  // MAC Bypass Trigger Port
wire                         reg_diag_trigger;   // SW Trigger Port

//------------------------------------------------------------------------------
// System control
//------------------------------------------------------------------------------
wire                         reg_bootrom_enable; // CPU Boot enable

//------------------------------------------------------------------------------
// Internal Coexistance interface
//------------------------------------------------------------------------------
wire                         coex_bt_tx_int;
wire                         coex_bt_rx_int;
wire                         coex_bt_event_int;
wire                         coex_bt_tx_abort_int;
wire                         coex_bt_rx_abort_int;
wire                   [3:2] coex_bt_pti_int;


////////////////////////////////////////////////////////////////////////////////
//
// Begining of Logic part
//
////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------------------------
// Resets
//------------------------------------------------------------------------------
wire                         sys_rst_n;
wire                         plf_rst_n;
wire                         ref80_rst_n;
wire                         fe_rst_n;
wire                         plf_por_n;
//------------------------------------------------------------------------------
// Clocks
//------------------------------------------------------------------------------
wire                         clk_pcie;
wire                         fe_clk;
wire                         ref80_clk;
wire                         plf_clk;
wire                         clk_pcie_p_buf;
wire                         clk_pcie_n_buf;
//------------------------------------------------------------------------------
// Target AHB interface
//------------------------------------------------------------------------------
wire                  [31:0] target_haddr;
wire                   [2:0] target_hburst;
wire                         target_hmastlock;
wire                   [3:0] target_hprot;
wire                  [31:0] target_hrdata;
wire                         target_hready;
wire                   [1:0] target_hresp;
wire                   [2:0] target_hsize;
wire                   [1:0] target_htrans;
wire                  [31:0] target_hwdata;
wire                         target_hwrite;
//------------------------------------------------------------------------------
// PCIe Subsystem
//------------------------------------------------------------------------------
wire                         axi_aclk_out;
wire                         axi_por_n;
wire                         intx_msi_request;
wire                         interrupt_host_out;

//------------------------------------------------------------------------------
// fpga register bank
//------------------------------------------------------------------------------
wire                  [15:0] regb_mictor0_sel;
wire                   [7:0] regb_mictor1_sel;
wire                   [7:0] regb_mictor2_sel;

wire                         regb_iodelay_start;
wire                         regb_iodelay_done;
wire                   [7:0] regb_iodelay_adc0;
wire                   [7:0] regb_iodelay_dac0;
wire                   [7:0] regb_iodelay_adc1;
wire                   [7:0] regb_iodelay_dac1;

wire                  [15:0] regb_playback_count;
wire                         regb_capture_done;
wire                         regb_ch0_playback_en;
wire                         regb_ch0_capture_en;
wire                         regb_ch1_playback_en;
wire                         regb_ch1_capture_en;

wire                   [3:0] regb_pathmux_sel;

wire                         regb_adc_autopower_en;
wire                   [4:0] regb_adc_spi_prescaler;
wire                   [3:0] regb_adc_spi_sel;
wire                         regb_adc_spi_start;
wire                         regb_adc_spi_we;
wire                  [15:0] regb_adc_spi_addr;
wire                  [15:0] regb_adc_spi_wdata;
wire                  [15:0] regb_adc_spi_rdata;
wire                         regb_adc_spi_done;

wire                         regb_dac_reset;
wire                         regb_dac_autopower_en;
wire                  [15:0] regb_dac_autopower_powerup;
wire                  [15:0] regb_dac_autopower_powerdn;
wire                   [4:0] regb_dac_spi_prescaler;
wire                   [3:0] regb_dac_spi_sel;
wire                         regb_dac_spi_start;
wire                         regb_dac_spi_we;
wire                  [15:0] regb_dac_spi_addr;
wire                  [15:0] regb_dac_spi_wdata;
wire                  [15:0] regb_dac_spi_rdata;
wire                         regb_dac_spi_done;

wire                  [15:0] regb_rf_force_en;
wire                  [15:0] regb_rf_force;
wire                  [ 7:0] regb_rf_gpio;

wire                         regb_rf_spi_start;
wire                         regb_rf_spi_done;
wire                   [3:0] regb_rf_spi_prescaler;
wire                         regb_rf_spi_we;
wire                  [15:0] regb_rf_spi_addr;
wire                  [15:0] regb_rf_spi_rdata;
wire                  [15:0] regb_rf_spi_wdata;

wire                   [9:0] regb_gcos_adc0;
wire                   [9:0] regb_gsin_adc0;
wire                   [9:0] regb_gcos_adc1;
wire                   [9:0] regb_gsin_adc1;
wire                   [9:0] regb_gcos_dac0;
wire                   [9:0] regb_gsin_dac0;
wire                   [9:0] regb_gcos_dac1;
wire                   [9:0] regb_gsin_dac1;

// karstif/fb
wire                         fb_ch0_trsw;
wire                         fb_ch0_pa2g;
wire                         fb_ch0_pa5g;
wire                         fb_ch1_trsw;
wire                         fb_ch1_pa2g;
wire                         fb_ch1_pa5g;
                      
wire                         fb_ch0_dac_on;
wire                  [11:0] fb_ch0_dac_i;
wire                  [11:0] fb_ch0_dac_q;
wire                         fb_ch1_dac_on;
wire                  [11:0] fb_ch1_dac_i;
wire                  [11:0] fb_ch1_dac_q;
                      
wire                         fb_ch0_adc_on;
wire                  [11:0] fb_ch0_adc_i;
wire                  [11:0] fb_ch0_adc_q;
wire                         fb_ch1_adc_on;
wire                  [11:0] fb_ch1_adc_i;
wire                  [11:0] fb_ch1_adc_q;

// misc
wire                  [31:0] fpga_signature;
wire                  [31:0] fpga_date;
wire                  [31:0] svnrev_modem;
wire                  [31:0] svnrev_fpgab;

// riu to fb
wire                         riu_rf_resetn;
wire                   [7:0] riu_rf_gpio;
wire                         riu_rf_agcfreeze;
wire                         riu_rf_tmode;
wire                         riu_rf_spi_miso;
wire                         riu_rf_spi_csn;
wire                         riu_rf_spi_clk;
wire                         riu_rf_spi_mosi;

// riu path0 adc
wire                         riu_ch0_adc_on;
wire                  [11:0] riu_ch0_adc_i;
wire                  [11:0] riu_ch0_adc_q;

// riu path0  dac
wire                         riu_dac_data_enable;
wire                         riu_ch0_dac_enable; // $todo: move to riu
wire                         riu_ch0_dac_on;
wire                  [11:0] riu_ch0_dac_i;
wire                  [11:0] riu_ch0_dac_q;

// riu path0  rf board control
wire                         riu_ch0_trsw;
wire                         riu_ch0_pa2g;
wire                         riu_ch0_pa5g;

`ifdef RW_NX_DERIV_FE_PATH1
// riu path1 adc
wire                         riu_ch1_adc_on;
wire                  [11:0] riu_ch1_adc_i;
wire                  [11:0] riu_ch1_adc_q;

// riu path1 dac
wire                         riu_ch1_dac_enable; // $todo: move to riu
wire                         riu_ch1_dac_on;
wire                  [11:0] riu_ch1_dac_i;
wire                  [11:0] riu_ch1_dac_q;

// riu path1 rf board control
wire                         riu_ch1_trsw;
wire                         riu_ch1_pa2g;
wire                         riu_ch1_pa5g;
`endif

// Interrupt
reg                          doorbell_int_status;
wire                         doorbell_int_clear;
wire                         doorbell_int_set;
wire                         doorbell_int_mask;

// V7 GPIO
wire                         v7_gpio_en;
wire                         v7_gpio6;
wire                         v7_gpio5;
wire                         v7_gpio3;
wire                         v7_gpio2;
wire                         v7_gpio1;
wire                         v7_gpio0;


//------------------------------------------------------------------------------
// path mux
//------------------------------------------------------------------------------
wire                         pathmux_ch0_adc_on;
wire                  [11:0] pathmux_ch0_adc_i;
wire                  [11:0] pathmux_ch0_adc_q;
wire                         pathmux_ch0_dac_on;
wire                         pathmux_ch0_dac_enable;
wire                  [11:0] pathmux_ch0_dac_i;
wire                  [11:0] pathmux_ch0_dac_q;
wire                         pathmux_ch0_trsw;
wire                         pathmux_ch0_pa5g;
wire                         pathmux_ch0_pa2g;
                      
wire                         pathmux_ch1_adc_on;
wire                  [11:0] pathmux_ch1_adc_i;
wire                  [11:0] pathmux_ch1_adc_q;
wire                         pathmux_ch1_dac_on;
wire                         pathmux_ch1_dac_enable;
wire                  [11:0] pathmux_ch1_dac_i;
wire                  [11:0] pathmux_ch1_dac_q;
wire                         pathmux_ch1_trsw;
wire                         pathmux_ch1_pa5g;
wire                         pathmux_ch1_pa2g;

//------------------------------------------------------------------------------
// debug interface
//------------------------------------------------------------------------------
wire                  [31:0] diag_in0;
wire                  [31:0] diag_in1;
wire                  [31:0] diag_in2;
wire                  [31:0] diag_in3;
wire                  [31:0] diag_in4;
wire                  [31:0] diag_in5;
wire                  [31:0] diag_in6;
wire                  [31:0] diag_in7;
wire                  [31:0] diag_in8;
wire                  [31:0] diag_in9;
wire                  [31:0] diag_in10;
wire                  [31:0] diag_in11;
wire                  [31:0] diag_in12;
wire                  [31:0] diag_in13;
wire                  [31:0] diag_in14;
wire                  [31:0] diag_in15;
wire                  [31:0] diag_in16;
wire                  [31:0] diag_in17;
wire                  [31:0] diag_in18;
wire                  [31:0] diag_in19;
wire                  [31:0] diag_in20;
wire                  [31:0] diag_in21;
wire                  [31:0] diag_in22;
wire                  [31:0] diag_in23;
wire                  [31:0] diag_in24;
wire                  [31:0] diag_in25;
wire                  [31:0] diag_in26;
wire                  [31:0] diag_in27;
wire                  [31:0] diag_in28;
wire                  [31:0] diag_in29;
wire                  [31:0] diag_in30;

//------------------------------------------------------------------------------
// ad9613_controller (DAC)
//------------------------------------------------------------------------------
wire                         karst_dac_reset;
wire                         karst_dac_spi_oe;
wire                         karst_dac_spi_mosi_pretri;
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
wire                  [11:0] kif_ch0_adc_i;
wire                  [11:0] kif_ch0_adc_q;
wire                  [11:0] kif_ch1_adc_i;
wire                  [11:0] kif_ch1_adc_q;
wire                  [11:0] kif_ch0_dac_i;
wire                  [11:0] kif_ch0_dac_q;
wire                  [11:0] kif_ch1_dac_i;
wire                  [11:0] kif_ch1_dac_q;
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
wire                         karst_adc_spi_oe;
wire                         karst_adc_spi_mosi_pretri;
//------------------------------------------------------------------------------
// FPGA Infrastructure
//------------------------------------------------------------------------------
//wire                         fpga_hsel_rega;
//reg                          fpga_hsel_rega_1t;
//wire                  [31:0] fpga_hrdata_rega;
//wire                   [1:0] fpga_hresp_rega;
//wire                         fpga_hready_rega;
wire                         fpga_hsel_regb;
reg                          fpga_hsel_regb_1t;
wire                  [31:0] fpga_hrdata_regb;
wire                   [1:0] fpga_hresp_regb;
wire                         fpga_hready_regb;
wire                         fpga_hsel_fbch0;
reg                          fpga_hsel_fbch0_1t;
wire                  [31:0] fpga_hrdata_fbch0;
wire                   [1:0] fpga_hresp_fbch0;
wire                         fpga_hready_fbch0;
wire                         fpga_hsel_fbch1;
reg                          fpga_hsel_fbch1_1t;
wire                  [31:0] fpga_hrdata_fbch1;
wire                   [1:0] fpga_hresp_fbch1;
wire                         fpga_hready_fbch1;
wire                         fpga_hsel_default;
reg                          fpga_hsel_default_1t;
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
wire                         rstn_long_pci;
wire                         platform_wake_up; // ToDo

//******************************************************************************
// static assignment
//******************************************************************************
// clock is not divided on the board, so only one possbile clock phase,
// no need to sync
assign karst_adc0_sync      = 1'b0;
assign karst_adc1_sync      = 1'b0;
assign karst_adc0_oen       = 1'b0;
assign karst_adc1_oen       = 1'b0;
`ifndef RW_RF_CACTUS
assign karst_clkbuf0_sync   = 1'b1;
assign karst_clkbuf1_sync   = 1'b1;
`endif

`ifdef RW_RF_CACTUS
// cactus board control
assign karst_ctrl_en_n      = 1'b0;
`endif

assign karst_pwr_en         = 1'b1; // Always on

// versioning
assign svnrev_modem         = `FPGA_SVNREV_MODEM;
assign svnrev_fpgab         = `RW_FPGA_SVNREV;
assign fpga_signature       = `RW_FPGA_SIGNATURE;
assign fpga_date            = `RW_FPGA_DATE;

//******************************************************************************
// PCIe subsytem
//******************************************************************************
RW_sub_system RW_sub_system_u0(
  .REFCLK             (clk_pcie           ),
  //----------------------------------------------------------------------------
  // Target ahb
  //----------------------------------------------------------------------------
  .ahb_clk            (plf_clk            ),
  .dma_clk            (plf_clk            ),
  .axi_aclk_out       (axi_aclk_out       ),
  .axi_aresetn        (axi_por_n          ),
  .target_haddr       (target_haddr       ),
  .target_hburst      (target_hburst      ),
  .target_hmastlock   (target_hmastlock   ),
  .target_hprot       (target_hprot       ),
  .target_hrdata      (target_hrdata      ),
  .target_hready      (target_hready      ),
  .target_hresp       (target_hresp[0]    ),
  .target_hsize       (target_hsize       ),
  .target_htrans      (target_htrans      ),
  .target_hwdata      (target_hwdata      ),
  .target_hwrite      (target_hwrite      ),
  //----------------------------------------------------------------------------
  // DMA
  //----------------------------------------------------------------------------
  .dma_araddr         (dma1_araddr        ),
  .dma_arburst        (dma1_arburst       ),
  .dma_arcache        (4'd0               ),
  .dma_arid           (dma1_arid          ),
  .dma_arlen          (dma1_arlen         ),
  .dma_arlock         (1'b0               ),
  .dma_arprot         (3'd0               ),
  .dma_arqos          (4'd0               ),
  .dma_arready        (dma1_arready       ),
  .dma_arregion       (4'd0               ),
  .dma_arsize         (dma1_arsize        ),
  .dma_arvalid        (dma1_arvalid       ),
  .dma_rdata          (dma1_rdata         ),
  .dma_rid            (dma1_rid           ),
  .dma_rlast          (dma1_rlast         ),
  .dma_rready         (dma1_rready        ),
  .dma_rresp          (dma1_rresp         ),
  .dma_rvalid         (dma1_rvalid        ),
  //
  .dma_bready         (dma0_bready        ),
  .dma_awaddr         (dma0_awaddr        ),
  .dma_awburst        (dma0_awburst       ),
  .dma_awcache        (4'd0               ),
  .dma_awid           (dma0_awid          ),
  .dma_awlen          (dma0_awlen         ),
  .dma_awlock         (1'b0               ),
  .dma_awprot         (3'd0               ),
  .dma_awqos          (4'd0               ),
  .dma_awready        (dma0_awready       ),
  .dma_awregion       (4'd0               ),
  .dma_awsize         (dma0_awsize        ),
  .dma_awvalid        (dma0_awvalid       ),
  .dma_bid            (dma0_bid           ),
  .dma_bresp          (dma0_bresp         ),
  .dma_bvalid         (dma0_bvalid        ),
  .dma_wdata          (dma0_wdata         ),
  .dma_wlast          (dma0_wlast         ),
  .dma_wready         (dma0_wready        ),
  .dma_wstrb          (dma0_wstrb         ),
  .dma_wvalid         (dma0_wvalid        ),
  //----------------------------------------------------------------------------
  // PCIe
  //----------------------------------------------------------------------------
  .INTX_MSI_Request   (intx_msi_request   ),
  .MSI_Vector_Num     (5'd0               ),
  .interrupt_host_out (interrupt_host_out ),
  .pcie_7x_mgt_rxn    (pcie_7x_mgt_rxn    ),
  .pcie_7x_mgt_rxp    (pcie_7x_mgt_rxp    ),
  .pcie_7x_mgt_txn    (pcie_7x_mgt_txn    ),
  .pcie_7x_mgt_txp    (pcie_7x_mgt_txp    )
);


/*****************************************************************************
* FPGA FSYS
*****************************************************************************/
/* fsys : rf 40MHz reference clock */
wire karst_fsys_prebufg;
wire karst_fsys_premmc;
IBUFGDS 
#(
  .DIFF_TERM(     "TRUE")
) 
u_karst_fsys_clk_lvds
(
  .I(             karst_fsys_p),
  .IB(            karst_fsys_n),
  .O(             karst_fsys_prebufg)
);


//******************************************************************************
// RW_HE_TOP_WRAPPER
//******************************************************************************
`ifndef  RW_WLAN_COEX_EN
assign coex_bt_tx_abort_int = 1'b0;
assign coex_bt_rx_abort_int = 1'b0;
`endif

rw_he_top_cpu u_rw_he_top_cpu_u0(
  //----------------------------------------------------------------------------
  // Reset
  //----------------------------------------------------------------------------
  .sys_rst_n            (sys_rst_n                    ),
  //----------------------------------------------------------------------------
  // Clock in
  //----------------------------------------------------------------------------
  .ref0_root_clk        (karst_fsys_prebufg           ),
  .ref1_root_clk        (clk_ext_25                   ),
  //----------------------------------------------------------------------------
  // Clock out
  //----------------------------------------------------------------------------
  .global_rst_n         (global_rst_n                 ),
  .ref80_clk            (ref80_clk                    ),
  .ref80_rst_n          (ref80_rst_n                  ),
  .fe_clk               (fe_clk                       ),
  .fe_rst_n             (fe_rst_n                     ),
  .plf_clk              (plf_clk                      ),
  .plf_rst_n            (plf_rst_n                    ),
  .plf_por_n            (plf_por_n                    ),
  .axi_aclk             (axi_aclk_out                 ),
  .axi_por_n            (axi_por_n                    ),

  //----------------------------------------------------------------------------
  // Clock enable outputs
  //----------------------------------------------------------------------------
  .platform_wake_up     (platform_wake_up             ),

  //----------------------------------------------------------------------------
  // Host AHB Slave interface
  //----------------------------------------------------------------------------
  .target_hready_in     (1'b1                         ),
  .target_haddr         (target_haddr                 ),
  .target_hburst        (target_hburst                ),
  .target_hmastlock     (target_hmastlock             ),
  .target_hprot         (target_hprot                 ),
  .target_hrdata        (target_hrdata                ),
  .target_hready        (target_hready                ),
  .target_hresp         (target_hresp                 ),
  .target_hsize         (target_hsize                 ),
  .target_htrans        (target_htrans                ),
  .target_hwdata        (target_hwdata                ),
  .target_hwrite        (target_hwrite                ),

  //----------------------------------------------------------------------------
  // Interrupt sources
  //----------------------------------------------------------------------------
  .host_irq             (host_irq                     ),
`ifdef  RW_FPGA_AHB
  .fpga_irq             (fpga_irq                     ),
`endif//RW_FPGA_AHB

  //----------------------------------------------------------------------------
  // GPIO interface
  //----------------------------------------------------------------------------
  .gpio_out             (gpio_out                     ),
  .gpio_in              (gpio_in                      ),
  .gpio_oen             (gpio_oen                     ),
  //----------------------------------------------------------------------------
  // AHB to Coexistence interface
  //----------------------------------------------------------------------------
`ifdef  RW_COEX_MODEL
  .coexif_hready_in     (coexif_hready_in             ),
  .coexif_hsel          (coexif_hsel                  ),
  .coexif_haddr         (coexif_haddr                 ),
  .coexif_htrans        (coexif_htrans                ),
  .coexif_hwrite        (coexif_hwrite                ),
  .coexif_hrdata        (coexif_hrdata                ),
  .coexif_hwdata        (coexif_hwdata                ),
  .coexif_hresp         (coexif_hresp                 ),
  .coexif_hready        (coexif_hready                ),
`endif//RW_COEX_MODEL

  //----------------------------------------------------------------------------
  // Bluetooth Coexistence Interface
  //----------------------------------------------------------------------------
`ifdef  RW_WLAN_COEX_EN
  .coex_bt_tx           (coex_bt_tx_int               ),
  .coex_bt_rx           (coex_bt_rx_int               ),
  .coex_bt_event        (coex_bt_event_int            ),
  .coex_bt_tx_abort     (coex_bt_tx_abort_int         ),
  .coex_bt_rx_abort     (coex_bt_rx_abort_int         ),
  .coex_bt_pti          ({coex_bt_pti_int[3:2],2'b00} ),
  .coex_bt_channel      (7'd0                         ),
  .coex_bt_bw           (1'b0                         ),
`endif//RW_WLAN_COEX_EN

  //----------------------------------------------------------------------------
  // RC Coexistence Interface
  //----------------------------------------------------------------------------
  .rc_tx_abort          (                     ), // TODO
  .rc_rx_abort          (                     ), // TODO

  //----------------------------------------------------------------------------
  // Plaform DMA Interface
  //----------------------------------------------------------------------------
  .dma0_awid            (dma0_awid                    ),
  .dma0_awaddr          (dma0_awaddr                  ),
  .dma0_awlen           (dma0_awlen                   ),
  .dma0_awsize          (dma0_awsize                  ),
  .dma0_awburst         (dma0_awburst                 ),
  .dma0_awuser          (dma0_awuser                  ),
  .dma0_awvalid         (dma0_awvalid                 ),
  .dma0_awready         (dma0_awready                 ),
  .dma0_wid             (/*Open*/                     ),
  .dma0_wdata           (dma0_wdata                   ),
  .dma0_wstrb           (dma0_wstrb                   ),
  .dma0_wlast           (dma0_wlast                   ),
  .dma0_wvalid          (dma0_wvalid                  ),
  .dma0_wready          (dma0_wready                  ),
  .dma0_bid             (dma0_bid                     ),
  .dma0_bresp           (dma0_bresp                   ),
  .dma0_bvalid          (dma0_bvalid                  ),
  .dma0_bready          (dma0_bready                  ),
  .dma1_arid            (dma1_arid                    ),
  .dma1_araddr          (dma1_araddr                  ),
  .dma1_arlen           (dma1_arlen                   ),
  .dma1_arsize          (dma1_arsize                  ),
  .dma1_arburst         (dma1_arburst                 ),
  .dma1_arvalid         (dma1_arvalid                 ),
  .dma1_arready         (dma1_arready                 ),
  .dma1_rid             (dma1_rid                     ),
  .dma1_rdata           (dma1_rdata                   ),
  .dma1_rresp           (dma1_rresp                   ),
  .dma1_rlast           (dma1_rlast                   ),
  .dma1_rvalid          (dma1_rvalid                  ),
  .dma1_rready          (dma1_rready                  ),

  //----------------------------------------------------------------------------
  // ADC Interface
  //----------------------------------------------------------------------------
  .adc0_on              (riu_ch0_adc_on               ),
  .adc0_i               (riu_ch0_adc_i                ),
  .adc0_q               (riu_ch0_adc_q                ),
`ifdef  RW_NX_DERIV_FE_PATH1
  .adc1_on              (riu_ch1_adc_on               ),
  .adc1_i               (riu_ch1_adc_i                ),
  .adc1_q               (riu_ch1_adc_q                ),
`endif//RW_NX_DERIV_FE_PATH1

  //----------------------------------------------------------------------------
  // DAC Interface
  //----------------------------------------------------------------------------
  .dac0_on              (riu_ch0_dac_on               ),// $todo: move triplet into riu
  .dac0_en              (riu_ch0_dac_enable           ),// $todo: move triplet into riu
  .dac0_i               (riu_ch0_dac_i                ),
  .dac0_q               (riu_ch0_dac_q                ),
`ifdef  RW_NX_DERIV_FE_PATH1
  .dac1_on              (riu_ch1_dac_on               ),// $todo: move triplet into riu
  .dac1_en              (riu_ch1_dac_enable           ),// $todo: move triplet into riu
  .dac1_i               (riu_ch1_dac_i                ),
  .dac1_q               (riu_ch1_dac_q                ),
`endif//RW_NX_DERIV_FE_PATH1

  //----------------------------------------------------------------------------
  // RF interface
  //----------------------------------------------------------------------------
  .rf_resetn            (riu_rf_resetn                ),
  .rf_agcfreeze         (riu_rf_agcfreeze             ),
  .rf_tmode             (riu_rf_tmode                 ),
  .rf_gpio              (riu_rf_gpio                  ),
  .rf_spi_in            (riu_rf_spi_miso              ),
  .rf_spi_ss_n          (riu_rf_spi_csn               ),
  .rf_spi_clk           (riu_rf_spi_clk               ),
  .rf_spi_out           (riu_rf_spi_mosi              ),
  .rf_trsw0             (riu_ch0_trsw                 ),
`ifdef  RW_NX_DERIV_FE_PATH1
  .rf_trsw1             (riu_ch1_trsw                 ),
`endif//RW_NX_DERIV_FE_PATH1
  .rf_extpaon_ch0_5G9   (riu_ch0_pa5g                 ),
  .rf_extpaon_ch0_2G4   (riu_ch0_pa2g                 ),
`ifdef  RW_NX_DERIV_FE_PATH1
  .rf_extpaon_ch1_5G9   (riu_ch1_pa5g                 ),
  .rf_extpaon_ch1_2G4   (riu_ch1_pa2g                 ),
`endif//RW_NX_DERIV_FE_PATH1

  //----------------------------------------------------------------------------
  // AHB to FPGA
  //----------------------------------------------------------------------------
`ifdef  RW_FPGA_AHB
  .fpga_hready_in       (fpga_hready_in               ),
  .fpga_hsel            (fpga_hsel                    ),
  .fpga_haddr           (fpga_haddr                   ),
  .fpga_htrans          (fpga_htrans                  ),
  .fpga_hwrite          (fpga_hwrite                  ),
  .fpga_hrdata          (fpga_hrdata                  ),
  .fpga_hwdata          (fpga_hwdata                  ),
  .fpga_hresp           (fpga_hresp                   ),
  .fpga_hready          (fpga_hready                  ),
`endif//RW_FPGA_AHB

  //----------------------------------------------------------------------------
  // MAC Platform Diagnostic Ports
  //----------------------------------------------------------------------------
  .ext_diagport         (32'h0/*mac_mictor_2t*/       ),
  .reg_bootrom_enable   (reg_bootrom_enable           ),
	.rw_nx_ss_diag        (rw_nx_ss_diag                ),
	.rw_nx_diag0          (rw_nx_diag0                  ),
  .rw_nx_diag1          (rw_nx_diag1                  ),
  .rw_nx_diag2          (rw_nx_diag2                  ),
  .rw_nx_diag3          (rw_nx_diag3                  ),
  .rw_nx_diag4          (rw_nx_diag4                  ),
  .rw_nx_diag5          (rw_nx_diag5                  ),
  .rw_nx_diag6          (rw_nx_diag6                  ),
  .mac_internal_error   (mac_internal_error           ),
  .mac_debug_ksr        (1'b1                         ),
  .macbypass_trigger    (macbypass_trigger            ),
  .reg_diag_trigger     (reg_diag_trigger             ),

  //****************************************************************************
  //JTAG
  //****************************************************************************
  .jtag_rtck            (                             ),
  .jtag_tdo             (                             ),
  .jtag_tdi             (1'b0                         ),
  .jtag_tms             (1'b0                         ),
  .jtag_tck             (1'b0                         )
);                      


//******************************************************************************
// DAC/ADC interface
//******************************************************************************
karst_if u_karst_if(
  //----------------------------------------------------------------------------
  // Resets
  //----------------------------------------------------------------------------
  .dco_adc1_locked    (/*Open*/               ),
  .dco_adc0_locked    (/*Open*/               ),
  .debug_dco_clk      (/*Open*/               ),
  .karst_dac0_clk     (/*Open*/               ),
  .karst_dac1_clk     (/*Open*/               ),
  .fe_rst_n           (fe_rst_n               ),
  //----------------------------------------------------------------------------
  // Clocks
  //----------------------------------------------------------------------------
  .fe_clk             (fe_clk                 ),
  //----------------------------------------------------------------------------
  // Register bank
  //----------------------------------------------------------------------------
  .regb_rf_force_en   (regb_rf_force_en       ),
  .regb_rf_force      (regb_rf_force          ),
  .regb_gpio          (regb_rf_gpio           ),
  .regb_spi_start     (regb_rf_spi_start      ),
  .regb_spi_done      (regb_rf_spi_done       ),
  .regb_spi_prescaler (regb_rf_spi_prescaler  ),
  .regb_spi_we        (regb_rf_spi_we         ),
  .regb_spi_addr      (regb_rf_spi_addr[9:0]  ),
  .regb_spi_rdata     (regb_rf_spi_rdata      ),
  .regb_spi_wdata     (regb_rf_spi_wdata      ),
  .regb_iodelay_start (regb_iodelay_start     ),
  .regb_iodelay_done  (regb_iodelay_done      ),
  .regb_iodelay_adc0  (regb_iodelay_adc0[4:0] ),
  .regb_iodelay_dac0  (regb_iodelay_dac0[4:0] ),
  .regb_iodelay_adc1  (regb_iodelay_adc1[4:0] ),
  .regb_iodelay_dac1  (regb_iodelay_dac1[4:0] ),
  //----------------------------------------------------------------------------
  // Karst interface
  //----------------------------------------------------------------------------
  .karst_rf_resetn    (karst_rf_resetn        ),
  .karst_rf_gpio      (karst_rf_gpio          ),
  .karst_rf_agcfreeze (karst_rf_agcfreeze     ),
`ifndef RW_RF_CACTUS
  .karst_rf_tmode     (karst_rf_tmode         ),
`else
  .karst_rf_tmode     (/*Open*/               ),
`endif
  .karst_trsw0        (karst_trsw0            ),
  .karst_trsw1        (karst_trsw1            ),
  .karst_2g_pa0       (karst_2g_pa0           ),
  .karst_2g_pa1       (karst_2g_pa1           ),
  .karst_5g_pa0       (karst_5g_pa0           ),
  .karst_5g_pa1       (karst_5g_pa1           ),
  .karst_rf_spi_csn   (karst_rf_spi_csn       ),
  .karst_rf_spi_clk   (karst_rf_spi_clk       ),
  .karst_rf_spi_miso  (karst_rf_spi_miso      ),
  .karst_rf_spi_mosi  (karst_rf_spi_mosi      ),
  .karst_adc0_clk_p   (karst_adc0_clk_p       ),
  .karst_adc0_clk_n   (karst_adc0_clk_n       ),
  .karst_adc0_dco_p   (karst_adc0_dco_p       ),
  .karst_adc0_dco_n   (karst_adc0_dco_n       ),
  .karst_adc0_p       (karst_adc0_p           ),
  .karst_adc0_n       (karst_adc0_n           ),
  .karst_dac0_clk_p   (karst_dac0_clk_p       ),
  .karst_dac0_clk_n   (karst_dac0_clk_n       ),
  .karst_dac0_dci_p   (karst_dac0_dci_p       ),
  .karst_dac0_dci_n   (karst_dac0_dci_n       ),
  .karst_dac0_p       (karst_dac0_p           ),
  .karst_dac0_n       (karst_dac0_n           ),
  .karst_adc1_clk_p   (karst_adc1_clk_p       ),
  .karst_adc1_clk_n   (karst_adc1_clk_n       ),
  .karst_adc1_dco_p   (karst_adc1_dco_p       ),
  .karst_adc1_dco_n   (karst_adc1_dco_n       ),
  .karst_adc1_p       (karst_adc1_p           ),
  .karst_adc1_n       (karst_adc1_n           ),
  .karst_dac1_clk_p   (karst_dac1_clk_p       ),
  .karst_dac1_clk_n   (karst_dac1_clk_n       ),
  .karst_dac1_dci_p   (karst_dac1_dci_p       ),
  .karst_dac1_dci_n   (karst_dac1_dci_n       ),
  .karst_dac1_p       (karst_dac1_p           ),
  .karst_dac1_n       (karst_dac1_n           ),
  //----------------------------------------------------------------------------
  // Phy Interface
  //----------------------------------------------------------------------------
  .rf_spi_csn         (riu_rf_spi_csn         ),
  .rf_spi_clk         (riu_rf_spi_clk         ),
  .rf_spi_miso        (riu_rf_spi_miso        ),
  .rf_spi_mosi        (riu_rf_spi_mosi        ),
  .rf_resetn          (riu_rf_resetn          ),
  .rf_gpio            (riu_rf_gpio            ),
  .rf_agcfreeze       (riu_rf_agcfreeze       ),
  .rf_tmode           (riu_rf_tmode           ),
  .rf_trsw0           (fb_ch0_trsw            ),
  .rf_trsw1           (fb_ch1_trsw            ),
  .rf_2g_pa0          (fb_ch0_pa2g            ),
  .rf_2g_pa1          (fb_ch1_pa2g            ),
  .rf_5g_pa0          (fb_ch0_pa5g            ),
  .rf_5g_pa1          (fb_ch1_pa5g            ),
  .dac0_on            (fb_ch0_dac_on          ),
  .dac0_i             (kif_ch0_dac_i          ),
  .dac0_q             (kif_ch0_dac_q          ),
  .dac1_on            (fb_ch1_dac_on          ),
  .dac1_i             (kif_ch1_dac_i          ),
  .dac1_q             (kif_ch1_dac_q          ),
  .adc0_on            (fb_ch0_adc_on          ),
  .adc0_i             (kif_ch0_adc_i          ),
  .adc0_q             (kif_ch0_adc_q          ),
  .adc1_on            (fb_ch1_adc_on          ),
  .adc1_i             (kif_ch1_adc_i          ),
  .adc1_q             (kif_ch1_adc_q          )
);

//******************************************************************************
// ADC/DAC IQ compensation
//******************************************************************************
iqcomp u_iqcomp_dac0 (
  .rst_n      (fe_rst_n       ),
  .clk        (fe_clk         ),
  //
  .gcos       (regb_gcos_dac0 ),
  .gsin       (regb_gsin_dac0 ),
  //
  .in_i       (fb_ch0_dac_i   ),
  .in_q       (fb_ch0_dac_q   ),
  //
  .out_i      (kif_ch0_dac_i  ),
  .out_q      (kif_ch0_dac_q  )
);

iqcomp u_iqcomp_dac1 (
  .rst_n      (fe_rst_n       ),
  .clk        (fe_clk         ),
  //
  .gcos       (regb_gcos_dac1 ),
  .gsin       (regb_gsin_dac1 ),
  //
  .in_i       (fb_ch1_dac_i   ),
  .in_q       (fb_ch1_dac_q   ),
  //
  .out_i      (kif_ch1_dac_i  ),
  .out_q      (kif_ch1_dac_q  )
);

`ifdef RW_NX_FPGA_RX_IQCOMP_EN
iqcomp u_iqcomp_adc0 (
  .rst_n      (fe_rst_n       ),
  .clk        (fe_clk         ),
  //
  .gcos       (regb_gcos_adc0 ),
  .gsin       (regb_gsin_adc0 ),
  //
  .in_i       (kif_ch0_adc_i  ),
  .in_q       (kif_ch0_adc_q  ),
  //
  .out_i      (fb_ch0_adc_i   ),
  .out_q      (fb_ch0_adc_q   )
);

iqcomp u_iqcomp_adc1 (
  .rst_n      (fe_rst_n       ),
  .clk        (fe_clk         ),
  //
  .gcos       (regb_gcos_adc1 ),
  .gsin       (regb_gsin_adc1 ),
  //
  .in_i       (kif_ch1_adc_i  ),
  .in_q       (kif_ch1_adc_q  ),
  //
  .out_i      (fb_ch1_adc_i   ),
  .out_q      (fb_ch1_adc_q   )
);
`else
  assign fb_ch0_adc_i = kif_ch0_adc_i;
  assign fb_ch0_adc_q = kif_ch0_adc_q;
  assign fb_ch1_adc_i = kif_ch1_adc_i;
  assign fb_ch1_adc_q = kif_ch1_adc_q;
`endif

//******************************************************************************
// FPGA AHB infrastructure
//******************************************************************************
//  1 FPGA A registers   64KB  0x0000_0000 - 0x0000_FFFF
//  1 FPGA B registers   64KB  0x0001_0000 - 0x0001_FFFF
//  2 frame buffer Ch0   64KB  0x0002_0000 - 0x0002_FFFF
//  3 frame buffer Ch1   64KB  0x0003_0000 - 0x0003_FFFF
//  4 RESERVED           64KB  0x0004_0000 - 0x000F_FFFF
//******************************************************************************
//sign fpga_hsel_rega    = fpga_hsel && fpga_haddr[19:16]==4'h0;
assign fpga_hsel_regb    = fpga_hsel && fpga_haddr[19:16]==4'h1;
assign fpga_hsel_fbch0   = fpga_hsel && fpga_haddr[19:16]==4'h2;
assign fpga_hsel_fbch1   = fpga_hsel && fpga_haddr[19:16]==4'h3;
assign fpga_hsel_default = ~(fpga_hsel_fbch0|fpga_hsel_fbch1|
                             fpga_hsel_regb /*|fpga_hsel_rega*/ );
//------------------------------------------------------------------------------
// AHB Read Data Mux
//------------------------------------------------------------------------------
always @(posedge plf_clk or negedge plf_rst_n)
   if(!plf_rst_n)
   begin
//    fpga_hsel_rega_1t    <= 1'b0;
      fpga_hsel_regb_1t    <= 1'b0;
      fpga_hsel_fbch0_1t   <= 1'b0;
      fpga_hsel_fbch1_1t   <= 1'b0;
      fpga_hsel_default_1t <= 1'b0;
   end
   else if(fpga_hready==1'b1 && fpga_htrans[1]==1'b1)
   begin
//    fpga_hsel_rega_1t    <= fpga_hsel_rega;
      fpga_hsel_regb_1t    <= fpga_hsel_regb;
      fpga_hsel_fbch0_1t   <= fpga_hsel_fbch0;
      fpga_hsel_fbch1_1t   <= fpga_hsel_fbch1;
      fpga_hsel_default_1t <= fpga_hsel_default;
   end

assign fpga_hready = fpga_hready_fbch0 & fpga_hready_fbch1 & 
                     fpga_hready_regb/*  & fpga_hready_rega*/;

assign {fpga_hresp,fpga_hrdata} =
    {34{fpga_hsel_fbch0_1t  }} & {fpga_hresp_fbch0,fpga_hrdata_fbch0} |
    {34{fpga_hsel_fbch1_1t  }} & {fpga_hresp_fbch1,fpga_hrdata_fbch1} |
    {34{fpga_hsel_regb_1t   }} & {fpga_hresp_regb ,fpga_hrdata_regb } |
  /*{34{fpga_hsel_rega_1t   }} & {fpga_hresp_rega ,fpga_hrdata_rega } |*/
    {34{fpga_hsel_default_1t}} & {2'b00           ,32'hdead5555     } ;



`ifdef  FRAMEBUFFER
//******************************************************************************
// Frame buffer
//******************************************************************************
karst_frame_buffer u_karst_frame_buffer (
  //----------------------------------------------------------------------------
  // clock & reset
  //----------------------------------------------------------------------------
  .ahb_rst_n            (plf_rst_n            ),
  .ahb_clk              (plf_clk              ),
  .fe_rst_n             (fe_rst_n             ),
  .fe_clk               (fe_clk               ),
  //----------------------------------------------------------------------------
  // AHB interface
  //----------------------------------------------------------------------------
  .hready_in            (fpga_hready          ),
  .hsel_ch0             (fpga_hsel_fbch0      ),
  .hsel_ch1             (fpga_hsel_fbch1      ),
  .haddr                (fpga_haddr[15:0]     ),
  .htrans               (fpga_htrans          ),
  .hwrite               (fpga_hwrite          ),
  .hwdata               (fpga_hwdata          ),
  .hrdata_ch0           (fpga_hrdata_fbch0    ),
  .hresp_ch0            (fpga_hresp_fbch0     ),
  .hready_ch0           (fpga_hready_fbch0    ),
  .hrdata_ch1           (fpga_hrdata_fbch1    ),
  .hresp_ch1            (fpga_hresp_fbch1     ),
  .hready_ch1           (fpga_hready_fbch1    ),
  //----------------------------------------------------------------------------
  // Frame buffer
  //----------------------------------------------------------------------------
  .regb_ch0_playback_en (regb_ch0_playback_en ),
  .regb_ch1_playback_en (regb_ch1_playback_en ),
  .regb_playback_count  (regb_playback_count  ),
  .regb_ch0_capture_en  (regb_ch0_capture_en  ),
  .regb_ch1_capture_en  (regb_ch1_capture_en  ),
  .regb_capture_done    (regb_capture_done    ),
  //----------------------------------------------------------------------------
  // Phy Interface
  //----------------------------------------------------------------------------
  .phy_ch0_adc_on       (pathmux_ch0_adc_on   ),
  .phy_ch0_adc_i        (pathmux_ch0_adc_i    ),
  .phy_ch0_adc_q        (pathmux_ch0_adc_q    ),
  .phy_ch1_adc_on       (pathmux_ch1_adc_on   ),
  .phy_ch1_adc_i        (pathmux_ch1_adc_i    ),
  .phy_ch1_adc_q        (pathmux_ch1_adc_q    ),
  .phy_ch0_trsw         (pathmux_ch0_trsw     ),
  .phy_ch0_pa2g         (pathmux_ch0_pa2g     ),
  .phy_ch0_pa5g         (pathmux_ch0_pa5g     ),
  .phy_ch0_dac_on       (pathmux_ch0_dac_on   ),
  .phy_ch0_dac_i        (pathmux_ch0_dac_i    ),
  .phy_ch0_dac_q        (pathmux_ch0_dac_q    ),
  .phy_ch1_trsw         (pathmux_ch1_trsw     ),
  .phy_ch1_pa2g         (pathmux_ch1_pa2g     ),
  .phy_ch1_pa5g         (pathmux_ch1_pa5g     ),
  .phy_ch1_dac_on       (pathmux_ch1_dac_on   ),
  .phy_ch1_dac_i        (pathmux_ch1_dac_i    ),
  .phy_ch1_dac_q        (pathmux_ch1_dac_q    ),
  //----------------------------------------------------------------------------
  // Karst Interface
  //----------------------------------------------------------------------------
  .karst_ch0_adc_on     (fb_ch0_adc_on        ),
  .karst_ch0_adc_i      (fb_ch0_adc_i         ),
  .karst_ch0_adc_q      (fb_ch0_adc_q         ),
  .karst_ch1_adc_on     (fb_ch1_adc_on        ),
  .karst_ch1_adc_i      (fb_ch1_adc_i         ),
  .karst_ch1_adc_q      (fb_ch1_adc_q         ),
  .karst_ch0_trsw       (fb_ch0_trsw          ),
  .karst_ch0_pa2g       (fb_ch0_pa2g          ),
  .karst_ch0_pa5g       (fb_ch0_pa5g          ),
  .karst_ch0_dac_on     (fb_ch0_dac_on        ),
  .karst_ch0_dac_i      (fb_ch0_dac_i         ),
  .karst_ch0_dac_q      (fb_ch0_dac_q         ),
  .karst_ch1_trsw       (fb_ch1_trsw          ),
  .karst_ch1_pa2g       (fb_ch1_pa2g          ),
  .karst_ch1_pa5g       (fb_ch1_pa5g          ),
  .karst_ch1_dac_on     (fb_ch1_dac_on        ),
  .karst_ch1_dac_i      (fb_ch1_dac_i         ),
  .karst_ch1_dac_q      (fb_ch1_dac_q         )
);
`endif//FRAMEBUFFER

//******************************************************************************
// Frame Buffer not implemented
//******************************************************************************
`ifndef FRAMEBUFFER
assign fpga_hrdata_fbch0      = 32'hdeaddead;
assign fpga_hresp_fbch0       =  2'b0;
assign fpga_hready_fbch0      =  1'b1;

assign fpga_hrdata_fbch1      = 32'hdeaddead;
assign fpga_hresp_fbch1       =  2'b0;
assign fpga_hready_fbch1      =  1'b1;

assign regb_capture_done      =  1'b0;

// pipeline rf->riu
reg [11:0] nofb_ch0_adc_i,  nofb_ch1_adc_i;
reg [11:0] nofb_ch0_adc_q,  nofb_ch1_adc_q;

always @(posedge fe_clk)
begin
   nofb_ch0_adc_i <= fb_ch0_adc_i;
   nofb_ch0_adc_q <= fb_ch0_adc_q;
   nofb_ch1_adc_i <= fb_ch1_adc_i;
   nofb_ch1_adc_q <= fb_ch1_adc_q;
end

assign pathmux_ch0_adc_i = nofb_ch0_adc_i;
assign pathmux_ch0_adc_q = nofb_ch0_adc_q;
assign pathmux_ch1_adc_i = nofb_ch1_adc_i;
assign pathmux_ch1_adc_q = nofb_ch1_adc_q;

// pipeline riu->rf
reg        nofb_ch0_adc_on, nofb_ch1_adc_on;
reg        nofb_ch0_trsw,   nofb_ch1_trsw;
reg        nofb_ch0_pa2g,   nofb_ch1_pa2g;
reg        nofb_ch0_pa5g,   nofb_ch1_pa5g;
reg        nofb_ch0_dac_on, nofb_ch1_dac_on;
reg [11:0] nofb_ch0_dac_i,  nofb_ch1_dac_i;
reg [11:0] nofb_ch0_dac_q,  nofb_ch1_dac_q;

always @(posedge fe_clk)
begin
   nofb_ch0_adc_on <= pathmux_ch0_adc_on;
   nofb_ch0_trsw   <= pathmux_ch0_trsw;
   nofb_ch0_pa2g   <= pathmux_ch0_pa2g;
   nofb_ch0_pa5g   <= pathmux_ch0_pa5g;
   nofb_ch0_dac_on <= pathmux_ch0_dac_on;
   nofb_ch0_dac_i  <= pathmux_ch0_dac_i;
   nofb_ch0_dac_q  <= pathmux_ch0_dac_q;
   nofb_ch1_adc_on <= pathmux_ch1_adc_on;
   nofb_ch1_trsw   <= pathmux_ch1_trsw;
   nofb_ch1_pa2g   <= pathmux_ch1_pa2g;
   nofb_ch1_pa5g   <= pathmux_ch1_pa5g;
   nofb_ch1_dac_on <= pathmux_ch1_dac_on;
   nofb_ch1_dac_i  <= pathmux_ch1_dac_i;
   nofb_ch1_dac_q  <= pathmux_ch1_dac_q;
end

assign fb_ch0_adc_on = nofb_ch0_adc_on | regb_ch0_capture_en;
assign fb_ch0_trsw   = nofb_ch0_trsw;
assign fb_ch0_pa2g   = nofb_ch0_pa2g;
assign fb_ch0_pa5g   = nofb_ch0_pa5g;
assign fb_ch0_dac_on = nofb_ch0_dac_on;
assign fb_ch0_dac_i  = nofb_ch0_dac_i;
assign fb_ch0_dac_q  = nofb_ch0_dac_q;
assign fb_ch1_adc_on = nofb_ch1_adc_on | regb_ch1_capture_en;
assign fb_ch1_trsw   = nofb_ch1_trsw;
assign fb_ch1_pa2g   = nofb_ch1_pa2g;
assign fb_ch1_pa5g   = nofb_ch1_pa5g;
assign fb_ch1_dac_on = nofb_ch1_dac_on;
assign fb_ch1_dac_i  = nofb_ch1_dac_i;
assign fb_ch1_dac_q  = nofb_ch1_dac_q;
`endif//FRAMEBUFFER


//******************************************************************************
// FPGA register bank
//******************************************************************************
rw_he_v7_reg u_rw_he_v7_reg(
  //----------------------------------------------------------------------------
  // Clock and reset
  //----------------------------------------------------------------------------
  .ahb_nrst                    (plf_rst_n                                    ),
  .ahb_clk                     (plf_clk                                      ),
  //----------------------------------------------------------------------------
  // Registers
  //----------------------------------------------------------------------------
  .fpga_signature              (fpga_signature                               ),
  .fpga_date                   (fpga_date                                    ),
  //----------------------------------------------------------------------------
  .fb_capture_done             (regb_capture_done                            ),
  //----------------------------------------------------------------------------
  .adc_spi_done                (regb_adc_spi_done                            ),
  .adc_spi_rdata               (regb_adc_spi_rdata                           ),
  //----------------------------------------------------------------------------
  .dac_spi_done                (regb_dac_spi_done                            ),
  .dac_spi_rdata               (regb_dac_spi_rdata                           ),
  //----------------------------------------------------------------------------
  .diag0_stat                  (32'h0                                        ),
  .diag1_stat                  (32'h0                                        ),
  .diag2_stat                  (32'h0                                        ),
  .diag3_stat                  (32'h0                                        ),
  .diag4_stat                  (32'h0                                        ),
  //----------------------------------------------------------------------------
  .doorbell_int_status         (doorbell_int_status                          ),
  .doorbell_int_clear_in       (1'b0                                         ),
  .doorbell_int_clear_in_valid (doorbell_int_clear                           ),
  .doorbell_int_set_in         (1'b0                                         ),
  .doorbell_int_set_in_valid   (doorbell_int_set                             ),
  //----------------------------------------------------------------------------
  .v7_gpio_en                  (v7_gpio_en                                   ),
  .v7_gpio6                    (v7_gpio6                                     ),
  .v7_gpio5                    (v7_gpio5                                     ),
  .v7_gpio3                    (v7_gpio3                                     ),
  .v7_gpio2                    (v7_gpio2                                     ),
  .v7_gpio1                    (v7_gpio1                                     ),
  .v7_gpio0                    (v7_gpio0                                     ),
  //----------------------------------------------------------------------------
  .iodelay_done                (regb_iodelay_done                            ),
  //----------------------------------------------------------------------------
  .rf_spi_done                 (regb_rf_spi_done                             ),
  .rf_spi_rdata                (regb_rf_spi_rdata                            ),
  .rf_irq                      ({7'b0,karst_rf_interrupt}                    ),
  //----------------------------------------------------------------------------
  .svnrev_modem                (svnrev_modem                                 ),
  .svnrev_fpgab                (svnrev_fpgab                                 ),
  //----------------------------------------------------------------------------
  .mictor2_sel                 (regb_mictor2_sel                             ),
  .mictor1_sel                 (regb_mictor1_sel                             ),
  .mictor0_sel                 (regb_mictor0_sel                             ),
  //----------------------------------------------------------------------------
  .fb_capture_en               ({regb_ch1_capture_en , regb_ch0_capture_en } ),
  .fb_playback_en              ({regb_ch1_playback_en, regb_ch0_playback_en} ),
  .fb_playback_count           (regb_playback_count                          ),
  .fb_pathmux_sel              (regb_pathmux_sel                             ),
  //----------------------------------------------------------------------------
  .adc_spi_prescaler           (regb_adc_spi_prescaler                       ),
  .adc_spi_autopower           (regb_adc_autopower_en                        ),
  .adc_spi_start               (regb_adc_spi_start                           ),
  .adc_spi_we                  (regb_adc_spi_we                              ),
  .adc_spi_sel                 (regb_adc_spi_sel                             ),
  .adc_spi_addr                (regb_adc_spi_addr                            ),
  .adc_spi_wdata               (regb_adc_spi_wdata                           ),
  //----------------------------------------------------------------------------
  .dac_spi_prescaler           (regb_dac_spi_prescaler                       ),
  .dac_reset                   (regb_dac_reset                               ),
  .dac_spi_autopower           (regb_dac_autopower_en                        ),
  .dac_spi_start               (regb_dac_spi_start                           ),
  .dac_spi_we                  (regb_dac_spi_we                              ),
  .dac_spi_sel                 (regb_dac_spi_sel                             ),
  .dac_spi_addr                (regb_dac_spi_addr                            ),
  .dac_spi_wdata               (regb_dac_spi_wdata                           ),
  .dac_powerup                 (regb_dac_autopower_powerup                   ),
  .dac_powerdown               (regb_dac_autopower_powerdn                   ),
  //----------------------------------------------------------------------------
  .doorbell_int_clear          (doorbell_int_clear                           ),
  .doorbell_int_set            (doorbell_int_set                             ),
  .doorbell_int_mask           (doorbell_int_mask                            ),
  //----------------------------------------------------------------------------
  .iodelay_start               (regb_iodelay_start                           ),
  .iodelay_adc0                (regb_iodelay_adc0                            ),
  .iodelay_dac0                (regb_iodelay_dac0                            ),
  .iodelay_adc1                (regb_iodelay_adc1                            ),
  .iodelay_dac1                (regb_iodelay_dac1                            ),
  //----------------------------------------------------------------------------
  .gcos_adc0                   (regb_gcos_adc0                               ),
  .gsin_adc0                   (regb_gsin_adc0                               ),
  .gcos_dac0                   (regb_gcos_dac0                               ),
  .gsin_dac0                   (regb_gsin_dac0                               ),
  .gcos_adc1                   (regb_gcos_adc1                               ),
  .gsin_adc1                   (regb_gsin_adc1                               ),
  .gcos_dac1                   (regb_gcos_dac1                               ),
  .gsin_dac1                   (regb_gsin_dac1                               ),
  //----------------------------------------------------------------------------
  .rf_spi_prescaler            (regb_rf_spi_prescaler                        ),
  .rf_spi_start                (regb_rf_spi_start                            ),
  .rf_spi_we                   (regb_rf_spi_we                               ),
  .rf_spi_sel                  (/*Open*/                                     ),
  .rf_spi_addr                 (regb_rf_spi_addr                             ),
  .rf_spi_wdata                (regb_rf_spi_wdata                            ),
  .rf_force_en                 (regb_rf_force_en                             ),
  .rf_force                    (regb_rf_force                                ),
  .rf_gpio                     (regb_rf_gpio                                 ),
  //----------------------------------------------------------------------------
  // Bus interface
  //----------------------------------------------------------------------------
  .hready_in                   (1'b1                                         ),
  .hsel                        (fpga_hsel_regb                               ),
  .haddr                       (fpga_haddr[10:0]                             ),
  .htrans                      (fpga_htrans                                  ),
  .hwrite                      (fpga_hwrite                                  ),
  .hwdata                      (fpga_hwdata                                  ),
  .hrdata                      (fpga_hrdata_regb                             ),
  .hresp                       (fpga_hresp_regb                              ),
  .hready                      (fpga_hready_regb                             )
);
  

//******************************************************************************
// ad9613_controller (ADC)
//******************************************************************************
ad9613_ctrl u_ad9613_ctrl (
  //----------------------------------------------------------------------------
  // Clock and reset
  //----------------------------------------------------------------------------
  .rst_n                  (ref80_rst_n               ),
  .clk                    (ref80_clk                 ),
  //----------------------------------------------------------------------------
  // Dynamic Control Interface
  //----------------------------------------------------------------------------
  .adc0_on                (fb_ch0_adc_on             ),
  .adc1_on                (fb_ch1_adc_on             ),
  //----------------------------------------------------------------------------
  // Register Interface
  //----------------------------------------------------------------------------
  .regb_adc_autopower_en  (regb_adc_autopower_en     ),
  .regb_adc_spi_prescaler (regb_adc_spi_prescaler    ),
  .regb_adc_spi_sel       (regb_adc_spi_sel[1:0]     ),
  .regb_adc_spi_start     (regb_adc_spi_start        ),
  .regb_adc_spi_we        (regb_adc_spi_we           ),
  .regb_adc_spi_addr      (regb_adc_spi_addr[12:0]   ),
  .regb_adc_spi_wdata     (regb_adc_spi_wdata[7:0]   ),
  .regb_adc_spi_rdata     (regb_adc_spi_rdata[7:0]   ),
  .regb_adc_spi_done      (regb_adc_spi_done         ),
  //----------------------------------------------------------------------------
  // Serial Interface
  //----------------------------------------------------------------------------
  .adc_pwdown0            (karst_adc0_pdwn           ),
  .adc_pwdown1            (karst_adc1_pdwn           ),
  .adc_spi_csn0           (karst_adc_spi_csn0        ),
  .adc_spi_csn1           (karst_adc_spi_csn1        ),
  .adc_spi_clk            (karst_adc_spi_clk         ),
  .adc_spi_miso           (karst_adc_spi_miso        ),
  .adc_spi_mosi           (karst_adc_spi_mosi_pretri ),
  .adc_spi_oe             (karst_adc_spi_oe          )
);

assign karst_adc_spi_mosi = karst_adc_spi_oe ? karst_adc_spi_mosi_pretri : 1'bz;
`ifndef RW_RF_CACTUS
/* no spi read back on old karst rf board */
assign karst_adc_spi_miso = 1'b0;
`endif//RW_RF_CACTUS

assign regb_adc_spi_rdata[15:8] = 8'b0;

//******************************************************************************
// ad9613_controller (DAC)
//******************************************************************************
// The controller contains an autopower mode needing a fast enough clock.
// Use 80 MHz as it is the highest clock frequency supported by the SPI.
ad9780_ctrl u_ad9780_ctrl (
  //----------------------------------------------------------------------------
  // Clock and reset
  //----------------------------------------------------------------------------
  .rst_n                      (ref80_rst_n                      ),
  .clk                        (ref80_clk                        ),
  //----------------------------------------------------------------------------
  // Dynamic Control Interface
  //----------------------------------------------------------------------------
  .dac0_on                    (fb_ch0_dac_on                    ),
  .dac1_on                    (fb_ch1_dac_on                    ),
  //----------------------------------------------------------------------------
  // Register Interface
  //----------------------------------------------------------------------------
  .regb_dac_reset             (regb_dac_reset                   ),
  .regb_dac_autopower_en      (regb_dac_autopower_en            ),
  .regb_dac_autopower_powerup (regb_dac_autopower_powerup[12:0] ),
  .regb_dac_autopower_powerdn (regb_dac_autopower_powerdn[12:0] ),
  .regb_dac_spi_prescaler     (regb_dac_spi_prescaler           ),
  .regb_dac_spi_sel           (regb_dac_spi_sel[1:0]            ),
  .regb_dac_spi_start         (regb_dac_spi_start               ),
  .regb_dac_spi_we            (regb_dac_spi_we                  ),
  .regb_dac_spi_addr          (regb_dac_spi_addr[4:0]           ),
  .regb_dac_spi_wdata         (regb_dac_spi_wdata[7:0]          ),
  .regb_dac_spi_rdata         (regb_dac_spi_rdata[7:0]          ),
  .regb_dac_spi_done          (regb_dac_spi_done                ),
  //----------------------------------------------------------------------------
  // Serial Interface
  //----------------------------------------------------------------------------
  .dac_reset                  (karst_dac_reset                  ),
  .dac_spi_csn0               (karst_dac_spi_csn0               ),
  .dac_spi_csn1               (karst_dac_spi_csn1               ),
  .dac_spi_clk                (karst_dac_spi_clk                ),
  .dac_spi_miso               (karst_dac_spi_miso               ),
  .dac_spi_mosi               (karst_dac_spi_mosi_pretri        ),
  .dac_spi_oe                 (karst_dac_spi_oe                 )
);

assign karst_dac_spi_mosi = karst_dac_spi_oe ? karst_dac_spi_mosi_pretri : 1'bz;
assign karst_dac0_reset   = karst_dac_reset;
assign karst_dac1_reset   = karst_dac_reset;

assign regb_dac_spi_rdata[15:8] = 8'b0;

//******************************************************************************
// PATHMUX
//
// 2x2: no path mux, path muxing shall be handled withing the RIU
// 1x1: RIU is one path only, because fpga harware infrstructure is always 2x2,
//      the path muxing is done in between RIU and frame_buffer.
//
//******************************************************************************
`ifdef  RW_NX_DERIV_FE_PATH1
  /* 2x2 */

  /* $todo: drop the triplet (riu_dac_on,riu_ch0_dac_enable,riu_ch1_dac_enable)
            and have a couple (riu_ch0_dac_on,riu_ch0_dac_on) in the riu */
  assign riu_dac_data_enable    = riu_ch0_dac_enable | riu_ch1_dac_enable;

  assign pathmux_ch0_adc_on     = riu_ch0_adc_on;
  assign riu_ch0_adc_i          = pathmux_ch0_adc_i;
  assign riu_ch0_adc_q          = pathmux_ch0_adc_q;

  assign pathmux_ch0_dac_on     = riu_ch0_dac_on;
  assign pathmux_ch0_dac_enable = riu_ch0_dac_enable;
  assign pathmux_ch0_dac_i      = riu_ch0_dac_i;
  assign pathmux_ch0_dac_q      = riu_ch0_dac_q;

  assign pathmux_ch0_trsw       = riu_ch0_trsw;
  assign pathmux_ch0_pa5g       = riu_ch0_pa5g;
  assign pathmux_ch0_pa2g       = riu_ch0_pa2g;


  assign pathmux_ch1_adc_on     = riu_ch1_adc_on;
  assign riu_ch1_adc_i          = pathmux_ch1_adc_i;
  assign riu_ch1_adc_q          = pathmux_ch1_adc_q;

  assign pathmux_ch1_dac_on     = riu_ch1_dac_on;
  assign pathmux_ch1_dac_enable = riu_ch1_dac_enable;
  assign pathmux_ch1_dac_i      = riu_ch1_dac_i;
  assign pathmux_ch1_dac_q      = riu_ch1_dac_q;

  assign pathmux_ch1_trsw       = riu_ch1_trsw;
  assign pathmux_ch1_pa5g       = riu_ch1_pa5g;
  assign pathmux_ch1_pa2g       = riu_ch1_pa2g;

`else //RW_NX_DERIV_FE_PATH1

  assign riu_dac_data_enable    = riu_ch0_dac_enable;

  assign pathmux_ch0_adc_on     = (regb_pathmux_sel==4'd0) ? riu_ch0_adc_on     : 1'b0;
  assign riu_ch0_adc_i          = (regb_pathmux_sel==4'd0) ? pathmux_ch0_adc_i  : pathmux_ch1_adc_i;
  assign riu_ch0_adc_q          = (regb_pathmux_sel==4'd0) ? pathmux_ch0_adc_q  : pathmux_ch1_adc_q;

  assign pathmux_ch0_dac_on     = (regb_pathmux_sel==4'd0) ? riu_ch0_dac_on     : 1'b0;
  assign pathmux_ch0_dac_enable = (regb_pathmux_sel==4'd0) ? riu_ch0_dac_enable : 1'b0;
  assign pathmux_ch0_dac_i      = (regb_pathmux_sel==4'd0) ? riu_ch0_dac_i      : 12'b0;
  assign pathmux_ch0_dac_q      = (regb_pathmux_sel==4'd0) ? riu_ch0_dac_q      : 12'b0;

  assign pathmux_ch0_trsw       = (regb_pathmux_sel==4'd0) ? riu_ch0_trsw       : 1'b1;
  assign pathmux_ch0_pa5g       = (regb_pathmux_sel==4'd0) ? riu_ch0_pa5g       : 1'b0;
  assign pathmux_ch0_pa2g       = (regb_pathmux_sel==4'd0) ? riu_ch0_pa2g       : 1'b0;


  assign pathmux_ch1_adc_on     = (regb_pathmux_sel==4'd0) ? 1'b0               : riu_ch0_adc_on;

  assign pathmux_ch1_dac_on     = (regb_pathmux_sel==4'd0) ? 1'b0               : riu_ch0_dac_on;
  assign pathmux_ch1_dac_enable = (regb_pathmux_sel==4'd0) ? 1'b0               : riu_ch0_dac_enable;
  assign pathmux_ch1_dac_i      = (regb_pathmux_sel==4'd0) ? 12'b0              : riu_ch0_dac_i;
  assign pathmux_ch1_dac_q      = (regb_pathmux_sel==4'd0) ? 12'b0              : riu_ch0_dac_q;

  assign pathmux_ch1_trsw       = (regb_pathmux_sel==4'd0) ? 1'b1               : riu_ch0_trsw;
  assign pathmux_ch1_pa5g       = (regb_pathmux_sel==4'd0) ? 1'b0               : riu_ch0_pa5g;
  assign pathmux_ch1_pa2g       = (regb_pathmux_sel==4'd0) ? 1'b0               : riu_ch0_pa2g;

`endif//RW_NX_DERIV_FE_PATH1

//******************************************************************************
//
//******************************************************************************
reg host_irq_r0;
reg host_irq_r1;
reg host_irq_r2;

// assert 1cycle pulse for pcie interrupt controller
assign intx_msi_request = host_irq_r1 & ~host_irq_r2;

always@(posedge axi_aclk_out or negedge axi_por_n)
   if (!axi_por_n)
   begin
      host_irq_r0 <= 1'b0;
      host_irq_r1 <= 1'b0;
      host_irq_r2 <= 1'b0;
   end
   else
   begin
      host_irq_r0 <= host_irq;
      host_irq_r1 <= host_irq_r0;
      host_irq_r2 <= host_irq_r1;
   end

//******************************************************************************
// Diag Port interface
//******************************************************************************
// mictor output assignment
assign mictor1[33:32] = {reg_diag_trigger,1'b0};
assign mictor2[33:32] = {reg_diag_trigger,1'b0};
assign mictor1[31: 0] = {rw_nx_diag3,rw_nx_diag2};
assign mictor2[31: 0] = {rw_nx_diag5,rw_nx_diag4};

//******************************************************************************
// mictor0 source synchronous capture for external LA
//******************************************************************************
reg [33:0] mictor0_d1_m3t/* synthesis syn_preserve=1 */;
reg [33:0] mictor0_d1_m2t/* synthesis syn_preserve=1 */;
reg [33:0] mictor0_d1_m1t/* synthesis syn_preserve=1 */;
reg [33:0] mictor0_d2_m3t/* synthesis syn_preserve=1 */;
reg [33:0] mictor0_d2_m2t/* synthesis syn_preserve=1 */;
reg [33:0] mictor0_d2_m1t/* synthesis syn_preserve=1 */;
reg [33:0] mictor0_test;

/* pipeline */
always @(posedge fe_clk,negedge fe_rst_n)
begin
  if(!fe_rst_n)
  begin
    mictor0_test   <= 34'd1; 
    mictor0_d1_m3t <= 34'b0;
    mictor0_d1_m2t <= 34'b0;
    mictor0_d1_m1t <= 34'b0;
    mictor0_d2_m3t <= 34'b0;
    mictor0_d2_m2t <= 34'b0;
    mictor0_d2_m1t <= 34'b0;
  end
  else
  begin
    
    mictor0_test          <= {mictor0_test[0],mictor0_test[33:1]}; 
    mictor0_d1_m3t[32]    <= 1'b0; // reserved
    mictor0_d2_m3t[32]    <= 1'b0; // reserved
    mictor0_d1_m3t[31:30] <= macbypass_trigger;
    mictor0_d2_m3t[31:30] <= macbypass_trigger;
    mictor0_d1_m3t[29:24] <= {1'b1,rw_nx_ss_diag};
    mictor0_d2_m3t[29:24] <= {1'b0,rw_nx_ss_diag};

    /* first phase  */
    case(regb_mictor0_sel[7:0])
      8'd0:
      begin
        if(fb_ch0_dac_on)
        begin
          mictor0_d1_m3t[11: 0] <= kif_ch0_dac_i;
          mictor0_d1_m3t[23:12] <= kif_ch0_dac_q;
        end
        else
        begin
          mictor0_d1_m3t[11: 0] <= kif_ch0_adc_i;
          mictor0_d1_m3t[23:12] <= kif_ch0_adc_q;
        end
      end
     
      8'd1:
      begin
        if(fb_ch1_dac_on)
        begin
          mictor0_d1_m3t[11: 0] <= kif_ch1_dac_i;
          mictor0_d1_m3t[23:12] <= kif_ch1_dac_q;
        end
        else
        begin
          mictor0_d1_m3t[11: 0] <= kif_ch1_adc_i;
          mictor0_d1_m3t[23:12] <= kif_ch1_adc_q;
        end
      end
      
      8'd2:
      begin
        mictor0_d1_m3t[11: 0] <= kif_ch0_adc_i;
        mictor0_d1_m3t[23:12] <= kif_ch1_adc_i;
      end
   
      8'd3:
      begin
        mictor0_d1_m3t[11: 0] <= kif_ch0_adc_q;
        mictor0_d1_m3t[23:12] <= kif_ch1_adc_q;
      end
      
      8'd255:
      begin
        mictor0_d1_m3t <= mictor0_test;
      end
      
      default:
      begin
        mictor0_d1_m3t[11: 0] <= 12'b0;
        mictor0_d1_m3t[23:12] <= 12'b0;
      end      
    endcase

    /* second phase  */
    case(regb_mictor0_sel[15:8])
      8'd0:
      begin
        if(fb_ch0_dac_on)
        begin
          mictor0_d2_m3t[11: 0] <= kif_ch0_dac_i;
          mictor0_d2_m3t[23:12] <= kif_ch0_dac_q;
        end
        else
        begin
          mictor0_d2_m3t[11: 0] <= kif_ch0_adc_i;
          mictor0_d2_m3t[23:12] <= kif_ch0_adc_q;
        end
      end
     
      8'd1:
      begin
        if(fb_ch1_dac_on)
        begin
          mictor0_d2_m3t[11: 0] <= kif_ch1_dac_i;
          mictor0_d2_m3t[23:12] <= kif_ch1_dac_q;
        end
        else
        begin
          mictor0_d2_m3t[11: 0] <= kif_ch1_adc_i;
          mictor0_d2_m3t[23:12] <= kif_ch1_adc_q;
        end
      end
      
      8'd2:
      begin
        mictor0_d2_m3t[11: 0] <= kif_ch0_adc_i;
        mictor0_d2_m3t[23:12] <= kif_ch1_adc_i;
      end
    
      8'd3:
      begin
        mictor0_d2_m3t[11: 0] <= kif_ch0_adc_q;
        mictor0_d2_m3t[23:12] <= kif_ch1_adc_q;
      end
      
      8'd255:
      begin
        mictor0_d2_m3t <= ~mictor0_test;
      end
      
      default:
      begin
        mictor0_d2_m3t[11: 0] <= 12'b0;
        mictor0_d2_m3t[23:12] <= 12'b0;
      end      
    endcase
    
    /* pipeline data to pads */
    mictor0_d1_m2t <= mictor0_d1_m3t;
    mictor0_d2_m2t <= mictor0_d2_m3t;
    mictor0_d1_m1t <= mictor0_d1_m2t;
    mictor0_d2_m1t <= mictor0_d2_m2t;
  end
end  

/* data 33 bits*/
generate
begin:g_mictor0_pads
  genvar i;
  for(i=0;i<33;i=i+1)
  begin:u_oddr_mictor0
    ODDR #(
      .DDR_CLK_EDGE ("SAME_EDGE"    ),
      .INIT         (1'b0           ),
      .SRTYPE       ("SYNC"         )
    ) u_oddr_mictor0_32_0 (
      .Q            (mictor0[i]     ),
      .C            (fe_clk         ),
      .CE           (1'b1           ),
      .D1           (mictor0_d1_m1t[i] ),
      .D2           (mictor0_d2_m1t[i] ),
      .R            (1'b0           ),
      .S            (1'b0           )
    );
  end
end
endgenerate

/* clock */
ODDR #(
  .DDR_CLK_EDGE ("SAME_EDGE" ),
  .INIT         (1'b0        ),
  .SRTYPE       ("SYNC"      )
) u_oddr_mictor0_33 (
  .Q            (mictor0[33] ),
  .C            (fe_clk      ),
  .CE           (1'b1        ),
  .D1           (1'b1        ),
  .D2           (1'b0        ),
  .R            (1'b0        ),
  .S            (1'b0        )
);

//******************************************************************************
// Bluetooth Coexistence interface
//******************************************************************************
// Configure the level shifter direction for Coex/GPIOs interface
assign coex_bt_tied0 = 1'b0; 

assign coex_bt_pti_int[3] = v7_gpio_en ? 1'b0           : coex_bt_pti[3];
assign coex_bt_rx_int     = v7_gpio_en ? 1'b0           : coex_bt_rx;
assign coex_bt_tx_int     = v7_gpio_en ? 1'b0           : coex_bt_tx;
assign coex_bt_pti_int[2] = v7_gpio_en ? 1'b0           : coex_bt_pti[2];
assign coex_bt_event_int  = v7_gpio_en ? 1'b0           : coex_bt_event;

assign coex_bt_rx_abort   = v7_gpio_en ? v7_gpio5       : coex_bt_rx_abort_int;
assign coex_bt_tx_abort   = v7_gpio_en ? v7_gpio6       : coex_bt_tx_abort_int;

assign v7_gpio0           = v7_gpio_en ? coex_bt_pti[3] : 1'b0;
assign v7_gpio1           = v7_gpio_en ? coex_bt_rx     : 1'b0;
assign v7_gpio2           = v7_gpio_en ? coex_bt_tx     : 1'b0;
assign v7_gpio3           = v7_gpio_en ? coex_bt_pti[2] : 1'b0;


//******************************************************************************
// GPIO
//******************************************************************************
reg [31:0] led1=32'h0;
reg [31:0] led2=32'h0;
reg [31:0] led3=32'h0;
reg [31:0] led4=32'h0;
reg        led5=1'b0;
reg        led5_m2t/* synthesis syn_preserve=1 */=1'b0;
reg        led5_m1t/* synthesis syn_preserve=1 */=1'b0;

always@(posedge axi_aclk_out) led1 <= led1+1;
always@(posedge plf_clk)      led2 <= led2+1;
always@(posedge fe_clk)       led3 <= led3+1;
always@(posedge ref80_clk)    led4 <= led4+1;

always@(posedge plf_clk)      led5_m2t <= gpio_out[0];
always@(posedge plf_clk)      led5_m1t <= led5_m2t;
always@(posedge plf_clk)      led5     <= led5_m1t;

assign led[1] = led1[24];
assign led[2] = led2[25];
assign led[3] = led3[22];
assign led[4] = led4[23];
assign led[5] = led5;
assign led[6] = 1'b1;
assign led[7] = 1'b1;

assign gpio_in = 32'h0;

//******************************************************************************
// Clock & Reset
//******************************************************************************
wire [31:0] n_counter_pcie;
reg  [31:0] counter_pcie;

assign n_counter_pcie[31:28] = counter_pcie[31:28]+{3'd0,&counter_pcie[27:0]};
assign n_counter_pcie[27:24] = counter_pcie[27:24]+{3'd0,&counter_pcie[23:0]};
assign n_counter_pcie[23:20] = counter_pcie[23:20]+{3'd0,&counter_pcie[19:0]};
assign n_counter_pcie[19:16] = counter_pcie[19:16]+{3'd0,&counter_pcie[15:0]};
assign n_counter_pcie[15:12] = counter_pcie[15:12]+{3'd0,&counter_pcie[11:0]};
assign n_counter_pcie[11: 8] = counter_pcie[11: 8]+{3'd0,&counter_pcie[7:0]};
assign n_counter_pcie[ 7: 4] = counter_pcie[ 7: 4]+{3'd0,&counter_pcie[3:0]};
assign n_counter_pcie[ 3: 0] = counter_pcie[ 3: 0]+{3'd0,1'b1};

always@(posedge axi_aclk_out or negedge global_rst_n)
   if (!global_rst_n)
      counter_pcie <= 0;
   else if (counter_pcie < 120000)
      counter_pcie <= n_counter_pcie;

`ifdef  RW_SIMU_ON
assign rstn_long_pci = (counter_pcie< 1000 || counter_pcie> 1100); //active low reset
`else //RW_SIMU_ON
assign rstn_long_pci = (counter_pcie< 100000 || counter_pcie> 110000); //active low reset
`endif//RW_SIMU_ON

// Instantiate IBUF before the IBUFDS_GTE2.
//    no more inferred by Synplify_pro 2017.03-SP1
//    Needed by Vivado 2017.1 for Pins location constraints
IBUF clk_pcie_p_ibuf(
   .I          (clk_pcie_p     ),
   .O          (clk_pcie_p_buf )
);

IBUF clk_pcie_n_ibuf(
   .I          (clk_pcie_n     ),
   .O          (clk_pcie_n_buf )
);

IBUFDS_GTE2 clk_pcie_ibufds(
   .CEB        (1'b0           ),
   .I          (clk_pcie_p_buf ),
   .IB         (clk_pcie_n_buf ),
   .ODIV2      (               ),
   .O          (clk_pcie       )
);

assign sys_rst_n = rstn_long_pci  & global_rst_n;

//******************************************************************************
// Doorbell Demo
//******************************************************************************
reg [3:0] doorbell_switch_cleaner=4'h0;
always @(posedge plf_clk or negedge coex_bt_event)
begin
   if (~coex_bt_event)
   begin
      doorbell_switch_cleaner[3] <= 1'b1;
      doorbell_switch_cleaner[2] <= 1'b1;
   end
   else
   begin
      doorbell_switch_cleaner[3] <= 1'b0;
      doorbell_switch_cleaner[2] <= doorbell_switch_cleaner[3];
   end
end

always @(posedge plf_clk)
begin
   doorbell_switch_cleaner[1] <= doorbell_switch_cleaner[2];
   doorbell_switch_cleaner[0] <= doorbell_switch_cleaner[1];
end

always @(posedge plf_clk or negedge plf_rst_n)
begin
   if (~plf_rst_n)
      doorbell_int_status <= 1'b0;
   else if (doorbell_switch_cleaner[0] | doorbell_int_set)
      doorbell_int_status <= 1'b1;
   else if (doorbell_int_clear)
      doorbell_int_status <= 1'b0;
end

assign fpga_irq = doorbell_int_status & doorbell_int_mask;

endmodule
////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////
