////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) by RivieraWaves.
// This module is a confidential and proprietary property of RivieraWaves
// and a possession or use of this module requires written permission
// from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: jvanthou $
// Company : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 14759 $
// $Date: 2014-04-29 15:42:29 +0200 (Tue, 29 Apr 2014) $
//---------------------------------------------------------------------------
// Description : This File contains all the defines related to Test bench
// Parameters :
// Terms & concepts :
// Bugs :
// Open issues and future enhancements :
// Tasks and functions:
// interfaces :
// Revision History :
//---------------------------------------------------------------------------

`define RW_FPGA_SVNREV 1
`define RW_FPGA_TIME 1
`define RW_FPGA_DATE 1
`define RW_FPGA_SIGNATURE 1
`define RW_MAC_SVNREV 1


// Simulation defines
// Enables simulation debug registers in RTL
`define READWRITE_MESSAGES
// Clock
`ifndef MACPI_CLK_FREQ
  `define MACPI_CLK_PERIOD       5        // 100 MHz
`else
  `define MACPI_CLK_PERIOD    ( 500.00 / `MACPI_CLK_FREQ)
`endif

`ifdef MAC_FREQ
  `define MACCORE_CLK_PERIOD    (500.00 / `MAC_FREQ)
`else
  `define MACCORE_CLK_PERIOD    25.00       // This half period of 20 MHz used to generate MacCoreClk.
`endif

`ifdef WEP_2_BB_CLK_RATIO
  `define WT_CLK_PERIOD         (`MACCORE_CLK_PERIOD / `WEP_2_BB_CLK_RATIO)
`else
  `define WT_CLK_PERIOD         (`MACCORE_CLK_PERIOD / 3)     // three times macCore
`endif

`define MACLP_CLK_PERIOD      15625    // 32 Khz
`define SYS_CLK_PERIOD        2.08     // 240 Mhz
`define CLK_1MHZ_PERIOD       1000     // 1 Mhz
`define TXCORE_CLK_PERIOD     8.333    // 120 Mhz


`define   HOSTADDRWIDTH           31  //actually 32 (0 to 31)
`define   MAXBUFSIZE             100
`define   AHB                    1

`define PROB_OK    'd80
`define PROB_ERROR 'd10
`define PROB_RETRY 'd5
`define PROB_SPLIT 'd5
`define MAX_AHB_WAIT_CYCLES        4

// Tick defines related to AHB slave.
`define    MEMORY_BIT_LENGTH                31
`define    AHB_START_MEMORY_ADDR          32'h0000_0000
`define    AHB_END_MEMORY_ADDR            32'h0000_FFFF
`define    MAC_PHY_SIMS

// Rx Vector1 written by MAC Core in the Rx Hdr Descr
// is to be verified or not
`define    RXVEC1_CHK                      1'b1

// Rx Vector2 written by MAC Core in the Rx Hdr Descr
// is to be verified or not
`define    RXVEC2_CHK                      1'b0

// TSF written by MAC Core in the Rx Hdr Descr
// is to be verified or not
`define    TSF_CHK                         1'b1

//TSF difference tolerated between TSF Read from the
// TSF reg on rxEndForTiming_p signal to the TSF values
// written by the MAC core in the Rx Hdr Descr
`define    TSF_TOL                         2

//Viterbi inputs are to be verified or not
`define    VTB_IN_CHK                      1


// In order to follow guidelines all wires should be declared. No implicit
// wire declarations are allowed.
// Note: This comment has to be un-commented in final release, the TB should
// still not have warnings/errors
`default_nettype none

// Width of HDMCore Tx frontend
`define FEDATA_WIDTH       13
// for TX frontend data width: 2 times for I/Q data + 1 for enable
`define TXCOREDATA_WIDTH   (2*`FEDATA_WIDTH+1)

// Width of TX mapper in TXCORE
`define MAPDATA_WIDTH    13
`define MAPINDEX_WIDTH   10
`define SYMBCNT_WIDTH    32
// for TX MAPPER stream agent data width: 2 times I/Q width + index width
// + symbol count width
`define TXMAPDATA_WIDTH  (2*`MAPDATA_WIDTH+`MAPINDEX_WIDTH+`SYMBCNT_WIDTH)

// Width of TX scrambler in TXCORE
// tail+last+length+data
`define TXSCRBDATA_WIDTH (8+1+4+8)

// Width of TX bit parser in TXCORE
// last+length+data
`define TXBPARSDATA_WIDTH (1+4+8)

// Width of TX BCC in TXCORE
// last+length+data
`define TXBCCDATA_WIDTH (1+4+8)

// RX start delay (40us)
`define RX_PHY_START_DELAY  40

// aSlotTime (9us)
`define ASLOT_TIME  9

// define FFT interface placeholder
`define FFTIF_WIDTH      8

// define latency for FFT signal driving, in clock cycles
`ifdef RW_NX_CHBW20
  `define LATENCY_FFT64   354
  `define LATENCY_FFT128  467
  `define LATENCY_FFT256  723
  `define LATENCY_FFT512  723
  `define LATENCY_FFT1024 723
`elsif RW_NX_CHBW4020
  `define LATENCY_FFT64   128
  `define LATENCY_FFT128  396
  `define LATENCY_FFT256  500
  `define LATENCY_FFT512  1000
  `define LATENCY_FFT1024 1000
`elsif RW_NX_CHBW804020
  `define LATENCY_FFT64   128
  `define LATENCY_FFT128  396
  `define LATENCY_FFT256  462
  `define LATENCY_FFT512  1000
  `define LATENCY_FFT1024 1000 // TBD
`endif

`define LATENCY_FDDONE  240
`define LATENCY_FFTDONE  50
`define LATENCY_BDBUFRD  60

// convert HDL PATH name to string
`define STRINGIFY(x) `"x`"

// offset that is added to STAID when defSTA.txt is made
`ifndef STAID_OFFSET
  `define STAID_OFFSET 100
`endif//STAID_OFFSET

// register model dump file name, used when error occurs on Modem test case
`ifndef REGMODEL_DUMP_FILE
  `define REGMODEL_DUMP_FILE "regmodel_dump.txt"
`endif//REGMODEL_DUMP_FILE

// define that test is run with full WLAN system
`ifndef STANDALONE_PHY
  `ifndef STANDALONE_MAC
    `define FULL_WLAN_SYSTEM
  `endif
`endif

// Defines for accessing modules using hierarchial access. These are added for
// readability

`ifdef WLAN_HE_WITH_CPU
  `define TOP              wlan_top_tb.u_rw_he_top_cpu
`else
  `define TOP              wlan_top_tb
`endif//WLAN_HE_WITH_CPU
`define TOP_WRAPPER       `TOP.u_rw_he_top_wrapper
`define RW_HE_TOP         `TOP_WRAPPER.u_rw_he_top
`define RW_HE_CRM         `TOP_WRAPPER.u_rw_he_crm
`define RW_HE_PLATF       `RW_HE_TOP.u_rw_nx_platform
`define MAC_DUT           `RW_HE_TOP.u_rw_nx_platform.u_rwWlanNxMACHW
`define PHY_DUT           `RW_HE_TOP.u_hdm_core
`define HDM_TXCORE        `PHY_DUT.u_ofdm_tx_core
`define HDM_RXCORE        `PHY_DUT.u_ofdm_rx_core
`define PTA_DUT           `RW_HE_PLATF.u_rw_pta
`define RIUTOP            `RW_HE_TOP.u_RIUKarstTop
`define PHYCLK            `PHY_DUT.PhyClk
`define PHYFFT            `PHY_DUT.u_fft_memmux
`define RXFD_TOP          `HDM_RXCORE.u_RxFDTop
`define RXTD_TOP          `HDM_RXCORE.u_RxTDTop
`define EQU_TOP           `RXFD_TOP.U_EqualizerRX1SS1
`define RXBD_TOP          `HDM_RXCORE.u_ofdm_rx_bd
`define VTRB_TOP          `RXBD_TOP.u_viterbi0
`define LDPC_TOP          `RXBD_TOP.u_rx_bd_ldpc
`define VITERBI_TOP       `RXBD_TOP.u_viterbi0
// RTL paths for memories
`define TOP_MEMORIES      `TOP_WRAPPER.u_rw_he_memories
`define SHARED_RAM        `TOP_MEMORIES.u_sharedram.mem
`define SHARED_RAM_BUS    `TOP_MEMORIES.u_sharedram
`define BFMER_RAM         `TOP_MEMORIES.u_bfmer_ram.mem
`define BFMEE_RAM         `TOP_MEMORIES.u_bfmee_ram.mem
`define H_MEM             `TOP_MEMORIES.u_h_ram.mem

// IRQ related
`define PATH_TO_MAC_INTERRUPT_CTRL      `RW_HE_PLATF.u_rwWlanNxMACHW.U_intCtrl
`define PATH_TO_PLATFORM_INTERRUPT_CTRL `RW_HE_PLATF.int_cntl_0

// RLT path strings
`define DUT_STRING           `STRINGIFY(`RW_HE_TOP)
`define MAC_DUT_STRING       "u_rw_nx_platform.u_rwWlanNxMACHW"
`define MAC_DUT_REG_STRING   {`MAC_DUT_STRING,".U_macCSReg"}
`define PHY_DUT_STRING       "u_HDMCore"
`define RIUTOP_STRING        "u_RIUKarstTop"


// Default data width of the MAC-PHY IF data lines. The current configuration
// is only permitted upto 8-bits
`define PHY_TX_DATA_WIDTH 8
`define PHY_RX_DATA_WIDTH 8

// Number of bytes in Tx Vector
`define TX_VEC_BYTE_CNT 16

// Number of bytes in Rx Vector
`define RX_VEC_BYTE_CNT 15

// Number of bytes in Rx Vector 2
`define RX_VEC2_BYTE_CNT 8

// Width of the Radio Digital to Analog Converter lines
`define DACWIDTH 12

// Width of the Radio Analog to Digital Converter lines
`define ADCWIDTH 12

// PHY defines
`define   NUM_ENCODING_STREAM   1 //NES is 1 if PHY rate is less than 300MBPS

//AGC Lock time
`define AGC_LOCK_TIME                     4.8

// Indicates if the Automatic Gain Control circuit in the PHY RTL is enabled
`define AGC_ON  1
// `define BYPASS  0

// Indicates that AGC has been disabled thus BYPASS logic should be enabled
// This should be commeneted if AGC_ON is 1
//`define BYPASS

// The number of I and Q samples to be read from the Matlab files at a time
// Increasing this would increase memory usage, decreases this increses
// frequency of disk access
`define RXIQMEMDEPTH 1

// LNA gain settling time, 1 micro sec
`define   LNA_GAIN_SETTLING_TIME_NS         350 //1000 ns

// VGA gain settling time, 0.7 micro sec
`define   VGA_GAIN_SETTLING_TIME_NS        100 //700 ns

`define LONG_ADDR_WIDTH   6
`define LONG_DATA_WIDTH   24

`define SHORT_ADDR_WIDTH  3
`define SHORT_DATA_WIDTH  10

// The width of the SB wires
`define DEMAPSBWIDTH      24
`define SBSTREAMWIDTH     5
`define CARRIERNBWIDTH    10
`define LDPCLENWIDTH      4
`define LDPCSBWIDTH       5
`define LDPCDATAWIDTH     8
`define VITERBILENWIDTH   4
`define VITERBISBWIDTH    5
`define VITERBIDATAWIDTH  2

// 8 SB per 2 SS
`define DEINTERWIDTH      (`SBSTREAMWIDTH*10*2+`CARRIERNBWIDTH)

// 8 Decompressed SB bits per SS
`define EQUWIDTH          (`DEMAPSBWIDTH*10+`CARRIERNBWIDTH)

// 8 SB for LDPC
`define LDPCWIDTH         (`LDPCSBWIDTH*10+`LDPCLENWIDTH)

// The number of signals (InputSoftMetrics[4:0] + ContentChannel)
`define VITERBIWIDTH      (`VITERBISBWIDTH*4 + 1)
// content channel mux signal
`define VITERBICONTCH     (`VITERBIWIDTH-1)

//////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// This block has macros used to execute any commands in the command-line.
// To use this macro dirListFp must be declared as integer in the module

// The macro takes as an argument a string. The string is writtern to a file
// and executed. This macro should be called in the following syntax
//    `shell_exec ({
//                 "Command 1\n",
//                 "Command 2\n",
//                     .
//                     .
//                 "Command n\n"
//                 }
//                );
//
// For example, this will print "Hello World" to the standard output
//   `shell_exec("echo 'Hello World'\n");
//
// No verilog special characters should be used, like " (double-quotes).
// ' (single quote) can be used instead. Proper escaping of other special
// charaters should be done to prevent from expansion
`define shell_exec(cmdString)                                           \
  /* dirlist.txt is a command file, all shell commands are put     */   \
  /* into the file, and file is executed from shell. All commands  */   \
  /* writtern within it will be executed                           */   \
  /* NOTE: dirListFp must be declared outside as integer for this  */   \
  /* to work properly                                              */   \
  dirListFp = $fopen("dirlist.txt","w");                                \
                                                                        \
  /* If file cannot be opened                                     */    \
  if (dirListFp == 0) begin                                             \
    `uvm_fatal(get_type_name(),"Unable to open dirlist.txt");           \
  end                                                                   \
                                                                        \
  /* Write the string to the file, all \n are converted to new    */    \
  /* lines. Each line will thus have one command                  */    \
  $fwrite(dirListFp,"%0s",cmdString);                                   \
                                                                        \
  /* Close the file                                              */     \
  $fclose(dirListFp);                                                   \
                                                                        \
  /* Call PLI to execute the commands in the file dirlist.txt    */     \
  /* Semi-colon is purposely removed, thus while using the       */     \
  /* macro the user has to put ';' after the define,             */     \
  $shell_run()



//////////////////////////////////////////////////////////////////////
//These defines are used by host tasks
//////////////////////////////////////////////////////////////////////
`ifndef MEMMAP_OFFSET
  `define MEMMAP_OFFSET                   32'h0
`endif

`define    SRAMADDRSTART                  (32'h00000000 + `MEMMAP_OFFSET) // start address of SRAM
`define    SRAMADDREND                    (32'h007FFFFF + `MEMMAP_OFFSET) // end address of SRAM
`define    BFREPORTMEMSTART               (32'h00C05000 + `MEMMAP_OFFSET) // Beamformer memory start address
`define    BFREPORTMEMEND                 (32'h00C08FFC + `MEMMAP_OFFSET) // Beamformer memory end address
`define    LDPCCFGMEMSTART                (32'h00C09000 + `MEMMAP_OFFSET) // LDPC CFG memory start address
`define    LDPCCFGMEMEND                  (32'h00C097CF + `MEMMAP_OFFSET) // LDPC CFG memory end address
`define    AGCMEMBASEADDR                 32'h00C00A00
`define    MACCOREBASEADDRESS             32'h00B00000 // for Host tasks
`define    MACPLBASEADDRESS               32'h00B08000 // for Host tasks
`define    PTABASEADDRESS                 32'h00920000
`define    PHYCONFIGBASEADDRESS           32'h00C00000
`define    PHYDSSSCONFIGBASEADDRESS       32'h00C00000
`define    PHYSTATUSBASEADDRESS           32'h00C00000
`define    RIUKARSTBASEADDRESS            32'h00C0B000
`define    RCKARSTBASEADDRESS             32'h00C0C000
`define    PTABASEADDRESS                 32'h00920000
`define    SYSCTRLBASEADDRESS             32'h00900000
`define    LABASEADDRESS                  32'h00E00000
`define    IPCEMBBASEADDRESS              32'h00800100
`define    IPCAPPBASEADDRESS              32'h00800000
`define    INTCBASEADDRESS                32'h00910000
`define    DMABASEADDRESS                 32'h00A00000
`define    CRMBASEADDRESS                 32'h00940000
`define    HSUBASEADDRESS                 32'h00930000
`define    MACBYPASSBASEADDRESS           32'h00C60000

`define    HARD_RESET_TIME                40000
`define    TIMEUNIT                       1

// The defines for the addresses used in testCases
`define    MAC_ADDRESS0                   48'h000000000000
`define    MAC_ADDRESS1                   48'h801122334454
`define    MAC_ADDRESS2                   48'h223344556676
`define    MACSIM_ADDR1                   48'h812233445566
`define    MACSIM_ADDR2                   48'h834455667788
`define    MACSIM_ADDR3                   48'h445566778898
`define    MACSIM_ADDR4                   48'h556677889810
`define    MACSIM_ADDR5                   48'h506070809810
`define    MACSIM_ADDR0                   48'h012345678900
`define    BROADCAST_ADDR                 48'hffffffffffff
`define    MULTICAST_ADDR                 48'h7bcdef010001

// The defines for different states of MAC
`define    IDLE_STATE                     4'b0000
`define    DOZE_STATE                     4'b0010
`define    ACTIVE_STATE                   4'b0011

// This define is used when the address can be anything
`define    IRRELEVANT                     'h0

// Defines used for different types of errors.
// These defines are used in the testCases.
`define    FCS_ERROR                      'd01
`define    ICV_ERROR                      'd02
`define    TWO_BYTE_SEQN                  'd03
`define    WRONG_SSID_LENGTH              'd04
`define    OWN_ELEMENT_ID1                'd05
`define    OWN_ELEMENT_ID2                'd06
`define    NO_ACK                         'd07
`define    PLCP_LENGTH_ERROR              'd08
`define    NO_ERROR                       'd0
`define    MIC_ERROR                      'd09

// PHY RTL config
`ifdef RW_NX_CHBW20
     `define   TXRFRAMPUP         240     // TX RF Ramp Up delay 4us
     `define   BW_PARAM_CONFIG    20
     `define   PHYCLKEDGECNT      3
     `define   MPIFCLKEDGECNT     7
`elsif RW_NX_CHBW4020
     `define   TXRFRAMPUP         480     // TX RF Ramp Up delay 4us
     `define   BW_PARAM_CONFIG    40
     `define   PHYCLKEDGECNT      1
     `define   MPIFCLKEDGECNT     3
`elsif RW_NX_CHBW804020
     `define   TXRFRAMPUP         480     // TX RF Ramp Up delay 4us
     `define   BW_PARAM_CONFIG    80
     `define   PHYCLKEDGECNT      1
     `define   MPIFCLKEDGECNT     3
`else
    `define   TXRFRAMPUP         240     // TX RF Ramp Up delay 4us
    `define   BW_PARAM_CONFIG    20
    `define   PHYCLKEDGECNT      3
    `define   MPIFCLKEDGECNT     7
`endif

// Time out defines

`define KSRAM_PGM_TO             10*2*`MACCORE_CLK_PERIOD



//Delays used in test cases
// Queues
`define    BCN_QUEUE        0
`define    AC0_QUEUE        1
`define    AC1_QUEUE        2
`define    AC2_QUEUE        3
`define    AC3_QUEUE        4
`define    RX_HDR_QUEUE     14
`define    RX_PLD_QUEUE     15



//waiting time after the state is changed and next action is taken
`define    CHG_STATE_DELAY        300

`define    ACTIVETX2IDLE_DELAY    50

`define   MATLAB_XTRA_SAMPLE      0       // Total no of zeros at the end of file


// SIFS
`define   SIFS_A                   16
`define   SIFS_B                   10
`define   MICRO_SEC                1000

// Max number of fragments, MSDU can have
`define    MAX_MPDU_FRAGS   16

// defines for Frame Bandwidth
`define    BW_20 2'd0
`define    BW_40 2'd1
`define    BW_80 2'd2

// Defines default macro for power estimation testcases
`define RW_TEST_BW   0
`define RW_TEST_SGI  2
`define RW_TEST_LDPC 0
`define RW_TEST_MCS  0

// Macro for adding callback to all fields of the specified register
`define ADD_CALLBACK_TO_REG_FIELDS(REG, CB) \
 begin \
  uvm_reg_field fields[$]; \
  REG.get_fields(fields); \
  foreach(fields[i]) begin \
   uvm_callbacks#(uvm_reg_field, uvm_reg_cbs)::add(fields[i], CB);  \
  end  \
 end

`define REG_CHANGE_POLICY(REG, POLICY) \
 begin \
  uvm_reg_field fields[$]; \
  REG.get_fields(fields); \
  foreach(fields[i]) begin \
   void'(fields[i].set_access(POLICY));  \
  end  \
 end


