#/////////////////////////////////////////////////////////////////////////////
#/  Copyright (C) by RivieraWaves.
#/  This module is a confidential and proprietary property of RivieraWaves
#/  and a possession or use of this module requires written permission
#/  from RivieraWaves.
#/----------------------------------------------------------------------------
#/ $Author: jvanthou $
#/ Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/ $Revision: 31094 $
#/ $Date: 2017-06-19 10:51:51 +0200 (Mon, 19 Jun 2017) $
#/ ---------------------------------------------------------------------------
#/ Dependencies     : None
#/ Description      : Full power estimation regression through all the configuration
#/ Application Note :
#/ Terms & concepts :
#/ Bugs             :
#/ Open issues and future enhancements :
#/ References       :
#/ Revision History :
#/ ---------------------------------------------------------------------------
#/
#/ $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_NX_REF_IP/HW/SIMS/run/power_fast_regression.sh $
#/
#/////////////////////////////////////////////////////////////////////////////  

CURRENTDATE=$(date +"%Y%m%d $S")

mkdir -p power_reports.$CURRENTDATE
ln -sf power_reports.$CURRENTDATE power_reports

config_STA_1x1_CBW20=1
config_STA_1x1_CBW20_LDPC=1
config_STA_1x1_CBW40_LDPC=1
config_STA_1x1_CBW80_LDPC=0

if [ $config_STA_1x1_CBW20 == 1 ]
then
# config_1x1_CBW20
RW_TEST_CONFIG=config_STA_1x1_CBW20
TESTCASE=test_wlan_rx_power
SIMRUN=simu.rx.power.run
RW_TEST_SEED=5
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_SEED=${RW_TEST_SEED} RW_TEST_BW=0 RW_TEST_LDPC=0 RW_TEST_MCS=0 RW_TEST_SGI=2 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_SEED=${RW_TEST_SEED} RW_TEST_BW=0 RW_TEST_LDPC=0 RW_TEST_MCS=9 RW_TEST_SGI=0 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
TESTCASE=test_wlan_tx_power
SIMRUN=simu.tx.power.run
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_SEED=${RW_TEST_SEED} RW_TEST_BW=0 RW_TEST_LDPC=0 RW_TEST_MCS=0 RW_TEST_SGI=2 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_SEED=${RW_TEST_SEED} RW_TEST_BW=0 RW_TEST_LDPC=0 RW_TEST_MCS=9 RW_TEST_SGI=0 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
TESTCASE=test_wlan_mac_state_change
SIMRUN=simu.state.power.run
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_BW=0 RW_TEST_LDPC=0 RW_TEST_MCS=4  RW_TEST_SGI=0 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
fi

if [ $config_STA_1x1_CBW20_LDPC == 1 ]
then
# config_STA_1x1_CBW20_LDPC
RW_TEST_CONFIG=config_STA_1x1_CBW20_LDPC
TESTCASE=test_wlan_rx_power
SIMRUN=simu.rx.power.run
RW_TEST_SEED=5
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_SEED=${RW_TEST_SEED} RW_TEST_BW=0 RW_TEST_LDPC=0 RW_TEST_MCS=0 1RW_TEST_SGI=2 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_SEED=${RW_TEST_SEED} RW_TEST_BW=0 RW_TEST_LDPC=1 RW_TEST_MCS=11 RW_TEST_SGI=0 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
TESTCASE=test_wlan_tx_power
SIMRUN=simu.tx.power.run
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_SEED=${RW_TEST_SEED} RW_TEST_BW=0 RW_TEST_LDPC=0 RW_TEST_MCS=0  RW_TEST_SGI=2 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_SEED=${RW_TEST_SEED} RW_TEST_BW=0 RW_TEST_LDPC=1 RW_TEST_MCS=11 RW_TEST_SGI=0 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
TESTCASE=test_wlan_mac_state_change
SIMRUN=simu.state.power.run
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_BW=0 RW_TEST_LDPC=0 RW_TEST_MCS=4  RW_TEST_SGI=0 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
fi

if [ $config_STA_1x1_CBW40_LDPC == 1 ]
then
# config_STA_1x1_CBW40_LDPC
RW_TEST_CONFIG=config_STA_1x1_CBW40_LDPC
TESTCASE=test_wlan_rx_power
SIMRUN=simu.rx.power.run
RW_TEST_SEED=5
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_SEED=${RW_TEST_SEED} RW_TEST_BW=1 RW_TEST_LDPC=0 RW_TEST_MCS=0 1RW_TEST_SGI=2 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_SEED=${RW_TEST_SEED} RW_TEST_BW=1 RW_TEST_LDPC=1 RW_TEST_MCS=11 RW_TEST_SGI=0 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
TESTCASE=test_wlan_tx_power
SIMRUN=simu.tx.power.run
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_SEED=${RW_TEST_SEED} RW_TEST_BW=1 RW_TEST_LDPC=0 RW_TEST_MCS=0  RW_TEST_SGI=2 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_SEED=${RW_TEST_SEED} RW_TEST_BW=1 RW_TEST_LDPC=1 RW_TEST_MCS=11 RW_TEST_SGI=0 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
TESTCASE=test_wlan_mac_state_change
SIMRUN=simu.state.power.run
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_BW=1 RW_TEST_LDPC=0 RW_TEST_MCS=4  RW_TEST_SGI=0 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
fi

if [ $config_STA_1x1_CBW80_LDPC == 1 ]
then
# config_STA_1x1_CBW80_LDPC
RW_TEST_CONFIG=config_STA_1x1_CBW80_LDPC
TESTCASE=test_wlan_rx_power
SIMRUN=simu.rx.power.run
RW_TEST_SEED=5
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_SEED=${RW_TEST_SEED} RW_TEST_BW=2 RW_TEST_LDPC=0 RW_TEST_MCS=0 1RW_TEST_SGI=2 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_SEED=${RW_TEST_SEED} RW_TEST_BW=2 RW_TEST_LDPC=1 RW_TEST_MCS=11 RW_TEST_SGI=0 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
TESTCASE=test_wlan_tx_power
SIMRUN=simu.tx.power.run
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_SEED=${RW_TEST_SEED} RW_TEST_BW=2 RW_TEST_LDPC=0 RW_TEST_MCS=0  RW_TEST_SGI=2 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_SEED=${RW_TEST_SEED} RW_TEST_BW=2 RW_TEST_LDPC=1 RW_TEST_MCS=11 RW_TEST_SGI=0 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
TESTCASE=test_wlan_mac_state_change
SIMRUN=simu.state.power.run
RW_TEST_CONFIG=${RW_TEST_CONFIG} RW_TEST_BW=0 RW_TEST_LDPC=0 RW_TEST_MCS=4  RW_TEST_SGI=0 TESTCASE=${TESTCASE} SIMRUN=${SIMRUN} run_power_estimation.sh
fi