#!/bin/bash
eval 'exec perl -x "$0" ${1+"$@"}'
if 0;
#!perl
#-------------------------------------------------------------------------------
#-          Project : 
#-        $RCSfile: $ 
#-     $Author: jvanthou $ 
#-
#-------------------------------------------------------------------------------
#- This source code is (c) by RivieraWaves, any copy is strictly forbidden unless
#- explicitly authorized by a RivieraWaves originating written document.
#-------------------------------------------------------------------------------
#- $Revision: 21470 $ 
#- $Date: 2015-09-23 17:25:26 +0200 (Wed, 23 Sep 2015) $ 
#- $State:  $
#- $Locker:  $
#-------------------------------------------------------------------------------
#-
#- Description : Generates a power resport
#-
#-  power_report.pl <output file>
#-
#-------------------------------------------------------------------------------
#-
#- $Source: $
#- $Log: $
#-
#-------------------------------------------------------------------------------

$REPORTPATH = "power_reports";
@REPORTLIST = glob  "$REPORTPATH/*.power.rpt";
#@REPORTLIST = "$REPORTPATH/config_AC_1x1_CBW80_WAPI_LDPC_FORMATMOD4_BW1_NSS1_LDPC0_MCS0_SGI1_tx.power.rpt";

@LISTOFMODULE=(rw_he_top_wrapper,
rw_he_top,
RIUKarstTop,
AGCCCATop,
TxRxFrontEndX40,
ModemCore,
OFDMTxBD,
OFDMRxBD,
Viterbi,
RxFDTop,
RxTDTop,
fft,
ChEstSmthTop,
modem80211b_top,
rw_he_platform,
rwWlanNxMACHW,
encryptEngTop,
svdtop,
LDPCRxTop,
LDPCTxTop);

#@LISTOFMODULE=(rw_he_top_wrapper,rw_he_top,rw_he_platform,rwWlanNxMACHW,RIUKarstTop2,RIUKarstTop,ModemCore,Viterbi,LDPCRxTop);
#@LISTOFMODULE=(rw_he_top);


sub nomalize_unit {
  if ($_[0] =~ /(.*)mW/) {return $1*1000}
  if ($_[0] =~ /(.*)uW/) {return $1}
  if ($_[0] =~ /(.*)nW/) {return $1/1000}
  if ($_[0] =~ /(.*)pW/) {return $1/1000000}
  if ($_[0] =~ /(.*)fW/) {return $1/1000000000}
  if ($_[0] =~ /(.*)W/) {return $1*1000000}
}




$LEGEND="                         Leakage    Internal    Switching      Total";

%TABLE={};
open(outputfile, ">power_report.csv") or die "Cannot open file";
#printf("%-80s %-20s %10s %10s %10s %10s\n","Configuration","Module","Leakage","Internal", "Switching","Total");
printf outputfile ("Config,Formatmod,BW,NSS,LPDC,MCS,SGI,Length,Mode,Module,Leakage,Internal,Switching,Total,Leakage (uW),Internal (uW),Switching (uW),Total (uW)\n");

local $| = 1; #flush immediately
print "Parse all reports contained in $REPORTPATH and generated power_report.csv file\n";

my @files = <$REPORTPATH/*>;
my $countreport = @files;
$cnt = 1;
for $RPT (@REPORTLIST)
{
  #print "$RPT\n";
  #print "$LEGEND\n";
  $config=$RPT;
  $config=~ s/\..*//g;
  $config=~ s/.*\///g;
  
  unless (open(inputfile,"$RPT")) { die "Unable to open $RPT\n"}
  chomp(my @lines = <inputfile>); 
  foreach $MODULE  (@LISTOFMODULE)
  {
    #print "$MODULE\n";
    foreach $line  (@lines)
    {
      if (($line =~ /\($MODULE\)\[\('(.*)' '(.*)' '(.*)'\) \('(.*)'\)\]/) or ($line =~ /^$MODULE\[\('(.*)' '(.*)' '(.*)'\) \('(.*)'\)\]/))
      {
        #print "$line\n";
        #printf("%-80s %-20s %10s %10s %10s %10s\n",$config,$MODULE,$1,$2,$3,$4);
        $Leakage    = $1;
        $Internal   = $2;
        $Switching  = $3;
        $Total      = $4;

        $LeakageNorm    = nomalize_unit($1);
        $InternalNorm   = nomalize_unit($2);
        $SwitchingNorm  = nomalize_unit($3);
        $TotalNorm      = nomalize_unit($4);
        
        
        if ($config =~  /(.*)_BW(.*)_LDPC(.*)_MCS(.*)_SGI(.*)_L(.*)_(.*)/)
        {
          #printf("%-40s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-10s %-20s %10s %10s %10s %10s\n",$1,$2,$3,$4,$5,$6,$7,$8,$9,$MODULE,$Leakage,$Internal,$Switching,$Total);
          printf outputfile ("$1,$2,$3,$4,$5,$6,$7,$8,$9,$MODULE,$Leakage,$Internal,$Switching,$Total,$LeakageNorm,$InternalNorm,$SwitchingNorm,$TotalNorm\n");
        }
       
        
      }
    }
  }
  close(inputfile);
  $cnt++;
  print "$cnt/$countreport\r";
}
close(outputfile);
exit

