#/////////////////////////////////////////////////////////////////////////////
#/  Copyright (C) by RivieraWaves.
#/  This module is a confidential and proprietary property of RivieraWaves
#/  and a possession or use of this module requires written permission
#/  from RivieraWaves.
#/----------------------------------------------------------------------------
#/ $Author: jvanthou $
#/ Company          : RivieraWaves
#/----------------------------------------------------------------------------
#/ $Revision: 31094 $
#/ $Date: 2017-06-19 10:51:51 +0200 (Mon, 19 Jun 2017) $
#/ ---------------------------------------------------------------------------
#/ Dependencies     : None
#/ Description      : Script to perform RTL based power estimation using Spyglass
#/ Application Note :
#/ Terms & concepts :
#/ Bugs             :
#/ Open issues and future enhancements :
#/ References       :
#/ Revision History :
#/ ---------------------------------------------------------------------------
#/
#/ $HeadURL: https://svn.frso.rivierawaves.com/svn/rw_wlan_nx/trunk/Projects/WLAN_HE_REF_IP/HW/SIMS_UVM/run/run_power_estimation.sh $
#/
#/////////////////////////////////////////////////////////////////////////////  
  

RUNSIMULATION=1
GENDB=1
RUNSPYGLASS=1
GUI="-nogui"
LOOP=1

RX=1
TX=1
STATE=1

RW_SIMDIR="${RW_SIMDIR:=dev}"
WORKDIR="work.${RW_SIMDIR}"

GotoWorkDir()
{
  echo "GotoWorkDir" 
  if [ ! -d "$WORKDIR" ]
  then
    # directory doesn't exist, create it
    cp -r _template $WORKDIR
    ln -s ../power_reports .
  fi

  cd $WORKDIR
}

GotoWorkDir

if [ ! -e waveform_db ]
then
  echo "Create waveform_db folder"
  mkdir waveform_db
fi  
if [ ! -e waveform_dir ]
then
  echo "Create waveform_dir folder"
  mkdir waveform_dir
fi  
if [ ! -e power_reports ]
then
  echo "Create power_reports folder"
  mkdir power_reports
fi  

STARTDATE=`date +%s`
date >> power_reports/power_simu.rpt


C=0

# Check all the parameters and skip the case if the configuration does not exist
function check_parameters {
  SKIP=0
  #echo $RW_TEST_CONFIG1"
  if [[ $RW_TEST_CONFIG != *LDPC* ]] && [ $RW_TEST_LDPC == 1 ] ;
  then
    #echo "[[ $RW_TEST_CONFIG != *LDPC* ]] && [ $RW_TEST_LDPC == 1 ]"
    SKIP="1"
  fi
  if [ $RW_TEST_BW == 0 ] && [ $RW_TEST_MCS -gt 9 ] ;
  then
    #echo "[ $RW_TEST_BW == 0 ] && [ $RW_TEST_MCS == 9 ]"
    SKIP="1"
  fi
    
}


# Launch the RTL simulation and SpyGlass analysis
function run_analysis {
  STARTLOOP=`date +%s`
  PASS=1
  if [ $RUNSIMULATION == 1 ]
  then
    rm -rf waveform_dir/*.*
    cd ..
    simulate.bash -fsdb -simu.run ${SIMRUN} -config ${RW_TEST_CONFIG} -seed ${RW_TEST_SEED} -d RW_TEST_MCS=${RW_TEST_MCS} -d RW_TEST_BW=${RW_TEST_BW} -d RW_TEST_SGI=${RW_TEST_SGI} -d RW_TEST_LDPC=${RW_TEST_LDPC} -d RW_TEST_LENGTH=${RW_TEST_LENGTH} -t ${TESTCASE}
    GotoWorkDir 
    cp -rf ../../logs/${RW_TEST_CONFIG}_${TESTCASE}_seed_${RW_TEST_SEED}.log power_reports/${RW_TEST_CONFIG}_BW${RW_TEST_BW}_LDPC${RW_TEST_LDPC}_MCS${RW_TEST_MCS}_SGI${RW_TEST_SGI}_L${RW_TEST_LENGTH}.simu.log

    TESTSIMU=`grep -c "= SCENARIO PASSED =" ../../logs/${RW_TEST_CONFIG}_${TESTCASE}_seed_${RW_TEST_SEED}.log`
    TESTFATAL=`grep -c "UVM_FATAL :    0" ../../logs/${RW_TEST_CONFIG}_${TESTCASE}_seed_${RW_TEST_SEED}.log`
    TESTERROR=`grep -c "UVM_ERROR :    0" ../../logs/${RW_TEST_CONFIG}_${TESTCASE}_seed_${RW_TEST_SEED}.log`
    if [ $TESTFATAL$TESTERROR$TESTASSERT == 111 ]
    then
      PASS=1
    fi

    if [ $PASS -eq 1 ]
    then
      echo "${TESTCASE} ${RW_TEST_CONFIG}_BW${RW_TEST_BW}_LDPC${RW_TEST_LDPC}_MCS${RW_TEST_MCS}_SGI${RW_TEST_SGI}_L${RW_TEST_LENGTH}_${TESTCASE} PASSED" >> power_reports/power_simu.rpt
    else
      echo "${TESTCASE} ${RW_TEST_CONFIG}_BW${RW_TEST_BW}_LDPC${RW_TEST_LDPC}_MCS${RW_TEST_MCS}_SGI${RW_TEST_SGI}_L${RW_TEST_LENGTH}_${TESTCASE} FAILED" >> power_reports/power_simu.rpt
    fi  

  fi
  #PASS=1
  if [ $GENDB == 1 ] && [ $PASS == 1 ] ;
  then
    PHASELIST=`ls waveform_dir | grep .fsdb | sed 's/.fsdb//'`
    for PHASE in $PHASELIST
    do
      mv waveform_dir/$PHASE.fsdb waveform_db/${RW_TEST_CONFIG}_BW${RW_TEST_BW}_LDPC${RW_TEST_LDPC}_MCS${RW_TEST_MCS}_SGI${RW_TEST_SGI}_L${RW_TEST_LENGTH}_${PHASE}.fsdb

      if [ $RUNSPYGLASS == 1 ]
      then
        rm simulation.fsdb
        ln -s waveform_db/${RW_TEST_CONFIG}_BW${RW_TEST_BW}_LDPC${RW_TEST_LDPC}_MCS${RW_TEST_MCS}_SGI${RW_TEST_SGI}_L${RW_TEST_LENGTH}_${PHASE}.fsdb simulation.fsdb
        rm verilog_files.list
        echo "${SOURCESLIB}/env/CONF/${RW_TEST_CONFIG}.v" > verilog_files.list    
        cat rw_he_top_rtl_files.list | egrep -v memory_models | egrep -v rw_he_memories >> verilog_files.list                        
        cat rw_he_top_tb_files.list >> verilog_files.list
        if ! [ -e simulation.fsdb ]
        then
          echo "ERROR.  simulation.fsdb has not been generated"
          exit 1
        fi
        cp ../rw_he_top_power.prj .
        cp ../rw_he_top_power.sgdc .
        
        # Run SpyGlass tool
        SPYGLASS_KO=1
        while [ $SPYGLASS_KO != 0 ]; do
          ${NC_RUN_SPYGLASS} spyglass -project rw_he_top_power.prj -batch -goal power/power_est_average@original
          SPYGLASS_KO=`egrep -c "*** LICENSE FAILURE NOTIFICATION ***" spyglass_results/rw_he_top_power/spyglass.out`
          if [ $SPYGLASS_KO != 0 ]
          then
            sleep 30
          fi  
        done
        cp -rf spyglass_results/rw_he_top_power/rw_he_top_wrapper/power/power_est_average/original/spyglass_reports/power_est/pe_summary.rpt power_reports/${RW_TEST_CONFIG}_BW${RW_TEST_BW}_LDPC${RW_TEST_LDPC}_MCS${RW_TEST_MCS}_SGI${RW_TEST_SGI}_L${RW_TEST_LENGTH}_${PHASE}.power.rpt
      
        
      fi



    done
  fi
  ENDLOOP=`date +%s`
  DURATION=$(($ENDLOOP-$STARTLOOP))
  echo "${TESTCASE} ${RW_TEST_CONFIG}_BW${RW_TEST_BW}_LDPC${RW_TEST_LDPC}_MCS${RW_TEST_MCS}_SGI${RW_TEST_SGI}_L${RW_TEST_LENGTH} $DURATION" >> power_reports/duration.txt
}



if [ -z ${RW_TEST_CONFIG} ] ;
then
  echo "RW_TEST_CONFIG has not been defined. Use default config : config_STA_1x1_CBW20"
  RW_TEST_CONFIG=config_STA_1x1_CBW20
fi  
if [ -z ${RW_TEST_BW} ] ;
then
  echo "RW_TEST_BW has not been defined. Use default bandwidth : 0"
  RW_TEST_BW=0
fi  
if [ -z ${RW_TEST_LDPC} ] ;
then
  echo "RW_TEST_LDPC has not been defined. Use default ldpc value: 0"
  RW_TEST_LDPC=0
fi  
if [ -z ${RW_TEST_SGI} ] ;
then
  echo "RW_TEST_SGI has not been defined. Use default SGI value : 0"
  RW_TEST_SGI=0
fi  
if [ -z ${RW_TEST_MCS} ] ;
then
  echo "RW_TEST_MCS has not been defined. Use default MCS : 0"
  RW_TEST_MCS=0
fi  

if [ -z ${RW_TEST_LENGTH} ] ;
then

  if [ $RW_TEST_MCS -gt 6 ]
  then 
    RW_TEST_LENGTH=2000
  else
    RW_TEST_LENGTH=1000
  fi
  
if [ -z ${RW_TEST_SEED} ] ;
then
  echo "RW_TEST_SEED has not been defined. Use default SEED : 5"
  RW_TEST_SEED=5
fi  

  echo "RW_TEST_LENGTH has not been defined. Use default frame length : $RW_TEST_LENGTH"
fi  

if [ -z ${TESTCASE} ] ;
then
  echo "TESTCASE has not been defined. Use default testcase : test_wlan_rx_power"
TESTCASE=test_wlan_rx_power
fi  

if [ -z ${SIMRUN} ] ;
then
  echo "SIMRUN has not been defined. Use default testcase : simu.rx.power.run"
SIMRUN=simu.rx.power.run
fi  


# Power Estimation
check_parameters
echo "${RW_TEST_CONFIG}_BW${RW_TEST_BW}_LDPC${RW_TEST_LDPC}_MCS${RW_TEST_MCS}_SGI${RW_TEST_SGI} $SKIP"
if [ "$SKIP" == 0 ]
then
  run_analysis
fi  


ENDDATE=`date +%s`
DURATION=$(($ENDDATE-$STARTDATE))
echo $DURATION > duration.txt
echo "Duration: $DURATION sec"
