//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: jvanthou $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 26496 $
// $Date: 2016-05-27 09:24:12 +0200 (Fri, 27 May 2016) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
//   This is the PHY Tx/Rx vector. It contains control parameters to/from the
//   Modem. It also contains a function for TX-TIME calculation.
//
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
#include <stdio.h>
#include <math.h>

// Function DPI-C to print through verilog testbench in irun.log
extern void tb_print(const char *STR);
extern void tb_fire_error(const char *STR);

// define which parameter will function return when called
typedef enum {
  RET_TXTIME,
  RET_L_LENGTH,
  RET_PSDU_LENGTH,
  RET_NSYM
} funcParamRet_e;

int GenHeTbTrs (
  int ruLen_i,
  int heLtfType_i,
  int giType_i,
  int packetExtension_i,
  int mcsIndex_i,
  int dcm_i,
  int numSymb_i,
  funcParamRet_e funcParamRet_i,
  int debug_i) {

  FILE  *fp;
  char  perl_script[] = "$SOURCESLIB/SIMS_UVM/tb_env/perl/gen_he_tb_trs.pl";
  char  STR[1024];
  char  command[1024];
  float he_ltf_type_param;
  float gi_type_param;
  int   ru_type_param;
  int   t_pe;
  // perl varibles to catch
  int   nbpsc,crn,crd;
  int   txtime,nsym,pe_disamb;
  int   a_init;
  int   nsym_init;
  int   npld;
  int   navbits;
  int   psdulen,npad;
  int   ncw,lldpc;
  int   npuncq,npuncr;
  int   nshrtq,nshrtr;
  int   nrepq,nrepr;
  int   fec;
  int   dcm;
  int   l_length;
  int   heltf_type,gi_type;
  int   ncbps, ndbps;

  he_ltf_type_param = pow(2,heLtfType_i) * 3.2;
  gi_type_param = pow(2,giType_i) * 0.8;
  switch (ruLen_i) {
    case 0:  ru_type_param = 26; break;
    case 1:  ru_type_param = 52; break;
    case 2:  ru_type_param = 106; break;
    case 3:  ru_type_param = 242; break;
    case 4:  ru_type_param = 484; break;
    case 5:  ru_type_param = 996; break;
    default: ru_type_param = 26; break;
  }
  switch (packetExtension_i) {
    case 0:  t_pe = 0;  break;
    case 1:  t_pe = 4;  break;
    case 2:  t_pe = 8;  break;
    case 3:  t_pe = 12; break;
    case 4:  t_pe = 16; break;
    default: t_pe = 0;  break;
  }

  // create command line
  sprintf(command, "%s rulen=%0d heltf_gi=%0.1f:%0.1f t_pe=%0d mcs=%0d dcm=%0d ref_nsym=%0d",
    perl_script,ru_type_param,he_ltf_type_param,gi_type_param,t_pe,mcsIndex_i,dcm_i,numSymb_i+1);

  if (debug_i==1) {
    tb_print(command);
  }
  fp = popen(command, "r");
  if (fp == NULL) {
    sprintf(STR, "Failed to popen file %s", command);
    tb_print(STR);
    return -1;
  }
  // collect printed varibles from perl, must scan in order like perl is printing
  fscanf(fp, "gi_type          = %d\n",&gi_type);
  fscanf(fp, "heltf_type       = %d\n",&heltf_type);
  fscanf(fp, "txtime           = %d\n",&txtime);
  fscanf(fp, "l_length         = %d\n",&l_length);
  fscanf(fp, "pe_disamb        = %d\n",&pe_disamb);
  fscanf(fp, "dcm              = %d\n",&dcm);
  fscanf(fp, "nbpsc            = %d\n",&nbpsc);
  fscanf(fp, "cr               = %d/%d\n",&crn,&crd);
  fscanf(fp, "ncbps            = %d\n",&ncbps);
  fscanf(fp, "ndbps            = %d\n",&ndbps);
  fscanf(fp, "fec              = %d\n",&fec);
  fscanf(fp, "nsym             = %d\n",&nsym);
  fscanf(fp, "nsym_init        = %d\n",&nsym_init);
  fscanf(fp, "a_init           = %d\n",&a_init);
  fscanf(fp, "psdulen          = %d\n",&psdulen);
  fscanf(fp, "npad             = %d\n",&npad);
  fscanf(fp, "npld             = %d\n",&npld);
  fscanf(fp, "navbits          = %d\n",&navbits);
  fscanf(fp, "ncw              = %d\n",&ncw);
  fscanf(fp, "lldpc            = %d\n",&lldpc);
  fscanf(fp, "(nshrtq, nshrtr) = (%d,%d)\n",&nshrtq, &nshrtr);
  fscanf(fp, "(npuncq, npuncr) = (%d,%d)\n",&npuncq, &npuncr);
  fscanf(fp, "(nrepq,   nrepr) = (%d,%d)\n",&nrepq,  &nrepr);

  pclose(fp);

  switch (funcParamRet_i) {
    case RET_TXTIME:      sprintf(STR,"RET_TXTIME:     %0d",txtime  ); if (debug_i==1) tb_print(STR); return txtime;
    case RET_L_LENGTH:    sprintf(STR,"RET_L_LENGTH:   %0d",l_length); if (debug_i==1) tb_print(STR); return l_length;
    case RET_PSDU_LENGTH: sprintf(STR,"RET_PSDU_LENGTH:%0d",psdulen ); if (debug_i==1) tb_print(STR); return psdulen;
    case RET_NSYM:        sprintf(STR,"RET_NSYM:       %0d",nsym    ); if (debug_i==1) tb_print(STR); return nsym;
    default:              sprintf(STR,"RET_PSDU_LENGTH:%0d",psdulen ); if (debug_i==1) tb_print(STR); return psdulen;
  }

}

