//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: jvanthou $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 5417 $
// $Date: 2012-12-18 13:20:24 +0100 (Tue, 18 Dec 2012) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
//   This is the PHY Tx/Rx vector. It contains control parameters to/from the
//   Modem. It also contains a function for TX-TIME calculation.
//
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
#include <stdio.h>
#include <math.h>
#include "phyVectorAC.h"

// Function DPI-C to print through verilog testbench in irun.log
extern void tb_print(const char *STR);

// Function DPI-C to calculate TXTIME
int ComputeTimeOnAirAC ( int length_i   , int  preType_i   , int mcsIndex_i,
                         int shortGI_i  , int  chBW_i      , int stbc_i    ,
                         int extNSS_i   , int  woPreamble_i, int band5G_i  ,
                         int multiUser_i, int  nSTSTotal_i , int debug_i   )
{

  // Max of 1024 character for debug printing through tb_print
  char   STR[1024];
  // Total TXTIME
  int    timeOnAir         = 0;
  // Preamble Time
  int    preambleTimeOnAir = 0;
  // LTF Time (coresponding to ((nLTF-1)*4) Since the first LTF1 is already in the define PREAMBLE BASE
  int    ltfTimeOnAir      = 0;
  // PPDU Time
  float  dataTimeOnAir     = 0.0;
  float  dataNSymbol       = 0.0;
  float  tSymbol           = 0.0;
  float  signalExtension   = 0.0;


  // IEEE corresponding variables
  int    nSS               = 0;
  int    nSTS              = 0;
  int    nDBPS             = 0;
  int    nES               = 0;

  if (band5G_i | ((preType_i < 2) & (mcsIndex_i < 4))) {
  signalExtension = 0.0;
  }else{
  signalExtension = 6.0;
  }

  //debug_i = 1;
  if(preType_i < 2){
    shortGI_i = 0;
  }
  // First Step: Get all the IEEE Variables
  // NSS
  if(preType_i == 4){
    // VHT NSS=mcsIndex_i[6:4]+1
    nSS = ((mcsIndex_i >> 4) & 0x00000007)+1;
  }
  else if(preType_i > 1){
    // HT NSS=according to mcsIndex_i
    nSS =   (mcsIndex_i <  8)                   ? 1:
            (mcsIndex_i <  16)                  ? 2:
            (mcsIndex_i <  24)                  ? 3:
            (mcsIndex_i <  32)                  ? 4:
            (mcsIndex_i == 32) && (chBW_i == 1) ? 1://only valid for 40MHz Bandwidth
            (mcsIndex_i == 32) && (chBW_i != 1) ? 0://Not valid
            (mcsIndex_i <  39)                  ? 2:
            (mcsIndex_i <  53)                  ? 3:
            (mcsIndex_i <= 76)                  ? 4:
                                                  0;
  }

  if(debug_i==1){
    sprintf(STR,"\nComputeTimeOnAirAC:\nnSS               = %0d (preType_i = %0d, mcsIndex_i = %0d, band5G_i = %0d)",nSS,preType_i,mcsIndex_i,band5G_i);
    tb_print(STR);
    sprintf(STR,"chBW_i            = %0d",chBW_i);
    tb_print(STR);
    sprintf(STR,"length_i          = %0d",length_i);
    tb_print(STR);
  }

  // nSTS
  if(preType_i == 4){
    // VHT IEEE P802.11ac D4.0
    if(multiUser_i == 1){
      // If multiUser == 1 then NSTS = nSTSTotal.
      nSTS  = nSTSTotal_i;
    }else{
      // If STBC == 1 then NSTS = NSS*2 else NSS.
      nSTS  = (stbc_i) ? nSS<<1 : nSS;
    }
  }
  else if(preType_i > 1){
    // HT nSTS IEEE Std 802.11 - 2012 table 20-12 Determining the number of space-time streams
    nSTS =  (nSS == 4) ? nSS : nSS + stbc_i;
  }

  if(debug_i==1){
    sprintf(STR,"nSTS              = %0d (stbc_i = %0d)",nSTS,stbc_i);
    tb_print(STR);
  }

  // number of DATA BIT PER SYMBOL
  nDBPS = (preType_i < 2) ?  LEGACY_OFDM_NDBPS[mcsIndex_i - 4]                : // mcsIndex_i from 4 to 11
          (preType_i < 4) ?  HT_NDBPS[chBW_i][mcsIndex_i]                     : // mcsIndex_i from 0 to 76 and chBW_i from 0 to 1
                             VHT_NDBPS[chBW_i][nSS-1][mcsIndex_i & 0x0000000F]; // mcsIndex_i[3:0] from 0 to 9 and chBW_i from 0 to 3 and nSS from 1 to 8

  if(debug_i==1){
    sprintf(STR,"nDBPS             = %0d ",nDBPS);
    tb_print(STR);
  }
  // nES = 6*NES
  // VHT IEEE P802.11ac D4.0
  if(preType_i == 4){
    // 20MHz and  40MHz Bandwidth
    if(chBW_i < 2) {
      nES = (nDBPS <= 2160) ? 6 : (nDBPS <= 4320) ? 12 : 18;
    }
    // 80MHz Bandwidth
    else if(chBW_i == 2) {
      if((nSS == 7) && (nDBPS == 8190)){
        nES = 36;
      }
      else if((nSS == 7) && (nDBPS == 2457)){
        nES = 18;
      }
      else {
        nES = (nDBPS <= 2106) ? 6 : (nDBPS <= 4212) ? 12 : (nDBPS <= 6318) ? 18 : (nDBPS <= 8424) ? 24 : 36;
      }
    }
    // 160MHz Bandwidth
    else if(chBW_i == 3){
      if( ((nSS == 4) && (nDBPS == 9360)) || ((nSS == 7) && (nDBPS == 9828)) ){
        nES = 36;
      }
      else if((nDBPS == 14040) && ((nSS == 5) || (nSS == 6)) ){
        nES = 48;
      }
      else if((nSS == 7) && (nDBPS == 16380)){
        nES = 54;
      }
      else{
        nES = (nDBPS <= 2106)  ? 6  :
              (nDBPS <= 4212)  ? 12 :
              (nDBPS <= 6318)  ? 18 :
              (nDBPS <= 8424)  ? 24 :
              (nDBPS <= 10530) ? 30 :
              (nDBPS <= 12636) ? 36 :
              (nDBPS <= 14742) ? 42 :
              (nDBPS <= 16848) ? 48 :
              (nDBPS <= 18720) ? 54 :
                                 72 ;
      }
    }
  }
  // HT IEEE Std 802.11 - 2012
  else if(preType_i > 1){
    nES = (nDBPS < 1296) ? 6 : 12;
  // LEGACY OFDM
  } else {
    nES = 6;
  }

  if(debug_i==1){
    sprintf(STR,"nES               = %0d (nDBPS = %0d)",nES,nDBPS);
    tb_print(STR);
  }

  // Check if preamble duration is taken in to the calculation
  if(woPreamble_i == 0){
    // preamble time on air
    switch(preType_i){
      case 0:  preambleTimeOnAir = (mcsIndex_i > 3) ? OFDM_NON_HT_PRE : (mcsIndex_i == 0) ? LONG_PRE : SHORT_PRE; break;
      case 1:  preambleTimeOnAir = (mcsIndex_i > 3) ? OFDM_NON_HT_PRE : LONG_PRE;  break;
      case 2:  preambleTimeOnAir = OFDM_HT_MM_PRE_BASE; break;
      case 3:  preambleTimeOnAir = OFDM_HT_GF_PRE_BASE; break;
      case 4:  preambleTimeOnAir = OFDM_VHT_PRE_BASE;   break;
      default: preambleTimeOnAir = 0;
    }

    // LTF Calculation
    // ltfTimeOnAir = (NLTF - 1) Since the LTF1 is already added in the preambleTimeOnAir
    switch(preType_i){
      // HT MM and HT GF IEEE Std 802.11 - 2012
      case 2:
      case 3:  ltfTimeOnAir  = (nSTS == 3)     ? 3 : nSTS-1;          // Table 20-13—Number of HT-DLTFs required for data space-time streams
               ltfTimeOnAir += (extNSS_i == 3) ? 4 : extNSS_i; break; // Table 20-14—Number of HT-ELTFs required for extension spatial streams

      // VHT IEEE P802.11ac D3.0 Table 22-13 Number of VHT-LTFs required for different numbers of space time streams
      case 4:  ltfTimeOnAir = (nSTS == 3) ? 3   :
                              (nSTS == 5) ? 5   :
                              (nSTS == 7) ? 7   :
                                            nSTS-1; break;
      default: ltfTimeOnAir = 0;
    }

    // Each LTF is 4us
    ltfTimeOnAir = ltfTimeOnAir<<2;
  }

  if(debug_i==1){
    sprintf(STR,"preambleTimeOnAir = %0d (woPreamble_i = %0d)",preambleTimeOnAir,woPreamble_i);
    tb_print(STR);
    sprintf(STR,"ltfTimeOnAir      = %0d (extNSS_i = %0d)",ltfTimeOnAir,extNSS_i);
    tb_print(STR);
  }

  // Data Time on Air for NON OFDM is Length in bit / data rate
  if((preType_i < 2) && (mcsIndex_i < 4)){
    dataTimeOnAir = ( ((float)(length_i<<3)) / (LEGACY_NON_OFDM_RATE[mcsIndex_i]) );

    // Round up the time
    dataTimeOnAir = ceilf(dataTimeOnAir);

    if(debug_i==1){
      sprintf(STR,"dataTimeOnAir     = %0d (length_i = %0d  LEGACY_NON_OFDM_RATE = %0d)",(int)dataTimeOnAir,length_i,(int)LEGACY_NON_OFDM_RATE[mcsIndex_i]);
      tb_print(STR);
    }
  }
  // Data Time on Air for OFDM
  // 1) The full data length in bit is length_i*8 + 16 bits of service field + 6*nES tail bits (IEEE Std 802.11 - 2012 Chapter 18.3.5.x)
  // 2) Convert into Nsymbols according to the MCS (round up the value)
  // 3) If STBC is enabled then add 1 symbol if Nsymbols is odd (STBC send symbols by pairs and twice)
  // 4) Convert Nsymbols into time duration according to Normal GI or Short GI (round up the value)
  // 5) In GF, the TXTIME formula is different than for HT-MM. However, if the packet alignment is included, both become equivalent.
  //   As a consequence, all the duration include the packet alignment duration.
  else {
    // Total of Symbols =            (length_i*8 + 16 + 6*NES)  / NDBPS
    dataNSymbol       = ( ((float)((length_i<<3) + 16 + nES)) / ((float)(nDBPS)) );

    // Round up the dataNSymbol
    dataNSymbol = ceilf(dataNSymbol);

    // If STBC See IEEE Std 802.11 - 2012 Table 20-18 then Add one symbol in case of odd number
    if(stbc_i != 0)
    {
      dataNSymbol += (float)( ((int)dataNSymbol) & 0x00000001); // convert into integer for odd or even detection
    }

    if(debug_i==1){
      sprintf(STR,"dataNSymbol       = %0d (length_i = %0d  nDBPS = %0d, stbc_i = %0d)",(int)dataNSymbol,length_i,nDBPS,stbc_i);
      tb_print(STR);
    }

    dataTimeOnAir = dataNSymbol;

    tSymbol           = (shortGI_i) ? 3.6 : 4.0;

    // Round up the time
    dataTimeOnAir = 4*ceilf(tSymbol*dataNSymbol/4.0);

    if(debug_i==1){
      sprintf(STR,"dataTimeOnAir     = %0d (shortGI_i = %0d)",(int)dataTimeOnAir,shortGI_i);
      tb_print(STR);
    }
  }

  if(debug_i==1){
    sprintf(STR,"signalExtension   = %0d",(int)signalExtension);
    tb_print(STR);
  }

  // Calculate the full time on air of the frame
  timeOnAir = preambleTimeOnAir + ltfTimeOnAir + (int)(dataTimeOnAir) + signalExtension;

  if(debug_i==1){
    sprintf(STR,"timeOnAir         = %0d",timeOnAir);
    tb_print(STR);
  }

  // Return the value
  return (timeOnAir);
}

int ComputeNumOfSymbols( int length_i   , int  preType_i   , int mcsIndex_i,
                         int shortGI_i  , int  chBW_i      , int stbc_i    ,
                         int extNSS_i   , int  woPreamble_i, int band5G_i  ,
                         int multiUser_i, int  nSTSTotal_i , int debug_i   )
{

  // Max of 1024 character for debug printing through tb_print
  char   STR[1024];
  // Total TXTIME
  int    timeOnAir         = 0;
  // Preamble Time
  int    preambleTimeOnAir = 0;
  // LTF Time (coresponding to ((nLTF-1)*4) Since the first LTF1 is already in the define PREAMBLE BASE
  int    ltfTimeOnAir      = 0;
  // PPDU Time
  float  dataTimeOnAir     = 0.0;
  float  dataNSymbol       = 0.0;
  float  tSymbol           = 0.0;
  float  signalExtension   = 0.0;


  // IEEE corresponding variables
  int    nSS               = 0;
  int    nSTS              = 0;
  int    nDBPS             = 0;
  int    nES               = 0;

  if (band5G_i | ((preType_i < 2) & (mcsIndex_i < 4))) {
  signalExtension = 0.0;
  }else{
  signalExtension = 6.0;
  }

  //debug_i = 1;
  if(preType_i < 2){
    shortGI_i = 0;
  }
  // First Step: Get all the IEEE Variables
  // NSS
  if(preType_i == 4){
    // VHT NSS=mcsIndex_i[6:4]+1
    nSS = ((mcsIndex_i >> 4) & 0x00000007)+1;
  }
  else if(preType_i > 1){
    // HT NSS=according to mcsIndex_i
    nSS =   (mcsIndex_i <  8)                   ? 1:
            (mcsIndex_i <  16)                  ? 2:
            (mcsIndex_i <  24)                  ? 3:
            (mcsIndex_i <  32)                  ? 4:
            (mcsIndex_i == 32) && (chBW_i == 1) ? 1://only valid for 40MHz Bandwidth
            (mcsIndex_i == 32) && (chBW_i != 1) ? 0://Not valid
            (mcsIndex_i <  39)                  ? 2:
            (mcsIndex_i <  53)                  ? 3:
            (mcsIndex_i <= 76)                  ? 4:
                                                  0;
  }

  if(debug_i==1){
    sprintf(STR,"\nComputeNumOfSymbols:\nnSS               = %0d (preType_i = %0d, mcsIndex_i = %0d, band5G_i = %0d)",nSS,preType_i,mcsIndex_i,band5G_i);
    tb_print(STR);
    sprintf(STR,"chBW_i            = %0d",chBW_i);
    tb_print(STR);
    sprintf(STR,"length_i          = %0d",length_i);
    tb_print(STR);
  }

  // nSTS
  if(preType_i == 4){
    // VHT IEEE P802.11ac D4.0
    if(multiUser_i == 1){
      // If multiUser == 1 then NSTS = nSTSTotal.
      nSTS  = nSTSTotal_i;
    }else{
      // If STBC == 1 then NSTS = NSS*2 else NSS.
      nSTS  = (stbc_i) ? nSS<<1 : nSS;
    }
  }
  else if(preType_i > 1){
    // HT nSTS IEEE Std 802.11 - 2012 table 20-12 Determining the number of space-time streams
    nSTS =  (nSS == 4) ? nSS : nSS + stbc_i;
  }

  if(debug_i==1){
    sprintf(STR,"nSTS              = %0d (stbc_i = %0d)",nSTS,stbc_i);
    tb_print(STR);
  }

  // number of DATA BIT PER SYMBOL
  nDBPS = (preType_i < 2) ?  LEGACY_OFDM_NDBPS[mcsIndex_i - 4]                : // mcsIndex_i from 4 to 11
          (preType_i < 4) ?  HT_NDBPS[chBW_i][mcsIndex_i]                     : // mcsIndex_i from 0 to 76 and chBW_i from 0 to 1
                             VHT_NDBPS[chBW_i][nSS-1][mcsIndex_i & 0x0000000F]; // mcsIndex_i[3:0] from 0 to 9 and chBW_i from 0 to 3 and nSS from 1 to 8

  if(debug_i==1){
    sprintf(STR,"nDBPS             = %0d ",nDBPS);
    tb_print(STR);
  }
  // nES = 6*NES
  // VHT IEEE P802.11ac D4.0
  if(preType_i == 4){
    // 20MHz and  40MHz Bandwidth
    if(chBW_i < 2) {
      nES = (nDBPS <= 2160) ? 6 : (nDBPS <= 4320) ? 12 : 18;
    }
    // 80MHz Bandwidth
    else if(chBW_i == 2) {
      if((nSS == 7) && (nDBPS == 8190)){
        nES = 36;
      }
      else if((nSS == 7) && (nDBPS == 2457)){
        nES = 18;
      }
      else {
        nES = (nDBPS <= 2106) ? 6 : (nDBPS <= 4212) ? 12 : (nDBPS <= 6318) ? 18 : (nDBPS <= 8424) ? 24 : 36;
      }
    }
    // 160MHz Bandwidth
    else if(chBW_i == 3){
      if( ((nSS == 4) && (nDBPS == 9360)) || ((nSS == 7) && (nDBPS == 9828)) ){
        nES = 36;
      }
      else if((nDBPS == 14040) && ((nSS == 5) || (nSS == 6)) ){
        nES = 48;
      }
      else if((nSS == 7) && (nDBPS == 16380)){
        nES = 54;
      }
      else{
        nES = (nDBPS <= 2106)  ? 6  :
              (nDBPS <= 4212)  ? 12 :
              (nDBPS <= 6318)  ? 18 :
              (nDBPS <= 8424)  ? 24 :
              (nDBPS <= 10530) ? 30 :
              (nDBPS <= 12636) ? 36 :
              (nDBPS <= 14742) ? 42 :
              (nDBPS <= 16848) ? 48 :
              (nDBPS <= 18720) ? 54 :
                                 72 ;
      }
    }
  }
  // HT IEEE Std 802.11 - 2012
  else if(preType_i > 1){
    nES = (nDBPS < 1296) ? 6 : 12;
  // LEGACY OFDM
  } else {
    nES = 6;
  }

  if(debug_i==1){
    sprintf(STR,"nES               = %0d (nDBPS = %0d)",nES,nDBPS);
    tb_print(STR);
  }

  // Check if preamble duration is taken in to the calculation
  if(woPreamble_i == 0){
    // preamble time on air
    switch(preType_i){
      case 0:  preambleTimeOnAir = (mcsIndex_i > 3) ? OFDM_NON_HT_PRE : (mcsIndex_i == 0) ? LONG_PRE : SHORT_PRE; break;
      case 1:  preambleTimeOnAir = (mcsIndex_i > 3) ? OFDM_NON_HT_PRE : LONG_PRE;  break;
      case 2:  preambleTimeOnAir = OFDM_HT_MM_PRE_BASE; break;
      case 3:  preambleTimeOnAir = OFDM_HT_GF_PRE_BASE; break;
      case 4:  preambleTimeOnAir = OFDM_VHT_PRE_BASE;   break;
      default: preambleTimeOnAir = 0;
    }

    // LTF Calculation
    // ltfTimeOnAir = (NLTF - 1) Since the LTF1 is already added in the preambleTimeOnAir
    switch(preType_i){
      // HT MM and HT GF IEEE Std 802.11 - 2012
      case 2:
      case 3:  ltfTimeOnAir  = (nSTS == 3)     ? 3 : nSTS-1;          // Table 20-13—Number of HT-DLTFs required for data space-time streams
               ltfTimeOnAir += (extNSS_i == 3) ? 4 : extNSS_i; break; // Table 20-14—Number of HT-ELTFs required for extension spatial streams

      // VHT IEEE P802.11ac D3.0 Table 22-13 Number of VHT-LTFs required for different numbers of space time streams
      case 4:  ltfTimeOnAir = (nSTS == 3) ? 3   :
                              (nSTS == 5) ? 5   :
                              (nSTS == 7) ? 7   :
                                            nSTS-1; break;
      default: ltfTimeOnAir = 0;
    }

    // Each LTF is 4us
    ltfTimeOnAir = ltfTimeOnAir<<2;
  }

  if(debug_i==1){
    sprintf(STR,"preambleTimeOnAir = %0d (woPreamble_i = %0d)",preambleTimeOnAir,woPreamble_i);
    tb_print(STR);
    sprintf(STR,"ltfTimeOnAir      = %0d (extNSS_i = %0d)",ltfTimeOnAir,extNSS_i);
    tb_print(STR);
  }

  // Data Time on Air for NON OFDM is Length in bit / data rate
  if((preType_i < 2) && (mcsIndex_i < 4)){
    dataTimeOnAir = ( ((float)(length_i<<3)) / (LEGACY_NON_OFDM_RATE[mcsIndex_i]) );

    // Round up the time
    dataTimeOnAir = ceilf(dataTimeOnAir);

    if(debug_i==1){
      sprintf(STR,"dataTimeOnAir     = %0d (length_i = %0d  LEGACY_NON_OFDM_RATE = %0d)",(int)dataTimeOnAir,length_i,(int)LEGACY_NON_OFDM_RATE[mcsIndex_i]);
      tb_print(STR);
    }
  }
  // Data Time on Air for OFDM
  // 1) The full data length in bit is length_i*8 + 16 bits of service field + 6*nES tail bits (IEEE Std 802.11 - 2012 Chapter 18.3.5.x)
  // 2) Convert into Nsymbols according to the MCS (round up the value)
  // 3) If STBC is enabled then add 1 symbol if Nsymbols is odd (STBC send symbols by pairs and twice)
  // 4) Convert Nsymbols into time duration according to Normal GI or Short GI (round up the value)
  // 5) In GF, the TXTIME formula is different than for HT-MM. However, if the packet alignment is included, both become equivalent.
  //   As a consequence, all the duration include the packet alignment duration.
  else {
    // Total of Symbols =            (length_i*8 + 16 + 6*NES)  / NDBPS
    dataNSymbol       = ( ((float)((length_i<<3) + 16 + nES)) / ((float)(nDBPS)) );

    // Round up the dataNSymbol
    dataNSymbol = ceilf(dataNSymbol);

    // If STBC See IEEE Std 802.11 - 2012 Table 20-18 then Add one symbol in case of odd number
    if(stbc_i != 0)
    {
      dataNSymbol += (float)( ((int)dataNSymbol) & 0x00000001); // convert into integer for odd or even detection
    }

    if(debug_i==1){
      sprintf(STR,"dataNSymbol       = %0d (length_i = %0d  nDBPS = %0d, stbc_i = %0d)",(int)dataNSymbol,length_i,nDBPS,stbc_i);
      tb_print(STR);
    }

    dataTimeOnAir = dataNSymbol;

    tSymbol           = (shortGI_i) ? 3.6 : 4.0;

    // Round up the time
    dataTimeOnAir = 4*ceilf(tSymbol*dataNSymbol/4.0);

    if(debug_i==1){
      sprintf(STR,"dataTimeOnAir     = %0d (shortGI_i = %0d)",(int)dataTimeOnAir,shortGI_i);
      tb_print(STR);
    }
  }

  if(debug_i==1){
    sprintf(STR,"signalExtension   = %0d",(int)signalExtension);
    tb_print(STR);
  }

  // Calculate the full time on air of the frame
  timeOnAir = preambleTimeOnAir + ltfTimeOnAir + (int)(dataTimeOnAir) + signalExtension;

  if(debug_i==1){
    sprintf(STR,"timeOnAir         = %0d",timeOnAir);
    tb_print(STR);
  }

  // Return the value
  return (dataNSymbol);
}
