//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: dtruong $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 5166 $
// $Date: 2012-12-03 17:09:56 +0100 (Mon, 03 Dec 2012) $
// ---------------------------------------------------------------------------
// Dependencies     : None                                                      
// Description      : 
//   This is the PHY Tx/Rx vector. It contains control parameters to/from the
//   Modem. It also contains a function for TX-TIME calculation.
//                    
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// 
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


/////////////////////////
// IEEE Std 802.11 - 2012
//
/////////////////////////
// Chapter 17.3.4 High Rate TXTIME Calculation
//
// For LEGACY NON OFDM
// TXTIME         = PreambleLength + PLCPHeaderTime + Ceiling(((LENGTH+PBCC) × 8) / DATARATE)
// PreambleLength = If LONG 144 else 72
// PLCPHeaderTime = If LOGN 48 else 24
// PBCC           = 0 for RW IPs
//
//////////////////////////
// Chapter 18.4.3 OFDM TXTIME Calculation
//
// For LEGACY OFDM 20MHz Bandwidth
// TXTIME    = TPREAMBLE + TSIGNAL + TSYM × NSYM
// TPREAMBLE = 16
// TSIGNAL   = 4
// TSYM      = 4
// NSYM      = Ceiling((16 + 8 × LENGTH + 6)/NDBPS)
// NDBPS     = See Table 18-4—Modulation-dependent parameters
//
//////////////////////////
// Chapter 20.4.3 TXTIME calculation
// For HT MM short GI
// TXTIME =  TLEG_PREAMBLE + TL_SIG + THT_PREAMBLE + THT_SIG + (TSYM * Ceiling(TSYMS * NSYM / TSYM)) + SignalExtension
//
// For HT MM regular GI
// TXTIME =  TLEG_PREAMBLE + TL_SIG + THT_PREAMBLE + THT_SIG + (TSYM * NSYM) + SignalExtension
//
// For HT GF short GI
// TXTIME =  TGF_HT_PREAMBLE + THT_SIG + (TSYM * Ceiling(TSYMS * NSYM / TSYM)) + SignalExtension
//
// For HT GF regular GI
// TXTIME = TGF_HT_PREAMBLE + THT_SIG + (TSYM * NSYM) + SignalExtension
//
//
// TLEG_PREAMBLE    = TLEG_TSF + TLEG_LTF = 8 + 8 = 16
// TL_SIG           = 4
// THT_SIG          = 8
// THT_PREAMBLE     = THT_STF    + THT_LTF1 + nTHT_LTF    = 4 + 4 + (4*(nTHT_LTF-1))
// TGF_HT_PREAMBLE  = THT_GF_STF + THT_LTF1 + nTHT_LTF    = 8 + 8 + (4*(nTHT_LTF-1))
// nTHT_LTF         = See Table 20-12, Table 20-13, Table 20-14
// TSYM             = 4
// TSYMS            = 3.6
// SignalExtension  = 0 for RW IPs
// NSYM             = mSTBC * (Ceiling( ( (8*LENGTH) + 16 + (6*NES) )/(mSTBC*NDBPS) )
// mSTBC            = If no STBC then 1 esle 2
// NDBPS            = See Chptr 20.6 Parameters for HT MCSs
// NES              = See Chptr 20.6 Parameters for HT MCSs
//
//
///////////////////////////
// IEEE P802.11ac D3.0
//
///////////////////////////
// For VHT short GI
// TXTIME = TLEG_PREAMBLE + TL_SIG + TVHT_SIG_A + TVHT_PREAMBLE + TVHT_SIG_B + (TSYM * Ceiling( ( (TSYMS * NSYM) / TSYM) ) )
//
// For VHT regular GI
// TXTIME = TLEG_PREAMBLE + TL_SIG + TVHT_SIG_A + TVHT_PREAMBLE + TVHT_SIG_B + TSYM * NSYM
//
//
// TLEG_PREAMBLE    = TLEG_TSF + TLEG_LTF = 8 + 8 = 16
// TL_SIG           = 4
// TVHT_SIG_A       = 8
// TVHT_SIG_B       = 8
// TVHT_PREAMBLE    = TVHT_STF + nTHT_LTF = 4 + (4*nTVHT_LTF)
// nTVHT_LTF        = See Table 22-13
// TSYM             = 4
// TSYMS            = 3.6
// NSYM             = mSTBC * (Ceiling( ( (8*LENGTH) + 16 + (6*NES) )/(mSTBC*NDBPS) )
// mSTBC            = If no STBC then 1 esle 2
// NDBPS            = See Chptr 22.5 Parameters for VHT MCSs
// NES              = See Chptr 22.5 Parameters for VHT MCSs

#ifndef DURATION_CALC_AC
#define DURATION_CALC_AC

// DSS CCK
#define SHORT_PRE  96
#define LONG_PRE   192

// OFDM
#define L_STF      8
#define L_LTF      8
#define L_SIG      4

#define OFDM_NON_HT_PRE  (L_STF + L_LTF + L_SIG)

#define HT_STF     4
#define HT_LTF     4
#define HT_SIG     8

#define OFDM_HT_MM_PRE_BASE  (OFDM_NON_HT_PRE + HT_SIG + HT_STF + HT_LTF)

#define HT_GF_STF  8
#define HT_LTF1    8

#define OFDM_HT_GF_PRE_BASE  (HT_GF_STF + HT_LTF1 + HT_SIG)

#define VHT_STF    4
#define VHT_LTF    4
#define VHT_SIG_A  8
#define VHT_SIG_B  4

#define OFDM_VHT_PRE_BASE  (OFDM_NON_HT_PRE + VHT_SIG_A + VHT_STF + VHT_SIG_B + VHT_LTF)

// LEGACY  RATES and NSYM in Mbps
const float LEGACY_NON_OFDM_RATE[4] = {1, 2, 5.5, 11};

// IEEE Std 802.11 - 2012 Table 18-4—Modulation-dependent parameters
const int   LEGACY_OFDM_NDBPS[8] =
{
 // data rate   6    9    12   18   24   36    48    54
 // MCS index   4    5    6    7    8    9     10    11
                24,  36,  48,  72,  96,  144,  192,  216
};

// HT NSYM
#define HT_BW   2
#define HT_MCS  77

// REF IEEE Std 802.11 - 2012 Chptr 20.6 Parameters for HT MCSs
const int HT_NDBPS[HT_BW][HT_MCS] = {
  // BW 20 MHz
  {
      //  MCS Index
      //  0        1         2         3         4         5         6         7
          26,      52,       78,       104,      156,      208,      234,      260,
      //  8        9         10        11        12        13        14        15
          52,      104,      156,      208,      312,      416,      468,      520,
      //  16       17        18        19        20        21        22        23
          78,      156,      234,      312,      468,      624,      702,      780,
      //  24       25        26        27        28        29        30        31
          104,     208,      312,      416,      624,      832,      936,      1040,
      //  32(error)33        34        35        36        37        38        39
          1,       156,      208,      260,      234,      312,      390,      208,
      //  40       41        42        43        44        45        46        47
          260,     260,      312,      364,      364,      416,      312,      390,
      //  48       49        50        51        52        53        54        55
          390,     468,      546,      546,      624,      260,      312,      364,
      //  56       57        58        59        60        61        62        63
          312,     364,      416,      468,      416,      468,      520,      520,
      //  64       65        66        67        68        69        70        71
          572,     390,      468,      546,      468,      546,      624,      702,
      //  72       73        74        75        76
          624,     702,      780,      780,      858
  },
  // BW 40 MHz
  {
      //  MCS Index
      //  0        1         2         3         4         5         6         7
          54,      108,      162,      216,      324,      432,      486,      540,
      //  8        9         10        11        12        13        14        15
          108,     216,      324,      432,      648,      864,      972,      1080,
      //  16       17        18        19        20        21        22        23
          162,     324,      486,      648,      972,      1296,     1458,     1620,
      //  24       25        26        27        28        29        30        31
          216,     432,      648,      864,      1296,     1728,     1944,     2160,
      //  32       33        34        35        36        37        38        39
          24,      324,      432,      540,      486,      648,      810,      432,
      //  40       41        42        43        44        45        46        47
          540,     540,      648,      756,      756,      864,      648,      810,
      //  48       49        50        51        52        53        54        55
          810,     972,      1134,     1134,     1296,     540,      648,      756,
      //  56       57        58        59        60        61        62        63
          648,     756,      864,      972,      864,      972,      1080,     1080,
      //  64       65        66        67        68        69        70        71
          1188,    810,      972,      1134,     972,      1134,     1296,     1458,
      //  72       73        74        75        76
          1296,    1458,     1620,     1620,     1782
  }
};

// VHT NSYM
#define VHT_BW   4
#define VHT_NSS  8
#define VHT_MCS  10

// IEEE P802.11ac D3.0  Chptr 22.5 Parameters for VHT MCSs
const int VHT_NDBPS[VHT_BW][VHT_NSS][VHT_MCS] = {
    // 20MHz
    {
        // NSS 1
        {
            //    MCS Index
            //    0       1        2        3        4        5        6        7        8        9(error)
                  26,     52,      78,      104,     156,     208,     234,     260,     312,     1
        },
        // NSS 2
        {
            //    0       1        2        3        4        5        6        7        8        9(error)
                  52,     104,     156,     208,     312,     416,     468,     520,     624,     1
        },
        // NSS 3
        {
            //    0       1        2        3        4        5        6        7        8        9
                  78,     156,     234,     312,     468,     624,     702,     780,     936,     1040,
        },
        // NSS 4
        {
            //    0       1        2        3        4        5        6        7        8        9(error)
                  104,    208,     312,     416,     624,     832,     936,     1040,    1248,    1
        },
        // NSS 5
        {
            //    0       1        2        3        4        5        6        7        8        9(error)
                  130,    260,     390,     520,     780,     1040,    1170,    1300,    1560,    1
        },
        // NSS 6
        {
            //    0       1        2        3        4        5        6        7        8        9
                  156,    312,     468,     624,     936,     1248,    1404,    1560,    1872,    2080,
        },
        // NSS 7
        {
            //    0       1        2        3        4        5        6        7        8        9(error)
                  182,    364,     546,     728,     1092,    1456,    1638,    1820,    2184,    1
        },
        // NSS 8
        {
            //    0       1        2        3        4        5        6        7        8        9(error)
                  208,    416,     624,     832,     1248,    1664,    1872,    2080,    2496,    1
        }
    },
    // 40MHz
    {
        // NSS 1
        {
            //    0       1        2        3        4        5        6        7        8        9
                  54,     108,     162,     216,     324,     432,     486,     540,     648,     720
        },
        // NSS 2
        {
            //    0       1        2        3        4        5        6        7        8        9
                  108,    216,     324,     432,     648,     864,     972,     1080,    1296,    1440
        },
        // NSS 3
        {
            //    0       1        2        3        4        5        6        7        8        9
                  162,    324,     486,     648,     972,     1296,    1458,    1620,    1944,    2160
        },
        // NSS 4
        {
            //    0       1        2        3        4        5        6        7        8        9
                  216,    432,     648,     864,     1296,    1728,    1944,    2160,    2592,    2880
        },
        // NSS 5
        {
            //    0       1        2        3        4        5        6        7        8        9
                  270,    540,     810,     1080,    1620,    2160,    2430,    2700,    3240,    3600
        },
        // NSS 6
        {
            //    0       1        2        3        4        5        6        7        8        9
                  324,    648,     972,     1296,    1944,    2592,    2916,    3240,    3888,    4320
        },
        // NSS 7
        {
            //    0       1        2        3        4        5        6        7        8        9
                  378,    756,     1134,    1512,    2268,    3024,    3402,    3780,    4536,    5040
        },
        // NSS 8
        {
            //    0       1        2        3        4        5        6        7        8        9
                  432,    864,     1296,    1728,    2592,    3456,    3888,    4320,    5184,    5760
        }
    },
    // 80MHz
    {
        // NSS 1
        {
            //    0       1        2        3        4        5        6        7        8        9
                  117,    234,     351,     468,     702,     936,     1053,    1170,    1404,    1560
        },
        // NSS 2
        {
            //    0       1        2        3        4        5        6        7        8        9
                  234,    468,     702,     936,     1404,    1872,    2106,    2340,    2808,    3120
        },
        // NSS 3
        {
            //    0       1        2        3        4        5        6(error) 7        8        9
                  351,    702,     1053,    1404,    2106,    2808,    1,       3510,    4212,    4680
        },
        // NSS 4
        {
            //    0       1        2        3        4        5        6        7        8        9
                  468,    936,     1404,    1872,    2808,    3744,    4212,    4680,    5616,    6240
        },
        // NSS 5
        {
            //    0       1        2        3        4        5        6        7        8        9
                  585,    1170,    1755,    2340,    3510,    4680,    5265,    5850,    7020,    7800
        },
        // NSS 6
        {
            //    0       1        2        3        4        5        6        7        8        9(error)
                  702,    1404,    2106,    2808,    4212,    5616,    6318,    7020,    8424,    1
        },
        // NSS 7
        {
            //    0       1        2        3        4        5        6(error) 7        8        9
                  819,    1638,    2457,    3276,    4914,    6552,    1,       8190,    9828,    10920
        },
        // NSS 8
        {
            //    0       1        2        3        4        5        6        7        8        9
                  936,    1872,    2808,    3744,    5616,    7488,    8424,    9360,    11232,   12480
        }
    },
    // 160MHz
    {
        // NSS 1
        {
            //    0       1        2        3        4        5        6        7        8        9
                  234,    468,     702,     936,     1404,    1872,    2106,    2340,    2808,    3120
        },
        // NSS 2
        {
            //    0       1        2        3        4        5        6        7        8        9
                  468,    936,     1404,    1872,    2808,    3744,    4212,    4680,    5616,    6240
        },
        // NSS 3
        {
            //    0       1        2        3        4        5        6        7        8        9(error)
                  702,    1404,    2106,    2808,    4212,    5616,    6318,    7020,    8424,    1
        },
        // NSS 4
        {
            //    0       1        2        3        4        5        6        7        8        9
                  936,    1872,    2808,    3744,    5616,    7488,    8424,    9360,    11232,   12480
        },
        // NSS 5
        {
            //    0       1        2        3        4        5        6        7        8        9
                  1170,   2340,    3510,    4680,    7020,    9360,    10530,   11700,   14040,   15600
        },
        // NSS 6
        {
            //    0       1        2        3        4        5        6        7        8        9
                  1404,   2808,    4212,    5616,    8424,    11232,   12636,   14040,   16848,   18720
        },
        // NSS 7
        {
            //    0       1        2        3        4        5        6        7        8        9
                  1638,   3276,    4914,    6552,    9828,    13104,   14742,   16380,   19656,   21840
        },
        // NSS 8
        {
            //    0       1        2        3        4        5        6        7        8        9
                  1872,   3744,    5616,    7488,    11232,   14976,   16848,   18720,   22464,   24960
        }
    }
};

#endif //DURATION_CALC_AC
