//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: dtruong $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 5166 $
// $Date: 2012-12-03 17:09:56 +0100 (Mon, 03 Dec 2012) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
//   This is the PHY Tx/Rx vector. It contains control parameters to/from the
//   Modem. It also contains a function for TX-TIME calculation.
//
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


///////////////////////////
// IEEE P802.11ax D2.0
//
///////////////////////////
// TXTIME = 20 + THE_PREAMBLE + NSYM * TSYM + NMA * NHE-LTF * THE-LTF-SYM + TPE + SignalExtension
//
// THE_PREAMBLE:
//   HE SU PPDU   : TRL-SIG + THE-SIG-A   +                       THE-STF-NT + NHE-LTF*THE-LTF-SYM
//   HE ER SU PPDU: TRL-SIG + THE-SIG-A-R +                       THE-STF-NT + NHE-LTF*THE-LTF-SYM
//   HE MU PPDU   : TRL-SIG + THE-SIG-A   + NHE-SIG-B*THE-SIG-B + THE-STF-NT + NHE-LTF*THE-LTF-SYM
//   HE TB PPDU   : TRL-SIG + THE-SIG-A   +                       THE-STF-T  + NHE-LTF*THE-LTF-SYM
//
// TRL_SIG          = 4
// THE_SIG_A        = 8
// THE_SIG_A_R      = 16
// THE_STF_T        = 8
// THE_STF_NT       = 4
// THE_SIG_B        = 4
// THE-LTF-SYM      = THE-LTF + TGI,HE-LTF
// THE-LTF          = THE-LTF-1X, THE-LTF-2X or THE-LTF-4X depending upon the LTF duration used
// THE_LTF_1X       = 3.2
// THE_LTF_2X       = 6.4
// THE_LTF_4X       = 12.8
// TGI,HE-LTF       = TGI1,Data, TGI2,Data or TGI4,Data depending on the GI used for data
// TGI,Data         = TGI1,Data, TGI2,Data or TGI4,Data depending on the GI used for data
// TGI1,Data        = 0.8
// TGI2,Data        = 1.6
// TGI4,Data        = 3.2
// TSYM1            = 13.6 = TDFT,HE + TGI1,Data
// TSYM2            = 14.4 = TDFT,HE + TGI2,Data
// TSYM4            = 16   = TDFT,HE + TGI4,Data
//

#ifndef DURATION_CALC_AX
#define DURATION_CALC_AX

// REF IEEE Std 802.11ax/D2.0 - 2017 Table 28-12 (Timing-related constants)
#define TRL_SIG        4
#define THE_SIG_A      8
#define THE_SIG_A_R   16
#define THE_STF_T      8
#define THE_STF_NT     4
#define THE_LTF_1X   3.2
#define THE_LTF_2X   6.4
#define THE_LTF_4X  12.8
#define THE_SIG_B      4
#define TGI1_DATA    0.8
#define TGI2_DATA    1.6
#define TGI4_DATA    3.2
#define TDFT_HE     12.8
#define NSERVICE      16

// HE Preamble
#define HE_SU_PRE_BASE    (TRL_SIG + THE_SIG_A   + THE_STF_NT)
#define HE_MU_PRE_BASE    (TRL_SIG + THE_SIG_A   + THE_STF_NT)
#define HE_ER_SU_PRE_BASE (TRL_SIG + THE_SIG_A_R + THE_STF_NT)
#define HE_TB_PRE_BASE    (TRL_SIG + THE_SIG_A   + THE_STF_T )


// REF IEEE Std 802.11ax/D2.0 - 2017 Chapter 28-5
#define HE_MCS 12
const float R[HE_MCS] = {
   // MCS
   // 0      1      2      3      4      5      6      7      8      9      10     11
      1.0/2, 1.0/2, 3.0/4, 1.0/2, 3.0/4, 2.0/3, 3.0/4, 5.0/6, 3.0/4, 5.0/6, 3.0/4, 5.0/6
};

const float NBPSCS[HE_MCS] = {
   // MCS
   // 0    1    2    3    4    5    6    7    8    9    10   11
      1,   2,   2,   4,   4,   6,   6,   6,   8,   8,   10,  10
};

// REF IEEE Std 802.11ax/D2.0 - 2017 Table 28-29
#define HE_DCM     2
#define HE_RU_SIZE 7
const int HE_NSDSHORT[HE_DCM][HE_RU_SIZE] = {
   // DCM=0
   {
      //  RU size
      //  26       52        106       242       484       996       2x996
          6,       12,       24,       60,       120,      240,      492
   },
   // DCM=1
   {
      //  RU size
      //  26       52        106       242       484       996       2x996
          2,       6,        12,       30,       60,       120,      246
   }
};

// REF IEEE Std 802.11ax/D2.0 - 2017 Chapter 28-5
#define HE_NSS 2 // Only 1x1 20Mhz supported
const int HE_NDBPS[HE_RU_SIZE][HE_NSS][HE_MCS][HE_DCM] = {
   // ruType=26, Nss=1
   {{
      {  12,   6}, // MCS=0, DCM=0/1
      {  24,  12}, // MCS=1, DCM=0/1
      {  36},      // MCS=2, DCM=0
      {  48,  24}, // MCS=3, DCM=0/1
      {  72,  36}, // MCS=4, DCM=0/1
      {  96},      // MCS=5, DCM=0
      { 108},      // MCS=6, DCM=0
      { 120},      // MCS=7, DCM=0
      { 144},      // MCS=8, DCM=0
      { 160},      // MCS=9, DCM=0
      { 180},      // MCS=10, DCM=0
      { 200}       // MCS=11, DCM=0
    },
   // ruType=26, Nss=2
    {
      {  24,  12}, // MCS=0, DCM=0/1
      {  48,  24}, // MCS=1, DCM=0/1
      {  72},      // MCS=2, DCM=0
      {  96,  48}, // MCS=3, DCM=0/1
      { 144 , 72}, // MCS=4, DCM=0/1
      { 192},      // MCS=5, DCM=0
      { 216},      // MCS=6, DCM=0
      { 240},      // MCS=7, DCM=0
      { 288},      // MCS=8, DCM=0
      { 320},      // MCS=9, DCM=0
      { 360},      // MCS=10, DCM=0
      { 400}       // MCS=11, DCM=0
    }
   },
   // ruType=52, Nss=1
   {{
      {  24,  12}, // MCS=0, DCM=0/1
      {  48,  24}, // MCS=1, DCM=0/1
      {  72},      // MCS=2, DCM=0
      {  96,  48}, // MCS=3, DCM=0/1
      { 144,  72}, // MCS=4, DCM=0/1
      { 192},      // MCS=5, DCM=0
      { 216},      // MCS=6, DCM=0
      { 240},      // MCS=7, DCM=0
      { 288},      // MCS=8, DCM=0
      { 320},      // MCS=9, DCM=0
      { 360},      // MCS=10, DCM=0
      { 400}       // MCS=11, DCM=0
    },
   // ruType=52, Nss=2
    {
      {  48,  24}, // MCS=0, DCM=0/1
      {  96,  48}, // MCS=1, DCM=0/1
      { 144},      // MCS=2, DCM=0
      { 192,  96}, // MCS=3, DCM=0/1
      { 288, 144}, // MCS=4, DCM=0/1
      { 384},      // MCS=5, DCM=0
      { 432},      // MCS=6, DCM=0
      { 480},      // MCS=7, DCM=0
      { 576},      // MCS=8, DCM=0
      { 640},      // MCS=9, DCM=0
      { 720},      // MCS=10, DCM=0
      { 800}       // MCS=11, DCM=0
    }
   },
   // ruType=106, Nss=1
   {{
      {  51,  25}, // MCS=0, DCM=0/1
      { 102,  51}, // MCS=1, DCM=0/1
      { 153},      // MCS=2, DCM=0
      { 204, 102}, // MCS=3, DCM=0/1
      { 306, 153}, // MCS=4, DCM=0/1
      { 408},      // MCS=5, DCM=0
      { 459},      // MCS=6, DCM=0
      { 510},      // MCS=7, DCM=0
      { 612},      // MCS=8, DCM=0
      { 680},      // MCS=9, DCM=0
      { 765},      // MCS=10, DCM=0
      { 850}       // MCS=11, DCM=0
    },
   // ruType=106, Nss=2
    {
      { 102,  51}, // MCS=0, DCM=0/1
      { 204, 102}, // MCS=1, DCM=0/1
      { 306},      // MCS=2, DCM=0
      { 408, 204}, // MCS=3, DCM=0/1
      { 612, 306}, // MCS=4, DCM=0/1
      { 816},      // MCS=5, DCM=0
      { 918},      // MCS=6, DCM=0
      {1020},      // MCS=7, DCM=0
      {1224},      // MCS=8, DCM=0
      {1360},      // MCS=9, DCM=0
      {1530},      // MCS=10, DCM=0
      {1700}       // MCS=11, DCM=0
    }
   },
   // ruType=242, Nss=1
   {{
      { 117,  58}, // MCS=0, DCM=0/1
      { 234, 117}, // MCS=1, DCM=0/1
      { 351},      // MCS=2, DCM=0
      { 468, 234}, // MCS=3, DCM=0/1
      { 702, 351}, // MCS=4, DCM=0/1
      { 936},      // MCS=5, DCM=0
      {1053},      // MCS=6, DCM=0
      {1170},      // MCS=7, DCM=0
      {1404},      // MCS=8, DCM=0
      {1560},      // MCS=9, DCM=0
      {1755},      // MCS=10, DCM=0
      {1950}       // MCS=11, DCM=0
    },
   // ruType=242, Nss=2
    {
      { 234, 117}, // MCS=0, DCM=0/1
      { 468, 234}, // MCS=1, DCM=0/1
      { 702},      // MCS=2, DCM=0
      { 936, 468}, // MCS=3, DCM=0/1
      {1404, 702}, // MCS=4, DCM=0/1
      {1872},      // MCS=5, DCM=0
      {2106},      // MCS=6, DCM=0
      {2340},      // MCS=7, DCM=0
      {2808},      // MCS=8, DCM=0
      {3120},      // MCS=9, DCM=0
      {3510},      // MCS=10, DCM=0
      {3900}       // MCS=11, DCM=0
    }
   },
   // ruType=484, Nss=1
   {{
      { 234, 117}, // MCS=0, DCM=0/1
      { 468, 234}, // MCS=1, DCM=0/1
      { 702},      // MCS=2, DCM=0
      { 936, 468}, // MCS=3, DCM=0/1
      {1404, 702}, // MCS=4, DCM=0/1
      {1872},      // MCS=5, DCM=0
      {2106},      // MCS=6, DCM=0
      {2340},      // MCS=7, DCM=0
      {2808},      // MCS=8, DCM=0
      {3120},      // MCS=9, DCM=0
      {3510},      // MCS=10, DCM=0
      {3900}       // MCS=11, DCM=0
    },
   // ruType=484, Nss=2
    {
      { 468, 234}, // MCS=0, DCM=0/1
      { 936, 468}, // MCS=1, DCM=0/1
      {1404},      // MCS=2, DCM=0
      {1872, 936}, // MCS=3, DCM=0/1
      {2808,1404}, // MCS=4, DCM=0/1
      {3744},      // MCS=5, DCM=0
      {4212},      // MCS=6, DCM=0
      {4680},      // MCS=7, DCM=0
      {5616},      // MCS=8, DCM=0
      {6240},      // MCS=9, DCM=0
      {7020},      // MCS=10, DCM=0
      {7800}       // MCS=11, DCM=0
    }
   },
   // ruType=996, Nss=1
   {{
      { 490, 245}, // MCS=0, DCM=0/1
      { 980, 490}, // MCS=1, DCM=0/1
      {1470},      // MCS=2, DCM=0
      {1960, 980}, // MCS=3, DCM=0/1
      {2940,1470}, // MCS=4, DCM=0/1
      {3920},      // MCS=5, DCM=0
      {4410},      // MCS=6, DCM=0
      {4900},      // MCS=7, DCM=0
      {5880},      // MCS=8, DCM=0
      {6533},      // MCS=9, DCM=0
      {7350},      // MCS=10, DCM=0
      {8166}       // MCS=11, DCM=0
    },
   // ruType=996, Nss=2
    {
      { 980, 490}, // MCS=0, DCM=0/1
      {1960, 980}, // MCS=1, DCM=0/1
      {2940},      // MCS=2, DCM=0
      {3920,1960}, // MCS=3, DCM=0/1
      {5880,2940}, // MCS=4, DCM=0/1
      {7840},      // MCS=5, DCM=0
      {8820},      // MCS=6, DCM=0
      {9800},      // MCS=7, DCM=0
      {11760},     // MCS=8, DCM=0
      {13066},     // MCS=9, DCM=0
      {14700},     // MCS=10, DCM=0
      {16333}      // MCS=11, DCM=0
    }
   },
   // ruType=2x996, Nss=1
   {{
      { 980, 490}, // MCS=0, DCM=0/1
      {1960, 980}, // MCS=1, DCM=0/1
      {2940},      // MCS=2, DCM=0
      {3920,1960}, // MCS=3, DCM=0/1
      {5880,2940}, // MCS=4, DCM=0/1
      {7840},      // MCS=5, DCM=0
      {8820},      // MCS=6, DCM=0
      {9800},      // MCS=7, DCM=0
      {11760},     // MCS=8, DCM=0
      {13066},     // MCS=9, DCM=0
      {14700},     // MCS=10, DCM=0
      {16333}      // MCS=11, DCM=0
    },
   // ruType=2x996, Nss=2
    {
      {1960, 980}, // MCS=0, DCM=0/1
      {3920,1960}, // MCS=1, DCM=0/1
      {5880},      // MCS=2, DCM=0
      {7840,3920}, // MCS=3, DCM=0/1
      {11760,5880},// MCS=4, DCM=0/1
      {15680},     // MCS=5, DCM=0
      {17640},     // MCS=6, DCM=0
      {19600},     // MCS=7, DCM=0
      {23520},     // MCS=8, DCM=0
      {26133},     // MCS=9, DCM=0
      {29400},     // MCS=10, DCM=0
      {32666}      // MCS=11, DCM=0
    }
   }
};

// REF IEEE Std 802.11 - 2012 Chptr 20.6 Parameters for HT MCSs
const int HESIGB_NDBPS[6] = {
      //  MCS Index
      //  0        1         2         3         4         5
          26,      52,       78,       104,      156,      208
};

// structure for HESIGB field, used in C code for
// compute time on air
typedef struct
{
  int compressed_mode;
  int dcm;
  int mcs;
  int ru_allocation;
} HESIGB_s;

#endif //DURATION_CALC_AX
