#!/usr/bin/perl
use strict;
no strict 'refs';
use paracom;

################################################################################
# extract options
################################################################################
foreach my $v (@ARGV)
{
  $v =~ /([a-z_0-9]+)=(.+)/;
  ${"$1"} = $2;
}

################################################################################
#
################################################################################
my $display=0;
$display = ${"display"} if(${"display"} ne "");

# input parameter coverage
my $rulen=-1;
my $heltf_gi=-1;
my $t_pe=-1;
my $mcs=-1;
my $dcm=-1;
my $ref_nsym=-1;

$rulen    = ${"rulen"}    if(${"rulen"}    ne "");
$heltf_gi = ${"heltf_gi"} if(${"heltf_gi"} ne "");
$t_pe     = ${"t_pe"}     if(${"t_pe"}     ne "");
$mcs      = ${"mcs"}      if(${"mcs"}      ne "");
$dcm      = ${"dcm"}      if(${"dcm"}      ne "");
$ref_nsym = ${"ref_nsym"} if(${"ref_nsym"} ne "");

die "error: wrong rulen paramters"    if($rulen==-1);
die "error: wrong heltf_gi paramters" if($heltf_gi==-1);
die "error: wrong t_pe paramters"     if($t_pe==-1);
die "error: wrong mcs paramters"      if($mcs==-1);
die "error: wrong dcm paramters"      if($dcm==-1);
die "error: wrong ref_nsym paramters" if($ref_nsym==-1);

# coverage loop
my ($nes,$r,$mstbc);
my ($nsd,$nsd_short);
my ($nbpsc,$crn,$crd);
my ($txtime,$nsym,$pe_disamb);
my $a_init;
my $nsym_init;
my ($ncbps,$ncbps_short,$ncbps_last_init);
my ($ndbps,$ndbps_short,$ndbps_last_init);
my $npld;
my $navbits;
my ($psdulen,$npad);
my ($ncw,$lldpc);
my ($npunc,$npuncq,$npuncr);
my ($nshrt,$nshrtq,$nshrtr);
my ($nrep,$nrepq,$nrepr);
my ($fec,$extra);
my ($t_sym,$t_gi,$t_he,$t_heltf_sym,$t_pe);
my ($l_length,$apep_length);
my $t_he_preamble;
my $inconsistent;
my ($heltf_type,$gi_type);


my $mstbc=1;

# rulen
($nsd,$nsd_short) = ( 24,  6) if($dcm==0 && $rulen==26);
($nsd,$nsd_short) = ( 48, 12) if($dcm==0 && $rulen==52);
($nsd,$nsd_short) = (102, 24) if($dcm==0 && $rulen==106);
($nsd,$nsd_short) = (234, 60) if($dcm==0 && $rulen==242);
($nsd,$nsd_short) = (468,120) if($dcm==0 && $rulen==484);
($nsd,$nsd_short) = (980,240) if($dcm==0 && $rulen==996);

($nsd,$nsd_short) = ( 12,  2) if($dcm==1 && $rulen==26);
($nsd,$nsd_short) = ( 24,  6) if($dcm==1 && $rulen==52);
($nsd,$nsd_short) = ( 51, 12) if($dcm==1 && $rulen==106);
($nsd,$nsd_short) = (117, 30) if($dcm==1 && $rulen==242);
($nsd,$nsd_short) = (234, 60) if($dcm==1 && $rulen==484);
($nsd,$nsd_short) = (490,120) if($dcm==1 && $rulen==996);

($fec,$nes) = (0,1) if($rulen<484);
($fec,$nes) = (1,0) if($rulen>=484);

# heltf_gi
($t_he,$t_gi) = split ":",$heltf_gi;
$t_heltf_sym  = $t_gi + $t_he;
$t_sym        = $t_gi + 12.8;
$heltf_type = 0 if($t_he eq "3.2");
$heltf_type = 1 if($t_he eq "6.4");
$heltf_type = 2 if($t_he eq "12.8");
$gi_type    = 0 if($t_gi eq "0.8");
$gi_type    = 1 if($t_gi eq "1.6");
$gi_type    = 2 if($t_gi eq "3.2");

$t_he_preamble = 20 + 1*$t_heltf_sym ;

# t_pe
# mcs
($nbpsc,$crn,$crd) = ( 1, 1,2) if($mcs== 0);
($nbpsc,$crn,$crd) = ( 2, 1,2) if($mcs== 1);
($nbpsc,$crn,$crd) = ( 2, 3,4) if($mcs== 2);
($nbpsc,$crn,$crd) = ( 4, 1,2) if($mcs== 3);
($nbpsc,$crn,$crd) = ( 4, 3,4) if($mcs== 4);
($nbpsc,$crn,$crd) = ( 6, 2,3) if($mcs== 5);
($nbpsc,$crn,$crd) = ( 6, 3,4) if($mcs== 6);
($nbpsc,$crn,$crd) = ( 6, 5,6) if($mcs== 7);
($nbpsc,$crn,$crd) = ( 8, 3,4) if($mcs== 8);
($nbpsc,$crn,$crd) = ( 8, 5,6) if($mcs== 9);
($nbpsc,$crn,$crd) = (10, 3,4) if($mcs==10);
($nbpsc,$crn,$crd) = (10, 5,6) if($mcs==11);

# nsym
########################################################################
########################################################################

# txtime
$txtime        = 20 + 20 + 1*$t_heltf_sym + $ref_nsym*$t_sym + $t_pe;

# l_length
($l_length,$r) = paracom::div( int(10*($txtime-20)), 10*4);
$l_length++ if($r!=0);
$l_length      = $l_length*3-5;

########################################################################
########################################################################

# pe_disamb
$pe_disamb = 0;
$pe_disamb = 1 if($t_pe==16);
$pe_disamb = 1 if($t_pe==12 && $t_heltf_sym==8 && $l_length==49);
$pe_disamb = 1 if($t_pe==12 && $t_heltf_sym==8 && $l_length==70);
$pe_disamb = 1 if($t_pe==12 && $t_heltf_sym==8 && $l_length==103);
$pe_disamb = 1 if($t_pe==12 && $t_heltf_sym==8 && $l_length==124);
$pe_disamb = 1 if($t_pe==12 && $t_heltf_sym==8 && $l_length==157);
$pe_disamb = 1 if($t_pe==12 && $t_heltf_sym==8 && $l_length==178);
$pe_disamb = 1 if($t_pe==12 && $t_heltf_sym==8 && $l_length==211);
$pe_disamb = 1 if($t_pe==12 && $t_heltf_sym==8 && $l_length==232);
$pe_disamb = 1 if($t_pe==12 && $t_heltf_sym==8 && $l_length==265);
$pe_disamb = 1 if($t_pe==12 && $t_heltf_sym==8 && $l_length==286);
$pe_disamb = 1 if($t_pe==12 && $t_heltf_sym==8 && $l_length==319);
$pe_disamb = 1 if($t_pe==12 && $t_heltf_sym==8 && $l_length==340);
$pe_disamb = 1 if($t_pe==12 && $t_heltf_sym==8 && $l_length==373);

# nsym
next if( (($l_length+5)*40-int(30*$t_he_preamble)) <0);
($nsym,$r) = paracom::div( ($l_length+5)*40-int(30*$t_he_preamble) , int(30*$t_sym));
$nsym--  if($pe_disamb==1);
next if($nsym<0);

$a = 4;

$nsym_init = $nsym;
if($fec==0)
{
  $a_init    = 4;
}
else
{
  $a_init    = 3;
}

# ncbps
$ncbps           = $nbpsc * $nsd;
$ncbps_short     = $nbpsc * $nsd_short;
$ncbps_last_init = $ncbps               if($a_init==4);
$ncbps_last_init = $a_init*$ncbps_short if($a_init!=4);

# ndbps
$ndbps           = int($ncbps       * $crn / $crd);
$ndbps_short     = int($ncbps_short * $crn / $crd);
$ndbps_last_init = $ndbps               if($a_init==4);
$ndbps_last_init = $a_init*$ndbps_short if($a_init!=4);

# npld
$npld = ($nsym_init-$mstbc)*$ndbps + $mstbc*$ndbps_last_init;

# navbits
$navbits = ($nsym_init-$mstbc)*$ncbps + $mstbc*$ncbps_last_init;

# psdulen , npad (phy pre-fec padding)
if( ($npld-16-$nes*6) < 0) {exit();};
($psdulen,$npad) = paracom::div($npld-16-$nes*6,8);

#
$ncw    = 0;
$lldpc  = 648;
($nshrt, $nshrtq, $nshrtr) = (0,0,0);
($npunc, $npuncq, $npuncr) = (0,0,0);
($nrep,  $nrepq,   $nrepr) = (0,0,0);

if($fec==1)
{
  # ncw,lldpc
  ($ncw,$lldpc) = paracom::proc_ncw_lldpc($npld,$navbits,$crd);

  # nshrt
  $nshrt = paracom::proc_nshrt($npld,$ncw,$lldpc,$crn,$crd);

  # update navbits (extra always set)
  $navbits = $navbits + $mstbc*($ncbps-3*$ncbps_short);

  # update npunc
  $npunc = paracom::proc_npunc($navbits,$ncw,$lldpc,$nshrt);

  # nrep
  $nrep = paracom::proc_nrep($npld,$navbits,$ncw,$lldpc,$crd);

  ($nshrtq, $nshrtr) = paracom::div($nshrt,$ncw);
  ($npuncq, $npuncr) = paracom::div($npunc,$ncw);
  ($nrepq,   $nrepr) = paracom::div($nrep,$ncw);
}

printf "gi_type          = %d\n",$gi_type;
printf "heltf_type       = %d\n",$heltf_type;

printf "txtime           = %d\n",$txtime;
printf "l_length         = %d\n",$l_length;
printf "pe_disamb        = %d\n",$pe_disamb;

printf "dcm              = %d\n",$dcm;
printf "nbpsc            = %d\n",$nbpsc;
printf "cr               = %d/%d\n",$crn,$crd;

printf "ncbps            = %d\n",$ncbps;
printf "ndbps            = %d\n",$ndbps;
printf "fec              = %d\n",$fec;
printf "nsym             = %d\n",$nsym;
printf "nsym_init        = %d\n",$nsym_init;
printf "a_init           = %d\n",$a_init;
printf "psdulen          = %d\n",$psdulen;
printf "npad             = %d\n",$npad;

printf "npld             = %d\n",$npld;
printf "navbits          = %d\n",$navbits;
printf "ncw              = %d\n",$ncw;
printf "lldpc            = %d\n",$lldpc;
printf "(nshrtq, nshrtr) = (%d,%d)\n",$nshrtq, $nshrtr;
printf "(npuncq, npuncr) = (%d,%d)\n",$npuncq, $npuncr;
printf "(nrepq,   nrepr) = (%d,%d)\n",$nrepq,   $nrepr;


