/**
 ******************************************************************************
 * @file mfp_bip.h
 *
 * @brief Manangement Frames protection module definitions.
 *
 * Copyright (C) RivieraWaves 2015
 *
 ******************************************************************************
 */

#ifndef _MFP_BIP_H_
#define _MFP_BIP_H_

#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include <stdio.h>
//#include "mac.h"

/**
 * @brief Compute MIC for BIP (Broadcast Integrity Protocol)
 *
 * @param[out] mic        MIC for BIP
 * @param[in]  key        Key for BIP (aka IGTK)
 * @param[in]  input16    Frame
 * @param[in]  length     Size in bytes of the frame
 *
 */
void mfp_compute_bip(uint32_t *mic,     uint32_t *key,
                     uint16_t *input16, uint16_t length);

#endif
