/**
 *******************************************************************************
 * @file rw_hsu.c
 *
 * @brief Hardware Security Unit module.
 *
 * Copyright (C) RivieraWaves 2015
 *
 *******************************************************************************
 */
#include <stdlib.h>
#include <stdio.h> 
#include "rw_hsu.h"
#include "acc_user.h"
#include "mfp_bip.h"
#include "me_mic.h"

uint16_t *input16;
uint32_t *input32;
uint16_t ptr;

/*
 * -----------------------------------------------------------------------------
 * Message memory allocation & initialisation
 *------------------------------------------------------------------------------
 */
int msg_init ()
{
   int len8  = acc_fetch_tfarg_int(1);
   int len16 = (len8/2)+(len8%2);
   int len32 = (len16/2)+(len16%2);

   free(input16);
   free(input32);
   input16 = (uint16_t *) malloc(sizeof(uint16_t *) * len16);
   input32 = (uint32_t *) malloc(sizeof(uint32_t *) * len32);

   ptr = 0;

   return(true);
}


/*
 *------------------------------------------------------------------------------
 * Append a byte in the message
 *------------------------------------------------------------------------------
 */
int msg_append ()
{
   if (ptr%2)
      input16[ptr/2] += (acc_fetch_tfarg_int(1)&0xff)<<8;
   else
      input16[ptr/2]  = (acc_fetch_tfarg_int(1)&0xff);

   if ((ptr%4)==0)
      input32[ptr/4]  = (acc_fetch_tfarg_int(1)&0xff);
   else if ((ptr%4)==1)
      input32[ptr/4] += (acc_fetch_tfarg_int(1)&0xff)<<8;
   else if ((ptr%4)==2)
      input32[ptr/4] += (acc_fetch_tfarg_int(1)&0xff)<<16;
   else if ((ptr%4)==3)
      input32[ptr/4] += (acc_fetch_tfarg_int(1)&0xff)<<24;

   ptr++;
   return(true);
}


/*
 *------------------------------------------------------------------------------
 * Compute CMAC MIC
 *------------------------------------------------------------------------------
 */
int cmac()
{
   uint32_t       key[4];
   uint16_t       length;
   uint32_t       mic[2];
   handle         h_mic0;
   handle         h_mic1;

   s_acc_value    val;
   s_setval_delay delay;

   delay.model = accNoDelay;

   // Inputs
   key[0] = acc_fetch_tfarg_int(1);
   key[1] = acc_fetch_tfarg_int(2);
   key[2] = acc_fetch_tfarg_int(3);
   key[3] = acc_fetch_tfarg_int(4);
   length = acc_fetch_tfarg_int(5);
   h_mic0 = acc_handle_tfarg(6);
   h_mic1 = acc_handle_tfarg(7);

   // BIP MIC model
   mfp_compute_bip(mic, key, input16, length);

   // MIC LSB output
   val.format        = accIntVal;
   val.value.integer = mic[0];
   acc_set_value(h_mic0, &val, &delay);

   // MIC MSB output
   val.format        = accIntVal;
   val.value.integer = mic[1];
   acc_set_value(h_mic1, &val, &delay);

   return true;
}


/*
 *------------------------------------------------------------------------------
 * Compute TKIP MIC
 *------------------------------------------------------------------------------
 */
int tkip()
{
   uint32_t        key[4];
   uint16_t        length;
   uint32_t        mic[2];
   handle          h_mic0;
   handle          h_mic1;

   struct mic_calc mic_calc_ptr;

   s_acc_value     val;
   s_setval_delay  delay;

   delay.model = accNoDelay;

   // Inputs
   key[0] = acc_fetch_tfarg_int(1);
   key[1] = acc_fetch_tfarg_int(2);
   key[2] = acc_fetch_tfarg_int(3);
   key[3] = acc_fetch_tfarg_int(4);
   length = acc_fetch_tfarg_int(5);
   h_mic0 = acc_handle_tfarg(6);
   h_mic1 = acc_handle_tfarg(7);

   // BIP MIC model
   me_mic_init(&mic_calc_ptr, key);
   me_mic_calc(&mic_calc_ptr, input32, length);
   me_mic_end (&mic_calc_ptr);

   // MIC LSB output
   val.format        = accIntVal;
   val.value.integer = mic_calc_ptr.mic_key_least;
   acc_set_value(h_mic0, &val, &delay);

   // MIC MSB output
   val.format        = accIntVal;
   val.value.integer = mic_calc_ptr.mic_key_most;
   acc_set_value(h_mic1, &val, &delay);

   return true;
}
