///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) by RivieraWaves.
// This module is a confidential and proprietary property of RivieraWaves
// and a possession or use of this module requires written permission
// from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: jvanthou $
// Company : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 23542 $
// $Date: 2015-12-14 23:44:01 +0100 (Mon, 14 Dec 2015) $
// ---------------------------------------------------------------------------
// Description :This file contains all the defines required to control the pli
//              simulations.
// Parameters : 
// Terms & concepts : 
// Bugs :  
// Open issues and future enhancements :
// Tasks and functions:  
// interfaces : 
// channels : 
// covergroups: 
// Revision History :
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
unsigned char *core;



//#define        PRINT_COSIM
//#define        PRINT_FCS
//#define        PRINT_RC4
//#define        PRINT_CCMP
#define        PROCESSRX_PRINT
//#define        TX_PRINT
//#define        HW_FRAGMENTATION
//#define        PRINT_IN_BINARY  
//#define        QOS  
#define        PARALLEL4_BB_IF 
#define        MAGIC_NUMBER 0xC704DD7B
#define        POLYNOMIAL   0x04C11DB7
#define        LEN 32
#define        DOT11I_SUPPORTED
#define        DOT11E_SUPPORTED
#define        DOT11H_SUPPORTED
#define        DOT11AC_SUPPORTED
#define        BLOCK_ACK
#define        WAPI_SUPPORTED
#define        BFMEE_SUPPORTED
#define        BFMER_SUPPORTED
#define        PRINT_WAPI
#define        PRINT_SMS4

//------ Following lines include standard C and PLI libraries ----------
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "v2ktbuser.h"
#include "acc_user.h"

#ifdef DOT11I_SUPPORTED
//----- Typedef used for 11i --------------------------------------------
typedef unsigned char  byte;
typedef unsigned short u16b;
typedef unsigned long  u32b;
#endif

//------ Following lines define the Fragment Types -----------------------
//management fragments
#define ASSN_REQ                         0
#define ASSN_RESP                        1
#define REASSN_REQ                       2
#define REASSN_RESP                      3
#define PROBE_REQ                        4
#define PROBE_RESP                       5
#define BEACON                           8
#define ATIM                             9
#define DIS_ASSN                        10
#define AUTHENTICATION                  11
#define DE_AUTHENTICATION               12

#ifdef QOS
#define ACTION                          13
#else
#ifdef DOT11H_SUPPORTED
#define ACTION                          13
#endif
#endif
#define ACTION_NOACK                    14

#ifdef   DOT11H_SUPPORTED
// Tick Defines for Action Field Values
#define  MEAS_REQ_ACTIONFIELDVALUE       0
#define  MEAS_REP_ACTIONFIELDVALUE       1
#define  TPC_REQ_ACTIONFIELDVALUE        2
#define  TPC_REP_ACTIONFIELDVALUE        3
#define  CHAN_SW_ACTIONFIELDVALUE        4
#endif

// Tick Defines for Category Field Values
#define VHT_CATEGORYFIELDVALUE                21

// Tick Defines for VHT Action Field Values
#define VHT_COMP_BEAMFORMING_ACTIONFIELDVALUE  0

//control fragments
#ifdef DOT11AC_SUPPORTED
#define BFR_POLL                        20
#define VHT_NDPA                        21
#endif

#ifdef QOS
#define GROUP_ACK_REQ                   24
#define GROUP_ACK                       25
#endif

#define BLOCK_ACK_REQ                   24
#define BLOCK_ACK_RES                   25

#define PS_POLL                         26
#define RTS                             27
#define CTS                             28
#define ACK                             29
#define CF_END                          30
#define CF_END_AND_CF_ACK               31

//data fragments
#define DATA                            32
#define DATA_AND_CF_ACK                 33
#define DATA_AND_CF_POLL                34
#define DATA_AND_CF_ACK_AND_CF_POLL     35
#define NULLDATA                        36
#define CF_ACK                          37
#define CF_POLL                         38
#define CF_ACK_AND_CF_POLL              39

#ifdef DOT11E_SUPPORTED
#define QOS_DATA                        40
#define QOS_DATA_AND_CF_ACK             41
#define QOS_DATA_AND_CF_POLL            42
#define QOS_DATA_AND_CF_ACK_AND_CF_POLL 43
#define QOS_NULLDATA                    44
#define QOS_CF_ACK                      45
#define QOS_CF_POLL                     46
#define QOS_CF_ACK_AND_CF_POLL          47
#define QOS_SELF_QCFPOLL                48
#endif

#define INVALID                         49

//------ Miscellaneous defines used by different testbench modules ---------
#define D_OUT             1
#define RX_DATA           1
#define SEED              1
#define DUR_PRES          5 

//----- Defines for 11i ---------------------------------------------------
#ifdef DOT11I_SUPPORTED
#define WEP               1
#define TKIP              2
#define CCMP              3
#define WAPI              4

#define rotR1(v16)        ((((v16) >> 1) & 0x7fff) ^ (((v16) & 1) << 15))
#define lo8(v16)          ((byte) (  (v16)        & 0x00ff))
#define hi8(v16)          ((byte) ( ((v16) >> 8)  & 0x00ff))
#define lo16(v32)         ((u16b) (  (v32)        & 0xffff))
#define hi16(v32)         ((u16b) ( ((v32) >> 16) & 0xffff))
#define mk16(hi,lo)       ((lo) ^ (((u16b) (hi)) << 8))
#define tk16(n)           mk16(str2dec(tkByte[2*(n)+1]),str2dec(tkByte[2*(n)]))

#define phaseLoopCnt 8
#define taSize       6
#define tkSize       16
#define p1kSize      10
#define rc4KeySize   16
#endif

//------ Defines for Various errors values are in hex --------------------
#define FCS_ERROR                       0x01
#define ICV_ERROR                       0x02
#define TWO_BYTE_SEQN                   0x03
#define WRONG_SSID_LENGTH               0x04
#define OWN_ELEMENT_ID1                 0x05
#define OWN_ELEMENT_ID2                 0x06
#define CF_ACK_WITH_NULL_DATA           0
#define CF_ACK_WITH_CF_POLL             1
#define CF_ACK_WITH_DATA                2
#define CF_ACK_WITH_DATA_AND_CF_POLL    3
#define MIC_ERROR                       0x09

#ifdef DOT11I_SUPPORTED
//------ Constants used for 11i -----------------------------------------------
static const unsigned int vectorLength[3] = {20,20,20};
static const int aesPlnm = 0x11b;
static const unsigned char sbox8[256] =
    {
        0x63, 0x7c, 0x77, 0x7b, 0xf2, 0x6b, 0x6f, 0xc5,
        0x30, 0x01, 0x67, 0x2b, 0xfe, 0xd7, 0xab, 0x76,
        0xca, 0x82, 0xc9, 0x7d, 0xfa, 0x59, 0x47, 0xf0,
        0xad, 0xd4, 0xa2, 0xaf, 0x9c, 0xa4, 0x72, 0xc0,
        0xb7, 0xfd, 0x93, 0x26, 0x36, 0x3f, 0xf7, 0xcc,
        0x34, 0xa5, 0xe5, 0xf1, 0x71, 0xd8, 0x31, 0x15,
        0x04, 0xc7, 0x23, 0xc3, 0x18, 0x96, 0x05, 0x9a,
        0x07, 0x12, 0x80, 0xe2, 0xeb, 0x27, 0xb2, 0x75,
        0x09, 0x83, 0x2c, 0x1a, 0x1b, 0x6e, 0x5a, 0xa0,
        0x52, 0x3b, 0xd6, 0xb3, 0x29, 0xe3, 0x2f, 0x84,
        0x53, 0xd1, 0x00, 0xed, 0x20, 0xfc, 0xb1, 0x5b,
        0x6a, 0xcb, 0xbe, 0x39, 0x4a, 0x4c, 0x58, 0xcf,
        0xd0, 0xef, 0xaa, 0xfb, 0x43, 0x4d, 0x33, 0x85,
        0x45, 0xf9, 0x02, 0x7f, 0x50, 0x3c, 0x9f, 0xa8,
        0x51, 0xa3, 0x40, 0x8f, 0x92, 0x9d, 0x38, 0xf5,
        0xbc, 0xb6, 0xda, 0x21, 0x10, 0xff, 0xf3, 0xd2,
        0xcd, 0x0c, 0x13, 0xec, 0x5f, 0x97, 0x44, 0x17,
        0xc4, 0xa7, 0x7e, 0x3d, 0x64, 0x5d, 0x19, 0x73,
        0x60, 0x81, 0x4f, 0xdc, 0x22, 0x2a, 0x90, 0x88,
        0x46, 0xee, 0xb8, 0x14, 0xde, 0x5e, 0x0b, 0xdb,
        0xe0, 0x32, 0x3a, 0x0a, 0x49, 0x06, 0x24, 0x5c,
        0xc2, 0xd3, 0xac, 0x62, 0x91, 0x95, 0xe4, 0x79,
        0xe7, 0xc8, 0x37, 0x6d, 0x8d, 0xd5, 0x4e, 0xa9,
        0x6c, 0x56, 0xf4, 0xea, 0x65, 0x7a, 0xae, 0x08,
        0xba, 0x78, 0x25, 0x2e, 0x1c, 0xa6, 0xb4, 0xc6,
        0xe8, 0xdd, 0x74, 0x1f, 0x4b, 0xbd, 0x8b, 0x8a,
        0x70, 0x3e, 0xb5, 0x66, 0x48, 0x03, 0xf6, 0x0e,
        0x61, 0x35, 0x57, 0xb9, 0x86, 0xc1, 0x1d, 0x9e,
        0xe1, 0xf8, 0x98, 0x11, 0x69, 0xd9, 0x8e, 0x94,
        0x9b, 0x1e, 0x87, 0xe9, 0xce, 0x55, 0x28, 0xdf,
        0x8c, 0xa1, 0x89, 0x0d, 0xbf, 0xe6, 0x42, 0x68,
        0x41, 0x99, 0x2d, 0x0f, 0xb0, 0x54, 0xbb, 0x16
    };
#endif

//------ Diclaration of variables interacting with verilog code --------------
unsigned char   state;
unsigned char   txRx;
unsigned char   stopComparison;
unsigned char   partialFragment;
unsigned char   retryFromCore;
unsigned char   frameSubTypeFromCore;
unsigned char   powerSaveFromCore;
unsigned char   *dtimCountStr;
unsigned char   *cfpCountStr;
unsigned char   *cfpDurRemainingStr;
unsigned char   *durationIdStr;
unsigned char   dot11a;
unsigned char   htFrame;
unsigned int    injectError;
unsigned int    rxDataRate;

unsigned char   dontCompDurId;
unsigned char   dontCompDurIdack;
unsigned char   dontCompRA;

unsigned char   aggregation;

unsigned char   encryptEn;
unsigned char   compareWithEncrypted;
unsigned char   *key;
unsigned char   *keyWithRxInitVector;
unsigned char   *keyWithTxInitVector;
unsigned char   *cryptedData;
unsigned char   *icvErrorBuffer;
unsigned char   *unEncryptedData;
unsigned char   keyLength;
unsigned char   *txInitVector;
unsigned char   txPadBits;
unsigned char   txKeyId;
unsigned char   *rxInitVector;
unsigned char   rxPadBits;
unsigned char   rxKeyId;
#ifdef WAPI_SUPPORTED
unsigned char   *intKey;
unsigned char   rxWapiKeyIdx;
unsigned char   rxWapiRsvd;
unsigned char   *rxWapiPN;
#endif

#ifdef BFMER_SUPPORTED
unsigned char   rxSoundingDialogTokenNumber;
unsigned char   *rxNdpaSTAInfo1AID12;
unsigned char   rxNdpaSTAInfo1FeedbackType;
unsigned char   rxNdpaSTAInfo1NcIndex;

unsigned char   *rxNdpaSTAInfo2AID12;
unsigned char   rxNdpaSTAInfo2FeedbackType;
unsigned char   rxNdpaSTAInfo2NcIndex;

unsigned char   *rxNdpaSTAInfo3AID12;
unsigned char   rxNdpaSTAInfo3FeedbackType;
unsigned char   rxNdpaSTAInfo3NcIndex;

unsigned char   *rxNdpaSTAInfo4AID12;
unsigned char   rxNdpaSTAInfo4FeedbackType;
unsigned char   rxNdpaSTAInfo4NcIndex;

unsigned char   rxFeedbackSegmentRetransmissionBitmap;
#endif

unsigned int    selfCTS;
unsigned int    txFragmentBodyLen;
long int        rxDurationPredicted;

unsigned int    totalTxBits;
unsigned int    rxBitCount;
unsigned int    fcsErrInRxFrame;

unsigned char   txPlcpSignal;
float           txRate;
unsigned char   txPlcpService;
unsigned char   *txPlcpLength;

unsigned char   txFhps;
unsigned char   rxFhps;

unsigned char   fcsWriteEn;
unsigned char   shortPreamble;

unsigned char   txProtocolVersion;
unsigned char   txType;
unsigned char   txSubType;
unsigned char   txToDs;
unsigned char   txFromDs;
unsigned char   txMoreFrag;
unsigned char   txRetry;
unsigned char   txPwrMgt;
unsigned char   txMoreData;
unsigned char   txWep;
unsigned char   txOrder;
unsigned char   *txDurationId;
unsigned char   *txDestAddr;
unsigned char   *txSourceAddr;
unsigned char   *txReceiverAddr;
unsigned char   *txTransmitterAddr;
unsigned char   txFragNum;
unsigned char   *txSeqnNum;
unsigned char   *previousFragmentRxSeqnNum;
unsigned char   *txAid;
unsigned char   *txBssId;

unsigned char    *txAuthAlgNum;
unsigned char    *txAuthTransSeqNum;
unsigned char    *txBeaconInterval;
unsigned char    txEss;
unsigned char    txIbss;
unsigned char    txCfPollable;
unsigned char    txCfPollRequest;
unsigned char    txPrivacy;

unsigned char    tsf;

unsigned char    txShortPreamble;
unsigned char    txPBCC;
unsigned char    txChannelAgility;

unsigned char    txQos;
unsigned char    txAPSD;
unsigned char    txGroupAck;
unsigned char    txExtendedCapabalityElement;

unsigned char    immBlockAck;
unsigned char    *txBlockAckStartingSeqn;
unsigned char    *txBlockAckBitmap;
unsigned char    txBARAckPolicy;
unsigned char    txMultiTid;
unsigned char    txCompressedBitmap;
unsigned char    *rxBlockAckStartingSeqn;
unsigned char    *rxBlockAckBitmap;
unsigned char    coreTxBlockAckStartingSeqn;
unsigned char    *coreTxBlockAckBitmap;
unsigned char    coreTxBARAckPol;
unsigned char    coreTxMultiTID;
unsigned char    coreTxComprBitmap;
unsigned char    coreTxBAAckPol;

unsigned char    *polledTxopStr;

unsigned char    *txCurrentApAddress;
unsigned char    *txListenInterval;
unsigned char    *txReasonCode;
unsigned char    *txStatusCode;
unsigned char    *txTimeStamp;
unsigned char    txSsidElementId;
unsigned int     txSsidLength;
unsigned char    *txSsid;
unsigned char    txSupRatesElementId;
unsigned char    txSupRatesLength;
unsigned char    *txSupportedRates;
unsigned char    txFhpsElementId;
unsigned char    txFhpsLength;
unsigned char    *txDwellTime;
unsigned char    txHopSet;
unsigned char    txHopPattern;
unsigned char    txHopIndex;
unsigned char    txDspsElementId;
unsigned char    txDspsLength;
unsigned char    txCurrentChannel;
unsigned char    txCfpsElementId;
unsigned char    txCfpsLength;
unsigned char    txCfpCount;
unsigned char    txCfpPeriod;
unsigned char    *txCfpMaxDuration;
unsigned char    *txCfpDurRemaining;
unsigned char    txTimElementId;
unsigned int     txTimLength;
unsigned char    txDtimCount;
unsigned char    txDtimPeriod;
unsigned char    txBitmapControl;
unsigned char    *txPartialVirtualBitmap;
unsigned char    txIbsspsElementId;
unsigned char    txIbsspsLength;
unsigned char    *txAtimWindow;
unsigned char    txCtElementId;
unsigned int     txCtLength;
unsigned char    *txChallengeText;
unsigned char    txOwnElementId1;
unsigned char    txOwnLength1;
unsigned char    *txOwnInformation1;
unsigned char    txOwnElementId2;
unsigned char    txOwnLength2;
unsigned char    *txOwnInformation2;

unsigned char    txQbssElementId;
unsigned char    txQbssLength;
unsigned char    *txQbssStationCount;
unsigned char    txQbssChannelUtilization;
unsigned char    *txAvailableAdmCap;
unsigned char    txEdcaPsElementId;
unsigned char    txEdcaPsLength;
unsigned char    txAcInfo;
unsigned char    *txACBEParamRec;
unsigned char    *txACBKParamRec;
unsigned char    *txACVIParamRec;
unsigned char    *txACVOParamRec;

unsigned char    txCategoryCode;
unsigned char    txActionCode;
unsigned char    txActivationDelay;
unsigned char    txDialogToken;

#ifdef DOT11H_SUPPORTED
unsigned char    txCountryElementId;
unsigned char    txCountryElementLen;
unsigned char    *txCountryCode;
unsigned char    txSpectrumManagement;
unsigned char    txPwrCnstElementID;
unsigned char    txPwrCnstLength;
unsigned char    txLocalPowerConstraint;
unsigned char    txMinimumPowerCapability;
unsigned char    txMaximumPowerCapability ;
unsigned char    txSupChElementID;
unsigned char    txPwrCapElementID;
unsigned char    txPwrCapLength;
unsigned char    txSupChElementID;
unsigned char    txSupChLength;
unsigned char    txFirstChannel;
unsigned char    txNumberofChannels;
unsigned char    txQuietElementID;
unsigned char    txQuietLength;
unsigned char    txQuietCount;
unsigned char    txQuietPeriod;
unsigned char    *txQuietDuration;
unsigned char    *txQuietOffset;
unsigned char    txIBSSDFSElementID;
unsigned char    txIBSSDFSLength;
unsigned char    *txDFSowner;
unsigned char    txRecoveryInterval;
unsigned char    txChannelNumber;
unsigned char    txMap;
unsigned char    txMeasurementReqCategory;
unsigned char    txMeasurementReqAction;
unsigned char    txMeasurementReqDialogToken;
unsigned char    txMeasurementReqMeasurementToken;
unsigned char    txMeasurementReqMeasurementMode;
unsigned char    txMeasurementReqMeasurementType;
unsigned char    txMeasurementReqChannelNumber;
unsigned char    *txMeasurementReqMeasurementStartTime;
unsigned char    *txMeasurementReqMeasurementDuration;
unsigned char    txMeasurementReqElementID;
unsigned char    txMeasurementReqLength;

unsigned char    txMeasurementRepCategory;
unsigned char    txMeasurementRepAction;
unsigned char    txMeasurementRepDialogToken;
unsigned char    txMeasurementRepElementID;
unsigned char    txMeasurementRepLength;
unsigned char    txMeasurementRepMeasurementToken;
unsigned char    txMeasurementRepMeasurementMode;
unsigned char    txMeasurementRepMeasurementType;
unsigned char    txMeasurementRepChannelNumber;
unsigned char    *txMeasurementRepMeasurementStartTime;
unsigned char    *txMeasurementRepMeasurementDuration;
unsigned char    txMeasurementRepMap;
unsigned char    txChSwCategory;
unsigned char    txChSwAction;
unsigned char    txChSwElementID;
unsigned char    txChSwLength;
unsigned char    txChannelSwitchMode;
unsigned char    txChSwNewChannelNumber;
unsigned char    txChannelSwitchCount;
unsigned char    txTPCReqCategory;
unsigned char    txTPCReqAction;
unsigned char    txTPCReqDialogToken;
unsigned char    txTPCReqElementID;
unsigned char    txTPCReqLength;
unsigned char    txTPCRepCategory;
unsigned char    txTPCRepAction;
unsigned char    txTPCRepDialogToken;
unsigned char    txTPCRepElementID;
unsigned char    txTPCRepLength;
unsigned char    txTransmitPower;
unsigned char    txLinkMargin;
#endif

#ifdef DOT11I_SUPPORTED
unsigned int     addRSNIE;
unsigned char    *txRSNHeader;
unsigned char    *rxRSNHeader;
unsigned char    *txRSNInformationElement;
unsigned char    *rxRSNInformationElement;
unsigned char    txCipherType;
unsigned char    rxCipherType;
unsigned char    rxEiv;
unsigned int     testVector;
unsigned int     vectorNo;
unsigned int     txTestVector;
unsigned int     txVectorNo;
#endif

#ifdef WAPI_SUPPORTED
unsigned char    *rxWAPIHeader;
unsigned char    *txWAPIPN;
unsigned char    *txWAPIKeyIdx;
#endif

#ifdef DOT11AC_SUPPORTED
unsigned int     nBeamformingSTA;
unsigned char   *txBfrPollFeedbackSegRetBitmap;
unsigned char   *txNdpaSndDialTokenNbr; 
unsigned char   *txNdpaStaInfo1Aid12;
unsigned char   *txNdpaStaInfo1FeedbackType;
unsigned char   *txNdpaStaInfo1NcIndex;
unsigned char   *txNdpaStaInfo2Aid12;
unsigned char   *txNdpaStaInfo2FeedbackType;
unsigned char   *txNdpaStaInfo2NcIndex;
unsigned char   *txBfrNcIndex;
unsigned char   *txBfrNrIndex;
unsigned char   *txBfrChannelWidth;
unsigned char   *txBfrGrouping;
unsigned char   *txBfrCodebookInformation;
unsigned char   *txBfrFeedbackType;
unsigned char   *txBfrRemainingFeedbackSegments;
unsigned char   *txBfrFirstFeedbackSegment;
unsigned char   *txBfrSoundingDialogTokenNumber;
unsigned int     txBfrLength;
unsigned char   *txBfrCompressedReport;
#endif

unsigned char   rxProtocolVersion;
unsigned char   rxType;
unsigned char   rxSubType;
unsigned char   rxToDs;
unsigned char   rxFromDs;
unsigned char   rxMoreFrag;
unsigned char   rxRetry;
unsigned char   rxPwrMgt;
unsigned char   rxMoreData;
unsigned char   rxWep;
unsigned char   rxOrder;
unsigned char   *rxDurationId;
unsigned char   *rxDestAddr;
unsigned char   *rxSourceAddr;
unsigned char   *rxReceiverAddr;
unsigned char   *rxTransmitterAddr;
unsigned char   rxFragNum;
unsigned char   previousFragmentRxFragNum;
unsigned char   *rxSeqnNum;
unsigned char   *rxAid;
unsigned char   *rxBssId;

unsigned char    *rxAuthAlgNum;
unsigned char    *rxAuthTransSeqNum;
unsigned char    *rxBeaconInterval;
unsigned char    rxEss;
unsigned char    rxIbss;
unsigned char    rxCfPollable;
unsigned char    rxCfPollRequest;
unsigned char    rxPrivacy;
unsigned char    *rxCurrentApAddress;
unsigned char    *rxListenInterval;
unsigned char    *rxReasonCode;
unsigned char    *rxStatusCode;
unsigned char    *rxTimeStamp;
unsigned char    rxElementId;
unsigned char    rxSsidElementId;
unsigned char    rxLength;
unsigned char    rxSsidLength;
unsigned char    *rxSsid;
unsigned char    rxSupRatesElementId;
unsigned char    rxSupRatesLength;
unsigned char    *rxSupportedRates;
unsigned char    rxFhpsElementId;
unsigned char    rxFhpsLength;
unsigned char    *rxDwellTime;
unsigned char    rxHopSet;
unsigned char    rxHopPattern;
unsigned char    rxHopIndex;
unsigned char    rxDspsElementId;
unsigned char    rxDspsLength;
unsigned char    rxCurrentChannel;
unsigned char    rxCfpsElementId;
unsigned char    rxCfpsLength;
unsigned char    rxCfpCount;
unsigned char    rxCfpPeriod;
unsigned char    *rxCfpMaxDuration;
unsigned char    *rxCfpDurRemaining;
unsigned char    rxTimElementId;
unsigned char    rxTimLength;
unsigned char    rxDtimCount;
unsigned char    rxDtimPeriod;
unsigned char    rxBitmapControl;
unsigned char    *rxPartialVirtualBitmap;
unsigned char    rxIbsspsElementId;
unsigned char    rxIbsspsLength;
unsigned char    *rxAtimWindow;
unsigned char    rxCtElementId;
unsigned char    rxCtLength;
unsigned char    *rxChallengeText;

#ifdef DOT11H_SUPPORTED
unsigned char    rxCountryElementId;
unsigned char    rxCountryElementLen;
unsigned char    *rxCountryCode;
unsigned char    rxSpectrumManagement;
unsigned char    rxFirstChannel;
unsigned char    rxPwrCnstElementID;
unsigned char    rxPwrCnstLength;
unsigned char    rxNumberofChannels;
unsigned char    rxSupChElementID;
unsigned char    rxSupChLength;
unsigned char    rxMinimumPowerCapability;
unsigned char    rxMaximumPowerCapability;
unsigned char    rxPwrCapElementID;
unsigned char    rxPwrCapLength;
unsigned char    rxLocalPowerConstraint;
unsigned char    rxChannelSwitchMode;
unsigned char    rxNewChannelNumber;
unsigned char    rxChannelSwitchCount;
unsigned char    rxChSwElementID;
unsigned char    rxChSwLength;
unsigned char    rxChSwCategory;
unsigned char    rxChSwAction;
unsigned char    rxQuietElementID;
unsigned char    rxQuietLength;
unsigned char    rxQuietCount;
unsigned char    rxQuietPeriod;
unsigned char    *rxQuietDuration;
unsigned char    *rxQuietOffset;
unsigned char    *rxDFSowner;
unsigned char    rxRecoveryInterval;
unsigned char    rxChannelNumber;
unsigned char    rxIBSSDFSElementID;
unsigned char    rxIBSSDFSLength;
unsigned char    rxMap;
unsigned char    rxMeasurementReqCategory;
unsigned char    rxMeasurementReqAction;
unsigned char    rxMeasurementReqDialogToken;
unsigned char    rxMeasurementReqMeasurementToken;
unsigned char    rxMeasurementReqMeasurementMode;
unsigned char    rxMeasurementReqMeasurementType;
unsigned char    rxMeasurementReqChannelNumber;
unsigned char    *rxMeasurementReqMeasurementStartTime;
unsigned char    *rxMeasurementReqMeasurementDuration;
unsigned char    rxMeasurementReqElementID;
unsigned char    rxMeasurementReqLength;
unsigned char    rxTransmitPower;
unsigned char    rxLinkMargin;
unsigned char    rxMeasurementRepElementID;
unsigned char    rxMeasurementRepLength;
unsigned char    rxMeasurementRepCategory;
unsigned char    rxMeasurementRepAction;
unsigned char    rxMeasurementRepDialogToken;
unsigned char    rxMeasurementRepMeasurementToken;
unsigned char    rxMeasurementRepMeasurementMode;
unsigned char    rxMeasurementRepMeasurementType;
unsigned char    rxMeasurementRepChannelNumber;
unsigned char    *rxMeasurementRepMeasurementStartTime;
unsigned char    *rxMeasurementRepMeasurementDuration;
unsigned char    rxMeasurementRepMap;
unsigned char    rxCategory;
unsigned char    rxAction;
unsigned char    rxTPCReqCategory;
unsigned char    rxTPCReqAction;
unsigned char    rxTPCReqDialogToken;
unsigned char    rxTPCReqElementID;
unsigned char    rxTPCReqLength;
unsigned char    rxTPCRepCategory;
unsigned char    rxTPCRepAction;
unsigned char    rxTPCRepDialogToken;
unsigned char    rxTPCRepElementID;
unsigned char    rxTPCRepLength;
#endif

unsigned char    rxCategoryCode;
unsigned char    rxActionCode;
unsigned char    rxActivationDelay;
unsigned char    rxDialogToken;
unsigned char   rxQos;
unsigned char   *rxStationCount;
unsigned char   rxChannelUtilization;
unsigned char   *rxAvailableAdmCap;
unsigned char   rxAcInfo;
unsigned char   *rxACBEParamRec;
unsigned char   *rxACBKParamRec;
unsigned char   *rxACVIParamRec;
unsigned char   *rxACVOParamRec;
unsigned char   rxQbssElementId;
unsigned char   rxQbssLength;
unsigned char   rxQbssChannelUtilization;
//unsigned char   rxQbssFrameLossRate;
unsigned char   rxQosPsElementId;
unsigned char   rxQosPsLength;

unsigned char    txTid;
unsigned char    txFec;
unsigned char    txAckPolicy;
unsigned char    txaMsduPresent; 
unsigned char    txQosControl15_8;

unsigned char    rxTid;
unsigned char    rxFec;
unsigned char    rxAckPolicy;
unsigned char    rxaMsduPresent;
unsigned char    rxQosControl15_8;

unsigned char    *txSentCount;
unsigned char    *txGroupAckStartingSeqn;
unsigned char    *txGroupAckBitmap;
unsigned char    txReOrderingBufferSize;

unsigned char    *rxSentCount;
unsigned char    *rxGroupAckStartingSeqn;
unsigned char    *rxGroupAckBitmap;
unsigned char    rxReOrderingBufferSize;
unsigned char    *txHtControl;
unsigned char    *rxHtControl;

unsigned int    coreTxNltf;
unsigned int    coreTxFormat;

unsigned char   rxBfrNcIndex;
unsigned char   rxBfrNrIndex;
unsigned char   rxBfrChanBW;
unsigned char   rxBfrGrouping;
unsigned char   rxBfrCodebook;
unsigned char   rxBfrFeedbackType;
unsigned char   rxBfrRemaingFeedbackSeg;
unsigned char   rxBfrFirstFeedbackSeg;
unsigned char   rxBfrSndDialogTokenNbr;


//------  Diclaration of global variables used by C code ---------------------
unsigned char   *txBits;
unsigned char   *txAmpduBytes;
unsigned int    txAmpduOffset;
unsigned int    txAmpduSingleVHT;
unsigned char   txAmpduMpduNumber;
unsigned char   *txAmpduDelimiter;
unsigned char   *macSimTxData;
unsigned char   *macSimTxDataRetrieved;
unsigned char   *macSimTxData1;
unsigned char   *macSimTxData2;
unsigned char   *macSimTxData3;
unsigned char   *macSimTxData4;
unsigned char   *macSimTxData5;
unsigned char   *macSimTxData6;
unsigned char   *macSimTxData7;
unsigned char   *macSimTxData8;
unsigned char   *macSimTxData9;
unsigned char   *macSimTxData10;
unsigned char   *transDataPntr;
unsigned int    *fragmentBodyData;
unsigned char   *fragmentBodyOnly;
unsigned int    macSimRxFrameCount;
unsigned int    fragmentBodyLen;
unsigned char   rxFragmentType;
unsigned char   txFragmentType;
unsigned int    totalRxBits;
unsigned int    rxDataFragmentHeaderLength;
unsigned int    txDataFragmentHeaderLength;
unsigned char   *rxBits;
unsigned char   *rxAmpduBytes;
unsigned int    rxAmpduOffset;
unsigned int    rxAmpduSingleVHT;
unsigned char   *rxAmpduDelimiter;
unsigned char   *macSimRxData;
unsigned char   *tempBuffer;
unsigned int    macSimTxFrameLength;
unsigned char   *seqnNumberString;
unsigned int    seqnNumber;

unsigned char   *coreTxDataTsf;
unsigned char   *macSimRxDataTsf;

unsigned char   *coreTxDataBudget1;
unsigned char   *coreTxDataBudget2;
unsigned char   *coreTxDataBudget3;
unsigned char   *macSimRxBudget1;
unsigned char   *macSimRxBudget2;
unsigned char   *macSimRxBudget3;
unsigned char   *coreTxDataLoad1;
unsigned char   *coreTxDataLoad2;
unsigned char   *coreTxDataLoad3;
unsigned char   *macSimRxLoad1;
unsigned char   *macSimRxLoad2;
unsigned char   *macSimRxLoad3;

//------ Function prototype declaration -------------------------------------
extern void  createBufferTx(void);
extern void  createBufferRx(void);
extern void  accessVerilogReg(void);
extern void  reverseStrCpy(unsigned char *s, unsigned char *t);
extern void  fcs(int length, unsigned char *in, unsigned int icv);
extern void  errorFunction(void) ;
extern void  rc4Encrypt(unsigned char *inData, unsigned char *dataKey);
extern void  updateVerilogReg(void);
extern void  freeTxBuffer(void);
extern void  freeRxBuffer(void);
#ifdef DOT11I_SUPPORTED
extern void  ccmpEncrypt(unsigned char *inData, unsigned char *dataKey);
#endif
#ifdef WAPI_SUPPORTED
void wapiEncrypt(unsigned char *inData, unsigned char *dataKey, unsigned char *intKey);
#endif
//------ Functions in transmitFragment.c file -------------------------------------
void plcpHeader(void);
void frameControl(void);
void durationId(void);
void destAddr(void);
void sourceAddr(void);
void receiverAddr(void);
void transmitterAddr(void);
void seqnControl(void);
void aId(void);
void bssId(void);
void decideAddress(void);
void htControl(void);
unsigned char ampduDelimiterCrc(void);
void ampduDelimiter(void);
void updateMacSimTxData(unsigned char numOfMpdu);

#ifdef DOT11H_SUPPORTED
void countryElement(void);
void powerConstraint(void);
void powerCapability(void);
void supportedChannels (void);
void quietElement(void);
void IBSSDFSElement(void);
void MeasurementRequest(void);
void MeasurementReport(void);
void TPCRequest(void);
void TPCReport(void);
void channelSwitchAnnouncement(void);
#endif

void qosControl(void);
void qosBody(void);

void iv(void);
void dataFragmentBodyGenerator(void);
void mgmtFragmentBodyGenerator(void);
void bitwriter(void);
void capabalityInfo(void);
void ssid(void);
void supportedRates(void);
void fhParamSet(void);
void dsParamSet(void);
void cfParamSet(void);
void tim(void);
void ibssParamSet(void);
void challengeText(void);
void ownInformationElement1(void);
void ownInformationElement2(void);
void catKeyAndIv(void);

#ifdef DOT11I_SUPPORTED
void rsnHeaderGenerator(void);
void deriveWepKey(void);
u16b getSbox(u16b);
void phase1(u16b *p1k, const byte *ta, u32b iv32, byte *tkByte[]);
void phase2(byte *rc4Key, const u16b *p1k, u16b iv16, byte *tkByte[]);
#endif

#ifdef DOT11AC_SUPPORTED
void bfrPollBody(void);
void ndpaBody(void);
void mimoControl(void);
void compressedBeamformingReport(void);
#endif

//------ Functions in receiveFragment.c file -------------------------------------
void processFragment(void);
void processFrameControl(void);
void processDurationId(void);
void processDestAddr(void);
void processSourceAddr(void);
void processReceiverAddr(void);
void processTransmitterAddr(void);
void processSeqnControl(void);
void processAid(void);
void processBssId(void);
void rxDecideAddress(void);
void processHtControl(void);
void processQosControl(void);

void processMgmtFragmentBody(void);
void processIv(void);
void processCapabalityInfo(void);
void processListenInterval(void);
void processElementId(unsigned int);
void processLength(unsigned int);
void processSsid(void);
void processSupportedRates(void);
void processStatusCode(void);
void processCurrentApAddress(void);
void processTimeStamp(void);
void processBeaconInterval(void);
void processFhParamSet(void);
void processDsParamSet(void);
void processCfParamSet(void);
void processIbssParamSet(void);

void processQbssLoad(void);
void processQosParamSet(void);

void BARBody(void);
void BABody(void);
void processBARBody(void);
void processBABody(void);

void processTim(void);
void processReasonCode(void);
void processAuthAlgNum(void);
void processAuthTransSeqNum(void);
void processChallengeText(void);
void processDataFragmentBody(void);
void compareMacSimRxFragment(unsigned char *);
int  roundOff(float , float);
long int  str2dec(unsigned char *);
void dec2string(unsigned int, unsigned char *, int);
void bitRead(void);
void string2hex(unsigned char *, unsigned char);
void removeFile(void);
unsigned int char2int(unsigned char in);
void CCBody(void);
void processCCBody(void);
void processGARBody(void);
void processGABody(void);

#ifdef  DOT11H_SUPPORTED
void processCountryElement(void);
void processSupportedChannels(void);
void processPowerCapability(void);
void processPowerConstraint(void);
void processQuietElement(void);
void processIBSSDFSElement(void);
void processMeasurementRequestElement(void);
void processMeasurementReportElement(void);
void processTPCRequestElement(void);
void processTPCReportElement(void);
void processChannelSwitchAnnouncementElement(void);
void processCategory(void);
void processAction(void);
#endif

#ifdef DOT11I_SUPPORTED
void processRSNInformationElement(void);
void processRSNHeader(void);
#endif
void calExpectedDurationId (void);
unsigned char processAmpduDelimiterCrc(void);
unsigned int processAmpduDelimiter(void);
void processUpdateMacSimData(unsigned char numSelect);

#ifdef WAPI_SUPPORTED
void coreWAPIHeaderField(void);
void processWAPIHeader(void);
void wapiHeader(void);
#endif
#ifdef BFMEE_SUPPORTED
void processVHTMimoControl(void);
void processVHTBeamformingReport(void);
#endif
#ifdef BFMER_SUPPORTED
//void coreTxSoundingDialogTokenField(void);
//void coreTxSTAInfoField(void);
void coreVHTNDPAFrameBody(void);
void processVHTBFRReportPoll(void);
void processVHTNDPABody(void);
#endif

//#########################################################################//

void coreQosControlField(void);
void coreCCFrameBody(void);

#ifdef DOT11I_SUPPORTED
void coreRSNHeader(void);
void setAddRSNIE(void);
#endif

void reverseString (unsigned char * , unsigned int);
void callLoopCount (void);
void compareRxFragment (unsigned char *, unsigned int);
void storeTxDataWithoutIgnoreData (unsigned int);
void appendIgnoreData (void);
void appendCoreTxDataWithIgnoreData (unsigned char * ,unsigned int , unsigned int, unsigned char);
void printFunction (void);
void copyCoreIgnoreData (void);
void appendUsingLoop (unsigned char , unsigned char , unsigned int);
void putNoOfReads (void);
void updateTimestamp (void);
void updateDtimCount (void);
void updateCfpCount (void);
void updateCfpDurRemaining (void);
void updateAckRA (void);
void storeTxDataForControlFrames (void);
void removePaddingBytes (unsigned int , unsigned int );

// From DS and To DS Conditions
#define   FROMDS_AND_TODS_00          00
#define   FROMDS_AND_TODS_01          01
#define   FROMDS_AND_TODS_10          02
#define   FROMDS_AND_TODS_11          03

// Frame Type
#define   MGMT                        00
#define   CONTROL                     01
#define   DTA                         02

// Miscellaneous
//#define   PRINT                       01

//#########################################################################//
// GLOBAL REGISTERS _ REGISTERS THAT CAN BE ACCESSED BY ALL THE FUNCTIONS
//#########################################################################//

void storeRxDataWithoutPaddingData (void);
void coreStopComparison (void);
void resetEncryptEn (void);
void setTxType(void);

// Unsigned char pointers

unsigned char *coreTimestamp;
unsigned char *coreBeaconInterval;
unsigned char *coreCapabilityInformation;
unsigned char *coreSSID;
unsigned char *coreSupportedRates;
unsigned char *coreFHParameterSet;
unsigned char *coreDSParameterSet;
unsigned char *coreCFParameterSet;
unsigned char *coreIBSSParameterSet;
unsigned char *coreTIM;
unsigned char *coreChallengeText;
unsigned char *coreAssociationID;
unsigned char *coreListenInterval;
unsigned char *coreTxDuration;
unsigned char *coreTxAID;
unsigned char *coreTxSequenceControl;
unsigned char *coreTxSourceAddress;
unsigned char *coreTxDestinationAddress;
unsigned char *coreTxReceiverAddress;
unsigned char *coreTxTransmitterAddress;
unsigned char *coreTxBSSIDAddress;
unsigned char *coreCurrentAPAddress;
unsigned char *address1;
unsigned char *address11;
unsigned char *address12;
unsigned char *address13;
unsigned char *address14;
unsigned char *address15;
unsigned char *address16;
unsigned char *address17;
unsigned char *address18;
unsigned char *address19;
unsigned char *address110;
unsigned char *address111;
unsigned char *address112;
unsigned char *address113;
unsigned char *address114;
unsigned char *address115;
unsigned char *address116;
unsigned char *address117;
unsigned char *address118;
unsigned char *address119;
unsigned char *address120;
unsigned char *address121;
unsigned char *reasonCode;
unsigned char *statusCode;
unsigned char *coreAuthAlgorithmNo;
unsigned char *coreAuthTransactionSequenceNo;
unsigned char *coreTxData;
unsigned char *coreTxData1;
unsigned char *coreTxData2;
unsigned char *coreTxData3;
unsigned char *coreTxData4;
unsigned char *coreTxData5;
unsigned char *coreTxData6;
unsigned char *coreTxData7;
unsigned char *coreTxData8;
unsigned char *coreTxData9;
unsigned char *coreTxData10;
unsigned char *coreTxData11;
unsigned char *coreTxData12;
unsigned char *coreTxData13;
unsigned char *coreTxData14;
unsigned char *coreTxData15;
unsigned char *coreTxData16;
unsigned char *coreTxData17;
unsigned char *coreTxData18;
unsigned char *coreTxData19;
unsigned char *coreTxData20;
unsigned char *coreTxData21;
unsigned char *coreTxDataWithIgnoreData;
unsigned char *coreRxData;
unsigned char *coreRxDataWithPaddingData;
unsigned char *coreToHostRxData;
unsigned char *coreMacAddr;
unsigned char *coreBssId;
unsigned char *coreCurrFragDurn;
unsigned char *coreCurrFragDurn1;
unsigned char *coreCurrFragDurn2;
unsigned char *coreCurrFragDurn3;
unsigned char *coreCurrFragDurn4;
unsigned char *coreCurrFragDurn5;
unsigned char *coreCurrFragDurn6;
unsigned char *coreCurrFragDurn7;
unsigned char *coreCurrFragDurn8;
unsigned char *coreCurrFragDurn9;
unsigned char *coreCurrFragDurn10;
unsigned char *coreCurrFragDurn11;
unsigned char *coreCurrFragDurn12;
unsigned char *coreCurrFragDurn13;
unsigned char *coreCurrFragDurn14;
unsigned char *coreCurrFragDurn15;
unsigned char *coreCurrFragDurn16;
unsigned char *coreCurrFragDurn17;
unsigned char *coreCurrFragDurn18;
unsigned char *coreCurrFragDurn19;
unsigned char *coreCurrFragDurn20;
unsigned char *coreCurrFragDurn21;
unsigned char *updateCoreTimestamp;

unsigned char *coreCurrRTSDurn;
unsigned char *coreCurrRTSDurn1;
unsigned char *coreCurrRTSDurn2;
unsigned char *coreCurrRTSDurn3;
unsigned char *coreCurrRTSDurn4;
unsigned char *coreCurrRTSDurn5;
unsigned char *coreCurrRTSDurn6;
unsigned char *coreCurrRTSDurn7;
unsigned char *coreCurrRTSDurn8;
unsigned char *coreCurrRTSDurn9;
unsigned char *coreCurrRTSDurn10;
unsigned char *coreCurrRTSDurn11;
unsigned char *coreCurrRTSDurn12;
unsigned char *coreCurrRTSDurn13;
unsigned char *coreCurrRTSDurn14;
unsigned char *coreCurrRTSDurn15;
unsigned char *coreCurrRTSDurn16;
unsigned char *coreCurrRTSDurn17;
unsigned char *coreCurrRTSDurn18;
unsigned char *coreCurrRTSDurn19;
unsigned char *coreCurrRTSDurn20;
unsigned char *coreCurrRTSDurn21;


#ifdef DOT11H_SUPPORTED
unsigned char *coreMeasurementRequestElement;
unsigned char *coreMeasurementReportElement;
unsigned char *coreTPCRequestElement;
unsigned char *coreTPCReportElement;
unsigned char *coreChannelSwitchAnnouncementElement;
unsigned char *coreCategory;
unsigned char *coreDialogToken;
unsigned char *coreAction;
#else
#ifdef DOT11AC_SUPPORTED
unsigned char *coreCategory;
unsigned char *coreAction;
#endif
#endif

#ifdef DOT11AC_SUPPORTED
unsigned char *coreVHTMIMOCntrl;
unsigned char *coreVHTBFR;
#endif

// Unsigned char identifiers

unsigned char coreIntOnTx;
unsigned char coreIgnoreByte;
unsigned char coreTxShortPreamble;
unsigned char coreTxModulation;
unsigned char coreWriteAck;
unsigned char coreDoNotExpectAck;
unsigned char coreTxSpeed;
unsigned char coreTxWEP;
unsigned char coreTxPwrLv;
unsigned char useProtection;
unsigned char coreTxFcsErr;
unsigned char coreTxSeqn;
unsigned char coreTxRtEn;

//QoS control fields
unsigned char coreTxTID;
unsigned char coreTxFec;
unsigned char coreTxAckPolicy;
unsigned char coreAMSDUPres; 
unsigned char coreTxQosControl15_8;

//HT control fields
unsigned char coreRgdOrMorePPDU;
unsigned char acConstraint;
unsigned char ndpAnnouncement;
unsigned char csiOrSteering;
unsigned char calibSeq;
unsigned char calibPos;
unsigned char mcsFbAntSel;
unsigned char mfbSeqId;
unsigned char mcsReqOrAntSelInd;
unsigned char trainingReq;

#ifdef WAPI_SUPPORTED
unsigned char *coreTxWAPIKeyIdx;
unsigned char *coreTxWAPIPN;
#endif

#ifdef BFMER_SUPPORTED
unsigned int  VHTNDPA;
unsigned char *coreTxSoundingDialogToken;
unsigned char *coreTxSTAInfo1;
unsigned char *coreTxSTAInfo2;
unsigned char *coreTxSTAInfo3;
unsigned char *coreTxSTAInfo4;
#endif

unsigned char *coreTxSentCount;
unsigned char *coreTxGroupAckStartingSeqn;
unsigned char *coreTxGroupAckBitmap;
unsigned char coreTxReOrderingBufferSize;
unsigned char coreTxCCILength;
unsigned char coreTxFeedbackCount;
unsigned char *coreTxFeedbackTAID;
unsigned char coreTxQos;
unsigned char *updateCoreTxopBudget;
unsigned char *updateCoreLoad;
unsigned char *coreQbssLoad;
unsigned char *coreQosParameterSet;
unsigned char coreTxExtCapabilityElement;
unsigned char coreTxQos;

#ifdef DOT11I_SUPPORTED
unsigned char *coreTxRSNHeader;
unsigned char *coreRSNInformationElement;
unsigned char coreDot11i;
#endif

unsigned char coreTxOrder;
unsigned char coreTxWEP;
unsigned char coreTxMoreData;
unsigned char coreTxPwrMgt;
unsigned char coreTxRetry;
unsigned char coreTxMoreFrag;
unsigned char coreTxFromDS;
unsigned char coreTxToDS;
unsigned char coreTxFrameSubType;
unsigned char coreTxFrameType;
unsigned char coreTxTypeSubType;
unsigned char coreTxFrameControlField9DownTo8;
unsigned char coreTxProtocolVersion;

unsigned char coreTxEss;
unsigned char coreTxIbss;
unsigned char coreTxCfPollable;
unsigned char coreTxCfPollRequest;
unsigned char coreTxCfPrivacy;

#ifdef DOT11H_SUPPORTED
unsigned char coreTxSpectrumManagement;
unsigned char *coreCountryElement;
unsigned char *corePowerConstraintElement;
unsigned char *coreQuietElement;
unsigned char *coreIBSSDFSElement;
unsigned char *corePowerCapabilityElement;
unsigned char *coreSupportedChannelsElement;

unsigned char elementID_CountryElement;
unsigned char lengthCountryElement;
#endif

unsigned char elementID_SSID;
unsigned char lengthSSID;
unsigned char elementID_SupportedRates;
unsigned char lengthSupportedRates;
unsigned char elementID_TIM;
unsigned char lengthTIM;
unsigned char elementID_ChallengeText;
unsigned char lengthChallengeText;

unsigned char loopElementID_SSID;
unsigned char loopLengthSSID;
unsigned char loopElementID_SupportedRates;
unsigned char loopLengthSupportedRates;
unsigned char loopElementID_TIM;
unsigned char loopLengthTIM;
unsigned char loopElementID_ChallengeText;
unsigned char loopLengthChallengeText;

unsigned char DTIM_Count;
unsigned char DTIM_Period;
unsigned char bitmapControl;
unsigned char loopDTIM_Count;
unsigned char loopDTIM_Period;
unsigned char loopBitmapControl;

unsigned char coreTxPaddingData;
unsigned char coreIgnoreNoOfBits;
unsigned char corePowerMgt;
unsigned char loopCount;
unsigned char coreTxFrame;
unsigned char coreTxFrame1;
unsigned char coreTxFrame2;
unsigned char coreTxFrame3;
unsigned char coreTxFrame4;
unsigned char coreTxFrame5;
unsigned char coreTxFrame6;
unsigned char coreTxFrame7;
unsigned char coreTxFrame8;
unsigned char coreTxFrame9;
unsigned char coreTxFrame10;
unsigned char coreTxFrame11;
unsigned char coreTxFrame12;
unsigned char coreTxFrame13;
unsigned char coreTxFrame14;
unsigned char coreTxFrame15;
unsigned char coreTxFrame16;
unsigned char coreTxFrame17;
unsigned char coreTxFrame18;
unsigned char coreTxFrame19;
unsigned char coreTxFrame20;
unsigned char coreTxFrame21;
unsigned char antennaSelect;

// Unsigned int identifiers

unsigned int coreTxDataIndex;
unsigned int coreTxDataWithIgnoreDataIndex;
unsigned int coreTxLength;
unsigned int coreMSDULifeTime;
unsigned int currFragDuration;
unsigned int resetCoreTxDataIndex;
unsigned int coreIgnoreData;
unsigned int coreRxDataIndex;
unsigned int coreBufferedTxDataIndex;
unsigned int coreRxFrameCount;
unsigned int noOfReads;
unsigned int paddingBeforePayload;
unsigned int coreRxStopComparison;
unsigned int coreToHostRxDataIndex;
// Signed int identifiers

int fragmentCount;
int coreRxLength;
int coreRxDataWithPaddingDataIndex;
int encrCount;

#define    DATABUSWIDTH     32
#define    FIFOPORTWIDTH    32
