///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) by RivieraWaves.
// This module is a confidential and proprietary property of RivieraWaves
// and a possession or use of this module requires written permission
// from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: rblanc $
// Company : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 20770 $
// $Date: 2015-08-12 15:56:06 +0200 (Wed, 12 Aug 2015) $
// ---------------------------------------------------------------------------
// Description :This file declares and maps the PLI functions that are called by
//              the verilog modules
// Parameters :
// Terms & concepts :
// Bugs :
// Open issues and future enhancements :
// Tasks and functions:
// interfaces :
// channels :
// covergroups:
// Revision History :
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

#include "veriuser.h"
#include "vxl_veriuser.h"

#define PARALLEL4_BB_IF
//#define     QOS
#define     DOT11H_SUPPORTED
#define     DOT11I_SUPPORTED
#define     DOT11E_SUPPORTED
#define    BLOCK_ACK
extern int  transmitFragment();
extern int  processRxedFragment();
extern int  bitWrite();
extern int  bitRead();
extern int  createBuffer();
extern int  createBufferTx();
extern int  createBufferRx();
extern int  freeTxBuffer();
extern int  freeRxBuffer();
extern int  removeFile();
extern int  accessVerilogReg();
extern int  storeMacSimTxData();
extern int  retrieveMacSimTxData();
extern int  ampduFirstMpdu();
extern int  ampduFirstMpduVht();
extern int  ampduMpdu();
extern int  ampduMpduVht();
extern int  ampduLastMpdu();
extern int  ampduLastMpduVht();
extern int  ampduFirstLastMpdu();
extern int  ampduFirstLastMpduVht();

extern int  coreFrameControlField();

extern int  coreQosControlField();
extern int  coreHTControlField();
extern int  coreWAPIHeaderField();

//extern int coreTxSoundingDialogTokenField();
//extern int coreTxSTAInfoField();
extern int coreVHTNDPAFrameBody();

extern int  coreBARFrame();
extern int  coreBAFrame();


extern int  coreFrameHeader();
extern int  coreTxSSID();
extern int  coreTxSupportedRates();
extern int  coreTxTIM();
extern int  coreTxChallengeText();
extern int  coreBeaconFrame();
extern int  coreATIMFrame();
extern int  coreDisassociationFrame();
extern int  coreAssociationRequestFrame();
extern int  coreAssociationResponseFrame();
extern int  coreReassociationRequestFrame();
extern int  coreProbeRequestFrame();
extern int  coreProbeResponseFrame();
extern int  coreAuthenticationFrame();
extern int  hostToCoreData();
extern int  callLoopCount();
extern int  storeCoreTxData();
extern int  storeDur();
extern int  coreToHostData();
extern int  coreToHostIcvMic();
extern int  compareRxFragment();
extern int  getCoreTxDataLengthWithIgnoreData();
extern int  retrieveCoreTxData();
extern int  getCoreAddressRegs();
extern int  updateTimestamp();
extern int  updateDtimCount();
extern int  updateCfpCount();
extern int  updateCfpDurRemaining();
extern int  updateAckRA();
extern int  coreDataFrameBody();
extern int  coreRTSFrame();
extern int  coreSelfCTSFrame();
extern int  corePSPollFrame();
extern int  coreCFEndFrame();
extern int  updateTxopBudgetLoad();
extern int  updatePolledTxop();
extern int  coreChannelSwitchAnnouncementFrame();
extern int  coreMeasurementRequestFrame();
extern int  coreMeasurementReportFrame();
extern int  coreTPCRequestFrame();
extern int  coreTPCReportFrame ();
extern int  coreTxCountryElement();
extern int  coreBFRFrameBody();

extern int  coreRSNHeader();
extern int  setAddRSNIE();
extern int  useTestVector();
extern int  setTxCipherType();

extern int  coreStopComparison();
extern int  resetEncryptEn();

extern int  shell_run();

extern int  printKnownBugs();

extern int  computeTimeOnAirAC();
// HSU functions
extern int  msg_init();
extern int  msg_append();
extern int  cmac();
extern int  tkip();

char *veriuser_version_str = "Register access by acc_handle routines\n";

int (*endofcompile_routines[])() =
{
    /*** my_eoc_routine, ***/
    0 /*** final entry must be 0 ***/
};

bool err_intercept(level,facility,code)
int level; char *facility; char *code;
{ return(true); }

s_tfcell veriusertfs[] =
{
    /*** Template for an entry:
    { usertask|userfunction, data,
      checktf(), sizetf(), calltf(), misctf(),
      "$tfname", forwref?, Vtool?, ErrMsg? },
      Example:
    { usertask, 0, my_check, 0, my_func, my_misctf, "$my_task" },
    ***/

   /*** add user entries here ***/
   {usertask,0,0,0,transmitFragment,0,"$transmitFragment"},
   {usertask,0,0,0,processRxedFragment,0,"$processRxedFragment"},
   {usertask,0,0,0,bitWrite,0,"$bitWrite"},
   {usertask,0,0,0,bitRead,0,"$bitRead"},
   {usertask,0,0,0,createBuffer,0,"$createBuffer"},
   {usertask,0,0,0,createBufferTx,0,"$createBufferTx"},
   {usertask,0,0,0,createBufferRx,0,"$createBufferRx"},
   {usertask,0,0,0,freeTxBuffer,0,"$freeTxBuffer"},
   {usertask,0,0,0,freeRxBuffer,0,"$freeRxBuffer"},
   {usertask,0,0,0,removeFile,0,"$removeFile"},
   {usertask,0,0,0,accessVerilogReg,0,"$accessVerilogReg"},
   {usertask,0,0,0,storeMacSimTxData,0,"$storeMacSimTxData"},
   {usertask,0,0,0,retrieveMacSimTxData,0,"$retrieveMacSimTxData"},
   {usertask,0,0,0,ampduFirstMpdu,0,"$ampduFirstMpdu"},
   {usertask,0,0,0,ampduFirstMpduVht,0,"$ampduFirstMpduVht"},
   {usertask,0,0,0,ampduMpdu,0,"$ampduMpdu"},
   {usertask,0,0,0,ampduMpduVht,0,"$ampduMpduVht"},
   {usertask,0,0,0,ampduLastMpdu,0,"$ampduLastMpdu"},
   {usertask,0,0,0,ampduLastMpduVht,0,"$ampduLastMpduVht"},
   {usertask,0,0,0,ampduFirstLastMpdu,0,"$ampduFirstLastMpdu"},
   {usertask,0,0,0,ampduFirstLastMpduVht,0,"$ampduFirstLastMpduVht"},

   {usertask,0,0,0,coreFrameControlField,0,"$coreFrameControlField"},

   {usertask,0,0,0,coreQosControlField,0,"$coreQosControlField"},
   {usertask,0,0,0,coreHTControlField,0,"$coreHTControlField"},
   {usertask,0,0,0,coreWAPIHeaderField,0,"$coreWAPIHeaderField"},
//   {usertask,0,0,0,coreTxSoundingDialogTokenField,0,"$coreTxSoundingDialogTokenField"},
//   {usertask,0,0,0,coreTxSTAInfoField,0,"$coreTxSTAInfoField"},
   {usertask,0,0,0,coreVHTNDPAFrameBody,0,"$coreVHTNDPAFrameBody"},
   {usertask,0,0,0,coreBARFrame,0,"$coreBARFrame"},
   {usertask,0,0,0,coreBAFrame,0,"$coreBAFrame"},

   {usertask,0,0,0,coreFrameHeader,0,"$coreFrameHeader"},
   {usertask,0,0,0,coreTxSSID,0,"$coreTxSSID"},
   {usertask,0,0,0,coreTxSupportedRates,0,"$coreTxSupportedRates"},
   {usertask,0,0,0,coreTxTIM,0,"$coreTxTIM"},
   {usertask,0,0,0,coreTxChallengeText,0,"$coreTxChallengeText"},
   {usertask,0,0,0,coreBeaconFrame,0,"$coreBeaconFrame"},
   {usertask,0,0,0,coreATIMFrame,0,"$coreATIMFrame"},
   {usertask,0,0,0,coreDisassociationFrame,0,"$coreDisassociationFrame"},
   {usertask,0,0,0,coreAssociationRequestFrame,0,"$coreAssociationRequestFrame"},
   {usertask,0,0,0,coreAssociationResponseFrame,0,"$coreAssociationResponseFrame"},
   {usertask,0,0,0,coreReassociationRequestFrame,0,"$coreReassociationRequestFrame"},
   {usertask,0,0,0,coreProbeRequestFrame,0,"$coreProbeRequestFrame"},
   {usertask,0,0,0,coreProbeResponseFrame,0,"$coreProbeResponseFrame"},
   {usertask,0,0,0,coreAuthenticationFrame,0,"$coreAuthenticationFrame"},
   {usertask,0,0,0,hostToCoreData,0,"$hostToCoreData"},
   {usertask,0,0,0,coreToHostData,0,"$coreToHostData"},
   {usertask,0,0,0,coreToHostIcvMic,0,"$coreToHostIcvMic"},
   {usertask,0,0,0,compareRxFragment,0,"$compareRxFragment"},
   {usertask,0,0,0,getCoreTxDataLengthWithIgnoreData,0,"$getCoreTxDataLengthWithIgnoreData"},
   {usertask,0,0,0,storeCoreTxData,0,"$storeCoreTxData"},
   {usertask,0,0,0,storeDur,0,"$storeDur"},
   {usertask,0,0,0,retrieveCoreTxData,0,"$retrieveCoreTxData"},
   {usertask,0,0,0,getCoreAddressRegs,0,"$getCoreAddressRegs"},
   {usertask,0,0,0,updateTimestamp,0,"$updateTimestamp"},
   {usertask,0,0,0,updateDtimCount,0,"$updateDtimCount"},
   {usertask,0,0,0,updateCfpCount,0,"$updateCfpCount"},
   {usertask,0,0,0,updateCfpDurRemaining,0,"$updateCfpDurRemaining"},
   {usertask,0,0,0,updateAckRA,0,"$updateAckRA"},
   {usertask,0,0,0,coreDataFrameBody,0,"$coreDataFrameBody"},
   {usertask,0,0,0,coreRTSFrame,0,"$coreRTSFrame"},
   {usertask,0,0,0,coreSelfCTSFrame,0,"$coreSelfCTSFrame"},
   {usertask,0,0,0,corePSPollFrame,0,"$corePSPollFrame"},
   {usertask,0,0,0,coreCFEndFrame,0,"$coreCFEndFrame"},
   {usertask,0,0,0,updateTxopBudgetLoad,0,"$updateTxopBudgetLoad"},
   {usertask,0,0,0,updatePolledTxop,0,"$updatePolledTxop"},
   {usertask,0,0,0,coreTPCReportFrame,0,"$coreTPCReportFrame"},
   {usertask,0,0,0,coreMeasurementReportFrame,0,"$coreMeasurementReportFrame"},
   {usertask,0,0,0,coreMeasurementRequestFrame,0,"$coreMeasurementRequestFrame"},
   {usertask,0,0,0,coreChannelSwitchAnnouncementFrame,0,"$coreChannelSwitchAnnouncementFrame"},
   {usertask,0,0,0,coreTPCRequestFrame,0,"$coreTPCRequestFrame"},
   {usertask,0,0,0,coreTxCountryElement,0,"$coreTxCountryElement"},
   {usertask,0,0,0,coreBFRFrameBody,0,"$coreBFRFrameBody"},

   {usertask,0,0,0,coreRSNHeader,0,"$coreRSNHeader"},
   {usertask,0,0,0,setAddRSNIE,0,"$setAddRSNIE"},
   {usertask,0,0,0,useTestVector,0,"$useTestVector"},
   {usertask,0,0,0,setTxCipherType,0,"$setTxCipherType"},

   {usertask,0,0,0,coreStopComparison,0,"$coreStopComparison"},
   {usertask,0,0,0,resetEncryptEn,0,"$resetEncryptEn"},

   {usertask,0,0,0,computeTimeOnAirAC,0,"$computeTimeOnAirAC"},
   // HSU tasks
   {usertask,0,0,0,msg_init,   0,"$msg_init"   },
   {usertask,0,0,0,msg_append, 0,"$msg_append" },
   {usertask,0,0,0,cmac,       0,"$cmac"       },
   {usertask,0,0,0,tkip,       0,"$tkip"       },

   // PHY TASKS
   {usertask,0,0,0,shell_run,0,"$shell_run"},

   // Print known bugs in RTL
   {usertask,0,0,0,0,printKnownBugs,"$printKnownBugs"},

   {0} /*** final entry must be 0 ***/
};
