//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef BFM_REPORT_SIZE_ESTIMATOR_SV
`define BFM_REPORT_SIZE_ESTIMATOR_SV

// funtion will return number of bytes that need to be read from
// beamforming memory by MAC
function int bfm_report_size_estimator(int Nr, int Nc, int ch_bw,
                                       int grouping, int codebook, int feedbacktype,
                                       bit debug = 0);

  real     num_bits_in_compr_bfm_field;
  real     num_bits_in_mu_excl_bfm_report;
  int      b_phi;     // bits in psi
  int      b_psi;     // bits in phi
  int      Ng;
  int      Na;
  int      Ns;
  int      Ns_prim;
  int      num_bytes_in_report;

  b_psi = (feedbacktype) ? ((codebook) ? 7 : 5) // MU
          : ((codebook) ? 4 : 2);               // SU

  b_phi = (feedbacktype) ? ((codebook) ? 9 : 7) // MU
          : ((codebook) ? 6 : 4);               // SU

  Ng = 2**grouping;
  Na = Na_table[Nr+1][Nc+1];
  Ns = Ns_table[ch_bw][`SCALE_NG_INDEX(Ng)];
  Ns_prim = Ns_prim_table[ch_bw][`SCALE_NG_INDEX(Ng)];

  // calculate number of bits in compressed beamforming field
  num_bits_in_compr_bfm_field = 8*(Nc+1) + Ns*Na*(b_phi+b_psi)/2.0;
  // calculate in MU exclusive BF report
  num_bits_in_mu_excl_bfm_report = 4*(Nc+1)*Ns_prim*feedbacktype;
  // calculate number of bytes in report
  num_bytes_in_report = $ceil(( num_bits_in_compr_bfm_field
                               +num_bits_in_mu_excl_bfm_report)/8.0);

  if (debug) begin
    $display("Nr (%0d)\nNc (%0d)\nNg (%0d)\nNa (%0d)\nb_psi (%0d)\nb_phi (%0d)\nNs (%0d)\nNs_prim (%0d)",
              Nr+1,Nc+1,Ng,Na,b_psi,b_phi,Ns,Ns_prim);
    $display("Bits in Compressed Beamforming filed: %0f",num_bits_in_compr_bfm_field);
    $display("Bits in MU Exclusive BF report: %0f",num_bits_in_mu_excl_bfm_report);
  end

  return num_bytes_in_report;
endfunction : bfm_report_size_estimator

`endif// BFM_REPORT_SIZE_ESTIMATOR_SV
