//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`ifndef BFM_REPORT_TABLES_SV
`define BFM_REPORT_TABLES_SV

`define SCALE_NG_INDEX(x) ((x==1)?0:((x==2)?1:2))

// definition of lookup tables
int Na_table[9][9] = '{
/*                  Nc                           */
/*   0,   1    2    3    4    5    6    7    8   */
  '{-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1}, /* 0 */
  '{-1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1}, /* 1 */
  '{-1,   2,   2,  -1,  -1,  -1,  -1,  -1,  -1}, /* 2 */
  '{-1,   4,   6,   6,  -1,  -1,  -1,  -1,  -1}, /* 3 */
  '{-1,   6,   10, 12,  12,  -1,  -1,  -1,  -1}, /* 4 */
  '{-1,   8,   14, 18,  20,  20,  -1,  -1,  -1}, /* 5 */ /* Nr */
  '{-1,   10,  18, 24,  28,  30,  30,  -1,  -1}, /* 6 */
  '{-1,   12,  22, 30,  36,  40,  42,  42,  -1}, /* 7 */
  '{-1,   14,  26, 36,  44,  50,  54,  56,  56}  /* 8 */
};

int Ns_table[4][3] = '{
/*        Ng             */
/*  1     2     4        */
  '{52,  30,   16}, /* 0 */
  '{108, 58,   30}, /* 1 */  /* BW */
  '{234, 122,  62}, /* 2 */
  '{468, 244, 124}  /* 3 */
};

int Ns_prim_table[4][3] = '{
/*        Ng             */
/*  1     2     4        */
  '{30,  16,   10}, /* 0 */
  '{58,  30,   16}, /* 1 */  /* BW */
  '{122, 62,   32}, /* 2 */
  '{244, 124,  64}  /* 3 */
};

typedef struct packed {
  int start_idx_f;
  int end_idx_f;
} ru_start_end_idx_s;

int SC_INDICES_20MHZ[2][] = '{
  /* Ng = 4 */
  '{ -122, -120, -116, -112, -108, -104, -100, -96, -92, -88, -84, -80, -76, -72, -68, -64,
     -60, -56, -52, -48, -44, -40, -36, -32, -28, -24, -20, -16, -12, -8, -4, -2, 2, 4,
     8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 72, 76, 80, 84,
     88, 92, 96, 100, 104, 108, 112, 116, 120, 122},
  /* Ng = 16 */
  '{-122, -116, -100, -84, -68, -52, -36, -20, -4, -2, 2, 4, 20, 36, 52, 68, 84, 100, 116, 122}
};

int SC_INDICES_40MHZ[2][] = '{
  /* Ng = 4 */
  '{-244, -240, -236, -232, -228, -224, -220, -216, -212, -208, -204, -200, -196, -192, -188, -184,
    -180, -176, -172, -168, -164, -160, -156, -152, -148, -144, -140, -136, -132, -128, -124, -120,
    -116, -112, -108, -104, -100, -96, -92, -88, -84, -80, -76, -72, -68, -64, -60, -56, -52, -48,
    -44, -40, -36, -32, -28, -24, -20, -16, -12, -8, -4, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40,
    44, 48, 52, 56, 60, 64, 68, 72, 76, 80, 84, 88, 92, 96, 100, 104, 108, 112, 116, 120, 124, 128,
    132, 136, 140, 144, 148, 152, 156, 160, 164, 168, 172, 176, 180, 184, 188, 192, 196, 200, 204,
    208, 212, 216, 220, 224, 228, 232, 236, 240, 244},
  /* Ng = 16 */
  '{-244, -228, -212, -196, -180, -164, -148, -132, -116, -100, -84, -68, -52, -36, -20, -4,
    4, 20, 36, 52, 68, 84, 100, 116, 132, 148, 164, 180, 196, 212, 228, 244}
};

int SC_INDICES_80MHZ[2][] = '{
  /* Ng = 4 */
  '{-500, -496, -492, -488, -484, -480, -476, -472, -468, -464, -460, -456, -452, -448, -444, -440, -436,
    -432, -428, -424, -420, -416, -412, -408, -404, -400, -396, -392, -388, -384, -380, -376, -372, -368,
    -364, -360, -356, -352, -348, -344, -340, -336, -332, -328, -324, -320, -316, -312, -308, -304, -300,
    -296, -292, -288, -284, -280, -276, -272, -268, -264, -260, -256, -252, -248, -244, -240, -236, -232,
    -228, -224, -220, -216, -212, -208, -204, -200, -196, -192, -188, -184, -180, -176, -172, -168, -164,
    -160, -156, -152, -148, -144, -140, -136, -132, -128, -124, -120, -116, -112, -108, -104, -100, -96,
    -92, -88, -84, -80, -76, -72, -68, -64, -60, -56, -52, -48, -44, -40, -36, -32, -28, -24, -20, -16,
    16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 72, 76, 80, 84, 88,
    92, 96, 100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140, 144, 148, 152, 156, 160, 164, 168, 172,
    176, 180, 184, 188, 192, 196, 200, 204, 208, 212, 216, 220, 224, 228, 232, 236, 240, 244, 248, 252, 256,
    260, 264, 268, 272, 276, 280, 284, 288, 292, 296, 300, 304, 308, 312, 316, 320, 324, 328, 332, 336, 340,
    344, 348, 352, 356, 360, 364, 368, 372, 376, 380, 384, 388, 392, 396, 400, 404, 408, 412, 416, 420, 424,
    428, 432, 436, 440, 444, 448, 452, 456, 460, 464, 468, 472, 476, 480, 484, 488, 492, 496, 500},
  /* Ng = 16 */
  '{-500, -484, -468, -452, -436, -420, -404, -388, -372, -356, -340, -324, -308, -292, -276, -260, -244,
    -228, -212, -196, -180, -164, -148, -132, -116, -100, -84, -68, -52, -36, -20, -4, 4, 20, 36, 52, 68,
    84, 100, 116, 132, 148, 164, 180, 196, 212, 228, 244, 260, 276, 292, 308, 324, 340, 356, 372, 388, 404,
    420, 436, 452, 468, 484, 500}
};

// first dimension is per Ng, second dimension is BW, third is RU index
ru_start_end_idx_s SC_INDEX_FROM_RU_INDEX[2][3][] = '{
  /* Ng = 4  */
  '{
    /* BW20*/
    '{ '{-122, -96}, /* 0 */
       '{ -96, -68}, /* 1 */
       '{ -68, -40}, /* 2 */
       '{ -44, -16}, /* 3 */
       '{ -16,  16}, /* 4 */  /* RU index */
       '{  16,  44}, /* 5 */
       '{  40,  68}, /* 6 */
       '{  68,  96}, /* 7 */
       '{  96, 122}  /* 8 */
     },
    /* BW40 */
    '{'{-244, -216}, /* 0  */
      '{-220, -192}, /* 1  */
      '{-192, -164}, /* 2  */
      '{-164, -136}, /* 3  */
      '{-136, -108}, /* 4  */
      '{-112,  -84}, /* 5  */
      '{ -84,  -56}, /* 6  */
      '{ -56,  -28}, /* 7  */ /* RU index */
      '{ -32,   -4}, /* 8  */
      '{  4 ,   32}, /* 9  */
      '{  28,   56}, /* 10 */
      '{  56,   84}, /* 11 */
      '{  84,  112}, /* 12 */
      '{ 108,  136}, /* 13 */
      '{ 136,  164}, /* 14 */
      '{ 164,  192}, /* 15 */
      '{ 192,  220}, /* 16 */
      '{ 216,  244}  /* 17 */
    },
    /* BW80 */
    '{'{-500, -472}, /* 0  */
      '{-476, -448}, /* 1  */
      '{-448, -420}, /* 2  */
      '{-420, -392}, /* 3  */
      '{-392, -364}, /* 4  */
      '{-368, -340}, /* 5  */
      '{-340, -312}, /* 6  */
      '{-312, -284}, /* 7  */
      '{-288, -260}, /* 8  */
      '{-260, -232}, /* 9  */
      '{-232, -204}, /* 10 */
      '{-204, -176}, /* 11 */
      '{-180, -152}, /* 12 */
      '{-152, -124}, /* 13 */
      '{-124,  -96}, /* 14 */
      '{-100,  -72}, /* 15 */
      '{-72 ,  -44}, /* 16 */
      '{-44 ,  -16}, /* 17 */
      '{-16 ,   16}, /* 18 */ /* RU index */
      '{16  ,   44}, /* 19 */
      '{44  ,   72}, /* 20 */
      '{72  ,  100}, /* 21 */
      '{96  ,  124}, /* 22 */
      '{124 ,  152}, /* 23 */
      '{152 ,  180}, /* 24 */
      '{176 ,  204}, /* 25 */
      '{204 ,  232}, /* 26 */
      '{232 ,  260}, /* 27 */
      '{260 ,  288}, /* 28 */
      '{284 ,  312}, /* 29 */
      '{312 ,  340}, /* 30 */
      '{340 ,  368}, /* 31 */
      '{364 ,  392}, /* 32 */
      '{392 ,  420}, /* 33 */
      '{420 ,  448}, /* 34 */
      '{448 ,  476}, /* 35 */
      '{472 ,  500}  /* 36 */
    }
  }, /* end Ng = 4*/
  /* Ng = 16 */
  '{
    /* BW20*/
    '{ '{-122,  -84}, /* 0 */
       '{ -96,  -64}, /* 1 */
       '{ -80,  -32}, /* 2 */
       '{ -52,   -4}, /* 3 */
       '{ -20,   20}, /* 4 */  /* RU index */
       '{   4,   52}, /* 5 */
       '{  32,   80}, /* 6 */
       '{  64,   96}, /* 7 */
       '{  84,  122}  /* 8 */
     },
    /* BW40 */
    '{'{-244, -212}, /* 0  */
      '{-228, -180}, /* 1  */
      '{-196, -164}, /* 2  */
      '{-164, -132}, /* 3  */
      '{-148, -100}, /* 4  */
      '{-116,  -84}, /* 5  */
      '{ -84,  -52}, /* 6  */
      '{ -68,  -20}, /* 7  */ /* RU index */
      '{ -36,   -4}, /* 8  */
      '{   4,   36}, /* 9  */
      '{  20,   68}, /* 10 */
      '{  52,   84}, /* 11 */
      '{  84,  116}, /* 12 */
      '{ 100,  148}, /* 13 */
      '{ 132,  164}, /* 14 */
      '{ 164,  196}, /* 15 */
      '{ 180,  228}, /* 16 */
      '{ 212,  244}  /* 17 */
    },
    /* BW80 */
    '{'{-500, -468}, /* 0  */
      '{-484, -436}, /* 1  */
      '{-452, -420}, /* 2  */
      '{-420, -388}, /* 3  */
      '{-404, -356}, /* 4  */
      '{-372, -340}, /* 5  */
      '{-340, -308}, /* 6  */
      '{-324, -276}, /* 7  */
      '{-292, -260}, /* 8  */
      '{-260, -228}, /* 9  */
      '{-244, -196}, /* 10 */
      '{-212, -164}, /* 11 */
      '{-180, -148}, /* 12 */
      '{-164, -116}, /* 13 */
      '{-132,  -84}, /* 14 */
      '{-100,  -68}, /* 15 */
      '{ -84,  -36}, /* 16 */
      '{ -52,   -4}, /* 17 */
      '{ -20,   20}, /* 18 */ /* RU index */
      '{   4,   52}, /* 19 */
      '{  36,   84}, /* 20 */
      '{  68,  100}, /* 21 */
      '{  84,  132}, /* 22 */
      '{ 116,  164}, /* 23 */
      '{ 148,  180}, /* 24 */
      '{ 164,  212}, /* 25 */
      '{ 196,  244}, /* 26 */
      '{ 228,  260}, /* 27 */
      '{ 260,  292}, /* 28 */
      '{ 276,  324}, /* 29 */
      '{ 308,  340}, /* 30 */
      '{ 340,  372}, /* 31 */
      '{ 356,  404}, /* 32 */
      '{ 388,  420}, /* 33 */
      '{ 420,  452}, /* 34 */
      '{ 436,  484}, /* 35 */
      '{ 468,  500}  /* 36 */
    }
  } /* end Ng = 16 */
};

`endif//BFM_REPORT_TABLES_SV
