//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////

`ifndef HE_BFM_REPORT_SIZE_ESTIMATOR_SV
`define HE_BFM_REPORT_SIZE_ESTIMATOR_SV

// funtion will return number of bytes that need to be read from
// beamforming memory by MAC
function int he_bfm_report_size_estimator(int Nr,
                                          int Nc,
                                          int ch_bw,
                                          int grouping,
                                          int codebook,
                                          int feedbacktype,
                                          int ru_start_index,
                                          int ru_end_index,
                                          bit debug = 0);

  real     num_bits_in_compr_bfm_field;
  real     num_bits_in_mu_excl_bfm_report;
  int      b_phi;     // bits in psi
  int      b_psi;     // bits in phi
  int      Ng;
  int      Na;
  int      Ns;
  real     Ns_real;
  int      num_bytes_in_report;
  ru_start_end_idx_s sc_index;
  int      sc_start_index;
  int      sc_end_index;

  b_psi = (feedbacktype) ? ((codebook) ? 7 : 5) // MU
          : ((codebook) ? 4 : 2);               // SU

  b_phi = (feedbacktype) ? ((codebook) ? 9 : 7) // MU
          : ((codebook) ? 6 : 4);               // SU

  Ng = 4**(grouping+1);
  Na = Na_table[Nr+1][Nc+1];
  // find starting index of SC
  sc_index = SC_INDEX_FROM_RU_INDEX[grouping][ch_bw][ru_start_index];
  sc_start_index = sc_index.start_idx_f;
  // find ending index of SC
  sc_index = SC_INDEX_FROM_RU_INDEX[grouping][ch_bw][ru_end_index];
  sc_end_index = sc_index.end_idx_f;
  Ns = 0;
  // count from starting SC index to inding SC index in steps of Ng to
  // determine how much SC are indices
  if (ch_bw == 0) begin
    for (int i=sc_start_index; i<=sc_end_index; i++)
      if (i inside {SC_INDICES_20MHZ[grouping]})
        Ns++;
  end
  else if (ch_bw == 1) begin
    for (int i=sc_start_index; i<=sc_end_index; i++)
      if (i inside {SC_INDICES_40MHZ[grouping]})
        Ns++;
  end
  else if (ch_bw == 2) begin
    for (int i=sc_start_index; i<=sc_end_index; i++)
      if (i inside {SC_INDICES_80MHZ[grouping]})
        Ns++;
  end
  // calculate number of bits in compressed beamforming field
  num_bits_in_compr_bfm_field = 8*(Nc+1) + Ns*Na*(b_phi+b_psi)/2.0;
  // calculate in MU exclusive BF report
  num_bits_in_mu_excl_bfm_report = 4*(Nc+1)*Ns*feedbacktype;
  // calculate number of bytes in report
  num_bytes_in_report = $ceil(( num_bits_in_compr_bfm_field
                               +num_bits_in_mu_excl_bfm_report)/8.0);

  if (debug) begin
    $display("Nr (%0d)\nNc (%0d)\nNg (%0d)\nNa (%0d)\nb_psi (%0d)\nb_phi (%0d)\nNs (%0d)",
              Nr+1,Nc+1,Ng,Na,b_psi,b_phi,Ns);
    $display("SC start index %0d, SC end index %0d", sc_start_index, sc_end_index);
    $display("Bits in Compressed Beamforming filed: %0f",num_bits_in_compr_bfm_field);
    $display("Bits in MU Exclusive BF report: %0f",num_bits_in_mu_excl_bfm_report);
  end

  return num_bytes_in_report;
endfunction : he_bfm_report_size_estimator

`endif// HE_BFM_REPORT_SIZE_ESTIMATOR_SV
