//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`ifndef TEST_BFR_ESTIMATOR_SV
`define TEST_BFR_ESTIMATOR_SV

module test_bfr_estimator;
  import misc_pkg::*;

  int bfr_size;

  initial begin
    $display("***********************************************");
    $display(" TEST BEAMFORMING ESTIMATOR FUNCTION");
    $display("***********************************************");

    $display("****************** BW20, Ng = 4 ****************");
    for (int i=0; i<=8; i++) begin
      for (int j=i; j<=8; j++) begin
        bfr_size = he_bfm_report_size_estimator(.Nr            (1),
                                                .Nc            (0),
                                                .ch_bw         (0),
                                                .grouping      (0),
                                                .codebook      (0),
                                                .feedbacktype  (0),
                                                .ru_start_index(i),
                                                .ru_end_index  (j),
                                                .debug         (1));
        $display("\nBFR SIZE: %0d for RU start index %0d, RU end index %0d\n",
        bfr_size, i, j);
      end
    end

    $display("****************** BW40, Ng = 4 ****************");
    for (int i=0; i<=17; i++) begin
      for (int j=i; j<=17; j++) begin
        bfr_size = he_bfm_report_size_estimator(.Nr            (1),
                                                .Nc            (0),
                                                .ch_bw         (1),
                                                .grouping      (0),
                                                .codebook      (0),
                                                .feedbacktype  (0),
                                                .ru_start_index(i),
                                                .ru_end_index  (j),
                                                .debug         (1));
        $display("\nBFR SIZE: %0d for RU start index %0d, RU end index %0d\n",
        bfr_size, i, j);
      end
    end

    // create SC indexes for 40CHBW
    $display("SC_INDICES_40MHZ[2][] = '{");
    $display("'{");
    for (int i=-244; i<=244; i=i+4) begin
      $write("%0d, ", i);
    end
    $display("},");
    $display("'{");
    for (int i=-244; i<=244;) begin
      $write("%0d, ", i);
      if (i == -4) i = 4;
      else         i = i + 16;
    end
    $display("}");
    $display("};");
    // create SC indexes for 80CHBW
    $display("SC_INDICES_80MHZ[2][] = '{");
    $display("'{");
    for (int i=-500; i<=500; i=i+4) begin
      $write("%0d, ", i);
    end
    $display("},");
    $display("'{");
    for (int i=-500; i<=500;) begin
      $write("%0d, ", i);
      if (i == -4) i = 4;
      else         i = i + 16;
    end
    $display("}");
    $display("};");
    $finish();
  end

endmodule : test_bfr_estimator

`endif//TEST_BFR_ESTIMATOR_SV
