//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $RCSmodulefile   :
// $Author          :
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 0.1
// $Date: 22-Dec-2008
// $State: Complete
// $Locker:
// ---------------------------------------------------------------------------
// Dependencies     :
// Description      : TKIP Class For TB
//
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

bit [7:0] AES_SBOX[16][16]   ='{
                              '{8'h63,8'h7c,8'h77,8'h7b,8'hf2,8'h6b,8'h6f,8'hc5,8'h30,8'h01,8'h67,8'h2b,8'hfe,8'hd7,8'hab,8'h76},
                              '{8'hca,8'h82,8'hc9,8'h7d,8'hfa,8'h59,8'h47,8'hf0,8'had,8'hd4,8'ha2,8'haf,8'h9c,8'ha4,8'h72,8'hc0},
                              '{8'hb7,8'hfd,8'h93,8'h26,8'h36,8'h3f,8'hf7,8'hcc,8'h34,8'ha5,8'he5,8'hf1,8'h71,8'hd8,8'h31,8'h15},
                              '{8'h04,8'hc7,8'h23,8'hc3,8'h18,8'h96,8'h05,8'h9a,8'h07,8'h12,8'h80,8'he2,8'heb,8'h27,8'hb2,8'h75},
                              '{8'h09,8'h83,8'h2c,8'h1a,8'h1b,8'h6e,8'h5a,8'ha0,8'h52,8'h3b,8'hd6,8'hb3,8'h29,8'he3,8'h2f,8'h84},
                              '{8'h53,8'hd1,8'h00,8'hed,8'h20,8'hfc,8'hb1,8'h5b,8'h6a,8'hcb,8'hbe,8'h39,8'h4a,8'h4c,8'h58,8'hcf},
                              '{8'hd0,8'hef,8'haa,8'hfb,8'h43,8'h4d,8'h33,8'h85,8'h45,8'hf9,8'h02,8'h7f,8'h50,8'h3c,8'h9f,8'ha8},
                              '{8'h51,8'ha3,8'h40,8'h8f,8'h92,8'h9d,8'h38,8'hf5,8'hbc,8'hb6,8'hda,8'h21,8'h10,8'hff,8'hf3,8'hd2},
                              '{8'hcd,8'h0c,8'h13,8'hec,8'h5f,8'h97,8'h44,8'h17,8'hc4,8'ha7,8'h7e,8'h3d,8'h64,8'h5d,8'h19,8'h73},
                              '{8'h60,8'h81,8'h4f,8'hdc,8'h22,8'h2a,8'h90,8'h88,8'h46,8'hee,8'hb8,8'h14,8'hde,8'h5e,8'h0b,8'hdb},
                              '{8'he0,8'h32,8'h3a,8'h0a,8'h49,8'h06,8'h24,8'h5c,8'hc2,8'hd3,8'hac,8'h62,8'h91,8'h95,8'he4,8'h79},
                              '{8'he7,8'hc8,8'h37,8'h6d,8'h8d,8'hd5,8'h4e,8'ha9,8'h6c,8'h56,8'hf4,8'hea,8'h65,8'h7a,8'hae,8'h08},
                              '{8'hba,8'h78,8'h25,8'h2e,8'h1c,8'ha6,8'hb4,8'hc6,8'he8,8'hdd,8'h74,8'h1f,8'h4b,8'hbd,8'h8b,8'h8a},
                              '{8'h70,8'h3e,8'hb5,8'h66,8'h48,8'h03,8'hf6,8'h0e,8'h61,8'h35,8'h57,8'hb9,8'h86,8'hc1,8'h1d,8'h9e},
                              '{8'he1,8'hf8,8'h98,8'h11,8'h69,8'hd9,8'h8e,8'h94,8'h9b,8'h1e,8'h87,8'he9,8'hce,8'h55,8'h28,8'hdf},
                              '{8'h8c,8'ha1,8'h89,8'h0d,8'hbf,8'he6,8'h42,8'h68,8'h41,8'h99,8'h2d,8'h0f,8'hb0,8'h54,8'hbb,8'h16}
                               };

bit [7:0] AES_INVSBOX[16][16]='{
                              '{8'h52,8'h09,8'h6a,8'hd5,8'h30,8'h36,8'ha5,8'h38,8'hbf,8'h40,8'ha3,8'h9e,8'h81,8'hf3,8'hd7,8'hfb},
                              '{8'h7c,8'he3,8'h39,8'h82,8'h9b,8'h2f,8'hff,8'h87,8'h34,8'h8e,8'h43,8'h44,8'hc4,8'hde,8'he9,8'hcb},
                              '{8'h54,8'h7b,8'h94,8'h32,8'ha6,8'hc2,8'h23,8'h3d,8'hee,8'h4c,8'h95,8'h0b,8'h42,8'hfa,8'hc3,8'h4e},
                              '{8'h08,8'h2e,8'ha1,8'h66,8'h28,8'hd9,8'h24,8'hb2,8'h76,8'h5b,8'ha2,8'h49,8'h6d,8'h8b,8'hd1,8'h25},
                              '{8'h72,8'hf8,8'hf6,8'h64,8'h86,8'h68,8'h98,8'h16,8'hd4,8'ha4,8'h5c,8'hcc,8'h5d,8'h65,8'hb6,8'h92},
                              '{8'h6c,8'h70,8'h48,8'h50,8'hfd,8'hed,8'hb9,8'hda,8'h5e,8'h15,8'h46,8'h57,8'ha7,8'h8d,8'h9d,8'h84},
                              '{8'h90,8'hd8,8'hab,8'h00,8'h8c,8'hbc,8'hd3,8'h0a,8'hf7,8'he4,8'h58,8'h05,8'hb8,8'hb3,8'h45,8'h06},
                              '{8'hd0,8'h2c,8'h1e,8'h8f,8'hca,8'h3f,8'h0f,8'h02,8'hc1,8'haf,8'hbd,8'h03,8'h01,8'h13,8'h8a,8'h6b},
                              '{8'h3a,8'h91,8'h11,8'h41,8'h4f,8'h67,8'hdc,8'hea,8'h97,8'hf2,8'hcf,8'hce,8'hf0,8'hb4,8'he6,8'h73},
                              '{8'h96,8'hac,8'h74,8'h22,8'he7,8'had,8'h35,8'h85,8'he2,8'hf9,8'h37,8'he8,8'h1c,8'h75,8'hdf,8'h6e},
                              '{8'h47,8'hf1,8'h1a,8'h71,8'h1d,8'h29,8'hc5,8'h89,8'h6f,8'hb7,8'h62,8'h0e,8'haa,8'h18,8'hbe,8'h1b},
                              '{8'hfc,8'h56,8'h3e,8'h4b,8'hc6,8'hd2,8'h79,8'h20,8'h9a,8'hdb,8'hc0,8'hfe,8'h78,8'hcd,8'h5a,8'hf4},
                              '{8'h1f,8'hdd,8'ha8,8'h33,8'h88,8'h07,8'hc7,8'h31,8'hb1,8'h12,8'h10,8'h59,8'h27,8'h80,8'hec,8'h5f},
                              '{8'h60,8'h51,8'h7f,8'ha9,8'h19,8'hb5,8'h4a,8'h0d,8'h2d,8'he5,8'h7a,8'h9f,8'h93,8'hc9,8'h9c,8'hef},
                              '{8'ha0,8'he0,8'h3b,8'h4d,8'hae,8'h2a,8'hf5,8'hb0,8'hc8,8'heb,8'hbb,8'h3c,8'h83,8'h53,8'h99,8'h61},
                              '{8'h17,8'h2b,8'h04,8'h7e,8'hba,8'h77,8'hd6,8'h26,8'he1,8'h69,8'h14,8'h63,8'h55,8'h21,8'h0c,8'h7d}
                               };

// Test vector key expanding from AES fips-197 2001
bit [127:0] AES_K128         = 128'h3c4fcf098815f7aba6d2ae2816157e2b;
bit [0:31]  AES_W128[44]     ='{
                                32'h2b7e1516, 32'h28aed2a6, 32'habf71588, 32'h09cf4f3c,
                                32'ha0fafe17, 32'h88542cb1, 32'h23a33939, 32'h2a6c7605,
                                32'hf2c295f2, 32'h7a96b943, 32'h5935807a, 32'h7359f67f,
                                32'h3d80477d, 32'h4716fe3e, 32'h1e237e44, 32'h6d7a883b,
                                32'hef44a541, 32'ha8525b7f, 32'hb671253b, 32'hdb0bad00,
                                32'hd4d1c6f8, 32'h7c839d87, 32'hcaf2b8bc, 32'h11f915bc,
                                32'h6d88a37a, 32'h110b3efd, 32'hdbf98641, 32'hca0093fd,
                                32'h4e54f70e, 32'h5f5fc9f3, 32'h84a64fb2, 32'h4ea6dc4f,
                                32'head27321, 32'hb58dbad2, 32'h312bf560, 32'h7f8d292f,
                                32'hac7766f3, 32'h19fadc21, 32'h28d12941, 32'h575c006e,
                                32'hd014f9a8, 32'hc9ee2589, 32'he13f0cc8, 32'hb6630ca6
                               };

bit [255:0] AES_K256         = 256'hf4df1409a310982dd708613b072c351f81777d85f0ae732bbe71ca1510eb3d60;
bit [0:31]  AES_W256[60]     ='{
                                32'h603deb10, 32'h15ca71be, 32'h2b73aef0, 32'h857d7781,
                                32'h1f352c07, 32'h3b6108d7, 32'h2d9810a3, 32'h0914dff4,
                                32'h9ba35411, 32'h8e6925af, 32'ha51a8b5f, 32'h2067fcde,
                                32'ha8b09c1a, 32'h93d194cd, 32'hbe49846e, 32'hb75d5b9a,
                                32'hd59aecb8, 32'h5bf3c917, 32'hfee94248, 32'hde8ebe96,
                                32'hb5a9328a, 32'h2678a647, 32'h98312229, 32'h2f6c79b3,
                                32'h812c81ad, 32'hdadf48ba, 32'h24360af2, 32'hfab8b464,
                                32'h98c5bfc9, 32'hbebd198e, 32'h268c3ba7, 32'h09e04214,
                                32'h68007bac, 32'hb2df3316, 32'h96e939e4, 32'h6c518d80,
                                32'hc814e204, 32'h76a9fb8a, 32'h5025c02d, 32'h59c58239,
                                32'hde136967, 32'h6ccc5a71, 32'hfa256395, 32'h9674ee15,
                                32'h5886ca5d, 32'h2e2f31d7, 32'h7e0af1fa, 32'h27cf73c3,
                                32'h749c47ab, 32'h18501dda, 32'he2757e4f, 32'h7401905a,
                                32'hcafaaae3, 32'he4d59b34, 32'h9adf6ace, 32'hbd10190d,
                                32'hfe4890d1, 32'he6188d0b, 32'h046df344, 32'h706c631e
                               };


// Test vector for aes encryption from AES fips-197 2001
bit  [7:0] AES_ENC_KEY[16]        = '{8'h2b,8'h7e,8'h15,8'h16,8'h28,8'hae,8'hd2,8'ha6,
                                      8'hab,8'hf7,8'h15,8'h88,8'h09,8'hcf,8'h4f,8'h3c};
bit  [7:0] AES_ENC_ENC_DATA[16]   = '{8'h39,8'h25,8'h84,8'h1d,8'h02,8'hdc,8'h09,8'hfb,
                                      8'hdc,8'h11,8'h85,8'h97,8'h19,8'h6a,8'h0b,8'h32};
bit  [7:0] AES_ENC_PLAIN_DATA[16] = '{8'h32,8'h43,8'hf6,8'ha8,8'h88,8'h5a,8'h30,8'h8d,
                                      8'h31,8'h31,8'h98,8'ha2,8'he0,8'h37,8'h07,8'h34};

bit  [7:0] AES_KEY128[16]         = '{8'h00,8'h01,8'h02,8'h03,8'h04,8'h05,8'h06,8'h07,
                                      8'h08,8'h09,8'h0a,8'h0b,8'h0c,8'h0d,8'h0e,8'h0f};
bit  [7:0] AES_PLAINTEXT128[16]   = '{8'h00,8'h11,8'h22,8'h33,8'h44,8'h55,8'h66,8'h77,
                                      8'h88,8'h99,8'haa,8'hbb,8'hcc,8'hdd,8'hee,8'hff};
bit  [7:0] AES_CIPHER128[16]      = '{8'h69,8'hc4,8'he0,8'hd8,8'h6a,8'h7b,8'h04,8'h30,
                                      8'hd8,8'hcd,8'hb7,8'h80,8'h70,8'hb4,8'hc5,8'h5a};

bit  [7:0] AES_KEY256[32]         = '{8'h00,8'h01,8'h02,8'h03,8'h04,8'h05,8'h06,8'h07,
                                      8'h08,8'h09,8'h0a,8'h0b,8'h0c,8'h0d,8'h0e,8'h0f,
                                      8'h10,8'h11,8'h12,8'h13,8'h14,8'h15,8'h16,8'h17,
                                      8'h18,8'h19,8'h1a,8'h1b,8'h1c,8'h1d,8'h1e,8'h1f};
bit  [7:0] AES_PLAINTEXT256[16]   = '{8'h00,8'h11,8'h22,8'h33,8'h44,8'h55,8'h66,8'h77,
                                      8'h88,8'h99,8'haa,8'hbb,8'hcc,8'hdd,8'hee,8'hff};
bit  [7:0] AES_CIPHER256[16]      = '{8'h8e,8'ha2,8'hb7,8'hca,8'h51,8'h67,8'h45,8'hbf,
                                      8'hea,8'hfc,8'h49,8'h90,8'h4b,8'h49,8'h60,8'h89};

class aes;
  int         Nb;
  int         Nk;
  int         Nr;

  bit   [7:0] plain_data[];
  bit   [7:0] enc_data[];
  bit   [7:0] dec_data[];

  bit   [7:0] Key[];
  bit  [31:0] w[];
  bit  [31:0] Rcon[];

  bit   [7:0] state[4][4/*Nb*/];
  bit [127:0] state_queue[];

  int         aes_err_cnt = 0;

  function new();
    plain_data.delete();
    enc_data.delete();
    dec_data.delete();
    Key.delete();
    w.delete();
    Rcon.delete();
    state_queue.delete();
  endfunction : new

  function int high_order(bit [31:0] polynom);
    int order;
    for(order=31; order>0; order=order-1)
    begin
      if(polynom[order] == 1)
        break;
    end
    return ((order > 8) ? order-8 : 0);
  endfunction : high_order

  function bit [7:0] GF_11B(bit [31:0] polynom);
    bit [31:0] tmp_var;
    bit [31:0] tmp_shift;

    tmp_var   = polynom;
    while(tmp_var > 32'h000000FF)
    begin
      tmp_shift = (32'h0000011B << high_order(tmp_var));
      tmp_var   = tmp_var ^ tmp_shift;
    end
    return tmp_var[7:0];
  endfunction : GF_11B

  function bit [7:0] GF_MULT(bit [7:0] x, bit [7:0] y);
    bit [7:0] product = 8'h0;

    for(int i=0; i<8; i=i+1)
    begin
      product = y[0] ? product^x : product;
      y       = y >> 1;
      x       = (x<<1)^(8'h1b & {x[7],x[7],x[7],x[7],x[7],x[7],x[7],x[7]});
    end

    return product;
  endfunction : GF_MULT

  function bit [31:0] SubWord(bit [31:0] word_in);
    return ( { AES_SBOX[word_in[31:28]][word_in[27:24]],
               AES_SBOX[word_in[23:20]][word_in[19:16]],
               AES_SBOX[word_in[15:12]][word_in[11: 8]],
               AES_SBOX[word_in[ 7: 4]][word_in[ 3: 0]]
             } );
  endfunction : SubWord

  function bit [31:0] RotWord(bit [31:0] word_in);
    return ({word_in[7:0],word_in[31:8]});
  endfunction : RotWord

  function void display_state(string msg= "");
    $display("\n %s",msg);
    $display(" %02h %02h %02h %02h",state[0][0],state[0][1],state[0][2],state[0][3]);
    $display(" %02h %02h %02h %02h",state[1][0],state[1][1],state[1][2],state[1][3]);
    $display(" %02h %02h %02h %02h",state[2][0],state[2][1],state[2][2],state[2][3]);
    $display(" %02h %02h %02h %02h",state[3][0],state[3][1],state[3][2],state[3][3]);
  endfunction : display_state

  function void gen_plain_data(input bit [7:0] plain_data_in[] = {}, input bit valid = 1'b0);
    int plain_data_length = $urandom_range(1024,1);
    if(valid && (plain_data_in.size() != 0))
    begin
      plain_data = new[plain_data_in.size()](plain_data_in);
    end
    else
    begin
      plain_data = new[plain_data_length];
      foreach(plain_data[i])
        plain_data[i] = $urandom_range(255,0);
    end
  endfunction : gen_plain_data

  function void gen_Key(input bit [7:0] Key_in[] = {}, input bit valid = 1'b0, input bit key_size = 0);

    if (valid & Key_in.size==32 | ~valid & key_size==1)
    begin
      // AES-256
      Nb   = 4;
      Nk   = 8;
      Nr   = 14;
      Key  = new[32];
    end
    else
    begin
      // AES-128
      Nb   = 4;
      Nk   = 4;
      Nr   = 10;
      Key  = new[16];
    end

    if(valid)
      foreach(Key[i]) Key[i] = Key_in[i];
    else
      foreach(Key[i]) Key[i] = $urandom_range(255,0);

  endfunction : gen_Key

  function void gen_state_queue(bit [7:0] aes_data[]);
    int aes_data_length    = aes_data.size();
    int remainder          = (aes_data.size()%16) ? 1:0;
    int state_queue_length = (aes_data_length/16) + remainder;

    state_queue = new[state_queue_length];

    foreach(state_queue[i])
    begin
      state_queue[i] = { (i*16+15 < aes_data_length) ? aes_data[i*16+15] : 8'h00,
                         (i*16+14 < aes_data_length) ? aes_data[i*16+14] : 8'h00,
                         (i*16+13 < aes_data_length) ? aes_data[i*16+13] : 8'h00,
                         (i*16+12 < aes_data_length) ? aes_data[i*16+12] : 8'h00,
                         (i*16+11 < aes_data_length) ? aes_data[i*16+11] : 8'h00,
                         (i*16+10 < aes_data_length) ? aes_data[i*16+10] : 8'h00,
                         (i*16+ 9 < aes_data_length) ? aes_data[i*16+ 9] : 8'h00,
                         (i*16+ 8 < aes_data_length) ? aes_data[i*16+ 8] : 8'h00,
                         (i*16+ 7 < aes_data_length) ? aes_data[i*16+ 7] : 8'h00,
                         (i*16+ 6 < aes_data_length) ? aes_data[i*16+ 6] : 8'h00,
                         (i*16+ 5 < aes_data_length) ? aes_data[i*16+ 5] : 8'h00,
                         (i*16+ 4 < aes_data_length) ? aes_data[i*16+ 4] : 8'h00,
                         (i*16+ 3 < aes_data_length) ? aes_data[i*16+ 3] : 8'h00,
                         (i*16+ 2 < aes_data_length) ? aes_data[i*16+ 2] : 8'h00,
                         (i*16+ 1 < aes_data_length) ? aes_data[i*16+ 1] : 8'h00,
                         (i*16+ 0 < aes_data_length) ? aes_data[i*16+ 0] : 8'h00
                      };
    end
  endfunction : gen_state_queue

  function void get_state(input int i);
    state[0] = '{ state_queue[i][  7:  0], state_queue[i][ 39: 32], state_queue[i][ 71: 64], state_queue[i][103: 96]};
    state[1] = '{ state_queue[i][ 15:  8], state_queue[i][ 47: 40], state_queue[i][ 79: 72], state_queue[i][111:104]};
    state[2] = '{ state_queue[i][ 23: 16], state_queue[i][ 55: 48], state_queue[i][ 87: 80], state_queue[i][119:112]};
    state[3] = '{ state_queue[i][ 31: 24], state_queue[i][ 63: 56], state_queue[i][ 95: 88], state_queue[i][127:120]};
  endfunction : get_state

  function void get_state_out(inout bit [7:0] array_inout[]);
    array_inout = new[array_inout.size()+16](array_inout);

    for(int i=0; i<4; i=i+1)
    begin
      for(int j=0; j<4; j=j+1)
      begin
        array_inout[array_inout.size() - 16 + i + 4*j] = state[i][j];
      end
    end
  endfunction : get_state_out

  function void SubBytes();
    foreach(state[i])
    begin
      for(int j=0; j<Nb; j=j+1)
      begin
        state[i][j] = AES_SBOX[state[i][j][7:4]][state[i][j][3:0]];
      end
    end
  endfunction : SubBytes

  function void InvSubBytes();
    foreach(state[i])
    begin
      for(int j=0; j<Nb; j=j+1)
      begin
        state[i][j] = AES_INVSBOX[state[i][j][7:4]][state[i][j][3:0]];
      end
    end
  endfunction : InvSubBytes

  function void ShiftRows();
    state[1] = '{ state[1][1], state[1][2], state[1][3], state[1][0]};
    state[2] = '{ state[2][2], state[2][3], state[2][0], state[2][1]};
    state[3] = '{ state[3][3], state[3][0], state[3][1], state[3][2]};
  endfunction : ShiftRows

  function void InvShiftRows();
    state[1] = '{ state[1][3], state[1][0], state[1][1], state[1][2]};
    state[2] = '{ state[2][2], state[2][3], state[2][0], state[2][1]};
    state[3] = '{ state[3][1], state[3][2], state[3][3], state[3][0]};
  endfunction : InvShiftRows

  function void MixColumns();
    bit  [7:0] tmp_var[4];
    for(int j=0; j<4; j=j+1)
    begin
      tmp_var     = '{ state[0][j], state[1][j], state[2][j], state[3][j]};
      for(int k=0; k<4; k=k+1)
      begin
        state[k][j] = GF_MULT(8'h02,tmp_var[k]) ^ GF_MULT(8'h03,tmp_var[(k+1)%4]) ^ tmp_var[(k+2)%4] ^ tmp_var[(k+3)%4];
      end
    end
  endfunction : MixColumns

  function void InvMixColumns();
    bit  [7:0] tmp_var[4];
    for(int j=0; j<4; j=j+1)
    begin
      tmp_var     = '{ state[0][j], state[1][j], state[2][j], state[3][j]};
      for(int k=0; k<4; k=k+1)
      begin
        state[k][j] = GF_MULT(8'h0E,tmp_var[k]) ^ GF_MULT(8'h0B,tmp_var[(k+1)%4]) ^ GF_MULT(8'h0D,tmp_var[(k+2)%4]) ^ GF_MULT(8'h09,tmp_var[(k+3)%4]);
      end
    end
  endfunction : InvMixColumns

  function void AddRoundKey(int round);
    bit [7:0] tmp_var[4];
    for(int j=0; j<Nb; j=j+1)
    begin
      tmp_var     = '{ state[0][j], state[1][j], state[2][j], state[3][j]};
      state[0][j] = tmp_var[0] ^ w[round*4 + j][ 7: 0];
      state[1][j] = tmp_var[1] ^ w[round*4 + j][15: 8];
      state[2][j] = tmp_var[2] ^ w[round*4 + j][23:16];
      state[3][j] = tmp_var[3] ^ w[round*4 + j][31:24];
    end
  endfunction : AddRoundKey

  function void KeyExpansion();
    bit [31:0] tmp_var;

    w    = new[Nb*(Nr+1)];
    Rcon = new[Nr+1];

    // GF[p**8] for Rcon
    Rcon[0] = 32'h0;
    for(int i=1; i<$size(Rcon); i=i+1)
    begin
      Rcon[i]      = 32'h0;
      tmp_var      = (2)**(i-1);
      Rcon[i][7:0] = GF_11B(tmp_var);
    end

    foreach(w[i])
    begin
      if(i<Nk)
      begin
        w[i] = {Key[i*4+3],Key[i*4+2],Key[i*4+1],Key[i*4+0]};
      end
      else
      begin
        tmp_var = w[i-1];
        if(i%Nk == 0)
        begin
          tmp_var = SubWord(RotWord(tmp_var)) ^ Rcon[i/Nk];
        end
        else if((Nk > 6) && (i%Nk == 4))
        begin
          tmp_var = SubWord(tmp_var);
        end
        w[i] = w[i-Nk] ^ tmp_var;
      end
    end
  endfunction : KeyExpansion

  function void testAESKeyExpanded();
    bit [7:0] Key128[16];
    bit [7:0] Key256[32];

    // AES-128
    foreach(Key128[i])
      Key128[i] = AES_K128[i*8 +: 8];

    gen_Key(Key128,1);
    KeyExpansion();
    foreach(w[i])
    begin
      if(w[i][31:0] != {AES_W128[i][24:31],AES_W128[i][16:23],AES_W128[i][8:15],AES_W128[i][0:7]})
      begin
        $display("w[%02d][31:0] (%08h) differs from AES_W128[%02d][31:0] (%08h)",
           i,w[i][31:0],
           i,{AES_W128[i][24:31],AES_W128[i][16:23],AES_W128[i][8:15],AES_W128[i][0:7]});
        aes_err_cnt = aes_err_cnt + 1;
      end
    end

    // AES-256
    foreach(Key256[i])
      Key256[i] = AES_K256[i*8 +: 8];

    gen_Key(Key256,1);
    KeyExpansion();
    foreach(w[i])
    begin
      if(w[i][31:0] != {AES_W256[i][24:31],AES_W256[i][16:23],AES_W256[i][8:15],AES_W256[i][0:7]})
      begin
        $display("w[%02d][31:0] (%08h) differs from AES_W256[%02d][31:0] (%08h)",
           i,w[i][31:0],
           i,{AES_W256[i][24:31],AES_W256[i][16:23],AES_W256[i][8:15],AES_W256[i][0:7]});
        aes_err_cnt = aes_err_cnt + 1;
      end
    end
  endfunction : testAESKeyExpanded

  function void aes_encrypt();
    enc_data.delete();
    KeyExpansion();
    gen_state_queue(plain_data);
    foreach(state_queue[i])
    begin
      get_state(i);
//      display_state("get state");
      AddRoundKey(0);
//      display_state("add round key 0");
      for(int j=1; j<Nr; j=j+1)
      begin
        SubBytes();
//        display_state("SubBytes");
        ShiftRows();
//        display_state("ShiftRows");
        MixColumns();
//        display_state("MixColumns");
        AddRoundKey(j);
//        display_state("AddRoundKey j");
      end
      SubBytes();
//      display_state("SubBytes");
      ShiftRows();
//      display_state("ShiftRows");
      AddRoundKey(Nr);
//      display_state("AddRoundKey Nr");
      get_state_out(enc_data);
    end
  endfunction : aes_encrypt

  function void aes_decrypt();
    dec_data.delete();
    KeyExpansion();
    gen_state_queue(enc_data);
    foreach(state_queue[i])
    begin
      get_state(i);
//      display_state("get state");
      AddRoundKey(Nr);
//      display_state("add round key Nr");
      for(int j=Nr-1; j>=1; j=j-1)
      begin
        InvShiftRows();
//        display_state("InvShiftRows");
        InvSubBytes();
//        display_state("InvSubBytes");
        AddRoundKey(j);
//        display_state("AddRoundKey j");
        InvMixColumns();
//        display_state("InvMixColumns");
      end
      InvShiftRows();
//      display_state("InvShiftRows");
      InvSubBytes();
//      display_state("InvSubBytes");
      AddRoundKey(0);
//      display_state("AddRoundKey Nr");
      get_state_out(dec_data);
    end
  endfunction : aes_decrypt

  function void test_aes_encrypt();
    gen_Key(AES_ENC_KEY,1);
    plain_data = new[$size(AES_ENC_PLAIN_DATA)](AES_ENC_PLAIN_DATA);
    aes_encrypt();
    if(enc_data.size() != $size(AES_ENC_ENC_DATA))
    begin
      $display("enc_data.size() %0d differs from $size(AES_ENC_ENC_DATA) %0d",enc_data.size(),$size(AES_ENC_ENC_DATA));
      aes_err_cnt = aes_err_cnt + 1;
    end
    else
    begin
      foreach(enc_data[i])
      begin
        if(enc_data[i] != AES_ENC_ENC_DATA[i])
        begin
          $display("enc_data[%02h] (%02h) != AES_ENC_ENC_DATA[%02h] (%02h)",i,enc_data[i],i,AES_ENC_ENC_DATA[i]);
          aes_err_cnt = aes_err_cnt + 1;
        end
      end
    end

    gen_Key(AES_KEY128,1);
    plain_data = new[$size(AES_PLAINTEXT128)](AES_PLAINTEXT128);
    aes_encrypt();
    if(enc_data.size() != $size(AES_CIPHER128))
    begin
      $display("enc_data.size() %0d differs from $size(AES_CIPHER128) %0d",enc_data.size(),$size(AES_CIPHER128));
      aes_err_cnt = aes_err_cnt + 1;
    end
    else
    begin
      foreach(enc_data[i])
      begin
        if(enc_data[i] != AES_CIPHER128[i])
        begin
          $display("enc_data[%02h] (%02h) != AES_CIPHER128[%02h] (%02h)",i,enc_data[i],i,AES_CIPHER128[i]);
          aes_err_cnt = aes_err_cnt + 1;
        end
      end
    end

    gen_Key(AES_KEY256,1);
    plain_data = new[$size(AES_PLAINTEXT256)](AES_PLAINTEXT256);
    aes_encrypt();
    if(enc_data.size() != $size(AES_CIPHER256))
    begin
      $display("enc_data.size() %0d differs from $size(AES_CIPHER256) %0d",enc_data.size(),$size(AES_CIPHER256));
      aes_err_cnt = aes_err_cnt + 1;
    end
    else
    begin
      foreach(enc_data[i])
      begin
        if(enc_data[i] != AES_CIPHER256[i])
        begin
          $display("enc_data[%02h] (%02h) != AES_CIPHER256[%02h] (%02h)",i,enc_data[i],i,AES_CIPHER256[i]);
          aes_err_cnt = aes_err_cnt + 1;
        end
      end
    end
  endfunction : test_aes_encrypt

  function void test_aes_decrypt();
    gen_Key(AES_ENC_KEY,1);
    enc_data = new[$size(AES_ENC_ENC_DATA)](AES_ENC_ENC_DATA);
    aes_decrypt();
    if(dec_data.size() != $size(AES_ENC_PLAIN_DATA))
    begin
      $display("dec_data.size() %0d differs from $size(AES_ENC_PLAIN_DATA) %0d",dec_data.size(),$size(AES_ENC_PLAIN_DATA));
      aes_err_cnt = aes_err_cnt + 1;
    end
    else
    begin
      foreach(dec_data[i])
      begin
        if(dec_data[i] != AES_ENC_PLAIN_DATA[i])
        begin
          $display("dec_data[%02h] (%02h) != AES_ENC_PLAIN_DATA[%02h] (%02h)",i,enc_data[i],i,AES_ENC_PLAIN_DATA[i]);
          aes_err_cnt = aes_err_cnt + 1;
        end
      end
    end

    gen_Key(AES_KEY128,1);
    enc_data   = new[$size(AES_CIPHER128)](AES_CIPHER128);
    aes_decrypt();
    if(dec_data.size() != $size(AES_PLAINTEXT128))
    begin
      $display("dec_data.size() %0d differs from $size(AES_PLAINTEXT128) %0d",dec_data.size(),$size(AES_PLAINTEXT128));
      aes_err_cnt = aes_err_cnt + 1;
    end
    else
    begin
      foreach(dec_data[i])
      begin
        if(dec_data[i] != AES_PLAINTEXT128[i])
        begin
          $display("dec_data[%02h] (%02h) != AES_PLAINTEXT128[%02h] (%02h)",i,dec_data[i],i,AES_PLAINTEXT128[i]);
          aes_err_cnt = aes_err_cnt + 1;
        end
      end
    end

    gen_Key(AES_KEY256,1);
    enc_data   = new[$size(AES_CIPHER256)](AES_CIPHER256);
    aes_decrypt();
    if(dec_data.size() != $size(AES_PLAINTEXT256))
    begin
      $display("dec_data.size() %0d differs from $size(AES_PLAINTEXT256) %0d",dec_data.size(),$size(AES_PLAINTEXT256));
      aes_err_cnt = aes_err_cnt + 1;
    end
    else
    begin
      foreach(dec_data[i])
      begin
        if(dec_data[i] != AES_PLAINTEXT256[i])
        begin
          $display("dec_data[%02h] (%02h) != AES_PLAINTEXT256[%02h] (%02h)",i,dec_data[i],i,AES_PLAINTEXT256[i]);
          aes_err_cnt = aes_err_cnt + 1;
        end
      end
    end
  endfunction : test_aes_decrypt
endclass : aes
