////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//------------------------------------------------------------------------------
// $RCSmodulefile   :
// $Author          :
// Company          : RivieraWaves
//------------------------------------------------------------------------------
// $Revision:$
// $Date:$
// $State: Complete
// $Locker:
// -----------------------------------------------------------------------------
// Dependencies     :
// Description      : GCMP Class For TB
//
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// -----------------------------------------------------------------------------
//
//
//
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

// IEEE 802.11-2016 GCMP test mpdu #1 ====
bit [7:0] IEEE_GCMP_PLAIN_DATA_1[256] = '{8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00};

bit [7:0] IEEE_GCMP_KEY_1[16]         = '{8'hAA,8'hAA,8'hAA,8'hAA,
                                          8'hAA,8'hAA,8'hAA,8'hAA,
                                          8'hAA,8'hAA,8'hAA,8'hAA,
                                          8'hAA,8'hAA,8'hAA,8'hAA};

bit [7:0] IEEE_GCMP_AAD_1[22]         = '{8'h20,8'h02,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h00,
                                          8'hFF,8'hFF,8'hFF,8'hFF,
                                          8'hFF,8'hFF,8'hFF,8'hFF,
                                          8'hFF,8'hFF,8'hFF,8'hFF,
                                          8'h00,8'h00};

bit [7:0] IEEE_GCMP_NONCE_1[12]       = '{8'hFF,8'hFF,8'hFF,8'hFF,
                                          8'hFF,8'hFF,8'h00,8'h00,
                                          8'h00,8'h00,8'h00,8'h01};

bit [7:0] IEEE_GCMP_CIPHER_1[256]     = '{8'h5F,8'h55,8'h78,8'hC1,
                                          8'h8F,8'h13,8'h7A,8'hD2,
                                          8'h79,8'hBF,8'h3F,8'h2B,
                                          8'h24,8'hC7,8'hBD,8'h8F,
                                          8'h27,8'h7A,8'h1B,8'hE6,
                                          8'h77,8'h0D,8'hA1,8'hD9,
                                          8'h8B,8'h70,8'hC6,8'hD2,
                                          8'h8A,8'hE0,8'h1C,8'h55,
                                          8'h9E,8'hCB,8'hA6,8'hA0,
                                          8'h1D,8'hB0,8'h67,8'hC5,
                                          8'hA2,8'h7E,8'h4D,8'hB0,
                                          8'h8C,8'hDA,8'hDC,8'h77,
                                          8'h52,8'hAD,8'h63,8'h7E,
                                          8'hAF,8'h0A,8'h18,8'hED,
                                          8'h13,8'hFB,8'hAA,8'h14,
                                          8'h3B,8'hAF,8'hEF,8'h18,
                                          8'hF8,8'hFB,8'hCE,8'h4C,
                                          8'h65,8'hE8,8'h6B,8'hD0,
                                          8'h2A,8'h87,8'hB6,8'h01,
                                          8'hB7,8'hEA,8'hB9,8'h3F,
                                          8'h2B,8'hBC,8'h87,8'h4C,
                                          8'h8A,8'h71,8'h05,8'h80,
                                          8'hF5,8'h02,8'h34,8'h1A,
                                          8'h6A,8'h53,8'h39,8'h31,
                                          8'h43,8'hDE,8'h4C,8'h9E,
                                          8'hC6,8'hA2,8'h86,8'hF1,
                                          8'h25,8'h71,8'h83,8'h78,
                                          8'hAE,8'hDC,8'h84,8'hEB,
                                          8'hA2,8'hB3,8'h0F,8'h5C,
                                          8'h28,8'hBB,8'h5D,8'h75,
                                          8'hC6,8'hB0,8'h25,8'h46,
                                          8'h6D,8'h06,8'h51,8'hC7,
                                          8'h22,8'hDC,8'h71,8'h15,
                                          8'h1F,8'h21,8'h2D,8'h68,
                                          8'h87,8'h82,8'h8A,8'h03,
                                          8'h82,8'hE9,8'h28,8'h8A,
                                          8'h7F,8'h43,8'hD5,8'h2B,
                                          8'h7D,8'h25,8'h08,8'h61,
                                          8'h57,8'h64,8'h69,8'h54,
                                          8'hBB,8'h43,8'hB5,8'h7E,
                                          8'hA5,8'h87,8'hA0,8'h25,
                                          8'hF4,8'h0C,8'hE7,8'h45,
                                          8'h11,8'hE4,8'hDD,8'h22,
                                          8'h85,8'hB4,8'h0B,8'hA3,
                                          8'hF3,8'hB9,8'h62,8'h62,
                                          8'hCB,8'hC2,8'h8C,8'h6A,
                                          8'hA7,8'hBE,8'h44,8'h3E,
                                          8'h7B,8'h41,8'hE1,8'hEB,
                                          8'hFF,8'h52,8'h48,8'h57,
                                          8'hA6,8'h81,8'h68,8'h97,
                                          8'h75,8'h01,8'h15,8'hB0,
                                          8'h23,8'h1A,8'hB7,8'hC2,
                                          8'h84,8'h72,8'hC0,8'h6D,
                                          8'hD0,8'hB4,8'h9B,8'hE9,
                                          8'hF3,8'h69,8'hA8,8'hC3,
                                          8'h9C,8'hCD,8'h0D,8'hB7,
                                          8'h98,8'h35,8'h10,8'hE1,
                                          8'hAE,8'h8F,8'h05,8'hD7,
                                          8'h75,8'h45,8'hE0,8'h23,
                                          8'h5C,8'hDB,8'hD6,8'h12,
                                          8'hF3,8'h15,8'h07,8'h54,
                                          8'hCE,8'hE5,8'hCE,8'h6A,
                                          8'h12,8'h25,8'hD9,8'h95,
                                          8'h25,8'h02,8'h6F,8'h74};

bit [7:0] IEEE_GCMP_MIC_1[16]         = '{8'h80,8'hCB,8'h06,8'h62,
                                          8'hEA,8'h71,8'hAB,8'hFD,
                                          8'h9F,8'h04,8'hC7,8'hF8,
                                          8'h72,8'hF5,8'h80,8'h90};

// IEEE 802.11-2016 GCMP test mpdu #2 ====
bit [7:0] IEEE_GCMP_KEY_2[16]         = '{8'hc9,8'h7c,8'h1f,8'h67,
                                          8'hce,8'h37,8'h11,8'h85,
                                          8'h51,8'h4a,8'h8a,8'h19,
                                          8'hf2,8'hbd,8'hd5,8'h2f};

bit  [7:0] IEEE_GCMP_PN_2[6]          = '{8'h08,8'h2B,8'h5F,8'h5F,
                                          8'h89,8'h00};

bit  [7:0] IEEE_GCMP_MAC_HEADER_2[26] = '{8'h88,8'h48,8'h0b,8'h00,
                                          8'h0f,8'hd2,8'he1,8'h28,
                                          8'ha5,8'h7c,8'h50,8'h30,
                                          8'hf1,8'h84,8'h44,8'h08,
                                          8'h50,8'h30,8'hf1,8'h84,
                                          8'h44,8'h08,8'h80,8'h33,
                                          8'h03,8'h00};

bit [7:0] IEEE_GCMP_HEADER_2[8]       = '{8'h08,8'h2b,8'h00,8'h20,
                                          8'h5f,8'h5f,8'h89,8'h00};

bit [7:0] IEEE_GCMP_NONCE_2[12]       = '{8'h50,8'h30,8'hf1,8'h84,
                                          8'h44,8'h08,8'h00,8'h89,
                                          8'h5f,8'h5f,8'h2b,8'h08};

bit [7:0] IEEE_GCMP_PLAIN_DATA_2[40]  = '{8'h00,8'h01,8'h02,8'h03,
                                          8'h04,8'h05,8'h06,8'h07,
                                          8'h08,8'h09,8'h0a,8'h0b,
                                          8'h0c,8'h0d,8'h0e,8'h0f,
                                          8'h10,8'h11,8'h12,8'h13,
                                          8'h14,8'h15,8'h16,8'h17,
                                          8'h18,8'h19,8'h1a,8'h1b,
                                          8'h1c,8'h1d,8'h1e,8'h1f,
                                          8'h20,8'h21,8'h22,8'h23,
                                          8'h24,8'h25,8'h26,8'h27};

bit [7:0] IEEE_GCMP_CIPHER_2[40]      = '{8'h60,8'he9,8'h70,8'h0c,
                                          8'hc4,8'hd4,8'h0a,8'hc6,
                                          8'hd2,8'h88,8'hb2,8'h01,
                                          8'hc3,8'h8f,8'h5b,8'hf0,
                                          8'h8b,8'h80,8'h74,8'h42,
                                          8'h64,8'h0a,8'h15,8'h96,
                                          8'he5,8'hdb,8'hda,8'hd4,
                                          8'h1d,8'h1f,8'h36,8'h23,
                                          8'hf4,8'h5d,8'h7a,8'h12,
                                          8'hdb,8'h7a,8'hfb,8'h23};

bit [7:0] IEEE_GCMP_MIC_2[16]         = '{8'hde,8'hf6,8'h19,8'hc2,
                                          8'ha3,8'h74,8'hb6,8'hdf,
                                          8'h66,8'hff,8'ha5,8'h3b,
                                          8'h6c,8'h69,8'hd7,8'h9e};

bit [7:0] IEEE_GCMP_CIPHER_MIC_2[56]  = '{8'h60,8'he9,8'h70,8'h0c,
                                          8'hc4,8'hd4,8'h0a,8'hc6,
                                          8'hd2,8'h88,8'hb2,8'h01,
                                          8'hc3,8'h8f,8'h5b,8'hf0,
                                          8'h8b,8'h80,8'h74,8'h42,
                                          8'h64,8'h0a,8'h15,8'h96,
                                          8'he5,8'hdb,8'hda,8'hd4,
                                          8'h1d,8'h1f,8'h36,8'h23,
                                          8'hf4,8'h5d,8'h7a,8'h12,
                                          8'hdb,8'h7a,8'hfb,8'h23,
                                          8'hde,8'hf6,8'h19,8'hc2,
                                          8'ha3,8'h74,8'hb6,8'hdf,
                                          8'h66,8'hff,8'ha5,8'h3b,
                                          8'h6c,8'h69,8'hd7,8'h9e};

// IEEE 802.11-2016 GCMP-256 test mpdu #3 =====
bit [7:0] IEEE_GCMP_KEY_3[32]         = '{8'hc9,8'h7c,8'h1f,8'h67,
                                          8'hce,8'h37,8'h11,8'h85,
                                          8'h51,8'h4a,8'h8a,8'h19,
                                          8'hf2,8'hbd,8'hd5,8'h2f,
                                          8'h00,8'h01,8'h02,8'h03,
                                          8'h04,8'h05,8'h06,8'h07,
                                          8'h08,8'h09,8'h0a,8'h0b,
                                          8'h0c,8'h0d,8'h0e,8'h0f};

bit [7:0] IEEE_GCMP_PN_3[6]           = '{8'h08,8'h2b,8'h5f,8'h5f,
                                          8'h89,8'h00};

bit [7:0] IEEE_GCMP_MAC_HEADER_3[26]  = '{8'h88,8'h48,8'h0b,8'h00,
                                          8'h0f,8'hd2,8'he1,8'h28,
                                          8'ha5,8'h7c,8'h50,8'h30,
                                          8'hf1,8'h84,8'h44,8'h08,
                                          8'h50,8'h30,8'hf1,8'h84,
                                          8'h44,8'h08,8'h80,8'h33,
                                          8'h03,8'h00};

bit [7:0] IEEE_GCMP_AAD_3[24]         = '{8'h88,8'h40,8'h0f,8'hd2,
                                          8'he1,8'h28,8'ha5,8'h7c,
                                          8'h50,8'h30,8'hf1,8'h84,
                                          8'h44,8'h08,8'h50,8'h30,
                                          8'hf1,8'h84,8'h44,8'h08,
                                          8'h00,8'h00,8'h03,8'h00};

bit [7:0] IEEE_GCMP_NONCE_3[12]       = '{8'h50,8'h30,8'hf1,8'h84,
                                          8'h44,8'h08,8'h00,8'h89,
                                          8'h5f,8'h5f,8'h2b,8'h08};

bit [7:0] IEEE_GCMP_PLAIN_DATA_3[40]  = '{8'h00,8'h01,8'h02,8'h03,
                                          8'h04,8'h05,8'h06,8'h07,
                                          8'h08,8'h09,8'h0a,8'h0b,
                                          8'h0c,8'h0d,8'h0e,8'h0f,
                                          8'h10,8'h11,8'h12,8'h13,
                                          8'h14,8'h15,8'h16,8'h17,
                                          8'h18,8'h19,8'h1a,8'h1b,
                                          8'h1c,8'h1d,8'h1e,8'h1f,
                                          8'h20,8'h21,8'h22,8'h23,
                                          8'h24,8'h25,8'h26,8'h27};

bit [7:0] IEEE_GCMP_MIC_3[16]         = '{8'h11,8'h43,8'h16,8'h85,
                                          8'h90,8'h95,8'h47,8'h3d,
                                          8'h5b,8'h1b,8'hd5,8'h96,
                                          8'hb3,8'hde,8'ha3,8'hbf};

bit [7:0] IEEE_GCMP_CIPHER_3[40]      = '{8'h65,8'h83,8'h43,8'hc8,
                                          8'hb1,8'h44,8'h47,8'hd9,
                                          8'h21,8'h1d,8'hef,8'hd4,
                                          8'h6a,8'hd8,8'h9c,8'h71,
                                          8'h0c,8'h6f,8'hc3,8'h33,
                                          8'h33,8'h23,8'h6e,8'h39,
                                          8'h97,8'hb9,8'h17,8'h6a,
                                          8'h5a,8'h8b,8'he7,8'h79,
                                          8'hb2,8'h12,8'h66,8'h55,
                                          8'h5e,8'h70,8'had,8'h79};

bit [7:0] IEEE_GCMP_CIPHER_MIC_3[56]  = '{8'h65,8'h83,8'h43,8'hc8,
                                          8'hb1,8'h44,8'h47,8'hd9,
                                          8'h21,8'h1d,8'hef,8'hd4,
                                          8'h6a,8'hd8,8'h9c,8'h71,
                                          8'h0c,8'h6f,8'hc3,8'h33,
                                          8'h33,8'h23,8'h6e,8'h39,
                                          8'h97,8'hb9,8'h17,8'h6a,
                                          8'h5a,8'h8b,8'he7,8'h79,
                                          8'hb2,8'h12,8'h66,8'h55,
                                          8'h5e,8'h70,8'had,8'h79,
                                          8'h11,8'h43,8'h16,8'h85,
                                          8'h90,8'h95,8'h47,8'h3d,
                                          8'h5b,8'h1b,8'hd5,8'h96,
                                          8'hb3,8'hde,8'ha3,8'hbf};

//------------------------------------------------------------------------------
class gcmp;
  aes aes_obj;

  bit  [7:0] PN[6];

  bit  [7:0] Key[];
  bit  [7:0] AAD[];
  bit  [7:0] GCMnonce[12];

  bit  [7:0] macheader[];
  bit  [7:0] plain_data[];
  bit  [7:0] enc_data[];
  bit  [7:0] full_enc_data[];
  bit  [7:0] dec_data[];

  bit  [7:0] CB[16];
  bit  [7:0] H[16];
  bit  [7:0] S[16];
  bit  [7:0] S_i[16];

  bit  [7:0] B_mic[];
  bit  [7:0] Mic_in[16];
  bit  [7:0] Mic_out[16];
  bit  [7:0] MIC[16];
  bit  [7:0] GCMPHeader[8];

  bit        htMode       = 0;
  bit        sspCapable   = 0;

  int        gcmp_err_cnt = 0;

  //----------------------------------------------------------------------------
  function new();
    aes_obj = new();
  endfunction : new

  //----------------------------------------------------------------------------
  function void gen_plain_data(
    input bit [7:0] plain_data_in[] = {},
    input bit       valid           = 1'b0,
    input bit       debug_en        = 1'b0
  );

    int plain_data_length = $urandom_range(1024,1);
    if(valid && (plain_data_in.size() != 0))
    begin
      plain_data = new[plain_data_in.size()](plain_data_in);
    end
    else
    begin
      plain_data = new[plain_data_length];
      foreach(plain_data[i])
        plain_data[i] = $urandom_range(255,0);
    end

    if(debug_en)
    begin
      for(int i=0; i<plain_data.size();i=i+4)
      begin
        $display("%02h%02h%02h%02h",plain_data[i+3],plain_data[i+2],
                                    plain_data[i+1],plain_data[i]);
      end
    end

  endfunction : gen_plain_data

  //----------------------------------------------------------------------------
  function void gen_PN(
    input bit [7:0] PN_in[6] = {8'h0,8'h0,8'h0,8'h0,8'h0,8'h0},
    input bit       valid    = 1'b0
  );

    foreach(PN[i])
    begin
      PN[i] = valid ? PN_in[i] : $urandom_range(255,0);
    end
  endfunction : gen_PN

  //----------------------------------------------------------------------------
  function void gen_GCMPHeader(
    input bit [7:0] GCMPHeader_in[8] = {8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0},
    input bit       valid            = 1'b0
  );

    if(valid)
    begin
      foreach(GCMPHeader[i])
      begin
        GCMPHeader[i] = GCMPHeader_in[i];
      end
    end
    else
    begin
      GCMPHeader[0] = PN[0];
      GCMPHeader[1] = PN[1];
      GCMPHeader[2] = 8'h00;
      GCMPHeader[3] = {$urandom_range(3,0),1'b1,5'h00};
      GCMPHeader[4] = PN[2];
      GCMPHeader[5] = PN[3];
      GCMPHeader[6] = PN[4];
      GCMPHeader[7] = PN[5];
    end
  endfunction : gen_GCMPHeader

  //----------------------------------------------------------------------------
  function void gen_Key(
    input bit [7:0] Key_in[] = {},
    input bit       valid    = 1'b0,
    input bit       key_size = 1'b0  // 0: 128Bits, 1: 256Bits
   );
    if (valid & Key_in.size==32 | ~valid & key_size==1)
      // GCMP-256
      Key = new[32];
    else
      // GCMP-128
      Key = new[16];

    foreach(Key[i])
    begin
      Key[i] = valid ? Key_in[i] : $urandom_range(255,0);
    end
  endfunction : gen_Key

  //----------------------------------------------------------------------------
  function void gen_macheader(
    input bit [7:0] macheader_in[] = {},
    input bit       valid          = 1'b0,
    input bit       forced_add4    = 1'b0,
    input bit       forced_qos     = 1'b0
  );

    if(valid && macheader_in.size() >= 24)
    begin
      macheader =new[macheader_in.size()](macheader_in);
    end
    else
    begin
      macheader = new[24];
      foreach(macheader[i])
      begin
        macheader[i] = $urandom_range(255,0);
      end
      macheader[0][2] = 1'b0; // Force Management or Data Frame

      macheader[1][6] = 1'b1;
      if(forced_add4)
      begin
        macheader[1][1:0] = 2'b11;
        macheader[0][3:2] = 2'b10;
      end

      if(forced_qos)
      begin
        macheader[0][7]   = 1'b1;
        macheader[0][6:4] = $urandom_range(7,0);
        macheader[0][3:2] = 2'b10;
      end

      if(macheader[1][3:2] == 2'b00)
      begin
        macheader[1][7]   = 1'b0;
        macheader[1][1:0] = 2'b01;
      end

      if(macheader[0][3:2] == 2'b10 &
         macheader[1][1:0] == 2'b11)
      begin
        macheader = new[macheader.size()+6](macheader);
        for(int i=macheader.size()-6; i<macheader.size(); i=i+1)
          macheader[i] = $urandom_range(255,0);
      end

      if(macheader[0][3:2] == 2'b10  &
         macheader[0][7]             &
         macheader[0][7:4] != 4'b1101)
      begin
        macheader = new[macheader.size()+2](macheader);
        for(int i=macheader.size()-2; i<macheader.size(); i=i+1)
          macheader[i] = $urandom_range(255,0);
      end
      macheader[1][6] = 1'b1;
      //$display("gen_macheader : FC = %h %h", macheader[0],macheader[1]);
    end
  endfunction : gen_macheader

  //----------------------------------------------------------------------------
  function void gen_full_enc_data();

    bit [31:0] temp_crc;
    full_enc_data.delete();

    foreach(macheader[i])
    begin
      full_enc_data = new[full_enc_data.size() + 1](full_enc_data);
      full_enc_data[full_enc_data.size() - 1] = macheader[i];
    end

    foreach(GCMPHeader[i])
    begin
      full_enc_data = new[full_enc_data.size() + 1](full_enc_data);
      full_enc_data[full_enc_data.size() - 1] = GCMPHeader[i];
    end

    foreach(enc_data[i])
    begin
      full_enc_data = new[full_enc_data.size() + 1](full_enc_data);
      full_enc_data[full_enc_data.size() - 1] = enc_data[i];
    end

    foreach(MIC[i])
    begin
      full_enc_data = new[full_enc_data.size() + 1](full_enc_data);
      full_enc_data[full_enc_data.size() - 1] = MIC[i];
    end

    FCS_calc(full_enc_data,temp_crc,1);
  endfunction : gen_full_enc_data

  //----------------------------------------------------------------------------
  // G(x) = x32 + x26 + x23 + x22 + x16 + x12 + x11 + x10 + x8 + x7 + x5 + x4 + x2 + x + 1
  function void FCS_calc(
    inout  bit  [7:0] data2crc[],
    output bit [31:0] crc_out,
    input  bit        append_crc = 1'b0
  );

    bit        lfsr_in;
    bit [31:0] crc_result = 32'hFFFF_FFFF;

    for(int i = 0; i<data2crc.size(); i=i+1)
    begin
      for(int g=0; g<8; g=g+1)
      begin
        lfsr_in             =  crc_result[31] ^ data2crc[i][g];
        crc_result[31]      =  crc_result[30];
        crc_result[30]      =  crc_result[29];
        crc_result[29]      =  crc_result[28];
        crc_result[28]      =  crc_result[27];
        crc_result[27]      =  crc_result[26];
        crc_result[26]      =  crc_result[25] ^ lfsr_in;
        crc_result[25]      =  crc_result[24];
        crc_result[24]      =  crc_result[23];
        crc_result[23]      =  crc_result[22] ^ lfsr_in;
        crc_result[22]      =  crc_result[21] ^ lfsr_in;
        crc_result[21]      =  crc_result[20];
        crc_result[20]      =  crc_result[19];
        crc_result[19]      =  crc_result[18];
        crc_result[18]      =  crc_result[17];
        crc_result[17]      =  crc_result[16];
        crc_result[16]      =  crc_result[15] ^ lfsr_in;
        crc_result[15]      =  crc_result[14];
        crc_result[14]      =  crc_result[13];
        crc_result[13]      =  crc_result[12];
        crc_result[12]      =  crc_result[11] ^ lfsr_in;
        crc_result[11]      =  crc_result[10] ^ lfsr_in;
        crc_result[10]      =  crc_result[9]  ^ lfsr_in;
        crc_result[9]       =  crc_result[8];
        crc_result[8]       =  crc_result[7]  ^ lfsr_in;
        crc_result[7]       =  crc_result[6]  ^ lfsr_in;
        crc_result[6]       =  crc_result[5];
        crc_result[5]       =  crc_result[4]  ^ lfsr_in;
        crc_result[4]       =  crc_result[3]  ^ lfsr_in;
        crc_result[3]       =  crc_result[2];
        crc_result[2]       =  crc_result[1]  ^ lfsr_in;
        crc_result[1]       =  crc_result[0]  ^ lfsr_in;
        crc_result[0]       =                   lfsr_in;
      end
    end

    crc_result[31:0] = ~crc_result[31:0];

    for(int i=0;i<32;i=i+1)
    begin
      if(i<8)
        crc_out[7-i]     = crc_result[i];
      else if(i<16)
        crc_out[15-i+8]  = crc_result[i];
      else if(i<24)
        crc_out[23-i+16] = crc_result[i];
      else
        crc_out[31-i+24] = crc_result[i];
    end

    if(append_crc)
    begin
      data2crc = new[data2crc.size() + 4](data2crc);
      data2crc[data2crc.size()-4] = crc_out[31:24];
      data2crc[data2crc.size()-3] = crc_out[23:16];
      data2crc[data2crc.size()-2] = crc_out[15:8];
      data2crc[data2crc.size()-1] = crc_out[7:0];
    end
  endfunction : FCS_calc

  //----------------------------------------------------------------------------
  function void ConstructAAD();

    AAD.delete();
    AAD = new[22];

    if (macheader[0][3:2] == 2)
      // In case of Data Frame, mask bits 4, 5 & 6
      AAD[0] =  macheader[0] & 8'h8F; // bit 4 5 6 = 0;
    else
      AAD[0] =  macheader[0];

    AAD[1] = (macheader[1] | 8'h40) & 8'hC7; // bit 11 12 13 = 0; bit 14 = 1;

    for(int i=2; i<(6*3)+2; i=i+1)
      AAD[i] = macheader[i+2];

    AAD[20] = macheader[22] & 8'h0F; // bit 4-7 = 0
    AAD[21] = 8'h00; // bit 8-15 = 0

    if(macheader[1][1:0] == 2'b11 &&
       macheader[0][3:2] == 2'b10   )
    begin
      AAD = new[AAD.size()+6](AAD);
      AAD[AAD.size()-6] = macheader[24];
      AAD[AAD.size()-5] = macheader[25];
      AAD[AAD.size()-4] = macheader[26];
      AAD[AAD.size()-3] = macheader[27];
      AAD[AAD.size()-2] = macheader[28];
      AAD[AAD.size()-1] = macheader[29];
      //$display("AAD with ADDR4");
    end

    if(macheader[0][7]   == 1'b1    &&
       macheader[0][7:4] != 4'b1101 &&
       macheader[0][3:2] == 2'b10   )
    begin
      AAD = new[AAD.size()+2](AAD);
      AAD[AAD.size()-2] = macheader[macheader.size()-2] & 8'h0F;
      AAD[AAD.size()-1] = 8'h00;
      //$display("AAD with QoS");

      // HT Patching
      if(htMode)
      begin
        AAD[1][7] = 0; // FC 15 mask to 0 with QoS frame
        if(sspCapable)
        begin
          AAD[AAD.size()-2][7] = macheader[macheader.size()-2][7]; // QoS 7 unmask (A-MSDU)
        end
      end
    end

    //foreach(AAD[i])
    //begin
    //  $display("AAD[%0d]=%h",i,AAD[i]);
    //end

  endfunction : ConstructAAD

  //----------------------------------------------------------------------------
  function void ConstructGCMnonce();

    for(int i=0; i<6; i=i+1)
      GCMnonce[i] = macheader[i + 4 + 6];

    for(int i=6; i<12; i=i+1)
       GCMnonce[i] = PN[5-(i-6)];

    //foreach(GCMnonce[i])
    //begin
    //  $display("GCMnonce[%0d]=%h",i,GCMnonce[i]);
    //end

  endfunction : ConstructGCMnonce

  //----------------------------------------------------------------------------
  function void multH(
    input  bit [7:0] in[16],
    output bit [7:0] out[16]
  );

    bit [127:0] R;
    bit [127:0] X;
    bit [127:0] Z;
    bit [127:0] V;

    R={8'he1,120'h0};
    foreach(in[i]) X[8*i+:8]=in[15-i];
    foreach(H[i])  V[8*i+:8]=H[15-i];
    Z=128'h0;

    for (int i=0;i<128;i=i+1)
    begin
      if (X[127-i]==1'b1) Z=Z^V;

      if (V[0]==1'b0) V={1'b0,V[127:1]};
      else            V={1'b0,V[127:1]}^R;

    end

    foreach(out[i]) out[15-i]=Z[8*i+:8];

  endfunction : multH

  //----------------------------------------------------------------------------
  function void GCMP_MIC(
    input bit [7:0] Nonce_in[],
    input bit [7:0] Message_in[],
    input bit [7:0] Adata_in[] = {},
    input bit       debug_en   = 1'b0
  );

    bit [7:0] mult_in[16];

    // Create the new B-mic array
    B_mic.delete();

    // AAD
    for (int i=0; i<Adata_in.size(); i=i+1)
    begin
      B_mic = new[B_mic.size() + 1](B_mic);
      B_mic[B_mic.size() - 1] = Adata_in[i];
    end

    // AAD Padding with '0'
    while(B_mic.size()%16)
    begin
      B_mic = new[B_mic.size() + 1](B_mic);
      B_mic[B_mic.size() - 1] = 8'h0;
    end

    // Append the message
    if(Message_in.size())
    begin
      for(int i=0; i<Message_in.size(); i=i+1)
      begin
        B_mic = new[B_mic.size() + 1](B_mic);
        B_mic[B_mic.size() - 1] = Message_in[i];
      end

      // Pad with 0 if the length is not modulo 16
      while(B_mic.size()%16)
      begin
        B_mic = new[B_mic.size() + 1](B_mic);
        B_mic[B_mic.size() - 1] = 8'h0;
      end
    end

    // Add AAD bit length order reverse
    B_mic = new[B_mic.size() + 8](B_mic);
    {B_mic[B_mic.size()-8],
     B_mic[B_mic.size()-7],
     B_mic[B_mic.size()-6],
     B_mic[B_mic.size()-5],
     B_mic[B_mic.size()-4],
     B_mic[B_mic.size()-3],
     B_mic[B_mic.size()-2],
     B_mic[B_mic.size()-1]} = Adata_in.size()*8;

    // Add message bit length order reverse
    B_mic = new[B_mic.size() + 8](B_mic);
    {B_mic[B_mic.size()-8],
     B_mic[B_mic.size()-7],
     B_mic[B_mic.size()-6],
     B_mic[B_mic.size()-5],
     B_mic[B_mic.size()-4],
     B_mic[B_mic.size()-3],
     B_mic[B_mic.size()-2],
     B_mic[B_mic.size()-1]} = Message_in.size()*8;

    if (debug_en) array_sprint("GCMP_MIC: B_mic:", B_mic, 0);

    // Mic calculation
    aes_obj.gen_Key(Key,1'b1); // setup Key

    // H
    aes_obj.gen_plain_data({8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,
                            8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0},1'b1);
    aes_obj.aes_encrypt();
    foreach(H[j])
      H[j] = aes_obj.enc_data[j];

    if (debug_en) array_sprint("GCMP_MIC: H    :", H, 0);

    // GHASH
    foreach(S[j]) S[j] = 8'h0;

    for(int i=0; i<B_mic.size(); i=i+16)
    begin
      foreach(B_mic[j]) Mic_in[j]=B_mic[i+j];
      if (debug_en) array_sprint("GCMP_MIC: Xi   :", Mic_in, 0);
      foreach(Mic_in[j]) mult_in[j] = B_mic[i+j] ^ S[j];
      if (debug_en) array_sprint("GCMP_MIC: X^Y  :", mult_in, 0);
      multH(mult_in, S);
      if (debug_en) array_sprint("GCMP_MIC: Y    :", S, 0);
    end

    // GCTR
    foreach(Nonce_in[i]) CB[i]=Nonce_in[i];
    CB[12]=8'h00;
    CB[13]=8'h00;
    CB[14]=8'h00;
    CB[15]=8'h01;
    if (debug_en) array_sprint("GCMP_MIC: CB   :", CB, 0);
    aes_obj.gen_plain_data(CB,1'b1);
    aes_obj.aes_encrypt();
    if (debug_en) array_sprint("GCMP_MIC: E(CB):", aes_obj.enc_data, 0);
    foreach(Mic_out[i]) Mic_out[i] = aes_obj.enc_data[i] ^ S[i];

    // Set MIC value
    foreach(MIC[j]) MIC[j] = Mic_out[j];
  endfunction : GCMP_MIC

  //----------------------------------------------------------------------------
  function void GCMP_Enc(
    input bit [7:0] Nonce_in[],
    input bit [7:0] Message_in[],
    input bit       debug_en = 1'b0
  );

    // init the compute data
    enc_data = new[Message_in.size()];

    // Init Counter Block
    foreach(Nonce_in[i]) CB[i]=Nonce_in[i];
    CB[12]=8'h00;
    CB[13]=8'h00;
    CB[14]=8'h00;
    CB[15]=8'h01;

    // encrypt the message
    for(int i=0; i<Message_in.size(); i=i+16)
    begin
      // Increment CB
      {CB[12],CB[13],CB[14],CB[15]} = {CB[12],CB[13],CB[14],CB[15]}+1;

      // setup AES Key
      aes_obj.gen_Key(Key,1);

      // get the new S_i
      aes_obj.gen_plain_data(CB,1'b1);
      aes_obj.aes_encrypt();
      foreach(S_i[j])
        S_i[j] = aes_obj.enc_data[j];

      foreach(S_i[j])
      begin
        if(i+j < Message_in.size())
          enc_data[i+j] = Message_in[i+j] ^ S_i[j];
        else
          break;
      end

      if(debug_en)
      begin
        array_sprint("aes key     : ",aes_obj.Key,0);
        array_sprint("aes data in : ",CB,0);
        array_sprint("aes data out: ",S_i,0);
        array_sprint("msg data in : ",Message_in[i+:16],0);
        array_sprint("enc data out: ",enc_data[i+:16],0);
      end
    end

  endfunction :GCMP_Enc

  //----------------------------------------------------------------------------
  function void GCMP_Dec(
    input bit [7:0] Nonce_in[],
    input bit [7:0] Message_in[],
    input bit       debug_en = 1'b0
  );

    // init the compute data
    dec_data = new[Message_in.size()];

    // Init Counter Block
    foreach(Nonce_in[i]) CB[i]=Nonce_in[i];
    CB[12]=8'h00;
    CB[13]=8'h00;
    CB[14]=8'h00;
    CB[15]=8'h01;

    // decrypt the message
    for(int i=0; i<Message_in.size(); i=i+16)
    begin
      // Increment CB
      {CB[12],CB[13],CB[14],CB[15]} = {CB[12],CB[13],CB[14],CB[15]}+1;

      // setup AES Key
      aes_obj.gen_Key(Key,1);

      // get the new S_i
      aes_obj.gen_plain_data(CB,1'b1);
      aes_obj.aes_encrypt();
      foreach(S_i[j])
        S_i[j] = aes_obj.enc_data[j];

      foreach(S_i[j])
      begin
        if(i+j < Message_in.size())
          dec_data[i+j] = Message_in[i+j] ^ S_i[j];
        else
          break;
      end

      if(debug_en)
      begin
        array_sprint("aes data in : ",CB,0);
        array_sprint("aes data out: ",S_i,0);
        array_sprint("msg data in : ",Message_in[i+:16],0);
        array_sprint("dec data out: ",dec_data[i+:16],0);
      end
    end

  endfunction :GCMP_Dec

  //----------------------------------------------------------------------------
  function void testGCMP();

    // Test against IEEE test vector
    // Test1
    $display("==== IEEE 802.11-2016 GCMP test mpdu #1 ====");
    gen_Key(IEEE_GCMP_KEY_1,1);

    GCMP_Enc(IEEE_GCMP_NONCE_1,IEEE_GCMP_PLAIN_DATA_1,0);
    array_compare("Encrypted Data", enc_data,
                  "Encrypted Ref" , IEEE_GCMP_CIPHER_1);

    GCMP_MIC(IEEE_GCMP_NONCE_1,IEEE_GCMP_CIPHER_1,IEEE_GCMP_AAD_1);
    array_compare("MIC Computed" , MIC,
                  "MIC Reference", IEEE_GCMP_MIC_1);

    GCMP_Dec(IEEE_GCMP_NONCE_1,IEEE_GCMP_CIPHER_1,0);
    array_compare("Decrypted Data", dec_data,
                  "Decrypted Ref" , IEEE_GCMP_PLAIN_DATA_1);

    // Test2
    $display("==== IEEE 802.11-2016 GCMP test mpdu #2 ====");
    gen_PN(IEEE_GCMP_PN_2,1);
    gen_macheader(IEEE_GCMP_MAC_HEADER_2,1);

    ConstructAAD();
    ConstructGCMnonce();
    array_compare("NONCE", GCMnonce,
                  "REF  ", IEEE_GCMP_NONCE_2);

    gen_Key(IEEE_GCMP_KEY_2,1);
    gen_plain_data(IEEE_GCMP_PLAIN_DATA_2,1);

    GCMP_Enc(GCMnonce,plain_data,0);

    array_compare("Encrypted Data", enc_data,
                  "Encrypted Ref" , IEEE_GCMP_CIPHER_2);

    GCMP_MIC(GCMnonce,enc_data,AAD,0);

    array_compare("MIC Computed"  , MIC,
                  "MIC Reference" , IEEE_GCMP_MIC_2);

    GCMP_Dec(GCMnonce,IEEE_GCMP_CIPHER_2,0);

    array_compare("Decrypted Data", dec_data,
                  "Decrypted Ref" , IEEE_GCMP_PLAIN_DATA_2);

    // Test3
    $display("==== IEEE 802.11-2016 GCMP-256 test mpdu #3 =====");
    gen_PN(IEEE_GCMP_PN_3,1);
    gen_macheader(IEEE_GCMP_MAC_HEADER_3,1);

    ConstructAAD();
    array_compare("AAD  ", AAD,
                  "REF  ", IEEE_GCMP_AAD_3);

    ConstructGCMnonce();
    array_compare("NONCE", GCMnonce,
                  "REF  ", IEEE_GCMP_NONCE_3);

    gen_Key(IEEE_GCMP_KEY_3,1);
    gen_plain_data(IEEE_GCMP_PLAIN_DATA_3,1);

    GCMP_Enc(GCMnonce,plain_data,0);

    array_compare("Encrypted Data", enc_data,
                  "Encrypted Ref" , IEEE_GCMP_CIPHER_3);

    GCMP_MIC(GCMnonce,enc_data,AAD,0);

    array_compare("MIC Computed"  , MIC,
                  "MIC Reference" , IEEE_GCMP_MIC_3);

    GCMP_Dec(GCMnonce,IEEE_GCMP_CIPHER_3,0);

    array_compare("Decrypted Data", dec_data,
                  "Decrypted Ref" , IEEE_GCMP_PLAIN_DATA_3);

  endfunction : testGCMP

  //----------------------------------------------------------------------------
  function void array_sprint(
    input string msg = "",
    input [7:0]  array_in[] = {},
    input bit    revert = 1'b0
  );

    string s_out;

    foreach(array_in[i])
    begin
      if((i%128 == 0) && (i > 0))
        $swrite(s_out,"%s\n",s_out);
      if(revert)
        $swrite(s_out,"%02h%s",array_in[i],s_out);
      else
        $swrite(s_out,"%s%02h",s_out,array_in[i]);
    end

    $display("%s%s",msg,s_out);
  endfunction : array_sprint

  //----------------------------------------------------------------------------
  function void array_compare(
    input string msg1  = "",
    input [7:0]  array_in1[] = {},
    input string msg2  = "",
    input [7:0]  array_in2[] = {}
  );

    if(array_in1.size() != array_in2.size())
    begin
      $display("%s size (%0d) differs from %s size (%0d)",
        msg1, array_in1.size(),
        msg2, array_in2.size());
      gcmp_err_cnt = gcmp_err_cnt + 1;
    end
    else
    begin
      foreach(array_in1[i])
      begin
        if(array_in1[i] != array_in2[i])
        begin
          $display("%s[%02h] %02h differs from %s[%02h] %02h",
            msg1,i,array_in1[i],
            msg2,i,array_in2[i]);
          gcmp_err_cnt = gcmp_err_cnt + 1;
        end
      end
    end
  endfunction : array_compare

endclass : gcmp
