//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $RCSmodulefile   :
// $Author          :
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 0.1
// $Date: 22-Dec-2008
// $State: Complete
// $Locker:
// ---------------------------------------------------------------------------
// Dependencies     :
// Description      : TKIP Class For TB
//
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

// IEEE 2007 p.1135
bit   [7:0] IEEE_SA[6]                    = {8'h02,8'h03,8'h04,8'h05,8'h06,8'h07};
bit   [7:0] IEEE_DA[6]                    = {8'h02,8'h03,8'h04,8'h05,8'h06,8'h08};
bit   [7:0] IEEE_KEY[32]                  = {8'h12,8'h34,8'h56,8'h78,8'h90,8'h12,8'h34,8'h56,8'h78,8'h90,8'h12,8'h34,8'h56,8'h78,8'h90,8'h12,
                                             8'h34,8'h56,8'h78,8'h90,8'h12,8'h34,8'h56,8'h78,8'h90,8'h12,8'h34,8'h56,8'h78,8'h90,8'h12,8'h34};

bit  [47:0] IEEE_PN                       = 48'h000000000001;
bit   [7:0] IEEE_IV[8]                    = {8'h00,8'h20,8'h01,8'h20,8'h00,8'h00,8'h00,8'h00};
bit   [7:0] IEEE_Phase1[10]               = {8'hbb,8'h58,8'h07,8'h1f,8'h9e,8'h93,8'hb4,8'h38,8'h25,8'h4b};
bit   [7:0] IEEE_Phase2[16]               = {8'h00,8'h20,8'h01,8'h4c,8'hfe,8'h67,8'hbe,8'hd2,8'h7c,8'h86,8'h7b,8'h1b,8'hf8,8'h02,8'h8b,8'h1c};

bit   [7:0] IEEE_PLAIN_MPDU_MIC[132]      = {8'h08,8'h42,8'h2c,8'h00,8'h02,8'h03,8'h04,8'h05,8'h06,8'h08,8'h02,8'h03,8'h04,8'h05,8'h06,8'h07,
                                             8'h02,8'h03,8'h04,8'h05,8'h06,8'h07,8'hd0,8'h02,8'h00,8'h20,8'h01,8'h20,8'h00,8'h00,8'h00,8'h00,
                                             8'haa,8'haa,8'h03,8'h00,8'h00,8'h00,8'h08,8'h00,8'h45,8'h00,8'h00,8'h54,8'h00,8'h00,8'h40,8'h00,
                                             8'h40,8'h01,8'ha5,8'h55,8'hc0,8'ha8,8'h0a,8'h02,8'hc0,8'ha8,8'h0a,8'h01,8'h08,8'h00,8'h3a,8'hb0,
                                             8'h00,8'h00,8'h00,8'h00,8'hcd,8'h4c,8'h05,8'h00,8'h00,8'h00,8'h00,8'h00,8'h08,8'h09,8'h0a,8'h0b,
                                             8'h0c,8'h0d,8'h0e,8'h0f,8'h10,8'h11,8'h12,8'h13,8'h14,8'h15,8'h16,8'h17,8'h18,8'h19,8'h1a,8'h1b,
                                             8'h1c,8'h1d,8'h1e,8'h1f,8'h20,8'h21,8'h22,8'h23,8'h24,8'h25,8'h26,8'h27,8'h28,8'h29,8'h2a,8'h2b,
                                             8'h2c,8'h2d,8'h2e,8'h2f,8'h30,8'h31,8'h32,8'h33,8'h34,8'h35,8'h36,8'h37,8'h68,8'h81,8'ha3,8'hf3,
                                             8'hd6,8'h48,8'hd0,8'h3c};

bit   [7:0] IEEE_CIPHER_MPDU_MIC_ICV[136] = {8'h08,8'h42,8'h2c,8'h00,8'h02,8'h03,8'h04,8'h05,8'h06,8'h08,8'h02,8'h03,8'h04,8'h05,8'h06,8'h07,
                                             8'h02,8'h03,8'h04,8'h05,8'h06,8'h07,8'hd0,8'h02,8'h00,8'h20,8'h01,8'h20,8'h00,8'h00,8'h00,8'h00,
                                             8'hc0,8'h0e,8'h14,8'hfc,8'he7,8'hcf,8'hab,8'hc7,8'h75,8'h47,8'he6,8'h66,8'he5,8'h7c,8'h0d,8'hac,
                                             8'h70,8'h4a,8'h1e,8'h35,8'h8a,8'h88,8'hc1,8'h1c,8'h8e,8'h2e,8'h28,8'h2e,8'h38,8'h01,8'h02,8'h7a,
                                             8'h46,8'h56,8'h05,8'h5e,8'he9,8'h3e,8'h9c,8'h25,8'h47,8'h02,8'he9,8'h73,8'h58,8'h05,8'hdd,8'hb5,
                                             8'h76,8'h9b,8'ha7,8'h3f,8'h1e,8'hbb,8'h56,8'he8,8'h44,8'hef,8'h91,8'h22,8'h85,8'hd3,8'hdd,8'h6e,
                                             8'h54,8'h1e,8'h82,8'h38,8'h73,8'h55,8'h8a,8'hdb,8'ha0,8'h79,8'h06,8'h8a,8'hbd,8'h7f,8'h7f,8'h50,
                                             8'h95,8'h96,8'h75,8'hac,8'hc4,8'hb4,8'hde,8'h9a,8'ha9,8'h9c,8'h05,8'hf2,8'h89,8'ha7,8'hc5,8'h2f,
                                             8'hee,8'h5b,8'hfc,8'h14,8'hf6,8'hf8,8'he5,8'hf8};

bit   [7:0] IEEE_Authenticator_MICKey[8]  =  {8'h34,8'h56,8'h78,8'h90,8'h12,8'h34,8'h56,8'h78};
bit   [7:0] IEEE_Supplicant_MICKey[8]     =  {8'h90,8'h12,8'h34,8'h56,8'h78,8'h90,8'h12,8'h34};

bit  [15:0] IEEE_TKIP_SBOX[2][256]        = '{'{
                                                16'hC6A5,16'hF884,16'hEE99,16'hF68D,16'hFF0D,16'hD6BD,16'hDEB1,16'h9154,
                                                16'h6050,16'h0203,16'hCEA9,16'h567D,16'hE719,16'hB562,16'h4DE6,16'hEC9A,
                                                16'h8F45,16'h1F9D,16'h8940,16'hFA87,16'hEF15,16'hB2EB,16'h8EC9,16'hFB0B,
                                                16'h41EC,16'hB367,16'h5FFD,16'h45EA,16'h23BF,16'h53F7,16'hE496,16'h9B5B,
                                                16'h75C2,16'hE11C,16'h3DAE,16'h4C6A,16'h6C5A,16'h7E41,16'hF502,16'h834F,
                                                16'h685C,16'h51F4,16'hD134,16'hF908,16'hE293,16'hAB73,16'h6253,16'h2A3F,
                                                16'h080C,16'h9552,16'h4665,16'h9D5E,16'h3028,16'h37A1,16'h0A0F,16'h2FB5,
                                                16'h0E09,16'h2436,16'h1B9B,16'hDF3D,16'hCD26,16'h4E69,16'h7FCD,16'hEA9F,
                                                16'h121B,16'h1D9E,16'h5874,16'h342E,16'h362D,16'hDCB2,16'hB4EE,16'h5BFB,
                                                16'hA4F6,16'h764D,16'hB761,16'h7DCE,16'h527B,16'hDD3E,16'h5E71,16'h1397,
                                                16'hA6F5,16'hB968,16'h0000,16'hC12C,16'h4060,16'hE31F,16'h79C8,16'hB6ED,
                                                16'hD4BE,16'h8D46,16'h67D9,16'h724B,16'h94DE,16'h98D4,16'hB0E8,16'h854A,
                                                16'hBB6B,16'hC52A,16'h4FE5,16'hED16,16'h86C5,16'h9AD7,16'h6655,16'h1194,
                                                16'h8ACF,16'hE910,16'h0406,16'hFE81,16'hA0F0,16'h7844,16'h25BA,16'h4BE3,
                                                16'hA2F3,16'h5DFE,16'h80C0,16'h058A,16'h3FAD,16'h21BC,16'h7048,16'hF104,
                                                16'h63DF,16'h77C1,16'hAF75,16'h4263,16'h2030,16'hE51A,16'hFD0E,16'hBF6D,
                                                16'h814C,16'h1814,16'h2635,16'hC32F,16'hBEE1,16'h35A2,16'h88CC,16'h2E39,
                                                16'h9357,16'h55F2,16'hFC82,16'h7A47,16'hC8AC,16'hBAE7,16'h322B,16'hE695,
                                                16'hC0A0,16'h1998,16'h9ED1,16'hA37F,16'h4466,16'h547E,16'h3BAB,16'h0B83,
                                                16'h8CCA,16'hC729,16'h6BD3,16'h283C,16'hA779,16'hBCE2,16'h161D,16'hAD76,
                                                16'hDB3B,16'h6456,16'h744E,16'h141E,16'h92DB,16'h0C0A,16'h486C,16'hB8E4,
                                                16'h9F5D,16'hBD6E,16'h43EF,16'hC4A6,16'h39A8,16'h31A4,16'hD337,16'hF28B,
                                                16'hD532,16'h8B43,16'h6E59,16'hDAB7,16'h018C,16'hB164,16'h9CD2,16'h49E0,
                                                16'hD8B4,16'hACFA,16'hF307,16'hCF25,16'hCAAF,16'hF48E,16'h47E9,16'h1018,
                                                16'h6FD5,16'hF088,16'h4A6F,16'h5C72,16'h3824,16'h57F1,16'h73C7,16'h9751,
                                                16'hCB23,16'hA17C,16'hE89C,16'h3E21,16'h96DD,16'h61DC,16'h0D86,16'h0F85,
                                                16'hE090,16'h7C42,16'h71C4,16'hCCAA,16'h90D8,16'h0605,16'hF701,16'h1C12,
                                                16'hC2A3,16'h6A5F,16'hAEF9,16'h69D0,16'h1791,16'h9958,16'h3A27,16'h27B9,
                                                16'hD938,16'hEB13,16'h2BB3,16'h2233,16'hD2BB,16'hA970,16'h0789,16'h33A7,
                                                16'h2DB6,16'h3C22,16'h1592,16'hC920,16'h8749,16'hAAFF,16'h5078,16'hA57A,
                                                16'h038F,16'h59F8,16'h0980,16'h1A17,16'h65DA,16'hD731,16'h84C6,16'hD0B8,
                                                16'h82C3,16'h29B0,16'h5A77,16'h1E11,16'h7BCB,16'hA8FC,16'h6DD6,16'h2C3A
                                               },
                                              '{ /* second half of table is byte-reversed version of first! */
                                                16'hA5C6,16'h84F8,16'h99EE,16'h8DF6,16'h0DFF,16'hBDD6,16'hB1DE,16'h5491,
                                                16'h5060,16'h0302,16'hA9CE,16'h7D56,16'h19E7,16'h62B5,16'hE64D,16'h9AEC,
                                                16'h458F,16'h9D1F,16'h4089,16'h87FA,16'h15EF,16'hEBB2,16'hC98E,16'h0BFB,
                                                16'hEC41,16'h67B3,16'hFD5F,16'hEA45,16'hBF23,16'hF753,16'h96E4,16'h5B9B,
                                                16'hC275,16'h1CE1,16'hAE3D,16'h6A4C,16'h5A6C,16'h417E,16'h02F5,16'h4F83,
                                                16'h5C68,16'hF451,16'h34D1,16'h08F9,16'h93E2,16'h73AB,16'h5362,16'h3F2A,
                                                16'h0C08,16'h5295,16'h6546,16'h5E9D,16'h2830,16'hA137,16'h0F0A,16'hB52F,
                                                16'h090E,16'h3624,16'h9B1B,16'h3DDF,16'h26CD,16'h694E,16'hCD7F,16'h9FEA,
                                                16'h1B12,16'h9E1D,16'h7458,16'h2E34,16'h2D36,16'hB2DC,16'hEEB4,16'hFB5B,
                                                16'hF6A4,16'h4D76,16'h61B7,16'hCE7D,16'h7B52,16'h3EDD,16'h715E,16'h9713,
                                                16'hF5A6,16'h68B9,16'h0000,16'h2CC1,16'h6040,16'h1FE3,16'hC879,16'hEDB6,
                                                16'hBED4,16'h468D,16'hD967,16'h4B72,16'hDE94,16'hD498,16'hE8B0,16'h4A85,
                                                16'h6BBB,16'h2AC5,16'hE54F,16'h16ED,16'hC586,16'hD79A,16'h5566,16'h9411,
                                                16'hCF8A,16'h10E9,16'h0604,16'h81FE,16'hF0A0,16'h4478,16'hBA25,16'hE34B,
                                                16'hF3A2,16'hFE5D,16'hC080,16'h8A05,16'hAD3F,16'hBC21,16'h4870,16'h04F1,
                                                16'hDF63,16'hC177,16'h75AF,16'h6342,16'h3020,16'h1AE5,16'h0EFD,16'h6DBF,
                                                16'h4C81,16'h1418,16'h3526,16'h2FC3,16'hE1BE,16'hA235,16'hCC88,16'h392E,
                                                16'h5793,16'hF255,16'h82FC,16'h477A,16'hACC8,16'hE7BA,16'h2B32,16'h95E6,
                                                16'hA0C0,16'h9819,16'hD19E,16'h7FA3,16'h6644,16'h7E54,16'hAB3B,16'h830B,
                                                16'hCA8C,16'h29C7,16'hD36B,16'h3C28,16'h79A7,16'hE2BC,16'h1D16,16'h76AD,
                                                16'h3BDB,16'h5664,16'h4E74,16'h1E14,16'hDB92,16'h0A0C,16'h6C48,16'hE4B8,
                                                16'h5D9F,16'h6EBD,16'hEF43,16'hA6C4,16'hA839,16'hA431,16'h37D3,16'h8BF2,
                                                16'h32D5,16'h438B,16'h596E,16'hB7DA,16'h8C01,16'h64B1,16'hD29C,16'hE049,
                                                16'hB4D8,16'hFAAC,16'h07F3,16'h25CF,16'hAFCA,16'h8EF4,16'hE947,16'h1810,
                                                16'hD56F,16'h88F0,16'h6F4A,16'h725C,16'h2438,16'hF157,16'hC773,16'h5197,
                                                16'h23CB,16'h7CA1,16'h9CE8,16'h213E,16'hDD96,16'hDC61,16'h860D,16'h850F,
                                                16'h90E0,16'h427C,16'hC471,16'hAACC,16'hD890,16'h0506,16'h01F7,16'h121C,
                                                16'hA3C2,16'h5F6A,16'hF9AE,16'hD069,16'h9117,16'h5899,16'h273A,16'hB927,
                                                16'h38D9,16'h13EB,16'hB32B,16'h3322,16'hBBD2,16'h70A9,16'h8907,16'hA733,
                                                16'hB62D,16'h223C,16'h9215,16'h20C9,16'h4987,16'hFFAA,16'h7850,16'h7AA5,
                                                16'h8F03,16'hF859,16'h8009,16'h171A,16'hDA65,16'h31D7,16'hC684,16'hB8D0,
                                                16'hC382,16'hB029,16'h775A,16'h111E,16'hCB7B,16'hFCA8,16'hD66D,16'h3A2C
                                               }};

// Test vector for Phase 1 and Phase 2 (IEEE 2007 p.1118)

bit  [7:0] IEEE_TK1[16]     = '{8'h00,8'h01,8'h02,8'h03,8'h04,8'h05,8'h06,8'h07,8'h08,8'h09,8'h0A,8'h0B,8'h0C,8'h0D,8'h0E,8'h0F};
bit  [7:0] IEEE_TA1[6]      = '{8'h10,8'h22,8'h33,8'h44,8'h55,8'h66};
bit  [7:0] IEEE_PN1[6]      = '{8'h00,8'h00,8'h00,8'h00,8'h00,8'h00};
bit [15:0] IEEE_P1K1[5]     = '{16'h3DD2,16'h016E,16'h76F4,16'h8697,16'hB2E8};
bit  [7:0] IEEE_RC4KEY1[16] = '{8'h00,8'h20,8'h00,8'h33,8'hEA,8'h8D,8'h2F,8'h60,8'hCA,8'h6D,8'h13,8'h74,8'h23,8'h4A,8'h66,8'h0B};

bit  [7:0] IEEE_PN2[6]      = '{8'h01,8'h00,8'h00,8'h00,8'h00,8'h00};
bit [15:0] IEEE_P1K2[5]     = '{16'h3DD2,16'h016E,16'h76F4,16'h8697,16'hB2E8};
bit  [7:0] IEEE_RC4KEY2[16] = '{8'h00,8'h20,8'h01,8'h90,8'hFF,8'hDC,8'h31,8'h43,8'h89,8'hA9,8'hD9,8'hD0,8'h74,8'hFD,8'h20,8'hAA};

bit  [7:0] IEEE_TK3[16]     = '{8'h63,8'h89,8'h3B,8'h25,8'h08,8'h40,8'hB8,8'hAE,8'h0B,8'hD0,8'hFA,8'h7E,8'h61,8'hD2,8'h78,8'h3E};
bit  [7:0] IEEE_TA3[6]      = '{8'h64,8'hF2,8'hEA,8'hED,8'hDC,8'h25};
bit  [7:0] IEEE_PN3[6]      = '{8'hFF,8'hFF,8'h43,8'hFD,8'hDC,8'h20};
bit [15:0] IEEE_P1K3[5]     = '{16'h7C67,16'h49D7,16'h9724,16'hB5E9,16'hB4F1};
bit  [7:0] IEEE_RC4KEY3[16] = '{8'hFF,8'h7F,8'hFF,8'h93,8'h81,8'h0F,8'hC6,8'hE5,8'h8F,8'h5D,8'hD3,8'h26,8'h25,8'h15,8'h44,8'hCE};

bit  [7:0] IEEE_PN4[6]      = '{8'h00,8'h00,8'h44,8'hFD,8'hDC,8'h20};
bit [15:0] IEEE_P1K4[5]     = '{16'h5A5D,16'h73A8,16'hA859,16'h2EC1 ,16'hDC8B};
bit  [7:0] IEEE_RC4KEY4[16] = '{8'h00,8'h20,8'h00,8'h49,8'h8C,8'hA4,8'h71,8'hFC,8'hFB,8'hFA,8'hA1,8'h6E,8'h36,8'h10,8'hF0,8'h05};

bit  [7:0] IEEE_TK5[16]     = '{8'h98,8'h3A,8'h16,8'hEF,8'h4F,8'hAC,8'hB3,8'h51,8'hAA,8'h9E,8'hCC,8'h27,8'h1D,8'h73,8'h09,8'hE2};
bit  [7:0] IEEE_TA5[6]      = '{8'h50,8'h9C,8'h4B,8'h17,8'h27,8'hD9};
bit  [7:0] IEEE_PN5[6]      = '{8'h8C,8'h05,8'hFC,8'h10,8'hA4,8'hF0};
bit [15:0] IEEE_P1K5[5]     = '{16'hF2DF,16'hEBB1,16'h88D3,16'h5923,16'hA07C};
bit  [7:0] IEEE_RC4KEY5[16] = '{8'h05,8'h25,8'h8C,8'hF4,8'hD8,8'h51,8'h52,8'hF4,8'hD9,8'hAF,8'h1A,8'h64,8'hF1,8'hD0,8'h70,8'h21};

bit  [7:0] IEEE_PN6[6]      = '{8'h8D,8'h05,8'hFC,8'h10,8'hA4,8'hF0};
bit [15:0] IEEE_P1K6[5]     = '{16'hF2DF,16'hEBB1,16'h88D3,16'h5923,16'hA07C};
bit  [7:0] IEEE_RC4KEY6[16] = '{8'h05,8'h25,8'h8D,8'h09,8'hF8,8'h15,8'h43,8'hB7,8'h6A,8'h59,8'h6F,8'hC2,8'hC6,8'h73,8'h8B,8'h30};


bit  [7:0] IEEE_TK7[16]     = '{8'hC8,8'hAD,8'hC1,8'h6A,8'h8B,8'h4D,8'hDA,8'h3B,8'h4D,8'hD5,8'hB6,8'h54,8'h38,8'h35,8'h9B,8'h05};
bit  [7:0] IEEE_TA7[6]      = '{8'h94,8'h5E,8'h24,8'h4E,8'h4D,8'h6E};
bit  [7:0] IEEE_PN7[6]      = '{8'hF8,8'h30,8'hB7,8'h73,8'h15,8'h8B};
bit [15:0] IEEE_P1K7[5]     = '{16'hEFF1,16'h3F38,16'hA364,16'h60A9,16'h76F3};
bit  [7:0] IEEE_RC4KEY7[16] = '{8'h30,8'h30,8'hF8,8'h65,8'h0D,8'hA0,8'h73,8'hEA,8'h61,8'h4E,8'hA8,8'hF4,8'h74,8'hEE,8'h03,8'h19};

bit  [7:0] IEEE_PN8[6]      = '{8'hF9,8'h30,8'hB7,8'h73,8'h15,8'h8B};
bit [15:0] IEEE_P1K8[5]     = '{16'hEFF1,16'h3F38,16'hA364,16'h60A9,16'h76F3};
bit  [7:0] IEEE_RC4KEY8[16] = '{8'h30,8'h30,8'hF9,8'h31,8'h55,8'hCE,8'h29,8'h34,8'h37,8'hCC,8'h76,8'h71,8'h27,8'h16,8'hAB,8'h8F};

class tkip;

  parameter   PHASE1_LOOP_COUNT = 8;

  wep         wep_obj = new();

  // TKIP PDU_MIC
  bit   [7:0] PDU_MIC[];
  bit   [7:0] PDU_MIC_encrypted[];
  bit   [7:0] PDU_MIC_decrypted[];

  bit   [7:0] WEPSeed1;
  bit   [7:0] TSC[6];

  bit   [7:0] IV[8];
  bit   [7:0] TK[16];
  bit   [7:0] TA[6];

  bit  [15:0] TTAK[5];
  bit  [15:0] PPK[6];

  bit   [7:0] WEPSeed[16];

  bit   [1:0] KeyID = 2'b0;
  bit         ExtIV = 1'b1;
  bit   [4:0] Rsvd  = 5'b00000;


  bit  [31:0] ICV;
  int         tkip_err_cnt = 0;

  function new();
    wep_obj = new();
    PDU_MIC.delete();
    PDU_MIC_encrypted.delete();
    PDU_MIC_decrypted.delete();
  endfunction : new

  function void gen_TSC(input bit [7:0] TSC_in[6] = {8'h0,8'h0,8'h0,8'h0,8'h0,8'h0}, input bit valid = 1'b0);
    foreach(TSC[i])
    begin
      TSC[i] = valid ? TSC_in[i] : $urandom_range(255,0);
    end
    WEPSeed1 = (TSC[1] | 8'h20) & 8'h7f;
  endfunction : gen_TSC

  function void gen_KeyID(input bit [1:0] KeyID_in = 0, input bit valid = 0);
    KeyID = valid ? KeyID_in : $urandom_range(3,0);
  endfunction : gen_KeyID

  function void gen_ExtIV(input bit ExtIV_in = 0, input bit valid = 0);
    KeyID = valid ? ExtIV_in : 1'b1;
  endfunction : gen_ExtIV

  function void gen_PDU_MIC(input bit [7:0] PDU_MIC_in[] = {}, input bit valid = 1'b0);
    int PDU_MIC_length = $urandom_range(1024,1);
    if(valid && (PDU_MIC_in.size() != 0))
    begin
      PDU_MIC = new[PDU_MIC_in.size()](PDU_MIC_in);
    end
    else
    begin
      PDU_MIC = new[PDU_MIC_length];
      foreach(PDU_MIC[i])
        PDU_MIC[i] = $urandom_range(255,0);
    end
  endfunction : gen_PDU_MIC

  function void gen_IV(input bit [7:0] IV_in[8] = {8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0}, input bit valid = 1'b0);
    if(valid)
    begin
      IV = IV_in;
    end
    else
    begin
      IV[0] = TSC[0];
      IV[1] = WEPSeed1;
      IV[2] = TSC[1];
      IV[3] = (TSC[1] | 8'h20) & 8'h7f;
      IV[4] = TSC[2];
      IV[5] = TSC[3];
      IV[6] = TSC[4];
      IV[7] = TSC[5];
    end
  endfunction : gen_IV

  function void gen_TK(input bit [7:0] TK_in[16] = {8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0,8'h0}, input bit valid = 1'b0);
    foreach(TK[i])
    begin
      TK[i] = valid ? TK_in[i] : $urandom_range(255,0);
    end
  endfunction : gen_TK

  function void gen_TA(input bit [7:0] TA_in[6] = {8'h0,8'h0,8'h0,8'h0,8'h0,8'h0}, input bit valid = 1'b0);
    foreach(TA[i])
    begin
      TA[i] = valid ? TA_in[i] : $urandom_range(255,0);
    end
  endfunction : gen_TA

  function bit [15:0] TKIP_Mk16(bit [7:0] X, bit [7:0] Y);
    return ({X,Y}); // (256*X)+Y
  endfunction : TKIP_Mk16

  function bit [7:0] Lo8(bit [15:0] X);
    return X[7:0];
  endfunction : Lo8

  function bit [7:0] Hi8(bit [15:0] X);
    return X[15:8];
  endfunction : Hi8

  function bit [15:0] S_out(bit [15:0] v16);
    return ((IEEE_TKIP_SBOX[0][Lo8(v16)]) ^ (IEEE_TKIP_SBOX[1][Hi8(v16)]));
  endfunction : S_out

  function bit [15:0] RotR1(bit [15:0] v16);
    return ({v16[0],v16[15:1]});
  endfunction : RotR1

  function void TKIP_Phase_1();
    // STEP 1
    TTAK[0] = TKIP_Mk16(TSC[3],TSC[2]);
    TTAK[1] = TKIP_Mk16(TSC[5],TSC[4]);
    TTAK[2] = TKIP_Mk16( TA[1], TA[0]);
    TTAK[3] = TKIP_Mk16( TA[3], TA[2]);
    TTAK[4] = TKIP_Mk16( TA[5], TA[4]);

    // STEP 2
    for(int i=0, int j=0; i<PHASE1_LOOP_COUNT; i=i+1)
    begin
      j       = (i&1)<<1;

      TTAK[0] = TTAK[0] + S_out(TTAK[4] ^ TKIP_Mk16( TK[1 +j],  TK[0 +j]));
      TTAK[1] = TTAK[1] + S_out(TTAK[0] ^ TKIP_Mk16( TK[5 +j],  TK[4 +j]));
      TTAK[2] = TTAK[2] + S_out(TTAK[1] ^ TKIP_Mk16( TK[9 +j],  TK[8 +j]));
      TTAK[3] = TTAK[3] + S_out(TTAK[2] ^ TKIP_Mk16( TK[13+j],  TK[12+j]));
      TTAK[4] = TTAK[4] + S_out(TTAK[3] ^ TKIP_Mk16( TK[1 +j],  TK[0 +j])) + i;

    end
  endfunction : TKIP_Phase_1

  function void TKIP_Phase_2();
    // STEP 1
    PPK[0] = TTAK[0];
    PPK[1] = TTAK[1];
    PPK[2] = TTAK[2];
    PPK[3] = TTAK[3];
    PPK[4] = TTAK[4];
    PPK[5] = TTAK[4] + TKIP_Mk16(TSC[1], TSC[0]);

    // STEP 2
    PPK[0] = PPK[0] + S_out(PPK[5] ^ TKIP_Mk16( TK[1], TK[0]));
    PPK[1] = PPK[1] + S_out(PPK[0] ^ TKIP_Mk16( TK[3], TK[2]));
    PPK[2] = PPK[2] + S_out(PPK[1] ^ TKIP_Mk16( TK[5], TK[4]));
    PPK[3] = PPK[3] + S_out(PPK[2] ^ TKIP_Mk16( TK[7], TK[6]));
    PPK[4] = PPK[4] + S_out(PPK[3] ^ TKIP_Mk16( TK[9], TK[8]));
    PPK[5] = PPK[5] + S_out(PPK[4] ^ TKIP_Mk16(TK[11],TK[10]));

    PPK[0] = PPK[0] + RotR1(PPK[5] ^ TKIP_Mk16(TK[13],TK[12]));
    PPK[1] = PPK[1] + RotR1(PPK[0] ^ TKIP_Mk16(TK[15],TK[14]));
    PPK[2] = PPK[2] + RotR1(PPK[1]);
    PPK[3] = PPK[3] + RotR1(PPK[2]);
    PPK[4] = PPK[4] + RotR1(PPK[3]);
    PPK[5] = PPK[5] + RotR1(PPK[4]);

    // STEP 3
    WEPSeed[0] = TSC[1];
    WEPSeed[1] = (TSC[1] | 8'h20) & 8'h7f;;
    WEPSeed[2] = TSC[0];
    WEPSeed[3] = Lo8((PPK[5] ^ TKIP_Mk16(TK[1],TK[0])) >> 1);

    for(int i=0; i<6; i=i+1)
    begin
      WEPSeed[4+(2*i)] = Lo8(PPK[i]);
      WEPSeed[5+(2*i)] = Hi8(PPK[i]);
    end
  endfunction : TKIP_Phase_2

  function void key_scheduling();
    TKIP_Phase_1();
    TKIP_Phase_2();
  endfunction : key_scheduling

  function void TKIP_Encrypt();
    wep_obj.Key        = new[$size(WEPSeed)](WEPSeed);
    wep_obj.plain_data = new[PDU_MIC.size()](PDU_MIC);
    wep_obj.crc32(wep_obj.plain_data,ICV);

    for(int i=0; i<4; i=i+1)
    begin
      wep_obj.plain_data =new[wep_obj.plain_data.size()+1](wep_obj.plain_data);
      wep_obj.plain_data[wep_obj.plain_data.size()-1] = ICV[(4-i-1)*8+:8];
    end

    wep_obj.encrypt();
    PDU_MIC_encrypted  = new[wep_obj.enc_data.size()](wep_obj.enc_data);
  endfunction : TKIP_Encrypt

  function void TKIP_Decrypt();
    wep_obj.enc_data   = new[PDU_MIC_encrypted.size()](PDU_MIC_encrypted);
    wep_obj.Key        = new[$size(WEPSeed)](WEPSeed);
    wep_obj.decrypt();
    PDU_MIC_decrypted  = new[wep_obj.dec_data.size()](wep_obj.dec_data);
  endfunction : TKIP_Decrypt

  function void testIEEETKIP_KeyGen();
    // reset error counter
    tkip_err_cnt = 0;

    // Set the IEEE PN
    foreach(TSC[i])
    begin
      TSC[i] = IEEE_PN1[i];
    end

    foreach(TK[i])
    begin
      TK[i] = IEEE_TK1[i];
    end

    // Set TA
    foreach(TA[i])
    begin
      TA[i] = IEEE_TA1[i];
    end

    // key scheduling
    key_scheduling();

    foreach(TTAK[i])
    begin
      if(TTAK[i] != IEEE_P1K1[i])
      begin
        $display(" tkip phase 1 error: TTAK[%02h] (%04h) differs from IEEE_P1K1 %04h",i,TTAK[i],IEEE_P1K1[i]);
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end

    foreach(WEPSeed[i])
    begin
      if(WEPSeed[i] != IEEE_RC4KEY1[i])
      begin
        $display(" tkip phase 2 error: WEPSeed[%02h] (%02h) differs from IEEE_RC4KEY1 %02h",i,WEPSeed[i],IEEE_RC4KEY1[i]);
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end

    // Set the IEEE PN
    foreach(TSC[i])
    begin
      TSC[i] = IEEE_PN2[i];
    end

    // key scheduling
    key_scheduling();

    foreach(TTAK[i])
    begin
      if(TTAK[i] != IEEE_P1K2[i])
      begin
        $display(" tkip phase 1 error: TTAK[%02h] (%04h) differs from IEEE_P1K2 %04h",i,TTAK[i],IEEE_P1K2[i]);
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end

    foreach(WEPSeed[i])
    begin
      if(WEPSeed[i] != IEEE_RC4KEY2[i])
      begin
        $display(" tkip phase 2 error: WEPSeed[%02h] (%02h) differs from IEEE_RC4KEY2 %02h",i,WEPSeed[i],IEEE_RC4KEY2[i]);
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end

    // Set the IEEE PN
    foreach(TSC[i])
    begin
      TSC[i] = IEEE_PN3[i];
    end

    foreach(TK[i])
    begin
      TK[i] = IEEE_TK3[i];
    end

    // Set TA
    foreach(TA[i])
    begin
      TA[i] = IEEE_TA3[i];
    end

    // key scheduling
    key_scheduling();

    foreach(TTAK[i])
    begin
      if(TTAK[i] != IEEE_P1K3[i])
      begin
        $display(" tkip phase 1 error: TTAK[%02h] (%04h) differs from IEEE_P1K3 %04h",i,TTAK[i],IEEE_P1K3[i]);
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end

    foreach(WEPSeed[i])
    begin
      if(WEPSeed[i] != IEEE_RC4KEY3[i])
      begin
        $display(" tkip phase 2 error: WEPSeed[%02h] (%02h) differs from IEEE_RC4KEY3 %02h",i,WEPSeed[i],IEEE_RC4KEY3[i]);
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end

    // Set the IEEE PN
    foreach(TSC[i])
    begin
      TSC[i] = IEEE_PN4[i];
    end

    // key scheduling
    key_scheduling();

    foreach(TTAK[i])
    begin
      if(TTAK[i] != IEEE_P1K4[i])
      begin
        $display(" tkip phase 1 error: TTAK[%02h] (%04h) differs from IEEE_P1K4 %04h",i,TTAK[i],IEEE_P1K4[i]);
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end

    foreach(WEPSeed[i])
    begin
      if(WEPSeed[i] != IEEE_RC4KEY4[i])
      begin
        $display(" tkip phase 2 error: WEPSeed[%02h] (%02h) differs from IEEE_RC4KEY4 %02h",i,WEPSeed[i],IEEE_RC4KEY4[i]);
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end

    // Set the IEEE PN
    foreach(TSC[i])
    begin
      TSC[i] = IEEE_PN5[i];
    end

    foreach(TK[i])
    begin
      TK[i] = IEEE_TK5[i];
    end

    // Set TA
    foreach(TA[i])
    begin
      TA[i] = IEEE_TA5[i];
    end

    // key scheduling
    key_scheduling();

    foreach(TTAK[i])
    begin
      if(TTAK[i] != IEEE_P1K5[i])
      begin
        $display(" tkip phase 1 error: TTAK[%02h] (%04h) differs from IEEE_P1K5 %04h",i,TTAK[i],IEEE_P1K5[i]);
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end

    foreach(WEPSeed[i])
    begin
      if(WEPSeed[i] != IEEE_RC4KEY5[i])
      begin
        $display(" tkip phase 2 error: WEPSeed[%02h] (%02h) differs from IEEE_RC4KEY5 %02h",i,WEPSeed[i],IEEE_RC4KEY5[i]);
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end

    // Set the IEEE PN
    foreach(TSC[i])
    begin
      TSC[i] = IEEE_PN6[i];
    end

    // key scheduling
    key_scheduling();

    foreach(TTAK[i])
    begin
      if(TTAK[i] != IEEE_P1K6[i])
      begin
        $display(" tkip phase 1 error: TTAK[%02h] (%04h) differs from IEEE_P1K6 %04h",i,TTAK[i],IEEE_P1K6[i]);
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end

    foreach(WEPSeed[i])
    begin
      if(WEPSeed[i] != IEEE_RC4KEY6[i])
      begin
        $display(" tkip phase 2 error: WEPSeed[%02h] (%02h) differs from IEEE_RC4KEY6 %02h",i,WEPSeed[i],IEEE_RC4KEY6[i]);
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end

    // Set the IEEE PN
    foreach(TSC[i])
    begin
      TSC[i] = IEEE_PN7[i];
    end

    foreach(TK[i])
    begin
      TK[i] = IEEE_TK7[i];
    end

    // Set TA
    foreach(TA[i])
    begin
      TA[i] = IEEE_TA7[i];
    end

    // key scheduling
    key_scheduling();

    foreach(TTAK[i])
    begin
      if(TTAK[i] != IEEE_P1K7[i])
      begin
        $display(" tkip phase 1 error: TTAK[%02h] (%04h) differs from IEEE_P1K7 %04h",i,TTAK[i],IEEE_P1K7[i]);
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end

    foreach(WEPSeed[i])
    begin
      if(WEPSeed[i] != IEEE_RC4KEY7[i])
      begin
        $display(" tkip phase 2 error: WEPSeed[%02h] (%02h) differs from IEEE_RC4KEY5 %02h",i,WEPSeed[i],IEEE_RC4KEY7[i]);
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end

    // Set the IEEE PN
    foreach(TSC[i])
    begin
      TSC[i] = IEEE_PN8[i];
    end

    // key scheduling
    key_scheduling();

    foreach(TTAK[i])
    begin
      if(TTAK[i] != IEEE_P1K8[i])
      begin
        $display(" tkip phase 1 error: TTAK[%02h] (%04h) differs from IEEE_P1K8 %04h",i,TTAK[i],IEEE_P1K8[i]);
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end

    foreach(WEPSeed[i])
    begin
      if(WEPSeed[i] != IEEE_RC4KEY8[i])
      begin
        $display(" tkip phase 2 error: WEPSeed[%02h] (%02h) differs from IEEE_RC4KEY6 %02h",i,WEPSeed[i],IEEE_RC4KEY8[i]);
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end
  endfunction : testIEEETKIP_KeyGen

  function void testIEEETKIP();
    // reset error counter
    tkip_err_cnt = 0;

    // Test Key Phase 1 & 2 first
    testIEEETKIP_KeyGen();
    if(tkip_err_cnt != 0)
      $display(" testIEEETKIP_KeyGen FAILED");

    // Set the IEEE PN
    foreach(TSC[i])
    begin
      TSC[i] = IEEE_PN[i*8 +: 8];
    end

    // Set TK
    foreach(TK[i])
    begin
      TK[i] = IEEE_KEY[i];
    end

    // Set TA
    foreach(TA[i])
    begin
      TA[i] = IEEE_SA[i];
    end

    // key scheduling
    key_scheduling();

    foreach(TTAK[i])
    begin
      if(TTAK[i] != {IEEE_Phase1[i*2+1],IEEE_Phase1[i*2]})
      begin
        $display(" tkip phase 1 error: TTAK[%02h] (%04h) differs from IEEE_Phase1 %04h",i,TTAK[i],{IEEE_Phase1[i+1],IEEE_Phase1[i]});
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end

    foreach(WEPSeed[i])
    begin
      if(WEPSeed[i] != IEEE_Phase2[i])
      begin
        $display(" tkip phase 2 error: WEPSeed[%02h] (%02h) differs from IEEE_Phase2 %02h",i,WEPSeed[i],IEEE_Phase2[i]);
        tkip_err_cnt = tkip_err_cnt + 1;
      end
    end

    // Set PDU MIC IEEE (remove the mpdu header and the two ICV
    PDU_MIC = new[$size(IEEE_PLAIN_MPDU_MIC)-32];

    for(int i=32; i<$size(IEEE_PLAIN_MPDU_MIC); i=i+1)
      PDU_MIC[i-32] = IEEE_PLAIN_MPDU_MIC[i];

    // Encrypt
    TKIP_Encrypt();

    if(PDU_MIC_encrypted.size() != ($size(IEEE_CIPHER_MPDU_MIC_ICV)-32))
    begin
      $display(" tkip encrypt error: PDU_MIC_encrypted.size() %02h differs from $size(IEEE_CIPHER_MPDU_MIC_ICV)-32  %02h",PDU_MIC_encrypted.size(),$size(IEEE_CIPHER_MPDU_MIC_ICV)-32);
      tkip_err_cnt = tkip_err_cnt + 1;
    end
    else
    begin
      foreach(PDU_MIC_encrypted[i])
      begin
        if(PDU_MIC_encrypted[i] != IEEE_CIPHER_MPDU_MIC_ICV[i+32])
        begin
          $display(" tkip encrypt error: PDU_MIC_encrypted[%02h] (%02h) differs from IEEE_CIPHER_MPDU_MIC_ICV[%02h] %02h",i,PDU_MIC_encrypted[i],i+32,IEEE_CIPHER_MPDU_MIC_ICV[i+32]);
          tkip_err_cnt = tkip_err_cnt + 1;
        end
      end
    end

    // Decrypt
    TKIP_Decrypt();

    if(PDU_MIC_decrypted.size() != ($size(IEEE_PLAIN_MPDU_MIC)+4-32))
    begin
      $display(" tkip decrypt error: PDU_MIC_decrypted.size() %02h differs from ($size(IEEE_PLAIN_MPDU_MIC)+4+32) %02h",PDU_MIC_decrypted.size(),($size(IEEE_PLAIN_MPDU_MIC)+4+32));
      tkip_err_cnt = tkip_err_cnt + 1;
    end
    else
    begin
      foreach(PDU_MIC_decrypted[i])
      begin
        if(i<PDU_MIC_decrypted.size()-4)
        begin
          if(PDU_MIC_decrypted[i] != IEEE_PLAIN_MPDU_MIC[i+32])
          begin
            $display(" tkip encrypt error: PDU_MIC_decrypted[%02h] (%02h) differs from IEEE_PLAIN_MPDU_MIC[%02h] %02h",i,PDU_MIC_decrypted[i],i+32,IEEE_PLAIN_MPDU_MIC[i+32]);
            tkip_err_cnt = tkip_err_cnt + 1;
          end
        end
        else
        begin
          if(PDU_MIC_decrypted[i] != ICV[((PDU_MIC_decrypted.size()-i-1))*8 +: 8])
          begin
            $display(" tkip encrypt error: PDU_MIC_decrypted[%02h] (%02h) differs from ICV[(4-(PDU_MIC_decrypted.size()-i-1))*8 +: 8] %02h",i,PDU_MIC_decrypted[i],ICV[(4-(PDU_MIC_decrypted.size()-i-1))*8 +: 8]);
            tkip_err_cnt = tkip_err_cnt + 1;
          end
        end
      end
    end
  endfunction : testIEEETKIP
endclass : tkip
